   L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |             FILEDATES             %%   \ @  *                %% |         filedates.c  c2004        %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *>  *  Copyright (C) 2003,2004 Lyle W. West, All Rights Reserved.J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *H  *  FILEDATES is an application which is both a subset of DIR/FULL and aH  *  superset DIR/DATE=ALL. Given a parameter being a filespec, FILEDATESL  *  will display the filename, creation date and revision date. Additionaly,J  *  qualifiers are available to display expiration, backup, effective, and  *  recording dates as desired.   *E  *  FILEDATES was created as a helper tool for CHFDAT, CHFNAM, et al.   *F  *  Online help is available after the foreign symbol is defined; From  *  DCL simply enter:   *  *      FILEDATES /HELP   *  *  Usage Examples:   *#  *    $ filedates FILEDATES_CLD.OBJ   *P  *     Target: DISK$ASUSER:[USR4.SOURCE.TOOLS.LOCAL.FILEDATES]FILEDATES_CLD.OBJ;,  *       Creation Date: 15-MAR-2002 02:16:040  *       Revision Date: 15-MAR-2002 02:16:04 (1)  *  *  -- or --  *  *    $ filedates *.obj /backup   *I  *     Target: DISK$ASUSER:[USR4.SOURCE.TOOLS.LOCAL.FILEDATES.WORK]*.OBJ;   *       FILEDATES.OBJ;5-  *        Creation Date: 15-MAR-2002 23:45:30 1  *        Revision Date: 15-MAR-2002 23:45:39 (1) -  *          Backup Date: 30-MAR-2002 02:17:33   *       FILEDATES_CLD.OBJ;4-  *        Creation Date: 20-FEB-2002 20:02:20 1  *        Revision Date: 20-FEB-2002 20:02:20 (1) -  *          Backup Date: 30-MAR-2002 02:17:33   *       SUPPORT.OBJ;2-  *        Creation Date: 15-MAR-2002 13:20:27 1  *        Revision Date: 15-MAR-2002 13:20:34 (1) -  *          Backup Date: 30-MAR-2002 02:17:33   *F  *  An undocumented option exists to also display date/time stamps forC  *  ISO9660 info, currently default for dcl 'dir/full'. This can be :  *  enabled by defining a process logical name as follows:  *"  *      $ DEFINE SHOW_ISO9660 TRUE  *K  *  The two ISO9660 date fields will only be displayed using /ALL qualifier   *@  *  This application must be relinked if the current VMS version+  *  is upgraded to version 7.3-2 or higher.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */     #define VERSION "V1.2-5"  #pragma module FILEDATES VERSION    #include <stdio.h> #include <atrdef.h>  #include <ctype.h>1 #include <clidef.h>         /* Cli definitions */  #include <climsgdef.h> #include <descrip.h> #include <dvidef.h>  #include <fibdef.h>  #include <iodef.h> #include <lib$routines.h>  #include <lnmdef.h>  #include <psldef.h>  #include <rms.h> #include <ssdef.h> #include <starlet.h> #include <stdlib.h>  #include <string.h>  #include <unistd.h>       9     /* Declare the rms structures used in this example */    L struct FAB Fab;                 /* Declare the parse-search FAB Structure */L struct NAM Nam;                 /* Declare the parse-search NAM Structure */ struct fibdef Fib;   H int RmsStat;                    /* status value returned by RMS calls */H int status;                     /* status value returned by SYS calls */   ? int BinTime[2];                 /* multi purpose time buffer */    D int BckBin[2];                  /* quadword value for Backup date */D int CreBin[2];                  /* quadword value for Create date */D int ExpBin[2];                  /* quadword value for Expire date */F int RevBin[2];                  /* quadword value for Revision date */      ? short Channel;                  /* I/O channel to input file */ I short DateLen;                  /* length value returned by sys$asctim */ C short ElipsisFlg;               /* input filespec contains '...' */ C short Iosb[4];                  /* I/O status block for SYS$QIOW */ E short OutFlg;                   /* if TRUE, output logging enabled */ N short QualFlg;                  /* bit mask reflecting selected time stamps */A short RevNum;                   /* target file revision number */ N short SemiFlg;                  /* sys$parse adds semicolon we may not want */    char AscDate[24];  char CmdVerb[32]; 8 char DevName[32];               /* target disk device */K char FileInfo[36];              /* this provides file rev number via qio */  char FileName[132];  char OutFileName[80]; 
 char *DviPtr;     $DESCRIPTOR(DscDate, AscDate);@ $DESCRIPTOR(DscDev, DevName);       /* device name descriptor */    #define BACKUP 1 #define CREATE 2 #define EXPIRE 4 #define REVISE 8 #define ALL 16 #define ISO9660 32    #define SS$_NORMAL 1    globalvalue CTL$AG_CLIDATA;  globalvalue PRC_L_RECALLPTR; globalvalue PPD$L_PRC; globalvalue PRC_S_COMMANDS;     globalvalue FILEDATES_CLD;   J $DESCRIPTOR(DscFib, (char *)&Fib); /* NOTE: this is not your normal dsc */   0 struct {short size, type; int *address;} Atr[6];7 struct {short len, code; int *buf, *retlen;} DviItm[2];     extern int GetQualifiers();  extern void ShowVers();  extern void ShowHelp();     FILE *outfp;   
 int main() {      int  CliStat;      int  devchar;         char CliStr[80];J     char CmdLine[132];              /* buffer reflecting input cmd line */     char EnableLnm[32];      char LineBuf[132];     char targetfile[80];L     char esa[NAM$C_MAXRSS];         /* extended filespec (from SYS$PARSE) */M     char rsa[NAM$C_MAXRSS];         /* resultant filespec (from SYS$SEARCH */      char *miscptr = 0;     char *ptr;        short BufLen;      short CmdLen;    J     $DESCRIPTOR(DscCli, CliStr);       /* cli param or qualifier string */!     $DESCRIPTOR(DscCmd, CmdLine); "     $DESCRIPTOR(DscDate, AscDate);"     $DESCRIPTOR(DscFnm, FileName);"     $DESCRIPTOR(DscLbuf, LineBuf);%     $DESCRIPTOR(DscOut, OutFileName); "     $DESCRIPTOR(DscVerb, CmdVerb);   %         /* init the RMS structures */         Fab = cc$rms_fab;      Nam = cc$rms_nam;    4         /* ititialize the itemlist for SYS$GETJPI */        DviItm[0].len    = 4; $     DviItm[0].code   = DVI$_DEVCHAR;=     DviItm[0].buf    = &devchar;   /* disk characteristics */      DviItm[0].retlen = 0;      DviItm[1].len    = 0;      DviItm[1].code   = 0;    '     DscFib.dsc$w_length = FIB$C_LENGTH;    G         /* initialize ACP-QIO Attributes structure. The primary purpose G            here is to get specific date/time values. This could grow in 6            time for other items, but it is unlikely */   !     Atr[0].size = sizeof(CreBin);       Atr[0].type = ATR$C_CREDATE;     Atr[0].address = &CreBin; !     Atr[1].size = sizeof(RevBin);       Atr[1].type = ATR$C_REVDATE;     Atr[1].address = &RevBin; !     Atr[2].size = sizeof(ExpBin);       Atr[2].type = ATR$C_EXPDATE;     Atr[2].address = &ExpBin; !     Atr[3].size = sizeof(BckBin);       Atr[3].type = ATR$C_BAKDATE;     Atr[3].address = &BckBin; !     Atr[4].size = ATR$S_ASCDATES; !     Atr[4].type = ATR$C_ASCDATES;      Atr[4].address = &FileInfo;      Atr[5].size = 0;     Atr[5].type = 0;     Atr[5].address = 0;    /         /* init 'QualFlg' to always display two E            timestamps (unless negated by userentered qualifier(s)) */    !     QualFlg |= (CREATE + REVISE);    <         /* get the command line used to invoke this image */   N     status = GetCmdLine(&DscCmd, &CmdLen);  /* get invoking foreign cmd str */*     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = '\0';    3         /* extract foreign cmd verb from CmdLine */    #     sscanf(CmdLine, "%s", CmdVerb);      ptr = strchr(CmdVerb, '/');      if(ptr) *ptr = '\0';+     DscVerb.dsc$w_length = strlen(CmdVerb); ,     status = str$upcase(&DscVerb, &DscVerb);   G         /* get parameter and qualifier(s) from command line, prefix the L            CLD declared verb and use CLI$DCL_PARSE to build the cmd table */   5     status = lib$get_foreign(&DscCmd, 0, &CmdLen, 0); *     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = '\0'; "     strcpy(LineBuf, "FILEDATES ");     strcat(LineBuf, CmdLine); +     DscLbuf.dsc$w_length = strlen(LineBuf); J     CliStat = cli$dcl_parse(&DscLbuf, FILEDATES_CLD, lib$get_input, 0, 0);,     if(CliStat != CLI$_NORMAL) exit(status);   >         /* if user typed /HELP then show help text and exit */        strcpy(CliStr,"HELP");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowHelp();    @         /* if user typed /VERSION then show versinfo and exit */        strcpy(CliStr, "VERSION");)     DscCli.dsc$w_length = strlen(CliStr); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowVers();    7         /* get the target FileName from command line */    *     strcpy(DscCli.dsc$a_pointer,"INFILE");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { ;         CliStat = cli$get_value(&DscCli, &DscFnm, &BufLen); 0         if(CliStat != SS$_NORMAL) exit(CliStat);          FileName[BufLen] = '\0';     } :     else {  /* if no FileName, display message and exit */M         printf("\n%%%s-E-NOFILE,  Usage Syntax: %s FileName [/Qualifier...]",              CmdVerb,  CmdVerb); 3         printf("\n\t(type %s /HELP)\n\n", CmdVerb);          exit(1);     }    9         /* esa adds a semicolon, see if user wanted it */    $     miscptr = strchr(FileName, ';');     if(miscptr) SemiFlg = TRUE;    B         /* if 'FileName' string contains elipsis (...) set flag */   &     miscptr = strstr(FileName, "...");"     if(miscptr) ElipsisFlg = TRUE;   E         /* check whether to log results with the /OUTPUT qualifier */         strcpy(CliStr, "OUTPUT"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { ;         CliStat = cli$get_value(&DscCli, &DscOut, &BufLen); 0         if(CliStat != SS$_NORMAL) exit(CliStat);         else {             OutFlg = TRUE;'             OutFileName[BufLen] = '\0'; 	         }      } )     else strcpy(OutFileName, ctermid(0)); %     outfp = fopen(OutFileName, "w+");      if(!outfp) exit(0x1852C);    E         /* check for date/time  command qualifiers entered by user */         status = GetQualifiers();      if(!QualFlg) {H         printf("%%%s-E-NONSELEC, No timestamp values were selected\n\n",                 CmdVerb);          exit(status);      }    G         /* check whether to display iso9660 timestamps. If logical name F            SHOW_ISO9660 is defined and equates to TRUE, enable flag */   &     strcpy(EnableLnm, "SHOW_ISO9660");5     status = CheckLnm(&EnableLnm, sizeof(EnableLnm));      if(status == SS$_NORMAL) {>         if(strcmp(EnableLnm, "TRUE") == 0) QualFlg |= ISO9660;     }    :         /* initialize parse/search Fab & Nam structures */   D     Fab.fab$l_dna = FileName;            /* Assign the address of */K                                             /* filename to fab.fab$l_dna */ A     Fab.fab$b_dns = strlen(FileName);    /* Assign the length. */ J     Fab.fab$l_nam = &Nam;                /* Assign address of NAM block */   A     Nam.nam$l_esa = esa;                 /* Address of the esa */ @     Nam.nam$b_ess = sizeof esa;          /* length of the esa */A     Nam.nam$l_rsa = rsa;                 /* Address of the rsa */ @     Nam.nam$b_rss = sizeof rsa;          /* Length of the rsa */   B         /*  This section first does the parse of the input string.F          *  It checks the value of the return status, and if not equalE          *  to RMS$_NORMAL, the program exits with the return status.           */    8     if ((status = sys$parse(&Fab,0,0)) == RMS$_NORMAL) {"         esa[Nam.nam$b_esl] = '\0';   -         /* Show user filepath we are using */    4 #ifdef __ALPHA      /* vax rms does not like this */#         miscptr = strchr(esa, ';'); "         if(!SemiFlg) *miscptr = 0; #endif/         fprintf(outfp, "\n Target: %s\n", esa);    :         /* get the disk device name for target filepath */   #         DviPtr = &Nam.nam$t_dvi[1];           strcpy(DevName, DviPtr);&         DevName[Nam.nam$t_dvi[0]] = 0;/         DscDev.dsc$w_length = Nam.nam$t_dvi[0]; A         status = sys$getdviw(0, 0, &DscDev, &DviItm, 0, 0, 0, 0); .         if(status != SS$_NORMAL) exit(status);   E         /*  Here we search for the file. If it is found, we fall down G          *  into a while loop. If 'FileName' contains wildcard info, we G          *  loop until no more filenames match the input string. If the F          *  input string contains no wildcards, we exit the loop afterD          *  the first pass thru. The program exits with the value of          *  the return status.          */    @         while ((status = sys$search(&Fab,0,0)) == RMS$_NORMAL) {&             rsa[Nam.nam$b_rsl] = '\0';)             status = GetDateStrings(rsa); )             if(!status & 1) exit(status); 	         }      }         fprintf(outfp, "\n");      fclose(outfp);  C     if(status == RMS$_NMF) exit(SS$_NORMAL);     /* exit quietly */ :     exit(status);   /* Else exit with the return status */ }          J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetDateStrings D  * Description: Check for and display date and time info for a givenE  *              file per the user request from the command line. Info F  *              from the cmdline is checked via the variable 'QualFlg'F  *              which was already configured via command line parsing.  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ $ int GetDateStrings(char *targetfile) {      int     Fstat;     char    Fname[80];     char    *ptr;    8     $DESCRIPTOR(DscWork, Fname);   /* target filename */   6         /* get and save target filename w/o dirspec */        ptr = Nam.nam$l_name;      strcpy(Fname, ptr);    D             /* clear the entire Fib structure so wildcard operationsE                do not reflect Fib values from a previous file. We are D                in fact inside a 'while' loop, even if we are working"                on just one file */   !     memset(&Fib, 0, sizeof(Fib));    <             /* init the Fib structure, only need file id and;                directory id fields filled in from Nam block ,                following successful $PARSE*/   2             /* copy the file ID from Nam to Fib */   )     Fib.fib$w_fid_num = Nam.nam$w_fid[0]; )     Fib.fib$w_fid_seq = Nam.nam$w_fid[1]; )     Fib.fib$w_fid_rvn = Nam.nam$w_fid[2];    7             /* copy the directory ID from Nam to Fib */    )     Fib.fib$w_did_num = Nam.nam$w_did[0]; )     Fib.fib$w_did_seq = Nam.nam$w_did[1]; )     Fib.fib$w_did_rvn = Nam.nam$w_did[2];    E             /* issue QIOW with IO$_ACCESS to fill primarily the items @                in the ATR structure. This does not open the file;                so does not change the revision date/time */    1     status = sys$assign(&DscDev, &Channel, 0, 0); *     if(status != SS$_NORMAL) exit(status);   )     DscWork.dsc$w_length = strlen(Fname);    :     status = sys$qiow(0, Channel, IO$_ACCESS, &Iosb, 0, 0,4                   &DscFib, &DscWork, 0, 0, &Atr, 0);*     if(status != SS$_NORMAL) exit(status);     status = Iosb[0]; *     if(status != SS$_NORMAL) exit(status);   >     memcpy(&RevNum, &FileInfo, 2);  /* file revision number */  *D         /* Print the file name to show we read it. If ElipsisFlg set<            then print entire rsa string, else print Fdate */  _9     if(ElipsisFlg) fprintf(outfp, "%s\n", Nam.nam$l_rsa); '     else fprintf(outfp, "%s\n", Fname);   |G         /* display file creation date if QualFlg bit 'CREATE' is set */   l+     if(QualFlg & CREATE || QualFlg & ALL) { ,         memset(AscDate, 0, sizeof(AscDate));         DateLen = 0;;         Fstat = sys$asctim(&DateLen, &DscDate, &CreBin ,0); 0         if(Fstat != SS$_NORMAL) lib$stop(Fstat);          AscDate[DateLen] = '\0';9         fprintf(outfp, "%12s: %s\n", "Created", AscDate);      }    G         /* display file revision date if QualFlg bit 'REVISE' is set */    +     if(QualFlg & REVISE || QualFlg & ALL) {_,         memset(AscDate, 0, sizeof(AscDate));         DateLen = 0;;         Fstat = sys$asctim(&DateLen, &DscDate, &RevBin, 0);i0         if(Fstat != SS$_NORMAL) lib$stop(Fstat);          AscDate[DateLen] = '\0';F         fprintf(outfp, "%12s: %s (%d)\n", "Revised", AscDate, RevNum);     }T   C         /* The file may or may not have expiration or backup dates.rI            First check to see if the date field has a value in it, if notE>            then print <none specified> in place of the date */  *I         /* display file expiration date if QualFlg bit 'EXPIRE' is set */   l+     if(QualFlg & EXPIRE || QualFlg & ALL) {s*         memset(AscDate,0,sizeof(AscDate));         DateLen = 0;         if(ExpBin[0] != 0) {?             Fstat = sys$asctim(&DateLen, &DscDate, &ExpBin, 0);e4             if(Fstat != SS$_NORMAL) lib$stop(Fstat);$             AscDate[DateLen] = '\0';=             fprintf(outfp, "%12s: %s\n", "Expires", AscDate); 	         }EI         else fprintf(outfp, "%12s: %s\n", "Expires", "<None specified>");      }*   E         /* display file backup date if QualFlg bit 'BACKUP' is set */B   +     if(QualFlg & BACKUP || QualFlg & ALL) { ,         memset(AscDate, 0, sizeof(AscDate));         DateLen = 0;         if(BckBin[0] != 0) {?             Fstat = sys$asctim(&DateLen, &DscDate, &BckBin, 0);I4             if(Fstat != SS$_NORMAL) lib$stop(Fstat);$             AscDate[DateLen] = '\0';<             fprintf(outfp, "%12s: %s\n", "Backup", AscDate);	         }pL         else fprintf(outfp, "%12s: %s\n", "Backup", "<No backup recorded>");     }2  E     fprintf(outfp, "\n");      return(Fstat); }0  2N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetQualifiersI  * Description: Read each command line qualifier, verify it's syntax, and*L  *              if it correct set/clear the appropriate bit in the 'QualFlg'G  *              variable. Note that if the /ALL qualifier is specified,e4  *              all other qualifiers are irrelevant.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int GetQualifiers()6 {a     int CliStat;     int status = SS$_NORMAL;  e     char CliStr[80];  iJ     $DESCRIPTOR(DscCli, CliStr);       /* cli param or qualifier string */  2     strcpy(CliStr, "BACKUP");*7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer);*#     CliStat = cli$present(&DscCli); 2     if(CliStat == CLI$_PRESENT) QualFlg |= BACKUP;  >     strcpy(CliStr, "CREATION");<7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer);*#     CliStat = cli$present(&DscCli);<2     if(CliStat == CLI$_PRESENT) QualFlg |= CREATE;8     else if(CliStat == CLI$_NEGATED) QualFlg &= ~CREATE;  <!     strcpy(CliStr, "EXPIRATION");i7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli);g2     if(CliStat == CLI$_PRESENT) QualFlg |= EXPIRE;  r     strcpy(CliStr, "REVISION");e7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer);p#     CliStat = cli$present(&DscCli);N2     if(CliStat == CLI$_PRESENT) QualFlg |= REVISE;8     else if(CliStat == CLI$_NEGATED) QualFlg &= ~REVISE;        strcpy(CliStr, "All");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); /     if(CliStat == CLI$_PRESENT) QualFlg |= ALL;p  o     return(status);  }n  c  n  ;H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetCmdLineI  * Description: Retrieve the last command entered from the command recallxH  *              buffer in the users process space, the command which wasJ  *              used to invoke this image. The contents of this recall bufK  *              are saved in a user specified buffer. In the unlikely eventtH  *              that the command line is longer than callers buffer, setM  *              length to -1 and return SS$_BUFFEROVF. Else return SS$_NORMAL   *J  *              This routine is aware of buffer length changes implemented'  *              in VMS 7.3-2 and above.s  *I  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ A int GetCmdLine(struct dsc$descriptor_s *DscTarget, short *length)o { <     char    *Sptr = 0;      /* last recall buffer pointer */D     char    *Dptr = 0;      /* callers string destination pointer */  [     short   ExpBuf = 0; @     short   *Lptr = 0;      /* pointer to callers length word */  i     int     BufSize;     int     RecallAddr = 0;t     int     ppd = 0;     int     prc = 0;A     int     *Iptr = 0;      /* integer pointer for indirection */R  ED         /* recall buffer larger for V7.3-2 and higher. Use this infoD            to determine whether recall buffer length is presented to$            us as a byte or a word */  $=     BufSize = PRC_S_COMMANDS;       /* get size of rcl buf */_     if(BufSize > 4100)D         ExpBuf = TRUE;              /* if < 4100, osvers <= 7.3-1 */  {8     RecallAddr = CTL$AG_CLIDATA;    /* address of ppd */8     RecallAddr += PPD$L_PRC;        /* address of prc */A     prc = PRC_L_RECALLPTR;          /* current command pointer */ A     Iptr = RecallAddr;              /* pseudo pointer register */      RecallAddr = *Iptr;C0     RecallAddr += prc;              /* offset */B     Iptr = RecallAddr;              /* copy to pointer register */L     RecallAddr = *Iptr;             /* RecallAddr points to end of buffer */   A         /* here we use recall allocation to determine the size of]B            the recall buffer length field, changed at vms 7.3.2 */   E     if(ExpBuf) RecallAddr -= 2;     /* length is 16 bits at 7.3-2+ */ ?     else RecallAddr--;              /* else length is 8 bits */r     Sptr = RecallAddr;$     Dptr = DscTarget->dsc$a_pointer;  tB         /* be sure cmd line not longer than callers buffer. If so,6            ignore cmd line and return SS$_BUFFEROVF */        if(ExpBuf) {         Lptr = Sptr;O         if(*Lptr < DscTarget->dsc$w_length-1) *length = *Lptr; /* 16 bit val */s         else {             *length = -1;i"             return(SS$_BUFFEROVF);	         }=     } 2     else *length = *Sptr;       /*  8 bit value */   C         /* get buffer length and copy cmd line to callers buffer */         Sptr -= *length;!     strncpy(Dptr, Sptr, *length);      return(SS$_NORMAL);  }$  E  H   L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *G  *  ShowVers - User entered the /VERSION qualifier to display the image F  *            version, C compiler type, and required image privileges.D  *            This software application has NOT been built with VaxC  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */; void ShowVers()e {=3     printf("\n\n\t\t%s by Lyle W West\n", CmdVerb);t0     printf("\t\tVersion: %s (DecC)\n", VERSION);.     printf("\t\tImage Build: %s\n", __DATE__);/     printf("\t\tRequired Privs: READALL \n\n");s     exit(1); }   [  sL /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *@  *  ShowHelp - User entered the /HELP qualifier to get a list of@  *             parameters and qualifiers available to this image  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowHelp()E {R2     printf("\n\n  %s (%s)\n\n", CmdVerb, VERSION);G     printf("\t%s displays the filename, creation and revision dates\n",*             CmdVerb);mM     printf("\tof a filespec input on the command line. Additionaly, the \n");'K     printf("\tuser can use qualifiers to display expiration and backup\n");CI     printf("\tdates. %s uses the ACP-QIO interface, permitting access\n",r             CmdVerb);s1     printf("\teven if target file is open.\n\n");c      printf("   Parameters\n\n");O     printf("    FILENAME    Required. The FILENAME is a valid filespec for\n");CE     printf("\t\twhich timestamp info is requested. Default is to\n"); ;     printf("\t\tdisplay CREATION and REVISION dates.\n\n");s      printf("   Qualifiers\n\n");F     printf("    /ALL        If present, %s displays all timestamps\n",             CmdVerb);)M     printf("\t\t(creation, revision, expiration, backup) for the entered\n");DJ     printf("\t\tfile. This excludes EFFECTIVE and RECORDING which VMS\n");7     printf("\t\tprovides for ISO 9660 compliance\n\n");hK     printf("    /BACKUP     If present, %s will display the backup date\n",n             CmdVerb);$     printf("\t\tand time\n\n");rM     printf("    /CREATION   If present, %s will display the creation date\n",i             CmdVerb);h)     printf("\t\tand time (default)\n\n");yO     printf("    /EXPIRATION If present, %s will display the expiration date\n",l             CmdVerb);      printf("\t\tand time\n\n");w%     printf("    /OUTPUT=filespec\n"); C     printf("\t\tIf present, %s redirects output from SYS$OUTPUT\n",I             CmdVerb);c1     printf("\t\tto the entered output file\n\n");SM     printf("    /REVISION   If present, %s will display the revision date\n",a             CmdVerb);l)     printf("\t\tand time (default)\n\n");!T     printf("    /HELP       If present, %s displays list of qualifiers\n", CmdVerb);?     printf("\t\tavailable for %s (this display)\n\n", CmdVerb);%M     printf("    /VERSION    If present %s displays version, build", CmdVerb);,1     printf(" date,\n\t\tand required privs\n\n");\     exit(1); }      xN /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: CheckLnmlL  * Description: Function to translate a provided logical name to the definedJ  *              equivalence string. The LNM$DCL_LOGICAL logical name tableD  *              is searched for a match. If successful, the returnedK  *              equivalence string is copied to the memory location used toUL  *              provide the input logical name (*LnmStr) so caller must makeG  *              certain the buffer containing the input logical name islF  *              large enough to contain the full equivalence string orG  *              this routine returns SS$_BUFFEROVF. In all other cases, F  *              the return status of SYS$TRNLNM is returned to caller.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */f& int CheckLnm(char *LnmStr, int buflen) {rJ     int LnmCase = LNM$M_CASE_BLIND;  /* resolve lnm without case issues */K     int EqvAttrb = 0;               /* returned attributes of eqv string */      int LnmStat = 0;     short EqvLen = 0;m     short TblLen = 0;s?     char AcMode = PSL$C_USER;       /* always from user mode */ <     char LnmTable[40];              /* logical name table */=     char LnmDef[40];                /* logical name string */mI     char LnmEqv[80];                /* logical name equivalence string */    >     struct {short len, code; int *bufadr, *retlen;} LnmItm[4];   %     $DESCRIPTOR(DscTabnam, LnmTable); #     $DESCRIPTOR(DscLognam, LnmDef);N#     $DESCRIPTOR(DscEqvnam, LnmEqv);n   '     memset(&LnmEqv, 0, sizeof(LnmEqv));s     strcpy(LnmDef, LnmStr); (     strcpy(LnmTable, "LNM$DCL_LOGICAL");  l.     DscTabnam.dsc$w_length = strlen(LnmTable);,     DscLognam.dsc$w_length = strlen(LnmDef);,     DscEqvnam.dsc$w_length = sizeof(LnmEqv);   %     LnmItm[0].len = sizeof(EqvAttrb); %     LnmItm[0].code = LNM$_ATTRIBUTES; !     LnmItm[0].bufadr = &EqvAttrb;      LnmItm[0].retlen = 0; %     LnmItm[1].len = sizeof(LnmTable);       LnmItm[1].code = LNM$_TABLE;!     LnmItm[1].bufadr = &LnmTable;      LnmItm[1].retlen = &TblLen; #     LnmItm[2].len = sizeof(LnmEqv); !     LnmItm[2].code = LNM$_STRING;      LnmItm[2].bufadr = &LnmEqv;t     LnmItm[2].retlen = &EqvLen;      LnmItm[3].len = 0;     LnmItm[3].code = 0;e  tM     LnmStat = sys$trnlnm(&LnmCase, &DscTabnam, &DscLognam, &AcMode, &LnmItm);N     if(LnmStat == SS$_NORMAL) {s         LnmEqv[EqvLen] = '\0';          LnmTable[TblLen] = '\0';3         if(EqvLen < buflen) strcpy(LnmStr, LnmEqv);/#         else return(SS$_BUFFEROVF);      } 8     if(EqvAttrb & LNM$M_CONCEALED) return(SS$_IVLOGNAM);     else return(LnmStat);  }         *et the disk device name for target filepath */   #         DviPtr = &Nam.nam$t_dvi[1];           strcpy(DevName, DviPtr);&         DevName[Nam.nam$t_dvi[0]] = 0;/         DscDev.dsc$w_length = Nam.nam$t_dvi[0]; A         status = sys$getdviw(0, 0, &DscDev, &DviItm, 0, 0, 0, 0); .         if(s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                