 /* 	MBMON_EXECLET   	MBMON Loadable Executive Image     COPYRIGHT NOTICE   F  This software is COPYRIGHT (c) 2005, Ian Miller. ALL RIGHTS RESERVED.  9  Released under licence described in freeware_readme.txt      DISCLAIMER   K THIS PACKAGE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"  Q AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED F WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE AREO DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR N ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGESL (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;N LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ONG ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT M (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS < SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */ #pragma module MBMONXT "V0.1"    #include <descrip> #include <lnmdef>  #include <psldef>  #include <ldrimgdef> #include <ldrdef>  #include <string>  #include <irpdef>  #include <pcbdef>  #include <ucbdef>  #include <ccbdef>  #include <ddbdef>  #include <ddtdef>  #include <fdtdef>  #include <fdt_contextdef.h>  #include <ssdef.h> #include <iodef.h> #include <dcdef.h> #include <vms_macros.h>    #include "mbmon.h"  5 #pragma extern_model strict_refdef "$A_NONPAGED_DATA" Q /* the vector table - has to be the first data in this psect so it can be found*/  MBMON_VECTOR mbmon_vector =  { % 	MBMON_VECTOR_VERSION,	/* version		*/ * 	MBMON_VECTOR_COUNT,	/* number of items	*/ 	NULL,			/* the table		*/  	NULL,			/* setup routine	*/ 	NULL,			/* add a mailbox	*/ 	NULL,			/* remove a mailbox	*/  };  ) /* number of mailboxes being monitored	*/ , static unsigned long mbmon_active_unit = 0;	  ( static MBMON_UNIT mbmon[MBMON_MAX_UNIT];   int mbmon_xt_write();  unsigned long mbmon_xt_setup(); J unsigned long mbmon_xt_add(MB_UCB *ucb1, MB_UCB *ucb2, unsigned int epid);  unsigned long mbmon_xt_remove();  + static int unlvec[2];   /* unload vector	*/   $ /* saved address of mbdriver ddb		*/ static DDB *mbddb = NULL; $ /* saved address of mbdriver ddt		*/ static DDT *mbddt = NULL;    /* saved mbdriver fdt 				*/ static FDT mbfdt;  static FDT *mbfdtptr = NULL;    3 #pragma extern_model strict_refdef "EXEC$INIT_CODE"  /*7 	mbmon_xt_init	- init routine called when we are loaded  */ int E mbmon_xt_init(LDRIMG *ldb, unsigned long *flags, MBMON_VECTOR **mbvp)  {  	int mbmon_xt_unload(); 	 #if TRACE % 	tr_print(("mbmon_xt_init - start")); 5 	tr_print(("mbmon_xt_init - ldr img data 0x%x",ldb));  #endif  - 	/* setup vector for users of this execlet	*/  	mbmon_vector.mbmon = mbmon;% 	mbmon_vector.setup = mbmon_xt_setup; 6 	mbmon_vector.add = (unsigned long (*)())mbmon_xt_add;< 	mbmon_vector.remove = (unsigned long (*)())mbmon_xt_remove;  " 	/* setup unload routine vector */; 	unlvec[0] = (int)mbmon_xt_unload;	/* my routine to call	*/ ( 	unlvec[1] = 0;				/* list terminator	*/ #ifdef OLD_LDRIMG  	/* pre V7.2-1		*/* 	ldb->ldrimg$l_unlvec = (int (*)())unlvec; #else  	/* V7.2-1 and later	*/  	ldb->ldrimg$l_unlvec = unlvec;  #endif 	*mbvp = &mbmon_vector;   	 #if TRACE 9 	tr_print(("mbmon_xt_init - vector address 0x%x",*mbvp)); # 	tr_print(("mbmon_xt_init - end"));  #endif
 	return 1; }    /*. 	mbmon_xt_unload - called when we are unloaded */ int mbmon_xt_unload()  { 	 #if TRACE ' 	tr_print(("mbmon_xt_unload - start"));  #endif 	if (mbddt == NULL)  	{	 #if TRACE 0 		tr_print(("mbmon_xt_unload - nothing to do")); #endif 	} 	else  	{# 		/* restore the mbdriver fdt 			*/ R 		mbfdtptr->fdt$ps_func_rtn[IO$_WRITEPBLK] = mbfdt.fdt$ps_func_rtn[IO$_WRITEPBLK];R 		mbfdtptr->fdt$ps_func_rtn[IO$_WRITELBLK] = mbfdt.fdt$ps_func_rtn[IO$_WRITELBLK];R 		mbfdtptr->fdt$ps_func_rtn[IO$_WRITEVBLK] = mbfdt.fdt$ps_func_rtn[IO$_WRITEVBLK];N 		mbfdtptr->fdt$ps_func_rtn[IO$_WRITEOF] = mbfdt.fdt$ps_func_rtn[IO$_WRITEOF]; 	  		mbddt = NULL;  		mbddb = NULL;  		mbfdtptr = NULL; 	}	 #if TRACE % 	tr_print(("mbmon_xt_unload - end"));  #endif  
 	return 1; } % #define INIT001_ROUTINE mbmon_xt_init  #include <init_rtn_setup>    /*C 	mbmon_xt_write	- the routine to be called instead of the MBDRIVER   		FDT write routine   D 	This routine is called at IPL$_ASTDEL in kernel mode in the context? 	of the user process which called $QIO to write to the mailbox.  */7 #pragma extern_model strict_refdef "NONPAGED_USER_CODE"  int 9 mbmon_xt_write(IRP *irp, PCB *pcb, MB_UCB *ucb, CCB *ccb)  {  	int ccode, i, ccode2; 	unsigned short iofc;  	void *msgbuf; 	unsigned long msglen; 	FDT_CONTEXT *fc;   % 	iofc = irp->irp$l_func & IO$M_FCODE;   9 	/* check if ucb address matches one we are monitoring	*/ # 	for (i=0; i < MBMON_MAX_UNIT; i++)  	{ 		if ((mbmon[i].mb_unit1 != 0)7 		&&  (mbmon[i].mb_unit1 == ucb->ucb$r_ucb.ucb$w_unit))  			break;	/* eureka	*/ 	} 	if (i < MBMON_MAX_UNIT) 	{( 		/* check this really is the mailbox	*/ 		if (mbmon[i].mb_ucb1 != ucb) 		{ 	 #if TRACE Z 			tr_print(("mbmon_xt_write - ucb mismatch - UCB 0x%x, ucb1 0x%x",ucb,mbmon[i].mb_ucb1));, 			mbmon[i].mb_unit1 = 0;	/* mark as free	*/% 			i = MBMON_MAX_UNIT;	/* no match	*/  #endif 		}  	}8 	/* if not call the mbdriver fdt write routine & exit	*/ 	if (i >= MBMON_MAX_UNIT)  	{: 		ccode = (*mbfdt.fdt$ps_func_rtn[iofc])(irp,pcb,ucb,ccb); 	} 	else  	{	 #if TRACE X 		tr_print(("mbmon_xt_write - IRP 0x%x, PCB 0x%x, UCB 0x%x, CCB 0x%x",irp,pcb,ucb,ccb)); #endifD 		/* save the I/O buffer addr&len(NB if fn=WRITEOF then no buffer)*/% 		msgbuf = (void *)irp->irp$l_qio_p1;  		msglen = irp->irp$l_qio_p2; 	 #if TRACE h 		tr_print(("mbmon_xt_write - PID 0x%x IO fc %d, msg 0x%x, len %d",pcb->pcb$l_epid,iofc,msgbuf,msglen)); #endif0 		/* save the address of the fdt_context area	*/ 		fc = irp->irp$ps_fdt_context;   , 		/* call the mbdriver fdt write routine		*/: 		ccode = (*mbfdt.fdt$ps_func_rtn[iofc])(irp,pcb,ucb,ccb);   		if (ccode == SS$_FDT_COMPL)  		{  			/* if write succeeded			*/ ( 			if (fc->fdt_context$l_qio_status & 1) 			{5 				/* write the message to the monitoring mailbox	*/ @ 				ccode2 = EXE_STD$WRTMAILBOX(mbmon[i].mb_ucb2,msglen,msgbuf);	 #if TRACE O 				tr_print(("mbmon_xt_write - status of write to monitoring mbx %x",ccode2));  #endif 			} 		}  	} 	return ccode; }    /*& 	mbmon_xt_setup	- setup for monitoring; 	Alter the mbdriver fdt vector to point to our routine for  2 	IO$_WRITExBLK saving the original routine address  6 	This routine is called at IPL$_ASTDEL in kernel mode ' 	with the I/O database locked for read.  */
 unsigned long  mbmon_xt_setup() {  	unsigned long ccode;  	extern UCB *SYS$AR_JOBCTLMB; 
 	UCB *ucb;  	 #if TRACE & 	tr_print(("mbmon_xt_setup - start")); #endif 	if (mbddt != NULL)  	{	 #if TRACE . 		tr_print(("mbmon_xt_setup - already done")); #endif 		return SS$_NORMAL; 	}  F 	/* get the job controllers mailbox ucb address from SYS$AR_JOBCTLMB*/ 	ucb = SYS$AR_JOBCTLMB;  	  	/* sanity check							*/ ( 	if (ucb->ucb$b_devclass != DC$_MAILBOX) 	{	 #if TRACE q 		tr_print(("mbmon_xt_setup - jobctl mailbox not a mailbox?!!! - ucb %x, devclass %d",ucb, ucb->ucb$b_devclass));  #endif 		return SS$_BADPARAM; 	}  8 	/* get the address of the mbdriver ddb from the ucb		*/ 	mbddb = ucb->ucb$l_ddb;  9 	/* get the address of the mbdriver ddt from the ddb 		*/  	mbddt = mbddb->ddb$ps_ddt;   8 	/* get the address of the mbdriver fdt from the ddt		*/  	mbfdtptr = mbddt->ddt$ps_fdt_2;	 #if TRACE : 	tr_print(("mbmon_xt_setup - mbfdt address %x",mbfdtptr)); #endif  ! 	/* save the mbdriver fdt 					*/ ' 	memcpy(&mbfdt,mbfdtptr,sizeof(mbfdt));   / 	/* change the fdt to refer to our routine			*/ ; 	mbfdtptr->fdt$ps_func_rtn[IO$_WRITEPBLK] = mbmon_xt_write; ; 	mbfdtptr->fdt$ps_func_rtn[IO$_WRITELBLK] = mbmon_xt_write; ; 	mbfdtptr->fdt$ps_func_rtn[IO$_WRITEVBLK] = mbmon_xt_write; 9 	mbfdtptr->fdt$ps_func_rtn[IO$_WRITEOF] = mbmon_xt_write;  	 	 #if TRACE A 	tr_print(("mbmon_xt_setup - mbmon_xt_write %x",mbmon_xt_write));  #endif  	 #if TRACE $ 	tr_print(("mbmon_xt_setup - end")); #endif   	ccode = 1;    	return ccode; }    /*9 	mbmon_xt_add	- add a mailbox to the table for monitoring   D 	This routine is called at IPL$_ASTDEL in kernel mode in the contextA 	of the user process which called the mbmon_enable system service  */
 unsigned long ; mbmon_xt_add(MB_UCB *ucb1, MB_UCB *ucb2, unsigned int epid)  {  	register unsigned long ccode; 	register int i;  	 #if TRACE M 	tr_print(("mbmon_xt_add - UCB1 0x%x, UCB2 0x%x, epid 0x%x",ucb1,ucb2,epid));  #endif  $ 	/* check table entry count < max	*/) 	if (mbmon_active_unit >= MBMON_MAX_UNIT)  		return SS$_DEVLISTFULL;   F 	/* search the table to check that it is not already being monitored*/  	/* and to find a free entry		*/ 	ccode = SS$_DEVLISTFULL; # 	for (i=0; i < MBMON_MAX_UNIT; i++)  	{6 		if (mbmon[i].mb_unit1 == ucb1->ucb$r_ucb.ucb$w_unit) 		{ + 			ccode = SS$_DUPUNIT;	/* already there */ 	 			break;  		}  		if (mbmon[i].mb_unit1 == 0)  		{ * 			ccode = SS$_NORMAL;	/* already there */	 			break;  		}  	} 	if (!(ccode & 1))) 		return ccode;	/* report the bad news	*/   ( 	/* fill in entry and increment count	*/0 	mbmon[i].mb_unit1 = ucb1->ucb$r_ucb.ucb$w_unit;0 	mbmon[i].mb_unit2 = ucb2->ucb$r_ucb.ucb$w_unit; 	mbmon[i].epid = epid; 	mbmon[i].mb_ucb1 = ucb1;  	mbmon[i].mb_ucb2 = ucb2;    	mbmon_active_unit++;  	  	ccode = SS$_NORMAL;	 #if TRACE " 	tr_print(("mbmon_xt_add - end")); #endif   	return ccode; }    /*3 	mbmob_xt_remove	- remove a mailbox from monitoring   D 	This routine is called at IPL$_ASTDEL in kernel mode in the contextA 	of the user process which called the mbmon_enable system service  */
 unsigned long 0 mbmon_xt_remove(MB_UCB *ucb1, unsigned int epid) {  	unsigned long ccode;  	register int i;  	 #if TRACE ? 	tr_print(("mbmon_xt_remove - UCB 0x%x, epid 0x%x",ucb1,epid));  #endif! 	/* search table to find it				*/ ; 	/* if found clear the table entry & decrement the count	*/    	ccode = SS$_NOSUCHDEV; # 	for (i=0; i < MBMON_MAX_UNIT; i++)  	{6 		if (mbmon[i].mb_unit1 == ucb1->ucb$r_ucb.ucb$w_unit) 		{  			if (mbmon[i].epid == epid)  			{ 				ccode = SS$_NORMAL; - 				mbmon[i].mb_unit1 = 0;	/* mark as free	*/ 5 				mbmon_active_unit--;	/* one less to worry about*/ 	 #if TRACE ; 				tr_print(("mbmon_xt_remove - found it at entry %d",i));  #endif 			} 			else  			{ 				ccode = SS$_NOPRIV; 	 #if TRACE O 				tr_print(("mbmon_xt_remove - epid mismatch - mb epid 0x%x",mbmon[i].epid));  #endif 			} 		}  	}	 #if TRACE 9 	tr_print(("mbmon_xt_remove - end - result 0x%x",ccode));  #endif 	return ccode; } 