   L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |              DIRSORT              %%   \ @  *                %% |         dirsort.c  c2004          %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *9  *  Copyright (C) 2004 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *;  *  DIRSORT is a customized equivalent of the DCL DIRECTORY =  *  command, except it only lists filename and timestamp info ;  *  about files in a directory. The output is sorted by the ;  *  timestamp rather than filename, and can sort by date in 3  *  either descending or ascending (default) order.   *A  *  File dates are displayed by default in the YYYY-Mmm-DD format >  *  This is user definable by setting the process logical name%  *  DIRSORT_FORMAT to another format:   *?  *   $ define DIRSORT_FORMAT "|!DB-!MAAU-!Y4 !H04:!M0:!S0.!C2|"   *;  *  which formats the date in normal VMS 'DD-MMM-YYYY' mode 0  *  See Programming Concepts, Tables 6-6 and 6-8  *>  *  DIRSORT accepts one parameter, a VMS filepath which is the;  *  target directory. RMS wildcards (* and %) are accepted.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */     #include "version.h" #pragma module DIRSORT VERSION    #include <stdio.h> #include <ctype.h> #include <climsgdef.h> #include <dvidef.h>  #include <descrip.h> #include <fibdef.h>  #include <iodef.h> #include <lib$routines.h>  #include <rms.h> #include <ssdef.h> #include <starlet.h> #include <stdlib.h>  #include <string.h>  #include <atrdef.h>  #include "defs.h"    @ int DateContext;            /* context for output date format */? int MaxPtr;                 /* addr of last slot in FileList */ D int RmsStat;                /* status value returned by RMS calls */D int status;                 /* status value returned by SYS calls */4 int ownuic;                 /* currently not used */   @ int BckBin[2];              /* quadword value for Backup date */@ int CreBin[2];              /* quadword value for Create date */A int CurBin[2];              /* quadword value for Current date */ > int DeltaBin[2];            /* quadword value for DeltaTime */@ int ExpBin[2];              /* quadword value for Expire date */B int RevBin[2];              /* quadword value for Revision date */   > int CliStat;                /* return status from cli calls */   ; short Channel;              /* I/O channel to input file */ > short CliStrLen;            /* length of cli value returned */: short DateFlg;              /* date qualifier specified */: short DateLen;              /* ascii date string length */> short DateMode;             /* type of date info to compare */E short DeltaFlg;             /* user specified /DELTATIME qualifier */ J short DescendFlg;           /* if set, dates sorted in descending order */? short Iosb[4];              /* I/O status block for SYS$QIOW */ M short LayoutFlg;            /* user wants filename filedate display format */ O short TruncFlg;             /* disp file first, truncate filename at 31 chrs */    2 char Buffer[80];            /* cli value string */3 char CliStr[80];            /* cli string buffer */ E char CmdVerb[32];           /* foreign command inviking this image */ : char DateFormat[40];        /* ascii date format string */8 char DateStr[28];           /* ascii file date string */4 char DevName[32];           /* target disk device */M char FilePath[80];          /* input filespec from dcl (may be wildcarded) */ C char LayoutStr[32];         /* output field order keyword string */ I char LineBuf[132];          /* modified cmdline fed into cli$dcl_parse */ A char LnmStr[50];            /* reserved for logical name equiv */ D char TargetFile[50];        /* resultant filename from sys$search */
 char *DviPtr;  char *NamePtr;    struct FAB Fab;  struct NAM Nam;  struct fibdef Fib;    FILE_LIST *FileList;C FILE_LIST *ListPtr;                 /* file pointer for FileList */    J $DESCRIPTOR(DscBuf, Buffer);        /* string returned by cli$get_value */G $DESCRIPTOR(DscCli, CliStr);        /* cli param or qualifier string */ ? $DESCRIPTOR(DscDate, DateStr);      /* date input descriptor */ @ $DESCRIPTOR(DscDev, DevName);       /* device name descriptor */# $DESCRIPTOR(DscFormat, DateFormat); 9 $DESCRIPTOR(DscWork, TargetFile);   /* target filename */     globalvalue DIRSORT_CLD;    extern int CheckPrv(); extern int Date_Sort();  extern int GetCmdLine(); extern void FormatDateStr(); extern void ShowVers();  extern void ShowHelp();    
 int main() { J     char CmdLine[132];              /* buffer reflecting input cmd line */D     char TargetPath[80];            /* target filepath to display */N     char WildStr[20];               /* search for specific wildcard pattern */I     char rsa[NAM$C_MAXRSS];         /* parse/search resultant filename */ I     char esa[NAM$C_MAXRSS];         /* parse/search expanded  filename */      char *path;      char *miscptr = 0;     char *wildptr = 0;        int NumFiles = 0;      int devchar;        short CmdLen; @     short CvLen;                    /* Length of command verb */     short WildFlg = 0;   !     $DESCRIPTOR(DscCmd, CmdLine); $     $DESCRIPTOR(DscDisp, LayoutStr);N     $DESCRIPTOR(DscFib, (char *)&Fib); /* NOTE: this is not your normal dsc */"     $DESCRIPTOR(DscLbuf, LineBuf);#     $DESCRIPTOR(DscPath, FilePath); F     $DESCRIPTOR(DscVerb, CmdVerb);  /* foreign invoking symbol name */        DviItm[0].len    = 4; $     DviItm[0].code   = DVI$_DEVCHAR;=     DviItm[0].buf    = &devchar;   /* disk characteristics */      DviItm[0].retlen = 0;      DviItm[1].len    = 0;      DviItm[1].code   = 0;    '     DscFib.dsc$w_length = FIB$C_LENGTH;       C         /* check if user has defined a format string in the process D            table. If so, copy lnm equiv to DateFormat, else load the4            default format string into DateFormat, */   %     strcpy(LnmStr, "DIRSORT_FORMAT"); /     status = CheckLnm(&LnmStr, sizeof(LnmStr)); 8     if(status == SS$_NORMAL) strcpy(DateFormat, LnmStr);@     else strcpy(DateFormat, "|!Y4-!MAAC-!D0 !H04:!M0:!S0.!C2|");   <         /* get the command line used to invoke this image */   M     status = GetCmdLine(&DscCmd, &CvLen);  /* get invoking foreign cmd str */ *     if(status != SS$_NORMAL) exit(status);     CmdLine[CvLen] = 0;    3         /* extract foreign cmd verb from CmdLine */    $     sscanf(CmdLine, "%s", &CmdVerb);#     miscptr = strchr(CmdVerb, '/');       if(miscptr) *miscptr = '\0';+     DscVerb.dsc$w_length = strlen(CmdVerb); ,     status = str$upcase(&DscVerb, &DscVerb);   G         /* get parameter and qualifier(s) from command line, prefix the L            CLD declared verb and use CLI$DCL_PARSE to build the cmd table */   5     status = lib$get_foreign(&DscCmd, 0, &CmdLen, 0); *     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = '\0';       strcpy(LineBuf, "DIRSORT ");     strcat(LineBuf, CmdLine); +     DscLbuf.dsc$w_length = strlen(LineBuf); H     CliStat = cli$dcl_parse(&DscLbuf, DIRSORT_CLD, lib$get_input, 0, 0);,     if(CliStat != CLI$_NORMAL) exit(status);   C         /* check for presence of qualifiers which are not dependant (            on additional input values */        strcpy(CliStr, "VERSION");)     DscCli.dsc$w_length = strlen(CliStr); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowVers();         strcpy(CliStr, "HELP"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowHelp();    G         /* if we get here (we would not if qualifiers /HELP or /VERSION H            were entered as they call sys$exit at the conclusion of theirD            respective function calls) then check for and process the=            other qualifiers and the parameter for filepath */    &         /* check for DATE qualifier */        strcpy(CliStr, "DATE"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0';              DateFlg = TRUE; M             if(strncmp(Buffer, "BACKUP", CliStrLen) == 0) DateMode |= BACKUP; M             if(strncmp(Buffer, "CREATE", CliStrLen) == 0) DateMode |= CREATE; M             if(strncmp(Buffer, "EXPIRE", CliStrLen) == 0) DateMode |= EXPIRE; M             if(strncmp(Buffer, "REVISE", CliStrLen) == 0) DateMode |= REVISE; 	         }      } C     else DateMode |= REVISE;    /* default is revise/modify date */    +         /* check for DELTATIME qualifier */          strcpy(CliStr, "DELTATIME");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) {          DeltaFlg = TRUE;%         status = sys$gettim(&CurBin);      }    &         /* check for SORT qualifier */        strcpy(CliStr, "SORT"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; P             if(strncmp(Buffer, "ASCENDING", CliStrLen) == 0) DescendFlg = FALSE;P             if(strncmp(Buffer, "DESCENDING", CliStrLen) == 0) DescendFlg = TRUE;	         }      }    (         /* check for LAYOUT qualifier */   <     strcpy(CliStr, "LAYOUT");   /* default is DD-MMM-YYYY */7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { ?         CliStat = cli$get_value(&DscCli, &DscDisp, &CliStrLen); #         if(CliStat == SS$_NORMAL) { (             LayoutStr[CliStrLen] = '\0';G             if(strncmp(LayoutStr, "DATEFIRST", strlen(LayoutStr)) == 0) "                 LayoutFlg = FALSE;G             if(strncmp(LayoutStr, "FILEFIRST", strlen(LayoutStr)) == 0) !                 LayoutFlg = TRUE; H             if(strncmp(LayoutStr, "TRUNCATE", strlen(LayoutStr)) == 0) {!                 LayoutFlg = TRUE;                   TruncFlg = TRUE;
             } 	         }      }    4         /* check command line for specific target */        strcpy(CliStr, "PATH"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; %             strcpy(FilePath, Buffer); -             DscPath.dsc$w_length = CliStrLen; 	         }      } ?     else {              /* target not specified, use default */          path = getenv("PATH");         strcpy(FilePath, path); 0         DscPath.dsc$w_length = strlen(FilePath);0         status = str$upcase(&DscPath, &DscPath);     } !     strcpy(TargetPath, FilePath);    G         /* initialize ACP-QIO Attributes structure. The primary purpose H            here is to get/put basic date/time values. This could grow in6            time for other items, but it is unlikely */   !     Atr[0].size = sizeof(CreBin);       Atr[0].type = ATR$C_CREDATE;     Atr[0].address = &CreBin; !     Atr[1].size = sizeof(RevBin);       Atr[1].type = ATR$C_REVDATE;     Atr[1].address = &RevBin; !     Atr[2].size = sizeof(ExpBin);       Atr[2].type = ATR$C_EXPDATE;     Atr[2].address = &ExpBin; !     Atr[3].size = sizeof(BckBin);       Atr[3].type = ATR$C_BAKDATE;     Atr[3].address = &BckBin;      Atr[4].size = 0;     Atr[4].type = 0;     Atr[4].address = 0;       -         /* initialize Fab & Nam structures */         Fab = cc$rms_fab; :     Fab.fab$l_fna = &FilePath;          /* name of file */%     Fab.fab$b_fns = strlen(FilePath); G     Fab.fab$l_nam = &Nam;               /* FAB has an associated NAM */      Nam = cc$rms_nam; ?     Nam.nam$l_esa = &esa;               /* expanded filespec */       Nam.nam$b_ess = sizeof(esa);@     Nam.nam$l_rsa = &rsa;               /* resultant filespec */      Nam.nam$b_rss = sizeof(rsa);            /* perform sys$parse */         status = sys$parse(&Fab); +     if(status != RMS$_NORMAL) exit(status);      esa[Nam.nam$b_esl] = '\0';         miscptr = strstr(esa, ".;");     if(miscptr) *miscptr = 0;    =     if(strcmp(esa, TargetPath) != 0) strcpy(TargetPath, esa);    >         /* see if user appended some wildcard chars to path */   )     memset(&WildStr, 0, sizeof(WildStr)); $     wildptr = strchr(FilePath, '*');     if(wildptr) WildFlg = TRUE; 
     else {(         wildptr = strchr(FilePath, '%');#         if(wildptr) WildFlg = TRUE;      }      if(WildFlg) { (         wildptr = strchr(FilePath, ']');         if(wildptr) {              wildptr++;%             strcpy(WildStr, wildptr); 	         }          else {,             wildptr = strchr(FilePath, ':');             if(wildptr) {                  wildptr++;)                 strcpy(WildStr, wildptr); 
             } 	         } ?             /* if ']' or ':' missing, user wants default dir */    7         if(!strlen(WildStr)) strcpy(WildStr, FilePath);      }    5         /* strip off "';" string if present in esa */         if(!WildFlg) {$         miscptr = strstr(esa, ".;");!         if(miscptr) *miscptr = 0;          strcat(esa, "*.*.*");      }      strcpy(FilePath, esa);   C         /* strip wild info from patn, already saved in 'WildStr' */         if(WildFlg) { *         wildptr = strchr(TargetPath, ']');         if(wildptr) {              wildptr++;             *wildptr = 0; 	         }          else {.             wildptr = strchr(TargetPath, ':');             if(wildptr) {                  wildptr++;                 *wildptr = 0; 
             } 	         }      }    @         /* re-execute sys$parse in case we had a lnm involved */   :     Fab.fab$l_fna = &FilePath;          /* name of file */%     Fab.fab$b_fns = strlen(FilePath);      status = sys$parse(&Fab); +     if(status != RMS$_NORMAL) exit(status);      esa[Nam.nam$b_esl] = '\0';   :         /* get the disk device name for target filepath */        DviPtr = &Nam.nam$t_dvi[1];      strcpy(DevName, DviPtr);"     DevName[Nam.nam$t_dvi[0]] = 0;+     DscDev.dsc$w_length = Nam.nam$t_dvi[0]; =     status = sys$getdviw(0, 0, &DscDev, &DviItm, 0, 0, 0, 0); *     if(status != SS$_NORMAL) exit(status);   7         /* perform sys$search to get number of files */    =     while((status = sys$search(&Fab, 0, 0)) == RMS$_NORMAL) { M         rsa[Nam.nam$b_rsl] = '\0';       /* convert to ASCIZ for debugging */          NumFiles++;      }    H         /* reserve some memory for list of files and the binary times */   7     FileList = calloc(NumFiles + 1, sizeof(FILE_LIST));      ListPtr = FileList; 1     status = sys$assign(&DscDev, &Channel, 0, 0); *     if(status != SS$_NORMAL) exit(status);   6         /* perform sys$parse again to reset context */        status = sys$parse(&Fab); +     if(status != RMS$_NORMAL) exit(status);      esa[Nam.nam$b_esl] = '\0';   %         /* display target filepath */    H     if(WildFlg) printf("\nDirectory %s  (%s)\n\n", TargetPath, WildStr);2     else printf("\nDirectory %s\n\n", TargetPath);   <         /* now get each filename and selected binary time */  *=     while((status = sys$search(&Fab, 0, 0)) == RMS$_NORMAL) {%B         rsa[Nam.nam$b_rsl] = '\0';          /* convert to ASCIZ */I         NamePtr = strchr(rsa, ']');         /* point past dev/dir info */          NamePtr++;D         strcpy(TargetFile, NamePtr);        /* save filename info */2         DscWork.dsc$w_length = strlen(TargetFile);+         DscWork.dsc$a_pointer = TargetFile;   eD             /* clear the entire Fib structure so wildcard operationsE                do not reflect Fib values from a previous file. We are%D                in fact inside a 'while' loop, even if we are working"                on just one file */   %         memset(&Fib, 0, sizeof(Fib));    <             /* init the Fib structure, only need file id and;                directory id fields filled in from Nam block_,                following successful $PARSE*/  s2             /* copy the file ID from Nam to Fib */  c-         Fib.fib$w_fid_num = Nam.nam$w_fid[0];*-         Fib.fib$w_fid_seq = Nam.nam$w_fid[1];a-         Fib.fib$w_fid_rvn = Nam.nam$w_fid[2];r   7             /* copy the directory ID from Nam to Fib */l  d-         Fib.fib$w_did_num = Nam.nam$w_did[0];r-         Fib.fib$w_did_seq = Nam.nam$w_did[1];s-         Fib.fib$w_did_rvn = Nam.nam$w_did[2];    E             /* issue QIOW with IO$_ACCESS to fill primarily the itemsi@                in the ATR structure. This does not open the fileK                so does not change the revision info to current date/time */i  (>         status = sys$qiow(0, Channel, IO$_ACCESS, &Iosb, 0, 0,8                       &DscFib, &DscWork, 0, 0, &Atr, 0);.         if(status != SS$_NORMAL) exit(status);         status = Iosb[0]; .         if(status != SS$_NORMAL) exit(status);  M         switch((int)DateMode) {t             case BACKUP:B                 memcpy(ListPtr->BinTime, &BckBin, sizeof(BckBin));                 break;             case CREATE:B                 memcpy(ListPtr->BinTime, &CreBin, sizeof(CreBin));                 break;             case EXPIRE:B                 memcpy(ListPtr->BinTime, &ExpBin, sizeof(ExpBin));                 break;             case REVISE:B                 memcpy(ListPtr->BinTime, &RevBin, sizeof(RevBin));	         }i.         strcpy(ListPtr->FileName, TargetFile);         ListPtr++;1     }       /* while sys$search == rms$_normal */s  .G         /* sort the array of files in ascending order (oldest first) */c  eD     qsort((void *)FileList, NumFiles, sizeof(FILE_LIST), Date_Sort);  e5         /* now we display the sorted list of files */   *     MaxPtr = ListPtr;i     ListPtr = FileList;         while(ListPtr < MaxPtr) {nI         FormatDateStr();    /* get filedate in selected format (ascii) */ G         if(!LayoutFlg) printf("%s  %-s\n", DateStr, ListPtr->FileName);n'         else {  /* LayoutFlg is TRUE */u1             if(strlen(ListPtr->FileName) >= 31) {*6                 if(TruncFlg) {  /* TruncFlg is TRUE */5                     NamePtr = ListPtr->FileName + 31;t!                     *NamePtr = 0;uE                     printf("%-32s %s\n", ListPtr->FileName, DateStr);x                 }eB                 else printf("%-32s\n%32s %s\n", ListPtr->FileName,"                     " ", DateStr);
             } B             else printf("%-32s %s\n", ListPtr->FileName, DateStr);	         }r         ListPtr++;     }l3         /* print a summary of what just happened */    9     if(!NumFiles) printf(" Target filespec not found\n"); 5     else printf("\nTotal of %d files\n\n", NumFiles); !     status = sys$dassgn(Channel);r }/  h   H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ShowVersC  * Description: Displays current installed version, build date, andIC  *              required privs for interactive usage and/or the VMS    *              install utility.  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowVers()r {f1     printf("\n\t\t%s by Lyle W West\n", CmdVerb);iF     printf("\t\tVersion: %s (%s)\n", VERSION, ARCH ? "Alpha" : "Vax");;     printf("\t\tImage Build: %s (%s)\n", __DATE__, "DecC");[:     printf("\t\tRequired Privs: SYSPRV (or READALL)\n\n");     exit(1); }c  f     eJ /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: Date_SortsD  * Description: Sort routine for qsort. Performs either ascending orG  *              descending sort on binary date from file array. Returnsf,  *              the result of value compare.  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */;1 int Date_Sort(FILE_LIST *file1, FILE_LIST *file2)h {*C     if(!DescendFlg) {     /* ascending order, oldest files first */u<         if(file1->BinTime[1] > file2->BinTime[1]) return(1);         else {A             if(file2->BinTime[1] > file1->BinTime[1]) return(-1);              else {D                 if(file1->BinTime[0] > file2->BinTime[0]) return(1);                 else {I                     if(file2->BinTime[0] > file1->BinTime[0]) return(-1);S#                     else return(0);v                 } 
             }(	         }D     }aB     else {              /* descending order, newest files first */=         if(file1->BinTime[1] > file2->BinTime[1]) return(-1);i         else {@             if(file2->BinTime[1] > file1->BinTime[1]) return(1);             else {E                 if(file1->BinTime[0] > file2->BinTime[0]) return(-1);                  else {H                     if(file2->BinTime[0] > file1->BinTime[0]) return(1);#                     else return(0);2                 }*
             }c	         }r     }r }/     h