 /* **++ **  FACILITY:	MMK  **! **  ABSTRACT:	MMK rules compiler.  ** **  MODULE DESCRIPTION:  **I **  	This program parses the rules in an MMK rules file and converts them E **  into C structures to be compiled and linked into the MMK utility.  ** **  AUTHOR: 	    M. Madison Q **  	    	    COPYRIGHT  1993-1998,2004  MADGOAT SOFTWARE.  ALL RIGHTS RESERVED.  ** **  CREATION DATE:  30-APR-1993  ** **  MODIFICATION HISTORY:  **1 **  	30-APR-1993 V1.0    Madison 	Initial coding. 6 **  	17-OCT-1993 V1.1    Madison 	Update for MMK V2.2.6 **  	14-JUL-1994 V1.2    Madison 	Update for MMK V3.2.8 **  	22-AUG-1994 V1.2-1  Madison 	Update for MMK V3.2-2.C **  	10-JAN-1995 V1.2-2  Madison 	Add put_command (for MMK V3.3-1). 7 **  	21-JUN-1995 V1.3    Madison 	Changes for MMK V3.4. 7 **  	22-DEC-1996 V1.4    Madison 	Changes for MMK V3.6. 2 **  	27-DEC-1998 V1.5    Madison 	General cleanup.? **      03-MAY-2004 V1.6    Madison     Integrate IA64 changes.  **-- */ #define MMKC_VERSION 	"V1.6"\ #define MMKC_COPYRIGHT	"Copyright  1993-1998,2004  MadGoat Software.  All Rights Reserved."  
 #ifdef __DECC - #pragma module MMK_COMPILE_RULES MMKC_VERSION  #else & #module MMK_COMPILE_RULES MMKC_VERSION #endif  )     char $$$Copyright[] = MMKC_COPYRIGHT; @     char *Version = MMKC_VERSION, *Copyright = &$$$Copyright[0];   #include "mmk.h" #include "clidefs.h"   /* ** Forward declarations  */     unsigned int main(void);$     unsigned int put_output(void *);%     unsigned int put_command(void *); ;     static unsigned int cli_get_value(char *, char *, int); ,     static unsigned int cli_present(char *);   /*& ** Globals used throughout the program */   #pragma nostandard+     GLOBAL struct SYMTABLE  global_symbols; *     GLOBAL struct SYMTABLE  local_symbols;,     GLOBAL struct SYMTABLE  cmdline_symbols;,     GLOBAL struct SYMTABLE  builtin_symbols;"     GLOBAL struct RULE      rules;-     GLOBAL struct RULE	    *default_rule = 0; )     GLOBAL struct DEPEND    dependencies; )     GLOBAL struct DEPEND    dep_internal; )     GLOBAL struct DEPEND    dep_deferred; %     GLOBAL struct SFX       suffixes; %     GLOBAL struct CMD       do_first; $     GLOBAL struct CMD       do_last;K     GLOBAL int  	    verify, do_log, did_an_update, noaction, check_status; Q     GLOBAL int	    	    from_sources, force, ignore, use_cms, skip_intermediates; J     GLOBAL int	    	    override_silent, override_ignore, symbol_override;(     GLOBAL unsigned int	    exit_status;)     GLOBAL char	    	    cms$lib[256*16]; 5     GLOBAL char	    	    cms_default_generation[256];  #pragma standard   /* ** External references */) #if defined(__ALPHA) || defined(__ia64__) !     extern mmk_compile_rules_cld;  #else $     globalref mmk_compile_rules_cld; #endif6 #define MMK_COMPILE_RULES_CLD (&mmk_compile_rules_cld)C     void Generate_Structures(char *, char *); /* module GENSTRUC */    /* **++ **  ROUTINE:	main  ** **  FUNCTIONAL DESCRIPTION:  **> **  	Main program.  Fetches the command from the command line,B **  uses CLI$ routines to parse it, then starts the build process. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **	 **  	main  **; **  IMPLICIT INPUTS:	See global definitions at module head.  **< **  IMPLICIT OUTPUTS:	See global definitions at module head. ** **  COMPLETION CODES:  **; **  	SS$_NORMAL, MMK__ALLOK : normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int main (void) {       DESCRIP cmdstr; $     char Output_File[256], tmp[256];"     $DESCRIPTOR(cmdname, "MMKC ");     unsigned int status;
     int i;   /* ** Initialize the globals  *//     for (i = 0; i < MMK_K_SYMTABLE_SIZE; i++) { +     	INIT_QUEUE(global_symbols.symlist[i]); *     	INIT_QUEUE(local_symbols.symlist[i]);,     	INIT_QUEUE(cmdline_symbols.symlist[i]);,     	INIT_QUEUE(builtin_symbols.symlist[i]);     }      INIT_QUEUE(rules);     INIT_QUEUE(dependencies);      INIT_QUEUE(dep_internal);      INIT_QUEUE(dep_deferred);      INIT_QUEUE(suffixes);      INIT_QUEUE(do_first);      INIT_QUEUE(do_last);     exit_status = SS$_NORMAL; E     ignore = override_silent = override_ignore = symbol_override = 0;      skip_intermediates = 0;    /*! ** Fetch and parse command string  */     INIT_DYNDESC(cmdstr); &     status = lib$get_foreign(&cmdstr);"     str$prefix(&cmdstr, &cmdname);:     status = cli$dcl_parse(&cmdstr, MMK_COMPILE_RULES_CLD,(     	    	lib$get_input, lib$get_input);7     if (!OK(status)) return (status | STS$M_INHIB_MSG);    /*, ** Get the command parameters and qualifiers */     Output_File[0] = '\0';0     if (cli_present("OUTPUT") == CLI$_PRESENT) {?     	cli_get_value("OUTPUT", Output_File, sizeof(Output_File));      }   ;     status = cli_get_value("RULES_FILE", tmp, sizeof(tmp)); 5     if (!OK(status)) return status | STS$M_INHIB_MSG;   0     Read_Description(tmp, "SYS$DISK:[].MMS", 1);?     if (OK(exit_status)) Generate_Structures(tmp, Output_File);   )     return exit_status | STS$M_INHIB_MSG;    }    /* **++ **  ROUTINE:	cli_get_value ** **  FUNCTIONAL DESCRIPTION:  **" **  	C Interface to CLI$GET_VALUE. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **0 **  	cli_get_value (char *argname, DESCRIP *arg) **1 ** argname: ASCIZ_string, read only, by reference < ** arg:	    char_string, write only, by descriptor (dynamic) ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  **2 **  	All those from CLI$PRESENT and CLI$GET_VALUE. ** **  SIDE EFFECTS:   	None. ** **-- */K static unsigned int cli_get_value (char *argname, char *arg, int argsize) {        DESCRIP argnamd, argd;     unsigned short arglen;     int status;   2     INIT_SDESC(argnamd, strlen(argname), argname);%     INIT_SDESC(argd, argsize-1, arg); #     status = cli$present(&argnamd); &     if ($VMS_STATUS_SUCCESS(status)) {6     	status = cli$get_value(&argnamd, &argd, &arglen);*     	if (OK(status)) *(arg+arglen) = '\0';     }      return status; }    /* **++ **  ROUTINE:	put_output  ** **  FUNCTIONAL DESCRIPTION:  **: **  	LIB$PUT_OUTPUT replacement that directs things either6 **  to SYS$OUTPUT or to the file specified in /OUTPUT. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **+ **  	put_output(struct dsc$descriptor *dsc)  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */% unsigned int put_output (void *dsc) {        return lib$put_output(dsc);    } /* put_output */   /* **++ **  ROUTINE:	put_command ** **  FUNCTIONAL DESCRIPTION:  **: **  	LIB$PUT_OUTPUT replacement that directs things eitherE **  to SYS$OUTPUT or to the file specified in /OUTPUT (for commands).  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **, **  	put_command(struct dsc$descriptor *dsc) ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */& unsigned int put_command (void *dsc) {       return lib$put_output(dsc);    } /* put_output */   /* **++ **  ROUTINE:	cli_present ** **  FUNCTIONAL DESCRIPTION: ! **                                  **  	C Interface to CLI$PRESENT. **A **  RETURNS:	cond_value, intword (unsigned), write only, by value  ** **  PROTOTYPE: **  **  	cli_present (char *argname) **1 ** argname: ASCIZ_string, read only, by reference  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  **  **  	All those from CLI$PRESENT. ** **  SIDE EFFECTS:   	None. ** **-- */1 static unsigned int cli_present (char *argname) {        DESCRIP argnamd;  2     INIT_SDESC(argnamd, strlen(argname), argname);!     return cli$present(&argnamd);  } 