
/*  @(#)mp.h 1.6 90/08/17
 *
 *  Contains all the global definitions used by mp.
 *
 *  Copyright (c) Steve Holden and Rich Burridge.
 *                All rights reserved.
 *
 *  Permission is given to distribute these sources, as long as the
 *  copyright messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if
 *  reported to me then an attempt will be made to fix them.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#ifndef VMS
#include <sys/param.h>
#include <pwd.h>
#endif
#include <ctype.h>
#include <time.h>

#ifdef   SYSV
#include <sys/pathname.h>
#include <string.h>
#endif /*SYSV*/

#define  FCLOSE       (void) fclose
#define  FPRINTF      (void) fprintf
#define  FPUTS        (void) fputs
#define  PRINTF       (void) printf
#define  PUTC         (void) putc
#define  SPRINTF      (void) sprintf
#define  SSCANF       (void) sscanf
#define  STRCPY       (void) strcpy
#define  STRNCPY      (void) strncpy
#define  UNGETC       (void) ungetc

/* Configuration constants */

#ifndef  PROLOGUE            /* PostScript prologue file */
#ifdef VMS
#define  PROLOGUE     "MP_PS_DIR:"
#else
#define  PROLOGUE     "/usr/local/lib"
#endif /* VMS */
#endif /*PROLOGUE*/

#define  EQUAL(val)   (!strncmp(val, nextline, strlen(val)))
#define  INC          argc-- ; argv++ ;

#if defined(NOINDEX) || defined(VMS)
#define  index        strchr
#endif /*NOINDEX*/

#define  LINELENGTH   80     /* Number of characters per line. */

#ifndef  MAXPATHLEN
#define  MAXPATHLEN   1024
#endif /*MAXPATHLEN*/

#define  MAXSIZES     4      /* Maximum number of different sizes. */

#define  NAMELENGTH   18     /* Maximum allowable real user name. */
#define  PAGELENGTH   60     /* Number of lines per page. */
#define  MAXCONT      10     /* Maximum no of continuation header lines */
#define  MAXLINE      256    /* Maximum string length. */
 
#ifndef TRUE
#define TRUE          1
#define FALSE         0
#endif  /*TRUE*/
 
typedef enum {DO_MAIL, DO_NEWS, DO_TEXT} document_type ;
typedef char bool ;

#ifndef VMS
time_t time() ;
struct tm *localtime() ;
bool emptyline() ;
FILE *fopen() ;
void exit() ;
char *asctime(), *getenv(), *getlogin(), *gets(), *index(), *malloc() ;
char *realloc(), *sprintf(), *strchr(), *strcpy(), *strncpy() ;
#endif

void do_date(), get_header(), get_mult_hdr(), init_setup() ;
void parse_headers(), readline(), reset_headers(), set_defs() ;
void show_headers(), show_mult_hdr() ;
