 /* PROGRAM DESCRIPTION:?   This program is used to maintain the VMSMAIL_PROFILE.DAT file +   which handles the forwarding for VMSMAIL.  AUTHORS:   W. Eric Wentz    V. Edward James  CREATION DATE:   7-Jan-1986           C H A N G E   L O G%      Date     |   Name  | Description P --------------+---------+------------------------------------------------------- %[change_entry]%O  3-Aug-1991       James   Changed to use callable mail routines instead of file H 18-Nov-1991       James   Changed to SMG$ routines to add command recall@ 19-Oct-1993       James   Removed use of WRITEV with Output_LineB 16-Feb-1994       James   Converted to C with help of P2C program. */  * #define VERSION         "4.2 (9504251650)"   #include "mailuaf.h"   #ifdef MAILMSGDEF_NOT_IN_SYSLIB  #include "mailmsgdef.h"  #else  #include <mailmsgdef.h>  #endif   #ifndef HELPLIB_NAME #define HELPLIB_NAME "MAILUAF" #endif  ' unsigned int keyboard_id, key_table_id;    char user[MAX_USERNAME+1]; char forward[NAM$C_MAXRSS+1];  char directory[NAM$C_MAXRSS+1];  char personal[NAM$C_MAXRSS+1]; char editor[NAM$C_MAXRSS+1]; char form[NAM$C_MAXRSS+1]; char queue[NAM$C_MAXRSS+1];    $DESCRIPTOR( user_id, "USER"); $DESCRIPTOR( user_desc, user);$ $DESCRIPTOR( forward_id, "FORWARD");$ $DESCRIPTOR( forward_desc, forward);( $DESCRIPTOR( directory_id, "DIRECTORY");( $DESCRIPTOR( directory_desc, directory);& $DESCRIPTOR( personal_id, "PERSONAL");& $DESCRIPTOR( personal_desc, personal);" $DESCRIPTOR( editor_id, "EDITOR");" $DESCRIPTOR( editor_desc, editor); $DESCRIPTOR( form_id, "FORM"); $DESCRIPTOR( form_desc, form);  $DESCRIPTOR( queue_id, "QUEUE");  $DESCRIPTOR( queue_desc, queue);& $DESCRIPTOR( messages_id, "MESSAGES"); $DESCRIPTOR( copy_id, "COPY");( $DESCRIPTOR( cc_prompt_id, "CC_PROMPT");( $DESCRIPTOR( autopurge_id, "AUTOPURGE");$ $DESCRIPTOR( version_id, "VERSION");  $DESCRIPTOR( topic_id, "TOPIC"); $DESCRIPTOR( all_id, "ALL");$ $DESCRIPTOR( line_no_id, "LINE_NO");   $DESCRIPTOR( full_id, "FULL");  $DESCRIPTOR( brief_id, "BRIEF");  $DESCRIPTOR( inuse_id, "INUSE");   short messages = 0; C boolean cc_prompt, auto_purge, self_send, self_reply, self_forward;   D long user_len, forward_len, directory_len, personal_len, editor_len,      form_len, queue_len;   E long cc_prompt_val,    auto_purge_val, self_send_val, self_reply_val,       self_forward_val;  C boolean forward_modified,   directory_modified,  personal_modified, @         editor_modified,    form_modified,       queue_modified,E         messages_modified,  cc_prompt_modified,  auto_purge_modified, G         self_send_modified, self_reply_modified, self_forward_modified;    unsigned int user_context = 0;  
 #ifdef __DECC  #pragma extern_model save   #pragma extern_model globalvalue extern MAILUAF_TABLE;  #pragma extern_model restore #else  globalvalue MAILUAF_TABLE; #endif   char workstr[NAM$C_MAXRSS+1]; $ $DESCRIPTOR( workstr_desc, workstr);) char initial_string[NAM$C_MAXRSS+1] = ""; 2 $DESCRIPTOR( initial_string_desc, initial_string);I boolean show_full_qualifier,  show_inuse_qualifier, show_brief_qualifier; ( ITEMLIST null_item_list[] = {{0,0,0,0}};F ITEMLIST user_name_item_list[] = {{ 0, MAIL$_USER_USERNAME, &user, 0},=                                   { 0, MAIL$_NOSIGNAL, 0, 0}, 1                                   { 0, 0, 0, 0}}; @ ITEMLIST first_user_item_list[] = {{ 0, MAIL$_USER_FIRST, 0, 0},>                                    { 0, MAIL$_NOSIGNAL, 0, 0},2                                    { 0, 0, 0, 0}};> ITEMLIST next_user_item_list[] = {{ 0, MAIL$_USER_NEXT, 0, 0},=                                   { 0, MAIL$_NOSIGNAL, 0, 0}, 1                                   { 0, 0, 0, 0}}; 7 ITEMLIST full_item_list[] = {{ 0, 0, &user, &user_len}, =                              { 0, 0, &forward, &forward_len}, A                              { 0, 0, &directory, &directory_len}, ?                              { 0, 0, &personal, &personal_len}, ;                              { 0, 0, &editor, &editor_len}, 7                              { 0, 0, &form, &form_len}, 9                              { 0, 0, &queue, &queue_len}, @                              { 2, 0, (char (*)[]) &messages, 0},E                              { 4, 0, (char (*)[]) &cc_prompt_val, 0}, F                              { 4, 0, (char (*)[]) &auto_purge_val, 0},E                              { 4, 0, (char (*)[]) &self_send_val, 0}, F                              { 4, 0, (char (*)[]) &self_reply_val, 0},H                              { 4, 0, (char (*)[]) &self_forward_val, 0},+                              { 0, 0, 0, 0}, ,                              { 0, 0, 0, 0}}; ITEMLIST short_item_list[] = {H                      { 0, MAIL$_USER_RETURN_USERNAME, &user, &user_len},I                      { 0, MAIL$_USER_FORWARDING, &forward, &forward_len}, $                      { 0, 0, 0, 0}};  N /*==========================================================================*/ int add_user( void)  {     unsigned int istat;  )    user_desc.dsc$w_length = MAX_USERNAME; A    cli$get_value( &user_id, &user_desc, &user_desc.dsc$w_length); '    user[user_desc.dsc$w_length] = '\0'; C    user_name_item_list[NAME_USER].bufflen = user_desc.dsc$w_length; %    user_len = user_desc.dsc$w_length; !    set_full_item_list_for_show(); ?    istat = get_user_info( user_name_item_list, full_item_list);     if( istat & 1) { 7       printf( "User %s record already exists\n", user); 8       /* %X000182A2 %RMS-E-REX, record already exists */)       istat = RMS$_REX | INHIBIT_MESSAGE;     }	    else { P       if( istat != MAIL$_NOSUCHUSR) { /* MAIL$_NOSUCHUSR = 8290346 %X007E802A */          lib$stop( istat);       }        else {          if( get_cli_info()) {,             set_full_item_list_for_modify();G             full_item_list[FULL_CREATE_IF].code = MAIL$_USER_CREATE_IF; '             istat = mail$user_set_info( D                      &user_context, full_item_list, null_item_list);             check( istat);-             printf( "User %s added\n", user); 
          }          else { D             printf( "User %s not added, field(s) required\n", user);3             istat = SS$_BADPARAM | INHIBIT_MESSAGE; 
          }       }     }    return istat; }  /* end of add_user */  N /*==========================================================================*/ void check_full_or_brief( void)  { 0    if( cli$present( &full_id) == CLI$_PRESENT) {!       show_full_qualifier = TRUE;     }	    else { "       show_full_qualifier = FALSE;    }1    if( cli$present( &brief_id) == CLI$_PRESENT) { "       show_brief_qualifier = TRUE;    }	    else { #       show_brief_qualifier = FALSE;     }1    if( cli$present( &inuse_id) == CLI$_PRESENT) { "       show_inuse_qualifier = TRUE;    }	    else { #       show_inuse_qualifier = FALSE;     }# }  /* end of check_full_or_brief */   N /*==========================================================================*/! void create_smg_structures( void)  {     long status, attributes; '    $DESCRIPTOR( find_key_name, "FIND"); .    $DESCRIPTOR( find_key_equiv, "RECALL/ALL");+    $DESCRIPTOR( select_key_name, "SELECT"); -    $DESCRIPTOR( select_key_equiv, "RECALL "); '    $DESCRIPTOR( help_key_name, "HELP"); )    $DESCRIPTOR( help_key_equiv, "HELP "); #    $DESCRIPTOR( do_key_name, "DO"); "    $DESCRIPTOR( do_key_equiv, "");1    unsigned char recall_lines = MAX_RECALL_LINES;   O    status = smg$create_virtual_keyboard( &keyboard_id, 0, 0, 0, &recall_lines);     check( status);1    status = smg$create_key_table( &key_table_id);     check( status);$    attributes = SMG$M_KEY_TERMINATE;    status = smg$add_key_def(L             &key_table_id, &find_key_name, 0, &attributes, &find_key_equiv);    check( status);    attributes = 0;    status = smg$add_key_def(P             &key_table_id, &select_key_name, 0, &attributes, &select_key_equiv);    check( status);    status = smg$add_key_def(L             &key_table_id, &help_key_name, 0, &attributes, &help_key_equiv);    check( status);$    attributes = SMG$M_KEY_TERMINATE;    status = smg$add_key_def(H             &key_table_id, &do_key_name, 0, &attributes, &do_key_equiv);    check( status);% }  /* end of create_smg_structures */   N /*==========================================================================*/! void delete_smg_structures( void)  {   /* don't erase screen */    long status;   7    status = smg$delete_virtual_keyboard( &keyboard_id);     check( status);% }  /* end of delete_smg_structures */   N /*==========================================================================*/ void display_user( void) {    #define MAX_FAO_STR       132       unsigned int istat;      if( directory_len != 0) {?       printf( "User %s subdirectory is %s\n", user, directory);     }	    else {         if( show_full_qualifier) {?          printf( "User %s has not set a subdirectory\n", user);        }     }-    if( messages > 0 || show_full_qualifier) { ?       printf( "User %s has %d new messages\n", user, messages);     }    if( forward_len != 0) {C       printf( "User %s forwarding address is %s\n", user, forward);     }	    else {         if( show_full_qualifier) {E          printf( "User %s has not set a forwarding address\n", user);        }     }    if( personal_len != 0) { C       printf( "User %s personal name is \"%s\"\n", user, personal);     }	    else {         if( show_full_qualifier) {@          printf( "User %s has not set a personal name\n", user);       }     }    if( editor_len != 0) { 6       printf( "User %s editor is %s\n", user, editor);    }	    else {         if( show_full_qualifier) {:          printf( "User %s has not set an editor\n", user);       }     }*    if( cc_prompt || show_full_qualifier) {       if( cc_prompt) {=          printf( "User %s has cc prompting enabled\n", user);        }        else {>          printf( "User %s has cc prompting disabled\n", user);       }     }H    if( self_send || self_reply || self_forward || show_full_qualifier) {4       if( self_send || self_reply || self_forward) {9          if( self_send && !self_reply && !self_forward) { L             printf( "User %s has automatic copies to self on send\n", user);
          }9          if( !self_send && self_reply && !self_forward) { M             printf( "User %s has automatic copies to self on reply\n", user); 
          }9          if( !self_send && !self_reply && self_forward) { O             printf( "User %s has automatic copies to self on forward\n", user); 
          }8          if( self_send && self_reply && !self_forward) {K             printf( "User %s has automatic copies to self on send,reply\n",                     user); 
          }8          if( self_send && !self_reply && self_forward) {M             printf( "User %s has automatic copies to self on send,forward\n",                     user); 
          }8          if( !self_send && self_reply && self_forward) {N             printf( "User %s has automatic copies to self on reply,forward\n",                    user); 
          }7          if( self_send && self_reply && self_forward) {              printf( N                "User %s has automatic copies to self on send,reply,forward\n",                user); 
          }       }        else {J          printf( "User %s has automatic copies to self disabled\n", user);       }     }+    if( auto_purge || show_full_qualifier) {        if( auto_purge) { P          printf( "User %s has automatic deleted message purge enabled\n", user);       }        else {J          printf( "User %s has automatic deleted message purge disabled\n",                 user);       }     }    if( queue_len != 0) {B       printf( "User %s default print queue is %s\n", user, queue);    }	    else {         if( show_full_qualifier) {F          printf( "User %s has not set a default print queue\n", user);       }     }    if( form_len != 0) { @       printf( "User %s default print form is %s\n", user, form);    }	    else {         if( show_full_qualifier) {E          printf( "User %s has not set a default print form\n", user);        }     } #undef MAX_FAO_STR }  /* end of display_user */  N /*==========================================================================*/ void done( void) {     unsigned int istat;  I    istat = mail$user_end( &user_context, null_item_list, null_item_list);     check( istat);     delete_smg_structures();     exit( EXIT_SUCCESS);  }  /* end of done */  N /*==========================================================================*/ boolean get_cli_info( void)  {     boolean modified;    unsigned int istat, jstat;       forward_modified = FALSE;    directory_modified = FALSE;    personal_modified = FALSE;     editor_modified = FALSE;     form_modified = FALSE;     queue_modified = FALSE;    messages_modified = FALSE;     cc_prompt_modified = FALSE;    auto_purge_modified = FALSE;     self_send_modified = FALSE;    self_reply_modified = FALSE; !    self_forward_modified = FALSE;     modified = FALSE;%    istat = cli$present( &forward_id);     if( istat == CLI$_PRESENT) { /       forward_desc.dsc$w_length = NAM$C_MAXRSS; M       cli$get_value( &forward_id, &forward_desc, &forward_desc.dsc$w_length); 0       forward[forward_desc.dsc$w_length] = '\0';.       forward_len = forward_desc.dsc$w_length;       forward_modified = TRUE;       modified = TRUE;    }    if( istat == CLI$_NEGATED) {        forward_len = 0;       forward_modified = TRUE;       modified = TRUE;    }  '    istat = cli$present( &directory_id);     if( istat == CLI$_PRESENT) { 1       directory_desc.dsc$w_length = NAM$C_MAXRSS;        cli$get_value(G          &directory_id, &directory_desc, &directory_desc.dsc$w_length); 4       directory[directory_desc.dsc$w_length] = '\0';2       directory_len = directory_desc.dsc$w_length;        directory_modified = TRUE;       modified = TRUE;    }    if( istat == CLI$_NEGATED) {        directory_len = 0;        directory_modified = TRUE;       modified = TRUE;    }  &    istat = cli$present( &personal_id);    if( istat == CLI$_PRESENT) { 0       personal_desc.dsc$w_length = NAM$C_MAXRSS;P       cli$get_value( &personal_id, &personal_desc, &personal_desc.dsc$w_length);2       personal[personal_desc.dsc$w_length] = '\0';0       personal_len = personal_desc.dsc$w_length;       personal_modified = TRUE;        modified = TRUE;    }    if( istat == CLI$_NEGATED) {        personal_len = 0;        personal_modified = TRUE;        modified = TRUE;    }  $    istat = cli$present( &editor_id);    if( istat == CLI$_PRESENT) { .       editor_desc.dsc$w_length = NAM$C_MAXRSS;J       cli$get_value( &editor_id, &editor_desc, &editor_desc.dsc$w_length);.       editor[editor_desc.dsc$w_length] = '\0';,       editor_len = editor_desc.dsc$w_length;       editor_modified = TRUE;        modified = TRUE;    }    if( istat == CLI$_NEGATED) {        editor_len = 0;        editor_modified = TRUE;        modified = TRUE;    }  "    istat = cli$present( &form_id);    if( istat == CLI$_PRESENT) { ,       form_desc.dsc$w_length = NAM$C_MAXRSS;D       cli$get_value( &form_id, &form_desc, &form_desc.dsc$w_length);*       form[form_desc.dsc$w_length] = '\0';(       form_len = form_desc.dsc$w_length;       form_modified = TRUE;        modified = TRUE;    }    if( istat == CLI$_NEGATED) {        form_len = 0;        form_modified = TRUE;        modified = TRUE;    }  #    istat = cli$present( &queue_id);     if( istat == CLI$_PRESENT) { -       queue_desc.dsc$w_length = NAM$C_MAXRSS; G       cli$get_value( &queue_id, &queue_desc, &queue_desc.dsc$w_length); ,       queue[queue_desc.dsc$w_length] = '\0';*       queue_len = queue_desc.dsc$w_length;       queue_modified = TRUE;       modified = TRUE;    }    if( istat == CLI$_NEGATED) {        queue_len = 0;       queue_modified = TRUE;       modified = TRUE;    }  &    istat = cli$present( &messages_id);    if( istat == CLI$_PRESENT) { /       workstr_desc.dsc$w_length = NAM$C_MAXRSS; N       cli$get_value( &messages_id, &workstr_desc, &workstr_desc.dsc$w_length);0       workstr[workstr_desc.dsc$w_length] = '\0';(       sscanf( workstr, "%d", &messages);       messages_modified = TRUE;        modified = TRUE;    }    if( istat == CLI$_NEGATED) {R       messages = 0;        messages_modified = TRUE;t       modified = TRUE;    }  "    istat = cli$present( &copy_id);    if( istat == CLI$_PRESENT) { 
       do {2          workstr_desc.dsc$w_length = NAM$C_MAXRSS;U          jstat = cli$get_value( &copy_id, &workstr_desc, &workstr_desc.dsc$w_length);-3          workstr[workstr_desc.dsc$w_length] = '\0';[E          /* cli$parse checks that options are valid from list in cld,rG             so now can just check for first letter, which is unique. */n.          if( strncmp( workstr, "S", 1) == 0) {             self_send = TRUE;O&             self_send_modified = TRUE;
          }0          if( strncmp( workstr, "NOS", 3) == 0) {             self_send = FALSE;&             self_send_modified = TRUE;
          }.          if( strncmp( workstr, "R", 1) == 0) {             self_reply = TRUE;'             self_reply_modified = TRUE;L
          }0          if( strncmp( workstr, "NOR", 3) == 0) {             self_reply = FALSE;r'             self_reply_modified = TRUE;M
          }.          if( strncmp( workstr, "F", 1) == 0) {              self_forward = TRUE;)             self_forward_modified = TRUE; 
          }0          if( strncmp( workstr, "NOF", 3) == 0) {!             self_forward = FALSE;")             self_forward_modified = TRUE;D
          }%       } while( jstat != CLI$_ABSENT);(8       if( !self_send_modified && !self_reply_modified &&#           !self_forward_modified) {cD          /* CLI$_ABSENT was returned on first call to cli$get_value.L             /copy was specified without list (no send, reply, or forward) */          self_send = TRUE;#          self_send_modified = TRUE;e          self_reply = TRUE; $          self_reply_modified = TRUE;          self_forward = TRUE;i&          self_forward_modified = TRUE;       }O       modified = TRUE;    }    if( istat == CLI$_NEGATED) {p       self_send = FALSE;        self_send_modified = TRUE;       self_reply = FALSE; !       self_reply_modified = TRUE;S       self_forward = FALSE; #       self_forward_modified = TRUE;h       modified = TRUE;    }  '    istat = cli$present( &cc_prompt_id);     if( istat == CLI$_PRESENT) {f       cc_prompt = TRUE;,        cc_prompt_modified = TRUE;       modified = TRUE;    }    if( istat == CLI$_NEGATED) {s       cc_prompt = FALSE;        cc_prompt_modified = TRUE;       modified = TRUE;    }  '    istat = cli$present( &autopurge_id);     if( istat == CLI$_PRESENT) {e       auto_purge = TRUE;!       auto_purge_modified = TRUE;p       modified = TRUE;    }    if( istat == CLI$_NEGATED) {        auto_purge = FALSE;o!       auto_purge_modified = TRUE;e       modified = TRUE;    }    return modified;d }  /* end of get_cli_info */  N /*==========================================================================*/N unsigned int get_user_info( ITEMLIST in_item_list[], ITEMLIST out_item_list[]) {r    unsigned int istat;  H    /* user_len must be set to correct value before calling get_user_infoC       if search on specific user.  user_len must be set to 0 beforew>       calling get_user_info if generic search (first,next). */    forward_len = 0;_    directory_len = 0;E    personal_len = 0;    editor_len = 0;    form_len = 0;    queue_len = 0;0K    istat = mail$user_get_info( &user_context, in_item_list, out_item_list);e    if( istat & 1) {        user[user_len] = '\0';(       user_desc.dsc$w_length = user_len;"       forward[forward_len] = '\0';.       forward_desc.dsc$w_length = forward_len;&       directory[directory_len] = '\0';2       directory_desc.dsc$w_length = directory_len;$       personal[personal_len] = '\0';0       personal_desc.dsc$w_length = personal_len;        editor[editor_len] = '\0';,       editor_desc.dsc$w_length = editor_len;       form[form_len] = '\0';(       form_desc.dsc$w_length = form_len;       queue[queue_len] = '\0';*       queue_desc.dsc$w_length = queue_len;       if( cc_prompt_val & 1) {          cc_prompt = TRUE;       }e       else {          cc_prompt = FALSE;&       }r       if( auto_purge_val & 1) {           auto_purge = TRUE;e       }        else {          auto_purge = FALSE;       }e       if( self_send_val & 1) {          self_send = TRUE;       }v       else {          self_send = FALSE;        }(       if( self_reply_val & 1) {           self_reply = TRUE;,       })       else {          self_reply = FALSE;       } !       if( self_forward_val & 1) {a          self_forward = TRUE;        }        else {          self_forward = FALSE;       }     }    return istat; }  /* end of get_user_info */   N /*==========================================================================*/ void help_user( void)  {e    unsigned int istat;*    $DESCRIPTOR( helplib_id, HELPLIB_NAME);  %    istat = cli$present( &version_id);     if( istat == CLI$_PRESENT) {=/       printf( "MAILUAF version %s\n", VERSION);=    },    workstr_desc.dsc$w_length = NAM$C_MAXRSS;H    cli$get_value( &topic_id, &workstr_desc, &workstr_desc.dsc$w_length);-    workstr[workstr_desc.dsc$w_length] = '\0';n    istat = lbr$output_help($/       &lib$put_output,     /* output routine */S>       0,                   /* output width - defaults to 80 *//       &workstr_desc,       /* input key desc */ J       &helplib_id,         /* library name desc Defaults: SYS$HELP:.HLB */&       0,                   /* flags */.       &mailuaf_get_input); /* input routine */    check( istat);o }  /* end of help_user */   N /*==========================================================================*/ void list_users( void) {U    unsigned int istat;      check_full_or_brief();;P    if( !show_full_qualifier && !show_brief_qualifier && !show_inuse_qualifier) {"       show_brief_qualifier = TRUE;    }    if( show_brief_qualifier) {L       printf( "%-*s%s\n", MAX_USERNAME+1, "Username", "Forwarding Address");L       printf( "%-*s%s\n", MAX_USERNAME+1, "--------", "------------------");       set_short_item_list();       user_len = 0; D       istat = get_user_info( first_user_item_list, short_item_list);    }	    else {e$       set_full_item_list_for_show();       user_len = 0;SC       istat = get_user_info( first_user_item_list, full_item_list);d    }    check( istat);=    do {=!       if( show_brief_qualifier) {=           if( forward_len != 0) {?             printf( "%-*s%s\n", MAX_USERNAME+1, user, forward);S
          }          user_len = 0;F          istat = get_user_info( next_user_item_list, short_item_list);       }e       else {          display_user();          user_len = 0;E          istat = get_user_info( next_user_item_list, full_item_list);        }i       if( !( istat & 1)) {5          /* MAIL$_NOMOREREC = 8314792 (%X007EDFA8) */ (          if( istat != MAIL$_NOMOREREC) {             lib$stop( istat);k
          }       } *    } while( istat & 1);   /* list_users */ }  /* end of list_users */  N /*==========================================================================*/ int modify_user( void) {"    unsigned int istat;  )    user_desc.dsc$w_length = MAX_USERNAME;TA    cli$get_value( &user_id, &user_desc, &user_desc.dsc$w_length); '    user[user_desc.dsc$w_length] = '\0';mC    user_name_item_list[NAME_USER].bufflen = user_desc.dsc$w_length;T%    user_len = user_desc.dsc$w_length;R!    set_full_item_list_for_show();h?    istat = get_user_info( user_name_item_list, full_item_list);r    if( istat & 1) {a       if( get_cli_info()) {))          set_full_item_list_for_modify();a3          istat = mail$user_set_info( &user_context, ,             full_item_list, null_item_list);          check( istat); -          printf( "User %s modified\n", user);u       }d    }	    else {c2       /* MAIL$_NOSUCHUSR = 8290346 (%X007E802A) */%       if( istat != MAIL$_NOSUCHUSR) {,          lib$stop( istat);       }e7       printf( "User %s record does not exist\n", user);_)       istat = RMS$_RNF | INHIBIT_MESSAGE;k    }    return istat; }  /* end of modify_user */   N /*==========================================================================*/H unsigned int mailuaf_get_input( struct dsc$descriptor *resultant_string,E                                 struct dsc$descriptor *prompt_string,=A                                 unsigned short *resultant_length)o {d    unsigned int istat;    unsigned short term_code;  >    initial_string_desc.dsc$w_length = strlen( initial_string);?    istat = smg$read_composed_line( &keyboard_id, &key_table_id,u,             resultant_string, prompt_string,,             &resultant_string->dsc$w_length,=             0, 0, &initial_string_desc, 0, 0, 0, &term_code);     if( istat & 1) {s       istat = SS$_NORMAL;n       *initial_string = '\0';s    }	    else {%       if( istat != SMG$_EOF) {          lib$stop( istat);       }f       istat = RMS$_EOF;"    }    return istat;! }  /* end of mailuaf_get_input */   N /*==========================================================================*/ void recall_line( void)s {e    unsigned int istat;    long ii;{  !    istat = cli$present( &all_id);d    if( istat == CLI$_PRESENT) { 4       istat = smg$replace_input_line( &keyboard_id);       check( istat);2       for( ii = 1; ii <= MAX_RECALL_LINES; ii++) {9          initial_string_desc.dsc$w_length = NAM$C_MAXRSS;eK          istat = smg$return_input_line( &keyboard_id, &initial_string_desc,f=                   0, &ii, &initial_string_desc.dsc$w_length);           check( istat);;A          initial_string[initial_string_desc.dsc$w_length] = '\0';s'          if( *initial_string != '\0') { 5             printf( "%3ld %s\n", ii, initial_string);i
          }       }        *initial_string = '\0';     }	    else {c(       istat = cli$present( &line_no_id);"       if( istat == CLI$_PRESENT) {2          workstr_desc.dsc$w_length = NAM$C_MAXRSS;P          cli$get_value( &line_no_id, &workstr_desc, &workstr_desc.dsc$w_length);3          workstr[workstr_desc.dsc$w_length] = '\0';f          check( istat);l7          istat = smg$replace_input_line( &keyboard_id);r          check( istat);e          ii = 0;&          sscanf( workstr, "%ld", &ii);0          if( 0 < ii && ii <= MAX_RECALL_LINES) {<             initial_string_desc.dsc$w_length = NAM$C_MAXRSS;N             istat = smg$return_input_line( &keyboard_id, &initial_string_desc,=                   0, &ii, &initial_string_desc.dsc$w_length);f          check( istat); D             initial_string[initial_string_desc.dsc$w_length] = '\0';
          }       }     } }  /* end of recall_line */r  N /*==========================================================================*/ int remove_user( void) { !    boolean save_full, save_inuse;     unsigned int istat;  )    user_desc.dsc$w_length = MAX_USERNAME;rA    cli$get_value( &user_id, &user_desc, &user_desc.dsc$w_length); '    user[user_desc.dsc$w_length] = '\0'; C    user_name_item_list[NAME_USER].bufflen = user_desc.dsc$w_length;n%    user_len = user_desc.dsc$w_length;l!    set_full_item_list_for_show(); ?    istat = get_user_info( user_name_item_list, full_item_list);&    if( istat & 1) { G       printf( "***************************************************\n");o@       printf( "User %s had the following information:\n", user);&       save_full = show_full_qualifier;(       save_inuse = show_inuse_qualifier;!       show_full_qualifier = TRUE;(#       show_inuse_qualifier = FALSE;        display_user(); &       show_full_qualifier = save_full;(       show_inuse_qualifier = save_inuse;G       printf( "***************************************************\n");e$       istat = mail$user_delete_info(C                &user_context, user_name_item_list, null_item_list);f       check( istat);)       printf( "User %s removed\n", user);e    }	    else { 2       /* MAIL$_NOSUCHUSR = 8290346 (%x007e802a) */%       if( istat != MAIL$_NOSUCHUSR) {r          lib$stop( istat);       }=7       printf( "User %s record does not exist\n", user);")       istat = RMS$_RNF | INHIBIT_MESSAGE;     }    return istat; }  /* end of remove_user */   N /*==========================================================================*/) void set_full_item_list_for_modify( void)= {=0    full_item_list[FULL_USER].bufflen = user_len;8    full_item_list[FULL_USER].code = MAIL$_USER_USERNAME;    if( forward_modified) {       if( forward_len != 0) {l<          full_item_list[FULL_FORWARD].bufflen = forward_len;G          full_item_list[FULL_FORWARD].code = MAIL$_USER_SET_FORWARDING;=       }=       else {J          full_item_list[FULL_FORWARD].code = MAIL$_USER_SET_NO_FORWARDING;       }f    }	    else { 5       full_item_list[FULL_FORWARD].code = MAIL$_NOOP;d    }    if( directory_modified) {       if( directory_len != 0) {_@          full_item_list[FULL_DIRECTORY].bufflen = directory_len;L          full_item_list[FULL_DIRECTORY].code = MAIL$_USER_SET_SUB_DIRECTORY;       }_       else {O          full_item_list[FULL_DIRECTORY].code = MAIL$_USER_SET_NO_SUB_DIRECTORY;o       }i    }	    else { 7       full_item_list[FULL_DIRECTORY].code = MAIL$_NOOP;     }    if( personal_modified) {        if( personal_len != 0) {>          full_item_list[FULL_PERSONAL].bufflen = personal_len;K          full_item_list[FULL_PERSONAL].code = MAIL$_USER_SET_PERSONAL_NAME;'       }        else {N          full_item_list[FULL_PERSONAL].code = MAIL$_USER_SET_NO_PERSONAL_NAME;       }}    }	    else { 6       full_item_list[FULL_PERSONAL].code = MAIL$_NOOP;    }    if( editor_modified) {=       if( editor_len != 0) {:          full_item_list[FULL_EDITOR].bufflen = editor_len;B          full_item_list[FULL_EDITOR].code = MAIL$_USER_SET_EDITOR;       }        else {E          full_item_list[FULL_EDITOR].code = MAIL$_USER_SET_NO_EDITOR;r       }r    }	    else {t4       full_item_list[FULL_EDITOR].code = MAIL$_NOOP;    }    if( form_modified) {i       if( form_len != 0) {6          full_item_list[FULL_FORM].bufflen = form_len;>          full_item_list[FULL_FORM].code = MAIL$_USER_SET_FORM;       };       else {A          full_item_list[FULL_FORM].code = MAIL$_USER_SET_NO_FORM;        }e    }	    else {_2       full_item_list[FULL_FORM].code = MAIL$_NOOP;    }    if( queue_modified) {       if( queue_len != 0) {e8          full_item_list[FULL_QUEUE].bufflen = queue_len;@          full_item_list[FULL_QUEUE].code = MAIL$_USER_SET_QUEUE;       }        else {C          full_item_list[FULL_QUEUE].code = MAIL$_USER_SET_NO_QUEUE;        }s    }	    else {R3       full_item_list[FULL_QUEUE].code = MAIL$_NOOP;p    }    if( messages_modified) {=G       full_item_list[FULL_MESSAGES].code = MAIL$_USER_SET_NEW_MESSAGES;     }	    else {d6       full_item_list[FULL_MESSAGES].code = MAIL$_NOOP;    }    if( cc_prompt_modified) {       if( cc_prompt) {H          full_item_list[FULL_CC_PROMPT].code = MAIL$_USER_SET_CC_PROMPT;       };       else {K          full_item_list[FULL_CC_PROMPT].code = MAIL$_USER_SET_NO_CC_PROMPT;R       }     }	    else {;7       full_item_list[FULL_CC_PROMPT].code = MAIL$_NOOP;t    }    if( auto_purge_modified) {.       if( auto_purge) {SJ          full_item_list[FULL_AUTO_PURGE].code = MAIL$_USER_SET_AUTO_PURGE;       }f       else {M          full_item_list[FULL_AUTO_PURGE].code = MAIL$_USER_SET_NO_AUTO_PURGE;        }     }	    else {T8       full_item_list[FULL_AUTO_PURGE].code = MAIL$_NOOP;    }    if( self_send_modified) {       if( self_send) {H          full_item_list[FULL_SELF_SEND].code = MAIL$_USER_SET_COPY_SEND;       }        else {K          full_item_list[FULL_SELF_SEND].code = MAIL$_USER_SET_NO_COPY_SEND;,       }e    }	    else { 7       full_item_list[FULL_SELF_SEND].code = MAIL$_NOOP;u    }    if( self_reply_modified) {        if( self_reply) { J          full_item_list[FULL_SELF_REPLY].code = MAIL$_USER_SET_COPY_REPLY;       }        else {M          full_item_list[FULL_SELF_REPLY].code = MAIL$_USER_SET_NO_COPY_REPLY;e       }     }	    else {$8       full_item_list[FULL_SELF_REPLY].code = MAIL$_NOOP;    }    if( self_forward_modified) {,       if( self_forward) {sN          full_item_list[FULL_SELF_FORWARD].code = MAIL$_USER_SET_COPY_FORWARD;       },       else {1          full_item_list[FULL_SELF_FORWARD].code =i*            MAIL$_USER_SET_NO_COPY_FORWARD;       }     }	    else { :       full_item_list[FULL_SELF_FORWARD].code = MAIL$_NOOP;    }4    full_item_list[FULL_CREATE_IF].code = MAIL$_NOOP;- }  /* end of set_full_item_list_for_modify */d  N /*==========================================================================*/' void set_full_item_list_for_show( void)  { ?    full_item_list[FULL_USER].code = MAIL$_USER_RETURN_USERNAME;a=    full_item_list[FULL_FORWARD].code = MAIL$_USER_FORWARDING; B    full_item_list[FULL_DIRECTORY].code = MAIL$_USER_SUB_DIRECTORY;A    full_item_list[FULL_PERSONAL].code = MAIL$_USER_PERSONAL_NAME; 8    full_item_list[FULL_EDITOR].code = MAIL$_USER_EDITOR;4    full_item_list[FULL_FORM].code = MAIL$_USER_FORM;6    full_item_list[FULL_QUEUE].code = MAIL$_USER_QUEUE;@    full_item_list[FULL_MESSAGES].code = MAIL$_USER_NEW_MESSAGES;>    full_item_list[FULL_CC_PROMPT].code = MAIL$_USER_CC_PROMPT;@    full_item_list[FULL_AUTO_PURGE].code = MAIL$_USER_AUTO_PURGE;>    full_item_list[FULL_SELF_SEND].code = MAIL$_USER_COPY_SEND;@    full_item_list[FULL_SELF_REPLY].code = MAIL$_USER_COPY_REPLY;D    full_item_list[FULL_SELF_FORWARD].code = MAIL$_USER_COPY_FORWARD;4    full_item_list[FULL_CREATE_IF].code = MAIL$_NOOP;4    full_item_list[FULL_USER].bufflen = MAX_USERNAME;7    full_item_list[FULL_FORWARD].bufflen = NAM$C_MAXRSS;E9    full_item_list[FULL_DIRECTORY].bufflen = NAM$C_MAXRSS; 8    full_item_list[FULL_PERSONAL].bufflen = NAM$C_MAXRSS;6    full_item_list[FULL_EDITOR].bufflen = NAM$C_MAXRSS;4    full_item_list[FULL_FORM].bufflen = NAM$C_MAXRSS;5    full_item_list[FULL_QUEUE].bufflen = NAM$C_MAXRSS; + }  /* end of set_full_item_list_for_show */   N /*==========================================================================*/ void set_short_item_list( void)l {o6    short_item_list[SHORT_USER].bufflen = MAX_USERNAME;9    short_item_list[SHORT_FORWARD].bufflen = NAM$C_MAXRSS;$# }  /* end of set_short_item_list */;  N /*==========================================================================*/ int show_user( void) {e    unsigned int istat;      check_full_or_brief();RP    if( !show_full_qualifier && !show_brief_qualifier && !show_inuse_qualifier) {"       show_inuse_qualifier = TRUE;    })    user_desc.dsc$w_length = MAX_USERNAME;TA    cli$get_value( &user_id, &user_desc, &user_desc.dsc$w_length);s'    user[user_desc.dsc$w_length] = '\0';pC    user_name_item_list[NAME_USER].bufflen = user_desc.dsc$w_length;e%    user_len = user_desc.dsc$w_length;     if( show_brief_qualifier) {L       printf( "%-*s%s\n", MAX_USERNAME+1, "Username", "Forwarding Address");L       printf( "%-*s%s\n", MAX_USERNAME+1, "--------", "------------------");       set_short_item_list();C       istat = get_user_info( user_name_item_list, short_item_list);/    }	    else {=$       set_full_item_list_for_show();B       istat = get_user_info( user_name_item_list, full_item_list);    }    if( istat & 1) {t8       if( show_full_qualifier || show_inuse_qualifier) {          display_user();       }c       else {<          printf( "%-*s%s\n", MAX_USERNAME+1, user, forward);       }f    }	    else {n2       /* MAIL$_NOSUCHUSR = 8290346 (%X007E802A) */%       if( istat != MAIL$_NOSUCHUSR) {=          lib$stop( istat);       }_7       printf( "User %s record does not exist\n", user);=)       istat = RMS$_RNF | INHIBIT_MESSAGE;_    }    return istat; }  /* end of show_user */   N /*==========================================================================*/ main( int argc, char *argv[])r {e    unsigned int istat, status;'    static char command[NAM$C_MAXRSS+1]; '    $DESCRIPTOR( command_desc, command);r(    $DESCRIPTOR( prompt_id, "MAILUAF> ");      create_smg_structures();e,    command_desc.dsc$w_length = NAM$C_MAXRSS;J    istat = lib$get_foreign( &command_desc, 0, &command_desc.dsc$w_length);-    command[command_desc.dsc$w_length] = '\0';e    check( istat);uK    istat = mail$user_begin( &user_context, null_item_list, null_item_list);p    check( istat);     status = SS$_NORMAL;     while( status != RMS$_EOF) {r*       if( command_desc.dsc$w_length > 0) {>          status = cli$dcl_parse( &command_desc, MAILUAF_TABLE,@                                  &lib$get_input, &lib$get_input,-                                  &prompt_id);v          if( status & 1) {$             status = cli$dispatch();
          }          break;        }e       else {N          status = cli$dcl_parse( (struct dsc$descriptor_s *) 0, MAILUAF_TABLE,H                                  &mailuaf_get_input, &mailuaf_get_input,-                                  &prompt_id);}          if( status & 1) {$             status = cli$dispatch();
          }       }=    }.    if( (status & 1) || (status == RMS$_EOF)) {M       status = mail$user_end( &user_context, null_item_list, null_item_list);_       check( status);i       delete_smg_structures();    }    exit( status);= }  /* end of main */