#include	<stdio.h>			/* standard I/O definitions */
#include	<descrip.h>			/* descriptor definitions */
#include	<ssdef.h>			/* system service definitions */
#include	<varargs.h>			/* variable arguments */

/*
 *	Send "Subj:" field to remote node
 *
 *	mai$ax_subj		Text of the "Subj:" field to display at
 *				remote end
 *	mai$ax_node		Node name from address (to the right of the
 *				'%') if a '::' was found, else a blank string
 *
 * Return: System service code for success/failure
 *
 */

PROTO_OUT_SUBJ(
	long	*mai$al_context,		/* Context field for protocol */
	long	mai$l_operation,		/* LNK_C_OUT_SUBJ */
	va_list	arglist)			/* remainder of arguments */
{
	struct	dsc$descriptor *mai$ax_node ;	/* Node to connect to */
	struct	dsc$descriptor *mai$ax_subj ;	/* Subj: field */

	mai$ax_node =
	  (struct dsc$descriptor *) va_arg(arglist, struct dsc$descriptor *) ;
	mai$ax_subj =
	  (struct dsc$descriptor *) va_arg(arglist, struct dsc$descriptor *) ;

	printf( "* Operation type = %d (LNK_C_OUT_SUBJ)\n", mai$l_operation );
	printf( "  Context field  = 0x%08x\n", *mai$al_context );
	printf( "  Node name      = %.*s\n", mai$ax_node->dsc$w_length, mai$ax_node->dsc$a_pointer );
	printf( "  Subj:          = %.*s\n", mai$ax_subj->dsc$w_length, mai$ax_subj->dsc$a_pointer );

	return(SS$_NORMAL) ;			/* Return success to caller */
}
