#include	<stdio.h>			/* standard I/O definitions */
#include	<descrip.h>			/* descriptor definitions */
#include	<ssdef.h>			/* system service definitions */
#include	<varargs.h>			/* variable arguments */
#include	<rab.h>				/* Define RMS RAB fields */

/*
 *	Receive a message from a remote node
 *
 *	mai$ar_rab		Address of RAB for file to receive from the
 *				remote node. We only receive the file once
 *				so that we can distribute the file to each
 *				user that we have previously been asked to.
 *	mai$a_error		Passed address of a routine to be used to
 *				report any I/O error whilst reading the file
 *				and to format the message correctly for MAIL.
 *				Call this routine with:
 *					4(AP)	RAB address as passed
 *
 * Return: System service code for success/failure
 *
 */

PROTO_IN_FILE(
	long	*mai$al_context,		/* Context field for protocol */
	long	mai$l_operation,		/* LNK_C_IN_FILE */
	va_list	arglist)			/* remainder of arguments */
{
	struct	dsc$descriptor	*mai$ax_node ;	/* Node to receive from (????? not sure)*/
	struct	RAB *mai$ar_rab ;		/* File RAB to receive */
	long	(*mai$a_error)() ;		/* Routine to log I/O error */

	mai$ax_node =
	  (struct dsc$descriptor *) va_arg(arglist, struct dsc$descriptor *) ;
	mai$ar_rab = (struct RAB *) va_arg(arglist, struct RAB *) ;
	mai$a_error = (long (*)()) va_arg(arglist, long *) ;

	printf( "* Operation type = %d (LNK_C_IN_FILE)\n", mai$l_operation );
	printf( "  Context field  = 0x%08x\n", *mai$al_context );

/* The mai$ax_node parameter does not seem to be used for LNK_C_IN_FILE. It
 * is passed as 0 by value. I think that it is included only for compatability
 * with LNK_C_OUT_FILE, which has to handle possible multiple simultaneous
 * calls. However, a slave MAIL can only receive from one node at a time, and
 * so the mai$ax_node parameter seems unneccessary, which is perhaps why it
 * is passed as 0 by value
 */
#if 0
	printf( "  Node name      = %.*s\n", mai$ax_node->dsc$w_length, mai$ax_node->dsc$a_pointer );
#endif
	printf( "  RAB address    = 0x%08x\n", mai$ar_rab );
	printf( "  Error routine  = 0x%08x\n", mai$a_error );

	return(SS$_NORMAL) ;			/* Return success to caller */
}
