L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |                UTC                %%   \ @  *                %% |            utc.c  c2004           %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *>  *  Copyright (C) 2001,2004 Lyle W. West, All Rights Reserved.J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *@  *  A digital clock based on 'Simple Digital Clock' From Young's?  *  Book, Chapter 5 (Xclock.c). Also appeared as a DSN article, E  *  "Title: Example C, Motif  Simple Digital Clock From Young's Book"   *D  *  Gets the time as other digital clocks, but then it adds* the VMSB  *  SYS$TIMEZONE_DIFFERENTIAL to the time to produce a clock whichB  *  constantly displays UTC. Also added titlebar, iconame and iconG  *  image plus a user definable font, emulates appearance of DECW$CLOCK   *D  *  Label widget is updated every second in sync with VMS clock, so F  *  there is virtually no cpu overhead running the image continuously.  *  7  *  * In the US Central timezone, UTC is +6 from local.   *    Your mileage may vary.  *  M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #define VERSION "V1.2" #pragma module UTC VERSION   #include <stdio.h> #include <descrip.h> #include <stdlib.h>  #include <string.h>  #include <time.h>  #include <varargs.h> #include <X11/Intrinsic.h> #include <X11/StringDefs.h>  #include <Xm/Xm.h> #include <Xm/Label.h>  #include "utc.xbm"   int n;   Widget          LabelW;  XmFontList      fontlist;  XmString        CpStr; Arg             args[10];    void UpdateTime(); void UpdateDisplay();   L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  Main program  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  main(int argc, char *argv[]) {      char     iconstr[10];      char     titlestr[10];1     XmFontListEntry FontOpt1, FontOpt2, FontOpt3; %     Widget   toplevel, MainBb, clock;   (         /* Create the toplevel widget */  4     toplevel = XtInitialize(argv[0], "Utc", NULL, 0,(                            &argc, argv);  3         /* Create the fontlists (only TAG2 used) */   )     XtSetLanguageProc (NULL, NULL, NULL);   :     FontOpt1 = XmFontListEntryLoad (XtDisplay (toplevel), =         "-*-courier-*-r-*--*-120-*", XmFONT_IS_FONT, "TAG1"); 9     FontOpt2 = XmFontListEntryLoad (XtDisplay (toplevel), >         "-*-times-bold-r-*--*-240-*", XmFONT_IS_FONT, "TAG2");9     FontOpt3 = XmFontListEntryLoad (XtDisplay (toplevel), I         "-adobe-helvetica-bold-r-normal--25-180-100-100-p-138-iso8859-1", !          XmFONT_IS_FONT, "TAG3");   6     fontlist = XmFontListAppendEntry (NULL, FontOpt1);:     fontlist = XmFontListAppendEntry (fontlist, FontOpt2);:     fontlist = XmFontListAppendEntry (fontlist, FontOpt3);  $     XmFontListEntryFree (&FontOpt1);$     XmFontListEntryFree (&FontOpt2);$     XmFontListEntryFree (&FontOpt3);  8         /* Create a label widget for the time display */  
     n = 0;2     XtSetArg(args[n], XmNshadowThickness, 0); n++;5     XtSetArg(args[n], XmNhighlightThickness, 0); n++; 2     XtSetArg(args[n], XmNfontList, fontlist); n++;=     XtSetArg(args[n], XmNalignment, XmALIGNMENT_CENTER); n++; 7     LabelW = XmCreateLabel(toplevel, "clock", args, n);      XtManageChild(LabelW);  8         /* set window and icon titles and icon bitmap */  
     n = 0;     sprintf(titlestr," Utc ");/     XtSetArg(args[n], XmNtitle, titlestr); n++;      sprintf(iconstr, "Utc");1     XtSetArg(args[n], XmNiconName, iconstr); n++; $     XtSetArg(args[n], XmNiconPixmap,6             XCreateBitmapFromData(XtDisplay(toplevel),I                                   RootWindowOfScreen(XtScreen(toplevel)), +                                   utc_bits, ,                                   utc_width,4                                   utc_height)); n++;$     XtSetValues (toplevel, args, n);      /*      * Get the initial time.      */       UpdateTime(LabelW, NULL);      XtRealizeWidget(toplevel);     XtMainLoop();  }     L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  UpdateTime  *  M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ * void UpdateTime(Widget w, XtIntervalId id) {      char   tz_diff[8];     char   tz_lnm[28];     char   lnm_tbl[20];      char   *tz_ptr; +     long   tloc, rounded_tloc, next_minute;      long   status, tz_sec;     short  tz_len;  !     $DESCRIPTOR(dsc_lnm, tz_lnm); #     $DESCRIPTOR(dsc_diff, tz_diff); "     $DESCRIPTOR(dsc_tbl, lnm_tbl);  0     strcpy(tz_lnm, "SYS$TIMEZONE_DIFFERENTIAL");(     strcpy(lnm_tbl, "LNM$SYSTEM_TABLE");*     dsc_lnm.dsc$w_length = strlen(tz_lnm);+     dsc_tbl.dsc$w_length = strlen(lnm_tbl);   ;     status = LIB$GET_LOGICAL(&dsc_lnm, &dsc_diff, &tz_sec,  3                              &dsc_tbl, 0, 0, 0, 0); !     if(status != 1) exit(status); "     tz_ptr = strchr(tz_diff, '-');     *tz_ptr = ' ';     tz_sec = atoi(tz_diff);   3         /* Ask the operating system for the time */        time(&tloc);     tloc += tz_sec;   6         /* Convert the time to a string and display it2            after rounding it down to the minute */  "     rounded_tloc = tloc / 60 * 60;1     UpdateDisplay(w, "%s", ctime(&rounded_tloc));   M         /* Adjust the time to reflect the time until the next round minute */   *     next_minute = (60 - tloc % 60) * 1000;  4         /* The Intrinsics removes timeouts when they)            occur so put ourselves back */   -     XtAddTimeOut(next_minute, UpdateTime, w);  }   L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *;  * UpdateDisplay: fprintf-like function for XmLabel widgets 1  *                 Example described on page: 141   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void UpdateDisplay(va_alist)
     va_dcl {      Widget   w;      char     *format;      va_list  vargs;      char     TimeStr[30];      char     tmpbuf[30];     char     *ptr1;      char     *ptr2;   .         /* the variable length (v)args list */       va_start(vargs);  4         /* Extract the destination widget, make sure)            it is a subclass of XmLabel */        w = va_arg(vargs, Widget);,     if(!XtIsSubclass(w, xmLabelWidgetClass));         XtError("UpdateDisplay() requires a Label Widget");   +         /* Extract the format to be used */   #     format = va_arg(vargs, char *);   C         /* Use vsprintf to format the string to be displayed in the @            XmLabel widget, then convert it to a compound string.A            If SUPPRESS_ZERO is defined, we don't display the hour 8            tens position between midnite and 9:59 utc */               $     vsprintf(tmpbuf, format, vargs);     ptr1 = &tmpbuf + 11; #ifdef SUPPRESS_ZEROH     if(*ptr1 == 0x30) ptr1++;       /* if leading zero, point past it */ #endif9     ptr2 = strrchr(tmpbuf, ':');    /* find last colon */      *ptr2 = '\0';      strcpy(TimeStr, ptr1);-     CpStr =  XmStringCreate(TimeStr, "TAG2");   3         /* set the time string into label widget */   
     n = 0;2     XtSetArg(args[n], XmNlabelString, CpStr); n++;!     XtSetValues(LabelW, args, n);        va_end(vargs); } 