$! Create MPEG_Play on VMS.
$! This command procedure compiles and links MPEG_Play with MMS or MMK if
$! either is available.
$!
$! Debugging is invoked if P1 is set to DEBUG. MMS parameters can be added
$! in P2 (e.g. /IGNORE=WARNING to make MMS ignore compilation warnings).
$! Additional arguments (e.g. __VAXC__=1) can be specified in P3
$! thru P8.
$!
$! This file derived from MAKE_MOSAIC.COM
$!
$ Verify = F$Verify(0)
$ On Error Then Goto The_End
$ On Control_Y Then Goto EndY
$ pwd = F$Environment("Default")
$ If P1 .EQS. "?" .OR. P1 .EQS. "HELP"
$  Then
$   Write sys$output "Specify DEBUG in P1 to build with debugging."
$   Write sys$output "Specify MMS parameters (e.g. /IGNORE=WARNING) in P2."
$   Write sys$output -
        "Specify additional arguments (e.g. __VAXC__=1) in P3 thru P8."
$   Goto The_End
$  Endif
$ Args = ""
$ If P3 .NES. "" then Args = P3 + ","
$ If P4 .NES. "" then Args = Args + P4 + ","
$ If P5 .NES. "" then Args = Args + P5 + ","
$ If P6 .NES. "" then Args = Args + P6 + ","
$ If P7 .NES. "" then Args = Args + P7 + ","
$ If P8 .NES. "" then Args = Args + P8 + ","
$ Args = F$Edit(Args,"Collapse,UPCase")
$ Macro = "(" + Args
$!
$ On Warning Then Platform = "VAX"
$ Platform = F$GetSYI("Arch_Name")
$ On Error Then Goto The_End
$ If Platform .EQS. "Alpha"
$  Then
$   Macro = Macro + "__ALPHA__=1,"
$  Endif
$!
$ If F$Search("SYS$System:DECC$Compiler.Exe") .NES. ""
$  Then
$   If (Platform .EQS. "Alpha") .OR. ((Platform .EQS. "VAX") .AND. -
        ((F$Trnlnm("DECC$LIBRARY_INCLUDE") .NES. "") .OR. -
        (F$Trnlnm("DECC$CC_DEFAULT") .NES. "")))
$    Then
$     Macro = Macro + "__DECC__=1,"
$    Else
$     Write sys$output "DEC C does not appear to be properly installed on"
$     Write sys$output "this system.  Check if SYS$STARTUP:CCXX$STARTUP.COM"
$     Write sys$output "was executed.  Will attempt to use VAX C."
$    Endif
$  Else
$    If Platform .EQS. "Alpha"
$     Then
$      Write sys$output "Aborting because DEC C does not appear to be"
$      Write sys$output "installed on this system."
$      Goto The_End
$     Endif
$  Endif
$ If (F$Locate("DEBUG",P1) .EQ. F$Length(P1)) .OR. -
        (F$Locate("NODEBUG",P1) .NE. F$Length(P1))
$  Then
$  Else
$   Macro = Macro + "DEBUG=1,"
$  EndIf
$!
$ If F$Search("SYS$System:MMS.Exe") .NES. ""
$  Then
$   Command = "MMS"
$  Else
$    If F$Search("MMK_DIR:MMK.Exe") .NES. ""
$     Then
$      Macro = Macro + "USE_MMK=1,"
$      Command = "MMK"
$     Else
$      Write SYS$Output "Neither MMS or MMK appears to be available."
$      Write SYS$Output "Aborting build."
$      Write SYS$Output " "
$      Goto No_mms
$     EndIf
$  EndIf
$!
$! Do MMS or MMK build
$!
$ If Macro .NES. "("
$  Then
$   Quals = P2 + "/Macro=" + Macro + ")"
$   Quals = Quals - ",)"
$   Quals = Quals + ")"
$  EndIf
$!
$! Run MMS or MMK now
$!
$ Write SYS$Output "''Command' will be invoked as ''Command'''Quals'"
$ If Command .EQS. "MMS"
$  Then MMS'Quals'
$  Else MMK'Quals'
$  EndIf
$ Goto The_End
$!
$No_mms:
$EndY:
$The_End:
$ xxx = F$Verify(Verify)
$ Set Default 'pwd'
$ Exit
