I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% +         ! Program       : Menu_routines.inc F         ! Package       : Communication Expense Report Tracking System%         ! Author        : Allen Roske '         ! Date          : February 1989          ! W.R. No.      : <         ! Purpose       : login, security, and menu routines=         ! Modified      : Lisa jordan Quast to work for CERTS I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          ! Modification HistoryI         !---------------------------------------------------------------- B         ! 28-JUN-94     MS      Modified to be versatile - removed7         !                       hard coded CERTS stuff. H         ! 17-AUG-94     MS      1. Modified to allow menu items 24 chars5         !                       long (previously 23). F         !                       2. Modified to center the pop-up menu.F         !                       3. Added new routine call to add EXIT 5         !                          as last menu item. J         ! 12-SEP-94     NVA     Need to set MENU_NO_FINISH to TRUE in .intG         !                       if you do not want the user to exit the G         !                       program from the maint menu with _BACK. F         ! 26-OCT-94     JLS     Increased maximum length of menu item F         !                       descriptions to 48.  But the length ofF         !                       a menu's item descriptions should not G         !                       exceed 24 if there is a $SPLIT command  3         !                       in that menu's MCL. I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         ! M E N U   B U I L D J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         !          ! Brief description:&         !   build the menu for display	         !          ! Expected: 	         !          ! Locals: 	         !          ! Results:	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine menu_build           menu_initialize            get_valid_operator!           if  not oper_okay then  #             action$ = 'menu_finish'              exit routine           end if           menu_process_mcl         end routine         I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% '         ! M E N U _ I N I T I A L I Z E I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! C         ! Set up the first screen.  This is the screen that is used I         ! when the program first starts up.  Initialize number of access  6         ! tries to zero.  Initialize famous constants.	         !          ! EXPECTED: C         !  u_str$        = header text (defined in calling program) 
         !          ! RESULT: 4         !        access_tries% = initialized to zero	         ! '         !  u_str$        = heading text 5         !  access_tries% = counter for login attempts 9         !  access_limit  = number of access tries allowed <         !  err_no_file%  = mcl_err% value for file not found:         !  err_syntax%   = mcl_err% value for syntax error=         !  err_bad_cmd%  = mcl_err% value for invalid command I         !  err_no_item%  = mcl_err% value for item not found in PROCEDURE ?         !  err_dup_id%   = mcl_err% value for duplicate item ID ;         !  err_bad_id%   = mcl_err% value for item ID error :         !  nospaces%     = edit$() param to discard spacesB         !  nolead%       = edit$() param to discard leading spaces@         !  noextra%      = edit$() param to discard extra spaces=         !  ucase%        = edit$() param to uppercase letters C         !  notrail%      = edit$() param to discard trailing spaces I         !  skipquote%    = edit$() param to supress editing within quotes 2         !  action$       = next action to be taken	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          routine menu_initialize 8           set structure mc, field menukey : key "111111".           screen_frame                                   access_tries% = 0            access_limit  = 3            err_no_file%  = 1%             err_syntax%   = 2%             err_bad_cmd%  = 3%           err_no_item%  = 4%           err_dup_id%   = 5%           err_bad_id%   = 6%           nospace%      = 2%           nolead%       = 8%%           noextra%      = 16%                    ucase%        = 32%            notrail%      = 128%           skipquote%    = 256%"           clear area 21, 1, 21, 80@           u_str$ = 'Initializing ' + system_name$ + ' system...'           gosub center#           message system_copyright$ '           print at 21, u_int% : u_str$;          end routine     I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% )         ! M E N U _ P R O C E S S _ M C L I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! A         ! Set up the operator ID and initials as symbols so other #         ! programs can access them. A         ! Process the MCL file; and load the internal arrays that /         ! are used to display and run the menu. 	         !          ! RESULT: F         !       menu_info_total% = number of MENU_INFO$(,) rows loadedF         !       menu_menu_total% = number of MENU_MENU$(,) rows loaded;         !       error            = error TRUE or FALSE flag 5         !       fatal            = TRUE or FALSE flag 9         !       action$          = next action to perform 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%           routine menu_process_mcl           do             menu_set_up_menu%             menu_init_for_process_mcl %             if  _error  then  exit do              menu_open_mcl_file%             if  _error  then  exit do              menu_read_mcl_file             menu_close_mcl_file $             menu_process_command_end.             menu_info_total% = menu_info_slot%.             menu_menu_total% = menu_menu_slot%#             menu_check_called_menus              menu_build_menu            end do           if  fatal  then #             action$ = "menu_finish"            else&             action$ = "open_all_files"           end if         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% )         ! M E N U _ S E T _ U P _ M E N U I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! @         ! Set up the internal arrays used to store the processed         ! MCL file information. 	         !          ! RESULT: #         !       info_row_max% = 400 !         !       info_col_max% = 5 K         !                ! maximum rows and columns for menu_info$(,) array 	         ! "         !       menu_row_max% = 10!         !       menu_col_max% = 6 K         !                ! maximum rows and columns for menu_menu$(,) array 5         !       menu_items%   = 0 index to menu_item% 	         ! $         !       menu_files_max% = 20-         !                ! maximum menu files 	         ! 8         !       menu_info$(info_row_max%, info_col_max%)/         !                ! column 1 = menu name -         !                ! column 2 = command <         !                ! column 3 = item number (if $ITEM),         !                ! column 4 = text 1,         !                ! column 5 = text 2	         ! 8         !       menu_menu$(menu_row_max%, menu_col_max%)/         !                ! column 1 = menu name 2         !                ! column 2 = menu headingB         !                ! column 3 = beginning MENU_INFO$(,) slot?         !                ! column 4 = ending MENU_INFO$(,) slot L         !                ! column 5 = "N" if all numbered items on this menu	         ! -         !       menu_level$(menu_row_max%, 2) ,         !                ! row# = menu level/         !                ! column 1 = menu name M         !                ! column 2 = MENU_INFO$(,) slot for last item chosen 	         ! *         !       mcl_name$(menu_files_max%)7         !                ! file name for each .MCL file 	         ! /         !       menu_line_ctr%(menu_files_max%) D         !                ! line counter for each file used for menus?         !       menu_item%(info_row_max%) = index to items only 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%             routine menu_set_up_menu           info_row_max%   = 400          info_col_max%   = 5          menu_row_max%   = 20         menu_col_max%   = 5          menu_files_max% = 20         menu_items%     = 0   4         dim menu_info$(info_row_max%, info_col_max%)4         dim menu_menu$(menu_row_max%, menu_col_max%))         dim menu_level$(menu_row_max%, 2) &         dim mcl_name$(menu_files_max%)+         dim menu_line_ctr%(menu_files_max%) %         dim menu_item%(info_row_max%) *         dim menu_ambiguous%(info_row_max%)           end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% ;         ! M E N U _ I N I T _ F O R _ P R O C E S S _ M C L I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! F         ! Initialize and set up variables for processing the MCL file."         ! Go check for menu errors	         !          ! EXPECTED: 6         !       oper_menu$ = operator's MCL file name.	         !          ! RESULT: (         !       error            = false(         !       fatal            = false-         !       mcl_fspec$       = oper_menu$ 5         !       mcl_level%       = menu level counter (         !       do_end%          = falseF         !       menu_info_slot%  = menu information array slot counterB         !       menu_menu_slot%  = menu context array slot counter4         !       menu_line_ctr%() = menu line counter;         !       menu_files_max%  = max number of menu files 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% )         routine menu_init_for_process_mcl !           mcl_fspec$ = oper_menu$            mcl_level% = 0           do_end% = false            menu_info_slot% = 0            menu_menu_slot% = 0 (           for z1% = 1 to menu_files_max%#             menu_line_ctr%(z1%) = 0            next z1%           menu_check_mcl_file          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% -         ! M E N U _ O P E N _ M C L _ F I L E I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! (         ! Increment the "include" level."         ! Open a menu source file.	         !          ! EXPECTED: 7         !       mcl_fspec$   = name of MCL file to open @         !       err_no_file% = mcl_err% value for file not found	         !          ! RESULT: )         !       mcl_level% is incremented F         !       mcl_name$(mcl_level%) is loaded with the MCL file name1         !       error        = TRUE or FALSE flag 8         !       mcl_err%     = which menu error occurred	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% "         routine menu_open_mcl_file%           mcl_level% = mcl_level% + 1 ,           mcl_name$(mcl_level%) = mcl_fspec$           error = false            when exception in <             open #mcl_level% : name mcl_fspec$, access input
           use            end when           if  _error then #             mcl_err% = err_no_file% !             menu_report_mcl_error            end if         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% -         ! M E N U _ R E A D _ M C L _ F I L E I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! '         ! Read a menu source file line. 	         !          ! EXPECTED: C         !       mcl_level% = source file channel / "include"  level 	         !          ! RESULT: 4         !       mcl_line$ = source file line read inF         !       menu_line_ctr%() = line counter for each channel/level	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% "         routine menu_read_mcl_file           do8             line input #mcl_level%, eof eof? : mcl_line$!             if  eof? then exit do G             menu_line_ctr%(mcl_level%) = menu_line_ctr%(mcl_level%) + 1 !             menu_process_mcl_line            loop         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% /         ! M E N U _ C L O S E _ M C L _ F I L E I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! %         ! Close the menu source file. (         ! Decrement the "include" level.	         !          ! EXPECTED: G         !       mcl_level% = menu source file channel / "include" level 	         !          ! RESULT: 1         !       menu_line_ctr%() is reinitialized )         !       mcl_level% is decremented 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% #         routine menu_close_mcl_file            close #mcl_level% (           menu_line_ctr%(mcl_level%) = 0%           mcl_level% = mcl_level% - 1          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 3         ! M E N U _ P R O C E S S _ M C L _ L I N E I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! *         ! Process a menu source file line.	         !          ! EXPECTED: >         !       mcl_line$    = raw, unprocessed .MCL file line>         !       err_syntax%  = mcl_err% value for syntax error	         !          ! RESULT: G         !       mcl_err%     = error number if line is incomprehensible 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %         routine menu_process_mcl_line &           z1$ = ltrim$(mcl_line$)[1:1]           select case z1$            case ""              ! skip blank lines           case "!"              ! skip comment lines           case "$"$             menu_process_mcl_command           case "%"&             menu_process_mcl_directive           case else $             mcl_err% = err_syntax%  !             menu_report_mcl_error            end select         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 9         ! M E N U _ P R O C E S S _ M C L _ C O M M A N D I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! .         ! Process MCL lines that are commands.'         ! These lines begin with a "$". 	         !          ! EXPECTED: E         !       mcl_line$    = .MCL file line which begins with a "$" F         !       nolead%      = edit$() param to discard leading spacesA         !       ucase%       = edit$() param to uppercase letters A         !       err_bad_cmd% = mcl_err% value for invalid command 	         !          ! RESULT: >         !       mcl_err%     = error number if unknown command	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% (         routine menu_process_mcl_commandD           z1$ = element$(edit$(mcl_line$, nolead% + ucase%), 1, " ")           select case z1$            case "$MENU"%             menu_process_command_menu            case "$HEADING" (             menu_process_command_heading           case "$TITLE" &             menu_process_command_title           case "$TEXT"%             menu_process_command_text            case "$ITEM"%             menu_process_command_item            case "$SPLIT" &             menu_process_command_split           case "$END" $             menu_process_command_end           case else #             mcl_err% = err_bad_cmd% !             menu_report_mcl_error            end select         end routine                                  I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% ;         ! M E N U _ P R O C E S S _ C O M M A N D _ M E N U I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! "         ! Process a $MENU command.	         !          ! EXPECTED: 1         !       mcl_line$   = .MCL file text line =         !       err_syntax% = mcl_err% value for syntax error E         !       nolead%     = edit$() param to discard leading spaces C         !       noextra%    = edit$() param to discard extra spaces @         !       ucase%      = edit$() param to uppercase lettersF         !       notrail%    = edit$() param to discard trailing spaces	         !          ! RESULT: E         !       do_end%     = set on (we will need to process a $END) I         !                     (we do this in case we don't ever find one) '         !       cur_menu$   = menu name 6         !       item_nbr%   = 0% = item number/counterG         !       item_idz$   = "" = string of unique item IDs (per menu) $         !                           I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% )         routine menu_process_command_menu "           menu_process_command_end           do_end% = trueH           z1$ = edit$(mcl_line$, nolead% + noextra% + ucase% + notrail%)+           if  elements(z1$, " ") <> 2  then #             mcl_err% = err_syntax%  !             menu_report_mcl_error              exit routine           end if5           cur_menu$ = z1$[len("$MENU ") + 1:len(z1$)] +           menu_load_arrays_for_command_menu            item_nbr% = 0%           item_idz$ = ""         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% K         ! M E N U _ L O A D _ A R R A Y S _ F O R _ C O M M A N D _ M E N U I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! .         ! Load the arrays for a $MENU command.	         !          ! EXPECTED: -         !       cur_menu$ = name of this menu 	         ! 8         !       menu_info$(info_row_max%, info_col_max%)/         !                ! column 1 = menu name -         !                ! column 2 = command <         !                ! column 3 = item number (if $ITEM),         !                ! column 4 = text 1,         !                ! column 5 = text 2	         ! 8         !       menu_menu$(menu_row_max%, menu_col_max%)/         !                ! column 1 = menu name 2         !                ! column 2 = menu headingB         !                ! column 3 = beginning MENU_INFO$(,) slot?         !                ! column 4 = ending MENU_INFO$(,) slot L         !                ! column 5 = "N" if all numbered items on this menu	         !          ! RESULT: .         !       menu_menu_slot% is incremented-         !       menu_info$(,) array is loaded -         !       menu_menu$(,) array is loaded 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 1         routine menu_load_arrays_for_command_menu B           menu_increment_menu_info_slot  ! returns MENU_INFO_SLOT%4           menu_info$(menu_info_slot%, 1) = cur_menu$2           menu_info$(menu_info_slot%, 2) = "$MENU"-           menu_info$(menu_info_slot%, 3) = "" -           menu_info$(menu_info_slot%, 4) = "" -           menu_info$(menu_info_slot%, 5) = "" /           menu_menu_slot% = menu_menu_slot% + 1 4           menu_menu$(menu_menu_slot%, 1) = cur_menu$-           menu_menu$(menu_menu_slot%, 2) = "" @           menu_menu$(menu_menu_slot%, 3) = str$(menu_info_slot%)-           menu_menu$(menu_menu_slot%, 4) = "" -           menu_menu$(menu_menu_slot%, 5) = ""          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% A         ! M E N U _ P R O C E S S _ C O M M A N D _ H E A D I N G I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! %         ! Process a $HEADING command. 	         !          ! EXPECTED: /         !       mcl_line$ = .MCL file text line (         !       cur_menu$ = current menuC         !       nolead%   = edit$() param to discard leading spaces A         !       noextra%  = edit$() param to discard extra spaces 	         ! 8         !       menu_info$(info_row_max%, info_col_max%)/         !                ! column 1 = menu name -         !                ! column 2 = command <         !                ! column 3 = item number (if $ITEM),         !                ! column 4 = text 1,         !                ! column 5 = text 2	         ! 8         !       menu_menu$(menu_row_max%, menu_col_max%)/         !                ! column 1 = menu name 2         !                ! column 2 = menu headingB         !                ! column 3 = beginning MENU_INFO$(,) slot?         !                ! column 4 = ending MENU_INFO$(,) slot L         !                ! column 5 = "N" if all numbered items on this menu	         !          ! RESULT: '         !       menu_info$(,) is loaded '         !       menu_menu$(,) is loaded 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% ,         routine menu_process_command_heading4           z1$ = edit$(mcl_line$, nolead% + noextra%)2           z2$ = z1$[len("$HEADING ") + 1:len(z1$)]'           menu_increment_menu_info_slot 4           menu_info$(menu_info_slot%, 1) = cur_menu$5           menu_info$(menu_info_slot%, 2) = "$HEADING" -           menu_info$(menu_info_slot%, 3) = "" .           menu_info$(menu_info_slot%, 4) = z2$-           menu_info$(menu_info_slot%, 5) = "" .           menu_menu$(menu_menu_slot%, 2) = z2$         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% =         ! M E N U _ P R O C E S S _ C O M M A N D _ T I T L E I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! #         ! Process a $TITLE command. 	         !          ! EXPECTED: /         !       mcl_line$ = .MCL file text line (         !       cur_menu$ = current menuC         !       nolead%   = edit$() param to discard leading spaces A         !       noextra%  = edit$() param to discard extra spaces 	         !          ! RESULT: '         !       menu_info$(,) is loaded 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% *         routine menu_process_command_title4           z1$ = edit$(mcl_line$, nolead% + noextra%)0           z2$ = z1$[len("$TITLE ") + 1:len(z1$)]'           menu_increment_menu_info_slot 4           menu_info$(menu_info_slot%, 1) = cur_menu$3           menu_info$(menu_info_slot%, 2) = "$TITLE" -           menu_info$(menu_info_slot%, 3) = "" .           menu_info$(menu_info_slot%, 4) = z2$-           menu_info$(menu_info_slot%, 5) = ""          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% ;         ! M E N U _ P R O C E S S _ C O M M A N D _ T E X T I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! "         ! Process a $TEXT command.	         !          ! EXPECTED: 2         !       mcl_line$    = .MCL file text line+         !       cur_menu$    = current menu A         !       err_bad_cmd% = mcl_err% value for invalid command 	         ! 	         !          ! RESULT: '         !       menu_info$(,) is loaded 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% )         routine menu_process_command_text &           z1% = pos(mcl_line$, '"', 1)Q           if  z1% = 0  then  z1% = pos(mcl_line$, "'", 1)  ! find beginning quote            if  z1% = 0  then              z2% = -1%            else=             z2% = pos(mcl_line$, mcl_line$[z1%:z1%], z1% + 1)            end if9               ! find ending quote (if we had a beginning)            if  z2% = 0  then #             mcl_err% = err_bad_cmd% !             menu_report_mcl_error              exit routine           end if1           text_text$ = mcl_line$[z1% + 1:z2% - 1] *           menu_load_array_for_command_text         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% I         ! M E N U _ L O A D _ A R R A Y _ F O R _ C O M M A N D _ T E X T I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! -         ! Load the array for a $TEXT command. 	         !          ! EXPECTED: -         !       cur_menu$ = current menu name (         !       text_text$ = text string	         !          ! RESULT: ;         !       menu_info$(,) is loaded for a $TEXT command 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 0         routine menu_load_array_for_command_text'           menu_increment_menu_info_slot 4           menu_info$(menu_info_slot%, 1) = cur_menu$2           menu_info$(menu_info_slot%, 2) = "$TEXT"-           menu_info$(menu_info_slot%, 3) = "" 5           menu_info$(menu_info_slot%, 4) = text_text$ -           menu_info$(menu_info_slot%, 5) = ""          end routine                             I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% ;         ! M E N U _ P R O C E S S _ C O M M A N D _ I T E M I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! 0         ! Process a $ITEM or $ITEM MENU command.	         !          ! EXPECTED: 1         !       mcl_line$    = MCL file text line A         !       err_bad_cmd% = mcl_err% value for invalid command F         !       nolead%      = edit$() param to discard leading spacesD         !       noextra%     = edit$() param to discard extra spacesA         !       ucase%       = edit$() param to uppercase letters G         !       notrail%     = edit$() param to discard trailing spaces 	         !          ! RESULT: 3         !       item_line$     = massaged MCL_LINE$ C         !       item_elements% = number of "elements" in ITEM_LINE$ 6         !       mcl_err%       = error number  if  any-         !                                     I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% )         routine menu_process_command_item O           item_line$ = edit$(mcl_line$, nolead% + noextra% + ucase% + notrail%) 4           item_elements% = elements(item_line$, " ")3           if  item_line$[1:10] = "$ITEM MENU"  then )             if  item_elements% >= 3  then                menu_item_menu             else&               mcl_err% = err_bad_cmd% #               menu_report_mcl_error              end if'           else                  ! $ITEM D             if  (item_elements% = 2)  or  (item_elements% = 3)  then               menu_item_item             else%               mcl_err% = err_bad_cmd% #               menu_report_mcl_error              end if           end if         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %         ! M E N U _ I T E M _ I T E M I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! C         ! Process a $ITEM command in either of the following forms: 	         ! )         !       $ITEM <item-id> item-name          !       $ITEM item-name 	         !          ! EXPECTED: 2         !       cur_menu$      = current menu nameC         !       item_elements% = number of "elements" in ITEM_LINE$          !                ! RESULT: ;         !       item_info$(,) is loaded for a $ITEM command 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          routine menu_item_item$           select case item_elements%           case is = 2 '             menu_item_item_without_name            case is = 3 $             menu_item_item_with_name           end select)           if  (error)  then  exit routine                  ! RETURNED: 1                 !       item_id$        = item ID =                 !       item_proc_name$ = item procedure name :                 !       item_desc$      = item description2           item_idz$ = item_idz$ + (item_id$ + ",")(                 ! add to item IDs string'           menu_increment_menu_info_slot 4           menu_info$(menu_info_slot%, 1) = cur_menu$2           menu_info$(menu_info_slot%, 2) = "$ITEM"3           menu_info$(menu_info_slot%, 3) = item_id$ :           menu_info$(menu_info_slot%, 4) = item_proc_name$5           menu_info$(menu_info_slot%, 5) = item_desc$ '           menu_items% = menu_items% + 1 3           menu_item%(menu_items%) = menu_info_slot%          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% ?         ! M E N U _ I T E M _ I T E M _ W I T H O U T _ N A M E I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! 8         ! Process a $ITEM command in the following form:	         !          !       $ITEM item-name 	         !          ! EXPECTED: ,         !       item_nbr%      = item number3         !       item_line$     = massaged MCL_LINE$          !                        ! RESULT: )         !       item_id$        = item ID 5         !       item_proc_name$ = item procedure name 2         !       item_desc$      = item description	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% +         routine menu_item_item_without_name $           item_nbr% = item_nbr% + 1%%           item_id$  = str$(item_nbr%) '           menu_check_for_duplicate_item (           if  _error  then  exit routine8           item_proc_name$ = element$(item_line$, 2, " ")           menu_find_item_desc (           if  _error  then  exit routine!           item_desc$ = proc(desc)          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 9         ! M E N U _ I T E M _ I T E M _ W I T H _ N A M E I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! 8         ! Process a $ITEM command in the following form:	         ! )         !       $ITEM <item-id> item-name 	         !          ! EXPECTED: 4         !        item_line$     = massaged MCL_LINE$	         !          ! RESULT: )         !       item_id$        = item ID 5         !       item_proc_name$ = item procedure name 2         !       item_desc$      = item description	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% (         routine menu_item_item_with_name1           item_id$ = element$(item_line$, 2, " ")            menu_check_item_id(           if  _error  then  exit routine8           item_proc_name$ = element$(item_line$, 3, " ")           menu_find_item_desc (           if  _error  then  exit routine!           item_desc$ = proc(desc)          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %         ! M E N U _ I T E M _ M E N U I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! >         ! Process a   $ITEM MENU <item_id> menu-name   command         !                  ! EXPECTED: ,         !       cur_menu$ = current menuname/         !       item_line$ = massaged MCL_LINE$ 	         !          ! RESULT: '         !       menu_info$(,) is loaded 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          routine menu_item_menu@           if  scan(element$(item_line$, 3, " "), "<>") = 0  then'             menu_item_menu_without_name            else$             menu_item_menu_with_name           end if(           if  _error  then  exit routine                 ! RETURNED: ,                 !       item_id$   = item ID8                 !       menu_name$ = menu name (to call):                 !       menu_desc$ = menu description text2           item_idz$ = item_idz$ + (item_id$ + ",")'           menu_increment_menu_info_slot 4           menu_info$(menu_info_slot%, 1) = cur_menu$7           menu_info$(menu_info_slot%, 2) = "$ITEM MENU" 3           menu_info$(menu_info_slot%, 3) = item_id$ 5           menu_info$(menu_info_slot%, 4) = menu_name$ 5           menu_info$(menu_info_slot%, 5) = menu_desc$ '           menu_items% = menu_items% + 1 3           menu_item%(menu_items%) = menu_info_slot%          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% ?         ! M E N U _ I T E M _ M E N U _ W I T H O U T _ N A M E I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! 4         ! Process a   $ITEM MENU menu-name   command         !                  ! EXPECTED: 0         !       mcl_line$  = .MCL file text line/         !       item_line$ = massaged MCL_LINE$ 0         !       item_nbr%  = item number counterD         !       nolead%    = edit$() param to discard leading spacesB         !       noextra%   = edit$() param to discard extra spacesE         !       notrail%   = edit$() param to discard trailing spaces 	         !          ! RESULT: $         !       item_id$   = item ID&         !       menu_name$ = menu name-         !       menu_desc$ = description text 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% +         routine menu_item_menu_without_name $           item_nbr% = item_nbr% + 1%%           item_id$  = str$(item_nbr%) '           menu_check_for_duplicate_item (           if  _error  then  exit routine3           menu_name$ = element$(item_line$, 3, " ") ?           z1$ = edit$(mcl_line$, nolead% + noextra% + notrail%) 5           z1% = pos(z1$, " ", len("$ITEM MENU ") + 1)            if  z1% > 0%  then.             menu_desc$ = z1$[z1% + 1:len(z1$)]           else-             menu_desc$ = menu_name$ + " menu"            end if         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 9         ! M E N U _ I T E M _ M E N U _ W I T H _ N A M E I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! >         ! Process a   $ITEM MENU <item_id> menu-name   command         !                  ! EXPECTED: 0         !       mcl_line$  = .MCL file text line/         !       item_line$ = massaged MCL_LINE$ 0         !       item_nbr%  = item number counterC         !       nolead%   = edit$() param to discard leading spaces A         !       noextra%  = edit$() param to discard extra spaces D         !       notrail%  = edit$() param to discard trailing spaces	         !          ! RESULT: $         !       item_id$   = item ID&         !       menu_name$ = menu name-         !       menu_desc$ = description text 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% (         routine menu_item_menu_with_name1           item_id$ = element$(item_line$, 3, " ")            menu_check_item_id(           if  _error  then  exit routine3           menu_name$ = element$(item_line$, 4, " ") ?           z1$ = edit$(mcl_line$, nolead% + noextra% + notrail%) !           z1% = pos(z1$, "> ", 1) &           z1% = pos(z1$, " ", z1% + 2)           if  z1% > 0%  then.             menu_desc$ = z1$[z1% + 1:len(z1$)]           else-             menu_desc$ = menu_name$ + " menu"            end if         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% -         ! M E N U _ C H E C K _ I T E M _ I D I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! 3         ! Here only when an item name is specified. 	         ! C         ! Item IDs must be enclosed between "<" and ">" characters, [         ! be 12 characters max, contain only "legal" characters, and be ++DJS++ 26-NOV-1990 !         ! unique within the menu. 	         !          ! EXPECTS:%         !       item_id$    = item ID 7         !       item_idz$   = string of unique item IDs =         !       err_syntax% = mcl_err% value for syntax error >         !       err_bad_id% = mcl_err% value for item ID error	         !          ! RETURNS:0         !       item_id$    = "massaged" item ID3         !       mcl_err%    = error number  if  any 	         ! I         ! Exceeds 22 lines to completely validate item name in one place. 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% "         routine menu_check_item_id           error = false 1           if  (left$(item_id$, 1)  <> "<")  and & 0               (right$(item_id$, 1) <> ">")  then#             mcl_err% = err_syntax%  !             menu_report_mcl_error              set error on             exit routine           end if0           item_id$ = item_id$[2:len(item_id$)-1]@                 ! remove from between the "<" and ">" characters'           if  len(item_id$) > 12%  then ;             ! item name too long 12 max ++DJS++ 26-NOV-1990 #             mcl_err% = err_bad_id%  !             menu_report_mcl_error              set error on             exit routine           end if@           legal_chars$ = "ABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789"(           for  z1% = 1% to len(item_id$)>             if  pos(legal_chars$, item_id$[z1%:z1%]) = 0  then%               mcl_err% = err_bad_id%  #               menu_report_mcl_error                set error on               exit for             end if           next z1%(           if  _error  then  exit routine'           menu_check_for_duplicate_item          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% C         ! M E N U _ C H E C K _ F O R _ D U P L I C A T E _ I T E M I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! %         ! Check for a duplicate item. 	         !          ! EXPECTED: /         !       item_id$    = item ID to check. @         !       item_idz$   = string of item IDs we have so far.B         !       err_dup_id% = mcl_err% value for duplicate item ID	         !          ! RESULT: .         !       error = true  if  a duplicate.	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% -         routine menu_check_for_duplicate_item 3           if  match(item_idz$, item_id$) <> 0  then %             mcl_err% = err_dup_id%    !             menu_report_mcl_error              set error on           end if         end routine                  I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% /         ! M E N U _ F I N D _ I T E M _ D E S C I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! H         ! Get the matching PROCEDURE record for the item procedure name.	         !          ! EXPECTS:+         !       item_proc_name$ = item name J         !       err_no_item%    = mcl_err% value for item not in PROCEDURE	         !          ! RETURNS:>         !       mcl_err% = error number if item name not found	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% #         routine menu_find_item_desc >           set structure proc, field name : key item_proc_name$"           if  _extracted = 0 then #             mcl_err% = err_no_item% !             menu_report_mcl_error              set error on           end if         end routine                  I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% =         ! M E N U _ P R O C E S S _ C O M M A N D _ S P L I T I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! #         ! Process a $SPLIT command. 	         !          ! EXPECTED: /         !       mcl_line$ = .MCL file text line 	         !          ! RESULT: =         !       menu_info$(,) is loaded for a $SPLIT command. 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% *         routine menu_process_command_split'           menu_increment_menu_info_slot 4           menu_info$(menu_info_slot%, 1) = cur_menu$3           menu_info$(menu_info_slot%, 2) = "$SPLIT" -           menu_info$(menu_info_slot%, 3) = "" -           menu_info$(menu_info_slot%, 4) = "" -           menu_info$(menu_info_slot%, 5) = ""          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 9         ! M E N U _ P R O C E S S _ C O M M A N D _ E N D I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! !         ! Process a $END command. D         ! The $END may be real or implied because we came to a $MENU&         ! or the end of main MCL file.	         !          ! EXPECTED: A         !       do_end%   = true  if  we need to run this routine -         !       cur_menu$ = current menu name 4         !       menu_menu_slot% = menu_menu$(,) slot	         ! 8         !       menu_info$(info_row_max%, info_col_max%)/         !                ! column 1 = menu name -         !                ! column 2 = command <         !                ! column 3 = item number (if $ITEM),         !                ! column 4 = text 1,         !                ! column 5 = text 2	         ! 8         !       menu_menu$(menu_row_max%, menu_col_max%)/         !                ! column 1 = menu name 2         !                ! column 2 = menu headingB         !                ! column 3 = beginning MENU_INFO$(,) slot?         !                ! column 4 = ending MENU_INFO$(,) slot L         !                ! column 5 = "N" if all numbered items on this menu	         ! '         !       menu_info$(,) is loaded '         !       menu_menu$(,) is loaded 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% (         routine menu_process_command_end-           if  not do_end%  then  exit routine '           menu_increment_menu_info_slot 4           menu_info$(menu_info_slot%, 1) = cur_menu$1           menu_info$(menu_info_slot%, 2) = "$END" -           menu_info$(menu_info_slot%, 3) = "" -           menu_info$(menu_info_slot%, 4) = "" -           menu_info$(menu_info_slot%, 5) = "" @           menu_menu$(menu_menu_slot%, 4) = str$(menu_info_slot%)>                 ! last MENU_INFO$(,) slot for the current menu           menu_load_items_type           do_end% = false          end routine       H         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%1         ! M E N U _ L O A D _ I T E M S _ T Y P E H         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         ! @         ! Load column 5 of the MENU_MENU$(,) slot with an "N" if3         ! this menu contains only "numbered" items. 	         !          ! EXPECTED: ;         !       menu_menu_slot% = current MENU_MENU$(,) row 	         ! 8         !       menu_info$(info_row_max%, info_col_max%)/         !                ! column 1 = menu name -         !                ! column 2 = command <         !                ! column 3 = item number (if $ITEM),         !                ! column 4 = text 1,         !                ! column 5 = text 2	         ! 8         !       menu_menu$(menu_row_max%, menu_col_max%)/         !                ! column 1 = menu name 2         !                ! column 2 = menu headingB         !                ! column 3 = beginning MENU_INFO$(,) slot?         !                ! column 4 = ending MENU_INFO$(,) slot L         !                ! column 5 = "N" if all numbered items on this menu	         !          ! RESULT: J         !        frst_menu_slot%  = first MENU_INFO$(,) slot for this menuI         !        last_menu_slot%  = last MENU_INFO$(,) slot for this menu 	         ! H         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%$         routine menu_load_items_type?           frst_menu_slot% = val(menu_menu$(menu_menu_slot%, 3)) ?           last_menu_slot% = val(menu_menu$(menu_menu_slot%, 4)) 6           z2% = true  ! z2% = true = all numeric items7           for  z1% = frst_menu_slot% to last_menu_slot% E             if  menu_info$(z1%, 2)[1:5] <> "$ITEM"  then  iterate for ?             if  not(valid(menu_info$(z1%, 3), "INTEGER"))  then                z2% = false                exit for             end if           next z1%]           if  z2%  then  menu_menu$(menu_menu_slot%, 5) = "N" ! set "all numbered items" flag          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% C         ! M E N U _ I N C R E M E N T _ M E N U _ I N F O _ S L O T I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! /         ! Increment the MENU_INFO_SLOT% counter 	         !          ! EXPECTED: <         !        menu_info_slot% = menu_info$(,) row counter	         !          ! RESULT: 7         !        menu_info_slot% is incremented by one. 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% -         routine menu_increment_menu_info_slot /           menu_info_slot% = menu_info_slot% + 1          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% =         ! M E N U _ P R O C E S S _ M C L _ D I R E C T I V E I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! "         ! Process a MCL directive.0         ! Directives begin with a "%" character.	         !          ! EXPECTED: D         !       mcl_line$    = MCL file line which begins with a "%"A         !       err_bad_cmd% = mcl_err% value for invalid command F         !       nolead%      = edit$() param to discard leading spacesD         !       ucase%       = edit$() param to convert to uppercase	         !          ! RESULT: 0         !       mcl_err% = error number  if  any	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% *         routine menu_process_mcl_directiveD           z1$ = element$(edit$(mcl_line$, nolead% + ucase%), 1, " ")           select case z1$            case "%INCLUDE" *             menu_process_directive_include           case else #             mcl_err% = err_bad_cmd% !             menu_report_mcl_error            end select         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% E         ! M E N U _ P R O C E S S _ D I R E C T I V E _ I N C L U D E I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! )         ! Process the %INCLUDE directive. 	         !          ! EXPECTED: .         !       mcl_line$ = MCL file text lineC         !       nolead%   = edit$() param to discard leading spaces A         !       noextra%  = edit$() param to discard extra spaces 	         !          ! RESULT: 2         !       mcl_fspec$ = file name to include.	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% .         routine menu_process_directive_include4           z1$ = edit$(mcl_line$, nolead% + noextra%)S           mcl_fspec$ = z1$[len("%INCLUDE ") + 1:len(z1$)] ! name of file to include            menu_check_mcl_file (           if  _error  then  exit routine           menu_open_mcl_file(           if  _error  then  exit routine           menu_read_mcl_file           menu_close_mcl_file          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 7         ! M E N U _ D I S P L A Y _ F I R S T _ M E N U I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! -         ! Set up to display the level 1 menu. 	         !          ! EXPECTED: 6         !       menu_menu$(1, 1) = level one menu name	         !          ! RESULT:          !       cur_menu%   = 1          !       menu_level% = 1 >         !       menu_level$(1, 1) is loaded with the menu name	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% '         routine menu_display_first_menu            cur_menu%   = 1            menu_level% = 1 L           menu_level$(menu_level%, 1) = menu_menu$(cur_menu%, 1) ! menu name=           menu_level$(menu_level%, 2) = "" ! last item chosen &           action$ = "menu_paint_menu"          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% '         ! M E N U _ P A I N T _ M E N U I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! '         ! Paint the screen with a menu. 	         !          ! EXPECTED: J         !       cur_menu%        = current menu number, i.e. menu to paintI         !       frst_menu_slot%  = first MENU_INFO$(,) slot for this menu H         !       last_menu_slot%  = last MENU_INFO$(,) slot for this menu	         ! 8         !       menu_info$(info_row_max%, info_col_max%)/         !                ! column 1 = menu name -         !                ! column 2 = command <         !                ! column 3 = item number (if $ITEM),         !                ! column 4 = text 1,         !                ! column 5 = text 2	         ! 8         !       menu_menu$(menu_row_max%, menu_col_max%)/         !                ! column 1 = menu name 2         !                ! column 2 = menu headingB         !                ! column 3 = beginning MENU_INFO$(,) slot?         !                ! column 4 = ending MENU_INFO$(,) slot L         !                ! column 5 = "N" if all numbered items on this menu	         !          ! RESULT: 1         !       cur_menu$     = current menu name 4         !       menu_heading$ = current menu heading	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          routine menu_paint_menu            if  pop_up_menu then             menu_menu_frame %             action$ = 'menu_ask_item'              exit routine           end if4           cur_menu$       = menu_menu$(cur_menu%, 1)4           menu_heading$   = menu_menu$(cur_menu%, 2)9           frst_menu_slot% = val(menu_menu$(cur_menu%, 3)) 9           last_menu_slot% = val(menu_menu$(cur_menu%, 4)) >           all_numbered_items% = menu_menu$(cur_menu%, 5) = "N"6                 ! this is an "all numbered items" menuB           for menu_info_slot% = frst_menu_slot% to last_menu_slot%6             select case menu_info$(menu_info_slot%, 2)5             case "$MENU"          : menu_display_menu @             case "$HEADING"       : ! we got menu_heading$ above6             case "$TITLE"         : menu_display_title5             case "$TEXT"          : menu_display_text 5             case "$ITEM"          : menu_display_item :             case "$ITEM MENU"     : menu_display_item_menu6             case "$SPLIT"         : menu_display_split3             case "$END"           : ! nothing to do 9             case else             : !??? REPORT ERROR ???              end select           next menu_info_slot%#           action$ = "menu_ask_item"          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% +         ! M E N U _ D I S P L A Y _ M E N U I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! &         ! Painting menu -- found $MENU(         ! Set up to paint a menu screen.	         !          ! RESULT: 2         !       cur_row% = current row is set to 35         !       cur_col% = current column is set to 1 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% !         routine menu_display_menu            menu_menu_frame            cur_row% = 3           cur_col% = 1         end routine              I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% '         ! M E N U _ M E N U _ F R A M E I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! *         ! Create and paint the menu frame.	         !          ! EXPECTED: ,         !        menu_heading$ = header text2         !        cur_menu$     = current menu name+         !        menu_level%   = menu level 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          routine menu_menu_frame            if  pop_up_menu then"             u_str$ = system_title$             screen_frame           else!             u_str$ = system_name$ 6             gosub screen_frame                        #             z3$ = space$(the_width) (             print reverse, at 2, 1 : z3$+             z3$ = " " + menu_heading$ + " " -             z% = (the_width/2) - (len(z3$)/2) 0             print reverse, bold, at 2, z% : z3$;/             print reverse, at 2, 2 : cur_menu$; /             z1$ = "Level: " + str$(menu_level%) A             print reverse, at 2, the_width - len(z1$) : z1$; ' ';            end if           message menu_message$          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% -         ! M E N U _ D I S P L A Y _ T I T L E I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! '         ! Painting menu -- found $TITLE 5         ! Paint a blank line and then the title text. 	         !          ! EXPECTED: 4         !       menu_info_slot% = MENU_INFO$(,) slot	         !          ! RESULT: @         !       cur_row% = current screen row incremented by two	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% "         routine menu_display_title!           cur_row% = cur_row% + 1 U           print reverse, bold, at cur_row%, cur_col% : menu_info$(menu_info_slot%, 4) !           cur_row% = cur_row% + 1          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% +         ! M E N U _ D I S P L A Y _ T E X T I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! '         ! Painting menu -- found $TEXT. 	         !          ! EXPECTED: 4         !       menu_info_slot% = MENU_INFO$(,) slot	         !          ! RESULT: 9         !       cur_row% = current screen row incremented 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% !         routine menu_display_text F           print at cur_row%, cur_col% : menu_info$(menu_info_slot%, 4)!           cur_row% = cur_row% + 1          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% +         ! M E N U _ D I S P L A Y _ I T E M I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! %         ! Painting menu - found $ITEM 	         !          ! EXPECTED: %         !       cur_row% = screen row (         !       cur_col% = screen column(         !       menu_level% = menu level4         !       menu_info_slot% = MENU_INFO$(,) slot3         !       all_numbered_items% = true or false 	         !          ! RESULT: 2         !       cur_row% = current row incremented	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% !         routine menu_display_item '           print at cur_row%, cur_col%:; G           if  menu_info_slot% =  val(menu_level$(menu_level%, 2))  then '             print bold : " *";                     else             print "  ";            end if)           if  (all_numbered_items%)  then C             print bold : lpad$(menu_info$(menu_info_slot%, 3), 2);  5             print " "; menu_info$(menu_info_slot%, 5)            elseD             print bold : rpad$(menu_info$(menu_info_slot%, 3), 10); 5             print " "; menu_info$(menu_info_slot%, 5)            end if5                 ! display the item ID and description !           cur_row% = cur_row% + 1 (                 ! increment line counter         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 6         ! M E N U  _ D I S P L A Y _ I T E M _ M E N UI         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! +         ! Painting menu -- found $ITEM MENU 	         !          ! EXPECTED: -         !       cur_row% = current screen row 0         !       cur_col% = current screen column(         !       menu_level% = menu level4         !       menu_info_slot% = MENU_INFO$(,) slot3         !       all_numbered_items% = true or false 	         !          ! RESULT: 4         !       cur_row% = screen row is incremented	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% &         routine menu_display_item_menu'           print at cur_row%, cur_col%:; G           if  menu_info_slot% =  val(menu_level$(menu_level%, 2))  then              print bold : " *";           else             print "  ";            end ifG                 ! last item chosen on this menu gets marked with an "*" )           if  (all_numbered_items%)  then B             print bold : lpad$(menu_info$(menu_info_slot%, 3), 2);5             print " "; menu_info$(menu_info_slot%, 5)            elseC             print bold : rpad$(menu_info$(menu_info_slot%, 3), 10); 5             print " "; menu_info$(menu_info_slot%, 5)            end if!           cur_row% = cur_row% + 1          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% -         ! M E N U _ D I S P L A Y _ S P L I T I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! '         ! Painting menu -- found $SPLIT C         ! Adjust row and column to start over at top of column two. 	         !          ! RESULT: '         !       cur_row% = set to row 3 +         !       cur_col% = set to column 41 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% "         routine menu_display_split           cur_row% = 3           cur_col% = 41          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% #         ! M E N U _ A S K _ I T E M I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! 3         ! Ask the user for the menu item ID to run. 6         ! They can choose any valid item on any of the          ! "set of menu screens."	         !          ! RESULT: 1         !       requested_item$ = user's repsonse 	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          routine menu_ask_item            if  pop_up_menu then             menu_do_pop_up             exit routine           end if           prompt$ = "Item"           length  = 12           uc_response? = true "           validation$ = 'required'!           help$     = "menu item"            input_response"           clear area 21, 1, 21, 80           if  _back  then              menu_do_back             exit routine           end if           if  _exit  then              menu_do_exit             exit routine           end if)           requested_item$ = trim$(reply$) &           action$ = "menu_verify_item"         end routine   I                                                                           /                                                 J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         ! M E N U   D O   P O P   U P J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         !          ! Brief description:	         !          ! Expected: 	         !          ! Locals: 	         !          ! Results:	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine menu_do_pop_upJ           line input menu menu_text$, default input_menu_default$ : reply$C           if _back and menu_no_finish then   !++nva defined in .int %             action$ = 'exit'          &             exit routine                         end if#             if  _exit or _back then %               action$ = 'menu_finish'                exit routine             end if)             input_menu_default$ = _string $             requested_item$ = reply$(             action$ = 'menu_verify_item'         end routine           I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% )         ! M E N U _ V E R I F Y _ I T E M I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! =         ! Find the MENU_INFO$(,) slot for the requested item. 	         !          ! EXPECTED: 9         !       requested_item$  = user requested item ID I         !       frst_menu_slot%  = first MENU_INFO$(,) slot for this menu H         !       last_menu_slot%  = last MENU_INFO$(,) slot for this menu	         ! 8         !       menu_info$(info_row_max%, info_col_max%)/         !                ! column 1 = menu name -         !                ! column 2 = command <         !                ! column 3 = item number (if $ITEM),         !                ! column 4 = text 1,         !                ! column 5 = text 2	         !          ! RESULT: G         !       menu_info_slot% = MENU_INFO$(,) slot for requested item F         !       desired_menu$   = menu desired item is on if we're not>         !                          already on the correct menu	         ! -         !       menu_level$(menu_row_max%, 2) ,         !                ! row# = menu level/         !                ! column 1 = menu name M         !                ! column 2 = MENU_INFO$(,) slot for last item chosen 	         ! 	         ! B         ! Exceeds 22 lines to completely verify item in one place.	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%           routine menu_verify_item           found_count% = 0%            saved_slot%  = 0% $           for z% = 1% to menu_items%,             menu_info_slot% = menu_item%(z%)I             z1$ = menu_info$(menu_info_slot%, 3%)[1:len(requested_item$)] +             if  requested_item$ = z1$  then .               found_count% = found_count% + 1%,               saved_slot%  = menu_info_slot%=               menu_ambiguous%(found_count%) = menu_info_slot%              end if           next z% <                 ! find MENU_INFO$(,) slot for requested item%           if  found_count% = 0%  then @             message error : "Item not found: " + requested_item$%             action$ = "menu_ask_item"              exit routine           end if$           if  found_count% > 1  then"             menu_display_ambiguous             if  _error  then'               action$ = "menu_ask_item"                exit routine             end if           end if'           menu_info_slot% = saved_slot% /                 ! slot of valid, requested item $           if  not pop_up_menu then &?             menu_level$(menu_level%, 2) = str$(menu_info_slot%) )                 ! update last item chosen 4           select case menu_info$(menu_info_slot%, 2)           case "$ITEM"#             menu_get_procedure_info              if  _error  then'               action$ = "menu_ask_item"                exit routine             end if%             action$ = "menu_run_item"            case "$ITEM MENU" :             desired_menu$ = menu_info$(menu_info_slot%, 4)&             action$ = "menu_call_menu"           end select         end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5         ! M E N U   D I S P L A Y   A M B I G U O U S J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%G         ! an ambiguous selection was entered.  Display them and let the          ! user pick one 	         !          ! Expected: >         !       found_count% = number of ambiguous items found0         !       menu_ambiguous%() = menu numbers	         !          ! Result  : 	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%&         routine menu_display_ambiguous           mda_init           mda_process_items /           if  not mda_done or  reply$ = '' then              set error on           elseB             saved_slot% = menu_ambiguous%(val(reply$) + mda_base%)           end if+           set window : current save_window$          end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         ! M D A   I N I T J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%9         ! setup to display ambiguous menu item selections 	         !          ! Expected: 	         !          ! Result  : 	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine mda_init2           max_ambig_disp% = min(found_count%, 15%)"           mda_display_offset% = 0%           mda_base% = 0%+           ask window : current save_window$ -           clear area 3, 1, 21, current_margin B           clear area box : 3, 1, 5+max_ambig_disp%, current_margin'           z$ = " Ambiguous Menu Items " H           print bold, reverse, at 4, (current_margin/2)-(len(z$)/2) : z$         end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%+         ! M D A   P R O C E S S   I T E M S J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;         ! display the selections and get the users response 	         !u         ! Expected: 	         !          ! Result  :e	         !TJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%!         routine mda_process_items.1           for menu_ambig_ctr% = 1 to found_count%r             mda_display_option;             if  mda_display_offset% = max_ambig_disp%  then                mda_ask%(               if mda_done then  exit for&               mda_display_offset% = 0%I               mda_base% = mda_base% + max_ambig_disp% ! offset into table              end if           next menu_ambig_ctr%!           if  not(mda_done)  thenJ5             if mda_display_offset% > 0  then  mda_ask            end if         end routined      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-         ! M D A   D I S P L A Y   O P T I O NrJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%.         ! display one of the ambiguous options	         !u         ! Expected: <         !       menu_ambiguous%() = array of ambiguous items=         !       menu_info$()      = array of info about itemsiL         !       all_numbered_items% = true if using numbers instead of names	         !          ! Result  : 2         !       mda_display_offset% is incremented	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"         routine mda_display_option.           z = menu_ambiguous%(menu_ambig_ctr%)7           mda_display_offset% = mda_display_offset% + 1 0           print at 4 + mda_display_offset%, 3: &7                   format$(mda_display_offset%, "##) "); '           if  all_numbered_items%  then%D             print lpad$(menu_info$(z, 3), 2); "  "; menu_info$(z, 5)           elseE             print rpad$(menu_info$(z, 3), 10); "  "; menu_info$(z, 5)%           end if         end routine%      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         ! M D A   A S K J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%H         ! ask if one of the items displayed on the screen is the one the         ! user wants	         !          ! Expected:b	         !          ! Result  : 	         !eJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine mda_ask            mda_done = false-           if  mda_display_offset% = 15%  theno6             message "Press RETURN for the next screen"           end if%           prompt$ = "Sequence number"            length = 4I           validation$ = 'integer;allow 1 to ' + str$(mda_display_offset%)            input_response#           if _back  or  _exit  thenn             mda_done = truen             exit routine           end if           if  reply$ <> '' then              mda_done = trueo*           else                            0             if mda_display_offset% = 15%  then &F                 clear area 5, 3, 4+max_ambig_disp%, current_margin - 1           end if         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r7         ! M E N U _ G E T _ P R O C E D U R E _ I N F OfI         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n	         ! 8         ! Get the matching PROCEDURE record inforamtion.	         !e         ! EXPECTED:rG         !       menu_info_slot% = MENU_INFO$(,) slot for requested itemo	         !f         ! RESULT: +         !       error = true  if  not found 	         !tG         !       proc_dispatch_type$  = dispatch type (ROUTINE, COMMAND) 4         !       proc_dispatch_text$  = dispatch text0         !       proc_parameter_text$ = parameter	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% '         routine menu_get_procedure_info M           set structure proc, field name : key menu_info$(menu_info_slot%, 4)g.                 ! procedure name for this item"           if  _extracted = 0 then H             message error : "Item " + menu_info$(menu_info_slot%, 4) + &?                             " not found in PROCEDURE structure"              exit routine           end if4           proc_dispatch_type$  = proc(dispatch_type)4           proc_dispatch_text$  = proc(dispatch_text)5           proc_parameter_text$ = proc(parameter_text)          end routine%      I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o#         ! M E N U _ R U N _ I T E M I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! +         ! Set up the parameter as a symbol. 8         ! Run the chosen item (if a routine or command).	         !          ! EXPECTED: >         !       proc_dispatch_type$  = procedure dispatch typeB         !       proc_dispatch_text$  = routine name or DCL command0         !       proc_parameter_text$ = parameter	         !uI         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine menu_run_item%)           select case proc_dispatch_type$              case "COMMAND"               clear%?               pass "OPER_PARAMETER :== " + proc_parameter_text$p&               pass proc_dispatch_text$             case "ROUTINE",                 dispatch proc_dispatch_text$           end select%           action$ = "menu_paint_menu"d         end routineh      I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e%         ! M E N U _ C A L L _ M E N U I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! *         ! The chosen item is a $ITEM MENU.	         !aF         ! Check if the menu to "call" was already called on our way toE         ! where we are now (we'll go backwards)  OR  if this is a new%&         ! menu (we're going forwards).	         !o         ! EXPECTED:l2         !       menu_level%   = current menu level=         !       desired_menu$ = menu screen we want to set up 	         !          ! RESULT:_:         !       menu_level% = set for new or previous menu1         !       cur_menu$   = set to desired menulA         !       menu_level$(menu_level%, 1) = set to desired menua	         !nI         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%c         routine menu_call_menu           found = false %           for z1% = 1% to menu_level% 9             if  desired_menu$ = menu_level$(z1%, 1)  then                found = true               menu_level% = z1%                exit for             end if           next z1%           if  not found  then )             menu_level% = menu_level% + 1 7             menu_level$(menu_level%, 1) = desired_menu$%,             menu_level$(menu_level%, 2) = ""           end if1           cur_menu$ = menu_level$(menu_level%, 1)r           menu_get_menu_number#                 ! returns cur_menu%x%           action$ = "menu_paint_menu"          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% !         ! M E N U _ D O _ E X I T I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%u	         !u8         ! If we're at the level 1 menu then exit program/         ! else go directly to the level 1 menu.f	         !          ! EXPECTED: 0         !       menu_level% = current menu level	         !u         ! RESULT:%,         !       menu_level% = set to level 1-         !       cur_menu$ = level 1 menu name!         !                  OR          !       exit program	         !iI         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          routine menu_do_exit#           if  menu_level% = 1  thenn#             action$ = "menu_finish"            else             menu_level% = 1 3             cur_menu$ = menu_level$(menu_level%, 1)               menu_get_menu_number#                 ! returns cur_menu% '             action$ = "menu_paint_menu"O           end if         end routinec      I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%u!         ! M E N U _ D O _ B A C K I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! !         ! Go back one menu level. 	         !$         ! EXPECTED:m0         !       menu_level% = current menu level	         !x         ! RESULT: ,         !       menu_level% = new menu level+         !       cur_menu$   = new menu namei	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          routine menu_do_back/           menu_level% = max(1, menu_level% - 1) 8                 ! can't go any farther back than level 11           cur_menu$ = menu_level$(menu_level%, 1)            menu_get_menu_number#                 ! returns cur_menu%u%           action$ = "menu_paint_menu"          end routinef                   I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m1         ! M E N U _ G E T _ M E N U _ N U M B E RlI         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e	         !x4         ! Given a menu name, return the menu number.	         !u         ! EXPECTED: &         !        cur_menu$ = menu name	         ! 8         !       menu_info$(info_row_max%, info_col_max%)/         !                ! column 1 = menu name 	         !          ! RETURNED: (         !        cur_menu% = menu number	         !%I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a$         routine menu_get_menu_number+           for  z1% = 1% to menu_menu_total%s>             if  menu_menu$(z1%, 1) = cur_menu$  then  exit for           next z1%           cur_menu% = z1%          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% /         ! M E N U _ C H E C K _ M C L _ F I L E I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! '         ! Check if the MCL file exists.n	         !r         ! EXPECTED: 1         !        mcl_fspec$  = file to be checkedl@         !       err_no_file% = mcl_err% value for file not found	         !          ! RESULT: 1         !        error = true  if  file NOT found%	         !%I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i#         routine menu_check_mcl_files           error = false ,           if  pos(mcl_fspec$, ".") = 0  then,             mcl_fspec$ = mcl_fspec$ + ".MCL"           end if%           z1$ = findfile$(mcl_fspec$)a           if  z1$ = ""  then             error = true$             mcl_err% = err_no_file% !             menu_report_mcl_error            end if         end routine%      I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 7         ! M E N U _ C H E C K _ C A L L E D _ M E N U S%I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! ?         ! Verify that all of the $ITEM MENU <item-id> menu_namec8         ! actually have a corresponding $MENU menu_name.	         !=         ! EXPECTED:iF         !        menu_info_total% = number of MENU_INFO$(,) slots usedF         !        menu_menu_total% = number of MENU_MENU$(,) slots used	         ! 8         !       menu_info$(info_row_max%, info_col_max%)/         !                ! column 1 = menu namec-         !                ! column 2 = command%<         !                ! column 3 = item number (if $ITEM),         !                ! column 4 = text 1,         !                ! column 5 = text 2	         !e8         !       menu_menu$(menu_row_max%, menu_col_max%)/         !                ! column 1 = menu name 2         !                ! column 2 = menu headingB         !                ! column 3 = beginning MENU_INFO$(,) slot?         !                ! column 4 = ending MENU_INFO$(,) slottL         !                ! column 5 = "N" if all numbered items on this menu	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'         routine menu_check_called_menus%*           for z1% = 1% to menu_info_total%7             if  menu_info$(z1%, 2) = "$ITEM MENU"  then                found = falsee.               for z2% = 1% to menu_menu_total%A                 if  menu_menu$(z2%, 1) = menu_info$(z1%, 4)  then                    found = true                   exit for                 end if               next z2%!               if  not found  then%/                 menu_name$ = menu_info$(z1%, 4)e-                 menu_report_called_menu_errore               end if             end if           next z1%         end routine_      I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lC         ! M E N U _ R E P O R T _ C A L L E D _ M E N U _ E R R O R%I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! ?         ! Report that a $ITEM MENU <item-id> menu_name does not%/         ! have a corresponding $MENU menu_name. 	         !e         ! EXPECTED: <         !       menu_name$ = menu to call that doesn't exist	         !          ! RESULT:e         !       fatal = trueI         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l-         routine menu_report_called_menu_errorc           fatal = true           message error : "">           print bold, at 14, 5 : "Called menu does not exist";5           print at 16, 5 : "Command    : $ITEM MENU";l7           print at 17, 5 : "Menu name  : "; menu_name$;            delayl"           clear area 14, 1, 19, 80*           message "Initializing system..."           print at 23, 52:;%         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%3         ! M E N U _ R E P O R T _ M C L _ E R R O R I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         !c#         ! Report an MCL file error.l	         !          ! EXPECTED:x'         !  mcl_err%      = error number %         !  mcl_level%    = menu level (         !  mcl_line$     = MCL file line<         !  err_no_file%  = mcl_err% value for file not found:         !  err_syntax%   = mcl_err% value for syntax error=         !  err_bad_cmd%  = mcl_err% value for invalid command]I         !  err_no_item%  = mcl_err% value for item not found in PROCEDUREl?         !  err_dup_id%   = mcl_err% value for duplicate item ID ;         !  err_bad_id%   = mcl_err% value for item ID error 	         !          ! RESULT:e         !  fatal         = truee	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %         routine menu_report_mcl_error            fatal = true           message error : ""           print at 14, 5:;           select case mcl_err%?             case err_no_file% :  print bold : "File not found";%=             case err_syntax%  :  print bold : "Syntax error"; @             case err_bad_cmd% :  print bold : "Invalid command";I             case err_no_item% :  print bold : "Item "; item_proc_name$; & G                                               " not found in PROCEDURE")A             case err_dup_id%  :  print bold : "Duplicate item ID"i=             case err_bad_id%  :  print bold : "Item ID error"=           end selectB           print at 16, 5 : "Menu file  : "; mcl_name$(mcl_level%);M           print at 17, 5 : "Line number: "; str$(menu_line_ctr%(mcl_level%));%6           print at 18, 5 : "Statement  : "; mcl_line$;           delayp"           clear area 14, 1, 19, 80*           message "Initializing system..."           print at 23, 52:;s         end routinee      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'         ! M E N U   B U I L D   M E N U J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         !          ! Brief description:	         !          ! Expected: 	         !e         ! Locals:i	         !          ! Results:	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine menu_build_menu            cur_menu% = 1e,           dim mbm_last_info(menu_menu_slot%)+           dim mbm_cur_info(menu_menu_slot%) (           dim mbm_menus(menu_menu_slot%)&           for z = 1 to menu_menu_slot%3             mbm_cur_info(z) = val(menu_menu$(z, 3)) 4             mbm_last_info(z) = val(menu_menu$(z, 4))           next z           mbm_menus(1) = 1           mbm_menu_index = 1G           menu_text$ = '%at 3, center, %autodisplay off, %autovbar off'            mbm_index = 0L           do%             mbm_index = mbm_index + 1r9             if  mbm_index > mbm_last_info(cur_menu%) thend1               mbm_menu_index = mbm_menu_index - 1 1               if  mbm_menu_index = 0 then exit doa3               cur_menu% = mbm_menus(mbm_menu_index)u+               menu_text$ = menu_text$ + '}' 5               mbm_index = mbm_cur_info(cur_menu%) + 1              end if             mbm_get_info              select case mbm_cmd$$               case "$HEADING"                         mbm_append_commaG                 menu_text$ = menu_text$ + '%title "' + mbm_text1$ + '"' $               case "$TITLE"                           mbm_append_comma:                 menu_text$ = menu_text$ + '%heading "' + &"                   mbm_text1$ + '"'.               case "$ITEM"          : mbm_item3               case "$ITEM MENU"     : mbm_item_menu $               case "$SPLIT"                           mbm_append_comma2                 menu_text$ = menu_text$ + '%split'               case elsef             end select           loop           menu_add_exita         end routineu      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#         ! M E N U   A D D   E X I T J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         !i         ! Brief description:F         !  This routine adds 'EXIT' as the last menu item in the main          !  pop-up menu. 	         !          ! Expected: 6         !  menu_text$ is defined from MENU_BUILD_MENU.8         !  u_exit_text$ is defined from the main program
         ! 	         !a         ! Results:!         !  menu_text$ is completeT	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine menu_add_exitx0           menu_text$ = menu_text$ + u_exit_text$         end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%!         ! M B M   G E T   I N F O!J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         !          ! Brief description:	         !m         ! Expected: 	         !c         ! Locals: 	         !          ! Results:	         !uJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine mbm_get_info-           mbm_cmd$ = menu_info$(mbm_index, 2) 5           mbm_prompt$ = menu_info$(mbm_index, 3)[1:9]n/           mbm_text1$ = menu_info$(mbm_index, 4) /           mbm_text2$ = menu_info$(mbm_index, 5)          end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         ! M B M   I T E M   J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         !m         ! Brief description:	         !s         ! Expected:N	         !          ! Locals:m	         !o         ! Results:	         !eJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine mbm_item           mbm_append_comma2           if  valid(mbm_prompt$, 'integer')  then &             z$ = lpad$(mbm_prompt$, 3)             !z = 30              z = 55           else'             z$ = rpad$(mbm_prompt$, 10)o             !z = 24              z = 48           end ifA           !+jls+ increase maximum length of menu item description J           menu_text$ = menu_text$ + '"' + z$ + mbm_text2$[1:z] + '"="' + &             mbm_prompt$ + '"'%         end routine%        J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#         ! M B M   I T E M   M E N U%J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         !m         ! Brief description:	         !          ! Expected:i	         !f         ! Locals: 	         !          ! Results:	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine mbm_item_menuo2           if  valid(mbm_prompt$, 'integer')  then &             z$ = lpad$(mbm_prompt$, 3)             !z = 30              z = 55           else'             z$ = rpad$(mbm_prompt$, 10)              !z = 23              z = 48           end ifA           !+jls+ increase maximum length of menu item description            mbm_append_commaB           menu_text$ = menu_text$ + '"' + z$ + mbm_text2$[1:z] + &2             '"={%replace, %at 3, center'          -           mbm_cur_info(cur_menu%) = mbm_indexg&           for z = 1 to menu_menu_slot%;             if  menu_menu$(z, 1) = mbm_text1$ then exit form           next z           cur_menu% = z -           mbm_index = mbm_cur_info(cur_menu%) -           mbm_menu_index = mbm_menu_index + 1T/           mbm_menus(mbm_menu_index) = cur_menu%          end routine$        J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)         ! M B M   A P P E N D   C O M M AoJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         !2         ! Brief description:	         !          ! Expected:t	         !s         ! Locals:u	         !_         ! Results:	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          routine mbm_append_comma1           if  right$(menu_text$, 1) <> '{' then &u*             menu_text$ = menu_text$ + ','          end routines      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-         ! G E T   V A L I D   O P E R A T O R J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         !%         ! Brief description:,         ! find out how to handle operator id	         !d         ! Expected: =         !       mc(operator_type) = "none", "username", "ask" 	         !          ! Result  :r+         !       dispatch to correct routine 	         !sJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"         routine get_valid_operator           oper_okay = falseu            z$ = mc(operator_type)           select case z$             case "NONE"%+               let oper_menu$ = default_mcl$p               oper_okay = true                pop_up_menu = true(               ask system : user oper_id$"               action$ = 'finished'             case "USERNAME" +               action$ = 'menu_get_username'$             case "ASK"+               action$ = 'menu_ask_operator'u           end select'           do until action$ = 'finished'o             dispatch action$           loop%           if  fatal then exit routine )           if  oper_okay then exit routine%           repeat routine         end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%+         ! M E N U   G E T   U S E R N A M E J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%!         ! get the user's username 	         !e         ! Expected: 	         !e         ! Result  :          !       writea	         !lJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%!         routine menu_get_usernamel"           ask system : user reply$           menu_verify_operator!           if  have_operator  then .             action$ = 'menu_get_operator_info'           else)             action$ = 'menu_ask_password'%           end if         end routinen      I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% +         ! M E N U _ A S K _ O P E R A T O R%I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e	         !n8         ! Ask the user for their operator ID and verify.	         !cH         !  u_*            = information to provide for the "ask" routine2         !  action$        = next action to perform)         !  have_operator% = operator flagoI         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%!         routine menu_ask_operator%#           prompt$   = "Operator ID"            length = 15            uc_response? = true%"           validation$ = 'required'           help$ = 'operator id'            input_response$           if  _back  or  _exit  then              action$ = "finished"             fatal = true             exit routine           end if           menu_verify_operator           user_id$ = reply$i!           if  have_operator  thenn.             action$ = "menu_get_operator_info"           else)             action$ = "menu_ask_password"            end if         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r1         ! M E N U _ V E R I F Y _ O P E R A T O R"I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%$	         !sC         ! Verify the entered operator ID in the OPERATOR structure. 	         !n         ! EXPECTED: 1         !       reply$ = user entered operator ID%	         !%         ! RESULT:%1         !       have_operator% = TRUE   if  found 5         !                        FALSE  if  not found%	         !%)         !  have_operator% = operator flag I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%T$         routine menu_verify_operator3           set structure oper, field id : key reply$l(           have_operator = _extracted = 1         end routine=      I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%p5         ! M E N U _ G E T _ O P E R A T O R _ I N F O I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i	         !tB         ! Get the information from the operator's OPERATOR record.	         !m         ! EXPECTED: )         !       we have a OPERATOR record=	         !"         ! RESULT:I,         !       oper_id$       = operator ID.         !       oper_name$     = operator name2         !       oper_password% = operator password.         !       oper_menu$     = operator menu2         !       oper_initials$ = operator initials	         !$I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t&         routine menu_get_operator_info#           oper_id$       = oper(id) %           oper_name$     = oper(name)>)           oper_password% = oper(password) 8           oper_menu$     = oper(#system_name$ + '_menu')           pop_up_menu = true?           if oper(#system_name$ + '_menu_type') = 'ITEM' then &              pop_up_menu = false '           action$ = "menu_ask_password"          end routinet      I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r+         ! M E N U _ A S K _ P A S S W O R D I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         !%.         ! Ask the operator for their password.E         ! We ask for the password even if we didn't find the matching%B         ! operator record.  If failure, go get next process to do.	         !f         ! EXPECTED: 8         !        access_tries%  = number of access tries4         !        have_operator% = TRUE or FALSE flag*         !        oper_password% = passwordC         !        mc(password_type) = ask if password is to be askedm	         !E+         !        reply$       = user answer 4         !        found          = TRUE or FALSE flagI         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%!         routine menu_ask_passwordn+           access_tries% = access_tries% + 1e-           if  mc(password_type) <> "ASK" thene#             if  have_operator  then "               action$ = "finished"               oper_okay = true             else-               action$ = "menu_access_failure"              end if             exit routine           end ifF           z1$ = "<at 21, 1, noecho, ucase :Password? ^@@@@@@@@@@@@@@>"(           line input screen z1$ : reply$#           clear area 21, 1, 21,  80m%           if  not have_operator  then              found = false            else'             gosub menu_encrypt_passwordi+             found = u_int% = oper_password%            end if           if  found  then               action$ = "finished"             oper_okay = true           else%             gosub menu_access_failure            end if         end routine_      I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%/         ! M E N U _ A C C E S S _ F A I L U R E I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! $         ! Access attempt has failed.%         ! Three tries and you're out.%	         !%         ! EXPECTED:%7         !        access_tries% = number of access trieso?         !        access_limit  = number of access tries allowedt7         !        action$       = next action to perform 3         !        fatal         = TRUE or FALSE flaglI         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% #         routine menu_access_failuret3           message error : "Operator access failure"u0           if  access_tries% < access_limit  thenK             if  mc(operator_type) = 'ASK' or mc(password_type) = 'ASK' then%"               action$ = "finished"               exit routine             end if           end if           fatal = true           action$ = "finished"         end routinee      I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m3         ! M E N U _ E N C R Y P T _ P A S S W O R DsI         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e	         ! .         ! Encrypt (hash) the entered password.	         !%         ! EXPECTED:%,         !       u_str$ = password to encrypt	         !          ! RESULT: -         !       u_int% = "encrypted" password%	         !%I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%g%         routine menu_encrypt_passwordE.           u_int% = convert(hash$(reply$)[1:4])         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          ! M E N U _ F I N I S H I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t	         !          ! Exit the program. 	         !          ! EXPECTED:%7         !       fatal = true  if  couldn't process menut	         !eI         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          routine menu_finish            clearh           if  fatal  then $             u_str$ = "A B O R T E D"           else&             u_str$ = "F I N I S H E D"           end if           gosub center&           print at 10, u_int% : u_str$(           u_str$ = date$(days(date$), 3)           gosub center&           print at 13, u_int% : u_str$           print at 19, 1: ''           action$ = "exit"         end routine%                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          