I {************************************************************************  *									*  *  J U M P								*  *									* B *  JUMP allows a user to login exactly as another user without a	*I *  password. It also allows a more restricted (non-exact) impersonation *  *  of another user.							*  *									* G *  Use of JUMP is restricted to specific categories of users: Systems	* B *  Programmers, Operators and any specifically authorised users.	* *									* 3 *  The syntax of the JUMP command generally is				*  *									* + *      $ JUMP [username] [qualifiers]					*  *									* E *  For full documentation on JUMP, see the HELP file (JUMP.HLP) and	* 2 *  the example access file (JUMP_ACCESS.DAT).				*I *.......................................................................* = *  ****  CAUTION: KERNEL-mode code fiddles things !!! ****		*  *									* / *  JUMP requires the following privileges:				* < *	CMEXEC, CMKRNL, DETACH (or IMPERSONATE), SYSNAM, SYSPRV 	* *									* G *  INSTALL JUMP with these privileges if non-privileged users will be	*  *  running JUMP.							* *									* H *  NOTE: The definition of privilege sets has been adopted for ease of	*H *  coding.  The source for the information is SYS$LIBRARY:STARLET.PAS.	*E *  The definition will need reviewing with each release of OpenVMS!	* I *.......................................................................* F *  ***	CAUTION: JUMP has dependencies on the underlying architecture	*? *  ***		 (VAX, Alpha or I64) and the version of OpenVMS.  Any	* ; *  ***		 changes to either of these *REQUIRES* JUMP to be	*  *  ***		 re-linked.						*I *.......................................................................* / *  Author and Maintainer: Jonathan Ridler.				* I *  Maintained on behalf of ITS, The University of Melbourne, Australia. *  *									* / *  Internet: jump-enquiries@unimelb.edu.au				*  *									*  *  COPYRIGHT NOTICE							*  *									* D *  This software is COPYRIGHT (c) 2004 Jonathan Ridler. ALL RIGHTS	*G *  RESERVED. Permission is granted for not-for-profit redistribution,	* C *  provided all source code, object code and documentation remain	* E *  unchanged from the original distribution, and that all copyright	*   *  notices remain intact.						*I *.......................................................................* E *  DISCLAIMER: This software is provided "AS IS".  It does NOT come	* F *  with any representations or warranties, implicit or otherwise, as	*B *  to its merchantability or fitness for any particular purpose.	*D *  The user assumes ALL risks and responsibilities associated with	*- *  installing and running this software.				* I *.......................................................................*  *									* E *  Revision History: See file CHANGES.TXT in the JUMP distribution.	*  *									* I ************************************************************************}     [INHERIT ('SYS$LIBRARY:STARLET',% 	  'SYS$LIBRARY:PASCAL$CLI_ROUTINES', % 	  'SYS$LIBRARY:PASCAL$LIB_ROUTINES', & 	  'SYS$LIBRARY:PASCAL$MAIL_ROUTINES',& 	  'SYS$LIBRARY:PASCAL$STR_ROUTINES')]    PROGRAM Jump (OUTPUT, Logfile) ;   CONST   I {************************************************************************ I  **** Keep the version up-to-date and in sync with the JUMP.OPT file **** J  ************************************************************************}  0 Version = 'JUMP V5.0 2005-02-19 (19-Feb-2005)' ;   Bell = CHR (07) ;		{ BEL } Xon  = CHR (17) ;		{ XON } Xoff = CHR (19) ;		{ XOFF }  Lf   = CHR (10) ;		{ Linefeed } & Cr   = CHR (13) ;		{ Carriage Return }  B Io_Buflen = 1 * 512 ;		{ *WORDS* = 1 pair of 512 byte R/W blocks }< Rsts = 1 ;			{ Index to read status in pseudo-terminal buf }; Rcnt = 2 ;			{ Count of chars read in pseudo-terminal buf } - Rbuf = 3 ;			{ Actual read data area begins } L Wsts = Io_Buflen DIV 2 + 1 ;	{ Start of write buffer area and write status }A Wcnt = Wsts + 1 ;		{ Count of chars writ in pseudo-terminal buf } 3 Wbuf = Wsts + 2 ;		{ Actual read data area begins } E Ft_Buflen = Io_Buflen - 4 ;	{ *BYTES* Size of buffer for FTA device } B Py_Buflen = Io_Buflen ; 	{ *BYTES* Size of buffer for PYA device }  > Rightsize = 80 ;		{ Number of rightslist entries to retrieve }  ! Alphanum  = ['0'..'9','A'..'Z'] ;  Wildcard  = ['*','%'] ; ! Symbol	  = Alphanum + ['$','_'] ;  Uic_Left  = ['[','<'] ;  Uic_Right = [']','>'] ; 7 Esc_Chars = ['D','F','G','I','K','L','N','P','U','V'] ;    TYPE  " $BOOL  = [BIT(1),UNSAFE] BOOLEAN ; $UBYTE = [BYTE] 0..255 ; $UWORD = [WORD] 0..65535 ;: $UQUAD = [QUAD,UNSAFE] RECORD  L0 , L1 : UNSIGNED ;  END ;   Word_Ptr     = ^$UWORD ;% Unsigned_Ptr = [VOLATILE] ^UNSIGNED ;   6 Privilege = (Cmkrnl,	{  0: May change Mode to Kernel }A 	     Cmexec,	{  1: May change Mode to Exec; MUST follow Cmkrnl } = 	     Sysnam,	{  2: May insert in system logical name table } E 	     Grpnam,	{  3: May insert in group l.n.tab; MUST follow Sysnam } 3 	     Allspool,	{  4: May allocate spooled device } E 	     Detach,	{  5: May create detached processes (aka Impersonate) } , 	     Diagnose,	{  6: May diagnose devices }( 	     Log_Io,	{  7: May do logical I/O }A 	     Group,	{  8: May affect other processes in same UIC group } + 	     Acnt,	{  9: May suppress accounting } @ 	     Prmceb,	{ 10: May create permanent common event clusters }3 	     Prmmbx,	{ 11: May create permanent mail box } - 	     Pswapm,	{ 12: May change process mode } 0 	     Altpri,	{ 13: May set any priority value }0 	     Setprv,	{ 14: May set any privilege bits }2 	     Tmpmbx,	{ 15: May create temporary mailbox }< 	     World,	{ 16: May affect other processes in the world }4 	     Mount,	{ 17: May execute mount ACP functions }& 	     Oper,	{ 18: Operator privilege }- 	     Exquota,	{ 19: May exceed disk quotas } / 	     Netmbx,	{ 20: May create network device } 4 	     Volpro,	{ 21: May override volume protection }) 	     Phy_Io,	{ 22: May do physical I/O } : 	     Bugchk,	{ 23: May make bug check error log entries }: 	     Prmgbl,	{ 24: May create permanent global sections }< 	     Sysgbl,	{ 25: May create system-wide global sections }/ 	     Pfnmap,	{ 26: May map to section by PFN } = 	     Shmem,	{ 27: May allocate structures in shared memory } : 	     Sysprv,	{ 28: Eligible for system protection field }5 	     Bypass,	{ 29: May bypass UIC-based protection } 2 	     Syslck,	{ 30: May create system-wide locks }< 	     Share,	{ 31: May assign channel to non-shared device }3 	     Upgrade,	{ 32: May upgrade object integrity } 5 	     Downgrade, { 33: May downgrade object secrecy } > 	     Grpprv,	{ 34: Group access via system protection field }* 	     Readall,	{ 35: May read any object }A 	     Import,	{ 36: May set classification for unlabeled object } B 	     Audit,	{ 37: May direct audit to system security audit log }6 	     Security,	{ 38: May perform security functions }= 	     Pbit39, Pbit40, Pbit41, Pbit42, Pbit43, Pbit44, Pbit45, = 	     Pbit46, Pbit47, Pbit48, Pbit49, Pbit50, Pbit51, Pbit52, = 	     Pbit53, Pbit54, Pbit55, Pbit56, Pbit57, Pbit58, Pbit59, F 	     Pbit60, Pbit61, Pbit62, Pbit63) ;	{ 39-63: dummy bits: 2 LONGs }  C Privset = PACKED SET OF Privilege ;		{ Allow easy bit union, etc. }   H { Oper_Class defines the bits in the operator class mask. This should be0   reviewed with each major release of OpenVMS. }   Oper_Class = (Central,		{  0 } 	      Printer,		{  1 }  	      Tapes,		{  2 }  	      Disks,		{  3 }  	      Devices,		{  4 }  	      Cards,		{  5 }  	      Network,		{  6 }  	      Cluster,		{  7 } C 	      Opc_Security,	{  8 = SECURITY ... avoid same name as priv! }  	      Reply,		{  9 }  	      Software, 	{ 10 } 	      License,		{ 11 }  	      Oper1,		{ 12 = USER1 }  	      Oper2,		{ 13 = USER2 }  	      Oper3,		{ 14 = USER3 }  	      Oper4,		{ 15 = USER4 }  	      Oper5,		{ 16 = USER5 }  	      Oper6,		{ 17 = USER6 }  	      Oper7,		{ 18 = USER7 }  	      Oper8,		{ 19 = USER8 }  	      Oper9,		{ 20 = USER9 }  	      Oper10,		{ 21 = USER10 }  	      Oper11,		{ 22 = USER11 } ! 	      Oper12) ; 	{ 23 = USER12 }   J Access_Status = (Granted,Denied,Unspecified) ;	{ Status from access file }  J Architecture_Type = (Vax,Alpha,Itanium) ;	{ Past, present ... and future!}  < Status_Block_Type = [UNSAFE] PACKED ARRAY [1..4] OF $UWORD ;   Item_List_Cell = RECORD  		   CASE INTEGER OF 		     1: (			{ Normal Cell }  			 Buffer_Length : $UWORD ; 			 Item_Code     : $UWORD ; 			 Buffer_Addr   : UNSIGNED ; 			 Return_Addr   : UNSIGNED 			) ; 		     2: (			{ Terminator } 			 Terminator    : UNSIGNED 			) ; 		 END ;  I Item_List_Template (Count:INTEGER) = ARRAY [1..Count] OF Item_List_Cell ;   . Username_Type = PACKED ARRAY [1..12] OF CHAR ;  / Rights_Array = ARRAY [1..Rightsize] OF $UQUAD ;   ' { Signal and Mechanism parameters ... }   ' Sig_Args  = ARRAY [0..100] OF INTEGER ; E Mech_Args = ARRAY [0..(SIZE(CHF2$TYPE)-4)DIV 4] OF [UNSAFE] INTEGER ;   < Io_Buffer = [ALIGNED(9),STATIC,UNSAFE]			{ Pagelet aligned } 		RECORD 		  CASE BOOLEAN OF A 		  TRUE:  (Raw : ARRAY [1..Io_Buflen]   OF $UWORD  VALUE ZERO) ; @ 		  FALSE: (One : ARRAY [1..Io_Buflen*2] OF CHAR	  VALUE ZERO) ; 		END ;    Terminal_Chars = PACKED RECORD% 		   Tt_Class    : [POS(0)]  $UBYTE ; % 		   Tt_Type     : [POS(8)]  $UBYTE ; % 		   Tt_Width    : [POS(16)] $UWORD ; & 		   Tt_Devchar  : [POS(32)] TT$TYPE ;' 		   Tt_Devchar2 : [POS(64)] TT2$TYPE ;  		 END ;   Prtctl_Type = PACKED RECORD + 		TTY$V_PC_NOTIME       : [POS(0)]  $BOOL ; + 		TTY$V_PC_DMAENA       : [POS(1)]  $BOOL ; + 		TTY$V_PC_DMAAVL       : [POS(2)]  $BOOL ; + 		TTY$V_PC_PRMMAP       : [POS(3)]  $BOOL ; + 		TTY$V_PC_MAPAVL       : [POS(4)]  $BOOL ; + 		TTY$V_PC_XOFAVL       : [POS(5)]  $BOOL ; + 		TTY$V_PC_XOFENA       : [POS(6)]  $BOOL ; + 		TTY$V_PC_NOCRLF       : [POS(7)]  $BOOL ; * 		TTY$V_PC_BREAK	      : [POS(8)]  $BOOL ;+ 		TTY$V_PC_PORTFDT      : [POS(9)]  $BOOL ; + 		TTY$V_PC_NOMODEM      : [POS(10)] $BOOL ; + 		TTY$V_PC_NODISCONNECT : [POS(11)] $BOOL ; + 		TTY$V_PC_SMART_READ   : [POS(12)] $BOOL ; + 		TTY$V_PC_ACCPORNAM    : [POS(13)] $BOOL ; + 		TTY$V_PC_MULTISESSION : [POS(15)] $BOOL ;  	      END ;   Notify_Mask = RECORD 		CASE INTEGER OF 7 		1: (All_Bits	: UNSIGNED ;) ; 	{ 32 bits - roomy! :) } < 		2: (After	: [BIT, POS(0)] BOOLEAN ;    { EXACT completed }= 		    Before	: [BIT, POS(1)] BOOLEAN ;    { EXACT initiated } > 		    Include_Log : [BIT, POS(2)] BOOLEAN ;    { Log in MAIL }8 		    By_Mail	: [BIT, POS(3)] BOOLEAN ;    { Send MAIL }= 		    By_Opcom	: [BIT, POS(4)] BOOLEAN ;    { OPCOM message } > 		    Vamoose	: [BIT, POS(5)] BOOLEAN ;) ; { Exit if problem } 	      END ;   CONST   N Required_Privs = [Cmexec,Cmkrnl,Detach,Sysnam,Sysprv] ; { Needed to run JUMP }   VAR   " Log ,				{ Log success messages? }" Alter_Ego ,			{ Change Username? }# Transmute ,			{ Change UIC, etc.? }  Auditing ,			{ Audit jumps? } = Real_Mccoy ,			{ Use a pseudo-terminal and *really* do it!? } 8 Double_Check ,			{ Double check general user's access? }4 Narcissus ,			{ Allow users to jump to themselves? }? Broken_Chain ,			{ Attempt to chain when chaining prohibited? } * Figment ,			{ Allow username NOT in UAF? }< Stamp_Uaf ,			{ Update UAF Last Interactive Login + Fails? }. Suspect ,			{ Trying to subvert Secure Mode? }. Houdini ,			{ Allow override of Secure Mode? }* Secure_Mode ,			{ Secure mode requested? }/ System_Secure_Mode ,		{ Secure mode mandated? } < Secure_Logical			{ Logical name is defined /SYSTEM /EXEC ? } : BOOLEAN := FALSE ;  : Chain ,				{ JUMP to target user's allowed JUMP targets? }> Secure_User_Dir 		{ JUMP_USER_DIR defined by System Manager? } : BOOLEAN := TRUE ;   8 Record_Session ,		{ Make a recording of an EXACT jump? }A Psb_Available , 		{ OpenVMS V7.2+ ? ==> Persona Security Block! } = Escape_Hatch ,			{ Escape character defined for EXACT jump? } 6 Jeronimo			{ Have we pulled the ripcord and escaped? } : [VOLATILE] BOOLEAN := FALSE ;   F Ripcord : [VOLATILE] CHAR := 'D' ;	{ Escape character for EXACT jump }  G { If the PSB is implemented, check the system parameter ARB_SUPPORT. If I   this parameter has the value ISS$C_ARB_FULL (= 3), the PSB data will be H   overwritten by data in the obsolete data cells which the PSB replaces.L   In this case, also update the obsolete cells. To avoid having to cater forG   the various versions of STARLET, this check is done in the BUILD_JUMP H   procedure and a module with the appropriate value for this variable is   linked in. }  < Arb_Full_Support		{ Access Rights Block: ARB_SUPPORT = 3 ? } : [VOLATILE,EXTERNAL] BOOLEAN ;   K Max_Sys_Group : INTEGER := 0 ;	{ Maximum UIC group with system privileges }   ! Oper_Class_Mask : UNSIGNED := 0 ;   N Mail_Error_Status : [VOLATILE] UNSIGNED := 0 ;	       { MAIL condition value }  $ Orig_User ,			{ Invoker's username }O New_User : [VOLATILE] VARYING [12] OF CHAR := PAD ('',' ',12) ; { Target user }   + Sanity_Ctl_User ,					{ For CMKRNL checks } + Sanity_Psb_User ,					{ For CMKRNL checks } H Sanity_Jib_User : [VOLATILE] Username_Type := '' ;	{ For CMKRNL checks }  ? Command : VARYING [80] OF CHAR := '' ;			{ Input command line }    Uic ,							{ UIC of caller } @ New_Uic : [VOLATILE] UIC$TYPE := ZERO ; 		{ UIC of target user }   Terminal ,						{ Audit this } Port ,							{ Audit this } $ Physical_Device ,					{ Audit this }D Def_Dev : [VOLATILE] VARYING [64] OF CHAR := '' ;	{ Default device }  4 Target_Attributes ,				{ Target process attributes }3 Secure_Directory ,				{ Directory for secure logs } 3 User_Directory ,				{ Directory for insecure logs } - Session_Log ,					{ Filespec of session log }  Access_List ,					{ Filespec }8 Audit_Trail : VARYING [255] OF CHAR := '' ;	{ Filespec }  H Def_Dir : [VOLATILE] VARYING [255] OF CHAR := '' ;	{ Default directory }  B Notify_Maillist : VARYING [1022] OF CHAR := '' ;	{ Who to notify }  9 Uic_Str : VARYING [15] OF CHAR := ZERO ;		{ String form }   ( Eq_Id_Str ,						{ UIC string handling }@ Id_Str	: VARYING [32] OF CHAR := ZERO ;		{ UIC string handling }  * Minor_Privs ,						{ Not major privs! :) }' Def_Priv ,						{ Target's def  privs } H Auth_Priv : [UNSAFE,VOLATILE]  Privset := ZERO ;	{ Target's auth privs }  1 Oper_Classes : PACKED SET OF Oper_Class := ZERO ;   @ Flags : [VOLATILE]  FLAGS$TYPE := ZERO ;		{ Target's UAF flags }  7 Notify : Notify_Mask := ZERO ;			{ Notification flags }   < Architecture : Architecture_Type := Alpha ;	{ Assume Alpha }   Psb_User_Ptr ,< Jib_User_Ptr : [VOLATILE] ^[VOLATILE] Username_Type := NIL ;  	 Psb_Ptr , 	 Jib_Ptr , 
 Psb_Uic_Ptr , 
 Jib_Uic_Ptr ,  Uic_Ptr : Unsigned_Ptr := NIL ;   / Pchan_Created , 				{ Has Pchan been created? } G Pseudo_Ft : [VOLATILE] BOOLEAN := FALSE ;	{ Is pseudo-terminal FTA0:? }   ( Pchan , 					{ Pseudo-terminal channel }& Rchan , 					{ Real terminal channel }5 Mchan : [VOLATILE] $UWORD := 0 ;		{ Mailbox channel }   D Pdev : VARYING [12] OF CHAR := '' ;		{ Pseudo-terminal device name }  O Pbuf_Range : ARRAY [1..2] OF UNSIGNED := ZERO ; { Quasi descriptor of I/O buf }   L Mbbuf : ARRAY [1..ACC$K_TERMLEN] OF $UBYTE := ZERO ;	{ Termination MBX buf }  O Piosb : [VOLATILE] Status_Block_Type := ZERO ;	{ IOSB for pseudo-terminal IOs }   G Buffer : [VOLATILE] Io_Buffer := ZERO ; 	{ Pseudo-terminal I/O buffer }   @ Rchars : Terminal_Chars := ZERO ;		{ Device chars of real term }  & Exit_Rst ,					{ Exit Handler status }" Pid ,						{ Current process PID }/ Master_Pid ,					{ Current process master PID } 0 Pseudo_Pid ,					{ Pseudo-terminal process PID }E Proc_Cnt : [VOLATILE] UNSIGNED := 0 ;		{ Current proc subproc count }   4 Proc_Cur_Priv ,					      { Caller's current privs }4 Proc_Perm_Priv ,				      { Caller's default privs }P Proc_Auth_Priv : [UNSAFE,VOLATILE]  Privset := ZERO ; { Caller's auth'd  privs }  2 Caller_Rights ,					      { Caller's proc rights }2 Target_Rights ,					      { Target's proc rights }? System_Rights : Rights_Array := ZERO ;		      { System rights }   1 Time_Now : TIMESTAMP ;				      { Real time now }   = Login_Time : $UQUAD := ZERO ;			      { Caller's login time }   K Login_Time_Str : VARYING [23] OF CHAR := '' ;	      { Caller's login time }   K Process_Name : VARYING [16] OF CHAR := '' ;	      { Caller's process name }   E Null_List : Item_List_Template(1) := ZERO ;	      { Empty item list }   ; Logfile : [VOLATILE] TEXT ;			{ Logfile for EXACT session }   D { The values "Jump__*" are condition codes used exclusively by JUMP.<   Details can be found in the Message file (JUMP_MSG.MSG). }   Jump__Badaccfil ,  Jump__Badaudit , Jump__Baddata ,  Jump__Badinclude , Jump__Badlogfil ,  Jump__Badnotify ,  Jump__Badoperclass , Jump__Badprivset , Jump__Baduser ,  Jump__Conflict , Jump__Default ,  Jump__Denied , Jump__Disabled , Jump__Fixnotify ,  Jump__Insaneuic ,  Jump__Insaneuser , Jump__Invescchar , Jump__Invlnm , Jump__Invuser ,  Jump__Ivident ,  Jump__Jumped , Jump__Mailfail , Jump__Nochain ,  Jump__Noescape , Jump__Noinsub ,  Jump__Nopriv , Jump__Nopseudo ,
 Jump__Nosub ,  Jump__Restrict , Jump__Return , Jump__Sameuic ,  Jump__Sameuser , Jump__Setuser ,  Jump__Transfer , Jump__Unsupported ,  Jump__Userabort , + Jump__Version : [EXTERNAL,VALUE] UNSIGNED ;   A { Some system and compiler-related values not found in STARLET. }    CCB$L_UCB ,  CCB$L_CHAN , CCB$K_LENGTH , PCB$L_JIB ,  PCB$L_UIC ,  PCB$AR_NATURAL_PSB , PSB$L_UIC ,  PSB$T_USERNAME , UCB$L_TL_PHYUCB ,  UCB$W_TT_PRTCTL ,  UCB$L_TT_ACCPORNAM , JIB$T_USERNAME , PAS$K_SUCCESS , - PAS$K_FILNOTFOU : [EXTERNAL,VALUE] UNSIGNED ;    CTL$GL_PCB , CTL$GL_CCBBASE ,( CTL$GA_CCB_TABLE : [EXTERNAL] UNSIGNED ;  4 CTL$T_USERNAME : [EXTERNAL,VOLATILE] Username_Type ;    ? FUNCTION Condition_Code (Pascal_Status : UNSIGNED) : UNSIGNED ;   0 { Convert a Pascal status to a condition code. }     BEGIN 	{ Condition_Code } 3   Condition_Code := 16#218644 + Pascal_Status * 8 ;    END ; 	{ Condition_Code }      FUNCTION Get_Logical_Name ( < 		Lognam	: [CLASS_S] PACKED ARRAY [L1..U1:INTEGER] OF CHAR ;# 		Default : VARYING [Sz1] OF CHAR ; & 		VAR Actual : VARYING [Sz2] OF CHAR ;< 		Table	: [CLASS_S] PACKED ARRAY [L2..U2:INTEGER] OF CHAR := 				'LNM$SYSTEM' ; 		Mode	: $UBYTE := PSL$C_EXEC ;  		Lnm_Index  : UNSIGNED := 0 		) : UNSIGNED ;  K { Get the translation of the logical name specified.  If it does not exist, M   use the default value if the index is zero, or flag a non-existant index. }      VAR Rst : UNSIGNED := 0 ; %       Attributes : LNM$TYPE := ZERO ; *       Actual_Mode : $UBYTE := PSL$C_USER ;1       Actual_Table : VARYING [32] OF CHAR := '' ; 3       Item_List  : Item_List_Template (6) := ZERO ;   "   BEGIN       { Get_Logical_Name }#   Item_List[1].Buffer_Length := 4 ; ,   Item_List[1].Item_Code     := LNM$_INDEX ;6   Item_List[1].Buffer_Addr   := IADDRESS (Lnm_Index) ;#   Item_List[1].Return_Addr   := 0 ;   3   Item_List[2].Buffer_Length := SIZE (Attributes) ; 1   Item_List[2].Item_Code     := LNM$_ATTRIBUTES ; 7   Item_List[2].Buffer_Addr   := IADDRESS (Attributes) ; #   Item_List[2].Return_Addr   := 0 ;   :   Item_List[3].Buffer_Length := SIZE (Actual_Table.BODY) ;,   Item_List[3].Item_Code     := LNM$_TABLE ;>   Item_List[3].Buffer_Addr   := IADDRESS (Actual_Table.BODY) ;@   Item_List[3].Return_Addr   := IADDRESS (Actual_Table.LENGTH) ;  #   Item_List[4].Buffer_Length := 1 ; -   Item_List[4].Item_Code     := LNM$_ACMODE ; 8   Item_List[4].Buffer_Addr   := IADDRESS (Actual_Mode) ;#   Item_List[4].Return_Addr   := 0 ;   4   Item_List[5].Buffer_Length := SIZE (Actual.BODY) ;-   Item_List[5].Item_Code     := LNM$_STRING ; 8   Item_List[5].Buffer_Addr   := IADDRESS (Actual.BODY) ;:   Item_List[5].Return_Addr   := IADDRESS (Actual.LENGTH) ;  A   Item_List[6].Terminator    := 0 ;   { Terminate the item list }   1   Rst := $TRNLNM (Attr	 := %REF LNM$M_CASE_BLIND,  		  Tabnam := Table, 		  Lognam := Lognam,  		  Acmode := %REF Mode, 		  Itmlst := Item_List) ;   Get_Logical_Name := Rst ;      Secure_Logical := FALSE ;      IF Rst = SS$_NOLOGNAM  THEN       Actual := Default    ELSE    IF Rst = SS$_NORMAL  THEN 
      BEGIN)      IF NOT Attributes.LNM$V_EXISTS  THEN I 	Get_Logical_Name := SS$_VALNOTVALID ;  { Index not found - tell caller } J      IF (Actual_Mode = PSL$C_EXEC) AND (Actual_Table = 'LNM$SYSTEM')  THEN 	Secure_Logical := TRUE ;       END    ELSE H   IF Rst = SS$_BUFFEROVF  THEN		     { Do nothing - caller must handle }    ELSE    IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ; %   END ;       { of Get_Logical_Name }      PROCEDURE Define_Logical_Name ( < 		Lognam : [CLASS_S] PACKED ARRAY [L1..U1:INTEGER] OF CHAR ;< 		Xlate  : [CLASS_S] PACKED ARRAY [L2..U2:INTEGER] OF CHAR ;= 		Table  : [CLASS_S] PACKED ARRAY [L3..U3:INTEGER] OF CHAR :=  				'LNM$SYSTEM' ;" 		Mode   : $UBYTE := PSL$C_EXEC) ;  K { Define the logical name specified.  BEWARE!  SYSNAM privilege is REQUIRED #   for supervisor mode or greater. }      VAR Rst : UNSIGNED := 0 ; 2       Item_List : Item_List_Template (2) := ZERO ;  %   BEGIN       { Define_Logical_Name } $   Item_List[1].Buffer_Length := U2 ;-   Item_List[1].Item_Code     := LNM$_STRING ; 2   Item_List[1].Buffer_Addr   := IADDRESS (Xlate) ;#   Item_List[1].Return_Addr   := 0 ;   #   Item_List[2].Terminator    := 0 ;   "   Rst := $CRELNM (Tabnam := Table, 		  Lognam := Lognam,  		  Acmode := Mode,  		  Itmlst := Item_List) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ; (   END ;       { of Define_Logical_Name }    2 FUNCTION Oprmsg (Message : VARYING [Len] OF CHAR ;? 		 Oper_Class_Mask : UNSIGNED := 16#00FFFFFF ;	{ 24 bits only } ( 		 Reply : BOOLEAN := FALSE) : BOOLEAN ;  I { Send an operator message (REQUEST).  Limit size to maximum (128 chars). D   If required, wait for a REPLY and flag if an ABORT was received. }     VAR	Rst : UNSIGNED := 0 ;  	Mbx_Chan : $UWORD := 0 ; + 	Msg_Text : VARYING [128] OF CHAR := ZERO ;  	Opr_Reply : OPC$TYPE := ZERO ; # 	Iosb : Status_Block_Type := ZERO ;  	Msg_Dsc : DSC1$TYPE := ZERO ; 	Msg : PACKED RECORD 		Msg_Type : $UBYTE ; # 		Msg_Targ : [BYTE(3)] 0..2**24-1 ;  		Msg_Rqst : UNSIGNED ; ( 		Mess : PACKED ARRAY [1..128] OF CHAR ; 	      END := ZERO ;     BEGIN 	{ Oprmsg } !   Oprmsg := TRUE ;				{ Default }      IF Message.LENGTH > 128  THEN =      Msg_Text := SUBSTR (Message.BODY,1,128)	{ Max msg size }     ELSE       Msg_Text := Message ;    Msg.Msg_Type := OPC$_RQ_RQST ;#   Msg.Msg_Targ := Oper_Class_Mask ;    Msg.Msg_Rqst := 0 ; !   Msg.Mess     := Msg_Text.BODY ; 2   Msg_Dsc.DSC$W_MAXSTRLEN := 8 + Msg_Text.LENGTH ;J   Msg_Dsc.DSC$B_DTYPE	  := DSC$K_DTYPE_T ;	{ Not essential ... but neat! }-   Msg_Dsc.DSC$A_POINTER   := IADDRESS (Msg) ; *   Msg_Dsc.DSC$B_CLASS	  := DSC$K_CLASS_S ;     IF Reply  THEN
      BEGIN<      Rst := $CREMBX (Chan := Mbx_Chan) ;		{ Create mailbox }      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ; 
      END ;  F   Rst := $SNDOPR (%REF Msg_Dsc,%IMMED Mbx_Chan) ;	{ Send to Operator }   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;      IF Reply  THEN
      BEGIN<      Rst := $QIOW (Chan := Mbx_Chan,			{ Read from mailbox } 		   Func := IO$_READVBLK, 		   P1	:= Opr_Reply,  		   P2	:= SIZE (Opr_Reply), 		   Iosb := Iosb) ;      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) 
       ELSE      IF NOT ODD (Iosb[1])  THEN  	LIB$SIGNAL (Iosb[1]) ;   A      Rst := Opr_Reply.OPC$W_MS_STATUS + 65536 * OPCOM$_FACILITY ; "      IF Rst = OPC$_RQSTABORT  THEN 	Oprmsg := FALSE
       ELSE      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;   5      Rst := $DASSGN (Mbx_Chan) ;			{ Delete mailbox }       IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ; 
      END ;   END ; 	{ of Oprmsg }    P FUNCTION  Str_Compress (Source : [CLASS_S] PACKED ARRAY [L..U:INTEGER] OF CHAR ;$ 			VAR  Dest : VARYING [D] OF CHAR ;, 			Collapse : BOOLEAN := FALSE) : UNSIGNED ;  L { Compress a string by removing leading and trailing white space (blanks andL   tabs), and replacing multiple consecutive white space with a single blank./   If collapse is set, remove ALL white space. }   %   CONST  Blanks = [' ',''(9),''(0)] ;  	 Maxsize = 1024 ;F 	 Warn_Inpstrtru = UAND (LIB$_INPSTRTRU,%Xfffffff8) ;	{ Warning only }  !   VAR  S , J , K : INTEGER := 0 ;          Done : BOOLEAN := FALSE ;,        Spacer : VARYING [1] OF CHAR := ' ' ;5        Dstr, Sstr : VARYING [Maxsize] OF CHAR := '' ;      BEGIN 	{ Str_Compress } .   Str_Compress := SS$_NORMAL ;		{ Presume so }   S := LENGTH (Source) ;  %   IF S = 0  THEN			{ Nothing passed }       Dest := ''     ELSE 
      BEGIN      IF S > Maxsize  THEN  	BEGIN$ 	Sstr := SUBSTR (Source,1,Maxsize) ;& 	Str_Compress := INT(Warn_Inpstrtru) ; 	END
       ELSE 	Sstr := Source ;   %      IF Collapse  THEN	Spacer := '' ;   D      IF FIND_MEMBER (Source,Blanks) = 0  THEN		{ Nothing to change }
 	Dstr := Sstr 
       ELSE 	WHILE NOT Done	DO 	  BEGIN& 	  J := FIND_NONMEMBER (Sstr,Blanks) ; 	  IF J = 0  THEN  	     Done := TRUE 	   ELSE 	     BEGIN / 	     Sstr := SUBSTR (Sstr,J,Sstr.LENGTH-J+1) ; & 	     K := FIND_MEMBER (Sstr,Blanks) ; 	     IF K = 0  THEN 		BEGIN  		Dstr := Dstr + Sstr ;  		Done := TRUE ; 		END  	      ELSE  		BEGIN / 		Dstr := Dstr + SUBSTR (Sstr,1,K-1) + Spacer ; + 		Sstr := SUBSTR (Sstr,K,Sstr.LENGTH-K+1) ;  		END ;  	     END ;  	  END ; 	{ of While }        IF Dstr <> ''  THEN! 	IF Dstr[Dstr.LENGTH] = ' '  THEN * 	   Dstr:= SUBSTR (Dstr,1,Dstr.LENGTH-1) ;        IF Dstr.LENGTH <= D  THEN
 	Dest := Dstr 
       ELSE 	BEGIN 	Dest := SUBSTR (Dstr,1,D) ;! 	Str_Compress := LIB$_OUTSTRTRU ;  	END ;
      END ;   END ; 	{ of Str_Compress }    / FUNCTION Secure_File_Open (VAR Fab : FAB$TYPE ;  			   VAR Rab : RAB$TYPE ;" 			   VAR Fyl : TEXT) : UNSIGNED ;  I { Open a file securely - translate all logical names in executive mode. }      VAR Rst : UNSIGNED := 0 ;      BEGIN { Secure_File_Open }>   Fab.FAB$V_LNM_MODE := PSL$C_EXEC ;		{ Executive mode only! }   Rst := $OPEN (Fab) ;   IF ODD (Rst)	THEN       Rst := $CONNECT (Rab) ;   Secure_File_Open := Rst ;    END ; { of Secure_File_Open }     ( PROCEDURE Format_User (Uic : UIC$TYPE) ;  B { Create a string with the UIC in numeric and identifier formats }     VAR  Rst : INTEGER := 0 ;      BEGIN 	{ Format_User }G   Rst := $FAO ('!%U',Uic_Str.LENGTH,%STDESCR Uic_Str.BODY,%IMMED Uic) ;    IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ; E   Rst := $FAO ('!%I',Id_Str.LENGTH,%STDESCR Id_Str.BODY,%IMMED Uic) ;    IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;    IF Uic_Str = Id_Str  THEN       Eq_Id_Str := ''    ELSE "      Eq_Id_Str := ' = ' + Id_Str ;   END ; 	{ of Format_User }      PROCEDURE Get_System_Info ;   : { Get relevant information about the system environment. }     VAR	Rst : INTEGER := 0 ;& 	Arch :	  VARYING [15] OF CHAR := '' ;' 	Version : VARYING  [8] OF CHAR := '' ; # 	Iosb : Status_Block_Type := ZERO ; - 	Item_List : Item_List_Template (5) := ZERO ;      BEGIN 	{ Get_System_Info }#   Item_List[1].Buffer_Length := 4 ; 2   Item_List[1].Item_Code     := SYI$_MAXSYSGROUP ;:   Item_List[1].Buffer_Addr   := IADDRESS (Max_Sys_Group) ;#   Item_List[1].Return_Addr   := 0 ;   6   Item_List[2].Buffer_Length := SIZE (System_Rights) ;4   Item_List[2].Item_Code     := SYI$_SYSTEM_RIGHTS ;:   Item_List[2].Buffer_Addr   := IADDRESS (System_Rights) ;#   Item_List[2].Return_Addr   := 0 ;   $   Item_List[3].Buffer_Length := 15 ;0   Item_List[3].Item_Code     := SYI$_ARCH_NAME ;6   Item_List[3].Buffer_Addr   := IADDRESS (Arch.BODY) ;8   Item_List[3].Return_Addr   := IADDRESS (Arch.LENGTH) ;  #   Item_List[4].Buffer_Length := 8 ; .   Item_List[4].Item_Code     := SYI$_VERSION ;9   Item_List[4].Buffer_Addr   := IADDRESS (Version.BODY) ; ;   Item_List[4].Return_Addr   := IADDRESS (Version.LENGTH) ;   A   Item_List[5].Terminator    := 0 ;   { Terminate the item list }   '   Rst := $GETSYIW (Itmlst := Item_List,  		   Iosb   := Iosb) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)     ELSE    IF NOT ODD (Iosb[1])	THEN       LIB$SIGNAL (Iosb[1]) ;   (   Rst := STR$UPCASE (%DESCR Arch,Arch) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;   D   IF (Arch <> 'VAX') AND (Arch <> 'ALPHA') AND (Arch <> 'IA64') THENA      $EXIT (Jump__Unsupported) ;		  { Should never be the case! }   .   IF Arch = 'VAX'  THEN  Architecture := Vax ;  6   Version := SUBSTR (Version,INDEX(Version,'.')-1,3) ;  I   { The Persona Security Block (PSB) is implemented only on OpenVMS Alpha      from V7.2 onwards. }  B   Psb_Available := (Architecture = Alpha) AND (Version >= '7.2') ;   END ; 	{ of Get_System_Info }      PROCEDURE Get_Caller_Info ;   > { Get relevant information about the invoker of the program. }     VAR	Rst : INTEGER := 0 ;# 	Iosb : Status_Block_Type := ZERO ; . 	Item_List : Item_List_Template (15) := ZERO ;     BEGIN 	{ Get_Caller_Info }#   Item_List[1].Buffer_Length := 8 ; /   Item_List[1].Item_Code     := JPI$_PROCPRIV ; ;   Item_List[1].Buffer_Addr   := IADDRESS (Proc_Perm_Priv) ; #   Item_List[1].Return_Addr   := 0 ;   #   Item_List[2].Buffer_Length := 8 ; /   Item_List[2].Item_Code     := JPI$_AUTHPRIV ; ;   Item_List[2].Buffer_Addr   := IADDRESS (Proc_Auth_Priv) ; #   Item_List[2].Return_Addr   := 0 ;   #   Item_List[3].Buffer_Length := 8 ; .   Item_List[3].Item_Code     := JPI$_CURPRIV ;:   Item_List[3].Buffer_Addr   := IADDRESS (Proc_Cur_Priv) ;#   Item_List[3].Return_Addr   := 0 ;   #   Item_List[4].Buffer_Length := 4 ; *   Item_List[4].Item_Code     := JPI$_UIC ;:   Item_List[4].Buffer_Addr   := IADDRESS (Uic.UIC$L_UIC) ;#   Item_List[4].Return_Addr   := 0 ;   2   Item_List[5].Buffer_Length := SIZE (Orig_User) ;/   Item_List[5].Item_Code     := JPI$_USERNAME ; ;   Item_List[5].Buffer_Addr   := IADDRESS (Orig_User.BODY) ; =   Item_List[5].Return_Addr   := IADDRESS (Orig_User.LENGTH) ;   #   Item_List[6].Buffer_Length := 4 ; *   Item_List[6].Item_Code     := JPI$_PID ;0   Item_List[6].Buffer_Addr   := IADDRESS (Pid) ;#   Item_List[6].Return_Addr   := 0 ;   #   Item_List[7].Buffer_Length := 4 ; 1   Item_List[7].Item_Code     := JPI$_MASTER_PID ; 7   Item_List[7].Buffer_Addr   := IADDRESS (Master_Pid) ; #   Item_List[7].Return_Addr   := 0 ;   #   Item_List[8].Buffer_Length := 4 ; -   Item_List[8].Item_Code     := JPI$_PRCCNT ; 5   Item_List[8].Buffer_Addr   := IADDRESS (Proc_Cnt) ; #   Item_List[8].Return_Addr   := 0 ;   2   Item_List[9].Buffer_Length := SIZE (Port.BODY) ;3   Item_List[9].Item_Code     := JPI$_TT_ACCPORNAM ; 6   Item_List[9].Buffer_Addr   := IADDRESS (Port.BODY) ;8   Item_List[9].Return_Addr   := IADDRESS (Port.LENGTH) ;  7   Item_List[10].Buffer_Length := SIZE (Terminal.BODY) ; 0   Item_List[10].Item_Code     := JPI$_TERMINAL ;;   Item_List[10].Buffer_Addr   := IADDRESS (Terminal.BODY) ; =   Item_List[10].Return_Addr   := IADDRESS (Terminal.LENGTH) ;   >   Item_List[11].Buffer_Length := SIZE (Physical_Device.BODY) ;4   Item_List[11].Item_Code     := JPI$_TT_PHYDEVNAM ;B   Item_List[11].Buffer_Addr   := IADDRESS (Physical_Device.BODY) ;D   Item_List[11].Return_Addr   := IADDRESS (Physical_Device.LENGTH) ;  7   Item_List[12].Buffer_Length := SIZE (Caller_Rights) ; K   Item_List[12].Item_Code     := JPI$_RIGHTSLIST ;	    { Process + System } ;   Item_List[12].Buffer_Addr   := IADDRESS (Caller_Rights) ; $   Item_List[12].Return_Addr   := 0 ;  $   Item_List[13].Buffer_Length := 8 ;0   Item_List[13].Item_Code     := JPI$_LOGINTIM ;8   Item_List[13].Buffer_Addr   := IADDRESS (Login_Time) ;$   Item_List[13].Return_Addr   := 0 ;  %   Item_List[14].Buffer_Length := 16 ; .   Item_List[14].Item_Code     := JPI$_PRCNAM ;?   Item_List[14].Buffer_Addr   := IADDRESS (Process_Name.BODY) ; A   Item_List[14].Return_Addr   := IADDRESS (Process_Name.LENGTH) ;   @   Item_List[15].Terminator    := 0 ;	{ Terminate the item list }  '   Rst := $GETJPIW (Itmlst := Item_List,  		   Iosb   := Iosb) ;     IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)     ELSE    IF NOT ODD (Iosb[1])	THEN       LIB$SIGNAL (Iosb[1]) ;   7   Rst := STR$TRIM (%DESCR Orig_User,%DESCR Orig_User) ;    IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;   %   IF (Physical_Device <> '') AND_THEN %      (Physical_Device[1] = '_')  THEN N       Physical_Device := SUBSTR (Physical_Device,2,Physical_Device.LENGTH-1) ;  F   IF NOT (Required_Privs <= Proc_Cur_Priv)  THEN	{ Got needed privs? }      $EXIT (Jump__Nopriv) ;   I   Rst := $ASCTIM (Login_Time_Str.LENGTH,Login_Time_Str.BODY,Login_Time) ;    IF NOT ODD (Rst) THEN       LIB$SIGNAL (Rst) ; "   IF Login_Time_Str[1]	= ' '  THEN      Login_Time_Str[1] := '0' ;    END ; 	{ of Get_Caller_Info }     % PROCEDURE Audit_Jump (Ok : BOOLEAN) ;   H { Record who, when, where, how, etc. for auditing purposes. Any problems/   opening the audit file will terminate JUMP. }*     VAR	Rst : UNSIGNED := 0 ;*7 	Imprint : VARYING [240] OF CHAR := '' ; 	{ 3 lines!! }U 	Audit : TEXT ;	- 	Stamp : PACKED ARRAY [1..23] OF CHAR := '' ;t     BEGIN 	{ Audit_Jump }aE   OPEN (Audit,FILE_NAME:=Audit_Trail,HISTORY:=Old,SHARING:=READWRITE,t7 	      USER_ACTION:=Secure_File_Open,Error:=CONTINUE) ;e   Rst := STATUS (Audit) ;p   IF Rst <> PAS$K_SUCCESS  THENm
      BEGIN"      LIB$SIGNAL (Jump__Badaudit) ;&      LIB$STOP (Condition_Code (Rst)) ;
      END ;     EXTEND (Audit) ;  -   Rst := $ASCTIM (Timbuf := %STDESCR Stamp) ;u   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;f,   IF Stamp[1] = ' '  THEN  Stamp[1] := '0' ;4   Imprint := SUBSTR (Stamp,1,20) + ' ' + Orig_User ;
   IF Ok  THEN 
      BEGIN7      IF (New_User = Orig_User) AND NOT Real_Mccoy  THEN. 	BEGIN  	Imprint := Imprint + ' from ' ; 	Format_User (Uic) ; 	END
       ELSE 	BEGIN  	Imprint := Imprint + '  to  ' ; 	Format_User (New_Uic) ; 	END ;  )      IF Alter_Ego AND NOT Transmute  THEN	 	Imprint := Imprint + New_User
       ELSE+ 	Imprint := Imprint + Uic_Str + Eq_Id_Str ;g        IF Alter_Ego  THEN $ 	Imprint := Imprint + ' *SETUSER*' ;  "      IF New_User = Orig_User  THEN8 	Format_User (New_Uic) ; 	{ Provide format for display }      END    ELSET9      Imprint := Imprint + ' PRIV violation: ' + Command ;V     IF Broken_Chain  THEN.)      Imprint := Imprint + ' *CHAINING*' ;.     IF Real_Mccoy  THENN
      BEGIN      IF Secure_Mode  THENn 	BEGIN# 	Imprint := Imprint + ' *SECURE*' ;)8 	IF Suspect  THEN  Imprint := Imprint + ' ??SUSPECT??' ; 	END
       ELSE" 	Imprint := Imprint + ' *EXACT*' ;;      IF Pdev <> ''  THEN  Imprint := Imprint + ' ' + Pdev ;.
      END ;  8   IF Port <> ''  THEN  Imprint := Imprint + ' ' + Port ;@   IF Terminal <> ''  THEN  Imprint := Imprint + ' ' + Terminal ;N   IF Physical_Device <> ''  THEN  Imprint := Imprint + ' ' + Physical_Device ;     WRITELN (Audit,Imprint) ;T   CLOSE (Audit) ;	   END ; 	{ of Audit_Jump }    ! PROCEDURE Get_And_Parse_Command ;   E { Get and parse the DCL command line.  Do some basic username checks.u$   Evaluate all JUMP logical names. }  "   VAR	Rst , Spot : UNSIGNED := 0 ; 	Prv : Privilege := Tmpmbx ;$ 	Str : VARYING [255] OF CHAR := '' ;" 	Opclass : Oper_Class := Central ;/ 	Jump_Cld : [EXTERNAL] INTEGER ; { CLD module }.  "   BEGIN 	{ Get_And_Parse_Command }E   Rst := LIB$GET_FOREIGN (%DESCR Command) ;		{ Get the command line }t   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;h      Command := 'JUMP ' + Command ;C   Rst := CLI$DCL_PARSE (Command,%REF Jump_Cld,%IMMED LIB$GET_INPUT, # 			%IMMED LIB$GET_INPUT,'JUMP> ') ; M   IF (Rst = RMS$_EOF) OR (Rst = CLI$_NOCOMD) OR (NOT ODD (Rst)) THEN  $EXIT ;.  C   { If the version is requested, ignore everything else and exit. }v  1   IF CLI$PRESENT ('VERSION') = CLI$_PRESENT  THENi
      BEGIN4      LIB$SIGNAL (Jump__Version,1,%STDESCR Version) ;      $EXIT ;
      END ;  N   Rst := CLI$GET_VALUE ('USERNAME',%DESCR New_User) ;	{ Assume will be there }   IF Rst = CLI$_ABSENT	THENB=      New_User := Orig_User			 { Default to current username }I    ELSEC   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)l    ELSEO
      BEGIN8      Rst := STR$TRIM (%DESCR New_User,%DESCR New_User) ;      IF NOT ODD (Rst)  THENv 	LIB$SIGNAL (Rst) ; 
      END ;  /   IF FIND_NONMEMBER (New_User,Symbol) <> 0 THEN*      $EXIT (Jump__Baduser) ;      Rst := CLI$PRESENT ('EXACT') ;@   Real_Mccoy := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;     IF Real_Mccoy THEN
      BEGIN5      Get_Logical_Name (Lognam  := 'JUMP_SECURE_MODE', 6 		       Default := 'FALSE',		       { SITE-specific } 		       Actual  := Str) ;      Str_Compress (Str,Str) ;=)      Rst := STR$UPCASE (%DESCR Str,Str) ;m      IF NOT ODD (Rst)  THENu 	LIB$SIGNAL (Rst) ;sC      System_Secure_Mode := Str = 'TRUE' ;	{ Mandatory Secure_Mode }   C      Rst := CLI$PRESENT ('SECURE_MODE') ;	{ Requested Secure_Mode }tD      Secure_Mode := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;$      Suspect := Rst = CLI$_NEGATED ;  4      Get_Logical_Name (Lognam  := 'JUMP_SECURE_DIR',< 		       Default := 'SYS_MANAGER:',	       { SITE-specific }' 		       Actual  := Secure_Directory) ;   9      Rst := Get_Logical_Name (Lognam  := 'JUMP_USER_DIR',e: 			      Default := 'SYS$LOGIN:',	       { SITE-specific }% 			      Actual  := User_Directory) ;   I      { If the System Manager has not explicitly defined the JUMP_USER_DIR'I        logical name, allow the user to do so. In this way, EXECUTIVE modeEL        definitions will always override definitions in outer access modes. }         IF Rst = SS$_NOLOGNAM  THEN 	BEGIN5 	Rst := Get_Logical_Name (Lognam  := 'JUMP_USER_DIR',S4 				 Default := 'SYS$LOGIN:',      { SITE-specific } 				 Actual  := User_Directory,  				 Table	 := 'LNM$FILE_DEV', 				 Mode	 := PSL$C_USER) ;	 	IF Rst = SS$_NORMAL  THEN 	   Secure_User_Dir := FALSE ; 	END ;  $      Rst := CLI$PRESENT ('RECORD') ;G      Record_Session := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ; 1      Suspect := Suspect OR (Rst = CLI$_NEGATED) ;p  8      IF Secure_Mode  THEN			{ Requested - set defaults } 	BEGIN7 	Notify.All_Bits := 16#FFFFFFFF ;	{ Full notification }a2 	Record_Session	:= TRUE ;		{ Required, obviously } 	END ;  E      { System_Secure_Mode is handled in Validate_Access.  For now, ifmE        Secure_Mode is requested, allow other qualifiers to modify the         notification profile. }  $      Rst := CLI$PRESENT ('NOTIFY') ;F      IF Rst = CLI$_PRESENT THEN 	{ Present if not explicitly negated } 	BEGIN' 	Rst := CLI$PRESENT ('NOTIFY.BEFORE') ;m) 	Notify.Before := (Rst = CLI$_PRESENT) ORe 			 (Rst = CLI$_DEFAULTED) OR 0 			 (Secure_Mode AND NOT (Rst = CLI$_NEGATED)) ;  & 	Rst := CLI$PRESENT ('NOTIFY.AFTER') ;( 	Notify.After := (Rst = CLI$_PRESENT) OR 			(Rst = CLI$_DEFAULTED) OR/ 			(Secure_Mode AND NOT (Rst = CLI$_NEGATED)) ;v  & 	Rst := CLI$PRESENT ('NOTIFY.OPCOM') ;+ 	Notify.By_Opcom := (Rst = CLI$_PRESENT) OR  			   (Rst = CLI$_DEFAULTED) ORe2 			   (Secure_Mode AND NOT (Rst = CLI$_NEGATED)) ;  % 	Rst := CLI$PRESENT ('NOTIFY.MAIL') ; * 	Notify.By_Mail := (Rst = CLI$_PRESENT) OR 			  (Rst = CLI$_DEFAULTED) OR1 			  (Secure_Mode AND NOT (Rst = CLI$_NEGATED)) ;r  ( 	Rst := CLI$PRESENT ('NOTIFY.INCLUDE') ;) 	Notify.Include_Log := Record_Session AND  			      Notify.By_Mail ANDC! 			      ((Rst = CLI$_PRESENT) OR	# 			       (Rst = CLI$_DEFAULTED) OR 7 			       (Secure_Mode AND NOT (Rst = CLI$_NEGATED))) ;e  3 	Rst := CLI$PRESENT ('NOTIFY.EXIT_ON_MAIL_ERROR') ; * 	Notify.Vamoose := (Rst = CLI$_PRESENT) OR 			  (Rst = CLI$_DEFAULTED) OR' 			  (Secure_Mode AND Notify.By_Mail) ;d  7 	IF Notify.All_Bits = 0	THEN		{ Default to everything }t	 	   BEGIN $ 	   Notify.All_Bits := 16#FFFFFFFF ;* 	   Notify.Include_Log := Record_Session ;	 	   END ;u 	END
       ELSE"      IF Rst = CLI$_DEFAULTED  THEN 	BEGINC 	Notify.All_Bits    := 16#FFFFFFFF ;	{ Full notification, almost? }t' 	Notify.Include_Log := Record_Session ;9 	END ;  .      Rst := CLI$PRESENT ('ESCAPE_CHARACTER') ;A      IF Rst = CLI$_PRESENT THEN 		{ Turn into Control character }t 	BEGIN7 	Rst := CLI$GET_VALUE ('ESCAPE_CHARACTER',%DESCR Str) ;r 	IF Rst = CLI$_ABSENT  THENn5 	   Ripcord := CHR (ORD(Ripcord)-64)		{ Use default }e 	 ELSE 	IF NOT ODD (Rst)  THEN  	   LIB$SIGNAL (Rst) 	 ELSE	 	   BEGINn( 	   Rst := STR$UPCASE (%DESCR Str,Str) ; 	   IF NOT ODD (Rst)  THEN 	      LIB$SIGNAL (Rst) ; @ 	   IF (Str.LENGTH <> 1) OR_ELSE NOT (Str[1] IN Esc_Chars)  THEN$ 	      LIB$SIGNAL (Jump__Invescchar)	 	    ELSE ( 	      Ripcord := CHR (ORD(Str[1])-64) ;	 	   END ;m 	Escape_Hatch := TRUE ;  	END ;      END ;	{ of IF Real_Mccoy }}  6   Get_Logical_Name (Lognam  := 'JUMP_NOTIFY_MAILLIST',4 		    Default := 'SYSTEM',		       { SITE-specific }# 		    Actual  := Notify_Maillist) ;R7   Str_Compress (Notify_Maillist,Notify_Maillist,TRUE) ;   "   Rst := CLI$PRESENT ('SETUSER') ;?   Alter_Ego := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ; .   Transmute := NOT (Alter_Ego OR Real_Mccoy) ;     Rst := CLI$PRESENT ('ALL') ;L   Alter_Ego := Alter_Ego OR (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;  '   Rst := CLI$PRESENT ('OVERRIDE_UAF') ;p=   Figment := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;t  %   Rst := CLI$PRESENT ('UPDATE_UAF') ;1?   Stamp_Uaf := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;F     Rst := CLI$PRESENT ('LOG') ;9   Log := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;       Rst := CLI$PRESENT ('AUDIT') ;>   Auditing := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;2   Get_Logical_Name (Lognam  := 'JUMP_AUDIT_TRAIL',B 		    Default := 'SYS_MANAGER:JUMP_AUDIT.DAT',   { SITE-specific } 		    Actual  := Audit_Trail) ;R  2   Get_Logical_Name (Lognam  := 'JUMP_ACCESS_LIST',B 		    Default := 'SYS_MANAGER:JUMP_ACCESS.DAT',  { SITE-specific } 		    Actual  := Access_List) ;E  3   Get_Logical_Name (Lognam  := 'JUMP_DOUBLE_CHECK',F3 		    Default := 'TRUE',			       { SITE-specific }C 		    Actual  := Str) ;n   Str_Compress (Str,Str) ;&   Rst := STR$UPCASE (%DESCR Str,Str) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;n    Double_Check := Str = 'TRUE' ;  O   { If the current process is a JUMP pseudo-terminal, check for any attributes.O%     Prevent chaining, if necessary. }O  P   Get_Logical_Name (Lognam  := 'JUMP_' + HEX (Pid,8,8),     { Process-specific }3 		    Default := 'NONE',			       { SITE-specific }  		    Actual  := Str) ; N   IF (INDEX (Str,'NOCHAIN ') > 0) AND	    { Chaining has been prohibited ... }H      (New_User <> Orig_User)  THEN	    { ... and it's a real chain ... }        BEGIN        Broken_Chain := TRUE ;         IF Auditing  THEN 	  Audit_Jump (FALSE) ;TD        $EXIT (Jump__Nochain) ;		    { ... c'est bon soir ma chere! }        END ;  #   { Allow an EXACT JUMP to chain? }   ,   Get_Logical_Name (Lognam  := 'JUMP_CHAIN',3 		    Default := 'TRUE',			       { SITE-specific }	 		    Actual  := Str) ;P   Str_Compress (Str,Str) ;&   Rst := STR$UPCASE (%DESCR Str,Str) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;C   Chain := Str = 'TRUE' ;B  +   Get_Logical_Name (Lognam  := 'JUMP_SELF',O3 		    Default := 'TRUE',			       { SITE-specific }T 		    Actual  := Str) ;:   Str_Compress (Str,Str) ;&   Rst := STR$UPCASE (%DESCR Str,Str) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;[   Narcissus := Str = 'TRUE' ;C  2   Get_Logical_Name (Lognam  := 'JUMP_MINOR_PRIVS',; 		    Default := 'NETMBX TMPMBX', 	       { SITE-specific }A 		    Actual  := Str) ;    Str_Compress (Str,Str) ;   REPEAT%     READV (Str,Prv,Error:=CONTINUE) ;B     IF STATUSV <> 0  THENE        $EXIT (Jump__Badprivset) 	      ELSEe        BEGIN+        Minor_Privs := Minor_Privs + [Prv] ;d         Spot := INDEX (Str,' ') ;        IF Spot = 0  THEN 	  Str := '' 	ELSEh/ 	  Str := SUBSTR (Str,Spot+1,Str.LENGTH-Spot) ;.        END ;   UNTIL Str = '' ;  3   Get_Logical_Name (Lognam  := 'JUMP_OPER_CLASSES', 5 		    Default := 'CENTRAL',		       { SITE-specific }r 		    Actual  := Str) ;	   Str_Compress (Str,Str) ;&   Rst := STR$UPCASE (%DESCR Str,Str) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;	D   IF Str = 'SECURITY'  THEN		{ Do nothing - SECURITY only required }    ELSEi
      BEGIN%      Spot := INDEX (Str,'SECURITY') ;e      IF Spot > 0  THEN 	BEGIN! 	IF Spot = 1  THEN			{ First up }d' 	   Str := SUBSTR (Str,10,Str.LENGTH-9)S 	 ELSE* 	IF Spot+7 = Str.LENGTH	THEN		{ Last one }& 	   Str := SUBSTR (Str,1,Str.LENGTH-9) 	 ELSE1 	   Str := SUBSTR (Str,1,Spot-1) +	{ Sandwiched }r+ 		  SUBSTR (Str,Spot+9,Str.LENGTH-Spot-8) ;e 	Str_Compress (Str,Str) ;i 	END ;        REPEAT},        READV (Str,Opclass,Error:=CONTINUE) ;        IF STATUSV <> 0	THENj 	  $EXIT (Jump__Badoperclass)n 	ELSE2 	  BEGIN- 	  Oper_Classes := Oper_Classes + [Opclass] ;c 	  Spot := INDEX (Str,' ') ; 	  IF Spot = 0  THEN 	     Str := ''  	   ELSE2 	     Str := SUBSTR (Str,Spot+1,Str.LENGTH-Spot) ; 	  END ;      UNTIL Str = '' ;'
      END ;  P   Oper_Classes := Oper_Classes + [Opc_Security] ;      { SECURITY is mandatory }-   Oper_Class_Mask := Oper_Classes::UNSIGNED ;l  $   END ; { of Get_And_Parse_Command }    $ FUNCTION Get_Target_Info : BOOLEAN ;  J { Get the required information for the particular new user from the UAF. }     VAR	I , J : INTEGER := 0 ; 	Rst , Ctx : UNSIGNED := 0 ; 	Holder : $UQUAD := ZERO ;- 	Item_List : Item_List_Template (7) := ZERO ;e     BEGIN 	{ Get_Target_Info }#   Item_List[1].Buffer_Length := 8 ;r/   Item_List[1].Item_Code     := UAI$_DEF_PRIV ;T5   Item_List[1].Buffer_Addr   := IADDRESS (Def_Priv) ;r#   Item_List[1].Return_Addr   := 0 ;o  #   Item_List[2].Buffer_Length := 8 ;a+   Item_List[2].Item_Code     := UAI$_PRIV ;u6   Item_List[2].Buffer_Addr   := IADDRESS (Auth_Priv) ;#   Item_List[2].Return_Addr   := 0 ;s  #   Item_List[3].Buffer_Length := 4 ; *   Item_List[3].Item_Code     := UAI$_UIC ;>   Item_List[3].Buffer_Addr   := IADDRESS (New_Uic.UIC$L_UIC) ;#   Item_List[3].Return_Addr   := 0 ;   #   Item_List[4].Buffer_Length := 4 ;y,   Item_List[4].Item_Code     := UAI$_FLAGS ;2   Item_List[4].Buffer_Addr   := IADDRESS (Flags) ;#   Item_List[4].Return_Addr   := 0 ;   0   Item_List[5].Buffer_Length := SIZE (Def_Dir) ;-   Item_List[5].Item_Code     := UAI$_DEFDIR ; 9   Item_List[5].Buffer_Addr   := IADDRESS (Def_Dir.BODY) ; #   Item_List[5].Return_Addr   := 0 ;[  0   Item_List[6].Buffer_Length := SIZE (Def_Dev) ;-   Item_List[6].Item_Code     := UAI$_DEFDEV ;u9   Item_List[6].Buffer_Addr   := IADDRESS (Def_Dev.BODY) ;c#   Item_List[6].Return_Addr   := 0 ;g  ?   Item_List[7].Terminator    := 0 ;	{ Terminate the item list }	  I   Rst := $GETUAI (Usrnam := %STDESCR SUBSTR (New_User,1,New_User.LENGTH),  		  Itmlst := Item_List) ;      Get_Target_Info := ODD (Rst) ;     IF NOT ODD (Rst)  THEN
      BEGIN      IF Rst <> RMS$_RNF  THENo 	LIB$SIGNAL (Rst) ;A      END    ELSE:
      BEGIN.      Def_Dir.LENGTH := INT (Def_Dir.BODY[1]) ;.      Def_Dev.LENGTH := INT (Def_Dev.BODY[1]) ;=      Def_Dir.BODY := SUBSTR (Def_Dir.BODY,2,Def_Dir.LENGTH) ;p=      Def_Dev.BODY := SUBSTR (Def_Dev.BODY,2,Def_Dev.LENGTH) ;   3      { Get the Rights IDs held by the target user }p  %      Holder.L0 := New_Uic.UIC$L_UIC ;e      REPEATR        I := I + 1 ;T+        Rst := $FIND_HELD (Holder := Holder,a  			  Id	 := Target_Rights[I].L0, 			  Contxt := Ctx) ;l7        IF (Rst <> SS$_NOSUCHID) AND NOT ODD (Rst)  THENs 	  LIB$SIGNAL (Rst) ;r4      UNTIL (Rst = SS$_NOSUCHID) OR (I = Rightsize) ;        I := I - 1 ;_
      J := 1 ; &      WHILE System_Rights[J].L0 > 0  DO        BEGIN5        Target_Rights[I+J].L0 := System_Rights[J].L0 ;c        J := J + 1 ;         END ;
      END ;   END ; 	{ of Get_Target_Info }     B FUNCTION Valid_Username (User : VARYING [Len] OF CHAR) : BOOLEAN ;  G { Determine if the string corresponds to a valid username in the UAF. }d  #   VAR	Rst , Flags : UNSIGNED := 0 ;e- 	Item_List : Item_List_Template (2) := ZERO ;Y     BEGIN 	{ Valid_Username } #   Item_List[1].Buffer_Length := 4 ;u,   Item_List[1].Item_Code     := UAI$_FLAGS ;G   Item_List[1].Buffer_Addr   := IADDRESS (Flags) ;	{ Anything will do }O#   Item_List[1].Return_Addr   := 0 ;   ?   Item_List[2].Terminator    := 0 ;	{ Terminate the item list }f  9   Rst := $GETUAI (Usrnam := %STDESCR SUBSTR (User,1,Len),f 		  Itmlst := Item_List) ;     Valid_Username := ODD (Rst) ;	  3   IF NOT ODD (Rst) AND_THEN (Rst <> RMS$_RNF)  THENp      LIB$SIGNAL (Rst) ;u   END ; 	{ of Valid_Username }    9 FUNCTION Parse_Ident (Ident_Str : VARYING [Len] OF CHAR ;p" 		      VAR Ident_Val : UIC$TYPE ;% 		      VAR Parse_Result : UNSIGNED ;}- 		      Req_Type : UNSIGNED := 0) : BOOLEAN ;p  J   { Use LIB$TABLE_PARSE to parse an identifier string.	This neatly handles>     all parsing issues associated with UICs and identifiers. }     CONSTg  E   No_Req  = 0 ; 	{ No specific requirements - any valid value is OK } (   Req_Rid = 1 ; 	{ Must be a Rights ID }"   Req_Uic = 2 ; 	{ Must be a UIC }7   Req_Uic_Nowild = 3 ;	{ Must be a non-wildcarded UIC }r2   Req_Uic_Wild	 = 4 ;	{ Must be a wildcarded UIC }     VAR'     Rst : UNSIGNED := 0 ;t  9   State_Tbl ,				      { TABLE_PARSE table - see source } P   Key_Tbl   : [EXTERNAL,VALUE] UNSIGNED ;     { TABLE_PARSE table - see source }L   Arg_Block : [VOLATILE] TPA$TYPE := ZERO ;   { TABLE_PARSE argument block }     BEGIN 	{ Parse_Ident }   Parse_Ident := FALSE ;  7   Ident_Val.UIC$L_UIC := 0 ;			{ Return null if error } :   Ident_Val.UIC$V_FORMAT := 1 ; 		{ Invalid format value }  -   Arg_Block.TPA$L_COUNT     := TPA$K_COUNT0 ;a$   Arg_Block.TPA$L_STRINGCNT := Len ;:   Arg_Block.TPA$L_STRINGPTR := IADDRESS (Ident_Str.BODY) ;  )   Rst := LIB$TABLE_PARSE (%REF Arg_Block, 0 			  %IMMED State_Tbl,	{ See JUMP MACRO source }0 			  %IMMED Key_Tbl) ;	{ See JUMP MACRO source }     Parse_Result := Rst ;       IF Rst <> LIB$_SYNTAXERR  THEN      IF NOT ODD (Rst)  THENh 	LIB$SIGNAL (Rst)a
       ELSE 	BEGIN0 	Ident_Val.UIC$L_UIC := Arg_Block.TPA$L_NUMBER ; 	IF Req_Type = No_Req  THENe 	   Parse_Ident := TRUE  	 ELSE2 	IF (Ident_Val.UIC$V_FORMAT = UIC$K_ID_FORMAT) AND 	   (Req_Type = Req_Rid)  THEN 	   Parse_Ident := TRUER 	 ELSE3 	IF Ident_Val.UIC$V_FORMAT = UIC$K_UIC_FORMAT  THENv 	   IF (Req_Type  = Req_Uic) OR ' 	      ((Req_Type = Req_Uic_Nowild) AND,8 	       (Ident_Val.UIC$V_GROUP  <> UIC$K_WILD_GROUP) AND9 	       (Ident_Val.UIC$V_MEMBER <> UIC$K_WILD_MEMBER)) ORT% 	      ((Req_Type = Req_Uic_Wild) ANDA1 		((Ident_Val.UIC$V_GROUP  = UIC$K_WILD_GROUP) OR,7 		 (Ident_Val.UIC$V_MEMBER = UIC$K_WILD_MEMBER)))  THEN$ 	      Parse_Ident := TRUE ; 	END ;   END ; 	{ of Parse_Ident }V    * FUNCTION Match_Uic (Id1 , Id2 : UIC$TYPE ;" 		    Exact   : BOOLEAN := FALSE ;- 		    Ordered : BOOLEAN := FALSE) : BOOLEAN ;n  F { Determine if a pair of UICs match, either uniquely if "EXACT", or asB   wildcarded UICs.  If "ORDERED", Id1 must be a "subset" of Id2. }     BEGIN 	{ Match_UIC }   Match_Uic := FALSE ;  9   IF Id1.UIC$L_UIC = Id2.UIC$L_UIC  THEN		{ Exact match }       Match_Uic := TRUE    ELSEG,   IF NOT Exact	THEN					{ Wildcarded forms }      IF Ordered  THENF8 	Match_Uic := ((Id2.UIC$V_MEMBER = UIC$K_WILD_MEMBER) OR2 		      (Id1.UIC$V_MEMBER = Id2.UIC$V_MEMBER)) AND/ 		     ((Id2.UIC$V_GROUP	= UIC$K_WILD_GROUP) ORc, 		      (Id1.UIC$V_GROUP	= Id2.UIC$V_GROUP))
       ELSE8 	Match_Uic := ((Id1.UIC$V_MEMBER = UIC$K_WILD_MEMBER) OR1 		      (Id2.UIC$V_MEMBER = UIC$K_WILD_MEMBER) ORT2 		      (Id1.UIC$V_MEMBER = Id2.UIC$V_MEMBER)) AND/ 		     ((Id1.UIC$V_GROUP	= UIC$K_WILD_GROUP) OR / 		      (Id2.UIC$V_GROUP	= UIC$K_WILD_GROUP) OR6. 		      (Id1.UIC$V_GROUP	= Id2.UIC$V_GROUP)) ;   END ; 	{ of Match_UIC }e    7 FUNCTION Match_List (Candidate	: VARYING [L1] OF CHAR ; ' 		     Targets : VARYING [L2] OF CHAR ;n! 		     Candidate_Uic : UIC$TYPE ;d4 		     Candidate_Rights : Rights_Array) : UNSIGNED ;  M   { Determine if a given candidate string, which may be either a (wildcarded)]J     username, a (wildcarded) UIC, or a rights identifier, is included in a>     list of targets which may be of any of these same types. }  ;   TYPE	Style_Type = (Unknown,Wild_S,User_S,Uic_S,Ident_S) ;]  "   VAR	Rst , Spot : UNSIGNED := 0 ;' 	Negated , Matched : BOOLEAN := FALSE ;:# 	Id_Style : Style_Type := Unknown ; ' 	Dancer : VARYING [100] OF CHAR := '' ;t 	Dancer_Id : UIC$TYPE := ZERO ;A     BEGIN 	{ Match_List }f   Match_List := CLI$_ABSENT ;M     WHILE Targets <> ''  DO_	     BEGIN +     IF Targets[1] = '!'  THEN			{ Negated }c        BEGIN9        IF Targets.LENGTH = 1  THEN		{ Last character??? }[ 	  $EXIT (Jump__Baddata) 	ELSEu3 	  Targets := SUBSTR (Targets,2,Targets.LENGTH-1) ;(        Negated := TRUE ;
        END	      ELSE:        Negated := FALSE ;m  *     IF Targets[1] IN Symbol+Wildcard  THEN        BEGIN9        Spot := FIND_NONMEMBER (Targets,Symbol+Wildcard) ;e        IF Spot = 0  THEN 	  BEGIN 	  Dancer  := Targets ;e 	  Targets := '' ; 	  END 	ELSEA#        IF Targets[Spot] = ','  THENE 	  BEGIN 	  Spot := Spot - 1 ;S& 	  Dancer := SUBSTR (Targets,1,Spot) ; 	  END 	ELSEO 	  $EXIT (Jump__Baddata) ;1        IF FIND_MEMBER (Dancer,Wildcard) > 0  THENe 	  Id_Style := Wild_Se 	ELSE = 	  Id_Style := User_S ;	{ User or ID?  Assume user for now. }M
        END	      ELSEa#     IF Targets[1] IN Uic_Left  THENF        BEGIN0        Spot := FIND_MEMBER (Targets,Uic_Right) ;        IF Spot = 0  THEN 	  $EXIT (Jump__Baddata) ;*        Dancer := SUBSTR (Targets,1,Spot) ;C        IF ((Dancer[1] = '[') AND (Dancer[Dancer.LENGTH] <> ']')) ORP? 	  ((Dancer[1] = '<') AND (Dancer[Dancer.LENGTH] <> '>'))  THENE 	  $EXIT (Jump__Baddata) ;        Id_Style := Uic_S ;
        END	      ELSEN        $EXIT (Jump__Baddata) ;  "     IF Spot < Targets.LENGTH  THEN=        Targets := SUBSTR (Targets,Spot+1,Targets.LENGTH-Spot)r	      ELSER        Targets := '' ;=     IF (Targets.LENGTH > 1) AND_THEN (Targets[1] = ',')  THENt1 	Targets := SUBSTR (Targets,2,Targets.LENGTH-1) ;I  B     IF Id_Style = Unknown  THEN 		  { Huh??? Should never happen }        $EXIT (Jump__Baddata)	      ELSER:     IF Id_Style = Wild_S  THEN				   { Wildcard username }        BEGIN1        Rst := STR$MATCH_WILD (Candidate,Dancer) ;          IF Rst = STR$_MATCH  THEN 	  Matched := TRUE 	ELSE:;        IF NOT ODD (Rst) AND_THEN (Rst <> STR$_NOMATCH)	THEN  	  LIB$SIGNAL (Rst) ;N
        END	      ELSE >     IF (Id_Style = User_S) AND_THEN			      { Exact username }!        (Candidate = Dancer)  THEN; 	  Matched := TRUE.      ELSE					 { Another username, UIC or ID }6     IF NOT Parse_Ident (Dancer,Dancer_Id,Rst) AND_THENP        (((Rst  = LIB$_SYNTAXERR) AND (Id_Style = Uic_S)) OR   { Bad UIC syntax }I 	((Rst <> LIB$_SYNTAXERR) AND NOT ODD (Rst)))  THEN { Parse_Ident error }: 	  $EXIT (Jump__Baddata)	      ELSEM        BEGIN  M       { If we reach here, it's a UIC, a UIC ID or a rights ID that has parsedoE 	successfully to an existing identifier. Ignore UIC IDs that are alsoDH 	usernames to eliminate ambiguity -- usernames always take precedence. }  $        IF (Id_Style = Uic_S) OR_ELSE& 	  (NOT Valid_Username (Dancer))  THEN4 	  IF Dancer_Id.UIC$V_FORMAT = UIC$K_ID_FORMAT  THEN 	     Id_Style := Ident_S  	   ELSE4 	  IF Dancer_Id.UIC$V_FORMAT = UIC$K_UIC_FORMAT	THEN 	     Id_Style := Uic_S ;   ,        IF (Id_Style = Uic_S)  AND				{ UIC }, 	  Match_Uic (Candidate_Uic,Dancer_Id)  THEN 	    Matched := TRUE 	ELSEs3        IF Id_Style = Ident_S  THEN				{ Rights ID }R! 	  FOR Spot := 1 TO Rightsize  DO_? 	      IF Dancer_Id.UIC$L_UIC = Candidate_Rights[Spot].L0  THEN! 		 Matched := TRUE ;        END ;       IF Matched	THENs        IF Negated  THENC 	  Match_List := CLI$_NEGATED  	ELSEN 	  Match_List := CLI$_PRESENT ;x	     END ;    END ; 	{ of Match_List }     PROCEDURE Validate_Access ;R  F { For the type of user running the program, validate the user's access'   against the target user's UAF record.H  H   Non-SysProgs can jump using /NOEXACT only to users who do not have anyI   privileges other than "minor" privileges, or to those to whom access is K   granted in the Access List file. "Minor" privileges are specified through K   a SITE-specific privilege list using the JUMP_MINOR_PRIVS logical name. }I     VAR	I   : INTEGER  := 0 ;s 	Rst : UNSIGNED := 0 ;* 	Chekov ,			{ User has JUMP's rights ID? }1 	Sysprog ,			{ SETPRV or group <= MAXSYSGROUP ? }r 	Operator ,			{ OPER ? }- 	Priv_Target ,			{ Target is "privileged" ? } E 	Id_Check_Ok : BOOLEAN := FALSE ;{ JUMP_ACCESS rights ID check ok ? }OI 	Access : Access_Status := Unspecified ; { Result of access list checks }} 	Jump_Id : UIC$TYPE := ZERO ;o  5   FUNCTION Check_Access_And_Options : Access_Status ;	  K   { Determine if the caller is specifically authorised to access the target;(     user in the access list data file. }  !     VAR I , Spot : INTEGER := 0 ;d& 	Rst , Target_Status : UNSIGNED := 0 ; 	Done : BOOLEAN := FALSE ;& 	Option , Scanning : BOOLEAN := TRUE ;7 	Src , Dst , Opt , Line : VARYING [120] OF CHAR := '' ;)% 	Buf : VARYING [1024] OF CHAR := '' ;t( 	Result : Access_Status := Unspecified ; 	Access : TEXT ;  &     BEGIN	{ Check_Access_And_Options };     Check_Access_And_Options := Unspecified ;			{ Default }A  L     OPEN (Access,FILE_NAME:=Access_List,HISTORY:=READONLY,SHARING:=READONLY,3 		 USER_ACTION:=Secure_File_Open,Error:=CONTINUE) ;r     Rst := STATUS (Access) ;      IF Rst = PAS$K_SUCCESS  THEN        BEGIN        RESET (Access) ;S+        WHILE NOT (EOF (Access) OR Done)  DOB 	 BEGINt 	 READLN (Access,Line) ;3 	 Str_Compress (Line,Line,TRUE) ;		{ Squeeeeeeze! } ( 	 Rst := STR$UPCASE (%DESCR Line,Line) ; 	 IF NOT ODD (Rst)  THEN 	    LIB$SIGNAL (Rst) ;EI 	 IF (Line.LENGTH > 0) AND_THEN (Line[1] <> '#')  THEN  { Not a comment }L
 	    BEGIN7 	    Spot := INDEX (Line,'#') ;			{ Trailing comment? }) 	    IF Spot > 0  THEN( 	       Line := SUBSTR (Line,1,Spot-1) ; 	    Spot := INDEX (Line,'\') ;t- 	    IF Spot > 0  THEN				{ Continued ... ? }B+ 	       Buf := Buf + SUBSTR (Line,1,Spot-1)s
 	     ELSE5 	    IF Line = '!!!'  THEN			{ Terminate processing }I 	       Done := TRUE
 	     ELSE
 	       BEGIN  	       Buf  := Buf + Line ;! 	       Spot := INDEX (Buf,':') ; 2 	       IF Spot = 0  THEN  $EXIT (Jump__Baddata) ;' 	       Src  := SUBSTR (Buf,1,Spot-1) ; 5 	       Dst  := SUBSTR (Buf,Spot+1,Buf.LENGTH-Spot) ; ! 	       Spot := INDEX (Dst,':') ;t 	       IF Spot = 0  THENs
 		  Opt := ''t 		ELSE	 		  BEGINr0 		  Opt := SUBSTR (Dst,Spot+1,Dst.LENGTH-Spot) ;" 		  Dst := SUBSTR (Dst,1,Spot-1) ;	 		  END ;i) 	       IF (Src = '') OR (Dst = '')  THENa 		  $EXIT (Jump__Baddata) ;   9 	       { Check if target user is in valid target list. }l  I 	       Target_Status := Match_List (New_User,Dst,New_Uic,Target_Rights);I  G 	       { If caller is in valid caller list, determine access status. }o   	       IF Match_ListN9 			(Orig_User,Src,Uic,Caller_Rights) = CLI$_PRESENT  THEN;	 		  BEGINFB 		  IF Target_Status = CLI$_PRESENT  THEN  { Newuser in target...}/ 		     Result := Granted			 { ... NOT negated }n	 		   ELSEU; 		  IF Target_Status = CLI$_NEGATED  THEN  { ... negated! }R 		     Result := Deniedr	 		   ELSE . 		     Result := Unspecified ;		 { Not there }  " 		  IF Result <> Unspecified  THEN 		     BEGIN 		     Done := TRUE ; + 		     Check_Access_And_Options := Result ;  		     END ;	 		  END ;   B 	       { If access is Granted, check and action any options ... }  3 	       IF (Result = Granted) AND (Opt <> '')  THENd  		  FOR I := 1 TO Opt.LENGTH  DO 		    IF Scanning  THEN 
 		      BEGINy 		      CASE Opt[I]  OFe& 			'!': Option := FALSE ;			{ Negate }! 			'A': Notify.After  := Option ;0! 			'B': Notify.Before := Option ;:. 			'C': IF NOT Option  THEN	 { Not negatable } 				$EXIT (Jump__Baddata) 
 			      ELSEe 				Chain := FALSE ;
 			'E': BEGINR) 			     IF (Option AND NOT Real_Mccoy) ORm% 				(Real_Mccoy AND NOT Option)  THENL* 				  Check_Access_And_Options := Denied ;7 			     IF (NOT Option) AND (Opt <> '!E')	THEN	{ ONLY }; 				$EXIT (Jump__Baddata) ; 
 			     END ;t( 			'I': Notify.Include_Log := Option AND 						   Record_Session AND_ 						   Notify.By_Mail  ;" 			'M': Notify.By_Mail := Option ;
 			'N': BEGINt; 			     Notify.All_Bits := Option::Unsigned8 * 16#FFFFFFFF;L9 			     Notify.Include_Log := Record_Session AND Option ;:
 			     END ;E# 			'O': Notify.By_Opcom := Option ;A 			'R': IF Opt[1] = 'S'  THENs 				$EXIT (Jump__Baddata)E
 			      ELSE)+ 			     IF Secure_Mode AND NOT Option  THEN  				$EXIT (Jump__Conflict)
 			      ELSE; 				Record_Session := Option ;
 			'S': BEGINs 			     IF I <> 1	THEN 				$EXIT (Jump__Baddata) ;S 			     Secure_Mode := TRUE ;L( 			     Notify.All_Bits := 16#FFFFFFFF ;! 			     Record_Session  := TRUE ;I
 			     END ;e
 			'X': BEGINI0 			     IF Opt <> 'X'  THEN	{ Must be just 'X' } 				$EXIT (Jump__Baddata) ;  			     Houdini := TRUE ; 
 			     END ;  			'+', ( 			'=': BEGIN			{ Buf no longer in use } 			     IF NOT Option  THENN 				$EXIT (Jump__Baddata) ; . 			     Buf := SUBSTR (Opt,I+1,Opt.LENGTH-I) ; 			     IF Opt[I] = '+'  THENT, 				Notify_Maillist := Notify_Maillist + Buf
 			      ELSE  				Notify_Maillist := Buf ;) 			     Scanning := FALSE ;	{ Stop here }i
 			     END ;n 			OTHERWISE 			     $EXIT (Jump__Baddata) ;( 			END ;	{ of Case }  ( 		      IF Opt[I] <> '!'	THEN		{ Reset } 			 Option := TRUE ; 		      END ;	{ of FOR }  , 	       Buf := '' ;		{ Logical end of line }4 	       END ;	{ of continue processing (not "!!!") } 	    END ;	{ of not a comment }v 	 END ;		{ of WHILE } 2        IF Buf <> ''  THEN		{ Continuation?  Huh? } 	  $EXIT (Jump__Baddata) ;        CLOSE (Access) ;:'        END		{ of successful file open } 	      ELSE[K     IF Rst <> PAS$K_FILNOTFOU  THEN	{ Ignore FILNOTFOU - file is optional }         BEGIN%        LIB$SIGNAL (Jump__Badaccfil) ;v'        LIB$STOP (Condition_Code(Rst)) ;         END ;  *     IF (Notify.Before OR Notify.After) AND3        NOT (Notify.By_Mail OR Notify.By_Opcom)	THEN_ 	 $EXIT (Jump__Badnotify) ;_       IF Notify.Include_Log ANDd3        NOT (Record_Session AND Notify.By_Mail)	THEN  	 $EXIT (Jump__Badinclude) ;  /     IF System_Secure_Mode AND NOT Houdini  THENA        BEGIN'        Notify.All_Bits := 16#FFFFFFFF ;:         Record_Session  := TRUE ;        Secure_Mode := TRUE ;        END ;  .     IF (Notify.By_Mail OR Notify.By_Opcom) AND0        NOT (Notify.Before OR Notify.After)  THEN        BEGIN        Notify.After  := TRUE ;        Notify.Before := TRUE ;%        LIB$SIGNAL (Jump__Fixnotify) ;         END ;       IF Secure_Mode  THEN        BEGIN        IF Notify.By_Mail  THEN 	  BEGIN 	  Notify.Vamoose := TRUE ; 1 	  Notify.Before  := TRUE ;	{ After is too late }I 	  END ;        IF Escape_Hatch	THEN[ 	  BEGIN 	  Escape_Hatch := FALSE ;  	  LIB$SIGNAL (Jump__Noescape) ; 	  END ;        END ;  <     Suspect := Suspect AND (Secure_Mode OR Record_Session) ;)     END ;	{ of Check_Access_And_Options }D    A   PROCEDURE Validate_Maillist (Listname : VARYING [Sz] OF CHAR) ;s  H   { Check the addresses in the Mailing List file to see if there are anyE     dodgy logical names (not defined /SYSTEM /EXEC).  The validity ofR#     mail addresses is not tested. }]  $     VAR  Rst , Spot : INTEGER := 0 ; 	 Done : BOOLEAN := FALSE ; 4 	 Dest_Addr , Result : VARYING [255] OF CHAR := '' ; 	 Dis_File : TEXT ;;       BEGIN	{ Validate_Maillist }A;     Dest_Addr := SUBSTR (Listname,2,Sz-1) ;  { Remove "@" }ZL     OPEN (Dis_File,FILE_NAME:=Dest_Addr,HISTORY:=READONLY,SHARING:=READONLY,5 		   USER_ACTION:=Secure_File_Open,Error:=CONTINUE) ;      Rst := STATUS (Dis_File) ;!     IF Rst <> PAS$K_SUCCESS  THEN L        LIB$SIGNAL (Condition_Code (Rst))   { Map to a condition code value }	      ELSE         BEGIN        RESET (Dis_File) ;.-        WHILE NOT (Done OR EOF (Dis_File))  DO) 	 BEGINm 	 READLN (Dis_File,Dest_Addr) ;S+ 	 Str_Compress (Dest_Addr,Dest_Addr,TRUE) ;2! 	 Spot := INDEX (Dest_Addr,'!') ;h 	 IF Spot > 1  THEN2/ 	    Dest_Addr := SUBSTR (Dest_Addr,1,Spot-1) ;s 	 IF Spot <> 1  THEN
 	    BEGIN5 	    Rst := Get_Logical_Name (Dest_Addr,'###',Result,2% 				     'LNM$FILE_DEV',PSL$C_USER) ;3: 	    IF NOT ((Rst = SS$_NOLOGNAM) OR Secure_Logical)  THEN# 	       LIB$SIGNAL (Jump__Invlnm,1,A7 			   %STDESCR SUBSTR (Dest_Addr,1,Dest_Addr.LENGTH)) ;A 	    Done := NOT ODD (Rst) ;
 	    END ; 	 END ;         CLOSE (Dis_File) ;d        END ;"     END ;	{ of Validate_Maillist }    "   PROCEDURE Validate_Notify_List ;  J   { Check the addresses in the JUMP_NOTIFY_MAILLIST logical name to see ifG     there are any dodgy logical names (not defined /SYSTEM /EXEC).  TheJ/     validity of mail addresses is not tested. };  !     VAR  Rst , I : INTEGER := 0 ;B
 	 Dest_Addr , 
 	 Result ,+ 	 Addr_List : VARYING [255] OF CHAR := '' ;I  "     BEGIN	{ Validate_Notify_List }  "     Addr_List := Notify_Maillist ;  !     WHILE Addr_List.LENGTH > 0	DO        BEGIN "       I := INDEX (Addr_List,',') ;       IF I > 0	THENc 	 BEGIN') 	 Dest_Addr := SUBSTR (Addr_List,1,I-1) ;P: 	 Addr_List := SUBSTR (Addr_List,I+1,Addr_List.LENGTH-I) ; 	 ENDP        ELSEC 	 BEGIN  	 Dest_Addr := Addr_List ; 	 Addr_List := '' ;r 	 END ;   #       IF Dest_Addr.LENGTH > 0  THEN, 	 BEGINe 	 IF Dest_Addr[1] = '@'	THEN" 	    Validate_Maillist (Dest_Addr) 	  ELSE 
 	    BEGIN5 	    Rst := Get_Logical_Name (Dest_Addr,'###',Result, % 				     'LNM$FILE_DEV',PSL$C_USER) ; : 	    IF NOT ((Rst = SS$_NOLOGNAM) OR Secure_Logical)  THEN# 	       LIB$SIGNAL (Jump__Invlnm,1,p7 			   %STDESCR SUBSTR (Dest_Addr,1,Dest_Addr.LENGTH)) ;t
 	    END ; 	 END ;s       END ;:$   END ; 	{ of Validate_Notify_List }       BEGIN 	{ Validate_Access }  G   { Check that the invoker has the required access to run this program.dH     This is independant of any installed privileges.  Identify SysProgs.D     If need be, check to see if process has JUMP_ACCESS rights ID. }     IF Double_Check  THEN 
      BEGINI      IF NOT Parse_Ident ('JUMP_ACCESS',Jump_Id,Rst,1)  THEN	{ Rights ID }B 	$EXIT (Jump__Ivident) ;
      I := 1 ;;      REPEAT(:        Chekov := Jump_Id.UIC$L_UIC = Caller_Rights[I].L0 ;        I := I + 1 ;H&      UNTIL Chekov OR (I > Rightsize) ;
      END ;  B   Id_Check_Ok := (Double_Check AND Chekov) OR (NOT Double_Check) ;  :   IF NOT Real_Mccoy  THEN		{ For "poor man's" JUMP only. }
      BEGINB      IF Proc_Cnt > 0  THEN		{ Don't jump if we have subprocesses } 	$EXIT (Jump__Nosub) ;  F      IF Pid <> Master_Pid  THEN		{ Don't jump if we are a subprocess } 	$EXIT (Jump__Noinsub) ;
      END ;  3   Sysprog  := (Uic.UIC$V_GROUP <= Max_Sys_Group) OR $ 	      (Setprv IN Proc_Auth_Priv) OR# 	      (Setprv IN Proc_Perm_Priv) ;T  )   Operator := (Oper IN Proc_Auth_Priv) OR ! 	      (Oper IN Proc_Perm_Priv) ;   "   IF Figment AND NOT Sysprog  THEN      $EXIT (Jump__Nopriv) ;      IF NOT Get_Target_Info  THENE      IF Figment AND Alter_Ego AND NOT (Transmute OR Real_Mccoy)  THENp 	LIB$SIGNAL (Jump__Invuser)*
       ELSE% 	LIB$STOP (Jump__Invuser) ;	{ Fatal }   &   Access := Check_Access_And_Options ;  5   Priv_Target := ((Auth_Priv - Minor_Privs) <> []) ORr' 		 ((Def_Priv  - Minor_Privs) <> []) OR + 		 (New_Uic.UIC$V_GROUP <= Max_Sys_Group) ;d     IF (NOT (Sysprog OR=+ 	   ((Access = Granted) AND Id_Check_Ok) ORP 	   ((Access <> Denied) ANDm' 	    ((Operator AND NOT Priv_Target) OR 2 	    ((New_User = Orig_User) AND Narcissus))))) OR&      (NOT Auditing AND NOT Sysprog) OR&      (Alter_Ego AND NOT Sysprog)  THEN        BEGIN        Audit_Jump (FALSE) ;	        $EXIT (Jump__Nopriv) ;         END ;  E   IF Alter_Ego AND (New_User = Orig_User)  THEN 	{ Change username? }b
      BEGIN"      LIB$SIGNAL (Jump__Sameuser,1,4 		 %STDESCR SUBSTR (Orig_User,1,Orig_User.LENGTH)) ;      $EXIT ;
      END ;  O   IF Transmute AND (New_Uic.UIC$L_UIC = Uic.UIC$L_UIC)	THEN { Change UIC etc? }l
      BEGIN8      LIB$SIGNAL (Jump__Sameuic,1,%IMMED Uic.UIC$L_UIC) ;      $EXIT ;
      END ;  (   IF Sysprog AND (Access = Denied)  THEN       LIB$SIGNAL (Jump__Denied) ;  :   IF (Flags.UAI$V_RESTRICTED OR Flags.UAI$V_CAPTIVE)  THEN
      BEGIN+      IF Sysprog OR (Access = Granted)  THENL 	LIB$SIGNAL (Jump__Restrict)
       ELSE' 	LIB$STOP (Jump__Restrict) ;		{ Fatal }   3      IF Escape_Hatch  THEN			{ Don't allow escape }  	BEGIN 	Escape_Hatch := FALSE ; 	LIB$SIGNAL (Jump__Noescape) ; 	END ;
      END ;     IF Flags.UAI$V_DISACNT  THEN      IF Figment  THENG 	LIB$SIGNAL (Jump__Disabled)
       ELSE' 	LIB$STOP (Jump__Disabled) ;		{ Fatal }G  A   IF Secure_Mode AND Notify.By_Mail  THEN  Validate_Notify_List ;F   END ; 	{ of Validate_Access }w    , [ASYNCHRONOUS] FUNCTION Mail_Error_Handler ( 			VAR Sa : Sig_Args;T+ 			VAR Ma : Mech_Args) : [UNSAFE] INTEGER ;E  F { A simple handler that always allows MAIL to handle the condition ...G   but ensures the status returned is accurate!	This is required for theFC   MAIL$SEND_MESSAGE routine which fails to return its status to the)   caller! 8-(( }     BEGINE<   Mail_Error_Status  := Sa[1] ; 	{ Primary condition value }A   Mail_Error_Handler := SS$_RESIGNAL ;	{ Propagate back to MAIL }N   END ;a    P FUNCTION Send_Mail_Message (To_Address : PACKED ARRAY [L0..H0:INTEGER] OF CHAR ;; 			    Subj_Line  : PACKED ARRAY [L1..H1:INTEGER] OF CHAR ; 9 			    Msg_Text   : PACKED ARRAY [L2..H2:INTEGER] OF CHARt 		) : INTEGER ;G  K { Send a mail message using Callable MAIL.  The Msg_Text is treated firstly E   as the file specification of a message file to be used in a call to L   MAIL$SEND_ADD_BODYPART.  If it is not a valid specification of an existingG   file, the Msg_Text will be inserted into the mail message verbatim. }M  !   VAR  I , Rst	 : INTEGER  := 0 ;S        Mail_Ctx  ,,        Context	 : [VOLATILE] UNSIGNED := 0 ;2        Mail_List : Item_List_Template(2) := ZERO ;        Addr_List,I?        Dest_Addr : STRING (MAX(510,SIZE(To_Address))) := ZERO ;         Msg_Buff,4        Msg_Line  : STRING (SIZE(Msg_Text)) := ZERO ;0        Msg_File  : VARYING [255] OF CHAR := '' ;        Dis_File  : TEXT ;u  (   FUNCTION Distribution_List : INTEGER ;  $     VAR  Rst , Spot : INTEGER := 0 ; 	 Done : BOOLEAN := FALSE ;o       BEGIN	{ Distribution_List }MK     Dest_Addr := SUBSTR (Dest_Addr,2,LENGTH(Dest_Addr)-1) ;  { Remove "@" }DL     OPEN (Dis_File,FILE_NAME:=Dest_Addr,HISTORY:=READONLY,SHARING:=READONLY,5 		   USER_ACTION:=Secure_File_Open,Error:=CONTINUE) ;_     Rst := STATUS (Dis_File) ;!     IF Rst <> PAS$K_SUCCESS  THEN;D        Rst := Condition_Code (Rst)	{ Map to a condition code value }	      ELSEL        BEGIN        RESET (Dis_File) ; -        WHILE NOT (Done OR EOF (Dis_File))  DO  	 BEGIN  	 READLN (Dis_File,Dest_Addr) ;e+ 	 Str_Compress (Dest_Addr,Dest_Addr,TRUE) ;:! 	 Spot := INDEX (Dest_Addr,'!') ;  	 IF Spot > 1  THEN=/ 	    Dest_Addr := SUBSTR (Dest_Addr,1,Spot-1) ;{ 	 IF Spot <> 1  THEN
 	    BEGIN7 	    Mail_List[1].Buffer_Length := LENGTH (Dest_Addr) ;uB 	    Rst := MAIL$SEND_ADD_ADDRESS (Mail_Ctx,Mail_List,Null_List) ; 	    Done := NOT ODD (Rst) ;
 	    END ; 	 END ;         CLOSE (Dis_File) ;E        END ;     Distribution_List := Rst ;"     END ;	{ of Distribution_List }     BEGIN 	{ Send_Mail_Message }  #   { Prepare the Mail SEND context }A  9   Rst := MAIL$SEND_BEGIN (Mail_Ctx,Null_List,Null_List) ; +   IF Notify.Vamoose AND NOT ODD (Rst)  THENt"      LIB$SIGNAL (Jump__Mailfail) ;      { Set up the To: address(es) }  7   Mail_List[1].Buffer_Length := 0 ;			{ Initially ... }$5   Mail_List[1].Item_Code     := MAIL$_SEND_USERNAME ;C;   Mail_List[1].Buffer_Addr   := IADDRESS (Dest_Addr.BODY) ;c#   Mail_List[1].Return_Addr   := 0 ;)  ?   Mail_List[2].Terminator    := 0 ;	{ Terminate the item list }s     Addr_List := To_Address ;   !   WHILE LENGTH (Addr_List) > 0	DOd	     BEGINR      I := INDEX (Addr_List,',') ;     IF I > 0  THEN        BEGIN.        Dest_Addr := SUBSTR (Addr_List,1,I-1) ;@        Addr_List := SUBSTR (Addr_List,I+1,LENGTH(Addr_List)-I) ;
        END	      ELSEL        BEGIN        Dest_Addr := Addr_List ;         Addr_List := '' ;        END ;#     IF LENGTH (Dest_Addr) > 0  THENN        BEGIN"        IF Dest_Addr[1] = '@'  THEN 	  Rst := Distribution_List( 	ELSEM 	  BEGIN5 	  Mail_List[1].Buffer_Length := LENGTH (Dest_Addr) ;a@ 	  Rst := MAIL$SEND_ADD_ADDRESS (Mail_Ctx,Mail_List,Null_List) ; 	  END ;0        IF Notify.Vamoose AND NOT ODD (Rst)  THEN  	  LIB$SIGNAL (Jump__Mailfail) ;        END ;	     END ;G     { Set up the Subject line }F  4   Mail_List[1].Buffer_Length := LENGTH (Subj_Line) ;4   Mail_List[1].Item_Code     := MAIL$_SEND_SUBJECT ;6   Mail_List[1].Buffer_Addr   := IADDRESS (Subj_Line) ;#   Mail_List[1].Return_Addr   := 0 ;   #   Mail_List[2].Terminator    := 0 ;A  A   Rst := MAIL$SEND_ADD_ATTRIBUTE (Mail_Ctx,Mail_List,Null_List) ;r+   IF Notify.Vamoose AND NOT ODD (Rst)  THEN "      LIB$SIGNAL (Jump__Mailfail) ;  I   { Determine if Msg_Text is a valid specification of an existing file. })  -   Rst := LIB$FIND_FILE (Filespec := Msg_Text, ) 			Resultant_Filespec := %DESCR Msg_File,N 			Context  := Context, " 			Flags	 := 0) ;	{ No wildcards }  0   IF ODD (Rst)	THEN	{ File exists - attach it. }
      BEGIN6      Mail_List[1].Buffer_Length := LENGTH (Msg_Text) ;4      Mail_List[1].Item_Code	:= MAIL$_SEND_FILENAME ;6      Mail_List[1].Buffer_Addr	:= IADDRESS (Msg_Text) ;$      Mail_List[1].Return_Addr	:= 0 ;  #      Mail_List[2].Terminator	:= 0 ;(  C      Rst := MAIL$SEND_ADD_BODYPART (Mail_Ctx,Mail_List,Null_List) ;S.      IF Notify.Vamoose AND NOT ODD (Rst)  THEN 	LIB$SIGNAL (Jump__Mailfail) ;      ENDF    ELSE 	{ Split Msg_Text at LF characters and send record by record }
      BEGIN4      Mail_List[1].Item_Code   := MAIL$_SEND_RECORD ;;      Mail_List[1].Buffer_Addr := IADDRESS (Msg_Line.BODY) ;=      Msg_Buff := Msg_Text ; $      WHILE LENGTH (Msg_Buff) > 0  DO        BEGIN!        I := INDEX (Msg_Buff,Lf) ;L        IF I > 0 THEN 	  BEGIN( 	  Msg_Line := SUBSTR (Msg_Buff,1,I-1) ;9 	  Msg_Buff := SUBSTR (Msg_Buff,I+1,LENGTH(Msg_Buff)-I) ;  	  END 	ELSEI 	  BEGIN 	  Msg_Line := Msg_Buff ;R 	  Msg_Buff := '' ;  	  END ;8        Mail_List[1].Buffer_Length := LENGTH (Msg_Line) ;E        Rst := MAIL$SEND_ADD_BODYPART (Mail_Ctx,Mail_List,Null_List) ;f0        IF Notify.Vamoose AND NOT ODD (Rst)  THEN  	  LIB$SIGNAL (Jump__Mailfail) ;        END ;
      END ;  B   { The message is complete.  Let's send it.  Mail_Error_Status isI     updated by the error handler ... so we can handle errors correctly. }   "   ESTABLISH (Mail_Error_Handler) ;;   Rst := MAIL$SEND_MESSAGE (Mail_Ctx,Null_List,Null_List) ;)
   REVERT ;     IF Notify.Vamoose AND)      ((NOT ODD (Rst)) OR*       (NOT ODD (Mail_Error_Status)))  THEN"      LIB$SIGNAL (Jump__Mailfail) ;   Send_Mail_Message := Rst ;  7   Rst := MAIL$SEND_END (Mail_Ctx,Null_List,Null_List) ; +   IF Notify.Vamoose AND NOT ODD (Rst)  THENm"      LIB$SIGNAL (Jump__Mailfail) ;!   END ; 	{ of Send_Mail_Message }=     PROCEDURE Update_Uaf ;  F { Set the Last Interactive Login time, and reset the Login Failures to	   zero. }i     VAR	Fails : $UWORD := 0 ;  	Rst : UNSIGNED := 0 ; 	Now : $UQUAD := ZERO ;'- 	Item_List : Item_List_Template (3) := ZERO ;e     BEGIN 	{ Update_UAF }I   GETTIMESTAMP (Time_Now) ;m   Now := Time_Now.Binary_Time ;_  #   Item_List[1].Buffer_Length := 2 ; /   Item_List[1].Item_Code     := UAI$_LOGFAILS ; 2   Item_List[1].Buffer_Addr   := IADDRESS (Fails) ;#   Item_List[1].Return_Addr   := 0 ;   #   Item_List[2].Buffer_Length := 8 ; 2   Item_List[2].Item_Code     := UAI$_LASTLOGIN_I ;0   Item_List[2].Buffer_Addr   := IADDRESS (Now) ;#   Item_List[2].Return_Addr   := 0 ;   ?   Item_List[3].Terminator    := 0 ;	{ Terminate the item list }   I   Rst := $SETUAI (Usrnam := %STDESCR SUBSTR (New_User,1,New_User.LENGTH),: 		  Itmlst := Item_List) ;  3   IF NOT ODD (Rst) AND_THEN (Rst <> RMS$_RNF)  THEN(      LIB$SIGNAL (Rst) ;A   END ; 	{ of Update_UAF }    2 [ASYNCHRONOUS,Check(None)] PROCEDURE Read_Longword 				(VAR Location ,e' 				 Pointer : [UNSAFE] Unsigned_Ptr) ;s  % { In EXEC MODE, peek at a location. }t     BEGIN("   Location::UNSIGNED := Pointer^ ;   END ;r    3 [ASYNCHRONOUS,Check(None)] PROCEDURE Write_Longword( 				(VAR Location , ( 				 Pointer  : [UNSAFE] Unsigned_Ptr) ;  1 { In KERNEL MODE, poke a value into a location. },     BEGIN "   Pointer^ := Location::UNSIGNED ;   END ;     ) [GLOBAL] PROCEDURE Getmem (VAR Location , ) 			   Pointer  : [UNSAFE] Unsigned_Ptr) ;o  6 { Jacket routine to peek at a location in EXEC MODE. }  P   VAR Arglst : [UNSAFE] ARRAY [1..3] OF UNSIGNED := (2,0,0) ;  { Argument list }     BEGIN 	{ Getmem }S$   Arglst[2] := IADDRESS (Location) ;#   Arglst[3] := IADDRESS (Pointer) ;t.   $CMEXEC (%IMMED Read_Longword,%REF Arglst) ;   END ; 	{ of Getmem }      PROCEDURE Putmem (VAR Location ,' 		  Pointer  : [UNSAFE] Unsigned_Ptr) ;>  B { Jacket routine to poke a value into a location in KERNEL MODE. }  P   VAR Arglst : [UNSAFE] ARRAY [1..3] OF UNSIGNED := (2,0,0) ;  { Argument list }     BEGIN 	{ Putmem }L$   Arglst[2] := IADDRESS (Location) ;#   Arglst[3] := IADDRESS (Pointer) ;U/   $CMKRNL (%IMMED Write_Longword,%REF Arglst) ;r   END ; 	{ of Putmem }    . [ASYNCHRONOUS,Check(None)] PROCEDURE Getuser ;  H { In EXEC MODE, peek at the Username either in the PSB or in the Control"   Region and the JIB in the PCB. }     BEGIN 	{ Getuser }   IF Psb_Available  THEN'      Sanity_Psb_User := Psb_User_Ptr^ ;=  0   IF Arb_Full_Support OR NOT Psb_Available  THEN
      BEGIN(      Sanity_Ctl_User := CTL$T_USERNAME ;'      Sanity_Jib_User := Jib_User_Ptr^ ;+
      END ;   END ; 	{ of Getuser }m    . [ASYNCHRONOUS,Check(None)] PROCEDURE Setuser ;  H { In KERNEL MODE, poke a new Username either into the PSB or the ControlC   Region and the JIB in the PCB. If the PSB exists, do *NOT* change C   JIB$T_USERNAME as this can cause problems in other processes in aSG   multiprocess job tree. (Even though JUMP prevents itself from running 3   in a multiprocess job tree, avoid this anyway.) }m     BEGIN 	{ Setuser }   IF Psb_Available  THEN&      Psb_User_Ptr^  := New_User.BODY ;  0   IF Arb_Full_Support OR NOT Psb_Available  THEN
      BEGIN&      CTL$T_USERNAME := New_User.BODY ;&      Jib_User_Ptr^  := New_User.BODY ;
      END ;   END ; 	{ of Setuser }s    . PROCEDURE Poteroo (Faking : BOOLEAN := TRUE) ;  > { Change the UIC.  Do sanity checks except when reverting from   pseudo-terminal. }  0   VAR Sanity_Uic : [VOLATILE] UIC$TYPE := ZERO ;     BEGIN 	{ Poteroo }  J   { Check that the UIC as returned by GETJPI and as peeked at in EXEC MODE)     agree -- do this as a sanity check. }      IF Psb_Available  THEN
      BEGIN?      Psb_Uic_Ptr::UNSIGNED := CTL$GL_PCB + PCB$AR_NATURAL_PSB ; '      Getmem (Psb_Uic_Ptr,Psb_Uic_Ptr) ;(A      Psb_Uic_Ptr::UNSIGNED := Psb_Uic_Ptr::UNSIGNED + PSB$L_UIC ;L0      Getmem (Sanity_Uic.UIC$L_UIC,Psb_Uic_Ptr) ;
      END ;  0   IF Arb_Full_Support OR NOT Psb_Available  THEN
      BEGIN6      Jib_Uic_Ptr::UNSIGNED := CTL$GL_PCB + PCB$L_UIC ;0      Getmem (Sanity_Uic.UIC$L_UIC,Jib_Uic_Ptr) ;
      END ;  =   IF Faking AND (Sanity_Uic.UIC$L_UIC <> Uic.UIC$L_UIC)  THENi!      LIB$STOP (Jump__Insaneuic,2,m 	       %IMMED Uic.UIC$L_UIC,s& 	       %IMMED Sanity_Uic.UIC$L_UIC) ;     IF Psb_Available  THENM      Putmem (New_Uic.UIC$L_UIC,Psb_Uic_Ptr) ;	{ Change UIC to be target UIC }   0   IF Arb_Full_Support OR NOT Psb_Available  THENM      Putmem (New_Uic.UIC$L_UIC,Jib_Uic_Ptr) ;	{ Change UIC to be target UIC }i   END ; 	{ of Poteroo }v    . PROCEDURE Wallaby (Faking : BOOLEAN := TRUE) ;  B { Change the username.	Do sanity checks except when reverting from   pseudo-terminal },     BEGIN 	{ Wallaby }  O   { Check that the username as returned by GETJPI and as peeked at in EXEC MODE$)     agree -- do this as a sanity check. }T     IF Psb_Available  THEN
      BEGIN;      Psb_Ptr::UNSIGNED := CTL$GL_PCB + PCB$AR_NATURAL_PSB ;       Getmem (Psb_Ptr,Psb_Ptr) ;DC      Psb_User_Ptr::UNSIGNED := Psb_Ptr::UNSIGNED + PSB$T_USERNAME ; 
      END ;  0   IF Arb_Full_Support OR NOT Psb_Available  THEN
      BEGIN2      Jib_Ptr::UNSIGNED := CTL$GL_PCB + PCB$L_JIB ;      Getmem (Jib_Ptr,Jib_Ptr) ;yC      Jib_User_Ptr::UNSIGNED := Jib_Ptr::UNSIGNED + JIB$T_USERNAME ; 
      END ;     $CMEXEC (Getuser,%IMMED 0) ;     IF Faking  THEN       IF Psb_Available  THENO 	BEGIN, 	IF (Sanity_Psb_User <> Orig_User.BODY)	THEN! 	   LIB$STOP (Jump__Insaneuser,2,A6 		     %STDESCR SUBSTR (Orig_User,1,Orig_User.LENGTH)," 		     %STDESCR Sanity_Psb_User) ; 	END
       ELSE0      IF ((Sanity_Ctl_User <> Orig_User.BODY)  OR, 	 (Sanity_Jib_User <> Orig_User.BODY))  THEN! 	   LIB$STOP (Jump__Insaneuser,2,l6 		     %STDESCR SUBSTR (Orig_User,1,Orig_User.LENGTH)," 		     %STDESCR Sanity_Jib_User) ;     $CMKRNL (Setuser,%IMMED 0) ;   END ; 	{ of Wallaby }U     PROCEDURE Kangaroo ;  H { Do all that is required to JUMP /NOEXACT to the new user, or to return9   to the original user.  This is the "poor man's" jump. }E  (   VAR	Rst , Attributes : UNSIGNED := 0 ;& 	Aclstr : VARYING [64] OF CHAR := '' ;. 	Aclent : PACKED ARRAY [1..32] OF CHAR := '' ;. 	Grptbl : PACKED ARRAY [1..16] OF CHAR := '' ;- 	Item_List : Item_List_Template (3) := ZERO ;E     BEGIN 	{ Kangaroo }   #   Poteroo ;	{ *** Set new UIC *** }i      { Set new default directory. }  <   Rst := $SETDDIR (SUBSTR (Def_Dir.BODY,1,Def_Dir.LENGTH)) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;e     { Set new default disk. }   0   Item_List[1].Buffer_Length := Def_Dev.LENGTH ;-   Item_List[1].Item_Code     := LNM$_STRING ;;9   Item_List[1].Buffer_Addr   := IADDRESS (Def_Dev.BODY) ; #   Item_List[1].Return_Addr   := 0 ;   #   Item_List[2].Terminator    := 0 ;b  3   Rst := $CRELNM (Tabnam := %STDESCR 'LNM$PROCESS',_" 		  Lognam := %STDESCR 'SYS$DISK', 		  Acmode := PSL$C_SUPER, 		  Itmlst := Item_List) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;t  9   { Point LNM$GROUP logical to group table for new UIC. };      Attributes := LNM$M_TERMINAL ;:   Grptbl := 'LNM$GROUP_' + OCT (New_Uic.UIC$V_GROUP,6,6) ;  #   Item_List[1].Buffer_Length := 4 ;.1   Item_List[1].Item_Code     := LNM$_ATTRIBUTES ;$7   Item_List[1].Buffer_Addr   := IADDRESS (Attributes) ;R#   Item_List[1].Return_Addr   := 0 ;B  /   Item_List[2].Buffer_Length := SIZE (Grptbl) ;b-   Item_List[2].Item_Code     := LNM$_STRING ;b3   Item_List[2].Buffer_Addr   := IADDRESS (Grptbl) ;s#   Item_List[2].Return_Addr   := 0 ;H  #   Item_List[3].Terminator    := 0 ;S  =   Rst := $CRELNM (Tabnam := %STDESCR 'LNM$PROCESS_DIRECTORY',c# 		  Lognam := %STDESCR 'LNM$GROUP',e 		  Acmode := PSL$C_KERNEL,T 		  Itmlst := Item_List) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;   M   { If going to a different UIC, allow the current LNM$JOB logical name tableUM     to be accessed by the new UIC.  If returning to original user, remove thee$     ACL access previously applied. }      Item_List[2].Terminator := 0 ;  =   IF New_User = Orig_User  THEN 	{ Return to original user. } 
      BEGIN&      Item_List[1].Buffer_Length := 0 ;0      Item_List[1].Item_Code	:= ACL$C_DELETEACL ;$      Item_List[1].Buffer_Addr	:= 0 ;$      Item_List[1].Return_Addr	:= 0 ;      END)    ELSE 				{ Allow access to new user. }t
      BEGIN      Format_User (New_Uic) ;A      Aclstr := '(IDENTIFIER=' + Uic_Str + ',ACCESS=READ+WRITE)' ;AG      Rst := $PARSE_ACL (Aclstr := SUBSTR (Aclstr.BODY,1,Aclstr.LENGTH),o 			Aclent := %STDESCR Aclent) ;E      IF NOT ODD (Rst)  THENo 	LIB$SIGNAL (Rst) ;{  4      Item_List[1].Buffer_Length := INT (Aclent[1]) ;0      Item_List[1].Item_Code	:= ACL$C_ADDACLENT ;4      Item_List[1].Buffer_Addr	:= IADDRESS (Aclent) ;$      Item_List[1].Return_Addr	:= 0 ;
      END ;  9   Rst := $CHANGE_ACL (Objtyp := ACL$C_LOGICAL_NAME_TABLE,I 		      Objnam := 'LNM$JOB', 		      Itmlst := Item_List) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;O   END ; 	{ of Kangaroo }     PROCEDURE Display_Jump ;  4 { Display data about the requested non-exact jump. }     BEGIN 	{ Display_Jump }O   IF Transmute	THENV
      BEGIN       LIB$SIGNAL (Jump__Jumped,4,2 		 %STDESCR SUBSTR (Orig_User,1,Orig_User.LENGTH),0 		 %STDESCR SUBSTR (New_User,1,New_User.LENGTH),. 		 %STDESCR SUBSTR (Uic_Str,1,Uic_Str.LENGTH),4 		 %STDESCR SUBSTR (Eq_Id_Str,1,Eq_Id_Str.LENGTH)) ;!      LIB$SIGNAL (Jump__Default,2,s- 		 %STDESCR SUBSTR(Def_Dev,1,Def_Dev.LENGTH),c/ 		 %STDESCR SUBSTR(Def_Dir,1,Def_Dir.LENGTH)) ;A
      END ;     IF Alter_Ego	THEN !      LIB$SIGNAL (Jump__Setuser,2,m2 		 %STDESCR SUBSTR (Orig_User,1,Orig_User.LENGTH),2 		 %STDESCR SUBSTR (New_User,1,New_User.LENGTH)) ;   END ; 	{ of Display_Jump }    6 PROCEDURE Get_Channel (Device : VARYING [L1] OF CHAR ;+ 		       VAR Channel : [VOLATILE] $UWORD) ;A  ! { Assign a channel to a device. }t     VAR Rst : UNSIGNED := 0 ;      BEGIN 	{ Get_Channel }#   Rst := $ASSIGN (Devnam := Device,  		  Chan	 := Channel) ;_   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;f   END ; 	{ of Get_Channel }     / PROCEDURE Exit_Handler (Condition : UNSIGNED) ;T  L { For an EXACT JUMP only, clean up after the pseudo-terminal session ends or   on abnormal termination. }     VAR Rst  : UNSIGNED := 0 ;(       Iosb : Status_Block_Type := ZERO ;     BEGIN 	{ Exit_Handler }d  #   $SETAST (0) ; 			{ Disable ASTs }   M   { If recording session for an EXACT jump, be sure the log file is closed. }N     IF Record_Session  THENE&      CLOSE (Logfile,Error:=CONTINUE) ;  +   { Restore username and UIC if required. }t     IF New_User <> Orig_User THENE
      BEGINM      New_User.BODY := PAD ('',' ',12) ; { Completely blat any previous name }S      New_User := Orig_User ;@      Wallaby (FALSE) ;			{ *** Change to original username *** }
      END ;  ,   IF New_Uic.UIC$L_UIC <> Uic.UIC$L_UIC THEN
      BEGIN      New_Uic := Uic ; ;      Poteroo (FALSE) ;			{ *** Change to original UIC *** }e
      END ;     IF Pchan_Created  THEN      IF Pseudo_Ft  THENR 	BEGIN> 	Rst := PTD$CANCEL (Pchan) ;	{ Cancel I/O to pseudo-terminal } 	IF NOT ODD (Rst)  THENB 	   LIB$SIGNAL (Rst) ;  7 	Rst := PTD$DELETE (Pchan) ;	{ Delete pseudo-terminal }' 	IF NOT ODD (Rst)  THEN= 	   LIB$SIGNAL (Rst) ; 	END
       ELSE8 	$DASSGN (Pchan) ;		{ Deassign pseudo-terminal channel }  6   $CANCEL (Rchan) ;			{ Cancel I/Os on real terminal }  D   Rst := $QIOW (Chan := Rchan,		{ Restore original characteristics } 		Func := IO$_SETMODE, 		Iosb := Iosb,S 		P1   := Rchars,: 		P2   := 12) ;a   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)E    ELSEe   IF NOT ODD (Iosb[1])	THENt      LIB$SIGNAL (Iosb[1]) ;t  '   $DASSGN (Rchan) ;			{ Shut up shop. }e  .   { Clean up process attributes (if any) ... }  )   Rst := $DELLNM (Tabnam := 'LNM$SYSTEM',l- 		  Lognam := 'JUMP_' + HEX (Pseudo_Pid,8,8),T 		  Acmode := PSL$C_EXEC) ;r2   IF NOT (ODD (Rst) OR (Rst = SS$_NOLOGNAM))  THEN      LIB$SIGNAL (Rst) ;      END ; 	{ of Exit_Handler }    $ [ASYNCHRONOUS] PROCEDURE Rchan_Ast ;  J { Called when a keystroke occurs on the real keyboard - the keystrokes areL   passed to the pseudo-terminal and another read queued.  If escaping, avoid3   all read/write activity and simply wake up Mum. }e     VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ Rchan_Ast}LA   IF Escape_Hatch AND_THEN (Buffer.One[Wsts*2+3] = Ripcord)  THENR
      BEGIN2      LIB$SIGNAL (Jump__Userabort) ;		{ Bail out! }0      Jeronimo := TRUE ; 			{ Pull the ripcord! }      Rst := $WAKE ;f      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;       END    ELSEs   IF Pseudo_Ft	THENs
      BEGIN'      Rst := PTD$WRITE (Chan	  := Pchan,n& 		       Wrtbuf	  := Buffer.Raw[Wsts], 		       Wrtbuf_Len := 1) ;       IF NOT ODD (Rst)  THENO 	LIB$SIGNAL (Rst) ;_  !      Rst := $QIO (Chan	 := Rchan,r 		  Func	 := IO$_READVBLK, 		  Astadr := Rchan_Ast, 		  P1	 := Buffer.Raw[Wbuf], 		  P2	 := 1) ;_      IF NOT ODD (Rst)  THENN 	LIB$SIGNAL (Rst) ;i      END    ELSE 
      BEGIN       Rst := $QIO (Chan := Pchan, 		  Func := IO$_WRITEVBLK, 		  P1   := Buffer.Raw[Wsts],E 		  P2   := 1) ;      IF NOT ODD (Rst)  THENi 	LIB$SIGNAL (Rst) ;o  !      Rst := $QIO (Chan	 := Rchan,a 		  Func	 := IO$_READVBLK, 		  Astadr := Rchan_Ast, 		  P1	 := Buffer.Raw[Wsts], 		  P2	 := 1) ;t      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ; 
      END ;   END ; 	{ of Rchan_Ast }     $ [ASYNCHRONOUS] PROCEDURE Pchan_Ast ;  M { Called when characters are received from the pseudo-terminal - the data arei6   passed to the real screen and another read queued. }     VAR  Rst : UNSIGNED := 0 ;=        Log_Buffer : VARYING [SIZE(Io_Buffer)] OF CHAR := '' ;      BEGIN 	{ Pchan_Ast }  7   { If recording, write the new text to the log file. }      IF Record_Session  THENf
      BEGIN"      IF Buffer.Raw[Rcnt] > 0  THENF 	STR$COPY_R (%DESCR Log_Buffer,Buffer.Raw[Rcnt],%REF Buffer.Raw[Rbuf])
       ELSE 	Log_Buffer := '' ; E      WRITELN (Logfile,Log_Buffer,Error:=CONTINUE) ;	{ Ignore errors } 
      END ;     IF Pseudo_Ft	THENA
      BEGIN!      Rst := $QIOW (Chan := Rchan,_ 		   Func := IO$_WRITEVBLK,l 		   P1	:= Buffer.Raw[Rbuf], 		   P2	:= Buffer.Raw[Rcnt]) ;      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;s  &      Rst := PTD$READ (Chan	  := Pchan, 		      Astadr	  := Pchan_Ast,& 		      Readbuf	  := Buffer.Raw[Rsts],# 		      Readbuf_Len := Ft_Buflen) ;       IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;t      END    ELSEr
      BEGIN!      Rst := $QIOW (Chan := Rchan,  		   Func := IO$_WRITEVBLK,, 		   P1	:= Buffer.Raw[Rsts], 		   P2	:= Piosb[2]) ;      IF NOT ODD (Rst)  THENB 	LIB$SIGNAL (Rst) ;c  !      Rst := $QIO (Chan	 := Pchan,F 		  Func	 := IO$_READVBLK, 		  Iosb	 := Piosb,' 		  Astadr := Pchan_Ast, 		  P1	 := Buffer.Raw[Rsts], 		  P2	 := Py_Buflen) ;h      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;o
      END ;   END ; 	{ of Pchan_Ast }       [ASYNCHRONOUS] PROCEDURE Mbast ;  F { Invoked by the detached process termination mailbox AST - WAKE UP! }     VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ MBast }  F   { Try to avoid any issues with typeahead buffer and EXACT log file }     IF Record_Session  THENo
      BEGIN       Rst := PTD$CANCEL (Pchan) ;      IF NOT ODD (Rst)  THENE 	LIB$SIGNAL (Rst) ; 
      END ;     Rst := $WAKE ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;A   END ; 	{ of MBast }L    ( [ASYNCHRONOUS] PROCEDURE Send_Bell_Ast ;    { Bell event notification AST. }     VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ Send_BELL_AST }   Rst := $QIO (Chan := Rchan,U 	       Func := IO$_WRITEVBLK, 	       P1   := Bell,t 	       P2   := 1) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;B   END ; 	{ of Send_BELL_AST }E    ' [ASYNCHRONOUS] PROCEDURE Send_Xon_Ast ;o   { Xon event notification AST. }      VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ Send_XON_AST }    Rst := $QIO (Chan := Rchan,  	       Func := IO$_WRITEVBLK, 	       P1   := Xon, 	       P2   := 1) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;B   END ; 	{ of Send_XON_AST }    ( [ASYNCHRONOUS] PROCEDURE Send_Xoff_Ast ;    { Xoff event notification AST. }     VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ Send_XOFF_AST }   Rst := $QIO (Chan := Rchan,  	       Func := IO$_WRITEVBLK, 	       P1   := Xoff,  	       P2   := 1) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;d   END ; 	{ of Send_XOFF_AST }g     PROCEDURE Transmography ;e  L { Create a pseudo-terminal connected to a detached process and actually *be*#   the user!  This is JUMP /EXACT. }      CONSTs  N   Subversion_Msg = '**** JUMP WARNING!! Attempt to subvert Secure Mode ****' ;     TYPE  8   Desc_Blk = PACKED RECORD			{ Exit handler descriptor } 	       Fwd_Link : UNSIGNED ;e& 	       Exit_Handler_Addr : UNSIGNED ; 	       Argcnt : $UBYTE ;.5 	       Fill_Zero : [UNSAFE] ARRAY [1..3] OF $UBYTE ;	 	       Condition ,i0 	       P2 , P3 , P4 , P5 , P6 , P7 : UNSIGNED ; 	     END VALUE ZERO ;     VARD  $   Modify_Sysprv : BOOLEAN := FALSE ;+   Rst , Mbunit , Stsflags : UNSIGNED := 0 ; .   Pctl : [VOLATILE,LONG] Prtctl_Type := ZERO ;)   Pctl_Ptr : [VOLATILE] Word_Ptr := NIL ;t   Rucb , Pucb ,O#   Rapn, Papn: Unsigned_Ptr := NIL ;p%   Newchars : Terminal_Chars := ZERO ; )   Exit_Desc : [STATIC] Desc_Blk := ZERO ;	$   Iosb : Status_Block_Type := ZERO ;.   Item_List : Item_List_Template (2) := ZERO ;/   Specified_User : VARYING [12] OF CHAR := '' ;E.   Time_Str     : VARYING  [23] OF CHAR := '' ;.   Notify_Msg   : VARYING  [80] OF CHAR := '' ;.   Logfile_Spec : VARYING [254] OF CHAR := '' ;  7   FUNCTION Find_Device (Device : VARYING [L1] OF CHAR ;e$ 			Chan   : $UWORD := 0) : BOOLEAN ;  7   { Determine if a device exists and return its name. }J       VAR Rst : UNSIGNED := 0 ; # 	Iosb : Status_Block_Type := ZERO ;A- 	Item_List : Item_List_Template (2) := ZERO ;f       BEGIN	{ Find_Device }B     Find_Device := TRUE ;   4     Item_List[1].Buffer_Length := SIZE (Pdev.BODY) ;/     Item_List[1].Item_Code     := DVI$_DEVNAM ;d8     Item_List[1].Buffer_Addr   := IADDRESS (Pdev.BODY) ;:     Item_List[1].Return_Addr   := IADDRESS (Pdev.LENGTH) ;  B     Item_List[2].Terminator    := 0 ;		{ Terminate the item list }  C     IF (Chan = 0) AND (Device <> '')  THEN	{ Device name supplied }i,        Rst := $GETDVIW (Itmlst := Item_List, 			Devnam := Device, 			Iosb   := Iosb))      ELSE					{ Channel number supplied }y,        Rst := $GETDVIW (Itmlst := Item_List, 			Chan   := Chan, 			Iosb   := Iosb) ;        IF Rst = SS$_NOSUCHDEV  THEN        Find_Device := FALSEI	      ELSEd     IF NOT ODD (Rst)  THEN        LIB$SIGNAL (Rst) 	      ELSE	     IF NOT ODD (Iosb[1])  THEN        LIB$SIGNAL (Iosb[1]) ;T     END ;	{ of Find_Device }  -   FUNCTION Logfile_Open (VAR Fab : FAB$TYPE ;) 			 VAR Rab : RAB$TYPE ;  			 VAR Log : TEXT) : UNSIGNED ;  K   { This function is invoked by Pascal's OPEN when the log file is created.nM     We hijack the NAM block to determine the actual filespec of the log file.mM     Also, if the log file is secure, use executive mode logical names only. }}       VAR Rst : UNSIGNED := 0 ;N 	Nam : ^NAM$TYPE := ZERO ;       BEGIN	{ Logfile_Open }+     IF Secure_Mode OR Secure_User_Dir  THEN(B        Fab.FAB$V_LNM_MODE := PSL$C_EXEC ;	{ Executive mode only! }  #     Nam := Fab.FAB$L_NAM::Pointer ;u       Rst := $CREATE (Fab) ;     IF ODD (Rst)  THEN        BEGINN        STR$COPY_R (%DESCR Logfile_Spec,Nam^.NAM$B_RSL,%IMMED Nam^.NAM$L_RSA) ;        Rst := $CONNECT (Rab)        END ;     Logfile_Open := Rst ;      END ;	{ of Logfile_Open }   *   PROCEDURE Get_Ucb (Chan_Num : UNSIGNED ;! 		     VAR Ucb  : Unsigned_Ptr) ;r  F   { Use the logical UCB address in the CCB to get to the physical UCB.7     VAX and Alpha handle things slightly differently. }_       VAR Inx : UNSIGNED := 0 ;i& 	Ccb_Chan : [VOLATILE] UNSIGNED := 0 ;% 	Ccb_Chan_Ptr : Unsigned_Ptr := NIL ;u       BEGIN	{ Get_Ucb }T     CASE Architecture OF       Vax:   BEGIN- 	     Inx := Chan_Num DIV 16 * CCB$K_LENGTH ;;' 	     Ucb::UNSIGNED := CTL$GL_CCBBASE -D- 				Inx - CCB$L_UCB ;	{ Logical UCB address }) 	     END ;N       Alpha: BEGIN 	     REPEATG 	       Ccb_Chan_Ptr::UNSIGNED := CTL$GA_CCB_TABLE + Inx + CCB$L_CHAN ;e( 	       Getmem (Ccb_Chan,Ccb_Chan_Ptr) ;# 	       Inx := Inx + CCB$K_LENGTH ;r! 	     UNTIL Ccb_Chan = Chan_Num ;I  > 	     Ucb::UNSIGNED := CTL$GA_CCB_TABLE + Inx - CCB$K_LENGTH +- 			      CCB$L_UCB ;		{ Logical UCB address }I 	     END ;        END ;	{ of Case }[  )     Getmem (Ucb,Ucb) ;				{ Logical UCB }B$     Ucb::UNSIGNED := Ucb::UNSIGNED +2 		     UCB$L_TL_PHYUCB ;		{ Physical UCB address }*     Getmem (Ucb,Ucb) ;				{ Physical UCB }     END ;	{ of Get_Ucb }     BEGIN 	{ Transmography }7   IF Suspect  THEN			{ Secure Mode subversion attempt } 
      BEGIN.      Oprmsg (Subversion_Msg,Oper_Class_Mask) ;?      Send_Mail_Message (Notify_Maillist,Subversion_Msg,'NL:') ;y
      END ;     Specified_User := New_User ;  I   { Determine which pseudo-terminal type (if any) exists on the system. }d  &   Pseudo_Ft := Find_Device ('FTA0:') ;   IF NOT Pseudo_Ft  THEN'      IF NOT Find_Device ('PYA0:')  THENt 	$EXIT (Jump__Nopseudo) ;,  I   { Get current (real) terminal process-specific device characteristics }A     Get_Channel ('TT:',Rchan) ;E     Rst := $QIOW (Chan := Rchan, 		Func := IO$_SENSEMODE, 		Iosb := Iosb,; 		P1   := Rchars,$ 		P2   := 12) ;      IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)     ELSEo   IF NOT ODD (Iosb[1])	THEN       LIB$SIGNAL (Iosb[1]) ;_  N   { Audit close to, but before the guts of it, so that even if the jump fails,     the attempt is audited. }e     IF Auditing  THEN,      Audit_Jump (TRUE) ;  I   { If recording, construct the session log filename and make sure we can,     open the file early on. }H     IF Record_Session THEN
      BEGIN      GETTIMESTAMP (Time_Now) ;:      Time_Str := DATE (Time_Now) + ' ' + TIME (Time_Now) ;       IF Time_Str[1]  = ' '  THEN 	Time_Str[1] := '0' ;L        IF NOT Secure_Mode  THENR% 	Secure_Directory := User_Directory ; *      WRITEV (Session_Log,Secure_Directory, 			 'JUMP_', 			 Orig_User, 			 '-',
 			 New_User,  			 '.', 			 DEC (Time_Now.Year,4,4), 			 DEC (Time_Now.Month,2,2),; 			 DEC (Time_Now.Day,2,2),n 			 '_', 			 DEC (Time_Now.Hour,2,2), 			 DEC (Time_Now.Minute,2,2),! 			 DEC (Time_Now.Second,2,2) ) ;M  I      { If the user has specified JUMP_USER_DIR and the System Manager hasRL        not, turn off SYSPRV for the file open if SYSPRV is not in the user's         process privilege mask. }  K      Modify_Sysprv := NOT (Secure_User_Dir OR (Sysprv IN Proc_Perm_Priv)) ;r        IF Modify_Sysprv  THENI1 	$SETPRV (Enbflg := %IMMED 0,		{ Disable SYSPRV }> 		 Prvadr := PRV$M_SYSPRV) ;  7      OPEN (Logfile,FILE_NAME:=Session_Log,HISTORY:=NEW,d; 		   Record_Length:=SIZE(Io_Buffer),Carriage_Control:=None,I1 		   USER_ACTION:=Logfile_Open,Error:=CONTINUE) ;r      Rst := STATUS (Logfile) ;"      IF Rst <> PAS$K_SUCCESS  THEN 	BEGIN 	LIB$SIGNAL (Jump__Badlogfil) ;l" 	LIB$STOP (Condition_Code (Rst)) ; 	END ;        REWRITE (Logfile) ;  &      { If necessary, restore SYSPRV. }        IF Modify_Sysprv  THENO0 	$SETPRV (Enbflg := %IMMED 1,		{ Enable SYSPRV } 		 Prvadr := PRV$M_SYSPRV) ;
      END ;  )   { Set up and declare the exit handler }T  :   Exit_Desc.Exit_Handler_Addr := IADDRESS (Exit_Handler) ;   Exit_Desc.Argcnt := 1 ;E.   Exit_Desc.Condition := IADDRESS (Exit_Rst) ;  (   Rst := $DCLEXH (Desblk := Exit_Desc) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;p  *   { If required, issue the notification. }     IF Notify.Before  THEN
      BEGIN:      Notify_Msg := 'Initiated JUMP/EXACT to ' + New_User ;      IF Notify.By_Opcom  THENS& 	Oprmsg (Notify_Msg,Oper_Class_Mask) ;      IF Notify.By_Mail	THEN 7 	Send_Mail_Message (Notify_Maillist,Notify_Msg,'NL:') ;U
      END ;  &   { Set new terminal characteristics }     Newchars := Rchars ;.   Newchars.Tt_Devchar.TT$V_NOECHO    := TRUE ;/   Newchars.Tt_Devchar.TT$V_WRAP      := FALSE ;F.   Newchars.Tt_Devchar2.TT2$V_PASTHRU := TRUE ;     Rst := $QIOW (Chan := Rchan, 		Func := IO$_SETMODE, 		Iosb := Iosb,p 		P1   := Newchars,u 		P2   := 12) ;      IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)r    ELSEo   IF NOT ODD (Iosb[1])	THEN)      LIB$SIGNAL (Iosb[1]) ;:  .   Wallaby ;	{ *** Change to new username *** })   Poteroo ;	{ *** Change to new UIC *** }v      { Create the pseudo-terminal }  &   Pbuf_Range[1] := IADDRESS (Buffer) ;6   Pbuf_Range[2] := Pbuf_Range[1] + Io_Buflen * 2 - 1 ;     IF Pseudo_Ft	THENu
      BEGIN'      Rst := PTD$CREATE (Chan	 := Pchan,  			Charbuff := Rchars, 			Buflen	 := SIZE (Rchars), 			Inadr	 := Pbuf_Range) ;      IF NOT ODD (Rst)  THENL 	LIB$SIGNAL (Rst) ;r         { Set event notifications }  8      Rst := PTD$SET_EVENT_NOTIFICATION (Chan   := Pchan, 					Astadr := Send_Bell_Ast,i! 					Type_  := PTD$C_SEND_BELL) ;e      IF NOT ODD (Rst)  THENG 	LIB$SIGNAL (Rst) ;   8      Rst := PTD$SET_EVENT_NOTIFICATION (Chan   := Pchan, 					Astadr := Send_Xon_Ast,  					Type_  := PTD$C_SEND_XON) ;      IF NOT ODD (Rst)  THENg 	LIB$SIGNAL (Rst) ;)  8      Rst := PTD$SET_EVENT_NOTIFICATION (Chan   := Pchan, 					Astadr := Send_Xoff_Ast, ! 					Type_  := PTD$C_SEND_XOFF) ;       IF NOT ODD (Rst)  THENv 	LIB$SIGNAL (Rst) ;       END    ELSE(
      BEGIN"      Get_Channel ('PYA0:',Pchan) ;
      END ;  8   Find_Device ('',Pchan) ;		{ Sets Pdev to device name }   Pchan_Created := TRUE ;H  K   { If the "real" process has a valid value for ACCPORNAM, set the "pseudo"I     process to point to it. }      Get_Ucb (Pchan,Pucb) ;:   Pctl_Ptr::UNSIGNED := Pucb::UNSIGNED + UCB$W_TT_PRTCTL ;   Getmem (Pctl,Pctl_Ptr) ;9   Papn::UNSIGNED := Pucb::UNSIGNED + UCB$L_TT_ACCPORNAM ;;     IF Port = ''	THENE
      BEGIN  M      { Welcome to a futureware section of code!  When ACCPORNAM is not valid,EI        the port name will be empty.  In this case, use the terminal name.	F        Allocate an appropriate buffer, copy the terminal name into it,J        put the address of the buffer into ACCPORNAM of the pseudo-terminalK        and set the validity bit in the port control mask.  When the pseudo-JO        terminal is terminated, deallocate the buffer.  This exercise remains torP        be attempted ... or supplied by an eager code jockey somewhere else! :) }        END    ELSER
      BEGIN      Get_Ucb (Rchan,Rucb) ;V<      Rapn::UNSIGNED := Rucb::UNSIGNED + UCB$L_TT_ACCPORNAM ;      Getmem (Rapn,Rapn) ;a      Putmem (Rapn,Papn) ;d3      Pctl::Prtctl_Type.TTY$V_PC_ACCPORNAM := TRUE ;e      Putmem (Pctl,Pctl_Ptr) ; 
      END ;  E   { Create a termination mailbox for the soon-to-be detached process,l     and get its unit number }E  !   Rst := $CREMBX (Chan	 := Mchan,n 		  Maxmsg := ACC$K_TERMLEN) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;   #   Item_List[1].Buffer_Length := 4 ;e+   Item_List[1].Item_Code     := DVI$_UNIT ;O3   Item_List[1].Buffer_Addr   := IADDRESS (Mbunit) ;T#   Item_List[1].Return_Addr   := 0 ;   ?   Item_List[2].Terminator    := 0 ;	{ Terminate the item list }a  '   Rst := $GETDVIW (Itmlst := Item_List,_ 		   Chan   := Mchan,  		   Iosb   := Iosb) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)     ELSEN   IF NOT ODD (Iosb[1])	THEN       LIB$SIGNAL (Iosb[1]) ;x  /   { Queue an asynchronous read to the mailbox }t     Rst := $QIO (Chan   := Mchan,A 	       Func   := IO$_READVBLK,  	       Astadr := Mbast, 	       P1     := Mbbuf," 	       P2     := ACC$K_TERMLEN) ;     IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;      IF Log  THEN
      BEGIN"      LIB$SIGNAL (Jump__Transfer,1,2 		 %STDESCR SUBSTR (New_User,1,New_User.LENGTH)) ;      WRITELN ;
      END ;  !   { Create the detached process }   =   Stsflags := PRC$M_DETACH + PRC$M_INTER + PRC$M_NOPASSWORD ;R   IF Figment  THEN<      Stsflags := Stsflags + PRC$M_LOGIN ;	{ == PRC$M_NOUAF }  ,   Rst := $CREPRC (Pidadr := %REF Pseudo_Pid,( 		  Image  := 'SYS$SYSTEM:LOGINOUT.EXE', 		  INPUT  := Pdev,P 		  OUTPUT := Pdev,E 		  Error  := Pdev,R 		  Baspri := 4, 		  Mbxunt := Mbunit,I% 		  Prcnam := 'JUMP_' + HEX(Pid,8,8),_  		  Stsflg := %IMMED Stsflags) ;     IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;d  >   IF Stamp_Uaf	THEN  Update_Uaf ;	{ Update UAF login details }  .   IF NOT Chain	THEN			{ Chaining not allowed }:      Target_Attributes := Target_Attributes + 'NOCHAIN ' ;  !   IF Target_Attributes = ''  THEN(       Target_Attributes := 'NONE'    ELSEEJ      Define_Logical_Name ('JUMP_'+HEX(Pseudo_Pid,8,8),Target_Attributes) ;     { Restore username and UIC }  J   New_User.BODY := PAD ('',' ',12) ;	{ Completely blat any previous name }   New_User := Orig_User ;R   New_Uic  := Uic ;s  ;   Wallaby (FALSE) ;	{ *** Change to original username *** } 6   Poteroo (FALSE) ;	{ *** Change to original UIC *** }  I   { Put some audit information at the start of the session log file. NoteaF     that we have to put the carriage control in explicitly because the?     log file is created without any implied carriage control. }N     IF Record_Session THEN
      BEGIN"      Session_Log := Logfile_Spec ;,      WRITELN (Logfile,PAD ('-','-',78),Cr) ;F      WRITELN (Logfile,Lf,Version,' Pseudo-terminal session log.',Cr) ;*      WRITELN (Logfile,Lf,Session_Log,Cr) ;8      WRITELN (Logfile,Lf,'User:        ',Orig_User,Cr) ;?      WRITELN (Logfile,Lf,'Login time:  ', Login_Time_Str, Cr) ; C      WRITELN (Logfile,Lf,'From PID:    ',HEX (Master_Pid,8,8),Cr) ;d;      WRITELN (Logfile,Lf,'Process:     ',Process_Name,Cr) ;;C      WRITELN (Logfile,Lf,'To PID:      ',HEX (Pseudo_Pid,8,8),Cr) ;L#      IF Physical_Device <> ''  THENS: 	WRITELN (Logfile,Lf,'Phys Dev:    ',Physical_Device,Cr) ;      IF Terminal <> ''	THENs3 	WRITELN (Logfile,Lf,'Terminal:    ',Terminal,Cr) ;       IF Port <> ''  THEN/ 	WRITELN (Logfile,Lf,'Port:        ',Port,Cr) ;t7      WRITELN (Logfile,Lf,'JUMP time:   ',Time_Str,Cr) ;M=      WRITELN (Logfile,Lf,'Target user: ',Specified_User,Cr) ;       IF Secure_Mode  THEN_. 	WRITELN (Logfile,Lf,'Mode:        Secure',Cr)
       ELSE0 	WRITELN (Logfile,Lf,'Mode:        Record',Cr) ;@      WRITELN (Logfile,Lf,'Attributes:  ',Target_Attributes,Cr) ;6      WRITELN (Logfile,Lf,'Command:     ',Command,Cr) ;      IF Suspect  THENa) 	WRITELN (Logfile,Lf,Subversion_Msg,Cr) ;E+      WRITELN (Logfile,PAD (Lf,'-',78),Cr) ;S      WRITELN (Logfile,Lf,Cr) ;
      END ;  O   { Queue the appropriate reads to both the real terminal and pseudo-terminal }E     IF Pseudo_Ft	THENl
      BEGIN!      Rst := $QIO (Chan	 := Rchan,t 		  Func	 := IO$_READVBLK, 		  Astadr := Rchan_Ast, 		  P1	 := Buffer.Raw[Wbuf], 		  P2	 := 1) ;       IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;e  &      Rst := PTD$READ (Chan	  := Pchan, 		      Astadr	  := Pchan_Ast,& 		      Readbuf	  := Buffer.Raw[Rsts],# 		      Readbuf_Len := Ft_Buflen) ;i      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;t      END    ELSE=
      BEGIN!      Rst := $QIO (Chan	 := Rchan,d 		  Func	 := IO$_READVBLK, 		  Astadr := Rchan_Ast, 		  P1	 := Buffer.Raw[Wsts], 		  P2	 := 1) ;.      IF NOT ODD (Rst)  THENi 	LIB$SIGNAL (Rst) ;:  !      Rst := $QIO (Chan	 := Pchan,O 		  Func	 := IO$_READVBLK, 		  Iosb	 := Piosb,  		  Astadr := Pchan_Ast, 		  P1	 := Buffer.Raw[Rsts], 		  P2	 := Py_Buflen) ;       IF NOT ODD (Rst)  THENL 	LIB$SIGNAL (Rst) ; 
      END ;  >   { Hibernate until termination mailbox message wakes us up. }  
   $HIBER ;     { All Done! We're back! ...S  M     If recording session for an EXACT jump, close the log file. If the escape>L     character terminated the session, add an appropriate termination message+     to the session log before closing it. },     IF Record_Session  THEN 
      BEGIN      IF Jeronimo  THEN% 	WRITELN (Logfile,Lf,'************ ', 4 			    'Process terminated by user escape request ',+ 			    '************',Cr,Error:=CONTINUE) ;n&      CLOSE (Logfile,Error:=CONTINUE) ;
      END ;  %   { If required, notify the troops. }y     IF Notify.After  THEN 
      BEGIN@      Notify_Msg := 'Completed JUMP/EXACT to ' + Specified_User ;      IF Notify.By_Mail	THENd 	BEGIN 	IF Notify.Include_Log  THEN> 	   Send_Mail_Message (Notify_Maillist,Notify_Msg,Session_Log) 	 ELSE 	IF Record_Session  THEN2 	   Send_Mail_Message (Notify_Maillist,Notify_Msg,- 			      'The session log is ' + Session_Log)s 	 ELSE2 	   Send_Mail_Message (Notify_Maillist,Notify_Msg,' 			      'There was no session log.') ;M 	END ;      IF Notify.By_Opcom  THEN; 	BEGIN& 	Oprmsg (Notify_Msg,Oper_Class_Mask) ; 	IF Record_Session  THEN< 	   Oprmsg ('Session log: ' + Session_Log,Oper_Class_Mask) ; 	END ;
      END ;     WRITELN ;s   IF Log  THEN
      BEGIN       LIB$SIGNAL (Jump__Return,1,4 		 %STDESCR SUBSTR (Orig_User,1,Orig_User.LENGTH)) ;      WRITELN ;
      END ;  +   { The Exit_Handler will do the cleanup. }      END ; 	{ of Transmography }t    E { * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *NC   * * * * * * * * * *	M A I N   P R O G R A M   * * * * * * * * * *gG   * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }[     BEGIN	{ Jump }   Get_System_Info ;  Get_Caller_Info ;_   Get_And_Parse_Command ;s' Validate_Access ;			{ Stop intruders! }]   IF Real_Mccoy  THENL    Transmography			{ Clone! }f  ELSEr    BEGIN    IF Auditing	THENL       Audit_Jump (TRUE)      ELSE       Format_User (New_Uic) ;	  3    IF Alter_Ego  THEN			{ *** Change username *** }m       Wallaby ;T  -    IF Transmute  THEN			{ Long jump! Boing! }t9       Kangaroo ;			{ *** Change miscellany of items *** }       IF Log  THEN  Display_Jump ;     END ;   END.	{ of it all }