; $! Copyright 2006 Hewlett-Packard Development Company, L.P.  $! CDROM_CALCULATOR.COM : $! Calculates basic disk facts from a disk maxblock value. $!, $! Originally written by:  Atlant G. Schmidt $!E $!  The numbers of cylinders, heads, and sectors (CHS) is completely  G $!  synthetic on CD-R or CD-ROM media, as the media is simply one long  F $!  track spiraling outward from the center of the disk.  All data on F $!  the drive is thus available as sectors on that one (long) track.   $!F $!  As operating systems that are interested in the geometry of a diskD $!  device can understandably be confused by a disk device with one C $!  cylinder, one track, and up to 1,380,000 sectors, the operating E $!  system device drivers can synthesize the geometry, and report the H $!  presence of multiple tracks and cylinders.  Accordingly, the number G $!  of sectors present on the media must be a multiple of the expected   $!  CHS value. $!E $!  OpenVMS does not have (fatal) problems with CD-R or CD-ROM media  E $!  that contains a difference between the number of sectors and the  G $!  calculated CHS value, though tools such as ANALYZE/DISK can (will)  H $!  return non-fatal errors associated with the unexpectedly small size G $!  of the ODS-2 disk storage bitmap if the CD-R or CD-ROM application  ? $!  that recorded the media has extended the number of sectors.  $!D $!  Further, all CD-R media should be recorded in multiples of four @ $!  blocks, as the physical size of a CD-R sector is 2048 bytes. $!G $!  OpenVMS will evaluate the SCSI mode page (format device page) that  E $!  contains the device geometry, if available.  This SCSI mode page  E $!  contains the numbers of cylinders, the numbers of heads, and the  E $!  sectors per track.  If present and valid, OpenVMS will use these   $!  values.  $!? $!  If the geometry values are absent, OpenVMS will then clear  C $!  UCB$M_TRK_CYL_VIA_MS and UCB$M_SECTORS_VIA_MS in the UCB field  B $!  UCB$L_DK_FLAGS2, and synthesize values.  With a CD-ROM device,E $!  OpenVMS will also synthesize the values if the geometry returned  ! $!  from the mode pages is bogus.  $!E $!  If UCB$B_TRACKS times UCB$B_SECTORS times UCB$W_CYLINDERS matches " $!  UCB$L_MAXBLOCK, all is well.   $!G $!  If either UCB$B_TRACKS or UCB$B_SECTORS contains a zero, load both  B $!  with the (initial) values of 6 and 4, respectively, and try toC $!  calculate the number of cylinders based on the number of blocks 
 $!  reported.  $!E $!  If the number of cylinders cannot be represented in a word-length G $!  field or if UCB$B_TRACKS times UCB$B_SECTORS times UCB$W_CYLINDERS  F $!  does not match UCB$L_MAXBLOCK, synthesize a geometry, and use the E $!  smallest of the following four geometries that can represent the   $!  number of blocks present:  $!C $!    6 tracks, 4 sectors, and a calculated number of cylinders, or 9 $!    32 tracks, 32 sectors, and calculated cylinders, or 9 $!    96 tracks, 96 sectors, and calculated cylinders, or 8 $!    255 tracks, 255 sectors, and calculated cylinders. $!G $!  These synthesized geometries can potentially waste up to 23, 1023,  ( $!  9215, or 65024 blocks, respectively. $!I $!  The attached formatting tool can be useful, as can the (undocumented) F $!  sys$etc:scsi_info tool that is included on OpenVMS V6.2 and later. $! $! $! $! CDROM_CALCULATOR.COM 6 $! -- Calculate some basic facts from a disk blocksize $!! $! Written by:  Atlant G. Schmidt  $! Written:     21-SEP-1998  $! Last Edit:   09-NOV-1998 7 $!              24-MAR-1999 -- Correct MM:SS truncation K $!                             Add an F$Integer() to SIZE from DCL, fixing  K $!                             hex display.  Fixup "Usage" parsing for the  3 $!                             MB/Megabytes command 3 $!              09-APR-1999 -- Add "Used" printouts 6 $!              04-NOV-1999 -- Add volume name displayE $!                             Suppressed Used/Free printouts if not  F $!                             mounted/mounted foreign.  Allow bigger G $!                             percentages of "CDROM" size, and always  & $!                             display/ $!              15-NOV-1999 -- Added KB display M $!              16-NOV-1999 -- Added the capability of processing a filename  ' $!                             as input L $!              01-DEC-1999 -- Corrected a typo preventing freespace displayI $!              02-MAR-2000 -- Modified the Free/Used display for easier  & $!                             reading $  $  $  SPACES  = "                " R $  DEVICE  = ""        ! Set to real device name/filename if real device/real file? $  MOUNTED = "???"     ! All set by F$GetDvI() if a real device  $  FOREIGN = "???"     !   : $  LOGNAME = "???"     !   :3 $  SWL     = "???"     !   :  (Software Write Lock)  $  TYPE    = "???"     !   :? $  MB_FLAG = "FALSE"   ! Flag if they just want megabyte report ? $  KB_FLAG = "FALSE"   ! Flag if they just want kilobyte report  $  $  $  $ PARSE_P1: B $  IF ( (P1 .EQS. "") .OR. (P1 .EQS. "HELP") .OR. (P1 .EQS. "?") )	 $    THEN   $      WRITE SYS$OUTPUT "Usage:" $      WRITE SYS$OUTPUT ""R $      WRITE SYS$OUTPUT "$ CDROM[_CALCULATOR]  <device_name> -- Report everything"R $      WRITE SYS$OUTPUT "$ CDROM[_CALCULATOR]  <file_name> ---- Report everything"R $      WRITE SYS$OUTPUT "$ CDROM[_CALCULATOR]  <blocks> ------- Report everything"` $      WRITE SYS$OUTPUT "$ MEGABYTES  <blocks|dev|file> ------- Just report marketing megabytes"` $      WRITE SYS$OUTPUT "$ MB  <blocks|dev|file> -------------- Just report marketing megabytes"V $      WRITE SYS$OUTPUT "$ KILOBYTES  <blocks|dev|file> ------- Just report kilobytes"V $      WRITE SYS$OUTPUT "$ KB  <blocks|dev|file> -------------- Just report kilobytes" $      WRITE SYS$OUTPUT ""   $      WRITE SYS$OUTPUT ""Y $      WRITE SYS$OUTPUT "    o Blocks may be specified as nnn (decimal), %xnnn, or 0xnnn" R $      WRITE SYS$OUTPUT "    o ""Marketing Megabytes"" are 10^6 (1,000,000) bytes"B $      WRITE SYS$OUTPUT "    o ""Kilobytes are 2^10 (1,024) bytes" $      EXIT 01
 $    ENDIF $  $ 5 $  IF ( (P1 .EQS. "MEGABYTES") .OR. (P1 .EQS. "MB") ) 	 $    THEN  $      MB_FLAG = "TRUE"  $      P1 = P2 $      P2 = "" $      GOTO PARSE_P1
 $    ENDIF $  $ 5 $  IF ( (P1 .EQS. "KILOBYTES") .OR. (P1 .EQS. "KB") ) 	 $    THEN  $      KB_FLAG = "TRUE"  $      P1 = P2 $      P2 = "" $      GOTO PARSE_P1
 $    ENDIF     $!  $ INTEGER_HANDLER: $ $ $  IF (F$Extract(0,2,P1) .EQS. "0X")	 $    THEN % $      P1 = "%x" + F$Extract(2,99,P1) 
 $    ENDIF $ " $  IF (F$type(P1) .EQS. "INTEGER")	 $    THEN  $      SIZE = P1 $      FREE = -1 $      USED = -1 $      P1      = "CD-ROM"  $      TYPE    = ""  $      MOUNTED = ""  $      FOREIGN = ""  $      LOGNAME = ""  $      SWL     = ""  $      GOTO DISPATCHER
 $    ENDIF $  $  $ FILENAME_HANDLER:  $ $ $  FILENAME = F$Parse( P1,,,"NAME" ) $  IF (FILENAME .GTS. "") 	 $    THEN ! $      IF (F$Search(P1) .EQS. "") 
 $        THEN 6 $          WRITE SYS$OUTPUT "%", P1, " doesn't exist!" $          EXIT 01 $        ENDIF$ $      ON WARNING THEN GOTO FILE_ERR, $      DI_EOF  = F$File_Attributes(P1,"EOF") $      ON WARNING THEN CONTINUE , $      DI_ALQ  = F$File_Attributes(P1,"ALQ") $      SIZE    = DI_EOF  $      FREE    = -1  $      USED    = -1  $      TYPE    = ""  $      MOUNTED = ""  $      FOREIGN = ""  $      LOGNAME = ""  $      SWL     = ""  $      GOTO DISPATCHER $  $ FILE_ERR: = $  WRITE SYS$OUTPUT "%", P1, " may be protected against you." 
 $  EXIT 01 $ 
 $    ENDIF $  $  $ DEVICENAME_HANDLER: % $  EXISTS  = F$GetDvI( P1, "EXISTS" )  $  IF (.NOT. EXISTS)	 $    THEN 2 $      WRITE SYS$OUTPUT "%", P1, " doesn't exist!" $      EXIT 01
 $    ENDIF' $  SIZE    = F$GetDvI( P1, "MAXBLOCK" ) ) $  FREE    = F$GetDvI( P1, "FREEBLOCKS" )  $  USED    = SIZE - FREE/ $  TYPE    = F$GetDvI( P1, "DEVICE_TYPE_NAME" ) " $  MOUNTED = F$GetDvI( P1, "MNT" )" $  FOREIGN = F$GetDvI( P1, "FOR" )( $  LOGNAME = F$GetDvI( P1, "LOGVOLNAM" )" $  SWL     = F$GetDvI( P1, "SWL" ) $  IF (.NOT. MOUNTED) 	 $    THEN   $      LOGNAME = "(not mounted)" $      FREE = -1 $      USED = -1
 $    ENDIF $  IF (FOREIGN) 	 $    THEN 0 $      LOGNAME = LOGNAME + " (mounted /FOREIGN)" $      FREE = -1 $      USED = -1
 $    ENDIF $  IF (SIZE .LT. 4) 	 $    THEN  $      IF (MOUNTED) 
 $        THEN 8 $          WRITE SYS$OUTPUT "%Something seems wrong ..."\ $          WRITE SYS$OUTPUT "%", P1, " is mounted but its size is less than 1 2Kbyte block!" $          EXIT 01
 $        ELSE T $          WRITE SYS$OUTPUT "%", P1, " isn't mounted and its size isn't remembered." $          EXIT 01 $        ENDIF
 $    ENDIF $  GOTO DISPATCHER     $! 
 $ DISPATCHER:  $  $  IF (SIZE .LT. 0) 	 $    THEN G $      WRITE SYS$OUTPUT "%The blocksize is negative (bit [31] is set)." ` $      WRITE SYS$OUTPUT "%Please limit yourself to no more than 2,147,483,647 blocks / 1099 GB." $      EXIT 01
 $    ENDIF $ * $  IF (MB_FLAG) THEN GOTO FORMAT_MEGABYTES $ * $  IF (KB_FLAG) THEN GOTO FORMAT_KILOBYTES $  $  IF (SIZE .LT. 4) 	 $    THEN O $      WRITE SYS$OUTPUT "%The CD-ROM capacity must be at least 1 2Kbyte block!"  $      EXIT 01
 $    ENDIF     $!  $ FORMAT_TYPE: $  IF (TYPE .GTS. "") 	 $    THEN  $      TYPE = " (" + TYPE + ")" 
 $    ENDIF $  $  $ FORMAT_SMALL_BLOCKS: $  $  STR    = SIZE $  WIDTH  = 13 $  GOSUB FORMAT  $  SBs    = STR  $  $  SIZE = F$Integer(SIZE) ' $  SBx    = "0x" + F$FAO( "!XL", SIZE )  $  $  MaxSBs = F$String( SIZE-1 ) $  MaxLen = F$Length( MaxSBS )" $  MaxSBx = F$FAO( "!XL", SIZE-1 ) $  $  $ FORMAT_MEGABYTES:  $  $  MB     = SIZEQ $  MB     = (MB / 1000 ) * 512 / 1000  ! Keep this scaled for reasonable accuracy  $  STR    = MB $  IF (MB_FLAG) 	 $    THEN  $      WIDTH  = 0  $      GOSUB FORMAT = $      WRITE SYS$OUTPUT "  Marketing Megabytes: ", STR, " MB"  $      EXIT 01	 $    ELSE  $      WIDTH  = 13 $      GOSUB FORMAT  $      MBs    = STR 
 $    ENDIF $  $  $  $ FORMAT_KILOBYTES:  $  $  KB     = SIZE  $  KB     = (KB+1)/2  ! Round up $  STR    = KB $  IF (KB_FLAG) 	 $    THEN  $      WIDTH  = 0  $      GOSUB FORMAT 3 $      WRITE SYS$OUTPUT "  Kilobytes: ", STR, " KB"  $      EXIT 01	 $    ELSE  $      WIDTH  = 13 $      GOSUB FORMAT  $      KBs    = STR 
 $    ENDIF $  $  $  $ FORMAT_BIG_BLOCKS: $  $  BB  = SIZE / 4  $  BBr = SIZE - (BB * 4) $ 
 $  STR   = BB 
 $  WIDTH = 13  $  GOSUB FORMAT  $  BBs   = STRP $  IF (BBr .GT. 0) THEN BBs = BBs + " + " + F$String( BBr ) + " small blocks!!!" $   $  BBx = "0x" + F$FAO("!XL", BB)P $  IF (BBr .GT. 0) THEN BBx = BBx + " + " + F$String( BBr ) + " small blocks!!!" $  $  MaxBBs = F$String( BB-1 )F $  MaxBBs = F$Extract( 0, MaxLen-F$Length( MaxBBs ), SPACES ) + MaxBBs  $  MaxBBx = F$FAO( "!XL", BB-1 ) $  $  $ FORMAT_SECONDS:  $  $  S   = BB / 75 $  Sr  = BB - (S * 75 )  $  $  STR   = S
 $  WIDTH = 13  $  GOSUB FORMAT  $  Ss    = STRK $  IF (Sr .GT. 0) THEN Ss = Ss + " + " + F$FAO( "!UL !AS!%S", Sr, "frame" )  $  $  $ FORMAT_MINUTES_N_SECONDS:  $  $  M  = S / 60 $  Mr = S - (M * 60)C $  Ms = F$String( M ) + ":" + F$Extract( 1, 2, F$String( Mr+100 ) ) 6 $  Ms = F$Extract( 0, 13 - F$Length(Ms), SPACES ) + MsL $  IF (Sr .GT. 0) THEN Ms = Ms + "  + " + F$FAO( "!UL !AS!%S", Sr, "frame" ) $  $  $ FORMAT_CDROM_FIT:  $ ] $  FC  = ( SIZE + (345000*4 / 200) ) / (345000*4 / 100)  ! Percent of largest possible CD-ROM  $  STR = FC  $  WIDTH = 5 $  GOSUB FORMAT ? $  FCs   = F$Extract( 0, 5, STR )  ! Trim off the decimal point      $!  $ FORMAT_USED_SMALL_BLOCKS:  $ $ $  IF (USED .EQ. -1) THEN GOTO FU_99 $  $  IF (USED .EQ. 0) 	 $    THEN  $      STR = "???"	 $    ELSE  $      STR = USED 
 $    ENDIF $  $  WIDTH  = 13 $  GOSUB FORMAT  $  USBs   = STR  $  $  $ FORMAT_USED_PERCENTS:  $ Y $  UP  = ( USED + (SIZE/200) ) / (SIZE/100)             ! Percent of device size, rounded E $  UP  = "(" + F$String(UP) + "%)"                      ! As "(nnn%)" X $  UP  = UP + F$Extract( F$Length(UP), 99, "      " )   ! Left-justified to 6 characters $  $  $ FORMAT_USED_MEGABYTES: $  $  UMB    = USEDR $  UMB    = (UMB / 1000 ) * 512 / 1000  ! Keep this scaled for reasonable accuracy $  $  IF (USED .EQ. 0) 	 $    THEN  $      STR = "???"	 $    ELSE  $      STR = UMB
 $    ENDIF $  $  WIDTH  = 13 $  GOSUB FORMAT  $  UMBs   = STR  $  $ FU_99:     $!  $ FORMAT_FREE_SMALL_BLOCKS:  $ $ $  IF (FREE .EQ. -1) THEN GOTO FF_99 $  $  IF (FREE .EQ. 0) 	 $    THEN  $      STR = "???"	 $    ELSE  $      STR = FREE 
 $    ENDIF $  $  WIDTH  = 13 $  GOSUB FORMAT  $  FSBs   = STR  $  $  $ FORMAT_FREE_PERCENTS:  $ Y $  FP  = ( FREE + (SIZE/200) ) / (SIZE/100)             ! Percent of device size, rounded E $  FP  = "(" + F$String(FP) + "%)"                      ! As "(nnn%)" X $  FP  = FP + F$Extract( F$Length(FP), 99, "      " )   ! Left-justified to 6 characters $  $  $ FORMAT_FREE_MEGABYTES: $  $  FMB    = FREER $  FMB    = (FMB / 1000 ) * 512 / 1000  ! Keep this scaled for reasonable accuracy $  $  IF (FREE .EQ. 0) 	 $    THEN  $      STR = "???"	 $    ELSE  $      STR = FMB
 $    ENDIF $  $  WIDTH  = 13 $  GOSUB FORMAT  $  FMBs   = STR  $  $ FF_99:     $!  $ DO_OUTPUT: $ ) $  WRITE SYS$OUTPUT "For ", P1, TYPE, ":" q $  WRITE SYS$OUTPUT "  512-byte blocks:             ", SBs,  "  [0:", MaxSBs, "]     ", SBx, "  [0:", MaxSBx, "]" q $  WRITE SYS$OUTPUT "  2Kbyte blocks (big frames):  ", BBs,  "  [0:", MaxBBs, "]     ", BBx, "  [0:", MaxBBx, "]" B $  WRITE SYS$OUTPUT "  Marketing Megabytes:         ", MBs,  " MB"9 $  WRITE SYS$OUTPUT "  Seconds:                     ", Ss 9 $  WRITE SYS$OUTPUT "  Time:                        ", Ms G $  WRITE SYS$OUTPUT "  Size as % of maxsize (76:40) CD-ROM: ", FCs, "%"  $   I $  IF (MOUNTED .EQS. "") THEN GOTO FINI   ! If not a real disk, all done!  $  $ + $              TotlSBs = SBs  +   " (100%)" + $              TotlMBs = MBs  +   " MB    "  $  $  $  IF (.NOT. MOUNTED) 	 $    THEN 0 $              UsedSBs = "    (Not mounted)    "0 $              UsedMBs = "    (Not mounted)    "	 $    ELSE  $      IF (FOREIGN) 
 $        THEN 0 $              UsedSBs = "    (Mountd /FOR)    "0 $              UsedMBs = "    (Mountd /FOR)    "
 $        ELSE  $          IF (USED .NE. -1) $            THEN ( $              UsedSBs = USBs + " " + UP) $              UsedMBs = UMBs + " MB    "  $            ELSE 0 $              UsedSBs = "    (Siz Not Avail!) "0 $              UsedMBs = "    (Siz Not Avail!) " $            ENDIF $        ENDIF
 $    ENDIF $  $  $  IF (.NOT. MOUNTED) 	 $    THEN , $              FreeSBs = "    (Not mounted)", $              FreeMBs = "    (Not mounted)"	 $    ELSE  $      IF (FOREIGN) 
 $        THEN , $              FreeSBs = "    (Mountd /FOR)", $              FreeMBs = "    (Mountd /FOR)"
 $        ELSE  $          IF (FREE .NE. -1) $            THEN ( $              FreeSBs = FSBs + " " + FP) $              FreeMBs = FMBs + " MB    "  $            ELSE / $              FreeSBs = "    (Siz Not Avail!)" / $              FreeMBs = "    (Siz Not Avail!)"  $            ENDIF $        ENDIF
 $    ENDIF $  $  $  WRITE SYS$OUTPUT ""d $  WRITE SYS$OUTPUT "                               Total                 Used                 Free"c $  WRITE SYS$OUTPUT "  512-byte blocks:     ",   TotlSBs,              UsedSBs,             FreeSBs c $  WRITE SYS$OUTPUT "  Marketing Megabytes: ",   TotlMBs,              UsedMBs,             FreeMBs  $  WRITE SYS$OUTPUT ""7 $  WRITE SYS$OUTPUT "  Logical Volume Name:  ", LOGNAME  $  $ FINI: 
 $  EXIT 01     $! 	 $ FORMAT:  $  $  STR    = F$String( STR )  $  STRLEN = F$Length( STR )  $  $  IF (STRLEN .LE. 3) 	 $    THEN  $      GOTO FORMAT_COMMON 
 $    ENDIF $  $  IF (STRLEN .LE. 6) 	 $    THEN 3 $      STR = F$Extract( 0, 6-STRLEN, SPACES ) + STR B $      STR = F$Extract( 0, 3, STR ) + "," + F$Extract( 3, 3, STR ) $      GOTO FORMAT_COMMON 
 $    ENDIF $  $  IF (STRLEN .LE. 9) 	 $    THEN 3 $      STR = F$Extract( 0, 9-STRLEN, SPACES ) + STR a $      STR = F$Extract( 0, 3, STR ) + "," + F$Extract( 3, 3, STR ) + "," + F$Extract( 6, 3, STR )  $      GOTO FORMAT_COMMON 
 $    ENDIF $  $  IF (STRLEN .LE. 12)	 $    THEN 4 $      STR = F$Extract( 0, 12-STRLEN, SPACES ) + STR $      STR = F$Extract( 0, 3, STR ) + "," + F$Extract( 3, 3, STR ) + "," + F$Extract( 6, 3, STR ) + "," + F$Extract( 9, 3, STR ) $      GOTO FORMAT_COMMON 
 $    ENDIF $  $ FORMAT_COMMON:" $  STR = F$Edit( STR, "COLLAPSE" ) $  IF (WIDTH .GT. 0)	 $    THEN F $      STR = F$Extract( 0, WIDTH-F$Length( STR ), SPACES ) + STR + "."
 $    ENDIF	 $  RETURN 