 c 3 c This library manages all things around cld tables . c the layout of a cld table is explained below c  c   General L c    TRO (Table Relative Offset) is an offset from the start of the cliTableQ c    BRO (Block Relative Offset) is an offset from the start of the current block  c  c  c  clitable 
 c   header2 c   verb_tro  --------------------+               . c   cmnd_tro  -->Header           +---->header> c                Tro -->Command         verb   (max 4 letters), c                Tro -->Command         verbD c                ... Length in header   ...    (length is in header) c   Length of table  c G c  Command_block (pointed to by the tro in the cmnd_tro in the clitable 
 c   HeaderD c   param_tro -->entity-->entity-->entity  (via .next_tro in entity)) c   quals_tro -->entity-->entity-->entity ! c   paramcnt (min/max parameters)  c   name(_bro) c   image(_bro)  c  c  Entity_block 
 c   HeaderC c   next_tro                      Pointer to the next in this chain 2 c   syntax_tro-->Command_block    Change of syntax4 c   user_type_tro-->type_block    User defined typesD c   value_type                    Type of value (if user_type_tro=0) c   name(_bro) c   label(_bro)  c   prompt(_bro) c   default_value(_bro)  c 
 c  Type_block 
 c   Header, c   keyword_tro --> entity-->entity-->entity c   name(_bro) c    c , 	function table_init(ptr_table_info,verbone) 	implicit none c ' c Allocate and Init table control block ! c  return a pointer to this block  c  	include 'table.inc'5 	integer*4 ptr_table_info	!:o: pointer to table block ( 	logical*4 verbone		!:i: verbone setting+ 	integer*4 table_init		!:f: function result  c# 	integer*4 istat 	record /table_info/ table_info " 	pointer (p_table_info,table_info) c  	integer*4 table__set_dcl  	integer*4 lib$get_vm  c 4 c Set the initial verbone state, this can be changed c with the ^V/f9 key c 
 c verbone ? c  some images do have cld tables but only to parse qualifiers. = c  they will do a lib$get_foreign to get the command line and 8 c  then a dcl_parse with a programmed verb. This verb is$ c  not visible to the outside world.F c  f.e. suppose we have a program test that defines "fixed" verb "vrb" c  test:=$test c  test /qual1/qual2.... c  The source woiuld be # c  call lib$get_foreign(line,,nkar) . c  call cli$dcl_parse('vrb '//line(1:nkar)...) c G c So the verb is test, but on the outside (users using the symbol test) 4 c  this "vrb" is not needed (and indeed not wanted). c I c If you have "verbone" set, and AUTO discovers an image with only 1 verb C c ("vrb" in the previous example) AUTO will not prompt for the verb + c nor will it insert it in the command line < c If verbone is clear, AUTO will ask for and insert the verbK c   (the program does a CLI$DCL_PARSE(LINE(1:NKAR)...) with the fixed "VRB"  c  c 4 	istat = lib$get_vm(sizeof(table_info),p_table_info) 	if(istat) then  	  table_info.verbone = verbone  c % 	  istat = table__set_dcl(table_info)  	endif 	ptr_table_info = p_table_info 	table_init = istat  	return  	end$ 	function table__set_dcl(table_info) 	implicit none c 4 c Init table control block to the standard DCL table7 c  it will take the CLI$AG_CLITABLE (so we need to link  c  with /SYSEXE) c  	include 'table.inc'1 	record /table_info/ table_info	!:io: table block . 	integer*4 table__set_dcl	!:f: function result c# 	integer*4 istat,nverbs  c  	integer*4 pointer 	pointer (p_pointer,pointer) c  	integer*4 get_dcl_table 	integer*4 table__check_table  c  c Look for the symbol table  c  	p_pointer = get_dcl_table() c 6 	istat = table__check_table(pointer,table_info,nverbs) 	table__set_dcl = istat  	return  	end7 	function table__check_table(pointer,table_info,nverbs)  	implicit none c 1 c Check if pointer points to a valid vector block  c  	include 'table.inc'  	integer*4 pointer		!:i: pointer0 	record /table_info/ table_info	!:o: table block& 	integer*4 nverbs		!:o: #verbs defined2 	integer*4 table__check_table	!:f: function result c  	integer*4 istat c  	record /vector_block/ table 	pointer (p_table , table) c  	record /verbs/ verb_table" 	pointer (p_verb_table,verb_table) c  	integer*4 table__tro  c  c Look for the symbol table  c  	p_table   = pointer c " c Check if this is a correct table c 6         if(table.header.length .ne. sizeof(table) .or.:      1     table.header.type   .ne. block_type_vector .or.C      1     table.header.subtype.ne. vector_block_subtype_dcl ) then  c  c Invalid ?? c  	  istat = 0         else c  c Fill the block c % 	  table_info.table_pointer = p_table @ 	  table_info.ptr_verbs = table__tro(table_info,table.verbs_tro)C 	  table_info.ptr_cmnds = table__tro(table_info,table.commands_tro)  c  c Get #verbs c & 	  p_verb_table = table_info.ptr_verbsD 	  nverbs = (verb_table.header.length - sizeof(verb_table.header))/ 1      1               sizeof(verb_table.verbsa(1))  	  table_info.n_verbs = nverbs 	  istat = 1 	endif 	table__check_table = istat  	return  	end c / 	function table_valid_verb(ptr_table_info,verb)  	implicit none c 3 c See if verb is a verb in the (current) cli tables  c  	include 'table.inc': 	integer*4 ptr_table_info	!:i: pointer to table info block+ 	character*(*) verb		!:i: the verb to check 5 	integer*4 table_valid_verb	!:f: result (1=oke,0=not)  c#5 	record /table_info/ table_info	!:i: table info block " 	pointer (p_table_info,table_info) 	integer*4 nk_verb 	character*(max_name) line 	logical exact c  	integer*4 idx,ptr,n_fnd c  	integer*4 table_match_verb  c + c Loop around all verbs and see for a match  c  	p_table_info = ptr_table_info c  	idx = 14 	do while(table_match_verb(ptr_table_info,verb,line,(      1           nk_verb,idx,ptr,exact)) c " c If we have a full match, all oke c  	  if(exact) goto 10 c  c Add one more match c  	  n_fnd = n_fnd + 1 	end do  c ( c if n_fnd =1, we have exactly one match c  	exact = n_fnd .eq. 1  c  c Return status  c  10	if(exact) then  	  table_valid_verb = 1  	else  	  table_valid_verb = 0  	endif 	return  	end' 	function table__tro(table_info,offset)  	implicit none c 3 c Return pointer with a TRO (table relative offset)  c  	include 'table.inc'; 	record /table_info/ table_info		!:i: the table info block	 * 	integer*4 offset        		!:i: the offset/ 	integer*4 table__tro			!:f: the pointer (or 0)  c# 	if(offset .eq. 0) then  	  table__tro  = 0 	else 1 	  table__tro = table_info.table_pointer + offset  	end if  	return  	end@ 	function table_match_verb(ptr_table_info,what,verb,nk_verb,idx,4      1                            ptr_command,exact) 	implicit none c ( c See if "WHAT" matches one of the verbs c  and update the .index field c  	include 'table.inc'7 	integer*4 ptr_table_info	!:i: pointer to control block . 	character*(*) what		!:i: the verb to look for( 	character*(*) verb		!:o: the verb found' 	integer*4 nk_verb		!:o: lenght of verb 2 	integer*4 idx			!:io: index for match (init to 1)F 	integer*4 ptr_command		!:o: the pointer to the selected command block) 	logical exact			!:o: true if exact match 6 	integer*4 table_match_verb	!:f: function result (0/1) c#0 	record /table_info/ table_info	!:io: table info" 	pointer (p_table_info,table_info) 	record /verbs/ verb_table" 	pointer (p_verb_table,verb_table) c   	record /commands/ command_table( 	pointer (p_command_table,command_table) c  	record /command_block/ command  	pointer (p_command,command) c  	integer*4 k,nk,l,bpos,nb  	logical*4 got_match! 	integer*4 str$case_blind_compare  	integer*4 table__tro  c  	character*(max_name) name 	integer*4 nk_name	  c ( c Verbs are found through the verb table8 c this is a list of 4 byte strings, allowing for a quick4 c search. It the first 4 (or less) characters match,: c there is a second list with tro's to the command blocoks c that contain the full name c  c Set pointer to the verb table G c  this is a tabel of longwords with the first 4 characters of the verb  c  	p_table_info = ptr_table_info$ 	p_verb_table = table_info.ptr_verbs c  	exact = .false.& 	table_match_verb = 0	!assume no match c  c CHeck for the bound  c * 10	if(idx .gt. table_info.n_verbs) goto 90 c  c Get and update the index c  	k = idx 	idx = idx + 1 c * c Get the length of the verb in the table,( c this is 4 (or less if zero terminated) c - 	nk = index(verb_table.verbsa(k),char(0)) - 1 - 	if(nk .lt. 0) nk = len(verb_table.verbsa(k))  c  	nk = min(len(what),nk)  c  c See if this one matches  c 6 	if(str$case_blind_compare(verb_table.verbsa(k)(1:nk),=      1                            what(1:nk)) .ne. 0) goto 10  c = c We have a short match, see if the long name is also correct $ c name_bro points to a list of names* c preceeded by a byte for the total length* c we are interested in the first name only c ' 	p_command_table = table_info.ptr_cmnds  c ? c Since more than one entry can point to the same command entry : c we check to see if the offset has already been processed c  	do l=1,k-1 ( 	  if(command_table.command_tro(l) .eq. 2      1       command_table.command_tro(k)) goto 10 	end do  c @ 	p_command = table__tro(table_info,command_table.command_tro(k)) c  c Get the full name 3 c Name_bro contains a list of values (the synonyms)  c the total structure is c  nbyte_total c  bytecounted string1 c  bytecounted string2 c  bytecounted string3	 c  ...etc 1 c  Example : for the verb SHOW there are 2 names  
 c  1: SHOW c  2: SH c ( 	bpos = %loc(command) + command.name_bro c  c Get the total nbyte  c  	nb = 0   	call lib$movc3(1,%val(bpos),nb) 	bpos = command.name_bro+1 	got_match = .false. 	exact = .false. 	do while(nb .gt. 0)3 	  call table__name_copy(command,bpos,name,nk_name)  	  nb = nb - nk_name - 1 	  bpos = bpos + nk_name + 1 c  c Now we have the full name  c " 	  if(len(what) .le. nk_name) then  	    nk = min(len(what),nk_name)* 	    if(str$case_blind_compare(name(1:nk),2      1                    what(1:nk)) .eq. 0) then 	      got_match = .true. 0 	      if(nk_name .eq. len(what)) exact = .true.
 	    endif 	  endif 	end do  c " c If match not set, no match found c  	if(.not. got_match) goto 10 c  c Match  c Get #parameters  c	 	ptr_command = p_command c   c And return the first full name c  	bpos = command.name_bro+11 	call table__name_copy(command,bpos,verb,nk_verb)  c  	table_match_verb = 1  c 	 90	return  	end c C 	function table_set_command_param(ptr_table_info,ptr_terminal_info, *      1                        ptr_command,:      1                        par_idx,ptr_entity,par_addr) 	implicit none c P c return pointer to entity block for parameter 'par_idx' for the current command c  	include 'table.inc'	 6 	integer*4 ptr_table_info		!:i: pointer to table block< 	integer*4 ptr_terminal_info		!:i: pointer to terminal block6 	integer*4 ptr_command			!:i: pointer to command block1 	integer*4 par_idx			!:i: the requested parameter 8 	integer*4 ptr_entity			!:o: pointer to ent entity block4 	integer*4 par_addr			!:i: address of parameter list7 	integer*4 table_set_command_param	!:f: function result  c#6 	record /table_info/ table_info		!:i: table info block" 	pointer (p_table_info,table_info) c  	record /command_block/ command  	pointer (p_command,command) c  	record /entity_block/ entity  	pointer (p_entity,entity)	  c  	integer*4 istat,idx c  	integer*4 table__tro  	external auto_msg_interr  	external auto_msg_expparam  c 
 	istat = 1 	p_table_info = ptr_table_info 	p_command = ptr_command c ( c Set the pointer to the first parameter c 5 c	p_entity = table__tro(table_info,command.param_tro)  	p_entity = par_addr c  	idx = 0 c  	do while(p_entity .ne. 0)   c 3 c They should be type parameter, but you never know  c E 	  if(entity.header.subtype .eq. entity_block_subtype_parameter) then  	    idx = idx + 1 	    if(idx .eq. par_idx) then c   c  Got it, so return the pointer c  	      ptr_entity = p_entity 	      goto 90
 	    endif	    	  else 7 	    call auto_msg(ptr_terminal_info,auto_msg_expparam)  	  endif c  c  Try the next  c   4 	  p_entity = table__tro(table_info,entity.next_tro) 	end do  c  c This should not happen c  	istat = %loc(auto_msg_interr) c # 90	table_set_command_param  = istat  	return  	end4 	subroutine table__name_copy(block,bro,name,nk_name) 	implicit none c % c Copy an ascic string to a fixed one  c  	byte block(*)		!:i: data block  	integer*2 bro		!:i: offset " 	character*(*) name	!:o: the  name& 	integer*4 nk_name	!:o: length of name c# c Compute the length c , 	nk_name = min(zext(block(bro+1)),len(name)) c  c Move the text  c 0 	call lib$movc3(nk_name,block(bro+2),%ref(name)) c  c Blank extra bytes  c 2 	if(nk_name .lt. len(name)) name(nk_name+1:) = ' ' 	return  	end		  C 	function table_list_command_qual(ptr_table_info,ptr_terminal_info, 5      1                                   ptr_command, ;      1                                   line,qual,nk_qual, <      1                                   ptr_entity,negated,3      1                                   qual_addr)  	implicit none c A c List the next qualifier matching "line" for the current command E c ptr_entity must be inited to 0, and is then updated by this routine  c  	include 'table.inc'/ 	integer*4 ptr_table_info	!:i: table info block 5 	integer*4 ptr_terminal_info	!:i: terminal info block = 	integer*4 ptr_command		!:i: the pointer to the command block . 	character*(*) line		!:i: the pattern to match- 	character*(*) qual		!:O: the qualifier found ' 	integer*4 nk_qual		!:o: length of qual > 	logical*4 negated    		!:o: was the match found with the NOxx< 	integer*4 ptr_entity		!:io: the pointer to the entity block6 	integer*4 qual_addr		!:i: the qualifier list address 7 	integer*4 table_list_command_qual !:f: function result  c  	record /table_info/ table_info " 	pointer (p_table_info,table_info) c  	record /command_block/ command  	pointer (p_command,command) c  	record /entity_block/ entity  	pointer (p_entity,entity)	  c  	integer*4 istat c  	external auto_msg_expqual 	integer*4 auto_msg  c  	logical*4 table__compare  	integer*4 table__tro  c  	p_table_info = ptr_table_info c  	istat = 1		!assume found  c & c Get the pointer to the command_block c  	p_command      = ptr_command  c  c Now set the pointer  c  	if(ptr_entity .eq. 0) then  c  c Take the first c < c	  p_entity  = table__tro(table_info,command.qualifier_tro) 	  p_entity  = qual_addr 	else  c + c Take the previous one, and then it's next  c  	  p_entity  = ptr_entity 4 	  p_entity = table__tro(table_info,entity.next_tro) 	endif c + c See if this one matches the wanted string  c  	do while(p_entity .ne. 0)   c . c Should all be qualifiers, but you never know c E 	  if(entity.header.subtype .eq. entity_block_subtype_qualifier) then  c  c See if it matches  c > 	    if(table__compare(line,entity,qual,nk_qual,negated)) then 	      goto 90
 	    endif 	  else  c  c Ingore status from auto_msg  c 6 	    call auto_msg(ptr_terminal_info,auto_msg_expqual) 	  endif c  c Try the next one c 4 	  p_entity = table__tro(table_info,entity.next_tro) 	end do 
 	istat = 0 	goto 99 c  c Remember the pointer c  90	ptr_entity = p_entity c & c Return the status (0=no more, 1=oke) c " 99	table_list_command_qual = istat 	return  	end1 	subroutine table_get_default(ptr_entity,def_des)  	implicit none c + c Return a descriptor to the default string  c  	include 'table.inc' c 0 	integer*4 ptr_entity		!:i: ptr to entirty block8 	integer*4 def_des(2)		!:o: descriptor for default value c# c  	integer*4 ipos  c  c The entity block c  	record /entity_block/ entity  	pointer (p_entity,entity)	  c  	p_entity = ptr_entity c  c Return the default value c ' c defval_bro contains a list of values   c the total structure is c  nbyte_total c  bytecounted string1 c  bytecounted string2 c  bytecounted string3	 c  ...etc  c  c We return the first value  c  	ipos = entity.defval_bro  c  	if(ipos .ne. 0) then 5 	  ipos = ipos + %loc(entity) - %loc(entity.rest) + 2  c % c Now ipos points to the first string  c ' 	  def_des(1) = zext(entity.rest(ipos)) * 	  def_des(2) = %loc(entity.rest(ipos+1))	 	else  	  def_des(1) = 0 " 	  def_des(2) = %loc(entity.rest)	 	endif c  	return  	end5 	function table_list_user(ptr_table_info,user_entity, 7      1          line,value,nk_value,ptr_entity,negated)  	implicit none c A c try to match the line to the name of the next user defined type 1 c after (no) match update the pointer to the next  c  	include 'table.inc' 	integer*4 ptr_table_info  c 2 	integer*4 user_entity	!:io: pointer to user block% 	character*(*) line	!:i: match string . 	character*(*) value	!:o: returned match value( 	integer*4 nk_value	!:o: length of value2 	integer*4 ptr_entity	!:o: return value for entity6 	logical*4 negated	!:o: true is matchwas a negated one- 	logical table_list_user	!:f: function result  c# 	record /table_info/ table_info " 	pointer (p_table_info,table_info) c  	record /entity_block/ entity  	pointer (p_entity,entity)	  c  	integer*4 istat c  	integer*4 table__tro  	logical*4 table__compare  c  	character*(max_name) name_work  	integer*4 nk_work c  	p_table_info = ptr_table_info c  	istat = 1		!assume match found  c  c  Keep going until pointer=0  c  	do while(user_entity .ne. 0)  	  p_entity = user_entity 7 	  user_entity = table__tro(table_info,entity.next_tro)  c  c Now see if type matches  c A 	  if(table__compare(line,entity,name_work,nk_work,negated)) then  	    ptr_entity = p_entity! 	    value = name_work(1:nk_work)  	    nk_value = nk_work  	    goto 90 	  endif 	enddo c  c So sorry, no match c  	istat  = 0  c  90	table_list_user = istat 	return  	end		  : 	function table__compare(item,entity,name,nk_name,negated) 	implicit none c , c See if item matches the name of the entity c  	include 'table.inc'. 	record /entity_block/ entity 	!:i: the entity+ 	character*(*) item		!:i: the name to match * 	character*(*) name		!:o: found match name' 	integer*4 nk_name		!:o: length of name - 	logical negated			!:o: trur is match negated , 	logical*4 table__compare	!:f: true if match c# 	integer*4 nk,nk_temp_name 	logical*4 neg 	character*(max_name) temp_name  c ! 	integer*4 str$case_blind_compare  c - 	table__compare = .true.	!assume match is oke  c  c Extract the name c E 	call table__name_copy(entity,entity.name_bro,temp_name,nk_temp_name)  c # c len(item) must be <= nk_temp_name  c  	nk = len(item)  	neg = .false. c  	if(nk .le. nk_temp_name) then( 	  if(str$case_blind_compare(item(1:nk),D      1                              temp_name(1:nk)) .eq. 0) goto 90 	endif c  c Check if negatable allowed c A         if(btest(entity.header.flags,entity_block_flag_neg)) then  c   c Now see if item matches NOname c  c  	  neg = .true.  	  temp_name = 'NO'//temp_name" 	  nk_temp_name = nk_temp_name + 20 	  if(nk .ge. 2 .and. nk .le. nk_temp_name) then* 	    if(str$case_blind_compare(item(1:nk),F      1                          'NO'//temp_name(1:nk)) .eq. 0) goto 90 	  endif 	endif c  c  No match, so return 0 c  	table__compare = .false.  	goto 99 90	negated = neg$ 	name    = temp_name(1:nk_temp_name) 	nk_name = nk_temp_name  c 	 99	return  	end c  c 2 	subroutine table_get_command_data(ptr_table_info,)      1          ptr_command,command_info)  	implicit none c = c Get the min_,max_params, n_qualifiers fields of the command > c but only if the _par,m bit is set, else leave them unchanged c  	include 'table.inc') 	integer*4 ptr_table_info	!:i: table info 6 	integer*4 ptr_command		!:i: pointer to command block	- 	record /command_info/ command_info !:o: data  c  	record /command_block/ command  	pointer (p_command,command) c  	integer*4 npar  c  	integer*4 table__tro  c / 	record /table_info/ table_info	!:i: table info " 	pointer (p_table_info,table_info) c  	record /entity_block/ entity  	pointer (p_entity,entity)	  c " c Now set pointer to command block c  	p_table_info = ptr_table_info 	p_command = ptr_command c  c Now set min/max parameters0 c But only if the _parms bit is set in the flags c   c .npar is a byte of two nibbles) c  the low  4 bits contain the .min_param ) c  the high 4 bits contain the .max_param  c   > 	if(btest(command.header.flags,command_block_flag_parms)) then# 	  npar = zext(command.param_count) ( 	  command_info.npar_min = iand(npar,15) 	  npar = npar/16 ( 	  command_info.npar_max = iand(npar,15)C 	  command_info.par_addr = table__tro(table_info,command.param_tro)  	endif c . c If this entry has quals, update the pointers c > 	if(btest(command.header.flags,command_block_flag_quals)) then c 6 	  command_info.ptr_disallow  = table__tro(table_info,G      1                                            command.disallow_tro) 2 	  command_info.qual_addr = table__tro(table_info,D      1                                        command.qualifier_tro)) 	  command_info.ptr_command = ptr_command  	endif c  c Now take the current command   c  and get the #qualifiers c ' 	p_entity      = command_info.qual_addr  	command_info.n_qual = 0 	do while (p_entity .ne. 0) 0 	  command_info.n_qual = command_info.n_qual + 14 	  p_entity = table__tro(table_info,entity.next_tro) 	end do		    	return  	end6 	subroutine table_entity_name(ptr_entity,name,nk_name) 	implicit none c  c return the name of the entity  c  	include 'table.inc'( 	integer*4 ptr_entity		!:i: entity block7 	character*(*) name		!:o: the name (filled with spaces) 5 	integer*4 nk_name		!:o: length of name(without fill)  c# 	record /entity_block/ entity  	pointer (p_entity,entity)	  c  	if(ptr_entity .eq. 0) then  	  nk_name = 0& 	  call sys$fao('%%ZERO',nk_name,name) 	else  	  p_entity = ptr_entity c * c It there was a label field, use that one c # 	  if(entity.label_bro .ne. 0) then @ 	    call table__name_copy(entity,entity.label_bro,name,nk_name) 	  else  c  c Else use the entity name c ? 	    call table__name_copy(entity,entity.name_bro,name,nk_name)  	  endif 	endif 	return  	end4 	function table_is_rest_of_line(ptr_entity,override) 	implicit none c : c Return true is the real (or override) type is restofline c  	include 'table.inc'3 	integer*4 ptr_entity		!:i: pointer to entity block 1 	integer*4 override		!:i: override for value type  	logical table_is_rest_of_Line c# 	record /entity_block/ entity  	pointer (p_entity,entity)	  c  	integer*4 test_val  c  	if(ptr_entity .eq. 0) then  c  c No entity has no type  c " 	  table_is_rest_of_line = .false. 	else  c 0 c Take either the override or the original value c  	  if(override .ge. 0) then  	    test_val = override 	  else  	    p_entity = ptr_entity 	    test_val = entity.valtyp  	  endif c # c Return true if value = restofline  c G 	  table_is_rest_of_line = test_val .eq. entity_block_valtyp_restofline  	endif 	return  	end8 	subroutine table_command_name(ptr_command,name,nk_name) 	implicit none c & c Return the name of the command(verb) c  	include 'table.inc'2 	integer*4 ptr_command         	!:i: command block9 	character*(max_name) name	!:o: name (filled with spaces) . 	integer*4 nk_name		!:o: length (without fill) c# 	record /command_block/ command  	pointer (p_command,command)	  c  c  	if(ptr_command .eq. 0) then 	  nk_name = 0& 	  call sys$fao('%%ZERO',nk_name,name) 	else  	  p_command = ptr_command c  c for a verb5 c  Name_bro contains a list of values (the synonyms)   c   the total structure is c    nbyte_total c    bytecounted string1 c    bytecounted string2 c    bytecounted string3 c    ...etc ! c   We only want the first string  c FOr a syntax change  c  name_bro is just one name c B 	  if(command.header.subtype .eq. command_block_subtype_verb) thenC 	    call table__name_copy(command,command.name_bro+1,name,nk_name)  	  else A 	    call table__name_copy(command,command.name_bro,name,nk_name)  	  endif 	endif 	return  	end< 	function table_set_command_proc(ptr_table_info,symbol_info,'      1          ptr_terminal_info,verb)  	implicit none c 6 c The user entered a verb that appears to be a symbols+ c  and that symbol contains a @proc command 1 c This procedure builds a cld table that contains  c all info for an @ command." c that means a /out=file qualifier" c         and  8 parameters p1..p8) c all parameter have type string and list 9 c but if the user defines antoher symbol verb_parameters, 8 c  the value of that symbol can be used to define p1..p8< c The contents of the symbol must be in the following layout c  "type1,type2.."8 c Upto 8 types can be defined. If you specify less, AUTO< c  will not allow you to use more than the define parameters$ c the value of type1 = type or type*( c  type must be one of the defined types- c  if you append a *, pn will be of type list ? c  The first type with a #, is the first not required parameter  c  	include 'table.inc' 	integer*4 ptr_table_info " 	integer*4 table_set_command_proc  	integer*4 symbol_info 	integer*4 ptr_terminal_info 	character*(*) verb  c  	record /table_info/ table_info " 	pointer (p_table_info,table_info) c  	common /table_data/ data    	record /table_data/ data  c F c to make sure it exists after leaving this subroutine, make it common c  	integer*4 bpos,istat  c  	integer*4 table__check_table # 	integer*4 table__insert_parameters  c 
 c Now init c 	 	bpos = 1  	p_table_info = ptr_table_info c < 	data.vector_block.header.length = sizeof(data.vector_block)4 	data.vector_block.header.type   = block_type_vector; 	data.vector_block.header.subtype= vector_block_subtype_dcl $ 	data.vector_block.header.flags  = 0' 	data.vector_block.header.tro_count = 0 F 	data.vector_block.verbs_tro     = %loc(data.verb_header) - %loc(data)F 	data.vector_block.commands_tro  = %loc(data.cmnd_header) - %loc(data) c  c Fill the tables  c 9 	data.verb_header.length    = sizeof(data.verb_header) +  7      1                               sizeof(data.verbs) / 	data.verb_header.type      = block_type_vector 7 	data.verb_header.subtype   = vector_block_subtype_verb  	data.verb_header.flags     = 0  	data.verb_header.tro_count = 0  c 2 	data.verbs(1)    = '@'//char(0)//char(0)//char(0) c 9 	data.cmnd_header.length    = sizeof(data.verb_header) +  :      1                               sizeof(data.commands)/ 	data.cmnd_header.type      = block_type_vector : 	data.cmnd_header.subtype   = vector_block_subtype_command 	data.cmnd_header.flags     = 0  	data.cmnd_header.tro_count = 0  c 3 	data.commands(1) = %loc(data.command) - %loc(data)  c  c Now fill the command block c 2 	data.command.header.length = sizeof(data.command)0 	data.command.header.type   = block_type_command8 	data.command.header.subtype= command_block_subtype_verb 	data.command.header.flags  = ;      1              ibset(0,command_block_flag_parms) .or.  5      1              ibset(0,command_block_flag_quals) " 	data.command.header.tro_count = 0 c C 	data.command.param_tro     = %loc(data.par_entity(1)) - %loc(data) C 	data.command.qualifier_tro = %loc(data.qual_entity)   - %loc(data) / 	data.command.disallow_tro  = 0			!no disallows  	data.command.handler       = 0  	data.command.verb_type     = 0  	data.command.pad           = 0 G 	data.command.name_bro      = %loc(data.names(bpos))-%loc(data.command)  c $ 	data.names(bpos) = 3		!total length 	bpos = bpos + 1- 	call table__insert_name(data.names,bpos,'@')  	data.command.image_bro     = 0  	data.command.outputs_bro   = 0  	data.command.prefix_bro    = 0  c 6 c Now fill the parameters (default 8*string with list) c  and no parameter required c (  	istat = table__insert_parameters(data,6      1           '#STRING*,STRING*,STRING*,STRING*,'//3      1           'STRING*,STRING*,STRING*,STRING*', =      1               symbol_info,ptr_terminal_info,verb,bpos)  	if(.not. istat) goto 90 c  c And now the qualifier OUTPUT c < 	data.qual_entity.header.length = sizeof(data.par_entity(1))3 	data.qual_entity.header.type   = block_type_entity @ 	data.qual_entity.header.subtype= entity_block_subtype_qualifier" 	data.qual_entity.header.flags  = 6      1           ibset(0,entity_block_flag_list) .or. 5      1           ibset(0,entity_block_flag_val) .or.  0      1           ibset(0,entity_block_flag_parm)# 	data.command.header.tro_count  = 0 # 	data.qual_entity.next_tro      = 0 # 	data.qual_entity.syntax_tro    = 0 # 	data.qual_entity.user_type_tro = 0 $ 	data.qual_entity.number        = 0	K 	data.qual_entity.valtyp        = entity_block_valtyp_outfile		!output file 9 	data.qual_entity.name_bro      = %loc(data.names(bpos))- ?      1                                   %loc(data.qual_entity) 2 	call table__insert_name(data.names,bpos,'OUTPUT')# 	data.qual_entity.label_bro     = 0 # 	data.qual_entity.prompt_bro    = 0 # 	data.qual_entity.defval_bro    = 0  c C c Always return .TRUE. (since check_verb should not have a problem)  c 7 	istat = table__check_table(%loc(data),table_info,bpos)  c ! 90	table_set_command_proc = istat  	return  	end              . 	subroutine table__insert_name(names,bpos,txt) 	implicit none c " c Insert a name in the BRO section c 2 	byte names(*)		!:o: the name field (the BRO area)= 	integer*4 bpos          !:io: the pointer in the names field * 	character*(*) txt	!:i: the name to insert c  	names(bpos) = len(txt) 1 	call lib$movc3(len(txt),%ref(txt),names(bpos+1))  	bpos = bpos + 1 + len(txt)  	return  	end+ 	function table_close_image(ptr_table_info)  	implicit none c 5 c Close the current image, and set tables back to DCL  c  	include 'table.inc'* 	integer*4 ptr_table_info	!:o: table block 	integer*4 table_close_image c  	integer*4 istat c  	integer*4 table_info_close  	integer*4 table__set_dcl  c 0 	record /table_info/ table_info	!:o: table block" 	pointer (p_table_info,table_info) c  c Close the image  c  	p_table_info = ptr_table_info) 	istat = table_info_close(ptr_table_info)  	if(.not. istat) goto 90 c  c And revert to DCL tables c # 	istat = table__set_dcl(table_info)  c  90	table_close_image = istat 	return  	end  @ 	function table_set_image(ptr_table_info,fnam,ptr_terminal_info,.      1                           special,verb,8      1                           symbol_info,verb_input) 	implicit none c + c This routine processes settings of images . c  It will map the image and try to locate the c  cld tables in the image. > c  if this is sucessful, set the table_info th the found table= c  if not, assume one parameter $restofline (unless the user  C c   defines a symbol 'verb'_parameters with the expected parameters  c  	include 'table.inc'* 	integer*4 ptr_table_info	!:o: table block) 	character*(*) fnam		!:i: the file to map  	integer*4 ptr_terminal_infoE 	logical*4 special		!:o: special action for images with only one verb E 	character*(*) verb		!:o: returns the first (nad maybe the only) verb 1 	integer*4 symbol_info		!:i: the  symbol structur - 	character*(*) verb_input	!:i: The verb input / 	integer*4 table_set_image	!:f: function result  c 5 	integer*4 lun_i,istat,inadr(2),nword,flags,ptr_table 0 	integer*4 nk_what,ptr_command,exact,nk_verb,idx 	character*1 what  	integer*4 nverbs  c  	record /table_info/ table_info " 	pointer (p_table_info,table_info) c  	record /table_data/ data  	common /data/ data  c F c to make sure it exists after leaving this subroutine, make it common c  	include '($secdef)' c          integer*2 channel  	integer*4 nblocks0         common /channel_message/ nblocks,channel c  	external table__user_open_vb  	integer*4 table__user_open_vb 	integer*4 table__check_table  	integer*4 table__search_item   	integer*4 table__set_restofline 	integer sys$crmpsc  	external auto_msg_tabnotf c  c  Try to ope the file% c    this will check on accessibility  c  and is needed for the crmpsc  c  	p_table_info = ptr_table_info 	call lib$get_lun(lun_i), 	open(lun_i,file=fnam,status='old',readonly,1      1             defaultfile='sys$system:.exe', 7      1             useropen=table__user_open_vb,err=80)  c * c Now we have the channel and the #blocks  c try to map into vm c  	flags = sec$m_expreg  	inadr(1) = 512  	inadr(1) = 512  c  	table_info.chan_imag = channel 3         istat = sys$crmpsc(inadr,table_info.retadr, &      1          %val(0),%val(flags),,,7      1          ,%val(channel),%val(nblocks),%val(1),,)  	if(.not. istat) goto 80 c : c  Now look in memory for a datastructure like a cld table> c  this is not completely fool-proof, but good enough (I hope) c 6 	nword = (table_info.retadr(2)-table_info.retadr(1))/2G 	istat = table__search_item(nword,%val(table_info.retadr(1)),ptr_table)  ce 	if(istat) thena c @ c We have a structure (in the image) that looks like a cld table cO: 	  istat = table__check_table(ptr_table,table_info,nverbs) 	  if(.not. istat) goto 70; 	  special = (nverbs .eq. 1) .and. .not. table_info.verbone  	  if(special) thent c  c Return the first verb> cd 	    idx = 1 	    nk_what = 0: 	    call table_match_verb(ptr_table_info,what(1:nk_what),3      1                            verb,nk_verb,idx,h4      1                            ptr_command,exact) 	  endif
 	  goto 90 	elseo ce% c Now revert to a simple command linec c  $restofline cr1 	  istat = table__set_restofline(data,verb_input,n2      1              symbol_info,ptr_terminal_info) 	  if(.not. istat) goto 90 ca* c set_restofline filled the data structure< c  since it is in common, the contents will not be lost when c  we leave this routine cx 	  ptr_table = %loc(data)x: 	  istat = table__check_table(ptr_table,table_info,nverbs)# 	  ptr_command = %loc(data.command)  	  special = .true.		!no verb  	  verb = data.verbs(1)p 	endif c 0 c Could not find the table, so return the memory c ( 70	call table_info_close(ptr_table_info) 	goto 90 c ! c OPen went wrong, get the reason> ci 80	call errsns(,istat) c  90	table_set_image = istat 	return, 	end;  	function table__set_restofline(data,verb,ptr_symbol_info,c<      1                                 ptr_terminal_info)	   	implicit none ct= c Create a command table for one parameter (type $restofline):4 c  Unless the user define a symbol 'verb'_parameters cs 	include 'table.inc'& 	record /table_data/ data		!:o: filled$ 	character*(*) verb 			!:i: the verb5 	integer*4 ptr_symbol_info  			!:i: symbol table info 1 	integer*4 ptr_terminal_info			!:i: terminal infog6 	integer*4 table__set_restofline		!:f: function result c# 	integer*4 bpos,istaty c # 	integer*4 table__insert_parameters  c$	 	bpos = 1  cg' c  Normally we would assume $restoflinea  c  for images withou CLD tables.$ c  but if the user defines a symbol  cl< 	data.vector_block.header.length = sizeof(data.vector_block)4 	data.vector_block.header.type   = block_type_vector; 	data.vector_block.header.subtype= vector_block_subtype_dclr$ 	data.vector_block.header.flags  = 0' 	data.vector_block.header.tro_count = 0b< 	data.vector_block.verbs_tro     = %loc(data.verb_header) - 4      1                                    %loc(data)< 	data.vector_block.commands_tro  = %loc(data.cmnd_header) - 4      1                                    %loc(data) cm c Fill the tables  c 9 	data.verb_header.length    = sizeof(data.verb_header) + a7      1                               sizeof(data.verbs)m/ 	data.verb_header.type      = block_type_vectori7 	data.verb_header.subtype   = vector_block_subtype_verb) 	data.verb_header.flags     = 0  	data.verb_header.tro_count = 0  c  	data.verbs(1)    = 'DUMM' c_9 	data.cmnd_header.length    = sizeof(data.verb_header) +  :      1                               sizeof(data.commands)/ 	data.cmnd_header.type      = block_type_vectork: 	data.cmnd_header.subtype   = vector_block_subtype_command 	data.cmnd_header.flags     = 0  	data.cmnd_header.tro_count = 0' cr3 	data.commands(1) = %loc(data.command) - %loc(data)t cr c Now fill the command block ce2 	data.command.header.length = sizeof(data.command)0 	data.command.header.type   = block_type_command8 	data.command.header.subtype= command_block_subtype_verb? 	data.command.header.flags  = ibset(0,command_block_flag_parms)i" 	data.command.header.tro_count = 0 c_C 	data.command.param_tro     = %loc(data.par_entity(1)) - %loc(data)l/ 	data.command.qualifier_tro = 0			!no qualifieri/ 	data.command.disallow_tro  = 0			!no disallowsd 	data.command.handler       = 0l 	data.command.verb_type     = 0p 	data.command.pad           = 0eG 	data.command.name_bro      = %loc(data.names(bpos))-%loc(data.command)4 cb$ 	data.names(bpos) = 6		!total length 	bpos = bpos + 10 	call table__insert_name(data.names,bpos,'DUMM') 	data.command.image_bro     = 0s 	data.command.outputs_bro   = 0b 	data.command.prefix_bro    = 0b c_ c Now insert all parameterso ca5 	istat = table__insert_parameters(data,'#RESTOFLINE',aA      1               ptr_symbol_info,ptr_terminal_info,verb,bpos)e  90	table__set_restofline = istat 	return  	end4 	function table__insert_parameters(data,paramstring,=      1           ptr_symbol_info,ptr_terminal_info,verb,bpos)t 	implicit none c ' c Insert the parameter definitions for a) c  either a @ command (default 8 strings)e; c  or an image with no CLD , default 1 parameter restoflinet cmA c  The user can overrule the types with a symbol 'verb'_parameter  c  	include 'table.inc'& 	record /table_data/ data		!:o: filled9 	character*(*) paramstring		!:i: default parameter string . 	integer*4 ptr_symbol_info			!:i: symbol block2 	integer*4 ptr_terminal_info			!:i: terminal block$ 	character*(*) verb			!:i: verb name7 	integer*4 bpos				!:io: position for names in BRO areai8 	integer*4 table__insert_parameters	!:f: function result ciC 	integer*4 n_arg,n_minarg,ielement,nkres,ipos,imatch,ityp,nk_resulti 	integer*4 istat,nk,kk 	logical*4 seen_max,list,exact! 	character*255 res,typenam,resultl cv 	integer*4 str$element 	logical symbols_match 	integer*4 auto_msg: 	external auto_msg_settypt 	external auto_msg_invtyp) 	external auto_msg_ambtypa cr3 c See if the user defined a symbol 'verb'_parameterp cn>         call symbols_rewind(ptr_symbol_info,ptr_terminal_info)=         if(symbols_match(ptr_symbol_info,verb//'_PARAMETERS', 2      1                   result,nk_result,exact,0,9      1                   ptr_terminal_info,.false.)) then  cfB           call symbols_get_value(ptr_symbol_info,result,nk_result) c  c Make it uppercasef c=B           call str$upcase(result(1:nk_result),result(1:nk_result)) c 6 	  istat = auto_msg(ptr_terminal_info,auto_msg_settyp,-      1                   result(1:nk_result))  	  if(.not. istat) goto 90         else ce) c Take the default value (one restofline)  ci 	  nk_result = len(paramstring)r& 	  call str$upcase(result,paramstring)
         endifl cn c  	seen_max = .false.t 	ielement  = 0 	n_arg     = 0 	n_minarg  = 0 co< 	do while(str$element(res,ielement,',',result(1:nk_result))) cp8 c See if we found a #, if so, this is the first optional
 c  parameter.  ct 	  ipos = index(res,'#') 	  if(ipos .ne. 0) thend 	    seen_max = .true.& 	    res = res(1:ipos-1)//res(ipos+1:) 	  endif 	  ielement = ielement + 1 	  n_arg = ielementt- 	  if(.not. seen_max) n_minarg = n_minarg + 1" cT2 c Now res has a symbol type, see if we can find it ce 	  ipos = index(res,'*') 	  if(ipos .ne. 0) theni c	  c We found an *, this means list ca 	    list = .true.& 	    res = res(1:ipos-1)//res(ipos+1:) 	  elseh 	    list = .false.r 	  endif c: c get the length ci 	  nkres = index(res,' ')-1r ct c Set match to -1 (undefined)c ca 	  imatch = -1+ 	  do ityp=0,entity_block_valtyp_last_entrye. 	    call table_get_type_name(ityp,typenam,nk)% 	    call str$upcase(typenam,typenam))0 	    if(typenam(1:nkres) .eq. res(1:nkres)) then+ 	      if(imatch .ge. 0) goto 41	!ambiguousc c  c Set the type c  	      imatch = ityp
 	    endif	 	  end dor 	  if(imatch .ge. 0) goto 44 ct c No match found coC 	  istat = auto_msg(ptr_terminal_info,auto_msg_invtyp,res(1:nkres),n+      1                  verb//'_PARAMETER')l 	  if(.not. istat) goto 90
 	  goto 42 cn c Ambig type cgE 41	  istat = auto_msg(ptr_terminal_info,auto_msg_ambtyp,res(1:nkres), +      1                  verb//'_PARAMETER')  	  if(.not. istat) goto 90 cn c Take the default ck( 42	  imatch = entity_block_valtyp_string 	  list = .true.	    caF 44	  data.par_entity(n_arg).header.length = sizeof(data.par_entity(1)); 	  data.par_entity(n_arg).header.type   = block_type_entitylH 	  data.par_entity(n_arg).header.subtype= entity_block_subtype_parameter ct c Set the flagsv c_* 	  data.par_entity(n_arg).header.flags  = 6      1            ibset(0,entity_block_flag_val) .or. 1      1            ibset(0,entity_block_flag_parm)_ cb c If list insert the list bite ce3 	  if(list) data.par_entity(n_arg).header.flags  = e<      1             data.par_entity(n_arg).header.flags  .or.3      1            ibset(0,entity_block_flag_list)  ( c $ 	  data.command.header.tro_count = 0 cv! c See if there is another element, c = 	  if(str$element(res,ielement,',',result(1:nk_result))) thene cr+ c There is another one, so link to the next  c ' 	    data.par_entity(n_arg).next_tro =  ?      1                %loc(data.par_entity(n_arg+1))-%loc(data)  	  elseo ci c No more, set link to 0 cc( 	    data.par_entity(n_arg).next_tro = 0 	  endif+ 	  data.par_entity(n_arg).syntax_tro    = 0t+ 	  data.par_entity(n_arg).user_type_tro = 0e, 	  data.par_entity(n_arg).number        = 0	 cr c Insert the typee cfG 	  data.par_entity(n_arg).valtyp        = imatch		!what the user wantedaA 	  data.par_entity(n_arg).name_bro      = %loc(data.names(bpos))-)?      1                                       %loc(data.command)dG 	  call table__insert_name(data.names,bpos,'P'//char(n_arg+ichar('0')))i+ 	  data.par_entity(n_arg).label_bro     = 0u+ 	  data.par_entity(n_arg).prompt_bro    = 0n+ 	  data.par_entity(n_arg).defval_bro    = 0r 	end do. ct c Now set the #arguments6 c Fortan uses signed bytes, and tyhe following integer0 c  may not fit in a (signed) byte, so we use the c  lib$movc3 to move the byte  cc 	k = n_arg*16+n_minarg	)- 	call lib$movc3(1,k,data.command.param_count). cs
 	istat = 1# 90	table__insert_parameters = istatl 	returnn 	end$ 	function table_exit(ptr_table_info) 	implicit none c  c Exit on exit of auto c1 	include 'table.inc' 	integer*4 ptr_table_info( 	integer*4 table_exitn c  	integer*4 istat c, 	integer*4 table_info_closei 	integer*4 lib$free_vm c 1 	record /table_info/ table_info	!:io: table block " 	pointer (p_table_info,table_info) cm c Clear possible open imageu c  	p_table_info = ptr_table_info c ) 	istat = table_info_close(ptr_table_info)( 	if(.not. istat) goto 90 c 3 	istat = lib$free_vm(sizeof(table_info),table_info)m 	if(.not. istat) goto 90 	ptr_table_info = 0  co 90	table_exit = istat  	returnl 	end  * 	function table_info_close(ptr_table_info) 	implicit none c  c Close open image (if opened) ca 	include 'table.inc' 	integer*4 ptr_table_info_ 	integer*4 table_info_close  c  	record /table_info/ table_info " 	pointer (p_table_info,table_info) cd 	integer sys$deltva  	integer sys$dassgn  ci 	integer*4 inadr(2),istat_ c'" c See if there is something mapped c'
 	istat = 1 	p_table_info = ptr_table_info co$ 	if(table_info.retadr(1) .ne.0) then6 	  istat = sys$deltva(table_info.retadr,inadr,%val(0)) 	  if(.not. istat) goto 90	  c 	  table_info.retadr(1) = 0i 	endif ch c See if still channel openg c4% 	if(table_info.chan_imag .ne. 0) theny1 	  istat = sys$dassgn(%val(table_info.chan_imag))e 	  if(.not. istat) goto 90	  c 	  table_info.chan_imag = 0s 	end if  cc c  90	table_info_close = istat  	returno 	end5         function table__user_open_vb(fab)		!,rab,lun)a         implicit nonei         include '($fabdef)'  cc1 c Useropen for crmpsc, we need to set the UFO bitt c  c          record /fabdef/ fabi%         integer*4 table__user_open_vbg ct          integer*4 istat,sys$open         integer*2 channeli 	integer*4 nblocks0         common /channel_message/ nblocks,channel ct c Set the UFO bit  c 4         fab.fab$l_fop = fab.fab$l_fop .or. fab$m_ufo         fab.fab$b_rtv = -1 cx& c open the file, connect is not needed c          istat = sys$open(fab,,)b cy+ c Return channel and #blocks through commonp ce         channel = fab.fab$l_stv) 	nblocks = fab.fab$l_alq#         table__user_open_vb = istat          return         endt 	options /extenr1 	function table__search_item(nword,data,location)  	implicit none c ' c Search verb control blocks in  memoryrA c  the file is mapped starting at address data (nword words long)o cb5 	integer nword		!:i: lengh of data in words(integer*2o( 	integer*2 data(*)	!:i: tghe memory data; 	integer*4 location	!:o: the spot where the table was found + 	logical table__search_item	!:f: the resultk cm 	integer k,istat c  	include 'table.inc'# 	record /vector_block/ vector_block) 	record /verbs/ verbst& 	pointer (p_vector_block,vector_block) 	pointer (p_verbs,verbs) cr c We are looking for a strtureH c  vector_block  integer*2 size     : should be 20 (sizeof vectro_block)1 c                byte type          : should be 1,1 c                byte subtype       : should be 1 / c                integer*2 flags    : any value=1 c                integer*2 tro_count: should be 2aN c                integer*4 verbs_tro: should point to just beyond vector_blockB c                                     (and thus should contain 20)3 c                integer*4 commands_tro : any value / c                integer*4 size     : any value / c  verbs_block   integer*2 size     : any valuei1 c                byte type          : should be 1n2 c                byte subtype       : shgould be 31 c                integer*2 flags    : should be 0.1 c                integer*2 tro_count: should be 0c c 
 	istat = 0 ct
 	do k=1,nwordi- 	  if(data(k) .eq. sizeof(vector_block)) then	# 	    p_vector_block = %loc(data(k)) 3 	    p_verbs = %loc(data(k)) + sizeof(vector_block)a ct@ 	    if(vector_block.header.type    .eq. block_type_vector .and.N      1         vector_block.header.subtype .eq. vector_block_subtype_dcl) then4 	      if(vector_block.header.tro_count .eq. 2) thenB 	        if(vector_block.verbs_tro .eq. sizeof(vector_block)) then? 	          if(verbs.header.type    .eq. block_type_vector .and. N      1               verbs.header.subtype .eq. vector_block_subtype_verb) then/ 	            if(verbs.header.flags .eq. 0 .and. :      1                 verbs.header.tro_count .eq. 0) then( 	               location = %loc(data(k)) 	               istat = 14 	               goto 904 	            endif 	          endif 	        endif 	      endif
 	    endif 	  endif 	end dom 90	table__search_item = istat  	returnm 	end@ 	function table_check_disallow(ptr_terminal_info,ptr_table_info,5      1                                ptr_token_info,r>      1                                ptr_disallow,ptr_entity,2      1                                ptr_command) 	implicit none cd= c Check if the new token is disallowed with the current state  cl 	include 'table.inc' cn 	integer*4 ptr_terminal_info/ 	integer*4 ptr_table_info	!:i: table info blockl> 	integer*4 ptr_token_info  		!:i: poinbter to token info block; 	integer*4 ptr_disallow		!:i: pointer to disallow structureu- 	integer*4 ptr_entity		!:i: pointer to entity 1 	integer*4 ptr_command		!:i: parent command blocka6 	logical table_check_disallow	!:f: false is disallowed c 5 	record /table_info/ table_info	!:i: table info bkockp" 	pointer (p_table_info,table_info) ce 	integer*4 nk_name,nkt 	character*(max_name) name 	character*80 line 	integer*4 istat cd 	logical table__dis  c  	p_table_info = ptr_table_info cp0 	call table_entity_name(ptr_entity,name,nk_name)= 	call sys$fao('Checking disallow ptr = !8XL for !AS',nk,line, 9      1                %val(ptr_disallow),name(1:nk_name))  cpA 	call terminal_debug(ptr_terminal_info,line(1:nk),0,dbg_flag_dis)i 	if(ptr_disallow .ne. 0) thenr cp c Go do the test coH 	  istat = .not. table__dis(table_info,ptr_terminal_info,ptr_token_info,8      1               %val(ptr_disallow),name(1:nk_name),&      1                0,0,ptr_command) 	elsee 	  istat = 1 	end if  	table_check_disallow = istatd 	returnl 	end	  	options /recursive 2 	function table__dis(table_info,ptr_terminal_info,+      1                      ptr_token_info,t?      1                      expression,new_name,operator,level,h(      1                      ptr_command) 	implicit none c. c  Return true if match found% c( 	include 'table.inc'		 c 5 	record /table_info/ table_info	!:i: table info block 5 	integer*4 ptr_terminal_info	!:i: terminal info block $ 	integer*4 ptr_token_info	!:i: token> 	record /expression_block/ expression    !:i: expression block& 	character*(*) new_name		!:i: new name. 	integer*4 operator              !:i: operator4 	integer*4 level                 !:i: level of depth5 	integer*4 ptr_command		!:i: pointer to command blockxE 	logical*4 table__dis		!:f: true if match found (so a disallow found)  c  	integer*4 p_entity' ci  	integer*4 result,res,k,cnt,oper 	logical negated! 	record /expression_block/ expresa 	pointer(p_expres,expres)r 	character*(max_name) name 	integer*4 nk_name 	character*6 oper_name 	character*6 resal 	character*10 leva 	integer*2 nk_leva c  	integer*4 token_lookupg 	integer*4 table__trow ca/ 	call sys$fao('L!UL ',nk_leva,leva,%val(level))iF 	if(expression.header.subtype .eq. expression_block_subtype_path) then cb c operator can ber c    not,any2,and,or,xor,neg cr
 	  cnt = 0/ 	  call table__get_opername(operator,oper_name)b) 	  call terminal_debug(ptr_terminal_info,c%      1              leva(1:nk_leva)//r?      1              'Check names for oper '//oper_name,level+1,a"      1               dbg_flag_dis)% 	  do k=1,expression.header.tro_counte8 	    p_entity = table__tro(table_info,expression.tro(k))2 	    call table_entity_name(p_entity,name,nk_name)7 	    res = token_lookup(ptr_token_info,name(1:nk_name),i3      1                         negated,ptr_command)  	    if(.not. res) thenn- 	      if(name(1:nk_name) .eq. new_name) then  	        res = .true.  	        negated = .false. 	        resa = 'Presnt'7 	      elseif(name(1:nk_name) .eq. 'NO'//new_name) theno 	        res = .true.n 	        negated = .true.  	        resa = 'P(N)' 	      elsec 	        resa = 'Absent' 	      endif	 	    else' 	      resa = 'Presnt'
 	    endif 	    if(k .eq. 1) result = res+ 	    call terminal_debug(ptr_terminal_info,m%      1              leva(1:nk_leva)//_@      1           'Par '//name(1:nk_name)//' res '//resa,level+3,"      1               dbg_flag_dis) c:8 	    if(operator .eq. expression_block_subtype_not) then 	      result = .not. res = 	    elseif(operator .eq. expression_block_subtype_any2) then_ 	      if(res) cnt = cnt + 1 	      if(cnt .gt. 1) goto 50e< 	    elseif(operator .eq. expression_block_subtype_and) then  	      result = result .and. res 	      if(.not. result) goto 50 ; 	    elseif(operator .eq. expression_block_subtype_or) thenn 	      result = result .or. rese 	      if(result) goto 50 < 	    elseif(operator .eq. expression_block_subtype_xor) then- 	      if(k .gt. 1) result = result .xor. resb< 	    elseif(operator .eq. expression_block_subtype_neg) then5 	      result = res .and. negated		!should not happen  	    endif	    '	 	  end doa9 50	  if(operator .eq. expression_block_subtype_any2) thend 	    result = cnt .gt. 1 	  endif 	  resa = 'False'm 	  if(result) resa = 'True' ) 	  call terminal_debug(ptr_terminal_info,.%      1              leva(1:nk_leva)// D      1              'Final name '//oper_name//' res '//resa,level+2,"      1               dbg_flag_dis) 	  table__dis = result 	elsee# 	  oper = expression.header.subtype + 	  call table__get_opername(oper,oper_name)e) 	  call terminal_debug(ptr_terminal_info,_%      1              leva(1:nk_leva)//i8      1              'Check operand '//oper_name,level+1,"      1               dbg_flag_dis)% 	  do k=1,expression.header.tro_countl8 	    p_expres = table__tro(table_info,expression.tro(k))B 	    res = table__dis(table_info,ptr_terminal_info,ptr_token_info,E      1                      expres,new_name,oper,level+1,ptr_Command)i cr 	    resa = 'False'  	    if(res) resa = 'True'+ 	    call terminal_debug(ptr_terminal_info,/%      1              leva(1:nk_leva)//(5      1           'Partial result res '//resa,level+3,t"      1               dbg_flag_dis) 	    cnt = 0 	    if(k .eq. 1) result = res4 	    if(oper .eq. expression_block_subtype_not) then 	      result = resa9 	    elseif(oper .eq. expression_block_subtype_any2) thena 	      if(res) cnt = cnt + 1# 	      if(cnt .gt. 1) goto 70	     n8 	    elseif(oper .eq. expression_block_subtype_and) then  	      result = result .and. res 	      if(.not. result) goto 70 7 	    elseif(oper .eq. expression_block_subtype_or) thenf 	      result = result .or. resa 	      if(result) goto 70f8 	    elseif(oper .eq. expression_block_subtype_xor) then- 	      if(k .gt. 1) result = result .xor. res 9 c	    elseif(oper .eq. expression_block_subtype_neg) then(" c	      result = res .and. negated 	    endif	     	 	  end do  cm5 70	  if(oper .eq. expression_block_subtype_any2) then1 	    result = cnt .gt. 1 	  endif 	  resa = 'False'a 	  if(result) resa = 'True'u) 	  call terminal_debug(ptr_terminal_info, #      1            leva(1:nk_leva)//oC      1           'Final result '//oper_name//' res '//resa,level+2,d"      1               dbg_flag_dis) 	end ifa 	table__dis = result 	returne 	end* 	subroutine table__get_opername(oper,name) 	implicit none ch* c Return the operatorname for the operator c= 	include 'table.inc' 	integer*4 oper  	character*(*) name, ci0 	if(oper .eq. expression_block_subtype_not) then 	  name = 'NOT'y5 	elseif(oper .eq. expression_block_subtype_any2) thene 	  name = 'ANY2'4 	elseif(oper .eq. expression_block_subtype_and) then 	  name = 'AND'y3 	elseif(oper .eq. expression_block_subtype_or) thent 	  name = 'OR'4 	elseif(oper .eq. expression_block_subtype_xor) then 	  name = 'XOR'_4 	elseif(oper .eq. expression_block_subtype_neg) then 	  name = 'NEG') 	endif	    _ 	return  	endB 	function table_check_cqual_init(ptr_table_info,ptr_terminal_info,>      1                                  ptr_command,qual_addr) 	implicit none ctB c Return true if all qualifiers for the cqual-routines are present c  	include 'table.inc' 	integer*4 ptr_table_info  	integer*4 ptr_terminal_info 	integer*4 ptr_command 	integer*4 qual_addr  	logical table_check_cqual_init	 cs 	record /table_info/ table_info)# 	pointer (p_table_info, table_info)s ce 	character*(max_name) qual% 	integer*4 nk_qual,flag,ptr_entity,nki 	logical*4 negated 	character*1 kar ct" 	integer*4 table_list_command_qual cr 	p_table_info = ptr_table_info	 	flag = 0t 	ptr_entity = 0c 	nk = 0tC 	do while(table_list_command_qual(ptr_table_info,ptr_terminal_info,a5      1                                   ptr_command,a@      1                                   kar(1:nk),qual,nk_qual,G      1                                   ptr_entity,negated,qual_addr)))5 	  if(qual(1:nk_qual) .eq. 'BEFORE')  flag = flag + 1t5 	  if(qual(1:nk_qual) .eq. 'SINCE')   flag = flag + 1f5 	  if(qual(1:nk_qual) .eq. 'CREATED') flag = flag + 1e5 	  if(qual(1:nk_qual) .eq. 'MODIFIED')flag = flag + 1s5 	  if(qual(1:nk_qual) .eq. 'EXPIRED') flag = flag + 1m5 	  if(qual(1:nk_qual) .eq. 'BACKUP')  flag = flag + 1  	end dot 	if(flag .eq. 6) thenv 	  kar = 'Y' 	  table_check_cqual_init = 1r 	elsed 	  kar = 'N' 	  table_check_cqual_init = 0_ 	endifF 	call terminal_debug(ptr_terminal_info,'Check for cqual_init = '//kar,       1           0,dbg_flag_tok) 	returnm 	endF 	function table_check_cqual(ptr_table_info,ptr_token_info,ptr_command) 	implicit none cl! c Check if all qualifiers presente c  	include 'table.inc' 	integer*4 ptr_table_info  	integer*4 ptr_token_infof 	integer*4 ptr_command 	logical table_check_cqual c 8 c If any of the expired or created or modified or backup2 c  has been specified, there also must be at least c  a /before or /since present c  	record /table_info/ table_info " 	pointer (p_table_info,table_info) cd 	integer*4 istat 	logical*4 negated 	integer*4 token_lookupl cn 	external auto_msg_nobefsin_ 	external auto_msg_befandsin c  	p_table_info = ptr_table_info cmC 	istat = token_lookup(ptr_token_info,'CREATED',negated,ptr_command)t& 	if(istat .and. .not. negated) goto 50 cyD 	istat = token_lookup(ptr_token_info,'MODIFIED',negated,ptr_command)& 	if(istat .and. .not. negated) goto 50 ctB 	istat = token_lookup(ptr_token_info,'BACKUP',negated,ptr_command)& 	if(istat .and. .not. negated) goto 50 c C 	istat = token_lookup(ptr_token_info,'EXPIRED',negated,ptr_command) & 	if(istat .and. .not. negated) goto 50 ca$ c No specials specified, check is ok cf 	goto 90 ci9 c One of the specials was there, now the must be at leasts c a /since or a /beforen c1C 50	istat = token_lookup(ptr_token_info,'SINCE',negated,ptr_command) & 	if(istat .and. .not. negated) goto 70 ci" c No /since, check for the /before c B 	istat = token_lookup(ptr_token_info,'BEFORE',negated,ptr_command)/ 	if(istat .and. .not. negated) goto 90	!oke nowe cf  c No /sinc and no /before, error cw  	istat = %loc(auto_msg_nobefsin) 	goto 99 c#4 c /sinc is present, /before must not also be present c		.D 70	istat = token_lookup(ptr_token_info,'BEFORE',negated,ptr_command)8 	if(.not. istat .or. .not. negated) goto 90	!all oke now c  c Both present, errorr ct! 	istat = %loc(auto_msg_befandsin)_ 	goto 99 cb
 c Oke exit cc 90	istat = 1 c/ 99	table_check_cqual = istat 	return  	end$ 	subroutine table_override(override) 	implicit none ci# c Get the next override possibility  c  	include 'table.inc'5 	integer*4 override              !io: override numbero cn- c Increase type, and roll around over the topn c  10	override = override + 1> 	if(override .gt. entity_block_valtyp_last_entry) override = 0 ce. c Skip some special formats, they are not used cu< 	if(override .eq. entity_block_valtyp_$test1       ) goto 10< 	if(override .eq. entity_block_valtyp_$test2       ) goto 10< 	if(override .eq. entity_block_valtyp_$test3       ) goto 10 ct 	returnb 	end 	options /exteno3 	subroutine table_get_type_name(ent_type,line,nkar)e 	implicit none ch! c Return the name of the ent_typeh ce 	include 'table.inc'" 	integer*4 ent_type		!:i: the type4 	character*(*) line		!:o: the name of the entry_type) 	integer*4 nkar			!:o: length or the nameo csD 	if(ent_type .eq. entity_block_valtyp_string       ) line = 'string'K 	if(ent_type .eq. entity_block_valtyp_infile       ) line = 'infile       '.K 	if(ent_type .eq. entity_block_valtyp_outfile      ) line = 'outfile      ' K 	if(ent_type .eq. entity_block_valtyp_number       ) line = 'number       'vK 	if(ent_type .eq. entity_block_valtyp_privilege    ) line = 'privilege    'dK 	if(ent_type .eq. entity_block_valtyp_datetime     ) line = 'datetime     '1K 	if(ent_type .eq. entity_block_valtyp_protection   ) line = 'protection   'dK 	if(ent_type .eq. entity_block_valtyp_process      ) line = 'process      ' K 	if(ent_type .eq. entity_block_valtyp_inlog        ) line = 'inlog        'bK 	if(ent_type .eq. entity_block_valtyp_outlog       ) line = 'outlog       'lK 	if(ent_type .eq. entity_block_valtyp_insym        ) line = 'insym        'tK 	if(ent_type .eq. entity_block_valtyp_outsym       ) line = 'outsym       'aK 	if(ent_type .eq. entity_block_valtyp_node         ) line = 'node         'tK 	if(ent_type .eq. entity_block_valtyp_device       ) line = 'device       'oG 	if(ent_type .eq. entity_block_valtyp_directory    ) line = 'directory'.K 	if(ent_type .eq. entity_block_valtyp_uic          ) line = 'uic          '(K 	if(ent_type .eq. entity_block_valtyp_restofline   ) line = 'restofline   'cK 	if(ent_type .eq. entity_block_valtyp_parenvalue   ) line = 'parenvalue   ' G 	if(ent_type .eq. entity_block_valtyp_deltatime    ) line = 'deltatime' G 	if(ent_type .eq. entity_block_valtyp_quotedstr    ) line = 'quotedstr'eK 	if(ent_type .eq. entity_block_valtyp_file         ) line = 'file         'SK 	if(ent_type .eq. entity_block_valtyp_expression   ) line = 'expression   ',L 	if(ent_type .eq. entity_block_valtyp_$test1       ) line = '$test1        'L 	if(ent_type .eq. entity_block_valtyp_$test2       ) line = '$test2        'L 	if(ent_type .eq. entity_block_valtyp_$test3       ) line = '$test3        'K 	if(ent_type .eq. entity_block_valtyp_acl          ) line = 'acl          'eF 	if(ent_type .eq. entity_block_valtyp_old_file     ) line = 'old_file' ct 	nkar = index(Line,' ')-1 ! 	if(nkar .lt. 0) nkar = len(line)c 	returnl 	end c < 	function table_check_override(all_over,ptr_entity,override) 	implicit none c  c See if override is possibleo	 c  either  c  1: type=string or restofline . c  2: user specified /override on command line cl 	include 'table.inc'0 	logical*4 all_over		!:i: override for all types0 	integer*4 ptr_entity  		!:i: ptr to entry block' 	integer*4 override		!:o: override flag E 	logical*4 table_check_override	!;:f: return true if override allowedl ca c_ 	record /entity_block/ entityU 	pointer (p_entity,entity)	e cr 	p_entity = ptr_entity ct4 c User defined types (ent_user<>0 canot be overruled. c  string type and restofline can be overruledL c  if user specified /override on command lines, all types (execpt user_def) c   can be overruled cb% 	if(entity.user_type_tro .eq. 0 .and. @      1     ((entity.valtyp .eq. entity_block_valtyp_string) .or.D      1      (entity.valtyp .eq. entity_block_valtyp_restofline) .or.      1       all_over)) then c  c Set override type to 0 c ! 	  override = 0  !enable override  	else " 	  override = -1	!disable override 	endif' 	table_check_override = override .ge. 0o 	returnx 	end  x. 	function table_toggle_verbone(ptr_table_info) 	implicit none cf4 c Toggle state of verbone key, and return the status ce 	include 'table.inc'/ 	integer*4 ptr_table_info		!:i: table structureuC 	integer*4 table_toggle_verbone          !:f: return verbone status4 cb cc5 	record /table_info/ table_info		!:i: table structurei" 	pointer (p_table_info,table_info) c  	p_table_info = ptr_table_info c	. 	table_info.verbone = .not. table_info.verbone c)* 	table_toggle_verbone = table_info.verbone 	returnl 	end1 	function table_entity_valreq(ptr_entity,negated)n 	implicit none c * c Return TRUE if entity has value required cb 	include 'table.inc' 	integer*4 ptr_entityi 	logical*4 negated 	logical*4 table_entity_valreq cg 	record /entity_block/ entityn 	pointer (p_entity,entity) 	logical*4 statusi cv c Return the ent_flag 0 c If the match was negated, clear the value flag ce 	if(negated) thene 	  status = .false.f 	else  	  p_entity = ptr_entity? 	  status = btest(entity.header.flags,entity_block_flag_valreq)i 	endif 	table_entity_valreq = statusf 	returne 	end0 	function table_entity_value(ptr_entity,negated) 	implicit none ce" c Return TRUE if entity has value  cx 	include 'table.inc' 	integer*4 ptr_entity  	logical*4 negated 	logical*4 table_entity_valuet c( 	record /entity_block/ entity  	pointer (p_entity,entity) cl 	logical*4 status: cs c Return the ent_flags0 c If the match was negated, clear the value flag cn 	if(negated) theny 	  status = .false.i 	else4 	  p_entity = ptr_entity< 	  status = btest(entity.header.flags,entity_block_flag_val) 	endif 	table_entity_value = status 	returnl 	end/ 	function table_entity_list(ptr_entity,negated)_ 	implicit none cn! c Return TRUE if entity has list x cc 	include 'table.inc' 	integer*4 ptr_entityc 	logical*4 negated 	logical*4 table_entity_list ct 	record /entity_block/ entityd 	pointer (p_entity,entity) c  	logical*4 statuse c  c Return the ent_flagi0 c If the match was negated, clear the value flag c' 	if(negated) thene 	  status = .false.r 	elsec 	  p_entity = ptr_entity= 	  status = btest(entity.header.flags,entity_block_flag_list)  	endif 	table_entity_list = statusg 	returne 	end' 	function table_entity_type(ptr_entity)  	implicit none ce c Return the entity type cm 	include 'table.inc' 	integer*4 ptr_entityt 	logical*4 table_entity_type ce 	record /entity_block/ entity  	pointer (p_entity,entity) ct c Return the ent_typen c  	p_entity = ptr_entity" 	table_entity_type = entity.valtyp 	return, 	end; 	function table_entity_user_type(ptr_table_info,ptr_entity)  	implicit none c_% c Return the pointer to the user typev ch 	include 'table.inc'5 	integer*4 ptr_table_info		!:i: pointer to info block . 	integer*4 ptr_entity			!:i: pointer to entity? 	logical*4 table_entity_user_type	!:f: pointer to usertype or 0i c. 	record /table_info/ table_info," 	pointer (p_table_info,table_info) ch 	record /entity_block/ entity  	pointer (p_entity,entity) c  	record /type_block/ type_blockt" 	pointer (p_type_block,type_block) ct  	integer*4 ent_user,p_type_block cg 	integer*4 table__tro= ca c Return the ent_typee cf 	p_table_info = ptr_table_info 	p_entity = ptr_entity ce; 	p_type_block = table__tro(table_info,entity.user_type_tro)h c  	if(p_type_block .eq. 0) then  	  ent_user = 0t 	elseO; 	  ent_user = table__tro(table_info,type_block.keyword_tro)  	endif" 	table_entity_user_type = ent_user 	return  	end8 	function table_entity_syntax(ptr_table_info,ptr_entity) 	implicit none cr4 c Return the pointer to the (possible) syntax change ca 	include 'table.inc'6 	integer*4 ptr_table_info		!:i: pointer to table block4 	integer*4 ptr_entity			!:i: pointer to entity block= 	logical*4 table_entity_syntax		!:f: pointer to syntax changet c  	record /table_info/ table_infof" 	pointer (p_table_info,table_info) ci 	record /entity_block/ entity  	pointer (p_entity,entity) cn 	integer*4 table__tros c) c Return the ent_typet ci 	p_table_info = ptr_table_info 	p_entity = ptr_entity c ? 	table_entity_syntax = table__tro(table_info,entity.syntax_tro)p 	return= 	end