## descrip.mms ends here#
# Maintainence productions for the Lisp directory
#
SOURCES = $(srcdir_dev)[$(srcdir_dir)]*.el, -
	$(srcdir_dev)[$(srcdir_dir)]COPYING, -
	$(srcdir_dev)[$(srcdir_dir)]descrip.mms
lisptagsfiles = $(srcdir_dev)[$(srcdir_dir)]*.el, -
	$(srcdir_dev)[$(srcdir_dir).term]*.el

unlock :
	set file/prot=(o:rwed) $(SOURCES)
	! chmod u+w $(SOURCES)

relock :
	set file/prot=(o:re) $(SOURCES)
	set file/prot=(o:rwed) version.el, finder-inf.el, loaddefs.el
	! chmod -w $(SOURCES)
	! chmod +w version.el finder-inf.el loaddefs.el

TAGS : $(lisptagsfiles)
	mcr sys$disk:[-.lib-src]etags $(lisptagsfiles)
	! ../lib-src/etags $(lisptagsfiles)

## begin ttn hack

ttn-clean-elc :
	delete *.elc.*
	delete [.calendar]*.elc.*
	delete [.emacs-lisp]*.elc.*
	delete [.emulation]*.elc.*
	delete [.eshell]*.elc.*
	delete [.gnus]*.elc.*
	delete [.international]*.elc.*
	delete [.language]*.elc.*
	delete [.mail]*.elc.*
	delete [.net]*.elc.*
	delete [.obsolete]*.elc.*
	delete [.play]*.elc.*
	delete [.progmodes]*.elc.*
	delete [.term]*.elc.*
	delete [.textmodes]*.elc.*
	delete [.toolbar]*.elc.*

wins.mms-elisp :
	open/write out $@
	write out "(setq WINS (list"
	write out "  default-directory"
	write out "  ""[.net]"""
	write out "  ""[.toolbar]"""
	write out "  ""[.textmodes]"""
	write out "  ""[.term]"""
	write out "  ""[.progmodes]"""
	write out "  ""[.play]"""
	write out "  ""[.obsolete]"""
	write out "  ""[.language]"""
	write out "  ""[.international]"""
	write out "  ""[.eshell]"""
	write out "  ""[.emulation]"""
	write out "  ""[.emacs-lisp]"""
	write out "  ""[.calendar]"""
	write out "  ""[.mail]"""
	write out "  ""[.gnus]"""
	write out "))"
	close out

BUILDSRCDIR =
bemacsfrag = $(BUILDSRCDIR)bootstrap-emacs
bemacs = mcr $(bemacsfrag) "-map" $(bemacsfrag).dump

loaddefs.el :
	open/write out loaddefs.el
	write out ";;; loaddefs.el --- automatically extracted autoloads"
	write out ";;"
	write out ";;; Code:"
	write out ""
	write out ";;; Local Variables:"
	write out ";;; version-control: never"
	write out ";;; no-byte-compile: t"
	write out ";;; no-update-autoloads: t"
	write out ";;; End:"
	write out ";;; loaddefs.el ends here"
	close out

autoloads.FRC :
	@ !

autoloads : loaddefs.el wins.mms-elisp autoloads.FRC
	@ write sys$output "::: Making $@ in ",f$environment("DEFAULT")
	open/write out autoloads.mms-elisp
	write out "(load ""autoload"")"
	write out "(setq generated-autoload-file """,-
		f$environment("DEFAULT"),-
		"loaddefs.el"")"
	write out "(apply (quote update-autoloads-from-directories) WINS)"
	close out
	$(bemacs) -batch -l wins.mms-elisp -l autoloads.mms-elisp
	delete autoloads.mms-elisp.*

compile-files.FRC :
	@ !

compile-files : compile-files.FRC
	@ write sys$output "::: Making $@ in ",f$environment("DEFAULT")
	$(bemacs) -batch -l compile-files.mms-elisp -
		vms-compile-files.com -
		$(bemacsfrag)
	directory/size/date/width=(filename=25) vms-compile-files.com
	@[]vms-compile-files.com
	delete vms-compile-files.com.*

custom-deps.FRC :
	@ !

custom-deps : wins.mms-elisp cus-load.el custom-deps.FRC
	@ write sys$output "::: Making $@ in ",f$environment("DEFAULT")
	open/write out custom-deps.mms-elisp
	write out "(setq command-line-args-left WINS)"
	write out "(custom-make-dependencies)"
	close out
	$(bemacs) -batch -l wins.mms-elisp -l cus-dep -l custom-deps.mms-elisp
	delete custom-deps.mms-elisp.*

NOT-YET-WORKING-bootstrap : autoloads compile-files custom-deps
	@ !

bootstrap :
	@ write sys$output "skipping $@ in ",f$environment("DEFAULT"),-
				" -- not yet working (bummer)"

## end ttn hack
