 #ifdef VAXC   #module RUNUSR "BOL-V1.0/AUG-96" #else ' #pragma module RUNUSR "BOL-V1.0/AUG-96"  #endif  . #ifdef __DECC			/* Not available in VAXCDEF */: #include cli$routines		/* CLI$xxx() routine definitions */ #endif/ #include climsgdef		/* CLI$_xxx status codes */ . #include descrip		/* Descriptor definitions */: #include lib$routines		/* LIB$xxx() routine definitions */6 #include libclidef		/* LIB$xxx CLI-specific symbols */- #include libdef			/* LIB$_xxx status codes */ + #include jpidef			/* JPI$_xxx item codes */ , #include pqldef			/* PQL$_xxx quota codes */6 #include prcdef			.* PRC$M_xxx create process flags */: #include prvdef			/* PRV$_xxx privilege bit definitions */- #include rmsdef			/* RMS$_xxx status codes */ + #include ssdef			/* SS$_xxx status codes */ < #include starlet		/* SYS$xxx() system service definitions */- #include stdio			/* standard I/O functions */ ; #include string			/* strxxx() string routine definitions */   E #define NOMSG	0x10000000;	/* DCL shouldn't print the error message */   ( /* Define literals for message codes. */  ! #define RUN$_PARSEFAIL 0x00C0124C ! #define RUN$_INVQUAVAL 0x00C0132C   9 /* Define privilege bit values (not define in STARLET) */    #define PRV$M_UPGRADE	0x01 #define PRV$M_DOWNGRADE 0x02 #define PRV$M_GRPPRV    0x04 #define PRV$M_READALL   0x08 #define PRV$M_IMPORT    0x10 #define PRV$M_AUDIT     0x20 #define PRV$M_SECURITY  0x40  2 /* If VMS_V7 is defined, define VMS_V6 as well. */  
 #ifdef VMS_V7  #define VMS_V6 1 #endif   int globalvalue   1 RUN$_PROC_ID,RUN$_SCHDWK,RUN$_CREPRC,RUN$_GETJPI, $ RUN$_CVTERR,RUN$_INVUIC,RUN$_ILLVAL;   extern int _setnam();   0 /* Define item list structure for SYS$GETJPI. */  
 struct itmlst  { '  short size;            /* Item size */ '  short code;            /* Item code */ .  int*  info;            /* Item information */5  void* len;             /* Item length (or unused) */  };  " /* Define quota list structure. */  : #ifdef __DECC		/* Ensure that no alignment occurs here. */ #pragma nomember_alignment #endif  
 struct quolst  {   char code;		/* Quota code; */  int  val;		/* Value */ 2 } RUN_QUOTA[16],	/* 16 entries should be enough */+ *RUN_QUOLIST;		/* Pointer to quota list. */   ' #ifdef __DECC		/* Restore alignment. */  #pragma member_alignment #endif   /* Local routines. */    void/ get_prcinf(),		/* Get info about our process */ 2 get_cmdlin(),		/* Get parameters and qualifiers */1  get_imgnam(),		/* Obtain and parse image name */ &  get_string(),		/* Get string value */3  chk_flg(),		/* Check for process creation flags */ ,  get_usrnam(),		/* Get and check username */.  get_uic(),		/* Get and validate UIC string */&  get_value(),		/* Get numeric value */(  get_quotas(),		/* Get process quotas */#  get_privs(),		/* Get privileges */ ;  get_times(),		/* Get schedule, delay and interval times */ # creprc();		/* Create the process */   0 int get_prvval();	/* Get privilege mask value */   /* Global data. */   char# OUR_USRNAM[16],		/* Our username */ ) RUN_USRNAM[16],		/* Specified username */ - RUN_PRCNAM[16],		/* Specified process name */   RUN_INPUT[256],		/* SYS$INPUT */! RUN_OUTPUT[256],	/* SYS$OUTPUT */   RUN_ERROR[256],		/* SYS$ERROR */+ RUN_IMAGE[256],		/* Specified image name */ 8 RUN_NODNAM[6],		/* Node name (VMS V7 and higher only) */+ FUL_IMAGE[256];		/* Resultant image name */    int  RUN_PID,		/* Returned PID */ RUN_UIC,		/* Specified UIC */ ' RUN_PRIORITY,		/* Specified priority */ / RUN_MBXUNIT,		/* Termination maibox unit no. */ 6 RUN_PRIVS[2],		/* Specified or inherited privileges */# OUR_PRIVS[2],		/* Our privileges */  RUN_FLAGS,		/* Flags */ 5 RUN_TIME[2],		/* Wakeup time (/DELAY or /SCHEDULE) */ 2 RUN_INTERVAL[2];	/* Wakeup interval (/INTERVAL) */  	 /******/   
 int main() { 0  char pid_buf[10];				/* Buffer for ASCII PID */  4  $DESCRIPTOR(run_pid,"$RUN_PID");		/* Symbol name */!  $DESCRIPTOR(dcl_ide,"IDENTIFY");   ;  $DESCRIPTOR(pid,pid_buf);			/* Descriptor for ASCII PID */   "  /* Obtain process information. */    get_prcinf();   4  /* Obtain image name and all command qualifiers. */    get_cmdlin();    /* Now create new process. */  
  creprc();  "  /* Unless disabled, print PID. */  +  if (cli$present(&dcl_ide) != CLI$_NEGATED)   $  lib$signal(RUN$_PROC_ID,1,RUN_PID);  $  /* Place PID in symbol $RUN_PID. */  !  sprintf(pid_buf,"%08X",RUN_PID);     pid.dsc$w_length = 8;  5  lib$set_symbol(&run_pid,&pid,&LIB$K_CLI_GLOBAL_SYM);     /* Well, all done. */    return SS$_NORMAL;  }   	 /******/    void get_prcinf()  { 7  /* This routine obtains information about our process. ,     We'll require this information later. */  0  short iosb[4];				/* GETJPI I/O status block */  $  int status;				/* Return status; */  6  struct itmlst itm[5] = 		/* Item list for SYS$JPI: */  {  :   4, JPI$_PRIB,    &RUN_PRIORITY,0,	/* Default priority */9   8, JPI$_PROCPRIV,RUN_PRIVS,0,		/* Process privileges */ <   8, JPI$_PROCPRIV,OUR_PRIVS,0,		/* Copy for later checks */6   16,JPI$_USERNAME,(int*) OUR_USRNAM,0,	/* Username */   0,0   };					/* End of list */   2  /* Call SYS$GETJPI to obtain this information. */  >  if ((status = sys$getjpiw(0,0,0,itm,iosb,0,0)) != SS$_NORMAL)  "  lib$signal(RUN$_GETJPI,0,status);  %  /* Error in IOSB? Signal as well. */   >  if (iosb[0] != SS$_NORMAL) lib$signal(RUN$_GETJPI,0,iosb[0]);  >  /* The username is returned as blank-filled string. Shrink it     to its actual length. */  ,  OUR_USRNAM[strcspn(OUR_USRNAM," ")] = '\0';    /* OK, thats all. */  }   	 /******/    void get_cmdlin()  { 5  /* This routine obtains all information specified in @     the command line: the image parameter and all qualifiers. */  +  int status;				/* CLI$xxx return status */     /* Command qualifier names: */     $DESCRIPTOR(dcl_inp,"INPUT");  $DESCRIPTOR(dcl_out,"OUTPUT");   $DESCRIPTOR(dcl_err,"ERROR");%  $DESCRIPTOR(dcl_nam,"PROCESS_NAME"); !  $DESCRIPTOR(dcl_pri,"PRIORITY");    $DESCRIPTOR(dcl_mbx,"MAILBOX");  #  $DESCRIPTOR(dcl_acc,"ACCOUNTING"); "  $DESCRIPTOR(dcl_aut,"AUTHORIZE");!  $DESCRIPTOR(dcl_det,"DETACHED");   $DESCRIPTOR(dcl_dmp,"DUMP"); &  $DESCRIPTOR(dcl_res,"RESOURCE_WAIT");(  $DESCRIPTOR(dcl_fai,"SERVICE_FAILURE");!  $DESCRIPTOR(dcl_swp,"SWAPPING");   9 #ifdef VMS_V6		/* Available in VMS V6 and higher only: */    $DESCRIPTOR(dcl_tcb,"TRUSTED");9 #ifdef VMS_V7		/* Available in VMS V7 and higher only: */   $DESCRIPTOR(dcl_nod,"ON");  #endif #endif  B  /* First, get and parse the image name ('filename' parameter). */    get_imgnam();  #  /* Next, get all string values. */   2  get_string(&dcl_inp,RUN_INPUT,255);		/* /INPUT */  4  get_string(&dcl_out,RUN_OUTPUT,255);		/* /OUTPUT */  2  get_string(&dcl_err,RUN_ERROR,255);		/* /ERROR */  9  get_string(&dcl_nam,RUN_PRCNAM,15);		/* /PROCESS_NAME */   
 #ifdef VMS_V7 .  get_string(&dcl_nod,RUN_NODNAM,6);		/* /ON */ #endif    /* Get SYS$CREPRC flags. */  7  chk_flg(&dcl_acc,PRC$M_NOACNT,1);		/* /NOACCOUNTING */   5  chk_flg(&dcl_aut,PRC$M_NOUAF,1);		/* /NOAUTHORIZE */   3  chk_flg(&dcl_det,PRC$M_DETACH,0);		/* /DETACHED */   /  chk_flg(&dcl_dmp,PRC$M_IMGDMP,0);		/* /DUMP */   ;  chk_flg(&dcl_res,PRC$M_SSRWAIT,1);		/* /NORESOURCE_WAIT */   ;  chk_flg(&dcl_fai,PRC$M_SSFEXCU,0);		/* /SERVICE_FAILURE */   5  chk_flg(&dcl_swp,PRC$M_PSWAPM,1);		/* /NOSWAPPING */   
 #ifdef VMS_V6 0  chk_flg(&dcl_tcb,PRC$M_TCB,0);			/* /TRUSTED */ #endif  +  /* Get and validate specified username. */   "  get_usrnam();					/* /USERNAME */  &  /* Get and validate specified UIC. */    get_uic();					/* /UIC */     /* Get specified priority. */  4  get_value(&dcl_pri,&RUN_PRIORITY);		/* /PRIORITY */  +  /* And termination mailbox unit number. */   2  get_value(&dcl_mbx,&RUN_MBXUNIT);		/* /MAILBOX */    /* Get quotas. */    get_quotas();  +  /* Get privileges. */				/* /PRIVILEGES */   
  get_privs();   :  /* Get time values */				/* /DELAY,/INTERVAL,/SCHEDULE */  
  get_times();     /* That's all! */ }   	 /******/    void get_imgnam()  { @  /* This routine obtains and parses the specified image name. */    short  retlen;			/* Return length */    int  status,			/* Return status */"  secstat,			/* Secondary status */+  ctx = 0;			/* Context for LIB$FIND_FILE */   0  $DESCRIPTOR(dcl_img,"P1");	/* Parameter name */4  $DESCRIPTOR(defnam,".EXE");	/* Default file type */;  $DESCRIPTOR(resnam, FUL_IMAGE); /* Resultant image name */   2  $DESCRIPTOR(aux," ");		/* Auxiliary descriptor */    aux.dsc$w_length = 255;    aux.dsc$a_pointer = RUN_IMAGE;   &  cli$get_value(&dcl_img,&aux,&retlen);    RUN_IMAGE[retlen] = '\0';    aux.dsc$w_length = retlen;   :  /* Parse the image name (".EXE" is default file type). */  A  status = lib$find_file(&aux,&resnam,&ctx,&defnam,0,&secstat,&1);   M  if (status != RMS$_NORMAL) lib$signal(RUN$_PARSEFAIL,1,&aux,status,secstat);   *  FUL_IMAGE[strcspn(FUL_IMAGE," ")] = '\0';  D  /* LIB$FIND_FILE returns the full file specification, including theC     version number. However, if the user hasn't specified a version E     number, we must remove it from the full file spec as well. Other- D     wise, even images installed shareable and/or with elevated privs<     would be activated without privs and process-private. */  =  if (!strchr(RUN_IMAGE,';')) *(strchr(FUL_IMAGE,';')) = '\0';     /* That's all. */ }   	 /******/   G void get_string(struct dsc$descriptor_s *ptr, char *retbuf, int maxlen)  { F  /* This routine obtains the CLI item whose name is specified in 'ptr'F     and returns the approbiate string in 'retbuf'. 'maxlen' determines$     the maximum size of 'retbuf'. */    short retlen = 0;    $DESCRIPTOR(aux,retbuf);   &  if (cli$present(ptr) == CLI$_PRESENT)  {   aux.dsc$w_length = maxlen;  "   cli$get_value(ptr,&aux,&retlen);  }  retbuf[retlen] = '\0';  }   	 /******/   C void chk_flg(struct dsc$descriptor_s *ptr, int bitval, int negated)  { F  /* This routine checks whether the specified CLI item (name in 'ptr')H     is present or negated in the command line. It sets the bit specifiedB     in 'bitval' if the item is present ('negated' = 0) or if it is*     explicitly negated ('negated' = 1). */    int status = cli$present(ptr);   =  if (status == CLI$_PRESENT && !negated) RUN_FLAGS |= bitval;   <  if (status != CLI$_PRESENT && negated) RUN_FLAGS |= bitval; }   	 /******/    void get_usrnam()  { )  /* Obtains username and validates it. */   $  int grp;					/* To save group ID */  8  $DESCRIPTOR(dcl_usr,"USER");			/* DCL qualifier name */  4  $DESCRIPTOR(aux,RUN_USRNAM);			/* Aux descriptor */  5  get_string(&dcl_usr,RUN_USRNAM,16);		/* Get value */   6  if (!RUN_USRNAM[0]) return;			/* Return if no name */  =  aux.dsc$w_length = strlen(RUN_USRNAM); 	/* Set descriptor */   C  /* If the specified name is longer than 12 chars, return error. */   G  if (aux.dsc$w_length > 12) lib$signal(RUN$_INVQUAVAL,2,&aux,&dcl_usr);   B  /* In addition, if /AUTHORIZE is specified, ensure that the givenA     username exists in the UAF, obtains its UIC and provide it as      default. */      if (!(RUN_FLAGS & PRC$M_NOUAF))  {2   if (sys$asctoid(&aux,&RUN_UIC,0) != SS$_NORMAL)   -   lib$signal(RUN$_INVQUAVAL,2,&aux,&dcl_usr);   7   /* Ensure that the obtained UIC is in valid range. */      grp = RUN_UIC >> 16;  4   if ((RUN_UIC & 0177777) > 0177776 || grp > 037776)  -   lib$signal(RUN$_INVQUAVAL,2,&aux,&dcl_usr);   };  /* Keep in mind that we must create a detached process. */     RUN_FLAGS |= PRC$M_DETACH;  }   	 /******/    void get_uic() { 6  /* Obtains UIC string and checks for valid syntax. */    char   *ptr,					/* Aux pointer */+  aux_buf[44];				/* Buffer receiving UIC */     int grp;				/* Group value */  6  $DESCRIPTOR(dcl_uic,"UIC");		/* DCL qualifier name */  1  $DESCRIPTOR(aux,aux_buf);		/* Aux. descriptor */   5  get_string(&dcl_uic,aux_buf,44);	/* Get UIC value */   <  aux.dsc$w_length = strlen(aux_buf);	/* Update descriptor */  *  if (aux_buf[0])			/* UIC was specified */  {K   if (aux_buf[0] == '[' || aux_buf[0] == '<')	/* Starts with '[' or '<'? */    { H    if (aux_buf[1] >= '0' && aux_buf[1] <= '7')	/* Octal UIC was given */    {=     /* If not syntax [grp,mem] or <grp_mem>, return error. */        if (aux_buf[0] == '[')     { F      if (sscanf(aux_buf,"[%o,%o]",(short*) &grp,(int*) &RUN_UIC) != 2)  $      lib$signal(RUN$_INVUIC,1,&aux);     }      else     { F      if (sscanf(aux_buf,"<%o,%o>",(short*) &grp,(int*) &RUN_UIC) != 2)  $      lib$signal(RUN$_INVUIC,1,&aux);     } B     /* If grp and member values are out of range, return error. */  J     if (grp > 037776 || RUN_UIC > 0177776) lib$signal(RUN$_INVUIC,1,&aux);  4     RUN_UIC += grp*65536;			/* Compute actual UIC */        return;					/* and return */    }B    /* UIC starts with '[', but contains an identifier name. Update       descriptor. */      aux.dsc$a_pointer++;       aux.dsc$w_length -= 2;    } M   /* Translate identifier name to binary value. If it fails, return error. */   Q   if (sys$asctoid(&aux,&RUN_UIC,0) != SS$_NORMAL) lib$signal(RUN$_INVUIC,1,&aux);   }  /* Well, that's all. */ }   	 /******/   9 void get_value(struct dsc$descriptor_s *ptr, int *retval)  { @  /* This routine obtains the CLI item whose name is specified inA     'ptr', converts it to an integer value and returns this value      to retval. */   $  char auxbuf[16];		/* Aux. buffer */  $  short retlen;			/* Return length */    $DESCRIPTOR(aux,auxbuf);   &  if (cli$present(ptr) == CLI$_PRESENT)  {"   cli$get_value(ptr,&aux,&retlen);     auxbuf[retlen] = '\0';     aux.dsc$w_length = retlen;  &   if (sscanf(auxbuf,"%d",retval) != 1)  2   lib$signal(RUN$_CVTERR,2,ptr,&aux,LIB$_INVNBDS);  } }   	 /******/    void get_quotas()  { =  /* This routine obtains all quotas from the command line and C     fills in the quota list which is later passed to SYS$CREPRC. */   *  char cputimbuf[16];			/* ASCII cputime */    int$  bintim[2],				/* Binary CPU time */.  cnt = 0;				/* Contains curr. quota item # */  D  $DESCRIPTOR(cputim,cputimbuf);		/* Descriptor to ASCII CPU time; */  "  $DESCRIPTOR(dcl_ast,"AST_LIMIT");%  $DESCRIPTOR(dcl_buf,"BUFFER_LIMIT"); &  $DESCRIPTOR(dcl_equ,"ENQUEUE_LIMIT");  $DESCRIPTOR(dcl_ext,"EXTENT"); #  $DESCRIPTOR(dcl_fil,"FILE_LIMIT"); $  $DESCRIPTOR(dcl_iob,"IO_BUFFERED");"  $DESCRIPTOR(dcl_iod,"IO_DIRECT");(  $DESCRIPTOR(dcl_job,"JOB_TABLE_QUOTA");,  $DESCRIPTOR(dcl_wsm,"MAXIMUM_WORKING_SET");"  $DESCRIPTOR(dcl_pag,"PAGE_FILE");$  $DESCRIPTOR(dcl_que,"QUEUE_LIMIT");)  $DESCRIPTOR(dcl_sub,"SUBPROCESS_LIMIT"); #  $DESCRIPTOR(dcl_tim,"TIME_LIMIT"); $  $DESCRIPTOR(dcl_wrk,"WORKING_SET");  ?  /* Get all quotas. If a quota was specified, obtains its value 6     and place it in the next free quota list entry. */  ;  if (cli$present(&dcl_ast) == CLI$_PRESENT)	/* AST limit */   {#   RUN_QUOTA[cnt].code = PQL$_ASTLM;   ,   get_value(&dcl_ast,&RUN_QUOTA[cnt++].val);  }E  if (cli$present(&dcl_buf) == CLI$_PRESENT)	/* Buffer (Byte) Limit */   {#   RUN_QUOTA[cnt].code = PQL$_BYTLM;   ,   get_value(&dcl_buf,&RUN_QUOTA[cnt++].val);  }F  if (cli$present(&dcl_equ) == CLI$_PRESENT)	/* Enqueue (lock) limit */  {#   RUN_QUOTA[cnt].code = PQL$_ENQLM;   ,   get_value(&dcl_equ,&RUN_QUOTA[cnt++].val);  }C  if (cli$present(&dcl_ext) == CLI$_PRESENT)	/* Working set limit */   {&   RUN_QUOTA[cnt].code = PQL$_WSEXTENT;  ,   get_value(&dcl_ext,&RUN_QUOTA[cnt++].val);  }A  if (cli$present(&dcl_fil) == CLI$_PRESENT)	/* Open file limit */   {#   RUN_QUOTA[cnt].code = PQL$_FILLM;   ,   get_value(&dcl_fil,&RUN_QUOTA[cnt++].val);  }D  if (cli$present(&dcl_iob) == CLI$_PRESENT)	/* Buffered I/O limit */  {#   RUN_QUOTA[cnt].code = PQL$_BIOLM;   ,   get_value(&dcl_iob,&RUN_QUOTA[cnt++].val);  }B  if (cli$present(&dcl_iod) == CLI$_PRESENT)	/* Direct I/O limit */  {#   RUN_QUOTA[cnt].code = PQL$_DIOLM;   ,   get_value(&dcl_iod,&RUN_QUOTA[cnt++].val);  }K  if (cli$present(&dcl_job) == CLI$_PRESENT)	/* Job log. name table quota */   {%   RUN_QUOTA[cnt].code = PQL$_JTQUOTA;   ,   get_value(&dcl_job,&RUN_QUOTA[cnt++].val);  }C  if (cli$present(&dcl_wsm) == CLI$_PRESENT)	/* Working set quota */   {%   RUN_QUOTA[cnt].code = PQL$_WSQUOTA;   ,   get_value(&dcl_wsm,&RUN_QUOTA[cnt++].val);  }A  if (cli$present(&dcl_pag) == CLI$_PRESENT)	/* Page file quota */   {'   RUN_QUOTA[cnt].code = PQL$_PGFLQUOTA;   ,   get_value(&dcl_pag,&RUN_QUOTA[cnt++].val);  }C  if (cli$present(&dcl_que) == CLI$_PRESENT)	/* Timer queue limit *//  {#   RUN_QUOTA[cnt].code = PQL$_TQELM;t  ,   get_value(&dcl_que,&RUN_QUOTA[cnt++].val);  }B  if (cli$present(&dcl_sub) == CLI$_PRESENT)	/* Subprocess limit */  {#   RUN_QUOTA[cnt].code = PQL$_PRCLM;	  ,   get_value(&dcl_sub,&RUN_QUOTA[cnt++].val);  }E  if (cli$present(&dcl_wrk) == CLI$_PRESENT)	/* Working set default */I  {'   RUN_QUOTA[cnt].code = PQL$_WSDEFAULT;B  ,   get_value(&dcl_wrk,&RUN_QUOTA[cnt++].val);  }?  /* CPU time quota. On the DCL command line, it is given as VMSi@     delta time, however, in the quota list, it must be specified     in units of 10 ms. */   >  if (cli$present(&dcl_tim) == CLI$_PRESENT)	/* If specified */  {:   get_string(&dcl_tim,cputimbuf,14);		/* Get the string */  I   cputim.dsc$w_length = strlen(cputimbuf);	/* Update descriptor length */O  J   if (sys$bintim(&cputim,bintim) != SS$_NORMAL)	/* Convert it to binary */  <   lib$signal(RUN$_ILLVAL,1,&cputim);		/* If error, signal */  H   if (lib$ediv(&-200000,&bintim[0],&bintim[0],&bintim[1]) != SS$_NORMAL)  <   lib$signal(RUN$_ILLVAL,1,&cputim);		/* If error, signal */  #   RUN_QUOTA[cnt].code = PQL$_CPULM;R  3   RUN_QUOTA[cnt++].val = bintim[0] * 2 + bintim[1];O  }   /* Mark the end of the list. */  $  RUN_QUOTA[cnt].code = PQL$_LISTEND;  ?  /* If at least one quota was specified, set the pointer to the$     quota list. */  "  if (cnt) RUN_QUOLIST = RUN_QUOTA;    /* That's all. */ }S  	 /******/    void get_privs() { F  /* This routine processes the privilege list given in the /PRIVILEGESC     qualifier and sets the RUN_PRIVS privilege mask accordingly. */n  "  char *ptr,					/* Aux. pointer */.  aux_buf[12];					/* Receives priv keywords */    short   retlen;					/* Return length */    int  msk,						/* Mask number */"  value,						/* Privilege value */   status;					/* Return status */  #  $DESCRIPTOR(dcl_prv,"PRIVILEGES");t(  $DESCRIPTOR(dcl_sam,"PRIVILEGES.SAME");3  $DESCRIPTOR(aux, aux_buf);			/* Aux. descriptor */a  F  /* First, check for /PRIVILEGES=NOSAME. If this is specified, we must=     clear the privilege mask (NOSAME means no privileges). */e  L  if (cli$present(&dcl_sam) == CLI$_NEGATED) RUN_PRIVS[0] = RUN_PRIVS[1] = 0;     /* Now, look for privileges. */  +  if (cli$present(&dcl_prv) == CLI$_PRESENT)   {0   status = cli$get_value(&dcl_prv,&aux,&retlen);     while (status != CLI$_ABSENT)a   {a    aux_buf[retlen] = '\0';  -    ptr = aux_buf;				/* Point to priv name */,  2    /* If NO<prv> was specified, adjust pointer. */  8    if (aux_buf[0] == 'N' && aux_buf[1] == 'O') ptr += 2;  E    /* IF [NO]ALL was specified, this means either (no) all privileges	F       or (no) ALLSPOOL privilege. If the string length is 3, we assume@       ALL, otherwise ALLSPOOL. Note that in the case of ALL, theH       string must be at least 3 bytes, due the ambiguity with ALTPRI. */  -    if (strlen(ptr) == 3)				/* Length = 3? */*    {.     if (!strcmp(ptr,"ALL"))				/* [NO]ALL ? */     { =      if (aux_buf[0] == 'N' && aux_buf[1] == 'O')	/* NOALL? *//      f=      RUN_PRIVS[0] = RUN_PRIVS[1] = 0;			/* Clear all privs */P  E      else RUN_PRIVS[0] = RUN_PRIVS[1] = -1;		/* else set all privs */5  G      status = cli$get_value(&dcl_prv,&aux,&retlen);	/* Get next priv */h  %      continue;						/* and proceed */t     }     }    7    value = get_prvval(ptr,&msk);			/* Get mask value */i  B    if (aux_buf [0] == 'N' && aux_buf [1] == 'O')	/* IF NO<priv> */  5    RUN_PRIVS[msk] &= ~value;				/* Clear appr. bit */c  ;    else RUN_PRIVS[msk] |= value;			/* Else set appr. bit */g  1    status = cli$get_value(&dcl_prv,&aux,&retlen);k   }i  }  /* OK, that's all. */ }U  	 /******/;  % int get_prvval(char *prvnam,int *msk)* {*A  /* Given the privilege name in 'prvnam', this routine obtain the A     approbiate privilege mask value and returns it to its caller.ID     'msk' is set to 0 if the privilege is in the lower 32 bit range,C     or set to 1, if the privilege bit is in the upper 32 bit range.c  ;     Parsing was already done by DCL, so we can be sure that/B     unambiguous privilege names were passed only. If the privilege=     name is 'SAME', ignore it (return 0) since it was alreadyd     processed earlier. */b  1  $DESCRIPTOR(aux, prvnam);		/* Aux. descriptor */s9  $DESCRIPTOR(prv,"PRIVILEGES");		/* For message string */   B  /* Most privileges are in the lower 32 bit range, so assume 'msk'     to be 0. */   
  *msk = 0;  .  switch (prvnam[0])		/* Check first letter. */  {   case 'A':    {     switch (prvnam[1])s    {      case 'C': return PRV$M_ACNT;
     case 'L':s     {a      switch (prvnam[2])i      {&       case 'L': return PRV$M_ALLSPOOL;$       case 'T': return PRV$M_ALTPRI;      }     }m
 #ifdef VMS_V6 -     case 'U': {*msk = 1; return PRV$M_AUDIT;}& #endif    }   }D   case 'B':t   {     switch (prvnam[1])P    {"     case 'U': return PRV$M_BUGCHK;"     case 'Y': return PRV$M_BYPASS;    }   }e   case 'C':J   {S    switch (prvnam[2])M    {"     case 'E': return PRV$M_CMEXEC;#     case 'K': return PRV$M_CMKRNL; o    }   }s   case 'D':    {     switch (prvnam[1])p    {"     case 'E': return PRV$M_DETACH;$     case 'I': return PRV$M_DIAGNOSE;
 #ifdef VMS_V6S1     case 'O': {*msk = 1; return PRV$M_DOWNGRADE;}L #endif    }   }E!   case 'E': return PRV$M_EXQUOTA;e     case 'G':    {-    switch (prvnam[3])t    {"     case 'N': return PRV$M_GRPNAM;.     case 'P': {*msk = 1; return PRV$M_GRPPRV;}!     case 'U': return PRV$M_GROUP;     }   }d   case 'I':/   {s
 #ifdef VMS_V6s    switch (prvnam[3])i    {.     case 'O': {*msk = 1; return PRV$M_IMPORT;}
 #ifdef VMS_V7 '     case 'E': return PRV$M_IMPERSONATE;t #endif    }   #endif   }f    case 'L': return PRV$M_LOG_IO;     case 'M': return PRV$M_MOUNT;t      case 'N': return PRV$M_NETMBX;     case 'O': return PRV$M_OPER;     case 'P':    {C    switch (prvnam[1])Y    {"     case 'F': return PRV$M_PFNMAP;"     case 'H': return PRV$M_PHY_IO;
     case 'R':d     {"      switch (prvnam[3])R      {$       case 'C': return PRV$M_PRMCEB;$       case 'G': return PRV$M_PRMGBL;$       case 'M': return PRV$M_PRMMBX;      }     } "     case 'S': return PRV$M_PSWAPM;    }   }S-   case 'R': {*msk = 1; return PRV$M_READALL;}      case 'S':d   {b    switch (prvnam[1])S    {8     case 'A': return 0;			/* Do not process SAME here */
     case 'E':      {       switch (prvnam[2])a      {2       case 'C': {*msk = 1; return PRV$M_SECURITY;}$       case 'T': return PRV$M_SETPRV;      }     }g
     case 'H':i     {I      switch(prvnam[2])      {#       case 'A': return PRV$M_SHARE; #       case 'M': return PRV$M_SHMEM;N      }     }*
     case 'Y':g     {n      switch(prvnam[3])      {$       case 'G': return PRV$M_SYSGBL;$       case 'L': return PRV$M_SYSLCK;$       case 'N': return PRV$M_SYSNAM;$       case 'P': return PRV$M_SYSPRV;      }     }O    }   }*   case 'T':g   {_    switch (prvnam[3])     {"     case 'M': return PRV$M_TMPMBX;    }   };
 #ifdef VMS_V6*-   case 'U': {*msk = 1; return PRV$M_UPGRADE;}U #endif    case 'V': return PRV$M_VOLPRO;     case 'W': return PRV$M_WORLD;k  }<  /* If we come here, we have lost. Build a descriptor to the      incorrect privilege name. */  #  aux.dsc$w_length = strlen(prvnam);f    /* Signal the error. */  (  lib$signal(RUN$_INVQUAVAL,2,&prv,&aux); }s  	 /******/n   void get_times() {(A  /* This routine obtains the times given by /DELAY, /INTERVAL and      /SCHEDULE. *//    char ,  timbuf[44];					/* Buffer for ASCII time */    $DESCRIPTOR(dcl_del,"DELAY");!  $DESCRIPTOR(dcl_int,"INTERVAL");l!  $DESCRIPTOR(dcl_sch,"SCHEDULE");&  8  $DESCRIPTOR(tim,timbuf);			/* Descriptor for $BINTIM */  .  get_string(&dcl_del,timbuf,43);		/* /DELAY */  +  if (timbuf[0])					/* Was /DELAY given? */i  {?   tim.dsc$w_length = strlen(timbuf);		/* Yes, set descriptor */   ?   if (sys$bintim(&tim,RUN_TIME) != SS$_NORMAL)	/* Convert it */   A   lib$signal(RUN$_CVTERR,2,&dcl_del,&tim);	/* If error, signal */t  =   RUN_FLAGS |= PRC$M_HIBER;			/* Mark process to hibernate */a  }:  get_string(&dcl_int,timbuf,43);		/* Same for /INTERVAL */    if (timbuf[0])E  {$   tim.dsc$w_length = strlen(timbuf);  2   if (sys$bintim(&tim,RUN_INTERVAL) != SS$_NORMAL)  *   lib$signal(RUN$_CVTERR,2,&dcl_int,&tim);     RUN_FLAGS |= PRC$M_HIBER;   }1  get_string(&dcl_sch,timbuf,43);		/* /SCHEDULE */     if (timbuf[0])   {$   tim.dsc$w_length = strlen(timbuf);  .   if (sys$bintim(&tim,RUN_TIME) != SS$_NORMAL)  *   lib$signal(RUN$_CVTERR,2,&dcl_sch,&tim);     RUN_FLAGS |= PRC$M_HIBER;a  } }X  	 /******/   
 void creprc()  {aL  /* This routine performs the actual process creation based on the arguments!     evaluated in get_cmdlin(). */S    int.  creprc_status,					/* Status of SYS$CREPRC */9  schdwk_status = SS$_NORMAL,			/* Status of SYS$SCHDWK */f9  newmsk = LIB$M_CLI_CTRLY,			/* mask to disable CTRL-Y */e   oldmsk;					/* Old CTRL mask */  =  $DESCRIPTOR(usr,RUN_USRNAM);			/* Descriptor for username */s;  $DESCRIPTOR(img,FUL_IMAGE);			/* Descriptor for various *//4  $DESCRIPTOR(inp,RUN_INPUT);			/* input arguments */  $DESCRIPTOR(out,RUN_OUTPUT);   $DESCRIPTOR(err,RUN_ERROR);  $DESCRIPTOR(nam,RUN_PRCNAM);'
 #ifdef VMS_V7s  $DESCRIPTOR(nod,RUN_NODNAM);o #endif  "  /* Initialize all descriptors. */  &  img.dsc$w_length = strlen(FUL_IMAGE);&  inp.dsc$w_length = strlen(RUN_INPUT);'  out.dsc$w_length = strlen(RUN_OUTPUT);p&  err.dsc$w_length = strlen(RUN_ERROR);'  nam.dsc$w_length = strlen(RUN_PRCNAM);'
 #ifdef VMS_V7r'  nod.dsc$w_length = strlen(RUN_NODNAM);  #endif  @  /* If /USER was given, we need DETACH and CMKRNL privileges. */    if (RUN_USRNAM[0])a  {;   if (!(OUR_PRIVS[0] & PRV$M_CMKRNL))		/* Lack of CMKRNL */o  A   lib$signal(RUN$_CREPRC,0,SS$_NOCMKRNL);	/* Signal if missing */   <   if (!(OUR_PRIVS[0] & PRV$M_DETACH))		/* Same for DETACH */  A   lib$signal(RUN$_CREPRC,0,SS$_NODETACH);	/* Signal if missing */b  @   /* Change our username before calling $CREPRC. This will forceB      the new process to be created under this name. First, disable      CTRL-Y temporary. */   $   lib$disable_ctrl(&newmsk,&oldmsk);  ?   usr.dsc$w_length = strlen(RUN_USRNAM);	/* Setup descriptor */U  F   if ((creprc_status = _setnam(&usr)) != SS$_NORMAL)	/* Change name */  *   lib$signal(RUN$_CREPRC,0,creprc_status);  }  /* Create the process. */  D  creprc_status = sys$creprc(&RUN_PID,		/* Longword to receive PID */ 			&img,			/* Image name */r  			&inp,			/* Input file name */! 			&out,			/* Output file name */   			&err,			/* Error file name */ 			RUN_PRIVS,		/* Privileges */w( 			RUN_QUOLIST,		/* Quota list (or 0) */ 			&nam,			/* Process name */i% 			RUN_PRIORITY,		/* Base priority */  			RUN_UIC,		/* Process UIC */* 			RUN_MBXUNIT,		/* Termination mailbox */
 #ifdef VMS_V7/" 			RUN_FLAGS,		/* Process flags */" 			0,			/* Item list (not used) */  			RUN_NODNAM);		/* Node name */ #else # 			RUN_FLAGS);		/* Process flags */  #endif  H  /* If process creation was successful and hibernation was requested dueF     to qualifiers /DELAY, /INTERVAL or /SCHEDULE), schedule the wakeup     request now. */   <  if (creprc_status == SS$_NORMAL && RUN_FLAGS & PRC$M_HIBER)  >  schdwk_status = sys$schdwk(&RUN_PID,0,RUN_TIME,RUN_INTERVAL);  6  /* If username was changed temporary, set it back. */    if (RUN_USRNAM[0])c  {@   usr.dsc$w_length = strlen(OUR_USRNAM);		/* Setup descriptor */!   usr.dsc$a_pointer = OUR_USRNAM;a  +   _setnam(&usr);					/* Restore username */,  3   lib$enable_ctrl(&oldmsk);				/* Restore CTRL-Y */i  }B  /* If process creation or schedule wakeup failed for some reason,     let the user know. */m  !  if (creprc_status != SS$_NORMAL)*  1  lib$signal(RUN$_CREPRC,1,RUN_PID,creprc_status);4  !  if (schdwk_status != SS$_NORMAL)w  1  lib$signal(RUN$_SCHDWK,1,RUN_PID,schdwk_status);  } 