 /* Modification History     -------------------- 6    Sep.  8, 1987 JEM - Conversion from BETA to Release<    Sep. 26, 1988 RPF - open indexf.sys in a shareable manner */ #include <descrip.h> #include <iodef.h> #include <ssdef.h> #include <secdef.h>    #include "FileInfo.h"   H long int map_section(Filename,Defaultname,PageCount,Offset,Flag,context)I /* This routines maps a file into memory. If no context has been set then H    it allocates a FileInfo structure, and opens the necessary file. OnceK    the file has been opened the Filename, Default name, and Flag parameters     are ignored.   '    Filename = Name of file to be opened 2    Defaultname = Default name of file to be opened9    PageCount = number of pages to try to read into memory D    Offset = VBN of the file to start reading from (1 is first block)3    Flag = Flag specifies attributes about the file: "  	bit 0 = File is opened for write  	bit 1 = File may be appended toJ    context = Pointer to a FileInfo structure. Initialize it to zero before9 	the first call to MapSection, don't touch it after that.    */"   struct dsc$descriptor *Filename;%   struct dsc$descriptor *Defaultname;    long int *PageCount;   long int *Offset;    long int *Flag;    struct FileInfo **context; {    long int Status,TmpStatus;   long int MapFlag=0;     long int RetAdr[2],DeltAdr[2];   long int i, ppp;     if (*context==0) {L     /* This is a first call, we need to allocate space, init the FAB etc. */:     Status = LIB$GET_VM(&sizeof(struct FileInfo),context);&     if (!(Status & 1)) return(Status);  "     (*context)->fi_l_flag = *Flag;     (*context)->fi_l_begadr=0;     (*context)->fi_l_endadr=0;&     (*context)->fi_r_fab = cc$rms_fab;&     (*context)->fi_r_nam = cc$rms_nam;,     (*context)->fi_r_xabfhc = cc$rms_xabfhc;-     (*context)->fi_r_fab.fab$l_fop=FAB$M_UFO; -     (*context)->fi_r_fab.fab$b_fac=FAB$M_GET; ;     (*context)->fi_r_fab.fab$l_fna=Filename->dsc$a_pointer; :     (*context)->fi_r_fab.fab$b_fns=Filename->dsc$w_length;>     (*context)->fi_r_fab.fab$l_dna=Defaultname->dsc$a_pointer;=     (*context)->fi_r_fab.fab$b_dns=Defaultname->dsc$w_length; <     (*context)->fi_r_fab.fab$l_nam = &(**context).fi_r_nam ;?     (*context)->fi_r_fab.fab$l_xab = &(**context).fi_r_xabfhc ;        if ((*context)->fi_m_write) 2       (*context)->fi_r_fab.fab$b_fac |= FAB$M_PUT;   /* The following fix came from: > From:	IN%"076RONAN@VAX.LIVERPOOL-POLY.AC.UK" 26-SEP-1988 15:44 To:	JOE@FHCRCVAX.BITNET  Subj:	Problem with INDEX v 1.0B Name:          Ronan P. Flood, Senior Analyst/Programmer (systems)C Address:       Liverpool Polytechnic, Computer Services Department, , 	       Byrom Street, Liverpool, L3 3AF, U.K, Telephone:     (051) 207-3581 extension 2101  J This allows ANALYZE/DISK (and such programs) to run concurrently with FIND */B     (*context)->fi_r_fab.fab$b_shr = FAB$M_SHRPUT | FAB$M_SHRGET |, 				FAB$M_SHRDEL | FAB$M_SHRUPD | FAB$M_UPI;  +     Status=SYS$OPEN(&(*context)->fi_r_fab); &     if (!(Status & 1)) return(Status);  :     /* use the xabfhc to find out the end of file block */@     (*context)->fi_l_filsiz = (*context)->fi_r_xabfhc.xab$l_ebk;/     if ((*context)->fi_r_xabfhc.xab$w_ffb == 0)         --(*context)->fi_l_filsiz;  I     MapFlag = SEC$M_EXPREG; /* first time we definitely need to expand */    };     if (*Offset==0)      *Offset=1;  7   if ((*Offset+*PageCount-1)>(*context)->fi_l_filsiz) { ?     /* they asked for more pages then there are in the file! */ "     if ((*context)->fi_m_append) {!       /* okay, extend the file */ J       /* Extend by (*Offset+*PageCount-1)-(*context)->fi_l_filsiz bytes */1       /* and update (*context)->fi_l_filsiz += */ "       /* for now, it's a no-op. */     }    else5     *PageCount=(*context)->fi_l_filsiz - *Offset + 1;    };     if ((*context)->fi_m_write)      MapFlag |= SEC$M_WRT;   D   Status=SYS$CRMPSC(&(*context)->fi_l_begadr,RetAdr,0,MapFlag,0,0,0,L                      (*context)->fi_r_fab.fab$l_stv,*PageCount,*Offset,0,0);  ?   /* see if we lost a chunk while remapping, if so deltva it */   G /* NRA this may delete more than expected on AXP, pagelets vs pages...  7    comment it out. Shouldn't affect FIND operation.  */ N /* second pass; this seems to be needed, at least on VAX! Strange status codes    later if not  */  +  if ((*context)->fi_l_endadr > RetAdr[1]) {   K     /* Hmm, the old end was larger  than the new end, so deltva the diff */ N     /* need care to round retadr[1] up to the next AXP page, then re-check if '      * there are pages to be removed */        ppp = pagelets_per_page();H     DeltAdr[0] = RetAdr[1]+ (512*ppp); /* this is in the NEXT page up */A     DeltAdr[0] &= ~((ppp*512)-1);      /* clear in-page offset */ ?     DeltAdr[1] = (*context)->fi_l_endadr; /* old end address */      L     if( DeltAdr[0] < DeltAdr[1] ) {       /* delete iff there are surplus */F         TmpStatus = SYS$DELTVA(DeltAdr,0,0);   /* whole pages to go */0         if (!(TmpStatus & 1)) return(TmpStatus);     };   };  &   (*context)->fi_l_begadr = RetAdr[0];&   (*context)->fi_l_endadr = RetAdr[1];  "   i = (RetAdr[1]-RetAdr[0]+1)/512;*   if ((i < *PageCount) || (*PageCount==0))     *PageCount = i; '   (*context)->fi_l_pagcnt = *PageCount; $   (*context)->fi_l_offset = *Offset;     return(Status);  }     long int delete_section(context)   struct FileInfo **context; {    long int Status;  4   Status = SYS$DELTVA(&(*context)->fi_l_begadr,0,0);$   if (!(Status & 1)) return(Status);  6   Status = SYS$DASSGN((**context).fi_r_fab.fab$l_stv);$   if (!(Status & 1)) return(Status);  9   Status = LIB$FREE_VM(&sizeof(struct FileInfo),context);    *context = 0;      return(Status);  }   8 long int read_section_block (context,blocknum,blockaddr)   struct FileInfo **context;   long int *blocknum;    long int **blockaddr;  {    static long int block=512;   long int iosb[2];    long int Status;     if (*blockaddr==0) {?     /* they didn't specify where to read the block to, so we'll .        allocate a block and read into there */*     Status = LIB$GET_VM(&block,blockaddr);&     if (!(Status & 1)) return(Status);   };  B   Status = SYS$QIOW(0,(*context)->fi_r_fab.fab$l_stv,IO$_READVBLK,?                     iosb,0,0,*blockaddr,block,*blocknum,0,0,0);    if (Status & 1)      Status = iosb[0];    return(Status);  } 