/*
 * routines for handling text subrecords and font information.
 */
struct bktxt_font_def {
    int fontno;		/* font number */
    char *name;		/* asciz name of font */
    /* Following are for Parse out versions for fields in name */
    char *foundry;	/* Font designer (ADOBE) */
    char *typeface;	/* Typeface family (Helvtica, Courier, etc */
    char *weight;	/* (Book, Demi, Medium, Bold) */
    char *style;	/* 'R'oman, 'I'talic, 'O'blique */
    char *width;	/* Normal, Wide, Double Wide */
    char *id;		/* ??? */
    int pixel_size;	/* -1 indicates "*" */
    int point_size;	/* 100, 120, 140, 180 */
    int res_x, res_y;   /* Dot/inch */
    char *spacing;	/* 'P'proportional, 'M'onospace, 'C'har-cell */
    int average_width;	/* Average width of characters (-1 means unknown) */
    char *encoding;	/* ISO8859-1 is LATIN1 */
};
typedef struct bktxt_font_def *bktxt_fntptr;
int bkt_read_font_map ( void* bkfctx, 		/* bki_open file context */
	bktxt_fntptr *fontdef, 		/* return array of structs  */
	int *count );				/* size of returned array */

/*
 *  Scan record by setting offset to 0 and calling repeatedly
 *  until offset greater or equal to reclen (length of record).
 */
int bkt_text3_scan ( int reclen, char *rec, 
	int *offset, char substring[256], int *stringlength, int *glue );
