typedef void *fcgi_handle;

int fcgi_init_mux (void);			/* one-time initialization */
int fcgi_connect ( char *apphost, int port, 
	fcgi_handle *fcgi, char err[256] );

int fcgi_listen ( int port, int connect_callback(), 
	int request_callback(), char err[256] );
int fcgi_accept ( char *host, char port, int id, fcgi_handle *fcgi );

int fcgi_send ( fcgi_handle fcgi, int msgtype, void *msg, int msgsize );
int fcgi_recv ( fcgi_handle fcgi, int *msgtype, char **msg, int *msgsize );
int fcgi_disconnect ( fcgi_handle fcgi, int keep_connection );
int fcgi_app_info ( fcgi_handle fcgi, char **apphost, int *port, int *mplx );
/*
 * Define contstants used for message types.
 */
#define FCGI_BEGIN_REQUEST 1
#define FCGI_ABORT_REQUEST 2
#define FCGI_END_REQUEST 3
#define FCGI_PARAMS 4
#define FCGI_STDIN 5
#define FCGI_STDOUT 6
#define FCGI_STDERR 7
#define FCGI_DATA 8
#define FCGI_UNKNOWN_TYPE 11

#define FCGI_RESPONDER 1
#define FCGI_AUTHORIZER 2
#define FCGI_FILTER 3
#define FCGI_KEEP_CONN 1
