/* Program Name            : FILERPUR.C                                 */
/*   Original Author       : C. K. Hung					*/
/*   Date                  : 21-MAY-1991				*/
/*   Program Description   :                                            */
/*                         :                                            */
/* Revision History follows                                             */
 
#include "global.h"
#include "dx.h"
#include "filer.h"
#include "filerdel.h"
#include "filerpur.h"
#include "inquire.h"
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      tbs
**
**--
**/
int	filer_purge()
{
    if (DX_CURRENT_DIRECTORY.filemode == multiple)
	filer_multiple_purge();
    else
	filer_single_purge();
     return DX__NORMAL;
}
 
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      to be specified
**
**--
**/
int	filer_multiple_purge()
{
    char errmsg[MAXFILESPEC+1];
 
    strcpy(errmsg, "Error purging file");
    multi_get_userinput_and_exec(
	filer_purge$1,
	"Multiple Purge",
	"Are you sure? [YES/NO] ",
	"",
	errmsg);
 
     return DX__NORMAL;
}
 
 
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      to be specified
**
**--
**/
int	filer_single_purge()
{
    char errmsg[MAXFILESPEC+1];
    char fn[MAXFILESPEC+1];
 
    if (!strcmp(DX_CURRENT_FILE->fn, "[-]"))
    {
        signal_err("Purge a parent directory file not allowed", bell);
    }
    else
    {
	find_full_path_name(DX_CURRENT_FILE->fn, fn, cntrl_info_block.cur_win);
	strcpy(errmsg, "Error purging file");
	if (cntrl_info_block.user_pref.purge_confirm)
	    get_userinput_and_execute(
		filer_purge$1,
		"Confirm Purge",
		"Purge this file? [YES/NO] ",
		"YES",
		errmsg,
		fn);
	else if (filer_purge$1("YES", fn, errmsg) == -1)
	    signal_err(errmsg, bell);
    }
     return DX__NORMAL;
}
 
 
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      to be specified
**
**--
**/
int	filer_purge$1(confirm, fn, errmsg)
char *confirm;
char *fn;
char *errmsg;
{
    struct fil_dx_tag *p, *q;
    char buf[MAXFILESPEC+1];
    char name1[MAXFILESPEC+1], name2[MAXFILESPEC+1];
    char *cp;
    int ver1, ver2;
    /*
    **	Verify that the user wants to continue with the
    **	purge operation.  Return to calling
    **	routine if the user does not enter "YES".
    **/
 
    if (!strcmp(confirm, "NO") || !strcmp(confirm, "N"))
    {
	strcpy(errmsg, "PURGE canceled by request");
	return DX__DONTCARE;
    }
    else if (!strcmp(confirm, "YE") || !strcmp(confirm, "Y"))
    {
	strcpy(errmsg, "Abbreviation not allowed.  Please try again.");
	return DX__ERROR;
    }
    else if (strcmp(confirm, "YES"))
    {
	strcpy(errmsg, "Invalid input data");
	return DX__ERROR;
    }
 
    /*
    **	Confirmed the purge operation.  Go ahead
    **	purge the file specified.
    **/
 
    strcpy(name1, fn);
    cp = strchr(name1, ';');
    *cp = EOS;
    ver1 = atoi (cp+1);
    p = DX_CURRENT_DIRECTORY.dir_filelist->forward;
    while (p != DX_CURRENT_DIRECTORY.non_dir_filelist)
    {
        if (p == DX_CURRENT_DIRECTORY.dir_filelist)
        {
            p = DX_CURRENT_DIRECTORY.non_dir_filelist->forward;
        }
	else
	{
	    q = p->forward;	/**  Save file to be processed next  **/
	    find_full_path_name(p->fn, buf, cntrl_info_block.cur_win);
	    strcpy(name2, buf);
            if ((cp = strchr(name2, ';')) != NULL)
            {
		*cp = EOS;	
		if (!strcmp(name1, name2))
		{
		    ver2 = atoi (cp+1);
		    if (ver1 > ver2) {
			if (filer_delete$1("YES", buf, errmsg) == DX__ERROR)
			{
			    signal_err(errmsg, bell);
			}
		    }
		}
            }
	    p = q;
	}
    }
 
    return DX__NORMAL;
}
