/* Program Name            : FILERCUS.C                                 */
/*   Original Author       : C. K. Hung					*/
/*   Date                  : 8-JAN-1991					*/
/*   Program Description   :                                            */
/*                         :                                            */
/* Revision History follows                                             */
/*  (11Apr91)   CKH	Upgrade to DX II				*/
/*  03-Jun-1999 JL 	Removed LSE					*/
 
 
 
#include "global.h"
#include "filercus.h"
#include "filerque.h"
#include "inquire.h"
 
/* ****  FUNCTIONAL PROTOTYPING *** */
 
static int	select_a_display_date$1(
		    short int dattype, enum sortbys sortdat, char *);
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**	tbs
**
**--
**/
int	custom_editor()
{
    char errmsg[MAXFILESPEC+1];
    char current_editor[4];
 
    switch (cntrl_info_block.user_pref.editor) {
 
        case DX_EDITOR_EDT:
            strcpy(current_editor, "EDT");
	    break;
        case DX_EDITOR_TPU:
            strcpy(current_editor, "TPU");
	    break;
        default:
            strcpy(current_editor, "TPU");
	    break;
 
    }
 
    strcpy(errmsg, "Invalid input value");
    get_userinput_and_execute(
	select_a_editor,
	"Select an Editor",
	"Choose an editor: [EDT, TPU, or LSE] ",
	current_editor,
	errmsg,
	"dummy");
 
    return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      tbs
**
**--
**/
int	select_a_editor(editor, dummy, errmsg)
char *editor;
char *dummy;
char *errmsg;
{
    int len;
 
    len = strlen(editor);
    if (!strncmp(editor, "EDT", len))		/**   User likes EDT better  **/
 
	cntrl_info_block.user_pref.editor = DX_EDITOR_EDT;
 
    else if (!strncmp(editor, "TPU", len))	/**  Use TPU as the editor   **/
 
	cntrl_info_block.user_pref.editor = DX_EDITOR_TPU;
 
    else if (!strncmp(editor, "LSE", len))	/**  Use LSE as the editor   **/
 
	cntrl_info_block.user_pref.editor = DX_EDITOR_LSE;
 
    else
    {
	strcpy(errmsg, "Invalid input data");
	return DX__ERROR;
    }
 
    return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**	tbs
**
**--
**/
int	custom_display_date()
{
    char errmsg[MAXFILESPEC+1];
    char init_value[MAXFILESPEC+1];
 
    switch (DX_CURRENT_DIRECTORY.cur_filter.date)
    {
        case DX_CREDATE:
            strcpy(init_value, "CREATED");
	    break;
        case DX_REVDATE:
            strcpy(init_value, "MODIFIED");
	    break;
        case DX_EXPDATE:
            strcpy(init_value, "EXPIRED");
	    break;
        case DX_BAKDATE:
            strcpy(init_value, "BACKUP");
	    break;
        default:
            return DX__ERROR;
    }
 
    strcpy(errmsg, "Invalid input value");
    get_userinput_and_execute(
	select_a_display_date,
	"Select a display date type",
	"Choose one: [CREATED, MODIFIED, EXPIRED, or BACKUP] ",
	init_value,
	errmsg,
	"dummy");
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      tbs
**
**--
**/
int	select_a_display_date(dat, dummy, errmsg)
char *dat;
char *dummy;
char *errmsg;
{
    int len;
 
    len = strlen(dat);
 
    if (!strncmp(dat, "CREATED", len))		/**  Display creation date   **/
    {
	select_a_display_date$1(DX_CREDATE, sortcredate, errmsg);
    }
    else if (!strncmp(dat, "MODIFIED", len))	/**  Display revision date   **/
    {
	select_a_display_date$1(DX_REVDATE, sortrevdate, errmsg);
    }
    else if (!strncmp(dat, "EXPIRED", len))	/**  Display expiration date **/
    {
	select_a_display_date$1(DX_EXPDATE, sortexpdate, errmsg);
    }
    else if (!strncmp(dat, "BACKUP", len))	/**  Display backup date     **/
    {
	select_a_display_date$1(DX_BAKDATE, sortbakdate, errmsg);
    }
    else					/**  Invalid input value     **/
    {
	return DX__ERROR;
    }
 
    return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      tbs
**
**--
**/
static int	select_a_display_date$1(
			short int dattype,
			enum sortbys sortdat,
			char *errmsg)
{
    static unsigned int timlen;
 
    char since[50];
    $DESCRIPTOR (since_descriptor, since);
    char before[50];
    $DESCRIPTOR (before_descriptor, before);
    enum sortbys old_sortby;
 
    check_OK(sys$asctim (
		&timlen,
		&since_descriptor,
		&DX_CURRENT_DIRECTORY.cur_filter.since,
		0))
    since[ timlen ] = EOS;
    check_OK(sys$asctim (
		&timlen,
		&before_descriptor,
		&DX_CURRENT_DIRECTORY.cur_filter.before,
		0))
    before[ timlen ] = EOS;
 
    if (DX_CURRENT_DIRECTORY.cur_filter.date != dattype)
    {
	DX_CURRENT_DIRECTORY.cur_filter.date = dattype;
	old_sortby = DX_CURRENT_DIRECTORY.sortby;
	if (DX_CURRENT_DIRECTORY.sortby == sortcredate ||
	    DX_CURRENT_DIRECTORY.sortby == sortrevdate ||
	    DX_CURRENT_DIRECTORY.sortby == sortexpdate ||
	    DX_CURRENT_DIRECTORY.sortby == sortbakdate)
	{	/**  Current directory sort by date  **/
	    DX_CURRENT_DIRECTORY.sortby = sortdat;
	}
 
	if (strncmp(since, "17-NOV-1858", 11) &&
	    strncmp(before, "31-DEC-2857", 11))
	{	/**  SINCE and BOFORE not null  **/
	    filer_filter$1("", "Update", errmsg);
	}
	else if (old_sortby != sortdat &&
		 old_sortby != sortname &&
		 old_sortby != sorttype &&
		 old_sortby != sortsize &&
		 old_sortby != sortmark)
	{	/**  Was sort by other date type  **/
	    filer_sort$1(
		DX_CURRENT_DIRECTORY.sortorder == ascending?
		    "ASCENDING" : "DESCENDING",
		"Date",
		errmsg);
	}
	else
	{	/**  Not sort by date  **/
	    check_OK(smg$begin_display_update (
			 &DX_CURRENT_DIRECTORY.filer_display.id))
 
	    check_OK(smg$erase_display (
			 &DX_CURRENT_DIRECTORY.filer_display.id,
			 0,
			 0,
			 0,
			 0))
 
	    write_to_filer(DX_CURRENT_DIRECTORY.dir_filelist);
	    write_to_filer(DX_CURRENT_DIRECTORY.non_dir_filelist);
 
	    change_filer_viewport(cntrl_info_block.cur_win);
 
	    highlight_filer_current_file();
 
	    check_OK(smg$end_display_update (
			 &DX_CURRENT_DIRECTORY.filer_display.id))
	}
    }
   return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**	tbs
**
**--
**/
int	custom_delete()
{
    char errmsg[MAXFILESPEC+1];
 
    strcpy(errmsg, "Invalid input value");
    get_userinput_and_execute(
	confirm_delete,
	"File Delete Confirmation",
	"Confirm on each file DELETION? [YES/NO] ",
	(cntrl_info_block.user_pref.delete_confirm? "YES" : "NO"),
	errmsg,
	"dummy");
   return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      tbs
**
**--
**/
int	confirm_delete(confirm, dummy, errmsg)
char *confirm;
char *dummy;
char *errmsg;
{
    int len;
 
    len = strlen(confirm);
    if (!strncmp(confirm, "YES", len))	    /** Confirm before deletion      **/
 
	cntrl_info_block.user_pref.delete_confirm = 1;
 
    else if (!strncmp(confirm, "NO", len))  /** Do not confirm before delete **/
 
	cntrl_info_block.user_pref.delete_confirm = 0;
 
    else
    {
	strcpy(errmsg, "Invalid input data");
	return DX__ERROR;
    }
 
    return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**	tbs
**
**--
**/
int	custom_purge()
{
    char errmsg[MAXFILESPEC+1];
 
    strcpy(errmsg, "Invalid input value");
    get_userinput_and_execute(
	confirm_purge,
	"File Purge Confirmation",
	"Confirm on each file PURGE? [YES/NO] ",
	(cntrl_info_block.user_pref.purge_confirm? "YES" : "NO"),
	errmsg,
	"dummy");
    return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      tbs
**
**--
**/
int	confirm_purge(confirm, dummy, errmsg)
char *confirm;
char *dummy;
char *errmsg;
{
    int len;
 
    len = strlen(confirm);
    if (!strncmp(confirm, "YES", len))	    /** Confirm before purge	     **/
 
	cntrl_info_block.user_pref.purge_confirm = 1;
 
    else if (!strncmp(confirm, "NO", len))  /** Do not confirm before purge  **/
 
	cntrl_info_block.user_pref.purge_confirm = 0;
 
    else
    {
	strcpy(errmsg, "Invalid input data");
	return DX__ERROR;
    }
 
    return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**	tbs
**
**--
**/
int	custom_type()
{
    char errmsg[MAXFILESPEC+1];
 
    strcpy(errmsg, "Invalid input value");
    get_userinput_and_execute(
	select_type_method,
	"Type by Page",
	"Display one screen at a time? [YES/NO] ",
	(cntrl_info_block.user_pref.type_by_page? "YES" : "NO"),
	errmsg,
	"dummy");
   return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      tbs
**
**--
**/
int	select_type_method(confirm, dummy, errmsg)
char *confirm;
char *dummy;
char *errmsg;
{
    int len;
 
    len = strlen(confirm);
    if (!strncmp(confirm, "YES", len))	    /** Type the file page-by-page   **/
 
	cntrl_info_block.user_pref.type_by_page = 1;
 
    else if (!strncmp(confirm, "NO", len))  /** Type the file continuously   **/
 
	cntrl_info_block.user_pref.type_by_page = 0;
 
    else
    {
	strcpy(errmsg, "Invalid input data");
	return DX__ERROR;
    }
 
    return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**	tbs
**
**--
**/
int	custom_auto_update()
{
    char errmsg[MAXFILESPEC+1];
 
    strcpy(errmsg, "Error setting AUTO UPDATE option");
    get_userinput_and_execute(
	auto_update,
	"Automatically Update",
	"Update after each EDIT, LAUNCH, or EXECUTE? [Y/N] ",
	(cntrl_info_block.user_pref.auto_update? "YES" : "NO"),
	errmsg,
	"dummy");
   return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      tbs
**
**--
**/
int	auto_update(confirm, dummy, errmsg)
char *confirm;
char *dummy;
char *errmsg;
{
    int len;
 
    len = strlen(confirm);
    if (!strncmp(confirm, "YES", len))	    /** Update after session	     **/
 
	cntrl_info_block.user_pref.auto_update = 1;
 
    else if (!strncmp(confirm, "NO", len))   /** Do not update		     **/
 
	cntrl_info_block.user_pref.auto_update = 0;
 
    else
    {
	strcpy(errmsg, "Invalid input data");
	return DX__ERROR;
    }
 
    return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**	tbs
**
**--
**/
int	custom_display_clock()
{
    char errmsg[MAXFILESPEC+1];
 
    strcpy(errmsg, "Error setting DISPLAY CLOCK option");
    get_userinput_and_execute(
	display_clock,
	"Display Clock",
	"Display clock in this session? [Y/N] ",
	(cntrl_info_block.user_pref.display_clock? "YES" : "NO"),
	errmsg,
	"dummy");
   return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      tbs
**
**--
**/
int	display_clock(confirm, dummy, errmsg)
char *confirm;
char *dummy;
char *errmsg;
{
    int len;
 
    len = strlen(confirm);
    if (!strncmp(confirm, "YES", len))	    /** Update after session	     **/
 
	cntrl_info_block.user_pref.display_clock = 1;
 
    else if (!strncmp(confirm, "NO", len))   /** Do not update		     **/
    {
	cntrl_info_block.user_pref.display_clock = 0;
	clear_time();
    }
    else
    {
	strcpy(errmsg, "Invalid input data");
	return DX__ERROR;
    }
 
    return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**	tbs
**
**--
**/
int	custom_update_in_second()
{
    char errmsg[MAXFILESPEC+1];
 
    strcpy(errmsg, "Error setting FLASH CLOCK COLON option");
    get_userinput_and_execute(
	update_in_second,
	"Flash Clock Colon",
	"Flash clock colon? [ON/OFF] ",
	(cntrl_info_block.user_pref.update_in_second? "ON" : "OFF"),
	errmsg,
	"dummy");
   return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      tbs
**
**--
**/
int	update_in_second(confirm, dummy, errmsg)
char *confirm;
char *dummy;
char *errmsg;
{
    int len;
 
    len = strlen(confirm);
 
    if (confirm[0] == 'O' && len == 1)
    {
	strcpy(errmsg, "Ambugious response - supply more characters");
	return DX__ERROR;
    }
    else if (!strncmp(confirm, "ON", len))	/** Update the clock every second    **/
    {
        cntrl_info_block.user_pref.display_clock = 1;
	cntrl_info_block.user_pref.update_in_second = 1;
    }
    else if (!strncmp(confirm, "OFF", len))/** Update the clock every 60 seconds**/
    {
        cntrl_info_block.user_pref.display_clock = 1;
	cntrl_info_block.user_pref.update_in_second = 0;
	write_time(cntrl_info_block.commands_display.id);
    }
    else
    {
	strcpy(errmsg, "Invalid input data");
	return DX__ERROR;
    }
 
    return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**	tbs
**
**--
**/
int	custom_save_setting()
{
    char errmsg[MAXFILESPEC+1];
 
    strcpy(errmsg, "Error save setting to a file");
    get_userinput_and_execute(
	save_setting,
	"Save Setting",
	"Save to: ",
	DEFAULT_STARTUP,
	errmsg,
	"dummy");
   return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      tbs
**
**--
**/
int	save_setting(filename, dummy, errmsg)
char *filename;
char *dummy;
char *errmsg;
{
    FILE *f;
    struct fil_dx_tag temp_entry;
    int i;
 
    if ((f = fopen (filename, "w")) == NULL)
    {
        sprintf (errmsg, "Error creating an output file");
	return DX__ERROR;
    }
 
    fprintf (f, "DX.short_form: ");
    if (DX_CURRENT_DIRECTORY.form == short_form)
    {
        fprintf (f, "YES\n");
    }
    else
    {
        fprintf (f, "NO\n");
    }
 
    fprintf (f, "DX.editor: ");
    switch (cntrl_info_block.user_pref.editor)
    {
        case DX_EDITOR_EDT:
            fprintf (f, "EDT\n");
	    break;
        case DX_EDITOR_TPU:
            fprintf (f, "TPU\n");
	    break;
        case DX_EDITOR_LSE:
            fprintf (f, "LSE\n");
	    break;
    }
    fprintf (f, "DX.display_date: ");
    switch (DX_CURRENT_DIRECTORY.cur_filter.date)
    {
        case DX_CREDATE:
            fprintf(f, "CREATED\n");
	    break;
        case DX_REVDATE:
            fprintf(f, "MODIFIED\n");
	    break;
        case DX_EXPDATE:
            fprintf(f, "EXPIRED\n");
	    break;
        case DX_BAKDATE:
            fprintf(f, "BACKUP\n");
	    break;
        default:
            return DX__ERROR;
    }
        fprintf (f, "DX.type_by_page: ");
    if (cntrl_info_block.user_pref.type_by_page)
    {
        fprintf (f, "YES\n");
    }
    else
    {
        fprintf (f, "NO\n");
    }
    fprintf (f, "DX.delete_confirm: ");
    if (cntrl_info_block.user_pref.delete_confirm)
    {
        fprintf (f, "YES\n");
    }
    else
    {
        fprintf (f, "NO\n");
    }
    fprintf (f, "DX.purge_confirm: ");
    if (cntrl_info_block.user_pref.purge_confirm)
    {
        fprintf (f, "YES\n");
    }
    else
    {
        fprintf (f, "NO\n");
    }
    fprintf (f, "DX.auto_update: ");
    if (cntrl_info_block.user_pref.auto_update)
    {
        fprintf (f, "YES\n");
    }
    else
    {
        fprintf (f, "NO\n");
    }
    fprintf (f, "DX.display_clock: ");
    if (cntrl_info_block.user_pref.display_clock)
    {
        fprintf (f, "YES\n");
    }
    else
    {
        fprintf (f, "NO\n");
    }
    fprintf (f, "DX.flash_clock_colon: ");
    if (cntrl_info_block.user_pref.update_in_second)
    {
        fprintf (f, "ON\n");
    }
    else
    {
        fprintf (f, "OFF\n");
    }
 
    fclose (f);
 
    /*
    **	Update the filer list and display
    **/
 
    strcpy(errmsg, "Screen not updated");
    if (filestat(filename, &temp_entry, errmsg) == DX__ERROR)
    {
        return DX__ERROR;
    }
 
    temp_entry.state = waiting;
    temp_entry.beg_y = temp_entry.beg_x = 0;
    temp_entry.forward = temp_entry.backward = NULL;
 
    /*
    **  Update cache queue.
    **	In case of running out of memory, output error message
    **	but update current display(s) anyway.
    **/
 
    if (update_filer_cache(temp_entry, add_to_filer_cache, errmsg) == DX__ERROR)
    {
        signal_err(errmsg, bell);
    }
 
    /**  Add it to the FILER  **/
    if (add_to_filer(temp_entry, errmsg, cntrl_info_block.cur_win) == DX__ERROR)
    {
        return DX__ERROR;
    }
 
    /**  Update other windows  **/
    for (i = 0;  i < cntrl_info_block.windows;  i++)
    {
        if (i != cntrl_info_block.cur_win)
        {
            if (add_to_filer(temp_entry, errmsg, i) == DX__ERROR)
            {
                 return DX__ERROR;
            }
        }
    }
 
    return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**	tbs
**
**--
**/
int	custom_restore_setting()
{
    char errmsg[MAXFILESPEC+1];
 
    strcpy(errmsg, "Error restore setting from a file");
    get_userinput_and_execute(
	restore_setting,
	"Restore Setting",
	"Restore from: ",
	DEFAULT_STARTUP,
	errmsg,
	"dummy");
   return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      tbs
**
**--
**/
int	restore_setting(filename, init_flag, errmsg)
char *filename;
char *init_flag;
char *errmsg;
{
    FILE *f;
    char line[256];
    int len;
    int i;
 
    if ((f = fopen (filename, "r")) == NULL)
    {
        sprintf (errmsg, "Error opening an input file");
	return DX__ERROR;
    }
 
    i = 0;
    while (!feof (f))
    {
        fgets (line, 255, f);
	len = strlen(line);
        if (len == 0)
        {
            break;
        }
	i++;
	len--;
	line[len] = EOS;
 
        if (!strncmp (line, "DX.short_form: ", 15))
        {
            if (!strncmp (line+15, "YES", 3))
	    {	    /**  Use short form  **/
		cntrl_info_block.user_pref.use_short_form = 1;
                if (DX_CURRENT_DIRECTORY.form != short_form)
                {
		    DX_CURRENT_DIRECTORY.form = short_form;
		    if (strcmp(init_flag, "init"))
		    {
			filer_short_form();
		    }
                }
	    }
	    else if (!strncmp (line+15, "NO", 2))
	    {	    /**  Use long form  **/
		cntrl_info_block.user_pref.use_short_form = 0;
		if (DX_CURRENT_DIRECTORY.form != long_form)
		{
		    DX_CURRENT_DIRECTORY.form = long_form;
		    if (strcmp(init_flag, "init"))
		    {
			filer_long_form();
		    }
		}
	    }
        }
        else if (!strncmp (line, "DX.editor: ", 11))
        {
            if (!strncmp (line+11, "EDT", 3))
            {
                cntrl_info_block.user_pref.editor = DX_EDITOR_EDT;
            }
            else if (!strncmp (line+11, "TPU", 3))
            {
                cntrl_info_block.user_pref.editor = DX_EDITOR_TPU;
            }
            else if (!strncmp (line+11, "LSE", 3))
            {
                cntrl_info_block.user_pref.editor = DX_EDITOR_LSE;
            }
        }
        else if (!strncmp (line, "DX.display_date: ", 17))
        {
	    if (!strncmp (line+17, "CREATED", 7) ||
		!strncmp(line+17, "MODIFIED", 8) ||
		!strncmp(line+17, "EXPIRED", 7) ||
		!strncmp(line+17, "BACKUP", 6))
	    {
		if (!strncmp (line+17, "CREATED", 7))
		{
		    DX_CURRENT_DIRECTORY.cur_filter.date = DX_CREDATE;
		}
		else if (!strncmp(line+17, "MODIFIED", 8))
		{
		    DX_CURRENT_DIRECTORY.cur_filter.date = DX_REVDATE;
		}
		else if (!strncmp(line+17, "EXPIRED", 7))
		{
		    DX_CURRENT_DIRECTORY.cur_filter.date = DX_EXPDATE;
		}
		else
		{
		    DX_CURRENT_DIRECTORY.cur_filter.date = DX_BAKDATE;
		}
 
                if (strcmp(init_flag, "init"))
                {	/**  Update the screen  **/
		    check_OK(smg$begin_display_update (
				 &DX_CURRENT_DIRECTORY.filer_display.id))
		    check_OK(smg$erase_display (
				 &DX_CURRENT_DIRECTORY.filer_display.id,
				 0,
				 0,
				 0,
				 0))
		    write_to_filer(DX_CURRENT_DIRECTORY.dir_filelist);
		    write_to_filer(DX_CURRENT_DIRECTORY.non_dir_filelist);
 
		    change_filer_viewport(cntrl_info_block.cur_win);
 
		    highlight_filer_current_file();
 
		    check_OK(smg$end_display_update (
				 &DX_CURRENT_DIRECTORY.filer_display.id))
		}
	    }
        }
        else if (!strncmp (line, "DX.type_by_page: ", 17))
        {
            if (!strncmp (line+17, "YES", 3))
 
		cntrl_info_block.user_pref.type_by_page = 1;
 
	    else if (!strncmp (line+17, "NO", 2))
 
		cntrl_info_block.user_pref.type_by_page = 0;
        }
        else if (!strncmp (line, "DX.delete_confirm: ", 19))
        {
            if (!strncmp (line+19, "YES", 3))
 
		cntrl_info_block.user_pref.delete_confirm = 1;
 
	    else if (!strncmp (line+19, "NO", 2))
 
		cntrl_info_block.user_pref.delete_confirm = 0;
        }
        else if (!strncmp (line, "DX.purge_confirm: ", 18))
        {
            if (!strncmp (line+18, "YES", 3))
 
		cntrl_info_block.user_pref.purge_confirm = 1;
 
	    else if (!strncmp (line+18, "NO", 2))
 
		cntrl_info_block.user_pref.purge_confirm = 0;
        }
        else if (!strncmp (line, "DX.auto_update: ", 16))
        {
            if (!strncmp (line+16, "YES", 3))
 
		cntrl_info_block.user_pref.auto_update = 1;
 
	    else if (!strncmp (line+16, "NO", 2))
 
		cntrl_info_block.user_pref.auto_update = 0;
        }
        else if (!strncmp (line, "DX.display_clock: ", 18))
        {
            if (!strncmp (line+18, "YES", 3))
 
		cntrl_info_block.user_pref.display_clock = 1;
 
	    else if (!strncmp (line+18, "NO", 2))
	    {
		cntrl_info_block.user_pref.display_clock = 0;
	    }
        }
        else if (!strncmp (line, "DX.flash_clock_colon: ", 22))
        {
            if (!strncmp (line+22, "ON", 2))
	    {
		cntrl_info_block.user_pref.update_in_second = 1;
	    }
	    else if (!strncmp (line+22, "OFF", 3))
	    {
		cntrl_info_block.user_pref.update_in_second = 0;
	    }
        }
    }
 
    fclose (f);
 
    return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**	tbs
**
**--
**/
int	custom_use_default()
{
    char errmsg[MAXFILESPEC+1];
 
    strcpy(errmsg, "Error set to default");
 
    return use_default("", "", errmsg);
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      tbs
**
**--
**/
int	use_default(nouse, dummy, errmsg)
char *nouse;
char *dummy;
char *errmsg;
{
    struct user_pref_tag default_settings =
    {				/**  Default setting and user preferences    **/
	0,			/**  Display with long form;		     **/
	DX_EDITOR_EDT,		/**  EDT for editor;			     **/
	DX_CREDATE,		/**  use creation date;			     **/
	1,			/**  pause type after each page;	     **/
	0,			/**  no delete confirm for individual file;  **/
	0,			/**  no purge confirm for individual file;   **/
	0,			/**  no re-read current directory after	     **/
				/**    edit, execute, and launch;	     **/
	1,			/**  display clock.			     **/
	0			/**  display clock every 60 seconds.	     **/
    };
 
    cntrl_info_block.user_pref = default_settings;
 
    return DX__NORMAL;
}
 
