 /*  *++  *  * Module: default.c  *  * Abstract:?  *	This module contains four routines for managing directories:   *	 D  *	1.) SET_DEFAULT changes the current working device and directory.C  *	    The algorithms used were based on the macro-32 code from set A  *	    the default routine. This routine should exhibits the same   *	    behavior.  *D  *	2.) GET_DEFAULT returns the current working directory in the user'  *	    supplied buffer (by descriptor.)   *<  *	3.) VALID_DEFAULT checks for the existence of a directoryC  *	    specification. If the directory does not exist, a message is C  *	    written to SYS$ERROR (and SYS$OUTPUT) and an error status is   *	    returned.  *F  *	4.) SHOW_DEFAULT writes the current default directory to sys$outputD  *	    including all translations for search lists. If the directoryE  *	    is invalid, a message is written to SYS$ERROR (and SYS$OUTPUT) '  *	    and an error status is returned.   *  * Environment: '  *	VAX/VMS operating system. User mode.   *
  * Author:  *	Eric M. LaFranchi  *  * Creation Date:   *	10-jun-1988  *  * Modification History:'  *	29-oct-1992	EML000	Eric M. Lafranchi    *	recode macro-32 routines in C  *  *--  */ ; #include <rms.h>			/* RMS for fab and nam block descrip  */ = #include <ctype.h>			/* Character Type Classification Mac  */ ; #include <ssdef.h>			/* Standard VMS messages code	      */ : #include <stdio.h>			/* Standard I/O definitions.	      */> #include <lnmdef.h>			/* logical name services definitions  */< #include <psldef.h>			/* process status definitions	      */> #include <stdlib.h>			/* Standard library definitions.      */> #include <string.h>			/* Standard string definitions.       */> #include <descrip.h>			/* VMS descriptor definitions.	      */  > #include "dirutl.h"			/* directory utility macros and def   */  %     /* external function declarations       */ = unsigned long int SYS$PARSE( const struct FAB * const, ... );   E unsigned long int SYS$SETDDIR( const struct dsc$descriptor_s * const, ! 			       unsigned short * const, , 			       struct dsc$descriptor_s * const );  > unsigned long int SYS$TRNLNM( const unsigned long int * const,/ 			      const struct dsc$descriptor_s * const, / 			      const struct dsc$descriptor_s * const, % 			      const unsigned char * const,  			      void * );  I unsigned long int LIB$SET_LOGICAL( const struct dsc$descriptor_s * const, - 				   const struct dsc$descriptor_s * const, - 				   const struct dsc$descriptor_s * const, & 				   const unsigned long int *const, 				   const void * const );  0 static const unsigned char acmode = PSL$C_SUPER;/ static const $DESCRIPTOR( lognam, "SYS$DISK" ); 3 static const $DESCRIPTOR( tabnam, "LNM$FILE_DEV" );      /*  *++  *  * Function: set_default( )   *  * Abstract:E  *	set_default changes the current working directory to the directory %  *	specified in the input descriptor.   *
  * Inputs:@  *	dirspec -- pointer to descriptor containing the new directory  *		   specification.   *  * Side effects:C  *	Current directory specification is changed to the one specified.   *  * Return Value:
  *	SS$_NORMAL   *	DIRUTL$_DIRECT /  *	any status return by the $SETDDIR or $TRNLNM   *  *--  */  unsigned long int ? set_default( const struct dsc$descriptor_s *const new_default )  { !     static $DESCALLOC( dirspec );        ITMLST itmlst[4]; #     long int max_index, attributes; 8     char tmpbuf[BUFSIZ], devbuf[BUFSIZ], dirbuf[BUFSIZ];     unsigned short int retlen;       register char *p, *q; %     register unsigned status, len, i;   F 	/* If directory specification specified is to long, then return error 	 */$     len = new_default->dsc$w_length;      if ( len > LNM$C_NAMLENGTH ) 	return ( DIRUTL$_DIRTOLONG );  5 	/* initialize item list and attempt to translate the  	 * directory specification. 	 */R     $ITEMINIT( itmlst, 0, sizeof( max_index ), LNM$_MAX_INDEX, &max_index, NULL );K     $ITEMINIT( itmlst, 1, sizeof( tmpbuf ), LNM$_STRING, tmpbuf, &retlen ); U     $ITEMINIT( itmlst, 2, sizeof( attributes ), LNM$_ATTRIBUTES, &attributes, NULL ); '     $ITEMINIT( itmlst, 3, 0, 0, 0, 0 );   D     status = SYS$TRNLNM( NULL, &tabnam, new_default, NULL, itmlst );=     if ( (status != SS$_NORMAL) && (status != SS$_NOLOGNAM) )  	return ( status );   * 	/* copy directory string into work buffer 	 */6     memcpy( devbuf, new_default->dsc$a_pointer, len );     devbuf[len] = '\0';   8 	/* if there is a translation, check for search list and
 	 * concealed  	 */     if ( status == SS$_NORMAL )      { B 	    /* if this is a search list or a concealed logical, make sure2 	     * there is a colon at the end of the string. 	     */9 	if ( (max_index > 0) || (attributes & LNM$M_CONCEALED) )  	{" 	    if ( devbuf[len - 1] != ':' ) 		strcat( devbuf, ":" ); 	} 	else if ( max_index == 0 )  	{& 	    memcpy( devbuf, tmpbuf, retlen ); 	    devbuf[retlen] = '\0';  	}     }   < 	/* translate the device name to a concealed device or until 	 * out of translations. 	 */     for ( i = 1;; i++ )      { 9 	    /* locate the device portion of the string including + 	     * node name an the directory portion.  	     */! 	if ( p = strchr( devbuf, ':' ) )  	{/ 		/* if this is a node name "::", then find end  		 * of device name  		 */  	    if ( p[1] == ':' ) ! 		if ( q = strchr( &p[2], ':' ) )  		    p = q; 	    *p++ = '\0';  	    if ( *p != '\0' ) 		strcpy( dirbuf, p );  4 		/* if the device name is SYS$DISK, get out of loop 		 */ ) 	    if ( !strcmp( "SYS$DISK", devbuf ) )  	    { 		devbuf[0] = '\0';  		break; 	    } 	} 	else  	{ 	    strcpy( dirbuf, devbuf ); 	    devbuf[0] = '\0'; 	    break;  	}  : 	    /* Translate the device name. If no translation, then 	     * were are done. 	     */ 	$DESCINIT( dirspec, devbuf );> 	status = SYS$TRNLNM( NULL, &tabnam, &dirspec, NULL, itmlst ); 	if ( status == SS$_NOLOGNAM ) 	    break;   / 	    /* if error status, then return bad status  	     */ 	if ( status != SS$_NORMAL )   	    return ( status );   F 	    /* if no translation, search list or concealed logical, were done 	     */: 	if ( (max_index != 0) || (attributes & LNM$M_CONCEALED) ) 	    break;   F 	    /* If a directory was specified in addition to a directory in the* 	     * translation, then report an error. 	     */9 	if ( (strchr( tmpbuf, '[' ) || strchr( tmpbuf, '<' )) &&  	     (dirbuf[0] != '\0') )  		return ( DIRUTL$_DIRECT );  9 	    /* Too many translations, something's really screwed  	     */ 	if ( i == LNM$C_MAXDEPTH )   	    return ( DIRUTL$_DIRECT );	  9 	    /* Copy translation back into the device name buffer  	     */" 	memcpy( devbuf, tmpbuf, retlen ); 	devbuf[retlen] = '\0';      }   B 	/* create the supervisor mode logical SYS$DISK if the device name$ 	 * is present in the specification. 	 */     if ( devbuf[0] != '\0' )     {  	strcat( devbuf, ":" );  	$DESCINIT( dirspec, devbuf );D 	status = LIB$SET_LOGICAL( &lognam, &dirspec, &tabnam, NULL, NULL );( 	if ( !(status & 1) ) return ( status );     }   = 	/* set the directory portion of the specification if present  	 */     if ( dirbuf[0] != '\0' )     {  	$DESCINIT( dirspec, dirbuf );. 	status = SYS$SETDDIR( &dirspec, NULL, NULL );) 	if ( !(status & 1 ) ) return ( status );      }        return ( SS$_NORMAL ); }    /*  *++  * Function: get_default( )   *  * Abstract:G  *	This function constructs the current working directory specification E  *	and write it into the users buffer. The device name for the string J  *	is found by translating the SYS$DISK logical name and then concatenatedE  *	with the current directory specification, return by the RMS system   *	service SYS$SETDDIR.   *
  * Inputs:  *	None   *  * Outputs: C  *	Current directory specification is written into the users buffer   *	(by descriptor)  *  * Return Value:C  *	SS$_NORMAL or and status return by the SYS$SETDDIR or SYS$TRNLMN   *	system services.   *  *--  */  unsigned long int 5 get_default( struct dsc$descriptor_s *const dirspec )  {       static $DESCALLOC( dirbuf );       ITMLST itmlst[2];      char devbuf[MAXDIRLEN * 2];      unsigned short int retlen;       register status;  / 	/* initialize item list and translate SYS$DISK  	 */K     $ITEMINIT( itmlst, 0, sizeof( devbuf ), LNM$_STRING, devbuf, &retlen ); '     $ITEMINIT( itmlst, 1, 0, 0, 0, 0 );   C     status = SYS$TRNLNM( NULL, &tabnam, &lognam, &acmode, itmlst ); ,     if ( !(status & 1 ) ) return ( status );  : 	/* append the directory specification to the device name. 	 */D     $DESCFILL( dirbuf, sizeof( devbuf ) - retlen, &devbuf[retlen] );@     status = SYS$SETDDIR( NULL, &dirbuf.dsc$w_length, &dirbuf );,     if ( !(status & 1 ) ) return ( status );  "     retlen += dirbuf.dsc$w_length;  < 	/* compute the return status and copy the current directory) 	 * specification to the supplied buffer.  	 */)     if ( dirspec->dsc$w_length < retlen )      {   	retlen = dirspec->dsc$w_length; 	status = SS$_BUFFEROVF;     }      else     {   	dirspec->dsc$w_length = retlen; 	status = SS$_NORMAL;      }   5     memcpy( dirspec->dsc$a_pointer, devbuf, retlen );        return ( status ); }    /*  *++  * Function: valid_default( )   *  * Abstract:A  *	This function takes a string descriptor containing a directory A  *	specification. If the directory specification does not exists, A  *	a message is printed to SYS$OUTPUT and SYS$ERROR (if different   *	from SYS$OUTPUT).  *
  * Inputs:<  *	dirspec -- pointer to descriptor containing the directory%  *		   specification to be validated.   *  * Outputs:   *	None   *  * Return Value:  *	SS$_NORMAL or DIRUTL$_INVDIR   *  *--  */  unsigned long int = valid_default( const struct dsc$descriptor_s *const dirspec )  { ,     char esa[(NAM$C_MAXRSS + 0x0F) & ~0x0F];     struct FAB fab;      struct NAM nam; 
     struct     {  	unsigned short	argcnt;  	unsigned short	msg_opt; 	unsigned long	msg_cod;  	unsigned short	fao_cnt; 	unsigned short	new_opt; 	unsigned long	fao1; 	char *		fao2; 	unsigned long	msg_cod1;
     } msgvec;        register status;  " 	/* initialize RMS data structures 	 */     nam = cc$rms_nam;      nam.nam$l_esa = esa;!     nam.nam$b_ess = NAM$C_MAXRSS;      fab = cc$rms_fab;      fab.fab$l_nam = &nam;      fab.fab$l_fop = FAB$M_NAM;+     fab.fab$l_fna = dirspec->dsc$a_pointer; *     fab.fab$b_fns = dirspec->dsc$w_length;  5 	/* determine if the directory specification is valid  	 */     status = SYS$PARSE( &fab );      if ( status & 1 )  	return ( SS$_NORMAL );   5 	/* build message vector and give message to the user  	 */     msgvec.argcnt = 5;     msgvec.msg_opt = 0x0f;$     msgvec.msg_cod = DIRUTL$_INVDEF;     msgvec.fao_cnt = 2;      msgvec.new_opt = 0x0f;(     msgvec.fao1 = dirspec->dsc$w_length;)     msgvec.fao2 = dirspec->dsc$a_pointer;      msgvec.msg_cod1 = status;     )     SYS$PUTMSG( &msgvec, NULL, NULL, 0 );        return ( DIRUTL$_INVDEF ); }    /*  *++  *  * Function: show_default( )  *  * Abstract:H  *	show_default write the current directory specification to sys$output,8  *	including search-lists and screwed SYS$DISK logicals.  *  * Implicit Inputs: &  *	The current directory specification  *  * Outputs: F  *	Writes the current device and directory specification to sys$output  *  * Return Value:C  *	SS$_NORMAL or any status return by the SYS$SETDDIR or SYS$TRNLNM   *  *--  */  unsigned long int  show_default( )  {       static $DESCALLOC( curdir );       struct FAB fab;      struct NAM nam;      void *msgvec[6];     ITMLST itmlst[2];      char tranlation[BUFSIZ];+     char esa[(NAM$C_MAXRSS + 0x0F) & 0x0F];        unsigned short int retlen;"     register unsigned status, tmp;  5 	/* initialize item list and attempt to translate the  	 * directory specification. 	 */S     $ITEMINIT( itmlst, 0, sizeof( tranlation ), LNM$_STRING, tranlation, &retlen ); '     $ITEMINIT( itmlst, 1, 0, 0, 0, 0 );   @     status = SYS$TRNLNM( NULL, &tabnam, &lognam, NULL, itmlst );     if ( !(status & 1) ) 	return ( status );   & 	/* mark end of the translation string 	 */     tranlation[retlen] = '\0';  = 	/* if sys$disk contains a directory, then output the current  	 * directory on the next line 	 */A     if ( strchr( tranlation, '<' ) || strchr( tranlation, '[' ) )      { $ 	strcat( tranlation, "\n  [] =  " ); 	retlen = strlen( tranlation );      }   + 	/* get the directory specification portion  	 */L     $DESCFILL( curdir, sizeof( tranlation ) - retlen, &tranlation[retlen] );@     status = SYS$SETDDIR( NULL, &curdir.dsc$w_length, &curdir );,     if ( !(status & 1 ) ) return ( status );  4     tranlation[curdir.dsc$w_length + retlen] = '\0';  1 	/* write the directory specification to the user  	 */*     fprintf( stdout, "  %s", tranlation );  B 	/* initialize RMS data structures to parse and retrun search-list 	 * members  	 */     nam = cc$rms_nam;      nam.nam$l_esa = esa;!     nam.nam$b_ess = NAM$C_MAXRSS; "     nam.nam$b_nop = NAM$M_SLPARSE;     fab = cc$rms_fab;      fab.fab$l_nam = &nam;      fab.fab$b_fns = 0;0     fab.fab$l_fop = FAB$M_NAM; /*| FAB$M_PPF; */  ; 	/* parse the directory specification until all search list   	 * translations have been found 	 */     for ( ;; )     {  	status = SYS$PARSE( &fab ); 	if ( !(status & 1) )  	    return( SS$_NORMAL );  , 	if ( !(NAM$M_SEARCH_LIST & nam.nam$l_fnb) ) 	    return( SS$_NORMAL );  6 	    /* Put NULL terminator on the translation string,- 	     * remove the '.;', write it to the user  	     */ 	esa[nam.nam$b_esl - 2] = '\0'; & 	fprintf( stdout, "\n  =   %s", esa );     }  } 