 1  routine tti$print_option            ! PRINT_OPTION.INC	         ! B         ! Print out a list file to screen, printer port, or system         ! printer 	         !          ! HISTORY:I         !       16-MAR-1989 jrw  Support for form types DEFAULT and ONEUP H         !        2-Aug-1989 rpr  Allow them to use LAS and laserprint itD         !       13-Feb-1990 amr  Add facility for default and copies2         !       13-May-1991 djs  Added save optionM         !       06-nov-92   djs  Added wide/narrow options for system printer A         !       21-Dec-1992 amr  Build up the OPTS_CHOSEN$ string C         !       11-Jan-1992 amr  add _BACK and _EXIT to OPT_CHOSEN$ K         !       30-Jun-1994 amr  trap bad disk or directory or ??? on SAVE. 	         ! E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% ?         ! A S K   F O R   P R I N T   O U T P U T   O P T I O N E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! /         ! Ask for the print output file option. 	         !          ! EXPECTED: B         !       u_str$       = file name of the list file to print+         !       u_scr_width% = screen width H         !       u_dispatch$  = routine to dispatch to after clear screenD         !                      (u_dispatch$ is cleared on reference)I         !       u_help$      = help topic (if u_help$ is not null then it H         !                      is assumed tti_run:help.inc is %included)@         !                      (u_help$ is cleared on reference)4         !       u_default$   = default output option8         !       u_copies%    = number of copies to print?         !       tti_delete_after_print = is set by init routine J         !               if true and report hasn't been queued to a spooler<         !               then will delete the file at the endI         !       tti_report_queued is set by the print routine to indicate ?         !               that the report was queued to a spooler 	         ! E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%      prnt_ask_option:           gosub prnt_init          gosub prnt_build_menu 
         doG           line input menu po_menu$, default po_menu_default$ : u_reply$            if  (_back)  then 8             opts_chosen$ = opts_chosen$ + ("BACK" + ",")             exit do            end if           if  (_exit)  then 8             opts_chosen$ = opts_chosen$ + ("EXIT" + ",")             exit do            end if           if  (_help)  then              gosub prnt_do_help             repeat do            end if           print at 22, 1:;+           prnt_opt$ = ucase$(u_reply$[1:3])            select case prnt_opt$ ,           case "SCR"    : gosub screen_print*           case "PRI"    : gosub port_print.           case "SYS"    : gosub prnt_sys_print0           case "LAS"    : gosub prnt_laser_print0           case "SAV"    : gosub prnt_save_report           case else              gosub prnt_to_queue            end select9           opts_chosen$ = opts_chosen$ + (prnt_opt$ + ",") ?                 ! build up a string of the chosen print options            clear .           set window : current po$save_window$         loop  *         if  tti_delete_after_print  and  &C             not  tti_report_queued  then  kill po$print_file$ + ';' 6                 ! kill the file if they asked for thisC                 ! don't do it if the report was queued to a printer            return      I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          ! P R N T - I N I T I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         !          ! EXPECTED: !         !   u_additional_queues$  F         !                      any additional queue options to present4         !       u_str$           = filename to printH         !       u_dispatch$      = routine to run before showing options4         !       u_help$          = help segment name7         !       u_default$       = default print option <         !       u_copies%        = number of copies to printI         !       u_delete%        = true if file should be deleted on exit G         !       tti_print_options is a symbol that might be defined. if E         !       so then it contains comma seperated commands such as  :         !       delete for delete print file when finished	         !          ! RESULT: "         !   po$additional_queues$ ;         !                      additional queues to present 6         !       po$print_file$     = filename to printH         !       po$dispatch$     = routine to run before showing options4         !       po$help$         = help segment name7         !       po$default$      = default print option <         !       po$copies%       = number of copies to printB         !       po$max_screens%  = maximum number of saved screensJ         !       po$screen$()     = array of saved screens (for backing up).         !       po$delete%       = delete flag9         !       original_margin% = saved, original margin >         !       tti_print_options$ = any options set by symbolM         !       tti_delete_after_print = true if print file should be deleted @         !       tti_report_queued = false.  No report queued yet	         ! I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%            routine prnt_init            clear !           po$print_file$ = u_str$            u_str$       = '' $           po$dispatch$ = u_dispatch$           u_dispatch$  = ''             po$help$     = u_help$           u_help$      = '' 5           po$default$  = ucase$(unquote$(u_default$))            u_default$   = "" O           if  po$default$ = ""  then  po$default$ = "SCREEN"  !++amr++ 02-13-90 "           po$copies%   = u_copies%           u_copies%    = 0% O           if  po$copies% = 0%  then  po$copies% = 1%          !++amr++ 02-13-90 "           po$delete%   = u_delete%           u_delete%    = false6           po$additional_queues$ = u_additional_queues$#           u_additional_queues$ = '' !           po$max_screens% = 1000% )           dim po$screen$(po$max_screens%) %           ask margin original_margin% #           gosub check_laser_printer &           gosub process_options_symbol#           tti_report_queued = false            opts_chosen$ = "" 8                 ! string of print options chosen by user!                 !++amr++ 12/21/92 #           if po$dispatch$ = '' then ?             message "Ready to print " + lcase$(po$print_file$)             else!             dispatch po$dispatch$            end if.           ask window : current po$save_window$         end routine       J 12000   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5         ! P R O C E S S   O P T I O N S   S Y M B O L J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         !          ! Brief description:H         !  translate the tti_print_options symbol and set up the related         !  fields          ! Expected: C         !   po$delete%         field saying this file to be deleted 	         !          ! Locals: 4         !   tti_print_options$ translation of symbol	         !          ! Results:F         !   tti_narrow_print$  print narrow command for system printerD         !   tti_wide_print$    print wide command for system printer#         !   tti_delete_after_print  =         !                      true if file should be deleted 	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%&         routine process_options_symbolK           ask system, symbol "tti_print_options" : value tti_print_options$ ;           if  match(tti_print_options$, 'DELETE') > 0  then )             tti_delete_after_print = true            else*             tti_delete_after_print = false           end if=           if  po$delete%  then  tti_delete_after_print = true            tti_wide_print$ = ''.           z = item(tti_print_options$, 'WIDE')           if  z > 0 then &N             tti_wide_print$ = element$(element$(tti_print_options$,z), 2, ' ')            tti_narrow_print$ = ''0           z = item(tti_print_options$, 'NARROW')           if  z > 0 then &P             tti_narrow_print$ = element$(element$(tti_print_options$,z), 2, ' ')         end routine       E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 0         !  C H E C K   L A S E R   P R I N T E RE         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% D         !  Check to see if they have a logical "laser".  If they do,2         !    allow them to use "LAS" as an option.E         !  Expects:  There is a logical "laser" set up if they have a %         !               laser printer B         !  Result:   have_laser% = true or false, depending on the9         !               existence of the "laser" logical. E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%      check_laser_printer:  -         ask system, symbol "laser": value z0$   !         have_laser% = (z0$ <> "")            return      E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% ;         ! S H O W   P R I N T   O U T P U T   O P T I O N S E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! 9         ! Display the print output options on the screen. 	         ! E         ! po$dispatch$ <> ''  if a routine to dispatch to after clear ?         ! have_laser% = true if they can say "LAS" and laser it E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%            routine prnt_build_menu            laser_opt$ = '' C           if  have_laser% then laser_opt$ = '"Laser Printer"=las, ' B           po_menu$ = '%title " Output Options ", %at 18, center, '-           if  po$additional_queues$ = '' then .             po_menu$ = po_menu$ + '%items 2, '           else.             po_menu$ = po_menu$ + '%items 3, '           end ifB           po_print_opt$ = '"Screen"=SCR, "Printer Port"=pri, ' + &E             '"System Printer"=sys, "Save to Disk"=sav, ' + laser_opt$ ?           if  have_laser% then po$result$ = po$result$ + ',LAS' 6           for z = 1 to elements(po$additional_queues$)3             z$ = element$(po$additional_queues$, z) 5             po_print_opt$ = po_print_opt$ + z$ + ', '            next z           z1 = len(po$default$) .           for z = 1 to elements(po_print_opt$)+             z$ = element$(po_print_opt$, z) 8             z1$ = ucase$(unquote$(element$(z$, 1, '='))),             if  po$default$ = z1$[1:z1] then.               po_menu_default$ = '#' + str$(z)               exit for             end if           next z6           po_menu$ = po_menu$ + po_print_opt$ + 'exit'         end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% !         ! P R N T - D O _ H E L P I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         !          ! Take care "HELP"	         !          ! EXPECTED: 0         !       po$help$    = help segment name.;         !       po$print_file$      = name of file to print 	         !          ! RESULT: 0         !       help_topic$ = help segment name.	         !          !++amr++ 02/13/90 I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%      prnt_do_help:   !         if  (po$help$ = '')  then C           message "Select where to print " + lcase$(po$print_file$)          else           clear             help_topic$ = po$help$           dispatch "help"          end if           return      E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% A         ! P R I N T   R E P O R T   T O   P R I N T E R   P O R T E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! $         ! Print to the printer port.	         !          ! EXPECTED: 4         !       u_scr_width%     = screen/file widthH         !       po$print_file$           = name of the file to print out<         !       po$copies%       = number of copies to print>         !       original_margin% = original/saved screen width	         ! E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   
   port_print:   
         clear          set margin u_scr_width%          print at 1, 1:;            set port on   &         for copies% = 1% to po$copies%           prnt_ch = _channel;           open #prnt_ch : name po$print_file$, access input              do             when exception in )               line input #prnt_ch : text$              use              end when             if  _error  then                 set error off                exit do              end if             print text$            loopL           print chr$(12) ! force final form feed so that laser printers willI                          ! print the last page. won't hurt other printers            close #prnt_ch         next copies%           set port off#         set margin original_margin%            set port on          set port off           return      I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %         ! P R N T _ S Y S _ P R I N T I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! 1         ! Print to system print  OR  other queue.          ! Ask for queue to use. 	         !          ! EXPECTED: <         !       po$print_file$      = name of file to print.8         !       po$copies%  = number of copies to print.N         !       tti_delete_after_print = true if they want report file deleted	         !          ! RESULT: +         !       queue_name$ = queue to use. I         !       tti_report_queued = true to indicate that the report file <         !                       has been queued to a spooler	         !          !++amr++ 02/13/90 I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%      prnt_sys_print:             clear area 18, 1, 19, 80  !         gosub setup_default_queue A         message "Enter any queue qualifiers after the queue name" 
         do           line input &%             prompt "Print queue? ", & '             default tti_sys_default$, &              length 60, &             at 21, 1 : &             u_reply$  1           if  (_exit)  or  (_back)  then  exit do              if  (_help)  then >             message "Enter the name of the print queue to use"             repeat do            end if              queue_name$ = u_reply$              gosub prnt_set_up_pass*           if  tti_delete_after_print  then             z$ = "print/delete"            else             z$ = "print"           end if           pass z$ + & 6                      "/copies=" + str$(po$copies%) + &H                      "/noidentify/notify/queue=" + queue_name$ + ' ' + &#                      po$print_file$            gosub prnt_check_pass $           if  error  then  repeat doM           tti_report_queued = true ! set flag saying a report has been queued          end do           return      J 13000   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%/         ! S E T U P   D E F A U L T   Q U E U E J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         !          ! Brief description:1         !   set up the default system print queue          ! Expected: 1         !   tti_narrow_print$  print narrow queue /         !   tti_wide_print$    print wide queue 	         !          ! Locals: 	         !          ! Results:,         !   tti_sys_default$   default queue	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#         routine setup_default_queue (           tti_sys_default$ = "SYS$PRINT"%           if  u_scr_width% > 80  then M             if  tti_wide_print$ <> '' then tti_sys_default$ = tti_wide_print$            elseQ             if  tti_narrow_print$ <> '' then tti_sys_default$ = tti_narrow_print$            end if         end routine       J 14000   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#         ! P R N T   T O   Q U E U E J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         !          ! Brief description:6         !   user selected one of the additional queues3         !   set up a generic command to pass to DCL 	         !          ! Expected: 9         !   u_reply$           queue name from input menu 	         !          ! Locals: 	         !          ! Results:*         !   tti_report_queued  set to true	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine prnt_to_queue 2           queue_name$ = u_reply$ ! from input menu            gosub prnt_set_up_pass*           if  tti_delete_after_print  then&             z$ = "print/delete/queue="           else             z$ = "print/queue="            end if#           pass z$ + queue_name$ + & 6                      "/copies=" + str$(po$copies%) + &.                      "/noidentify/notify " + &#                      po$print_file$            gosub prnt_check_pass            if  error  then   $             message error : systext$             exit routine           end ifM           tti_report_queued = true ! set flag saying a report has been queued          end routine       I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% )         ! P R N T _ L A S E R _ P R I N T I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! :         ! Print to laser printer  IF  there is one set up.	         !          ! EXPECTED: D         !       have_laser%      = TRUE  if  symbol LASER is set up.A         !       po$print_file$           = name of file to print. :         !       u_scr_width%     = width of file to print.=         !       po$copies%       = number of copies to print. 	         !          ! RESULT: ;         !       laser_qualifier$ = LASER command qualifier. 	         !          !++amr++ 02/13/90 I         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%      prnt_laser_print:            if  have_laser%  then %           if  u_scr_width% > 80  then #             laser_qualifier$ = '/L'            else#             laser_qualifier$ = '/F'            end if  (           for copies% = 1% to po$copies%C             pass 'laser ' + po$print_file$ + ' ' + laser_qualifier$ !             gosub prnt_check_pass %             if  error  then  exit for            next copies%         else7           message error : "Invalid option: " + u_reply$          end if           return      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)         ! P R N T   S A V E   R E P O R T J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         ! 	         !          ! Expected: 	         !          ! Result  : 	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          routine prnt_save_report            clear area 18, 1, 19, 80-         po$filespec$ = lcase$(po$print_file$) %         gosub po$break_apart_filespec L         po$save_filename$ = po$disk$ + po$directory$ + po$filename$ + '.lis'
         do           line input &-             prompt "Filename to save as? ", & (             default po$save_filename$, &             length 60, &             at 21, 1 : &             u_reply$1           if  (_exit)  or  (_back)  then  exit do            if  (_help)  then >             message "Enter the name to save this report under"             repeat do            end if)           po$filespec$ = lcase$(u_reply$) '           gosub po$break_apart_filespec L           if  po$extension$ = ''  then  po$filespec$ = po$filespec$ + '.lis'D           message "Saving " + po$print_file$ + " as " + po$filespec$  K           !++amr++ 06/30/94 -- code below deleted.  replacement code below. =           !pass "copy " + po$print_file$ + " " + po$filespec$             !gosub prnt_check_pass%           !if  error  then  repeat do K           !++amr++ 06/30/94 -- code above deleted.  replacement code below.   .           !++amr++ 06/30/94 -- begin new code.  J           pass "set message/nofacility/noidentification/noseverity/notext"  <           pass "copy " + po$print_file$ + " " + po$filespec$  !           systext_msg$ = systext$   (           ask system, pass : success ok?  B           pass "set message/facility/identification/severity/text"             if  not ok?  then (             message error : systext_msg$             repeat do            end if  ,           !++amr++ 06/30/94 -- end new code.         end do           end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%7         ! P O $ B R E A K   A P A R T   F I L E S P E C J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%G         ! take a file spec and return the disk, directory, filename and          ! extension 	         !          ! Expected: (         !       po$filespec$ = file spec	         !          ! Result  : $         !       po$disk$      = disk)         !       po$directory$ = directory (         !       po$filename$  = filename)         !       po$extension$ = extension 	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'         routine po$break_apart_filespec            po$disk$      = ""         po$directory$ = ""         po$filename$  = ""         po$extension$ = ""         z1 = 1&         z = pos(po$filespec$, ":", z1)         if  z > 0  then   '           po$disk$ = po$filespec$[z1:z]            z1 = z + 1         end if&         z = pos(po$filespec$, "]", z1)         if  z > 0  then   ,           po$directory$ = po$filespec$[z1:z]           z1 = z + 1         end if&         z = pos(po$filespec$, ".", z1)         if  z > 0  then   -           po$filename$ = po$filespec$[z1:z-1]            z1 = z + 1=           po$extension$ = po$filespec$[z+1:len(po$filespec$)]          end if           end routine       E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% )         ! P R N T _ S E T _ U P _ P A S S E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%      prnt_set_up_pass:   "         !clear ++DJS++ 03-MAR-1993A         !z1$ = "Submitting " + po$print_file$ ++DJS++ 03-MAR-1993 L         !z1% = (original_margin% / 2%) - (len(z1$) / 2%) ++DJS++ 03-MAR-19933         !print at 10, z1% : z1$ ++DJS++ 03-MAR-1993 <         message delay : 'Submitting '; po$print_file$; '...'         return      E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% '         ! P R N T _ C H E C K _ P A S S E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%      prnt_check_pass:  &         ask system, pass : success z1%           error = (z1% = false)   +         if  error  then  message error : ""            return      E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 5         ! P R I N T   R E P O R T   T O   S C R E E N E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! *         ! Print a list file to the screen.	         !          ! EXPECTED: ;         !        First heading line begins with a CHR$(12%) 6         !        All heading lines end with a CHR$(0%)E         !        po$print_file$ = name of the .list file to print out ,         !        u_scr_width% = screen width	         ! E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%      screen_print:   
         clear          print at 1, 1:;          set margin u_scr_width%          prnt_ch = _channel9         open #prnt_ch : name po$print_file$, access input          po$screen_ctr% = 0%          head_lines% = 0%         first_page% = true  
         do           when exception in '             line input #prnt_ch : text$              eof% = false
           use              eof% = true            end when             if  eof%  then             delay 1             if _back or _terminator = 'PREV' then                 gosub do_back_page               repeat do              end if             exit do            end if  0           if  right$(text$, 1%) = chr$(0%)  then+             gosub screen_print_heading_line 3             if  po$do_delay and _exit  then exit do *             if  po$do_delay and _back then                gosub do_back_page               repeat do              end if             iterate do           end if  #           ask window: row line_ctr% +           if  line_ctr% = head_lines%  then >             clear area head_lines% + 1%, 1%, 22%, u_scr_width%           end if  #           ask window: row line_ctr% $           if  line_ctr% >= 22%  then             delay 2             if _back  or _terminator = 'PREV' then                gosub do_back_page               repeat do              end if#             if  _exit  then exit do   >             clear area head_lines% + 1%, 1%, 22%, u_scr_width%+             print at head_lines% + 1%, 1%:;            end if             print text$          loop           close #prnt_ch#         set margin original_margin%            return      E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% =         ! P R I N T   R E P O R T   H E A D I N G   L I N E S E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! .         ! This routine is used by SCREEN_PRINT	         !          ! EXPECTED: =         !        text$ = text line (that ends with a CHR$(0%) 	         ! E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%      screen_print_heading_line:           po$do_delay = false   .         if  left$(text$, 1%) = chr$(12%)  then           if  first_page%  then              first_page% = false            else             delay              po$do_delay = trueD             if  _exit  or _back  or _terminator = 'PREV' then return           end if             clear            print at 1%, 1%:;            text$ = text$[2:999]           head_lines% = 0%.           po$screen_ctr% = po$screen_ctr% + 1%:           ask #prnt_ch: current po$screen$(po$screen_ctr%)         end if           print text$   &         head_lines% = head_lines% + 1%           return      E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% #         ! B a c k   o n e   p a g e E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 	         ! '         ! Causes us to go back one page 	         ! E         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%      do_back_page:   "         select case po$screen_ctr%         case 0%            close #prnt_ch           prnt_ch = _channel;           open  #prnt_ch: name po$print_file$, access input ?           po$screen_ctr% = 1%  ! no pages is just like one page          case 1% :           set #prnt_ch: current po$screen$(po$screen_ctr%)         case else .           po$screen_ctr% = po$screen_ctr% - 1%:           set #prnt_ch: current po$screen$(po$screen_ctr%)         end select  B         po$screen_ctr% = po$screen_ctr% - 1%  ! to repeat this one@         first_page% = true  ! act like the first page (no DELAY)         head_lines% = 0%           return      end routine ! tti$print_option