! #module NFS$MSX_LOADER "V1.0-006"  #pragma builtins   /* ** COPYRIGHT (c) 1993 BY9 ** DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.  ** ALL RIGHTS RESERVED.  **H ** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDH ** ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THEH ** INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHERH ** COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANYH ** OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY ** TRANSFERRED.  **H ** THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICEH ** AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT ** CORPORATION.  **H ** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS: ** SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL. */   /* **++% **  FACILITY:  DEC MultiSIX For SEVMS  ** **  MODULE DESCRIPTION:  **E **      Scans the specified directory, performing a token translation @ **	on the classification blocks associated with each file.  This> **	forces all tokens into memory in the token mapping process. ** **  AUTHOR:  ** **      Steve Hoffman  **	Hoffman@xdelta.enet.dec.com$ **	DEC TNSG NSM Security Engineering ** **  CREATION DATE:  28-Jan-1993  ** **  DESIGN ISSUES: ** **      no major design issues ** **  MODIFICATION HISTORY:  ** **-- */ #include <acedef.h>  #include "msxsrc:$arbdef.h"  #include <atrdef.h>  #include <clsdef.h>  #include <descrip.h> #include <fibdef.h>  #include <iodef.h> #include "msxsrc:itemlist.h" #include "msxsrc:$pcbdef.h"  #include <psldef.h>  #include "msxsrc:$prvdef.h"  #include <rms.h> #include <ssdef.h> #include <stdio.h> #include <stsdef.h>  #include <syidef.h>    struct NFS$$MSXCTX     {      unsigned short int qiochan;       unsigned short int qiosb[4];      unsigned long int filecount;     int lfs_context;     char *rsa;     char *esa;     struct clsdef cls;     struct FAB fab;      struct RAB rab;      struct NAM nam;      struct fibdef fib;     struct atrdef atr[5];      };    * main( int argc, char **argv, char **envp )     {      int retstat;2     static int NFS$MSX_macscan_ok( struct FAB * );2     static int NFS$MSX_macscan_ng( struct FAB * );.     $DESCRIPTOR( dirspec, "SYS$SYSTEM:*.*;*");  +     retstat = NFS$MSX_macscan( &dirspec, 0, * 	NFS$MSX_macscan_ok, NFS$MSX_macscan_ng );     return SS$_NORMAL;     }    /* **++ **  FUNCTIONAL DESCRIPTION:  **F **      NFS$MSX_macscan accepts a file or, more typically, a directoryB **	specification; it then loads the mandatory access control (MAC)4 **	class block for each file (successfully) located. ** **  FORMAL PARAMETERS: **1 **      filspec		file specification (via descrip) 4 **	defspec		default file specification (via descrip)? **	rtn_success	address of routine to be called on success (ref) ? **	rtn_failure	address of routine to be called on failure (ref)  ** **  RETURN VALUE:  **? **      SS$_NORMAL (low bit set) on success, failure otherwise.  ** **  SIDE EFFECTS:  **D **      the primary side effect involves the development of a strong4 **	desire to code an RMS-level interface into SEVMS. ** **  DESIGN:  **< **      A simple directory scanner, using various RTL calls. ** **  PRECONDITIONS: **    C **  	Expects to be called with READALL or BYPASS privileges -- this @ **	routine requires sufficient access to read all classification
 **	labels. **     **-- */: extern int NFS$MSX_macscan(struct dsc$descriptor *filspec,H     struct dsc$descriptor *defspec, int *rtn_success, int *rtn_failure )     {      int retstat, retstat_x; 9     int (*rtn_ok)( struct FAB * ) = (void *) rtn_success; 9     int (*rtn_ng)( struct FAB * ) = (void *) rtn_failure; 
     int i;     struct il3def il[10];      struct clsdef class_mask; %     struct NFS$$MSXCTX context, *ctx;      char rsa[NAM$C_MAXRSS+1];      char esa[NAM$C_MAXRSS+1]; -     $DESCRIPTOR( sysdisk, "SYS$SYSDEVICE:" );        /*A     **	The target file specification address, or the default file A     **	specification address, or both, must be non-zero.  Failure @     **	to specify at least one of these addresses is an error...     */0     if (  (!(int) filspec) && (!(int) defspec) ) 	return SS$_BADPARAM;        /*E     **	Just for grins, move the context block address into a pointer. C     **	This is sheer laziness on my part -- with this assignment, I ?     **	can now use the same "->" C syntax all over the place...      */     ctx = &context;        /*F     **	Initialize the context, implicitly including the initializationF     **	of the FAB, NAM, ATR and FIB blocks, and then flip a few bits n2     **	bytes in various structures here and there.     */2     memset( ctx, 0, sizeof( struct NFS$$MSXCTX) );       ctx->esa = esa;      ctx->rsa = rsa;     #     ctx->fab.fab$b_bid = FAB$C_BID; #     ctx->fab.fab$b_bln = FAB$C_BLN; #     ctx->nam.nam$b_bid = NAM$C_BID; #     ctx->nam.nam$b_bln = NAM$C_BLN;   #     ctx->fab.fab$l_nam = &ctx->nam;      ctx->fab.fab$l_xab = 0;   #     ctx->fab.fab$l_fop = FAB$M_NAM;   &     ctx->nam.nam$b_rss = NAM$C_MAXRSS;"     ctx->nam.nam$l_rsa = ctx->rsa;&     ctx->nam.nam$b_ess = NAM$C_MAXRSS;"     ctx->nam.nam$l_esa = ctx->esa;       /*D     **	Pass the context address via the FAB context.  (We could haveC     **	accomplished the same thing by a bias back by the FAB offset B     **	in the context structure, but that technique can get ugly.)     */     ctx->fab.fab$l_ctx = ctx;        /*E     **	Start with no files... (not really needed -- due to memset().)      */     ctx->filecount = 0;        /*<     **	Allow for defaulting of either the file specification)     **	or the default file specification.      */     if ( (int) filspec ) 	{- 	ctx->fab.fab$l_fna = filspec->dsc$a_pointer; , 	ctx->fab.fab$b_fns = filspec->dsc$w_length; 	}       if ( (int) defspec ) 	{- 	ctx->fab.fab$l_dna = defspec->dsc$a_pointer; , 	ctx->fab.fab$b_dns = defspec->dsc$w_length; 	}       /*B     **	Assign a channel to j-random disk device -- this channel isA     **	used primarily to chat with the XQP to read and write file F     **	attributes, and is not particularly used to read or write data.     */C     retstat = sys$assign( &sysdisk, &ctx->qiochan, PSL$C_USER, 0 ); B     if (!$VMS_STATUS_SUCCESS( retstat )) goto NFS$MSX_macscan_err;       ctx->lfs_context = 0; L     retstat = lib$file_scan( &ctx->fab, rtn_ok, rtn_ng, &ctx->lfs_context );B     if (!$VMS_STATUS_SUCCESS( retstat )) goto NFS$MSX_macscan_err;  @     retstat = lib$find_file_end( &ctx->fab, &ctx->lfs_context );B     if (!$VMS_STATUS_SUCCESS( retstat )) goto NFS$MSX_macscan_err;  6     printf("Total of %8.8d files\n", ctx->filecount );   NFS$MSX_macscan_err:(     printf("NFS$MSX_macscan() done.\n");+     retstat_x = sys$dassgn( ctx->qiochan );        return retstat;      }        /* **++ **  FUNCTIONAL DESCRIPTION:  **? **      Gets called repeatedly, each time getting handed a FAB. ; **	Using the information in the FAB, lock and load the info 7 **	necessary to retrieve a class block, and go get one.  **	  **  FORMAL PARAMETERS: **9 **      FAB	Address of an RMS file access block structure  ** **  RETURN VALUE:  *** **      SS$_NORMAL or low bit set, success) **	SS$_BADPARAM or low bit clear, failure  ** **  SIDE EFFECTS:  ** **      Chews up some I/O  ** **  DESIGN:  **A **      Performs some extra processing necessitated by SEVMS; the < **	class block information not available directly at the RMS2 **	level, it is available solely at the XQP level. ** **-- */0 static int NFS$MSX_macscan_ok( struct FAB *fab )     {      int retstat, retstat_x;      int qiofunc;
     int i;!     struct dsc$descriptor fib_d = > 	{ sizeof( struct fibdef ), DSC$K_DTYPE_Z, DSC$K_CLASS_S, 0 };     unsigned short int *didfid;      struct fibdef *fib;      struct atrdef *atr;      struct NAM *nam;     struct NFS$$MSXCTX *ctx;       ctx = fab->fab$l_ctx;        fib = (char *) &ctx->fib; '     fib_d.dsc$a_pointer = (char *) fib;      atr = &ctx->atr;     nam = &ctx->nam;       fib->fib$l_aclctx = 0;-     fib->fib$r_acctl_overlay.fib$l_acctl = 0;        /*=     **	Go read the file identification (FID) value -- a value =     **	unique across the particular volume -- associated with      **	the file.     **=     **	Set the File ID and the Directory ID appropriately for *     **	the upcoming $QIOW IO$_ACCESS call.     */3 #define DIDDRECK fib$r_did_overlay.fib$r_did_fields $     fib->DIDDRECK.fib$w_did_num = 0;$     fib->DIDDRECK.fib$w_did_seq = 0;:     fib->DIDDRECK.fib$r_did_rvn_overlay.fib$w_did_rvn = 0;       didfid = &nam->nam$w_fid; 3 #define FIDDRECK fib$r_fid_overlay.fib$r_fid_fields ,     fib->FIDDRECK.fib$w_fid_num = didfid[0];,     fib->FIDDRECK.fib$w_fid_seq = didfid[1];B     fib->FIDDRECK.fib$r_fid_rvn_overlay.fib$w_fid_rvn = didfid[2];       /*@     **	Load the attributes structure.  This is where the requestB     **	to perform a class block lookup is actually encoded -- most@     **	of the rest of the code present in this program exists to     **	support this call.      */
     i = 0;-     (atr + i)->atr$w_size = ATR$S_CLASS_MASK; -     (atr + i)->atr$w_type = ATR$C_CLASS_MASK; *     (atr + (i++))->atr$l_addr = &ctx->cls;     (atr + i)->atr$w_size = 0;     (atr + i)->atr$w_type = 0;"     (atr + (i++))->atr$l_addr = 0;  =     printf("%*.*s\n", ctx->nam.nam$b_rsl, ctx->nam.nam$b_rsl,  	ctx->nam.nam$l_rsa );       /*@     **	Perform an XQP $QIOW IO$_ACCESS call; this call loads theC     **	attributes list.  Rephrased, this retrieves the class block.      */     qiofunc = IO$_ACCESS; C     retstat = sys$qiow( 0, ctx->qiochan, qiofunc, ctx->qiosb, 0, 0, "         &fib_d, 0, 0, 0, atr, 0 );E     if (!$VMS_STATUS_SUCCESS( retstat )) goto NFS$MSX_macscan_ok_err;      retstat = ctx->qiosb[0];E     if (!$VMS_STATUS_SUCCESS( retstat )) goto NFS$MSX_macscan_ok_err;        /*<     **	Provide a brief and fleeting illusion of normalicy...     */     retstat = SS$_NORMAL; K     printf("%8.8d: sl: %d\n", ++ctx->filecount, ctx->cls.cls$b_secur_lev );        retstat = MSX$SCD_GET(        NFS$MSX_macscan_ok_err:        if ( retstat == RMS$_FLK )/ 	printf("%8.8d: sl unavailable; file locked\n",  	    ++ctx->filecount );;     if (( retstat == RMS$_NMF ) || ( retstat == RMS$_FLK ))  	return SS$_NORMAL; (     if (!$VMS_STATUS_SUCCESS( retstat ))' 	printf("%8.8d: sl: %d ERROR: 0x0%x\n", ; 	    ++ctx->filecount, ctx->cls.cls$b_secur_lev, retstat );        return retstat;      }        /* **++ **  FUNCTIONAL DESCRIPTION:  **@ **      This routine exists to provide somewhere for failures to; **	CALL{S|G} to.  This routine should not be invoked often.  **	(BTW: `ng' is `no good'.) ** **  FORMAL PARAMETERS: **" **      FAB	address of an RMS FAB. ** **  RETURN VALUE:  **? **      SS$_BUGCHECK	-- this routine is only called on failure.  ** **  SIDE EFFECTS:  **
 **      None.  ** **  DESIGN:  ** **      Design?  What design?  ** **-- */0 static int NFS$MSX_macscan_ng( struct FAB *fab )     {   -     printf("NFS$MSX_macscan_ng() called.\n");      return SS$_BUGCHECK;     }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         