Newsgroups: comp.os.vms
Distribution: world
X-Newsreader: mxrn 6.18-32
Followup-To: 
References:  <1997070908425669127@zetnet.co.uk>
From: hoffman@xdelta.enet.dec.com (Stephen Hoff Hoffman)
Reply-To: hoffman@xdelta.zko.dec.nospam
Organization: Digital Equipment Corp
Subject: Re: C - Passing args by descriptor
Keywords: 
-=-=-=-= Enter your text below this line (don't delete this line) =-=-=-=-
In article <1997070908425669127@zetnet.co.uk>, Dave Stevenson <dave.stevenson@zetnet.co.uk> writes:
:I cannot get my head around 
:how to pass the required arguments "by descriptor".

  Start with the OpenVMS Programming Concepts manual...

  A descriptor is nothing more than a small data structure that describes
  (hence the name) a string -- it provides the address of the storage
  buffer, the buffer length, the particular type of data stored in the
  buffer, and the class code for the particular type of string descriptor.
  Passing by descriptor means passing the address of a descriptor.

  In addition to the various C code examples in sys$examples:*.c,
  ucx$examples:*.c, and decw$examples:*.c, here is yet another one:

#include <descrip.h>
#include <lib$routines.h>
#include <ssdef.h>
#include <str$routines.h>
#include <string.h>
#include <stsdef.h>
main()
    {
    #define DSCBUFSIZ 255
    $DESCRIPTOR( DscConstant, "NON-WRITEABLE CONSTANT STRING" );
    char DscBuf[DSCBUFSIZ];
    int DscBufLen;
    int RetStat;
    struct dsc$descriptor DscStatic, DscDynamic;

    strncpy( DscBuf, "WRITABLE CONSTANT STRING", DSCBUFSIZ );

    /*
    // static string descriptor:
    // the user has full control over the storage referenced
    // by the descriptor.  (This is the most commonly-used
    // type of OpenVMS string descriptor, and the type most
    // often prefered by DEC C programmers.)
    */
    DscBufLen = strlen( DscBuf );
    DscStatic.dsc$w_length = DscBufLen;
    DscStatic.dsc$b_dtype = DSC$K_DTYPE_T;
    DscStatic.dsc$b_class = DSC$K_CLASS_S;
    DscStatic.dsc$a_pointer = DscBuf;

    /*
    // dynamic string descriptor:
    // the RTL has full control over the storage -- never alter
    // the length nor the pointer, once initialized.  only use
    // calls such as lib$sget1_dd and lib$sfree1_dd to alter the
    // RTL-allocated storage buffer size and address.  (Though it
    // is OK to write _in_ the allocated buffer.)
    */
    DscDynamic.dsc$w_length = 0;
    DscDynamic.dsc$b_dtype = DSC$K_DTYPE_T;
    DscDynamic.dsc$b_class = DSC$K_CLASS_D;
    DscDynamic.dsc$a_pointer = NULL;
    RetStat = lib$sget1_dd( &DscBufLen, &DscDynamic );
    if (!$VMS_STATUS_SUCCESS( RetStat )) return RetStat;

    /*
    //	copy the static string into the dynamic string...
    */
    RetStat = str$copy_dx( &DscDynamic, &DscStatic );
    if (!$VMS_STATUS_SUCCESS( RetStat )) return RetStat;

    /*
    //	now display some output, passing arguments "by descriptor".
    */
    RetStat = lib$put_output(  &DscConstant );
    if (!$VMS_STATUS_SUCCESS( RetStat )) return RetStat;
    RetStat = lib$put_output(  &DscStatic );
    if (!$VMS_STATUS_SUCCESS( RetStat )) return RetStat;
    RetStat = lib$put_output(  &DscDynamic );
    if (!$VMS_STATUS_SUCCESS( RetStat )) return RetStat;

    /*
    //  free the dynamic string.
    */
    RetStat = lib$sfree1_dd( &DscDynamic );
    if (!$VMS_STATUS_SUCCESS( RetStat )) return RetStat;

    /*
    //	and exit...
    */
    return SS$_NORMAL;
    }

  -------------------------- pure personal opinion ---------------------------
   Hoff (Stephen) Hoffman   OpenVMS Engineering   h*ffman@xdelta.enet.dec.c*m
     headers and addresses munged to avoid automated spammers: junk-e-mail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    