3 	subroutine util_cli_get_number(name,def_val,value)  	implicit none c  	include 'dix_def.inc' c @ c get a number from the cli command line and translate to number c with a default value c 2 	character*(*) name	!:i: the name of the qualifier% 	integer*4 def_val	!:i: default value ! 	integer*4 value		!:o: the result  c#' 	character*(max_short_line_length) line 
 	integer*4 nk  c ! 	call cli$get_value(name,line,nk)  	if(nk .eq. 0) then  	  value = def_val 	else  	  read(line(1:nk),2000) value 2000	  format(i10) 	endif 	return  	end		0  	function dix_util_overlap(pos1,len1,pos2,len2) 	implicit none c 4 c If pos1(len1) overlaps pos2(len2) then return true c   	integer*4 pos1		!:i: position 1 	integer*4 len1		!:i: length 1( 	integer*4 pos2          !:i: position 2 	integer*4 len2		!:i: length 2 	logical*4 dix_util_overlap  c# 	dix_util_overlap = A      1  (pos1      .ge. pos2 .and. pos1      .lt. pos2+len2) .or. A      1  (pos1+len1 .gt. pos2 .and. pos1+len1 .le. pos2+len2) .or. <      2  (pos1      .lt. pos2 .and. pos1+len1 .gt. pos2+len2)   	return  	end c : 	subroutine dix_util_copy_bits(nbit,offset,src,dest,nbyte) 	implicit none 	include 'dix_size_def.inc'  c < c Copy nbits from bit offset of data src to dest(nbyte) long c # 	integer*4 nbit		!:i: #bits to copy : 	integer*4 offset        !:i: offset in bits in buffer src+ 	byte src(*)             !:i: source buffer ) 	byte dest(*)            !:o: dest buffer , 	integer*4 nbyte         !:i: nbytes to fill c#0 	call dix_util_move_bits(nbit,src,offset,dest,0,2      1                nbyte*bits_per_byte,.false.) 	return  	end& 	subroutine dix_util_copy(nb,src,dest) 	implicit none c $ c copy data from src to dest (bytes) c  	integer*4 nb		!:i: length 	byte src(*)		!:i:source data  	byte dest(*)		!:o: result data  c# 	integer idx,nb_copy c  	idx = 1 c G c MOVc3 can only copy word length data, so split in parts if nb > 65536  c " 10	nb_copy = min(nb-idx + 1,65535)+ 	call lib$movc3(nb_copy,src(idx),dest(idx))  	idx = idx + nb_copy 	if (idx .le. nb) goto 10  c  	return  	end c   & 	subroutine dix_util_fill(byt,nb,dest) 	implicit none c ! c Fill data in dest with binary 0  c  	byte byt		!:i: the filler byte  	integer*4 nb		!:i: length 	byte dest(*)		!:o: result data  c#  	call lib$movc5(0,0,byt,nb,dest) 	return  	end c ) 	subroutine dix_util_left_just(line,nkar)  	implicit none c + c left justify data (remove leading blanks)  c # 	character*(*) line		!:io: the line ( 	integer*4 nkar			!:io: resulting length c# 	integer*4 ipos  c  	if(line(1:nkar) .eq. ' ') then  	  nkar = 0  	else  	  ipos = 1 % 	  do while(line(ipos:ipos) .eq. ' ')    	    ipos = ipos + 1	 	  end do  	  if(ipos .gt. 1) then  	    line = line(ipos:)  	    nkar = nkar - ipos + 1 	 	  end if  	end if  	return  	end c   	function dix_util_kar_conv(kar) 	implicit none c E c Convert character to printable one, so change unprintable char to .  c  	character kar 	character dix_util_kar_conv c# 	logical*4 dix_util_kar_in_ran c ) 	if(dix_util_kar_in_ran(ichar(kar))) then  	  dix_util_kar_conv = kar 	else  	  dix_util_kar_conv = '.' 	end if  	return  	end  # 	function dix_util_kar_in_ran(ikar)  	implicit none c % c check if character is printable one  c  	integer*4 ikar  	logical*4 dix_util_kar_in_ran c# 	dix_util_kar_in_ran =4      1      (ikar .ge.  32 .and. ikar .le. 126) .or./      1      (ikar .ge. 160 .and. ikar .le. 254)  	return  	end7 	function dix_util_get_field(fieldnr,fields,field,nkar)  	implicit none c  	include 'dix_def.inc' c   c Return field value from string  c We have two formats for fields. c 1. value=name,value=name...   (named values)0 c 2. name,,name,,name...        (names by index) c  c  	integer*4 fieldnr		!:i: index/ 	character*(*) fields		!:i: the list of strings & 	character*(*) field		!:o: field value& 	integer*4 nkar			!:o: length of field0 	logical*4 dix_util_get_field	!:f: true if found c#& 	character*(max_short_line_length) tmp 	integer*4 ipos,nk c  	logical*4 str$element 	integer*4 dix_util_get_len  c 	 	nkar = 0 " 	if(index(fields,'=') .ne. 0) then c 0 c Case 1, subfields must be in format value=name8 c make the string ",fieldnr=" and asee if we can find it c - 	  call sys$fao(',!SL=',nk,tmp,%val(fieldnr)) ! 	  ipos = index(fields,tmp(1:nk))  	  if(ipos .eq. 0) then  c G c Not found, but the first one does not have the laeding , so try again  c without the ,  c . 	    if(fields(1:nk-1) .ne. tmp(2:nk)) goto 90 c H c Yes, now set ipos to 0, so the next statement will copy the right part c 
 	    ipos = 0 	 	  end if  c D c Got it, now copy the part after the = sign, and terminate with the: c next , or the length of the string (for the last entry)( c  	  field = fields(ipos+nk:)  	  nkar = index(field,',')-11 	  if(nkar .lt. 0) nkar = dix_util_get_len(field)  	  field(nkar+1:) = ' '  	else  c % c The next format, name,name,,,name,, 7 c take the "fieldnr"th element of fields (if it exists)  c 1 	  if(str$element(field,fieldnr,',',fields)) then  	    nkar = len(field))  	    call dix_util_left_just(field,nkar) # 	    nkar = dix_util_get_len(field) 	 	  end if  	end if  c 4 c Now check for the result, if nkar > 0, we have one c  90	if(nkar .eq. 0) field = ' '! 	dix_util_get_field = nkar .gt. 0  	return  	end3 	function dix_util_find_field(field,fields,fieldnr)  	implicit none c  	include 'dix_def.inc' c  c The reverse from get_field, 0 c see if we can  find the name "field" in fields  c We have two formats for fields. c 1. value=name,value=name...   (named values)0 c 2. name,,name,,name...        (names by index) c / 	character*(*) field		!:i: the name to be found 2 	character*(*) fields		!:i: the list of fieldnames 	integer*4 fieldnr		!:o: number 1 	logical*4 dix_util_find_field	!:f: true if found  c# 	logical*4 str$element 	integer*4 dix_util_get_len 1 	character*(max_symbol_name_length) field1,field2  	integer*4 nk,ipos c 
 	fieldnr = -1  c  	dix_util_find_field = .false. c " 	if(index(fields,'=') .ne. 0) then c 
 c Format 1, c  value1=name1,value2=name2,value3=name3... c " c Make a search string as "=name," c  	  nk = dix_util_get_len(field) 0 	  call str$upcase(field2,'='//field(1:nk)//',') 	  nk = nk + 2 c 2 c Go through all fields, ansd see if we can find i c  	  fieldnr = 03 	  do while(str$element(field1,fieldnr,',',fields)) # 	    call str$upcase(field1,field1) & 	    ipos = index(field1,field2(1:nk))) 	    if(ipos .ne. 0) goto 40	!got a match ( 	    fieldnr = fieldnr + 1	!try the next	 	  end do  c : c If we came here we have no match, check for last entry, " c  that does not have a trailing , c Get the last field back  c 0 	  call str$element(field1,fieldnr-1,',',fields)! 	  call str$upcase(field1,field1)  c : c And check for the search string (without the trailing ,) c ' 	  ipos = index(field1,field2(1:nk-1))	 " 	  if(ipos .ne. 0) goto 40	!got it 	  goto 99			!not found  c ) c Field1 has the correct data, value=name 8 c the = is at pos ipos, so the 1:ipos-1 must be a number c 3 40	  read(field1(1:ipos-1),'(i10)',err=99) fieldnr   c  c Successful c 
 	  goto 90 	else  c 	 c FOrmat2  c name1,name2,name3  c  	  fieldnr = 03 	  do while(str$element(field1,fieldnr,',',fields)) " 	    if(field1 .eq. field) goto 90 	    fieldnr = fieldnr + 1	 	  end do  	  fieldnr = -1  	end if  c  	goto 99 c  90	dix_util_find_field = .true.  c 	 99	return  	end0 	function dix_con_hex_in_string(string,nk,tobin) 	implicit none c 7 c Replace all %XX to the hex value   (if tobin is true) 8 c         or all unprintables to %XX    (tobin is false) c 1 	character*(*) string	!:io: the text to b checked , 	integer*4 nk		!:io: the length of th string6 	logical*4 tobin		!if true convert from text to binary@ 	logical dix_con_hex_in_string !:f: true if something converted  c# 	logical*4 dix_util_kar_in_ran 	integer dix_util_hex_kar  c  	integer*4 ipos,k,k1
 	logical stat  	integer*4  max_str_size 	parameter (max_str_size=2)  	character*(max_str_size) tmp  c 	 	ipos = 1  	stat = .false.  	do while(ipos .le. nk)   	  if(tobin) then                c J c To binary mode, replace %XX to one binary char, but leave %% to be one % C ( 	    if(string(ipos:ipos) .eq. '%') then. 	      if(string(ipos+1:ipos+1) .eq. '%') then* 	        string(ipos+1:) = string(ipos+2:) 	        nk = nk - 1 	      else  c - c %XX expected, tty to convert next two chars  c < 	        k1 = dix_util_hex_kar(ichar(string(ipos+1:ipos+1))) 	        if(k1 .ge. 0) then  	          k = k1*16> 	          k1 = dix_util_hex_kar(ichar(string(ipos+2:ipos+2))) 	          if(k1 .ge. 0) then  	            k = k+k1	   c 4 c Successful, replace the %XX by the one binary char c  	            stat = .true.5 	            string(ipos:) = char(k)//string(ipos+3:)  	            nk = nk - 2 	          endif 	        endif
 	      end if  	    end if  	  else  c  c From bin to ascii  c A 	    if(.not. dix_util_kar_in_ran(ichar(string(ipos:ipos)))) then  c " c Unprintable char, replcae by %XX c / 	      write(tmp,1000) ichar(string(ipos:ipos))  1000	      format(z2.2) 0 	      string(ipos:) = '%'//tmp//string(ipos+2:) 	      nk = nk + 2 	      ipos = ipos + 2 	    end if  	  endif 50	  ipos = ipos + 1 	end do  	dix_con_hex_in_string = stat  	return  	end c & 	subroutine dix_util_link_in(link,top) 	implicit none c / c Link in "link" in the link started with "top"  c  	include 'dix_def.inc' 	record /link/ link  	integer*4 top c# 	record /link/ tlink c	integer*4 p_tlink  	pointer(p_tlink,tlink)  c  	link.forw = 0 c  	if(top .eq. 0) then 	  link.backw = 0  	  top = %loc(link)  	else  	  p_tlink = top 	  do while(tlink.forw .ne. 0) 	    p_tlink = tlink.forw 	 	  end do  	  tlink.forw = %loc(link) 	  link.backw = p_tlink  	end if  	return  	end  ' 	subroutine dix_util_link_out(link,top)  	implicit none c / c Link in "link" in the link started with "top"  c  	include 'dix_def.inc') 	record /link/ link		!:io: link structure & 	integer*4 top			!:io: the top pointer c#" 	record /link/ next_link,prev_link 	pointer(p_next_link,next_link)  	pointer(p_prev_link,prev_link)  c  	p_next_link = top		 	p_prev_link = 0 c 7 c Let next link be equal to link, and remmeber previous  c & 	do while(p_next_link .ne. %loc(link)) 	  if(p_next_link .eq. 0) then, 	    write(*,*) 'Internal error in link_out'
 	    stop  	  endif- 	  p_prev_link = p_next_link			!remember prev . 	  p_next_link = next_link.forw			!set to next 	end do  c  c Now next_link = link! c     prev_link = previous (or 0)  c  	if(p_prev_link .eq. 0) then c ( c No previous record, so next is new top c % 	  top = next_link.forw		!set new top  	else  c 7 c there was a previous, set previous to forward to next  c " 	  prev_link.forw = next_link.forw 	end if  c  c CHeck if next record exists  c  	if(next_link.forw .ne. 0) then  c = c Netx record exists, set it to point to either 0, or previos  c  	  p_next_link = next_link.forw   	  next_link.backw = p_prev_link 	end if 	 90	return  	end9 	subroutine dix_util_insert_bits(source,offset,nbit,dest)  	implicit none c & c Insert a bit string in a data string c / 	integer*4 source(*)           	!:i: the source - 	integer*4 nbit		        !:i: #bits in source ( 	integer*4 offset		!:i: offset in buffer$ 	integer*4 dest			!:io: data buffer  c#@ 	call dix_util_move_bits(nbit,source,0,dest,offset,nbit,.false.) 	return  	end- 	subroutine dix_util_collapse(line,nk,quotes)  	implicit none c 4 c Remove a non-significant spaces (outside a string) c " 	character*(*) line	!:io: the line3 	integer*4 nk            !:io: the lnegth (updated) & 	logical quotes		!:i: look for quotes? c# 	integer*4 k,nk1 	logical in_string c  	nk1 = 0 	in_string = .false. 	do k=1,min(nk,len(line)) B 	  if(quotes .and. line(k:k) .eq. '"') in_string = .not. in_string- 	  if(in_string .or. line(k:k) .ne. ' ') then  	    nk1 = nk1 + 1 	    line(nk1:nk1) = line(k:k)	 	  end if  	end do 	 	nk = nk1  	line(nk1+1:) = ' '  	return  	end@ 	subroutine dix_util_get_type_name(enttyp,enttyp_nam,enttyp_len,2      1                                   dataitem) 	implicit none c  c Get the name for an type c # 	integer*4 enttyp  		!:i: the type  3 	character*(*) enttyp_nam	!:o: the name of the type / 	integer*4 enttyp_len		!:o: length of entyp_nam + 	integer*4 dataitem		!:o: is it a data item  c# 	include 'dix_def.inc' c  	integer*4 str$element c H 	if(.not.str$element(enttyp_nam,enttyp,'/',type_names)) enttyp_nam = ' ' 	enttyp_len = len(enttyp_nam) 6 	call dix_util_collapse(enttyp_nam,enttyp_len,.false.)4 	if(enttyp_nam(enttyp_len:enttyp_len) .eq. '&') then  	  enttyp_nam(enttyp_len:) = ' ' 	  enttyp_len = enttyp_len - 1 	  dataitem = .false.  	else  	  dataitem = .true. 	endif 	return  	end6 	function dix_util_find_char_bracket(name,kars,quotes) 	implicit none c $ c Find a character taking care of () c 7 	character*(*) name        	!:i: the string to serch in , 	character*(*) kars		!:i: the kar(s) to find# 	logical quotes			!:i: quotes used? < 	integer*4 dix_util_find_char_bracket    !:f: the pos (or 0) c# 	integer*4 k,level 	logical out_string  c  	out_string = .true. c 
 	level = 0 	do k=1,len(name) E 	  if(quotes .and. name(k:k) .eq. '"') out_string = .not. out_string   	  if(out_string) then- 	    if(name(k:k) .eq. ')') level = level - 1 @ 	    if(index(kars,name(k:k)) .ne. 0 .and. level .le. 0) goto 50- 	    if(name(k:k) .eq. '(') level = level + 1  	  endif 	end do  	k = 0$ 50	dix_util_find_char_bracket = k	   	return  	end" 	function dix_util_get_len(string) 	implicit none c 1 c Get the length (the pos of the first space - 1)  c & 	character*(*) string		!:i: the string+ 	integer*4 dix_util_get_len	!:f: the length  c#
 	integer*4 nk  c  	nk = index(string,' ')-1  	if(nk .lt. 0) nk = len(string)  	dix_util_get_len = nk 	return  	end% 	function dix_util_get_len_fu(string)  	implicit none c 3 c  Get the length of the string (the last nonblank)  c & 	character*(*) string		!:i: the string5 	integer*4 dix_util_get_len_fu	!:f: the length (or 0)  c#
 	integer*4 nk  c  	do nk=len(string),1,-1 % 	  if(string(nk:nk) .ne. ' ') goto 10  	end do  	nk = 0  10	dix_util_get_len_fu = nk  	return  	end5 	subroutine dix_util_con_nr(offset,has_fields,offasc, 6      1                             nk_off,hex,control) 	implicit none 	include 'dix_def.inc' c - c Convert offset (bit_offset) to ascii number > c if has_fields is true, the text also includes the bit_offset c . 	integer*4 offset		!:i: the (bit_)offset value( 	logical*4 has_fields		!:i: need . part?$ 	character*(*) offasc		!:o: the text. 	integer*4 nk_off		!:io: the width to fit into$ 	logical*4 hex			!:i: In hex format?, 	record /control/ control	!:i: control block c#$ 	character*(max_nr_asc_length) nroff c  	if(nk_off .eq. 0) then  c 4 c Calller did not specify the width, compute it here c  	  if(hex) then + 	    write(nroff,1000) offset/bits_per_byte  1000	    format(z5)  	    nk_off = 5 +  	    call dix_util_left_just(nroff,nk_off)  	  else <             call dix_con_type_intasc(4,offset/bits_per_byte,4      1              enttyp_int,nroff,nk_off,control) 	  endifC           if(has_fields) nk_off = nk_off + 2        !for . and bit    	endif  c  c Fill offset field  c 
 	if(hex) then  c  c Hex mode   c            if(has_fields) then  c  c Hex mode with bit offset c 3             write(nroff,1011) offset/bits_per_byte, 7      1                        mod(offset,bits_per_byte) & 1011        format(z<nk_off-2>,'.',z1)           else c  c HEx mode with the bit offset c 2             write(nroff,1012) offset/bits_per_byte 1012        format(z<nk_off>)            end if 	else  c  c Decimal mode c            if(has_fields) then  c ' c Decimal mode with of without bit part  c 3             write(nroff,1021) offset/bits_per_byte, 7      1                        mod(offset,bits_per_byte) & 1021        format(i<nk_off-2>,'.',i1)           else c  c Decimal mode without bit part  c 2             write(nroff,1022) offset/bits_per_byte 1022        format(i<nk_off>)            end if         end if 	offasc = nroff  	return  	end 	 ( 	function dix_util_insert_table(control,6      1                      table,elem,extend,vm_zone,!      1                      name)  	implicit none c  	include 'dix_def.inc' c - c append the element at the end of the table,  c + 	record /control/ control!:i: control block / 	record /table/ table	!:io: table control block 8 	byte elem(*)            !:i: the element to be insertedC 	integer*4 extend        !:i: extend in elements if not enough room % 	record /vm_zone/ vm_zone!:i: zone id ( 	character*(*) name	!:I: name of element9 	logical*4 dix_util_insert_table !:f: true if table moved  c# 	integer*4 nb_temp 	integer*4 adr_temp  c  c   c Check if no more room in table c   	dix_util_insert_table = .false.5 	if(table.allocated .le. table.count*table.size) then  c  c Not enough room  c Compute new size c ! 	  dix_util_insert_table = .true. . 	  nb_temp = (table.count+extend) * table.size c ( c 1. create new segment with more memory c = 	  call get_vm(control,nb_temp,adr_temp,vm_zone,.false.,name)  c   	  if(table.address .gt. 0) then c D c Copy old data to new data, size can be >65535 bytes, so do not use c  movc3 c < 	    call dix_util_copy(table.allocated,%val(table.address),.      1                         %val(adr_temp)) c  c Delete old sement  c @ 	    call free_vm(control,table.allocated,table.address,vm_zone)	 	  end if  c  c Adjust pointers  c  	  table.address   = adr_temp  	  table.allocated = nb_temp 	endif c  c Insert element in table  c $ 	call dix_util_copy(table.size,elem,;      1          %val(table.address+table.count*table.size)) . 	table.count = table.count + 1				!1 more line 	return  	end( 	function dix_util_get_nr(maxval,result) 	implicit none c  	include 'dix_def.inc' c  c Get  a number  from sys$input  c   	integer*4 maxval	!:i: max value' 	integer*4 result        !:o: the value 8 	logical*4 dix_util_get_nr   !:f: the status of the read c#' 	character*(max_short_line_length) line  	integer*4 k,nk  c  	dix_util_get_nr = .false.) 	call sys$fao('!UL',nk,line,%val(maxval))   10      write(*,1010) line(1:nk), 1010    format('$Select number (1..',a,'):')$         read(*,2000,err=10,end=90) k 2000    format(bn,i5)          if(k .eq. 0) goto 90/         if(k .lt. 1 .or. k .gt. maxval) goto 10  	result = k  	dix_util_get_nr = .true. 	 90	return  	end4 	subroutine dix_util_move_bits(nbits,src,src_offset,;      1                                      dst,dst_offset, @      1                                field_width,right_justify) c 1 c Move some bits from somewhere to somewhere else  c  	implicit none 	include 'dix_size_def.inc'  c % 	integer*4 nbits		!:i: Number of bits , 	byte src(*)             !:i: source address< 	integer*4 src_offset    !:i: source offset in bits from src1 	byte dst(*)             !:i: destination address A 	integer*4 dst_offset    !:i: destination offset in bits from src ) 	integer*4 field_width   !:i: field_width 6 	logical*4 right_justify !:i: if true do right justify c#? 	integer*4 data,sidx,didx,sofs,dofs,nbits_to_do,nb,nbytes_to_do  c  	integer*4 lib$extzv c 1 	if(nbits .le. 0 .or. field_width .le. 0) goto 90  c " 	sidx = src_offset/bits_per_byte+1" 	didx = dst_offset/bits_per_byte+1 d	write(*,*) 'Sidx = ',sidx  d	write(*,*) 'Didx = ',didx  c 0 	if(mod(src_offset ,bits_per_byte) .eq. 0 .and. 6      1     mod(dst_offset ,bits_per_byte) .eq. 0 .and.7      1     mod(field_width,bits_per_byte) .eq. 0 .and.  6      1     mod(nbits      ,bits_per_byte) .eq. 0) then c ; c All boundaries are byte aligned, so we can do byte copies  c  d	  write(*,*) 'Byte oriented' 	  if(right_justify) then 5 	    nbytes_to_do = (field_width-nbits)/bits_per_byte ! 	    if(nbytes_to_do .gt. 0) then 7 d	      write(*,*) 'left  fill, nbytes = ',nbytes_to_do 3 	      call lib$movc5(0,0,0,nbytes_to_do,dst(didx)) ! 	      didx = didx + nbytes_to_do  	    end if  	  endif c 6 	  nbytes_to_do = min(field_width,nbits)/bits_per_byte7 d	  write(*,*)     'Copy  data, nbytes = ',nbytes_to_do 3 	  call lib$movc3(nbytes_to_do,src(sidx),dst(didx))  	  didx = didx + nbytes_to_do  c  	  if(.not. right_justify) then 5 	    nbytes_to_do = (field_width-nbits)/bits_per_byte ! 	    if(nbytes_to_do .gt. 0) then 7 d	      write(*,*) 'right fill, nbytes = ',nbytes_to_do 3 	      call lib$movc5(0,0,0,nbytes_to_do,dst(didx)) ! 	      didx = didx + nbytes_to_do  	    end if  	  endif 	else  c @ c Data is not byte aligned, so we must use lib$extz and lib$insv c ' 	  sofs = mod(src_offset,bits_per_byte) ' 	  dofs = mod(dst_offset,bits_per_byte)  d	  write(*,*) 'Bit oriented'  d	  write(*,*) 'Sofs = ',sofs  d	  write(*,*) 'Dofs = ',dofs  c  c Fill out with 0 at begin c  	  if(right_justify) then $ 	    nbits_to_do = field_width-nbits
 	    data = 0 " 	    do while(nbits_to_do .gt. 0)  	      nb = min(nbits_to_do,32) < d	      write(*,*) 'Left  fill, nbits = ',nb,' didx = ',didx/ 	      call lib$insv   (data,dofs,nb,dst(didx))  	      if(nb .eq. 32) then 	        didx = didx + 4 	      else  	        dofs = dofs + nb  	      endif% 	      nbits_to_do = nbits_to_do - nb              end doB d	    write(*,*) 'Left  fill, at end didx = ',didx,' dofs = ',dofs	 	  end if  c ' 	  nbits_to_do = min(nbits,field_width)  c  	  do while(nbits_to_do .gt. 0)  	    nb = min(nbits_to_do,32) H d	    write(*,*) 'Copy  data, nbits = ',nb,' sidx ',sidx,' didx = ',didx- 	    data = lib$extzv(sofs,     nb,src(sidx)) - 	    call lib$insv   (data,dofs,nb,dst(didx))  	    if(nb .eq. 32) then 	      sidx = sidx + 4 	      didx = didx + 4	 	    else  	      sofs = sofs + nb  	      dofs = dofs + nb 
 	    endif# 	    nbits_to_do = nbits_to_do - nb 	 	  end do @ d	  write(*,*) 'Copy  data, at end didx = ',didx,' dofs = ',dofs( c                                        c Fill out with 0 at end c  	  if(.not. right_justify) then $ 	    nbits_to_do = field_width-nbits
 	    data = 0 " 	    do while(nbits_to_do .gt. 0)  	      nb = min(nbits_to_do,32) < d	      write(*,*) 'Right fill, nbits = ',nb,' didx = ',didx/ 	      call lib$insv   (data,dofs,nb,dst(didx))  	      didx = didx + 4% 	      nbits_to_do = nbits_to_do - nb              end do	 	  end if  	end if  c 	 90	return  	end  2 	function dix_util_file_parse(fnam,type,bpos,epos) 	implicit none c  c Get a part of the filename1 c  type = 'X' : return bpos and epos of file disk 6 c  type = 'D' : return bpos and epos of file directory1 c  type = 'N' : return bpos and epos of file name 1 c  type = 'T' : return bpos and epos of file type 6 c  type = 'V' : return bpos and epos of file extension c . 	character*(*) fnam              !:i: filename% 	character type		!:i: what, X,D,N,T,V # 	integer*4 bpos			!:o: bpos of part # 	integer*4 epos			!:o: epos of part 6 	logical*4 dix_util_file_parse	!:f: True if part found c# 	include '($fscndef)'  	record /fscndef/ fscn_items(2)  	integer*4 istat,flags,mask  c  	integer*4 sys$filescan  c  	istat = .false.	 	bpos = 0 	 	epos = 0  c  	if(type .eq. 'X') then 0 	  fscn_items(1).fscn$w_item_code = fscn$_device 	  mask = fscn$v_device  	elseif(type .eq. 'D') then 3 	  fscn_items(1).fscn$w_item_code = fscn$_directory  	  mask = fscn$v_directory 	elseif(type .eq. 'N') then . 	  fscn_items(1).fscn$w_item_code = fscn$_name 	  mask = fscn$v_name  	elseif(type .eq. 'T') then . 	  fscn_items(1).fscn$w_item_code = fscn$_type 	  mask = fscn$v_type  	elseif(type .eq. 'V') then 1 	  fscn_items(1).fscn$w_item_code = fscn$_version  	  mask = fscn$v_version 	else 
 	  goto 90 	endif c   	fscn_items(1).fscn$w_length = 0 	fscn_items(1).fscn$l_addr = 0 c   	fscn_items(2).fscn$w_length = 0# 	fscn_items(2).fscn$w_item_code = 0  	fscn_items(2).fscn$l_addr = 0, 	istat = sys$filescan(fnam,fscn_items,flags)$ 	if(istat) istat = btest(flags,mask) 	if(istat) then 4 	  bpos = fscn_items(1).fscn$l_addr - %loc(fnam) + 10 	  epos = bpos + fscn_items(1).fscn$w_length - 1 	endif 90	dix_util_file_parse = istat 	return  	end% 	subroutine dix_append(nk,line,topic)  	implicit none c 4 c Append a string to another  (skip trailing spaces) c 1 	integer*4 nk            !:io: the length of line " 	character*(*) line  	!:io: string. 	character*(*) topic	!:i: the string to append c# 	integer*4 nk1   	integer*4 dix_util_get_len_fu c ! 	nk1 = dix_util_get_len_fu(topic)  c  	line(nk+1:nk+nk1) = topic 	nk = nk + nk1 	return  	end& 	subroutine dix_append1(nk,line,topic) 	implicit none c 6 c Append a string to another (include trailing spaces) c 1 	integer*4 nk            !:io: the length of line " 	character*(*) line  	!:io: string. 	character*(*) topic	!:i: the string to append c# 	integer*4 nk1 c  	nk1 = len(topic)  	line(nk+1:nk+nk1) = topic 	nk = nk + nk1 	return  	end 	function test_bit(bit,mask) 	implicit none c  c 64 bit btest c + 	integer*4 bit		!:i: the bit to test (0-63) $ 	integer*4 mask(2)	!:i: the bit mask' 	logical test_bit	!:f: true oif bit set  c# 	test_bit = .false. & 	if(bit .ge. 0 .and. bit .le. 63) then 	  if(bit .lt. 32) then " 	    test_bit = btest(mask(1),bit) 	  else % 	    test_bit = btest(mask(2),bit-32) 	 	  end if  	end if  	return  	end   	subroutine set_bit(bit,mask)  	implicit none c 
 c 64 bit set   c % 	integer*4 bit		!:i: bitnumber (0-63) + 	integer*4 mask(2)	!:io: bit mask (updates)  c#		& 	if(bit .ge. 0 .and. bit .le. 63) then 	  if(bit .lt. 32) then ! 	    mask(1) = ibset(mask(1),bit)  	  else $ 	    mask(2) = ibset(mask(2),bit-32) 	  endif 	endif 	return  	end 	subroutine clear_bit(bit,mask)  	implicit none c 
 c 64 bit set   c , 	integer*4 bit		!:i: the bit to clear (0-63). 	integer*4 mask(2)	!:io: the bitmask (updated) c#& 	if(bit .ge. 0 .and. bit .le. 63) then 	  if(bit .lt. 32) then ! 	    mask(1) = ibclr(mask(1),bit)  	  else $ 	    mask(2) = ibclr(mask(2),bit-32) 	  endif 	endif 	return  	end 	function ignore_message() 	implicit none c 0 c Ignore a signal, used around cli$dcl_parse to  c prevent dcl from signalling  c  	integer*4 ignore_message  	logical seen_signal+ 	common /ignore_message_common/ seen_signal  c# 	include '($ssdef)'  c  	seen_signal = .true.  	ignore_message = ss$_continue 	return  	end% 	function dix_util_check_name(symbol)  	implicit none c   c Check if symbol is a valie one4 c  start with letter, continue with letter/digit/$/_ c  	include 'dix_def.inc' c  	character*(*) symbol  	logical dix_util_check_name c# 	integer*4 k,istat c  	external dix_msg_karsallow  	external dix_msg_symbtool 	external dix_msg_symbresv 	logical str$case_blind_compare  c  	logical dix_util_legal_char c  c CHeck length c & 	if(len(symbol) .gt. name_length) then! 	  istat = %loc(dix_msg_symbtool) 
 	  goto 90 	end if  c  c Check for valid chars  c  	do k=1,len(symbol) 4 	  if(.not. dix_util_legal_char(symbol(k:k),k)) then$ 	    istat = %loc(dix_msg_karsallow) 	    goto 90 	  endif 	end do  c  c check if reserved names  c 7 	if(str$case_blind_compare(symbol,true_name) .eq. 0.or. A      1     str$case_blind_compare(symbol,false_name) .eq. 0) then ! 	  istat = %loc(dix_msg_symbresv) 
 	  goto 90 	endif
 	istat = 1 90	dix_util_check_name = istat 	return  	end& 	function dix_util_legal_char(kar,pos) 	implicit none c 7 c See if char 'kar' is legal in symbolname at pos 'pos'   c  Allow a-z,_ at first position# c  Allow 0-9,$ at pos 2 and further < c The $ at pos 2 and further is to prevent normal symbols th3 c interfere with the standard $status and $severity  c  	character kar 	integer*4 pos 	logical dix_util_legal_char c#. 	if(    (kar .ge. 'A' .and. kar .le. 'Z') .or.5      1         (kar .ge. 'a' .and. kar .le. 'z') .or. "      1          kar .eq. '_') then 	  dix_util_legal_char = .true. / 	elseif((kar .ge. '0' .and. kar .le. '9') .or.  "      1          kar .eq. '$') then# 	  dix_util_legal_char = pos .gt. 1  	else   	  dix_util_legal_char = .false. 	endif 	return  	end" 	function dix_util_upcase_kar(kar) 	implicit none c  c Upcase a character c  	character kar 	character dix_util_upcase_kar c#: 	if((kar .ge.         'a' .and. kar .le.        'z') .or. B      1     (kar .ge. char('E0'X) .and. kar .le. char('FE'X))) thenC 	  dix_util_upcase_kar = char(ichar(kar) - ichar('a') + ichar('A'))  	else  	  dix_util_upcase_kar = kar 	end if  	return  	end" 	function dix_util_locase_kar(kar) 	implicit none c  c Upcase a character c  	character kar 	character dix_util_locase_kar c#: 	if((kar .ge.         'A' .and. kar .le.        'Z') .or. B      1     (kar .ge. char('C0'X) .and. kar .le. char('DE'X))) thenC 	  dix_util_locase_kar = char(ichar(kar) - ichar('A') + ichar('a'))  	else  	  dix_util_locase_kar = kar 	end if  	return  	end  	function dix_util_hex_kar(ikar) 	implicit none c ) c Transform a character from ascii to HEX 7 c return 0..15 for a valid char, and -1 for a not valid  c 6 	integer*4 ikar	       		!:i: the input char (integer)3 	integer*4 dix_util_hex_kar	!:o: The result (or -1)  c# 	integer*4 ival  c = 	if(    ikar .ge. ichar('0') .and. ikar .le. ichar('9')) then  	  ival  = ikar - ichar('0')= 	elseif(ikar .ge. ichar('A') .and. ikar .le. ichar('F')) then ! 	  ival  = ikar - ichar('A') + 10 = 	elseif(ikar .ge. ichar('a') .and. ikar .le. ichar('f')) then ! 	  ival  = ikar - ichar('a') + 10  	else  	  ival = -1		!illegal char  	endif 	dix_util_hex_kar = ival 	return  	end c * 	function dix_util_remove_comment(nk,line) 	implicit none c @ c Remove trailing ! comment (but only if the ! is not in quotes) c and all trailing blanks  c 
 	integer*4 nk  	character*(*) line   	logical dix_util_remove_comment c# 	integer*4 k 	logical in_quote  c  	in_quote = .false. 
 	do k=1,nk 	  if(line(k:k) .eq. '"') then 	    in_quote = .not. in_quote 	  else  	    if(.not. in_quote) then" 	      if(line(k:k) .eq. '!') then 	        nk = k-1  	        goto 50 	      endif
 	    endif 	  endif 	end do  50	if(.not. in_quote) then 	  do k=nk,1,-1 # 	    if(line(k:k) .ne. ' ') goto 80 	 	  end do  	  k = 0 80	  nk = k  	endif) 	dix_util_remove_comment = .not. in_quote  	return  	end) 	subroutine dix_util_decent_line(nk,line)  	implicit none c  	include 'dix_def.inc' c  c replace tab by space c Remove all leading blanks 8 c replace all multiple blanks by one (but not in quotes); c if a slash is found (not in_quotes) and the prev char is   c space, then skip the space c  c skip trailing blanks c 
 	integer*4 nk  	character*(*) line  c# 	integer*4 k,n  	logical in_quote,skip,next_skip c  	character dix_util_upcase_kar c  	in_quote  = .false. 	skip      = .true.  	next_skip = .true.  	n         = 0
 	do k=1,nk+ 	  if(line(k:k) .eq. TAB) line(k:k) = SPACE 3 	  if(line(k:k) .eq. '"') in_quote = .not. in_quote  	  if(.not. in_quote) then" 	    if(line(k:k) .eq. SPACE) then 	      next_skip = .true. 	 	    else  	      skip      = .false. 	      next_skip = .false.1 	      line(k:k) = dix_util_upcase_kar(line(k:k)) - 	      if(index('/=,',line(k:k)) .ne. 0) then  c , c Char is / or =, previous cannot be a space c ) 	        if(line(n:n) .eq. SPACE) n = n-1  	        next_skip = .true.  	      endif
 	    endif 	  else  	    skip = .false.  	    next_skip = .false. 	  endif 	  if(.not. skip) then 	    n = n + 1 	    line(n:n) = line(k:k) 	  endif 	  skip = next_skip  	end do  	nk = n  	if(nk .gt. 0) then ) 	  if(line(nk:nk) .eq. SPACE) nk = nk - 1  	endif	 90	return  	end8 	function dix_util_checksum(type,data,bpos,epos,chktype) 	implicit none c  	integer*4 type		!:i: b/w/l & 	byte data(*)            !:i: the data7 	integer*4 bpos		!:i: bpos in bytes (0-start of buffer) $ 	integer*4 epos		!:i: epos in bytes # 	character chktype	!:X(or) or S(UM)  	integer*4 dix_util_checksum c# 	integer*4 dix_util_checksum_b 	integer*4 dix_util_checksum_w 	integer*4 dix_util_checksum_l c  	integer*4 k c  	if(    type .eq. 1) then	2 	  k = dix_util_checksum_b(data,bpos,epos,chktype) 	  k = k .and. 'ff'x 	elseif(type .eq. 2) then	6 	  k = dix_util_checksum_w(data,bpos/2,epos/2,chktype) 	  k = k .and. 'ffff'x 	elseif(type .eq. 4) then	6 	  k = dix_util_checksum_l(data,bpos/4,epos/4,chktype) 	endif 	dix_util_checksum = k 	return  	end5 	function dix_util_checksum_b(data,bpos,epos,chktype)  	implicit none c  	byte data(0:*)  	integer*4 bposb 	integer*4 eposg# 	character chktype	!:X(or) or S(UM)i 	integer*4 dix_util_checksum_b c# 	integer*4 k,resultf c  	result = 0n 	if(chktype .eq. 'S') then 	  do k=bpos,epost 	    result = result + data(k)	 	  end dom 	elseif(chktype .eq. 'X') then 	  do k=bpos,epos " 	    result = result .xor. data(k)	 	  end do  	endif 	dix_util_checksum_b = result  	returnr 	end5 	function dix_util_checksum_w(data,bpos,epos,chktype)) 	implicit none cd 	integer*2 data(0:*) 	integer*4 bpos) 	integer*4 eposr 	character chktype 	integer*4 dix_util_checksum_w c# 	integer*4 k,result2 cn 	result = 0  	if(chktype .eq. 'S') then 	  do k=bpos,eposh 	    result = result + data(k)	 	  end doo 	elseif(chktype .eq. 'X') then 	  do k=bpos,epos4" 	    result = result .xor. data(k)	 	  end do	 	endif 	dix_util_checksum_w = resultr 	return  	end5 	function dix_util_checksum_l(data,bpos,epos,chktype)  	implicit none c) 	integer*4 data(0:*) 	integer*4 bposn 	integer*4 epos # 	character chktype	!:X(or) or S(UM). 	integer*4 dix_util_checksum_l c# 	integer*4 k,resultd c  	result = 0  	if(chktype .eq. 'S') then 	  do k=bpos,epos  	    result = result + data(k)	 	  end do  	elseif(chktype .eq. 'X') then 	  do k=bpos,epose" 	    result = result .xor. data(k)	 	  end do  	endif 	dix_util_checksum_l = result  	return  	end4 	subroutine dix_util_compress_line(line,nk,collapse) 	implicit none c  	include 'dix_def.inc' c  c replace tab by space8 c replace all multiple blanks by one (but not in quotes)& c If collapse is true, skip all spaces c	" 	character*(*) line	!:io: the line+ 	integer*4 nk    	!:io: the number of chars)) 	logical collapse	!:i: remove all spaces?t c# 	integer*4 k,n 	logical in_quote,prev_space c  	in_quote  = .false. 	prev_space= .false. 	n         = 0
 	do k=1,nk+ 	  if(line(k:k) .eq. TAB) line(k:k) = SPACEn3 	  if(line(k:k) .eq. '"') in_quote = .not. in_quote5 	  if(.not. in_quote) then" 	    if(line(k:k) .eq. SPACE) then+ 	      if(collapse .or. prev_space) goto 30o
 	    endif 	  endif 	  n = n + 1 	  line(n:n) = line(k:k)$ 	  prev_space = line(k:k) .eq. SPACE	 30	end doo 	nk = n 	 90	returnn 	end* 	subroutine dix_util_case_line(line,upper) 	implicit none c4# c Change case, execpt within string < c If uppper is true, case is changed to upper, else to lower c	" 	character*(*) line	!:io: the line- 	logical upper		!:i: change to upper or lowery c# 	integer*4 k 	logical in_quotec 	character dix_util_locase_kar 	character dix_util_upcase_kar cn 	in_quote  = .false. 	do k=1,len(line)i3 	  if(line(k:k) .eq. '"') in_quote = .not. in_quotei 	  if(.not. in_quote) then 	    if(upper) then 1 	      line(k:k) = dix_util_upcase_kar(line(k:k)) 	 	    else 1 	      line(k:k) = dix_util_locase_kar(line(k:k)) 
 	    endif 	  endif 	end do  	return  	end+ 	function dix_util_match(candidate,pattern)  	implicit none cc c Match partial string  c so f$enum matches f$enum|erate$ c The part upto the | must be there,3 c if the part after the | is present, it must match( c_ 	character*(*) candidate 	character*(*) pattern 	logical dix_util_matchd c# 	integer*4 ipos,nk1e ci 	ipos = index(pattern,'|')( 	if(ipos .eq. 0) ipos = len(pattern) + 1 co$ 	if(len(candidate) .lt. ipos-1) then 	  dix_util_match = .false. ( 	elseif(len(candidate) .eq. ipos-1) then4 	  dix_util_match = candidate .eq. pattern(1:ipos-1) 	else." 	  nk1 = len(candidate) - ipos + 1# 	  dix_util_match = candidate .eq. e:      1         pattern(1:ipos-1)//pattern(ipos+1:ipos+nk1) 	endif 	return  	end 	function dix_util_tfas(log) 	implicit none co 	logical log 	character*(*) dix_util_tfas c#
 	if(log) thenu 	  dix_util_tfas = 'True'  	elsem 	  dix_util_tfas = 'False' 	end ife 	return  	end 	function vms_vers 	implicit none c( 	include 'dix_def.inc' c ' c Deliver the vms-version in an integerd c maj*100+min*10+patch c for example 7.3-1 => 731 cl 	integer*4 vms_vers	 c#) 	character*(max_short_line_length) stringi 	include '($syidef)' 	integer*4 nk,majv,minv,patchr ce) 	call lib$getsyi(syi$_version,,string,nk)a c ( 	read(string(1:nk),2000) majv,minv,patch 2000	format(1x,i1,1x,i1,1x,i1) cr" 	vms_vers = majv*100+minv*10+patch 	return  	end	e0 	function dix_util_check_field(field,fields,idx) 	implicit none c  	include 'dix_def.inc' cp6 c Check if field is on of the fields allowed in fields. c field can be abbreviated, but must be unique. c fields is a list of strings separated by a | c-- 	character*(*) field	!:i: the searched stringi. 	character*(*) fields	!:i: the allowed strings& 	integer*4 idx		!:o: the number (0..n)) 	integer dix_util_check_field	!:f: result  c#$ 	character*(max_line_length) element 	integer*4 nk2,nk1,k,istat c  	integer*4 dix_util_get_lend 	external dix_msg_ambign 	external dix_msg_wrargval 	logical str$element ci 	nk1 = dix_util_get_len(field)	 	idx = -1  c 
         k = 0 3         do while(str$element(element,k,'|',fields))l)           nk2 = dix_util_get_len(element)            if(nk1 .le. nk2) then,5             if(field(1:nk1) .eq. element(1:nk1)) thend cuB c Match complete, if we have a complete match, do not look further cd#               if(nk1 .eq. nk2) thenh 	        idx = k                 goto 90i               endif= c'2 c Check if we have more than one match, if so exit cf!               if(idx .ge. 0) theni+                 istat = %loc(dix_msg_ambig)'                 goto 99e               endif  c  c Remember we matched here ci               idx = kv             endifi           endifn 	  k = k + 1 	end dom 90	if(idx .lt. 0) then! 	  istat = %loc(dix_msg_wrargval)) 	elsec 	  istat = 1 	endif 99	dix_util_check_field = istatt 	returne 	end( 	subroutine vm_info(control,full,detail) 	implicit none c  	include 'dix_def.inc' ce 	integer*4 control
 	logical fulll 	logical detaili c#! 	integer*4 context,zone,full_flag( 	integer*4 lib$find_vm_zone1 	external vm_info_printp c * 	call lib$show_vm(0,vm_info_print,control)* 	call lib$show_vm(4,vm_info_print,control) ch 	context = 0 	full_flag             = 0 	if(full)   full_flag  = 1 	if(detail) full_flag  = 3 ce* 	do while (lib$find_vm_zone(context,zone))> 	  call lib$show_vm_zone(zone,full_flag,vm_info_print,control) 	end dot 	returnl 	end% 	function vm_info_print(line,control)e 	implicit none cl 	character*(*) linef 	integer*4 control 	integer*4 vm_info_print c# 	integer*4 istat 	integer*4 dix_dump_print_line c	, 	istat = dix_dump_print_line(control,2,line) 	vm_info_print = istat 	returnt 	end6 	subroutine init_vm(control,vm_zone,recsiz,name,dzero) 	implicit none c . c Create a vm_zone, simplified interface to vm cd 	include 'dix_def.inc', 	record /control/ control	!:I; control block- 	record /vm_zone/ vm_zone	!:io: block address . 	integer*4 recsiz		!:i: recordsize, 0=variable& 	character*(*) name		!:i: name of zone" 	logical dzero			!:i: demand zero  c# 	include '($libvmdef)' c   	integer*4 istat,algor,flags,nk1 	integer*4 lib$create_vm_zones co! 	character*(max_line_length) line  c  	algor = lib$k_vm_first_fit') 	if(recsiz .gt. 0) algor = lib$k_vm_fixed 
 	flags = 0% 	if(dzero) flags = lib$m_vm_get_fill0e c 6 	istat = lib$create_vm_zone(vm_zone.zone,algor,recsiz,      1       flags,,,,,,,name)- 	if(.not. istat) call lib$signal(%val(istat))14 	control.n_vm_area_crea = control.n_vm_area_crea + 1 	vm_zone.n_alloc    = 0e 	vm_zone.nb_alloc   = 0r 	vm_zone.n_dealloc  = 0o 	vm_zone.nb_dealloc = 0, 	vm_zone.name       = name ce9 	call dix_util_link_in(vm_zone.link,control.top_vm_zones)  c / 	if((control.debug .and. debug_vm) .ne. 0) then $ 	  call sys$fao('!AS',nk1,line,name)% 	  if(algor .eq. lib$k_vm_fixed) thene& 	    call dix_append(nk1,line,' FIX')  	  elsec, 	    call dix_append(nk1,line,' First Fit')  	  endif/ 	  if(dzero) call dix_append(nk1,line,' DZERO')l. 	  call dix_main_print_debug(control,debug_vm,>      1                  'VM zone   '//line(1:nk1)//' created') 	endif 	returnr 	end; 	subroutine get_vm(control,size,pointer,vm_zone,clear,name)  	implicit none cd c Allocate memoryk c  	include 'dix_def.inc' c		 , 	record /control/ control	!:i: control block 	integer*4 size			!:i: sizee  	integer*4 pointer		!:o: pointer) 	record /vm_zone/ vm_zone	!:io: zone info:" 	logical clear			!:i: init to zero3 	character*(*) name		!:i: name of item (debug only)  c# 	integer*4 ptr,istat 	integer*4 lib$get_vmn 	integer*4 dix_util_get_len_fu ci 	integer*4 nk1! 	character*(max_line_length) line  ci* 	istat = lib$get_vm(size,ptr,vm_zone.zone)- 	if(.not. istat) call lib$signal(%val(istat))s( 	vm_zone.n_alloc  = vm_zone.n_alloc  + 1+ 	vm_zone.nb_alloc = vm_zone.nb_alloc + sizel! 	vm_zone.magic    = magic_vm_zone  cr 	pointer = ptr3 	if(clear) call dix_util_fill(0,size,%val(pointer)))/ 	if((control.debug .and. debug_vm) .ne. 0) then * 	  nk1 = dix_util_get_len_fu(vm_zone.name)@ 	  call sys$fao('!AS(!AS), !UL bytes allocated, address = !8XL',9      1                 nk1,line,vm_zone.name(1:nk1),name, ,      1                 %val(size),%val(ptr))1 	  if(clear) call dix_append(nk1,line,' Cleared') . 	  call dix_main_print_debug(control,debug_vm,2      1                  '  VM zone '//line(1:nk1)) 	endif 	return  	end1 	subroutine free_vm(control,size,pointer,vm_zone)c 	implicit none cs2 c Free memory, simplified interface to lib$free_vm cl 	include 'dix_def.inc' c , 	record /control/ control	!:i: control block% 	integer*4 size			!:i: #bytes to freer. 	integer*4 pointer               !:io: pointer 	record /vm_zone/ vm_zonen c# 	integer*4 istat,nk1 	integer*4 lib$free_vm c ! 	character*(max_line_length) line  	integer*4 dix_util_get_len_fu c / 	istat = lib$free_vm(size,pointer,vm_zone.zone) - 	if(.not. istat) call lib$signal(%val(istat))k, 	vm_zone.n_dealloc  = vm_zone.n_dealloc  + 1/ 	vm_zone.nb_dealloc = vm_zone.nb_dealloc + sizel c_/ 	if((control.debug .and. debug_vm) .ne. 0) thenn* 	  nk1 = dix_util_get_len_fu(vm_zone.name)= 	  call sys$fao('!AS, !UL bytes deallocated, address = !8XL', 4      1                 nk1,line,vm_zone.name(1:nk1),0      1                 %val(size),%val(pointer)). 	  call dix_main_print_debug(control,debug_vm,1      1                 '  VM zone '//line(1:nk1))e 	endif) 	pointer = 0		!make sure not reffed again  cd 	return_ 	end& 	subroutine delete_vm(control,vm_zone) 	implicit none cw 	include 'dix_def.inc' 	record /control/ control  	record /vm_zone/ vm_zonep c# 	integer*4 istat 	integer*4 lib$delete_vm_zonei 	integer*4 dix_util_get_len_fu c  	integer*4 nk1! 	character*(max_line_length) lines cr/ 	if((control.debug .and. debug_vm) .ne. 0) thenp* 	  nk1 = dix_util_get_len_fu(vm_zone.name)< 	  call sys$fao('!AS, deleted',nk1,line,vm_zone.name(1:nk1)). 	  call dix_main_print_debug(control,debug_vm,2      1                  'VM zone   '//line(1:nk1)) 	endif cx c Link out of the list ce: 	call dix_util_link_out(vm_zone.link,control.top_vm_zones) c ) 	istat = lib$delete_vm_zone(vm_zone.zone)x- 	if(.not. istat) call lib$signal(%val(istat))p4 	control.n_vm_area_dele = control.n_vm_area_dele + 1 	returns 	end* 	subroutine dix_util_show_vm_link(control) 	implicit none ct 	include 'dix_def.inc' 	record /control/ control  c  	record /vm_zone/ vm_zonet 	pointer (p_vm_zone,vm_zone)
 	logical*4 fii cg! 	p_vm_zone = control.top_vm_zones  	fi = .true. 	do while(p_vm_zone .ne. 0) 		/ 	  call dix_util_show_vm1(control,vm_zone,fi,1)i  	  p_vm_zone = vm_zone.link.forw 	end do_ 	returna 	end  % 	subroutine dix_util_show_vm(control)o 	implicit none ct 	include 'dix_def.inc' 	record /control/ control	 c# 	record /file_info/ file 	pointer (p_file,file) c ! 	character*(max_line_length) lineo
 	integer*4 nk  c # 	record /des_expanded/ des_expanded & 	pointer (p_des_expanded,des_expanded) c, 	record /des_info/ des_infot 	pointer (p_des_info,des_info) 	logical fi. c_ 	fi = .true. cs4 	call dix_dump_print_line(control,0,'VM activities') c @ 	call sys$fao('VM Zones     Opened !10UL deleted !10UL',nk,line,-      1          %val(control.n_vm_area_crea),n-      1          %val(control.n_vm_area_dele))y/ 	call dix_dump_print_line(control,0,line(1:nk))d ci@ 	call sys$fao('Memory files Opened !10UL deleted !10UL',nk,line,0      1          %val(control.n_memfiles_opened),0      1          %val(control.n_memfiles_closed))/ 	call dix_dump_print_line(control,0,line(1:nk))i c	7 	call dix_util_show_vm1(control,control.zone_file,fi,0) 8 	call dix_util_show_vm1(control,control.zone_descr,fi,0) 	p_file = control.top_file 	do while(p_file .ne. 0)& 	  call dix_dump_print_line(control,0,/      1      'File '//file.fnam(1:file.nk_fnam))n  	  p_des_expanded = file.top_des( 	  call dix_fastio_show_vm(control,file)# 	  do while(p_des_expanded .ne. 0) t) 	    p_des_info = des_expanded.p_des_infou 	   ( 	    call dix_dump_print_line(control,1,=      1      'Descriptor '//des_info.fnam(1:des_info.nk_fnam))a< 	    call dix_util_show_vm1(control,des_info.zone_file,fi,2)? 	    call dix_util_show_vm1(control,des_expanded.zone_rec,fi,2)), 	    p_des_expanded = des_expanded.link.forw	 	  end do4 	  p_file = file.link.forw 	end doh8 	call dix_util_show_vm1(control,control.zone_cfile,fi,0)( 	call dix_dump_inter_show_vm(control,fi): 	call dix_util_show_vm1(control,control.zone_general,fi,0)8 	call dix_util_show_vm1(control,control.zone_links,fi,0)$ 	call dix_symbol_show_vm(control,fi)% 	call dix_keydefs_show_vm(control,fi)  	returnn 	end7 	subroutine dix_util_show_vm1(control,vm_zone,fi,level)e 	implicit none c  	include 'dix_def.inc' 	record /control/ control	 	record /vm_zone/ vm_zoneo 	logical fit 	integer*4 level c#" 	character*(max_screen_width) line 	integer*4 nk,nk_w c1' 	character*(max_short_line_length) textt cg  	if(vm_zone.zone .eq. 0) goto 90 	nk_w = len(vm_zone.name)4 	if(fi) then: 	  call sys$fao('!#AS !8AS !7AS !10AS !7AS !10AS',nk,line,*      1          %val(nk_w),%Descr('Name'),"      1          %descr('Address'),"      1          %descr('n_alloc'),%      1          %descr('  nb_alloc'), "      1          %descr('n_deall'),%      1          %descr('  nb_deall'))  	  fi = .false. 1 	  call dix_dump_print_line(control,0,line(1:nk))  	end ifi 	text = ' '.7 	call sys$fao('!AS !8XL !7UL !10UL !7UL !10UL',nk,line,u:      1          text(1:level)//vm_zone.name(1:nk_w-level),#      1          %val(vm_zone.zone), &      1          %val(vm_zone.n_alloc),'      1          %val(vm_zone.nb_alloc), (      1          %val(vm_zone.n_dealloc),)      1          %val(vm_zone.nb_dealloc))o/ 	call dix_dump_print_line(control,0,line(1:nk))!	 90	returnt 	end) 	subroutine cnv_forterr_message(ier,line). 	implicit none c(! c Convert a fortran error to text4 c_& 	integer*4 ier		!:i: the fortran error! 	character*(*) line	!:o: the textc c# 	line = ' 't5 	if(ier .eq. '00000001'X) line = 'FOR$IOS_NOTFORSPE 't2 	if(ier .eq. '00000002'X) line = 'FOR$IOS_NOTIMP '3 	if(ier .eq. '00000003'X) line = 'FOR$IOS_IGNORED 'i5 	if(ier .eq. '00000004'X) line = 'FOR$IOS_IGNNOTDEL 't0 	if(ier .eq. '00000005'X) line = 'FOR$IOS_INFO '3 	if(ier .eq. '00000006'X) line = 'FOR$IOS_VERSION ' 5 	if(ier .eq. '00000008'X) line = 'FOR$IOS_BUG_CHECK ',5 	if(ier .eq. '00000009'X) line = 'FOR$IOS_PERACCFIL ' 5 	if(ier .eq. '0000000A'X) line = 'FOR$IOS_CANOVEEXI ' 5 	if(ier .eq. '0000000B'X) line = 'FOR$IOS_UNINOTCON 'l5 	if(ier .eq. '00000011'X) line = 'FOR$IOS_SYNERRNAM ' 5 	if(ier .eq. '00000012'X) line = 'FOR$IOS_TOOMANVAL ' 5 	if(ier .eq. '00000013'X) line = 'FOR$IOS_INVREFVAR ' 2 	if(ier .eq. '00000014'X) line = 'FOR$IOS_REWERR '5 	if(ier .eq. '00000015'X) line = 'FOR$IOS_DUPFILSPE ' 5 	if(ier .eq. '00000016'X) line = 'FOR$IOS_INPRECTOO ' 2 	if(ier .eq. '00000017'X) line = 'FOR$IOS_BACERR '5 	if(ier .eq. '00000018'X) line = 'FOR$IOS_ENDDURREA 'e5 	if(ier .eq. '00000019'X) line = 'FOR$IOS_RECNUMOUT 'e5 	if(ier .eq. '0000001A'X) line = 'FOR$IOS_OPEDEFREQ 'r5 	if(ier .eq. '0000001B'X) line = 'FOR$IOS_TOOMANREC ' 2 	if(ier .eq. '0000001C'X) line = 'FOR$IOS_CLOERR '5 	if(ier .eq. '0000001D'X) line = 'FOR$IOS_FILNOTFOU 'i2 	if(ier .eq. '0000001E'X) line = 'FOR$IOS_OPEFAI '5 	if(ier .eq. '0000001F'X) line = 'FOR$IOS_MIXFILACC '_5 	if(ier .eq. '00000020'X) line = 'FOR$IOS_INVLOGUNI 'f5 	if(ier .eq. '00000021'X) line = 'FOR$IOS_ENDFILERR '(5 	if(ier .eq. '00000022'X) line = 'FOR$IOS_UNIALROPE ',5 	if(ier .eq. '00000023'X) line = 'FOR$IOS_SEGRECFOR ' 5 	if(ier .eq. '00000024'X) line = 'FOR$IOS_ATTACCNON 'e5 	if(ier .eq. '00000025'X) line = 'FOR$IOS_INCRECLEN 't5 	if(ier .eq. '00000026'X) line = 'FOR$IOS_ERRDURWRI 'l5 	if(ier .eq. '00000027'X) line = 'FOR$IOS_ERRDURREA 'm5 	if(ier .eq. '00000028'X) line = 'FOR$IOS_RECIO_OPE 'd5 	if(ier .eq. '00000029'X) line = 'FOR$IOS_INSVIRMEM 'z5 	if(ier .eq. '0000002A'X) line = 'FOR$IOS_NO_SUCDEV 'e5 	if(ier .eq. '0000002B'X) line = 'FOR$IOS_FILNAMSPE ' 5 	if(ier .eq. '0000002C'X) line = 'FOR$IOS_INCRECTYP ' 5 	if(ier .eq. '0000002D'X) line = 'FOR$IOS_KEYVALERR 'n5 	if(ier .eq. '0000002E'X) line = 'FOR$IOS_INCOPECLO 'u5 	if(ier .eq. '0000002F'X) line = 'FOR$IOS_WRIREAFIL ' 5 	if(ier .eq. '00000030'X) line = 'FOR$IOS_INVARGFOR '_5 	if(ier .eq. '00000031'X) line = 'FOR$IOS_INVKEYSPE 't5 	if(ier .eq. '00000032'X) line = 'FOR$IOS_INCKEYCHG 'r5 	if(ier .eq. '00000033'X) line = 'FOR$IOS_INCFILORG 'a5 	if(ier .eq. '00000034'X) line = 'FOR$IOS_SPERECLOC 't5 	if(ier .eq. '00000035'X) line = 'FOR$IOS_NO_CURREC ' 5 	if(ier .eq. '00000036'X) line = 'FOR$IOS_REWRITERR 'd2 	if(ier .eq. '00000037'X) line = 'FOR$IOS_DELERR '2 	if(ier .eq. '00000038'X) line = 'FOR$IOS_UNLERR '2 	if(ier .eq. '00000039'X) line = 'FOR$IOS_FINERR '2 	if(ier .eq. '0000003A'X) line = 'FOR$IOS_FMTSYN '5 	if(ier .eq. '0000003B'X) line = 'FOR$IOS_LISIO_SYN ' 5 	if(ier .eq. '0000003C'X) line = 'FOR$IOS_INFFORLOO 'a5 	if(ier .eq. '0000003D'X) line = 'FOR$IOS_FORVARMIS 'e5 	if(ier .eq. '0000003E'X) line = 'FOR$IOS_SYNERRFOR '	5 	if(ier .eq. '0000003F'X) line = 'FOR$IOS_OUTCONERR '(5 	if(ier .eq. '00000040'X) line = 'FOR$IOS_INPCONERR 'n2 	if(ier .eq. '00000041'X) line = 'FOR$IOS_FLTINV '5 	if(ier .eq. '00000042'X) line = 'FOR$IOS_OUTSTAOVE 'o5 	if(ier .eq. '00000043'X) line = 'FOR$IOS_INPSTAREQ 't5 	if(ier .eq. '00000044'X) line = 'FOR$IOS_VFEVALERR 'l2 	if(ier .eq. '00000045'X) line = 'FOR$IOS_SIGINT '2 	if(ier .eq. '00000046'X) line = 'FOR$IOS_INTOVF '2 	if(ier .eq. '00000047'X) line = 'FOR$IOS_INTDIV '2 	if(ier .eq. '00000048'X) line = 'FOR$IOS_FLTOVF '2 	if(ier .eq. '00000049'X) line = 'FOR$IOS_FLTDIV '2 	if(ier .eq. '0000004A'X) line = 'FOR$IOS_FLTUND '2 	if(ier .eq. '0000004B'X) line = 'FOR$IOS_SIGFPE '2 	if(ier .eq. '0000004C'X) line = 'FOR$IOS_SIGIOT '2 	if(ier .eq. '0000004D'X) line = 'FOR$IOS_SUBRNG '3 	if(ier .eq. '0000004E'X) line = 'FOR$IOS_SIGTERM ' 3 	if(ier .eq. '0000004F'X) line = 'FOR$IOS_SIGQUIT 's5 	if(ier .eq. '00000050'X) line = 'FOR$IOS_WRONUMARG 'i5 	if(ier .eq. '00000051'X) line = 'FOR$IOS_INVARGMAT 'i2 	if(ier .eq. '00000052'X) line = 'FOR$IOS_UNDEXP '5 	if(ier .eq. '00000053'X) line = 'FOR$IOS_LOGZERNEG 'e5 	if(ier .eq. '00000054'X) line = 'FOR$IOS_SQUROONEG ' 5 	if(ier .eq. '00000057'X) line = 'FOR$IOS_SIGLOSMAT 't5 	if(ier .eq. '00000058'X) line = 'FOR$IOS_FLOOVEMAT 'h5 	if(ier .eq. '00000059'X) line = 'FOR$IOS_FLOUNDMAT 't5 	if(ier .eq. '0000005D'X) line = 'FOR$IOS_ADJARRDIM 's5 	if(ier .eq. '0000005E'X) line = 'FOR$IOS_INVMATKEY 'e5 	if(ier .eq. '0000006C'X) line = 'FOR$IOS_CANSTAFIL 'o5 	if(ier .eq. '00000078'X) line = 'FOR$IOS_OPEREQSEE 's6 	if(ier .eq. '00000082'X) line = 'FOR$IOS_BRK_USERBP '8 	if(ier .eq. '00000083'X) line = 'FOR$IOS_BRK_KERNELBP '8 	if(ier .eq. '00000085'X) line = 'FOR$IOS_BRK_BD_TAKEN '; 	if(ier .eq. '00000086'X) line = 'FOR$IOS_BRK_BD_NOTTAKEN 'y7 	if(ier .eq. '00000087'X) line = 'FOR$IOS_BRK_SSTEPBP 'y8 	if(ier .eq. '00000088'X) line = 'FOR$IOS_BRK_OVERFLOW '7 	if(ier .eq. '00000089'X) line = 'FOR$IOS_BRK_DIVZERO 'e5 	if(ier .eq. '0000008A'X) line = 'FOR$IOS_BRK_RANGE 'e6 	if(ier .eq. '0000008B'X) line = 'FOR$IOS_BRK_RANGE2 '2 	if(ier .eq. '0000008C'X) line = 'FOR$IOS_FLTINE '2 	if(ier .eq. '0000008D'X) line = 'FOR$IOS_DECOVF '2 	if(ier .eq. '0000008E'X) line = 'FOR$IOS_DECDIV '2 	if(ier .eq. '0000008F'X) line = 'FOR$IOS_DECINV '3 	if(ier .eq. '00000090'X) line = 'FOR$IOS_ROPRAND ' 5 	if(ier .eq. '00000091'X) line = 'FOR$IOS_ASSERTERR 'c5 	if(ier .eq. '00000092'X) line = 'FOR$IOS_NULPTRERR 'n2 	if(ier .eq. '00000093'X) line = 'FOR$IOS_STKOVF '5 	if(ier .eq. '00000094'X) line = 'FOR$IOS_STRLENERR ' 5 	if(ier .eq. '00000095'X) line = 'FOR$IOS_SUBSTRERR ''4 	if(ier .eq. '00000096'X) line = 'FOR$IOS_RANGEERR '6 	if(ier .eq. '00000097'X) line = 'FOR$IOS_INVREALLOC '5 	if(ier .eq. '00000098'X) line = 'FOR$IOS_RESACQFAI ' 6 	if(ier .eq. '00000099'X) line = 'FOR$IOS_INVDEALLOC '7 	if(ier .eq. '000000AD'X) line = 'FOR$IOS_INVDEALLOC2 'd8 	if(ier .eq. '000000AF'X) line = 'FOR$IOS_SHORTDATEARG '8 	if(ier .eq. '000000B0'X) line = 'FOR$IOS_SHORTTIMEARG '8 	if(ier .eq. '000000B1'X) line = 'FOR$IOS_SHORTZONEARG '/ 	if(ier .eq. '000000B2'X) line = 'FOR$IOS_DIV 'w6 	if(ier .eq. '000000B3'X) line = 'FOR$IOS_ARRSIZEOVF '5 	if(ier .eq. '00000100'X) line = 'FOR$IOS_UNFIO_FMT '(5 	if(ier .eq. '00000101'X) line = 'FOR$IOS_FMTIO_UNF 'c5 	if(ier .eq. '00000102'X) line = 'FOR$IOS_DIRIO_KEY '.5 	if(ier .eq. '00000103'X) line = 'FOR$IOS_SEQIO_DIR ' 5 	if(ier .eq. '00000104'X) line = 'FOR$IOS_KEYIO_DIR '_5 	if(ier .eq. '00000107'X) line = 'FOR$IOS_OPEREQDIS '(5 	if(ier .eq. '00000108'X) line = 'FOR$IOS_OPEREQSEQ ' 5 	if(ier .eq. '00000109'X) line = 'FOR$IOS_PROABOUSE ' 5 	if(ier .eq. '0000010A'X) line = 'FOR$IOS_FLOCONFAI 'b5 	if(ier .eq. '0000010C'X) line = 'FOR$IOS_ENDRECDUR ',5 	if(ier .eq. '00000128'X) line = 'FOR$IOS_FLOINEEXC '(5 	if(ier .eq. '00000129'X) line = 'FOR$IOS_FLOINVEXC 'f5 	if(ier .eq. '0000012A'X) line = 'FOR$IOS_FLOOVFEXC ' 6 	if(ier .eq. '0000012B'X) line = 'FOR$IOS_FLODIV0EXC '5 	if(ier .eq. '0000012C'X) line = 'FOR$IOS_FLOUNDEXC ' 5 	if(ier .eq. '0000018F'X) line = 'FOR$IOS_MSGBUFOVF 'r6 	if(ier .eq. '00000190'X) line = 'FOR$IOS_DIAGNOSTIC '1 	if(ier .eq. '0000021C'X) line = 'FOR$IOS_F6096 'l1 	if(ier .eq. '0000021D'X) line = 'FOR$IOS_F6097 't1 	if(ier .eq. '0000021E'X) line = 'FOR$IOS_F6098 't1 	if(ier .eq. '0000021F'X) line = 'FOR$IOS_F6099 'n1 	if(ier .eq. '00000220'X) line = 'FOR$IOS_F6100 ' 1 	if(ier .eq. '00000221'X) line = 'FOR$IOS_F6101 '$1 	if(ier .eq. '00000222'X) line = 'FOR$IOS_F6102 'x1 	if(ier .eq. '00000223'X) line = 'FOR$IOS_F6103 ' 1 	if(ier .eq. '00000224'X) line = 'FOR$IOS_F6104 ' 1 	if(ier .eq. '00000225'X) line = 'FOR$IOS_F6105 's1 	if(ier .eq. '00000226'X) line = 'FOR$IOS_F6106 'e1 	if(ier .eq. '00000227'X) line = 'FOR$IOS_F6200 'd1 	if(ier .eq. '00000228'X) line = 'FOR$IOS_F6201 'd1 	if(ier .eq. '00000229'X) line = 'FOR$IOS_F6202 'i1 	if(ier .eq. '0000022A'X) line = 'FOR$IOS_F6203 'i1 	if(ier .eq. '0000022B'X) line = 'FOR$IOS_F6204 'i1 	if(ier .eq. '0000022C'X) line = 'FOR$IOS_F6205 '!1 	if(ier .eq. '0000022D'X) line = 'FOR$IOS_F6206 ' 1 	if(ier .eq. '0000022E'X) line = 'FOR$IOS_F6207 'e1 	if(ier .eq. '0000022F'X) line = 'FOR$IOS_F6208 'p1 	if(ier .eq. '00000230'X) line = 'FOR$IOS_F6209 'e1 	if(ier .eq. '00000231'X) line = 'FOR$IOS_F6210 'i1 	if(ier .eq. '00000232'X) line = 'FOR$IOS_F6211 ' 1 	if(ier .eq. '00000233'X) line = 'FOR$IOS_F6212 'y1 	if(ier .eq. '00000234'X) line = 'FOR$IOS_F6213 'd1 	if(ier .eq. '00000235'X) line = 'FOR$IOS_F6214 '(1 	if(ier .eq. '00000236'X) line = 'FOR$IOS_F6300 'c1 	if(ier .eq. '00000237'X) line = 'FOR$IOS_F6301 ' 1 	if(ier .eq. '00000238'X) line = 'FOR$IOS_F6302 '$1 	if(ier .eq. '00000239'X) line = 'FOR$IOS_F6303 'e1 	if(ier .eq. '0000023A'X) line = 'FOR$IOS_F6304 '_1 	if(ier .eq. '0000023B'X) line = 'FOR$IOS_F6305 's1 	if(ier .eq. '0000023C'X) line = 'FOR$IOS_F6306 't1 	if(ier .eq. '0000023D'X) line = 'FOR$IOS_F6307 ' 1 	if(ier .eq. '0000023E'X) line = 'FOR$IOS_F6308 '$1 	if(ier .eq. '0000023F'X) line = 'FOR$IOS_F6309 'f1 	if(ier .eq. '00000240'X) line = 'FOR$IOS_F6310 '$1 	if(ier .eq. '00000241'X) line = 'FOR$IOS_F6311 'i1 	if(ier .eq. '00000242'X) line = 'FOR$IOS_F6312 'a1 	if(ier .eq. '00000243'X) line = 'FOR$IOS_F6313 'b1 	if(ier .eq. '00000244'X) line = 'FOR$IOS_F6314 ' 1 	if(ier .eq. '00000245'X) line = 'FOR$IOS_F6315 'd1 	if(ier .eq. '00000246'X) line = 'FOR$IOS_F6316 ' 1 	if(ier .eq. '00000247'X) line = 'FOR$IOS_F6317 'o1 	if(ier .eq. '00000248'X) line = 'FOR$IOS_F6318 'g1 	if(ier .eq. '00000249'X) line = 'FOR$IOS_F6319 'n1 	if(ier .eq. '0000024A'X) line = 'FOR$IOS_F6400 'c1 	if(ier .eq. '0000024B'X) line = 'FOR$IOS_F6401 'i1 	if(ier .eq. '0000024C'X) line = 'FOR$IOS_F6402 ' 1 	if(ier .eq. '0000024D'X) line = 'FOR$IOS_F6403 'n1 	if(ier .eq. '0000024E'X) line = 'FOR$IOS_F6404 'b1 	if(ier .eq. '0000024F'X) line = 'FOR$IOS_F6405 ' 1 	if(ier .eq. '00000250'X) line = 'FOR$IOS_F6406 's1 	if(ier .eq. '00000251'X) line = 'FOR$IOS_F6407 't1 	if(ier .eq. '00000252'X) line = 'FOR$IOS_F6408 'a1 	if(ier .eq. '00000253'X) line = 'FOR$IOS_F6409 't1 	if(ier .eq. '00000254'X) line = 'FOR$IOS_F6410 'k1 	if(ier .eq. '00000255'X) line = 'FOR$IOS_F6411 'o1 	if(ier .eq. '00000256'X) line = 'FOR$IOS_F6412 'b1 	if(ier .eq. '00000257'X) line = 'FOR$IOS_F6413 '31 	if(ier .eq. '00000258'X) line = 'FOR$IOS_F6414 't1 	if(ier .eq. '00000259'X) line = 'FOR$IOS_F6415 'l1 	if(ier .eq. '0000025A'X) line = 'FOR$IOS_F6416 '(1 	if(ier .eq. '0000025B'X) line = 'FOR$IOS_F6417 'i1 	if(ier .eq. '0000025C'X) line = 'FOR$IOS_F6418 ' 1 	if(ier .eq. '0000025D'X) line = 'FOR$IOS_F6419 'n1 	if(ier .eq. '0000025E'X) line = 'FOR$IOS_F6420 's1 	if(ier .eq. '0000025F'X) line = 'FOR$IOS_F6421 'i1 	if(ier .eq. '00000260'X) line = 'FOR$IOS_F6422 'i1 	if(ier .eq. '00000261'X) line = 'FOR$IOS_F6423 '.1 	if(ier .eq. '00000262'X) line = 'FOR$IOS_F6424 'e1 	if(ier .eq. '00000263'X) line = 'FOR$IOS_F6425 'f1 	if(ier .eq. '00000264'X) line = 'FOR$IOS_F6500 ',1 	if(ier .eq. '00000265'X) line = 'FOR$IOS_F6501 't1 	if(ier .eq. '00000266'X) line = 'FOR$IOS_F6502 '41 	if(ier .eq. '00000267'X) line = 'FOR$IOS_F6503 'g1 	if(ier .eq. '00000268'X) line = 'FOR$IOS_F6504 'e1 	if(ier .eq. '00000269'X) line = 'FOR$IOS_F6505 ' 1 	if(ier .eq. '0000026A'X) line = 'FOR$IOS_F6506 'f1 	if(ier .eq. '0000026B'X) line = 'FOR$IOS_F6507 'i1 	if(ier .eq. '0000026C'X) line = 'FOR$IOS_F6508 'l1 	if(ier .eq. '0000026D'X) line = 'FOR$IOS_F6509 't1 	if(ier .eq. '0000026E'X) line = 'FOR$IOS_F6510 'o1 	if(ier .eq. '0000026F'X) line = 'FOR$IOS_F6511 'e1 	if(ier .eq. '00000270'X) line = 'FOR$IOS_F6512 'e1 	if(ier .eq. '00000271'X) line = 'FOR$IOS_F6513 '_1 	if(ier .eq. '00000272'X) line = 'FOR$IOS_F6514 'c1 	if(ier .eq. '00000273'X) line = 'FOR$IOS_F6515 'o1 	if(ier .eq. '00000274'X) line = 'FOR$IOS_F6516 '.1 	if(ier .eq. '00000275'X) line = 'FOR$IOS_F6600 '_1 	if(ier .eq. '00000276'X) line = 'FOR$IOS_F6601 'i1 	if(ier .eq. '00000277'X) line = 'FOR$IOS_F6602 'r1 	if(ier .eq. '00000278'X) line = 'FOR$IOS_F6700 'r1 	if(ier .eq. '00000279'X) line = 'FOR$IOS_F6701 'e1 	if(ier .eq. '0000027A'X) line = 'FOR$IOS_F6970 ' 1 	if(ier .eq. '0000027B'X) line = 'FOR$IOS_F6971 'i1 	if(ier .eq. '0000027C'X) line = 'FOR$IOS_F6972 'y1 	if(ier .eq. '0000027D'X) line = 'FOR$IOS_F6980 ',1 	if(ier .eq. '0000027E'X) line = 'FOR$IOS_F6981 ' 1 	if(ier .eq. '0000027F'X) line = 'FOR$IOS_F6982 'e1 	if(ier .eq. '00000280'X) line = 'FOR$IOS_F6983 'e1 	if(ier .eq. '00000281'X) line = 'FOR$IOS_F6984 'r1 	if(ier .eq. '00000282'X) line = 'FOR$IOS_F6985 '(1 	if(ier .eq. '00000283'X) line = 'FOR$IOS_F6986 ' 1 	if(ier .eq. '00000284'X) line = 'FOR$IOS_F6987 'n1 	if(ier .eq. '00000285'X) line = 'FOR$IOS_F6988 ' 1 	if(ier .eq. '00000286'X) line = 'FOR$IOS_F6989 'o1 	if(ier .eq. '00000287'X) line = 'FOR$IOS_F6990 'w1 	if(ier .eq. '00000288'X) line = 'FOR$IOS_F6991 'f1 	if(ier .eq. '00000289'X) line = 'FOR$IOS_F6992 ' 1 	if(ier .eq. '0000028A'X) line = 'FOR$IOS_F6993 'a1 	if(ier .eq. '0000028B'X) line = 'FOR$IOS_F6994 'h1 	if(ier .eq. '0000028C'X) line = 'FOR$IOS_F6995 'o1 	if(ier .eq. '0000028D'X) line = 'FOR$IOS_F6996 ')1 	if(ier .eq. '0000028E'X) line = 'FOR$IOS_F6997 'u1 	if(ier .eq. '0000028F'X) line = 'FOR$IOS_F6998 'd1 	if(ier .eq. '00000290'X) line = 'FOR$IOS_F6999 ''1 	if(ier .eq. '00000291'X) line = 'FOR$IOS_F6702 ' 1 	if(ier .eq. '00000292'X) line = 'FOR$IOS_F6703 ' 1 	if(ier .eq. '00000293'X) line = 'FOR$IOS_F6704 'i1 	if(ier .eq. '00000294'X) line = 'FOR$IOS_F6705 'r1 	if(ier .eq. '00000295'X) line = 'FOR$IOS_F6706 ' 1 	if(ier .eq. '00000296'X) line = 'FOR$IOS_F6707 '11 	if(ier .eq. '00000297'X) line = 'FOR$IOS_F6708 'X1 	if(ier .eq. '00000298'X) line = 'FOR$IOS_F6709 '-1 	if(ier .eq. '00000299'X) line = 'FOR$IOS_F6710 'a1 	if(ier .eq. '0000029A'X) line = 'FOR$IOS_F6711 'i1 	if(ier .eq. '0000029B'X) line = 'FOR$IOS_F6712 'e1 	if(ier .eq. '0000029C'X) line = 'FOR$IOS_F6713 'i1 	if(ier .eq. '0000029D'X) line = 'FOR$IOS_F6714 'a1 	if(ier .eq. '0000029E'X) line = 'FOR$IOS_F6715 '(1 	if(ier .eq. '0000029F'X) line = 'FOR$IOS_F6716 'i1 	if(ier .eq. '000002A0'X) line = 'FOR$IOS_F6717 '(1 	if(ier .eq. '000002A1'X) line = 'FOR$IOS_F6718 'i1 	if(ier .eq. '000002A2'X) line = 'FOR$IOS_F6719 ')1 	if(ier .eq. '000002A3'X) line = 'FOR$IOS_F6720 'a1 	if(ier .eq. '000002A4'X) line = 'FOR$IOS_F6721 '-1 	if(ier .eq. '000002A5'X) line = 'FOR$IOS_F6722 'i1 	if(ier .eq. '000002A6'X) line = 'FOR$IOS_F6723 '_1 	if(ier .eq. '000002A7'X) line = 'FOR$IOS_F6724 ' 1 	if(ier .eq. '000002A8'X) line = 'FOR$IOS_F6725 'h1 	if(ier .eq. '000002A9'X) line = 'FOR$IOS_F6726 'i1 	if(ier .eq. '000002AA'X) line = 'FOR$IOS_F6727 't1 	if(ier .eq. '000002AB'X) line = 'FOR$IOS_F6728 'k1 	if(ier .eq. '000002AC'X) line = 'FOR$IOS_F6729 ' 1 	if(ier .eq. '000002AD'X) line = 'FOR$IOS_F6730 'a1 	if(ier .eq. '000002AE'X) line = 'FOR$IOS_F6731 ' 1 	if(ier .eq. '000002AF'X) line = 'FOR$IOS_F6732 '_1 	if(ier .eq. '000002B0'X) line = 'FOR$IOS_F6733 'l1 	if(ier .eq. '000002B1'X) line = 'FOR$IOS_F6734 ' 1 	if(ier .eq. '000002B2'X) line = 'FOR$IOS_F6735 'a1 	if(ier .eq. '000002B3'X) line = 'FOR$IOS_F6736 ' 1 	if(ier .eq. '000002B4'X) line = 'FOR$IOS_F6737 ' 1 	if(ier .eq. '000002B5'X) line = 'FOR$IOS_F6738 'h1 	if(ier .eq. '000002B6'X) line = 'FOR$IOS_F6739 'i1 	if(ier .eq. '000002B7'X) line = 'FOR$IOS_F6740 ''1 	if(ier .eq. '000002B8'X) line = 'FOR$IOS_F6741 ' 1 	if(ier .eq. '000002B9'X) line = 'FOR$IOS_F6742 ' 1 	if(ier .eq. '000002BA'X) line = 'FOR$IOS_F6743 ' 1 	if(ier .eq. '000002BB'X) line = 'FOR$IOS_F6744 ' 1 	if(ier .eq. '000002BC'X) line = 'FOR$IOS_F6745 't1 	if(ier .eq. '000002BD'X) line = 'FOR$IOS_F6746 'e1 	if(ier .eq. '000002BE'X) line = 'FOR$IOS_F6747 'n1 	if(ier .eq. '000002BF'X) line = 'FOR$IOS_F6748 'g1 	if(ier .eq. '000002C0'X) line = 'FOR$IOS_F6749 ' 1 	if(ier .eq. '000002C1'X) line = 'FOR$IOS_F6750 's1 	if(ier .eq. '000002C2'X) line = 'FOR$IOS_F6751 'a1 	if(ier .eq. '000002C3'X) line = 'FOR$IOS_F6752 ' 1 	if(ier .eq. '000002C4'X) line = 'FOR$IOS_F6753 'i1 	if(ier .eq. '000002C5'X) line = 'FOR$IOS_F6754 'a1 	if(ier .eq. '000002C6'X) line = 'FOR$IOS_F6755 'e1 	if(ier .eq. '000002C7'X) line = 'FOR$IOS_F6756 'k1 	if(ier .eq. '000002C8'X) line = 'FOR$IOS_F6757 'i1 	if(ier .eq. '000002C9'X) line = 'FOR$IOS_F6758 ' 1 	if(ier .eq. '000002CA'X) line = 'FOR$IOS_F6759 'A1 	if(ier .eq. '000002CB'X) line = 'FOR$IOS_F6760 ' 1 	if(ier .eq. '000002CC'X) line = 'FOR$IOS_F6761 '.1 	if(ier .eq. '000002CD'X) line = 'FOR$IOS_F6762 ' 1 	if(ier .eq. '000002CE'X) line = 'FOR$IOS_F6763 ' 1 	if(ier .eq. '000002CF'X) line = 'FOR$IOS_F6764 ' 1 	if(ier .eq. '000002D0'X) line = 'FOR$IOS_F6765 ' 1 	if(ier .eq. '000002D1'X) line = 'FOR$IOS_F6766 'e1 	if(ier .eq. '000002D2'X) line = 'FOR$IOS_F6767 '.1 	if(ier .eq. '000002D3'X) line = 'FOR$IOS_F6768 ' 1 	if(ier .eq. '000002D4'X) line = 'FOR$IOS_F6769 't1 	if(ier .eq. '000002D5'X) line = 'FOR$IOS_F6770 ' 1 	if(ier .eq. '000002D6'X) line = 'FOR$IOS_F6771 '01 	if(ier .eq. '000002D7'X) line = 'FOR$IOS_F6772 't1 	if(ier .eq. '000002D8'X) line = 'FOR$IOS_F6773 '41 	if(ier .eq. '000002D9'X) line = 'FOR$IOS_F6774 'h1 	if(ier .eq. '000002DA'X) line = 'FOR$IOS_F6775 't1 	if(ier .eq. '000002DB'X) line = 'FOR$IOS_F6776 ' 1 	if(ier .eq. '000002DC'X) line = 'FOR$IOS_F6777 'x1 	if(ier .eq. '000002DD'X) line = 'FOR$IOS_F6778 ' 1 	if(ier .eq. '000002DE'X) line = 'FOR$IOS_F6779 '_1 	if(ier .eq. '000002DF'X) line = 'FOR$IOS_F6780 ' 1 	if(ier .eq. '000002E0'X) line = 'FOR$IOS_F6781 ',1 	if(ier .eq. '000002E1'X) line = 'FOR$IOS_F6782 ')1 	if(ier .eq. '000002E2'X) line = 'FOR$IOS_F6783 '/1 	if(ier .eq. '000002E3'X) line = 'FOR$IOS_F6784 'q1 	if(ier .eq. '000002E4'X) line = 'FOR$IOS_F6785 'e1 	if(ier .eq. '000002E5'X) line = 'FOR$IOS_F6786 't1 	if(ier .eq. '000002E6'X) line = 'FOR$IOS_F6787 ',1 	if(ier .eq. '000002E7'X) line = 'FOR$IOS_F6788 ' 1 	if(ier .eq. '000002E8'X) line = 'FOR$IOS_F6789 'k1 	if(ier .eq. '000002E9'X) line = 'FOR$IOS_F6790 'm1 	if(ier .eq. '000002EA'X) line = 'FOR$IOS_F6791 '(1 	if(ier .eq. '000002EB'X) line = 'FOR$IOS_F6792 's1 	if(ier .eq. '000002EC'X) line = 'FOR$IOS_F6793 ' 1 	if(ier .eq. '000002ED'X) line = 'FOR$IOS_F6794 'e1 	if(ier .eq. '000002EE'X) line = 'FOR$IOS_F6795 'h1 	if(ier .eq. '000002EF'X) line = 'FOR$IOS_F6796 't1 	if(ier .eq. '000002F0'X) line = 'FOR$IOS_F6797 'o1 	if(ier .eq. '000002F1'X) line = 'FOR$IOS_F6798 't1 	if(ier .eq. '000002F2'X) line = 'FOR$IOS_F6799 'i1 	if(ier .eq. '000002F3'X) line = 'FOR$IOS_F6800 ' 1 	if(ier .eq. '000002F4'X) line = 'FOR$IOS_F6801 'h1 	if(ier .eq. '000002F5'X) line = 'FOR$IOS_F6802 'i1 	if(ier .eq. '000002F6'X) line = 'FOR$IOS_F6803 'r1 	if(ier .eq. '000002F7'X) line = 'FOR$IOS_F6804 'd; 	if(ier .eq. '000002F8'X) line = 'FOR$IOS_MESSAGE_MAXIMUM 't 	returnu 	end@ 	subroutine dix_util_insert_string(control,descr,vm_zone,string) 	implicit none ci/ c Insert a string, allocate memory from zone_idM c  	include 'dix_def.inc'+ 	record /control/ control!:i: control block - 	record /strdef/ descr	!:io: strig descriptore% 	record /vm_zone/ vm_zone!:i: zone id 1 	character*(*) string	!:i: string to be inserterdp c#
 	integer*4 nbl c ) 	call dix_util_clear_descr(descr,.false.)d 	nb = len(string)= 	if(nb .gt. 0) thene6 	  call get_vm(control,nb,descr.dsc$a_pointer,vm_zone,-      1               .false.,'Insert_string') @ 	  call dix_util_copy(nb,%ref(string),%val(descr.dsc$a_pointer)) 	elsen 	  descr.dsc$a_pointer  = 0u 	endif/ 	call dix_util_copy(2,nb,descr.dsc$w_maxstrlen)e 	returnr 	end- 	subroutine dix_util_copy_string(source,dest)s 	implicit none cp5 c Copy a string, this allows descriptors to be copiede c   ( 	character*(*) source	!:i: source string& 	character*(*) dest	!:o: target string c# ce 	dest = source 	returnn 	end& 	subroutine dix_util_swap(word1,word2) 	implicit none ct 	integer*2 word1 	integer*2 word2 c. 	integer*2 temp  ci 	temp  = word1 	word1 = word2 3
 	word2 = temp  	return  	end$ 	function dix_util_str_eq(str1,str2) 	implicit none ck c Return true is str1 = str2 c  	character*(*) str1s 	character*(*) str2s 	logical dix_util_str_eq c ! 	dix_util_str_eq = str1 .eq. str2h 	return  	end/ 	subroutine dix_util_clear_descr(descr,dynamic)o 	implicit none ct! c Initialise a string descriptor l c  to either fixed or dynamic  ce 	include 'dix_def.inc' 	include '($dscdef)' 	record /strdef/ descr 	logical*4 dynamic c_ 	descr.dsc$w_maxstrlen = 0 	descr.dsc$a_pointer  = 0i# 	descr.dsc$b_dtype  = dsc$k_dtype_z= 	if(dynamic) then % 	  descr.dsc$b_class  = dsc$k_class_d) 	else % 	  descr.dsc$b_class  = dsc$k_class_zl 	endif 	returne 	end& 	subroutine dix_util_free_descr(descr) 	implicit none cd( c Free a string descriptor  (in dynamic) ct 	include 'dix_def.inc' 	include '($dscdef)' 	record /strdef/ descr ca 	integer*4 istat 	integer*4 str$free1_dx  ch. 	if(descr.dsc$b_class .eq. dsc$k_class_d) then& 	  if(descr.dsc$a_pointer .ne. 0) then'             istat = str$free1_dx(descr)(8             if(.not. istat) call lib$signal(%val(istat)) 	  endif 	  descr.dsc$w_maxstrlen = 0         end if 	return( 	end4 	function dix_util_conv_version_Ascint(version,iver) 	implicit none cl, c Convert a version string like 4.1-2 to 412 c 6 	character*(*) version          	!:i: the ascci string8 	integer*4 iver                  !:o: the binary version> 	integer*4 dix_util_conv_version_ascint !:f: conversion result c1/ 	integer*4 ipos,jpos,majver,minver,patver,istat_ 	external dix_msg_illverso c  c Locate the major version c) 	ipos = index(version,'.') 	if(ipos .eq. 0) thens c') c No dot, so this is only a major version  cd*           read(version,2000,err=85) majver 2000	  format(bn,i10)u           minver = 0           patver = 0         else cd c Upto the . is the major, o cx4           read(version(1:ipos-1),2000,err=85) majver ct! c See if we we can find the patch  cc,           jpos = index(version(ipos+1:),'-')           if(jpos .eq. 0) then co c No patch,  c 5             read(version(ipos+1:),2000,err=85) minver( 	    patver = 0)           else 	    jpos = jpos + ipos ;             read(version(ipos+1:jpos-1),2000,err=85) minver,5             read(version(jpos+1:),2000,err=85) patver  	  endif 	endif n' 	iver = majver*100 + minver*10 + patver 
 	istat = 1 	goto 90  85	istat = %loc(dix_msg_illvers)	 	iver = 0g' 90	dix_util_conv_version_ascint = istate 	returnh 	end9 	subroutine dix_util_conv_version_intasc(iver,version,nk)s 	implicit none c:* c Convert a version to a string line 4.1-2 ci8 	integer*4 iver                  !:i: the binary version6 	character*(*) version          	!:o: the ascci string: 	integer*4 nk                    !:o: length of the string cl# 	integer*4 majver,minver,patver,nk1i ce c Locate the major version c  	patver = mod(iver,10) 	minver = mod(iver/10,10)k 	majver = iver/100 c  	nk  = 0 	nk1 = 0= 	call sys$fao('!UL.!UL',nk,version,%val(majver),%val(minver))f 	if(patver .ne. 0) thent7 	  call sys$fao('-!UL',nk1,version(nk+1:),%val(patver))t 	  nk = nk + nk1 	endif 	return  	end c 1 	function dix_util_match_string_wild(data,search, /      1                 case_sens,wildcard_flag)c 	implicit none ch( c Match a record to a (wildcard) string A c in either none , standard(vms) or extended(unix) style wildcard'$ c  with case blind or case_sensitive c  the whole record must match ce 	include 'dix_def.inc'" 	character*(*) data		!:i: the data7 	character*(*) search            !:i: the search stringh( 	logical case_sens		!:i: case sensitive?+ 	integer*4 wildcard_flag		!:i: search flag _6 	integer dix_util_match_string_wild !:f: true or false c# cl 	integer*4 bpos,endpos,istat cc$ 	integer*4 dix_util_find_string_wild! 	integer*4 str$case_blind_comparei 	integer*4 str$match_wildz c, c Some shortcuts.r( c  if wild=node, it is just a eq compare cp/ 	if(wildcard_flag .eq. wildcard_flag_none) then  	  if(case_sens) theni 	    istat = data .eq. searcht 	  elsel7 	    istat = str$case_blind_compare(data,search) .eq. 0e	 	  endif f 	else3E 	  if(wildcard_flag .eq. wildcard_flag_standard .and. case_sens) theno( 	    istat = str$match_wild(data,search) 	  else  ct c Now the general comparef cr< 	    bpos = dix_util_find_string_wild(data,search,case_sens,>      1                                   wildcard_flag,endpos)8 	    istat = (bpos .eq. 1) .and. (endpos .eq. len(data)) 	  endif 	endif% 90	dix_util_match_string_wild = istatr 	return  	end cn0 	function dix_util_find_string_wild(data,search,6      1                 case_sens,wildcard_flag,endpos) 	implicit none ce' c Find a record to a (wildcard) string 	A c in either none , standard(vms) or extended(unix) style wildcard $ c  with case blind or case_sensitive c  the whole record must match c ) c In none mode no wildcards are supportedz c 4 c In standard mode the following chars are supported cf2 c *     : matches all substrings (0 of meer chars)  c %     : matches exactly 1 char cg; c In extended mode the following extra chars are recognized_ ce* c  [abc] : Matches a "a" or a "b" or a "c"( c  [-abc]: Matches anything except a,b,c$ c  [a-z] : Matches all letters (a-z)* c  [-a-z]: Matches anything except letters; c  'a    : Char "a" is not longer a special char ([*%' etc).L c  ~     : If in front of the searchstring , the searchstring must be in theD c          beginning of the line, if at the end of the searchstring,: c          the searchstring must be at the end of the line/ c  !     : Matches one or more whitespace charse c) 	include 'dix_def.inc'" 	character*(*) data		!:i: the data7 	character*(*) search            !:i: the search string ( 	logical case_sens		!:i: case sensitive?+ 	integer*4 wildcard_flag		!:i: search flag c, 	integer*4 endpos		!:o: endposition of match5 	integer dix_util_find_string_wild !:f: true or false  c# 	integer*4 bpos,epos 	logical*4 last,check_firstr& 	integer*4 dix_util_find_string_wild_r cz	 	bpos = 1m 	epos = len(search)i ci/ 	if(wildcard_flag .eq. wildcard_flag_none) theni ce2 c Locate mode, if not case sensitive, this is easy co 	  if(case_sens) then: 	    bpos = index(data,search)0 	    if(bpos .gt. 0) epos = bpos + len(search)-1 	    goto 90	 	  endif i7 	elseif(wildcard_flag .eq. wildcard_flag_extended) thene  	  if(search(1:1) .eq. '~') then
 	    bpos = 2l 	    check_first = .true.u 	  endif& 	  if(search(epos:epos) .eq. '~') then 	    last = .true. 	    epos = epos - 1 	  endif 	endif cz) 	bpos = dix_util_find_string_wild_r(data,(<      1                             search(bpos:epos),endpos,B      1                             case_sens,1,last,wildcard_flag)  + 	if(check_first .and. bpos .ne. 1) bpos = 0l 	if(bpos .eq. 0) endpos = 0 # 90	dix_util_find_string_wild = bpose 	return  	end 	options /recursive_9 	function dix_util_find_string_wild_r(data,search,endpos,cF      1                             case_sens,level,last,wildcard_flag) 	implicit none c  c wildcard search( ce 	include 'dix_def.inc' cc" 	character*(*) data		!:i: the line7 	character*(*) search            !:i: the search string 8 	integer endpos                  !:o: end pos on success5 	logical case_sens		!:i: If true, then case-sensitiveo: 	logical*4 last			!:i: true if must match agains last char 	integer*4 level			!:i: level'E 	integer*4 wildcard_flag		!:i: search flag none, standard or extendedrR 	integer dix_util_find_string_wild_r   !:f: begin pos of the match(0 if not found) c#2 	integer l,pos1,endpos1,spos,xpos,epos,nkd,nks,pos+ 	logical normal,neg,match,extended,standardn 	character kar_d,kar_s 	character kar_l,kar_h ct5 d	write(*,1000) '|'//data//'|','|'//search//'|',level 8 d1000	format(' Data = ',a30,' Sear = ',a20,' Level=',i5) 	nkd = len(data) 	nks = len(search) 	pos = 1 cz5 	extended = wildcard_flag .eq. wildcard_flag_extendedb: 	standard = wildcard_flag .eq. wildcard_flag_standard .or.      1             extendedU cy c Try to match all substrings'# c  pos = start position of the datam cn 	do while(pos .le. nkd)	 c 4 c Start search for search in substring data(pos:nkd) ct  	  spos = 1		!start for "search"/ 	  xpos = pos            !start for data stringf4 	  normal = .true.       !special chars have meaning c_& c Now go through all chars of "search" cn 	  do while(spos .le. nks) 	    if(normal) then cr c Special kars are interpreted co= 	      if    (standard .and. search(spos:spos) .eq. '%') thenn c  c Matches exactly one char+ c  so the spos and xpos must be incrementedl ct 	        spos = spos + 1 	        xpos = xpos + 1 	        goto 30= 	      elseif(standard .and. search(spos:spos) .eq. '*') thene c' c We have an *, $ c  this matches 0 or more characters cg 	        if(spos .eq. nks) then  c . c The * is the last char of the search string. c   Now the match is complete  c_ 	          xpos = nkd + 1c 	          goto 35 	        endif cd= c Try to match recursively with the rest of the search string% c   search(spos+1:nks) c_; 	        pos1 = dix_util_find_string_wild_r(data(xpos:nkd),o9      1                                search(spos+1:nks),iE      1                                endpos1,case_sens,level+1,last, 4      1                                wildcard_flag) 	        if(pos1 .ne. 0) thenv co c We have a match  c % 	          endpos = endpos1 + xpos -1_ 	          goto 90 	        endif 	        goto 40		!no match.> 	      elseif(extended .and. search(spos:spos) .eq. '''') then cr  c Next char is no longer special- c  if there is still a character after the ',  c increment spos ci# 	        if(spos .eq. nks) goto 20 a 	        normal = .false.o 	        spos   = spos + 1 	        goto 30= 	      elseif(extended .and. search(spos:spos) .eq. '[') thenr cd& c we found a [, see if we can find a ] cs 	        do epos=spos,nksf1 	          if(search(epos:epos) .eq. ']') goto 12, 	        end do  c 2 c not found, so now [ is regarded as a normal char c, 	        goto 20 c  c spos..epos contains [....] cn 12	        spos = spos + 1 	        neg = .false., 	        if(search(spos:spos) .eq. '-') then 	          neg = .true.r 	          spos = spos + 1 	        endif 	        l = sposv 	        if(case_sens) then," 	          kar_d = data(xpos:xpos)
 	        else 1 	          call str$upcase(kar_d,data(xpos:xpos))	 	        endif 	        do while (l .lt. epos)lD 	          if((l .lt. epos-2) .and. (search(l+1:l+1) .eq. '-')) then 	            if(case_sens) thenl" 	              kar_l = search(l:l) 	            else,1 	              call str$upcase(kar_l,search(l:l))  	            endif 	            if(case_sens) thens& 	              kar_h = search(l+2:l+2) 	            else 5 	              call str$upcase(kar_h,search(l+2:l+2))c 	            endif@ 	            match = (kar_d .ge. kar_l) .and. (kar_d .le. kar_h) 	            l = l + 3 	          else( 	            if(case_sens) then " 	              kar_s = search(l:l) 	            elsee1 	              call str$upcase(kar_s,search(l:l))o 	            endif% 	            match = kar_d .eq. kar_s  	            l = l + 1 	          endif 	          if(match) thent cs, c We found a match, if not negative, all oke; c If we had negative, no match so start next data substringt c C 	            if(.not. neg) goto 14	!een match, dus oke als niet neg . 	            if(neg) goto 40		!en fout als neg 	          endif 	        end dot c, c No match found,  c  if negative , all oke! c  else start next data substring  ctA 	        if(.not. neg) goto 40			!alles matched niet, oke als neg# cc& c the [..] matched eieter pos or neg, + c  so skip the [..] part and 1 char of datal ct 14	        spos = epos + 1 	        xpos = xpos + 1 	        goto 30= 	      elseif(extended .and. search(spos:spos) .eq. '!') then0 c,0 c Marches one or more whitespace (blank and tab) c  	        do l=xpos,nkdD 	          if(data(l:l) .ne. SPACE .and. data(l:l) .ne. TAB) goto 18 	        end do  	        l = nkd + 1 c_D c If we did not find one space, no match, so try next data substring cl" 18	        if(l .eq. xpos) goto 40 	        spos = spos + 1 	        xpos = la 	        goto 30 	      endif
 	    endif c 1 c No more special chars, now the bytes must matchv c Check valid char cv 20	    if(case_sens) then 9 	      if(data(xpos:xpos) .ne. search(spos:spos)) goto 40e	 	    else - 	      call str$upcase(kar_d,data(xpos:xpos)) / 	      call str$upcase(kar_s,search(spos:spos))_# 	      if(kar_d .ne. kar_s) goto 40!
 	    endif ce. c we have a match, so increment spos and xpos  cp 	    spos = spos + 1 	    xpos = xpos + 1 30	    normal = .true.	 	  end doe cr- c We found all chars of search, so we have it  c if the last is specified,.' c xpos must be at the end of the stringt ci) 35	  if(last .and. xpos .le. nkd) goto 40I 	  endpos = xpos - 1 c0 c Found a match$ c_
 	  goto 90 c(+ c No match , try the next substring of dataE ct 40	  pos = pos + 1 	end doi c= c Not found, so set pos to 0 c0 	pos = 0 ce c Return the pos   c $ 90	dix_util_find_string_wild_r = pos 	returnH 	endB         subroutine dix_util_set_bit_flag(token,field,bit,negative)         implicit none' c$' c Set a bit flag depending on the tokenX ci.         character*(*) token	!:i: the  cli name3         integer*4 field         !:i: bit mask field05         integer*4 bit           !:i: wanted bit(mask)0, 	logical*4 negative	!:i: reverse bit meaning c.         logical*4 lval cO4         lval = (field .and. bit) .ne. 0 !get the bit 	if(negative) lval = .not. lval05         field = field .and. (.not. bit) !and clear it0 cX*         call dix_util_set_flag(token,lval) c0 c And set it again (if wanted) c  	if(negative) lval = .not. lval''         if(lval) field = field .or. bit0         return         endE& 	function dix_util_set_flag(name,flag) 	implicit none c ( c Set the flag according to the presence  c  if (local) present : set flag" c  if (local) negated : clear flag) c  if neither         : do not touch flagF c' 	character*(*) name0 	logical*4 flag$1 	logical*4 dix_util_set_flag	!set if flag changed' c$ 	external cli$_present 	external cli$_negated 	external cli$_locpres 	external cli$_locneg2 c  	integer*4 istat 	integer*4 cli$present c0 	istat = cli$present(name) cC 	dix_util_set_flag = .false. c & 	if(istat .eq. %loc(cli$_present) .or..      1     istat .eq. %loc(cli$_locpres)) then 	  flag = .true. 	  dix_util_set_flag = .true.  	endif c & 	if(istat .eq. %loc(cli$_negated) .or.-      1     istat .eq. %loc(cli$_locneg)) thenO 	  flag = .false.( 	  dix_util_set_flag = .true.O 	endif 	returnz 	end/ 	subroutine dix_util_conv_fancy(kar,nam,nk_nam)e 	implicit none c0 	integer kar 	character*(*) nam 	integer*4 nk_nam0 c0 cX 	integer*4 dix_util_get_len  ci 	character*3 dix_util_c0_name' 	character*3 dix_util_c1_namee   c0 	nk_nam = 0e
 	nam = ' ' cO8 	if(kar .ge. 0 .and. kar .lt. 31 .or. kar .eq. 127) then# 	  nam = '<'//dix_util_c0_name(kar)e2 	elseif(kar .ge. 0+128 .and. kar .lt. 31+128 .or. !      1         kar .eq. 255) thene# 	  nam = '<'//dix_util_c1_name(kar)N 	endif# 	nk_nam = dix_util_get_len(nam) + 1' 	nam(nk_nam:nk_nam) = '>'	 	return0 	end  	function dix_util_c0_name(ikar) 	implicit none c0: c convert a character code in the c0 range to a fancy name ci 	integer*4 ikarR 	character*3 dix_util_c0_name7 c  	character*3 dix_util_extracte ce 	character*(*) names1 	parameter (names  = 'NULSOHSTXETXEOTENQACKBEL'//=8      1                      'BS HT LF VT FF CR SO SI '//8      1                      'DLEDC1DC2DC3DC4NAKSYNETB'//7      1                      'CANEM SUBESCFS GS RS US ')F( 	if(ikar .ge. 0 .and. ikar .le. 31) then8 	  dix_util_c0_name = dix_util_extract(names,ikar*3+1,3) 	elseif(ikar .eq. 127) then  	  dix_util_c0_name = 'DEL'$ 	elseC 	  dix_util_c0_name = ' '0 	endif 	returnO 	end  	function dix_util_c1_name(ikar) 	implicit none cO: c convert a character code in the c1 range to a fancy name c  	integer*4 ikar' 	character*3 dix_util_c1_nameS cE 	character*3 dix_util_extract  ce 	character*(*) names1 	parameter (names  = '128129130131INDNELSSAESA'//T8      1                      'HTSHTJVTSPLDPLURI SS2SS3'//8      1                      'DCSPU1PU2STSCDhMW SPAEPA'//7      1                      '152153154CSIST OSCPM APC')'0 	if(ikar .ge. 0+128 .and. ikar .lt. 31+128) then> 	  dix_util_c1_name = dix_util_extract(names,(ikar-128)*3+1,3) 	elseif(ikar .eq. 255) theni 	  dix_util_c1_name = '255'= 	elseO 	  dix_util_c1_name = ' '0 	endif 	return' 	end 	U 	function dix_util_c0_kar(name)  	implicit none cT( c convert a text name to a c0 range byte* c  if the name does not match, return a -1 ci 	character*(*) nameR 	integer*4 dix_util_c0_kar c  	integer*4 k cN 	character*(*) names1 	parameter (names  = 'NULSOHSTXETXEOTENQACKBEL'//e8      1                      'BS HT LF VT FF CR SO SI '//8      1                      'DLEDC1DC2DC3DC4NAKSYNETB'//7      1                      'CANEM SUBESCFS GS RS US ')0 	if(len(name) .gt. 3) goto 80E 	if(len(name) .lt. 2) goto 80X ci 	k = index(names,name)-1 	if(name .eq. 'DEL') k = 127*3 	if(3*(k/3) .ne. k) goto 80( 	goto 90 c0	 80	k = -1e 90	dix_util_c0_kar = k 	return  	end 	function dix_util_c1_kar(name)A 	implicit none c.: c convert a character code in the c1 range to a fancy name+ c  If the name does not match, return a --1e ce 	character*(*) name= 	integer*4 dix_util_c1_kar ce 	integer*4 k cX 	character*(*) names1 	parameter (names  = '128129130131INDNELSSAESA'//O8      1                      'HTSHTJVTSPLDPLURI SS2SS3'//8      1                      'DCSPU1PU2STSCDhMW SPAEPA'//7      1                      '152153154CSIST OSCPM APC')O 	if(len(name) .gt. 3) goto 80e 	if(len(name) .lt. 2) goto 80_ c_ 	k = index(names,name)-1 	if(name .eq. '255') k = 255*3 	if(3*(k/3) .ne. k) goto 80C 	k = k + 128 	goto 90 c'	 80	k = -1e 90	dix_util_c1_kar = k 	returnE 	end- 	function dix_util_extract(string,spos,nbyte)D 	implicit none c' c0 	character*(*) string_ 	integer*4 spos  	integer*4 nbyte 	character*(*) dix_util_extracte ce- 	dix_util_extract = string(spos:spos+nbyte-1)i 	return. 	end1 	subroutine dix_util_hex_conv(value,line,nk,perc)' 	implicit none c') c Convert an integer to a Hex format (pre & c if perc = true, insert a %X in front c' 	integer*4 value		!:i: value( 	character*(*) line      !:o: hex string 	integer*4 nk		!:o: length! 	logical*4 perc		!:i: INclude %X?O cN 	integer*4 k ce( 	call sys$fao('!XL',nk,line,%val(value)) 	do k=1,nk-1! 	  if(line(k:k) .ne. '0') goto 10_ 	end doC 	k = nke 10	if(perc) then 	  line = '%X'//line(k:nk) 	  nk =  2 + nk - k + 10 	elsei 	  line = line(k:nk) 	  nk   =  nk - k + 10 	endif 	return' 	end' 	subroutine dix_util_sign_extend(value)X 	implicit none cH cSign extend to i*8  c. 	integer*4 value(2)' c$ 	if(value(1) .ge. 0) then0 	  value(2) = 0' 	else_ 	  value(2) = -1 	endif 	return0 	end c=+ 	subroutine dix_util_init_table(table,size)1 	implicit none c_ 	include 'dix_def.inc' 	record /table/ table' 	integer*4 size  c . 	table.count     = 0	!nothing in the table yet( 	table.size      = size	!size of element, 	table.allocated = 0	!no bytes allocated yet+ 	table.address   = 0	!and no memory pointer'= 	table.magic     = magic_table !set magic word (sanity check)9 	return= 	end