F 	function dix_fastio_init(control,file,search_block_size,multi_buffer) 	implicit none c # c Now connect a channel to the file  c  	include 'dix_fastio_def.inc'  	include '($fabdef)' 	include '($namdef)' 	include '($fibdef)' 	include '($atrdef)' 	include '($efndef)' 	include '($iodef)'  c - 	record /control/ control	!:io: control block * 	record /file_info/ file		!:io: file block9 	integer*4 search_block_size  	!:i: block size for search * 	integer*4 multi_buffer		!:i: multi buffer* 	integer*4 dix_fastio_init	!:f: the result c#4 	integer*4 istat,k,des(2),addr,n,blnr,area_nr,offset c  	record /atrdef/ cblk(2)# 	record /rec_attributes/ rec_attrib  	record /fibdef/ fib c  	integer*4 lib$get_vm_page 	integer*4 sys$assign  	integer*4 sys$qiow  	integer*4 dix_fastio__read  c  	record /area/ area  	pointer (p_area,area) c % 	record /fastio_header/ fastio_header ( 	pointer (p_fastio_header,fastio_header) c  	record /prologue/ prologue  c  	record /fabdef/ fab 	pointer (p_fab,fab) c ! 	character*(max_line_length) line 
 	integer*4 nk  c  	byte data_block(block_size) c  c Get control  block" c  if ptr <>0 it was already done  c 
 	istat = 1% 	if(file.ptr_fast_search .ne. 0) then ) 	  p_fastio_header = file.ptr_fast_search + 	  if(fastio_header.channel .ne. 0) goto 90  c = c We already allocted the header, but not yet the data blocks  c 	 	  goto 5  	endif c ? 	call dix_main_print_debug(control,debug_fastio,'Setup fastio')  c / c GEt control block, all bytes are cleared to 0  c 0 	call get_vm(control,sizeof(fastio_header),addr,&      1              control.zone_file,(      1              .true.,'FASTIO_HDR') 	p_fastio_header = addr  c  c Set defaults c ' 	file.ptr_fast_search = p_fastio_header % 5	fastio_header.skip        = .false.  c ! 	fastio_header.seq_block_count =  5      1         min(search_block_size,max_block_count)  c E c For indexed files, get one buffer of max_bucket size (max_buf_size)  c ! 	fastio_header.ran_block_count =  5      1         (max_buf_size+block_size-1)/block_size  c 3 	if((control.debug .and. debug_fastio) .ne. 0) then < 	  call sys$fao(' Seq bufsiz = !UL, random buf !UL',nk,line,3      1         %val(fastio_header.seq_block_count), 3      1         %val(fastio_header.ran_block_count)) = 	  call dix_main_print_debug(control,debug_fastio,line(1:nk))  	endif c 2 c Now allocate the data blocks for sequential data9 c we need max_seq_rec blocks , but only for indexed files  c  	if(file.indexed) then c = c For indexd files, get max_seq_rec blocks, and one ran block  c K 	  n = max(1,min(multi_buffer,max_seq_rec))	!we want max_seq_rec seq blocks  c B c Now allocate the data block for random data (only one in needed) c > 	  istat = lib$get_vm_page(fastio_header.ran_block_count,addr) 	  if(.not. istat) goto 90# 	  fastio_header.ran.address = addr  	else  c  c Get one seq block  c  	  n = 1 	endif c 	 	do k=1,n > 	  istat = lib$get_vm_page(fastio_header.seq_block_count,addr) 	  if(.not. istat) then  c C c Allocation failed, if we have at least one block, we can continue  c / 	    if(fastio_header.n_seq_buf .eq. 0) goto 90  	    goto 10 	  endif& 	  fastio_header.seq(k).address = addr8 	  fastio_header.n_seq_buf = fastio_header.n_seq_buf + 1 	enddo c  c Now assign channel to file c	 10	p_fab = file.fabadr c 5 c Get the name of the disk and the fileid of the file 5 c since alpha/ia64 user naml blocks, and vax only nam 8 c  this is done in the architecture specific rms library c < 	call dix_rms_get_nam(%val(fab.fab$l_nam),des,fib.fib$w_fid) c  c Now assign channel to disk c  	k = 0 	istat = sys$assign(des,k,,) 	if(.not. istat) goto 90 	fastio_header.channel = k c % c Set up cblk entry to get rec attrib  c /         cblk(1).atr$w_size = sizeof(rec_attrib) *         cblk(1).atr$w_type = atr$c_recattr-         cblk(1).atr$l_addr = %loc(rec_attrib)  c          cblk(2).atr$w_size = 0         cblk(2).atr$w_type = 0         cblk(2).atr$l_addr = 0 c   c Create descriptor for  the fib c          des(1) = sizeof(fib)         des(2) = %loc(fib) c . c The nolock needs priv, if you do not have it c it is ignored. c 8         fib.fib$l_aclctx = 0            !clear acl index&         fib.fib$l_acctl = fib$m_nolock c 
 c connect  c E         istat = sys$qiow(%val(EFN$C_ENF),%val(fastio_header.channel), 0      1        %val(io$_access .or. io$m_access),0      1        fastio_header.iosb,,,des,,,,cblk,)/         if(istat) istat = fastio_header.iosb(1)          if(.not. istat) goto 90  c $ c  Get some data from the rec attrib c 9 	fastio_header.file_size = ishftc(rec_attrib.hiblk,16,32) : 	fastio_header.eof_size  = ishftc(rec_attrib.eofblk,16,32)2 	fastio_header.ffbyte    = zext(rec_attrib.ffbyte) c . c Now if the file is indexed, get the prologue5 c  this also includes the definition of the first key  c # 	fastio_header.type = fab.fab$b_org & 	if(fab.fab$b_org .eq. fab$c_idx) then c  c Read the prologue block  c  	  fastio_header.typasc = 'IDX' . 	  istat = dix_fastio__read(fastio_header,1,1,-      1                            prologue,k)  c   c remember tehe primary key data c ( 	  fastio_header.prim_key = prologue.key 	  fastio_header.bucket_size =  ;      1        zext(fastio_header.prim_key.data_bucket_size) 5 	  fastio_header.nb_key = zext(prologue.key.key_size) " 	  fastio_header.ran_block_count =2      1          min(fastio_header.ran_block_count,.      1              fastio_header.bucket_size) c ' c Get the block for the area definition  c  Get the first area block  c 3 	  area_nr = zext(fastio_header.prim_key.data_area) " 	  offset = area_nr * sizeof(area): 	  blnr = mod(offset,block_size) + zext(prologue.area_vbn) 	  offset = offset/block_size > 	  istat = dix_fastio__read(fastio_header,blnr,1,data_block,k)% 	  p_area = %loc(data_block) + offset  c 2 	  call dix_search_set_file_size(area.total_alloc/:      1                             zext(area.bucket_size)) c 5 	  if((control.debug .and. debug_fastio) .ne. 0) then A 	    call sys$fao('  Keyed file bucket size = !UL , keysize !UL',       1        nk,line,.      1        %val(fastio_header.bucket_size),)      1        %val(fastio_header.nb_key)) ? 	    call dix_main_print_debug(control,debug_fastio,line(1:nk))  	  endif* 	elseif(fab.fab$b_org .eq. fab$c_rel) then c A c Relative files ,read the prologue and get the max record number  c  	  fastio_header.typasc = 'REL' . 	  istat = dix_fastio__read(fastio_header,1,1,-      1                            prologue,k) 4 	  fastio_header.vfc_size      = zext(fab.fab$b_fsz)4 	  fastio_header.record_length = zext(fab.fab$w_mrs)4 	  fastio_header.bucket_size   = zext(fab.fab$b_bks)3 	  fastio_header.max_recnr     = prologue.max_recnr $ 	  fastio_header.rfm = fab.fab$b_rfm c  c Now compute the record size  c ? 	  fastio_header.rel_recsiz = 1 + fastio_header.record_length + -      1                 fastio_header.vfc_size , 	  if(fastio_header.rfm .ne. fab$c_fix) then< 	    fastio_header.rel_recsiz = fastio_header.rel_recsiz + 2 	  endif c   c and the count of record/bucket c   	  fastio_header.rel_nrecbuck = 7      1       (fastio_header.bucket_size * block_size) / &      1        fastio_header.rel_recsiz= 	  fastio_header.rel_bperbucket = fastio_header.rel_nrecbuck* (      1          fastio_header.rel_recsiz c * 	elseif(fab.fab$b_org .eq. fab$c_seq) then c & c Get the data for the seuqntial files c  	  fastio_header.typasc = 'SEQ'   	  fastio_header.bucket_size = 1$ 	  fastio_header.rfm = fab.fab$b_rfm= 	  fastio_header.blk = (fab.fab$b_rat .and. fab$m_blk) .ne. 0 > 	  fastio_header.msb = (fab.fab$b_rat .and. fab$m_msb) .ne. 0 / 	  fastio_header.vfc_size = zext(fab.fab$b_fsz) 4 	  fastio_header.record_length = zext(fab.fab$w_mrs) c 5 	  if((control.debug .and. debug_fastio) .ne. 0) then 6 	    call sys$fao('  Seq file eof block,byte !UL,!UL',      1        nk,line,+      1        %val(fastio_header.eof_size), )      1        %val(fastio_header.ffbyte)) ? 	    call dix_main_print_debug(control,debug_fastio,line(1:nk))  	  endif 	else  	  istat = 0	!should not happen  	endif c  90	dix_fastio_init = istat 	return  	end) 	function dix_fastio_rewind(control,file)  	implicit none c  c Rewind the file  c  	include 'dix_fastio_def.inc' , 	record /control/ control	!:i: control block4 	record /file_info/ file         !:i: the file block/ 	integer*4 dix_fastio_rewind	!:f: the io result  c  	include '($fabdef)' c  	record /bucket/ bucket  	pointer (p_bucket,bucket) c % 	record /fastio_header/ fastio_header ( 	pointer (p_fastio_header,fastio_header) c  	integer*4 istat,k" 	integer*4 dix_fastio__read_bucket 	integer*4 dix_fastio__read_seq  c A 	call dix_main_print_debug(control,debug_fastio,' Rewind fastio') ' 	p_fastio_header = file.ptr_fast_search  c  c Clear all settings c  	do k=1,max_seq_rec ' 	  fastio_header.seq(k).start_block = 0 ' 	  fastio_header.seq(k).end_block   = 0  	end do  c  c Get the first block/bucket in  c + 	if(fastio_header.type .eq. fab$c_idx) then  c   c Now get the first data-bucket. c 9 	  istat = dix_fastio__read_bucket(control,fastio_header, <      1             fastio_header.prim_key.first_data_bucket,*      1             fastio_header.p_bucket)$ 	  p_bucket = fastio_header.p_bucket c * c Ansd set the data rec to the first entry c 1 	  fastio_header.data_offset = sizeof(bucket.hdr)  c / 	elseif(fastio_header.type .eq. fab$c_rel) then  c , c REL, get data block 2, and set offset to 0 c 2 	  istat = dix_fastio__read_seq(fastio_header,1,2)  	  fastio_header.data_offset = 0 	else  c ) c SEQ, get the data block in from block 1  c 2 	  istat = dix_fastio__read_seq(fastio_header,1,1)  	  fastio_header.data_offset = 0 	endif c  c Set record number to 0 c  	fastio_header.recnr = 0 	dix_fastio_rewind = istat 	return  	end  * 	function dix_fastio_set_rfa(control,file) 	implicit none c   c Set the file to the wanted RDA c  	include 'dix_fastio_def.inc'  	include '($rmsdef)' 	include '($fabdef)' c , 	record /control/ control	!:i: control block- 	record /file_info/ file		!:i: the file block - 	integer*4 dix_fastio_set_rfa	!:f: the result  c  	record /rfa/ rfa  	integer*4 istat! 	integer*4 dix_fastio_set_rfa_rfa  c 0 c Get the rfa from the current record in the rab c " 	call dix_rms_return_rfa(file,rfa)1 	istat = dix_fastio_set_rfa_rfa(control,file,rfa)  	dix_fastio_set_rfa = istat  	return  	end2 	function dix_fastio_set_rfa_rfa(control,file,rfa) 	implicit none c   c Set the file to the wanted RDA c  	include 'dix_fastio_def.inc'  	include '($rmsdef)' 	include '($fabdef)' c , 	record /control/ control	!:i: control block- 	record /file_info/ file		!:i: the file block  	record /rfa/ rfa		!:i: the rfa 1 	integer*4 dix_fastio_set_rfa_rfa	!:f: the result  c ' 	integer*4 istat,recsiz,bpos,ptr_key,nk ! 	character*(max_line_length) line  c " 	integer*4 dix_fastio__read_bucket 	integer*4 dix_fastio__read_seq  c  c Now readin buffer /bucket  c % 	record /fastio_header/ fastio_header ( 	pointer (p_fastio_header,fastio_header) c  	record   /bucket/ bucket  	pointer (p_bucket,bucket) c  	record    /data_rec/ data_rec 	pointer (p_data_rec ,data_rec)  c  c ' 	p_fastio_header = file.ptr_fast_search  c 0 c Get the rfa from the current record in the rab c ( 	fastio_header.recnr       = file.rec_nr# 	fastio_header.skip        = .true.  	fastio_header.cur_rfa = rfa c 
 	istat = 1 c 3 	if((control.debug .and. debug_fastio) .ne. 0) then 8 	  call sys$fao('setting rfa for !AS file to (!UL,!UW)',,      1         nk,line,fastio_header.typasc,0      1         %val(fastio_header.cur_rfa.bbnr),2      1         %val(fastio_header.cur_rfa.offset))= 	  call dix_main_print_debug(control,debug_fastio,line(1:nk))  	endif c + 	if(fastio_header.type .eq. fab$c_idx) then  c 0 c Now find the data bucket with this rfa .offset c GEt the bucket c 9 	  istat = dix_fastio__read_bucket(control,fastio_header, 9      1                        fastio_header.cur_rfa.bbnr, 4      1                       fastio_header.p_bucket)% 	  p_bucket  = fastio_header.p_bucket , 	  istat = rms$_rnf	!assume record not found c K c And start skipping until the valid data block is found (on out of bucket)  c - 	  p_data_rec = p_bucket + sizeof(bucket.hdr)  c : 12	  fastio_header.data_offset = p_data_rec - %loc(bucket) c 6 c Seer if we are out of bucket, if so record not found c % 	  if(fastio_header.data_offset .ge.  :      1           zext(bucket.hdr.first_free_byte)) goto 90 c ! 	  recsiz = zext(data_rec.recsiz) < 	  if((data_rec.hdr.flag .and. dhdr_rec_deleted) .ne. 0)then c  c Deleted record c . 	    recsiz = recsiz + sizeof(data_rec.recsiz)= 	  elseif((data_rec.hdr.flag .and. dhdr_rec_rrv) .ne. 0) then  c  c RRV entry  c  	    recsiz = 0            else c 0 c Real data rec, if fda.offset matches, -> gotit c E 	    if(data_rec.hdr.rfa_byte .eq. fastio_header.cur_rfa.offset) then  	      istat = 1 	      goto 90
 	    endif. 	    recsiz = recsiz + sizeof(data_rec.recsiz) 	  endif c 8 c Update the keyheader. Compressed keys must be expanded c ? 	  call dix_fastio__uncompress_key(fastio_header,data_rec.data,       1           bpos,ptr_key) c  c Update the data pointer  c : 	  p_Data_rec = p_data_rec + sizeof(data_rec.hdr) + recsiz
 	  goto 12/ 	elseif(fastio_header.type .eq. fab$c_rel) then  c 3 c For rel , make sure the whole bucket is in memory  c ' 	  if((fastio_header.cur_rfa.bbnr .lt.  5      1        fastio_header.seq(1).start_block) .or.  F      1      ((fastio_header.cur_rfa.bbnr + fastio_header.bucket_size) 8      1        .gt. fastio_header.seq(1).end_block)) then2 	    istat = dix_fastio__read_seq(fastio_header,1,0      1               fastio_header.cur_rfa.bbnr) 	  endif> 	  fastio_header.data_offset = fastio_header.cur_rfa.offset + 0      1              (fastio_header.cur_rfa.bbnr-A      1               fastio_header.seq(1).start_block)*block_size  	else  c 5 c For seq, just read the block in, and set the offset  c ' 	  if((fastio_header.cur_rfa.bbnr .lt.  5      1        fastio_header.seq(1).start_block) .or.  .      1       (fastio_header.cur_rfa.bbnr .gt. 3      1        fastio_header.seq(1).end_block)) then  c " c Block not in memory read a chunk c 2 	    istat = dix_fastio__read_seq(fastio_header,1,2      1                 fastio_header.cur_rfa.bbnr) 	  endif c  c  Now update the pointer  c > 	  fastio_header.data_offset = fastio_header.cur_rfa.offset + 0      1              (fastio_header.cur_rfa.bbnr-A      1               fastio_header.seq(1).start_block)*block_size  	endif! 90	dix_fastio_set_rfa_rfa = istat  	return  	end2 	function dix_fastio_get(control,file,nkar,record) 	implicit none c  c Get the next record  c  	include 'dix_fastio_def.inc' , 	record /control/ control	!:i: control block0 	record /file_info/ file         !:i: file block$ 	integer*4 nkar			!:o: record length& 	byte record(*)			!:o: the record data% 	integer*4 dix_fastio_get	!:f: result  c# 	include '($fabdef)' c % 	record /fastio_header/ fastio_header ( 	pointer (p_fastio_header,fastio_header) c  	integer*4 istat c  	integer*4 dix_fastio__get_idx 	integer*4 dix_fastio__get_rel 	integer*4 dix_fastio__get_seq 	integer*4 dix_fastio_rewind c ' 	p_fastio_header = file.ptr_fast_search  c  c Update record number c 6 	if(fastio_header.recnr .ge. 0) fastio_header.recnr = (      1           fastio_header.recnr + 1 c 0 c If we had not yet done anyting, force a rewind c 1 	if(fastio_header.seq(1).start_block .eq. 0) then * 	  istat = dix_fastio_rewind(control,file) 	  if(.not. istat) goto 90 	endif c 9 c Now we point to the current record, take us to the next  c - 10	if(fastio_header.type .eq. fab$c_idx) then  c  c Read indexed file  c A 	  istat = dix_fastio__get_idx(control,fastio_header,nkar,record)  c  c Update counters for ^T c 4 	  call dix_search_update(fastio_header.bucket_size,$      1          fastio_header.recnr,B      1          fastio_header.nbuckets_read,fastio_header.cur_rfa) c / 	elseif(fastio_header.type .eq. fab$c_rel) then  c  c Read relative file c A 	  istat = dix_fastio__get_rel(control,fastio_header,nkar,record)  c  c Update counters for ^T c 0 	  call dix_search_update(0,fastio_header.recnr,A      1          fastio_header.nblocks_read,fastio_header.cur_rfa)  c / 	elseif(fastio_header.type .eq. fab$c_seq) then  c  c Read sequential file c A 	  istat = dix_fastio__get_seq(control,fastio_header,nkar,record)  c  c Update counters for ^T c 0 	  call dix_search_update(0,fastio_header.recnr,A      1          fastio_header.nblocks_read,fastio_header.cur_rfa)  c  	else  c  c Should not happen  c  	  istat = 0 	endif 90	dix_fastio_get = istat  	return  	end@ 	function dix_fastio__get_idx(control,fastio_header,nkar,record) 	implicit none c ! c Get nextrecord for indexed file  c  	include 'dix_fastio_def.inc' - 	record /control/ control		!:i: control block C 	record /fastio_header/ fastio_header    !:io: fastio control block ( 	integer*4 nkar				!:o: length of record  	byte record(*)				!:o: the data4 	integer*4 dix_fastio__get_idx		!:f: function result c# 	record /bucket/ bucket  	pointer (p_bucket, bucket)  	record /data_rec/ data_rec  	pointer (p_data_rec, data_rec)  c . 	integer*4 istat,bl_wanted,recsiz,bpos,ptr_key 	include '($rmsdef)' c " 	integer*4 dix_fastio__read_bucket c  c Get the current bucket c 
 	istat = 1" 	p_bucket = fastio_header.p_bucket c 5 c Set the pointer for the data record (in the bucket)  c 4 20	p_data_rec = p_bucket + fastio_header.data_offset c  c And find the next  c # 	if(fastio_header.data_offset .ge.  7      1           zext(bucket.hdr.first_free_byte)) then  c @ c No more data records in the bucket, take us to the next bucket c 9 	  if((bucket.hdr.flag .and. bhdr_flag_last) .ne. 0) then  	    istat = rms$_eof  	  else  c ( c Get the next bucket (follow the chain) c ' 	    bl_wanted = bucket.hdr.next_bucket  c ; 	    istat = dix_fastio__read_bucket(control,fastio_header, 5      1              bl_wanted,fastio_header.p_bucket) & 	    p_bucket = fastio_header.p_bucket c  c One more bucket read c  	  endif c " c  Adjust the pointer to the begin c 1 	  fastio_header.data_offset = sizeof(bucket.hdr) B 	  if(istat) goto 20	!process the first data_rec of the new bucket 	  goto 90             !error  	endif c ( c Check for the contents of the data_rec c 7 	if((data_rec.hdr.flag .and. dhdr_rec_rrv) .eq. 0) then  c 8 c Was not rrv pointer , expand key value (if compressed) c ? 	  call dix_fastio__uncompress_key(fastio_header,data_rec.data,       1           bpos,ptr_key) 	endif c  c Get the record size  c  	recsiz = zext(data_rec.recsiz)  c ; 	if((data_rec.hdr.flag .and. dhdr_rec_deleted) .ne. 0) then  c 1 c Deleted record, skip it, there is a record part  c , 	  recsiz = recsiz + sizeof(data_rec.recsiz); 	elseif((data_rec.hdr.flag .and. dhdr_rec_rrv) .ne. 0) then  c  c RRV entry , no record part c  	  recsiz = 0		          else c - c Real data rec, if skip not set we found it. , c  if skip set, clear it and go get the next c ' 	  if(.not. fastio_header.skip) goto 40 , 	  recsiz = recsiz + sizeof(data_rec.recsiz) 	  fastio_header.skip = .false.  	endif c ! c Update the pointer for data rec  c 8 	fastio_header.data_offset = fastio_header.data_offset+ 2      1               sizeof(data_rec.hdr) + recsiz 	goto 20 c * c Now the data record is found, go copy it c : 40	call dix_fastio__copy_data(fastio_header,recsiz-bpos+1,8      1          data_rec.data(bpos),ptr_key,nkar,record) c  c Save the rfa c 7 	fastio_header.cur_rfa.bbnr   = data_rec.hdr.rfa_block  5 	fastio_header.cur_rfa.offset = data_rec.hdr.rfa_byte  c ! c Update the offset in the bucket  c 9 	fastio_header.data_offset = fastio_header.data_offset +  5      1               sizeof(data_rec.hdr) + recsiz +  ,      1               sizeof(data_rec.recsiz) c  90	dix_fastio__get_idx = istat 	return  	end@ 	function dix_fastio__get_rel(control,fastio_header,nkar,record) 	implicit none c  c Get data from a relative file  c  	include 'dix_fastio_def.inc' - 	record /control/ control		!:i: control block : 	record /fastio_header/ fastio_header	!:io: fastion header% 	integer*4 nkar				!:o: record length # 	byte record(*)				!:o: record data 4 	integer*4 dix_fastio__get_rel		!:f: funciton result c#- 	integer*4 istat,offs,bucknr,flag,recsiz,incr  	include '($rmsdef)' 	include '($fabdef)' c  	byte var_data(0:*)  	pointer (p_var_data,var_data) c  	integer*4 dix_fastio__get_copy  	integer*4 dix_fastio__scroll  c 
 	nkar  = 0 c 2 c Each record is a fixed length cell in the bucket% c  the first byte is the present flag E c  and then follows a variable (vfc) record just like sequential file , c   the bucket may be not completely filled. c # 21	offs = fastio_header.data_offset  c A c Get lowest multiple of bucket_size (added the 1 block overhead)  c 1 	bucknr = (fastio_header.seq(1).start_block - 2)/ +      1            fastio_header.bucket_size 0 	bucknr = bucknr * fastio_header.bucket_size + 2E 	offs = offs + (fastio_header.seq(1).start_block - bucknr)*block_size  c ! c Now see if offs is > bucketsize  c ? 	bucknr = bucknr + offs/(fastio_header.bucket_size*block_Size)* 8      1                         fastio_header.bucket_size6 	offs = mod(offs,fastio_header.bucket_size*block_size) c 8 c Now if offs > #rrec/bucker*recsiz, we need to round up c 0 	if(offs .ge. fastio_header.rel_bperbucket) then; 	  fastio_header.data_offset = fastio_header.data_offset +  8      1          fastio_header.bucket_size * block_size -,      1          fastio_header.rel_bperbucket
 	  goto 21 	endif, 	if(bucknr .gt. fastio_header.eof_size) then 	  istat = rms$_eof 
 	  goto 90 	endif c 	 c Set rfa  c & 	fastio_header.cur_rfa.bbnr   = bucknr$ 	fastio_header.cur_rfa.offset = offs c 3 c Make sure the first byte (flag byte) is in memory  c ) 	do while(fastio_header.data_offset .ge.  .      1           fastio_header.seq(1).nb_read)4 	  istat = dix_fastio__scroll(control,fastio_header) 	  if(.not. istat) goto 90 	enddo c  c HEre is the data c * 	p_var_data = fastio_header.seq(1).address c # c Now var data points to the record  c	  + 	flag = var_data(fastio_header.data_offset)  c + 	if(((flag .and. rel_record) .ne. 0) .and.  2      1     ((flag .and. rel_deleted) .eq. 0)) then c ) c Got valid record and not deleted, gotit  c ' 	  if(.not. fastio_header.skip) goto 25  	  fastio_header.skip = .false.  	endif c  c Point to the next record c 9 	fastio_header.data_offset = fastio_header.data_offset +  <      1                              fastio_header.rel_recsiz 	goto 21	    c  c Now copy the data  c < 25	fastio_header.data_offset = fastio_header.data_offset + 1 c $ 	incr = fastio_header.rel_recsiz - 1 c * 	if(fastio_header.rfm .eq. fab$c_fix) then' 	  recsiz = fastio_header.record_length  	else	!vfc/var
 	  recsiz = 0  c * c Make sure the next 2 bytes are in memory c - 	  do while(fastio_header.data_offset+1 .ge.  1      1             fastio_header.seq(1).nb_read)  6 	    istat = dix_fastio__scroll(control,fastio_header) 	    if(.not. istat) goto 90 	  enddo c * c And copy the 2 bytes (the record length) c ? 	  call lib$movc3(2,var_data(fastio_header.data_offset),recsiz) < 	  fastio_header.data_offset = fastio_header.data_offset + 2 	  incr = incr - 2 c 5 	  if(fastio_header.msb) recsiz = ishftc(recsiz,8,16) , 	  if(fastio_header.rfm .eq. fab$c_vfc) then c / c VFC, skip the vfc bytes, and set recsiz lower  c = 	    fastio_header.data_offset = fastio_header.data_offset +  @      1                                    fastio_header.vfc_size 	       - 	    recsiz = recsiz - fastio_header.vfc_size ) 	    incr = incr - fastio_header.vfc_size  	  endif 	endif c " c Copy the data to the user record c @ 	istat = dix_fastio__get_copy(control,fastio_header,recsiz,incr,      1            nkar,record) c  90	dix_fastio__get_rel = istat 	return  	end@ 	function dix_fastio__get_seq(control,fastio_header,nkar,record) 	implicit none c / c Gte data from a sequential file (all formats)  c  	include 'dix_fastio_def.inc' - 	record /control/ control		!:i: control block @ 	record /fastio_header/ fastio_header	!:io: fastion header block% 	integer*4 nkar				!:o: record length # 	byte record(*)				!:o: record data 4 	integer*4 dix_fastio__get_seq		!:f: function result c#" 	integer*4 istat,extra,recsiz,incr 	include '($rmsdef)' 	include '($fabdef)' c  	integer*4 dix_fastio__get_copy  	integer*4 dix_fastio__scroll  c  	byte var_data(0:*)  	pointer (p_var_data,var_data) c * 	byte cr,lf,prev_byte,cur_byte,search_byte 	parameter (lf=10,cr=13) c  c Save the rfa c D 10	fastio_header.cur_rfa.bbnr  = fastio_header.seq(1).start_block + =      1                   fastio_header.data_offset/block_size   	fastio_header.cur_rfa.offset = 6      1       mod(fastio_header.data_offset,block_size) c 
 	istat = 1
 	nkar  = 0* 	p_var_data = fastio_header.seq(1).address
 	extra = 0 c * 	if(fastio_header.rfm .eq. fab$c_fix) then c  c Fixed record length file c ' 	  recsiz = fastio_header.record_length  	  incr = recsiz c - 	elseif(fastio_header.rfm .eq. fab$c_var .or. 5      1         fastio_header.rfm .eq. fab$c_vfc) then  c @ c Now copy the record length, first make sure the offset is even c % 	  if(fastio_header.data_offset) then E 	    fastio_header.data_offset = fastio_header.data_offset + 1 !align  c  c And recompute the rfa  c F 	    fastio_header.cur_rfa.bbnr  = fastio_header.seq(1).start_block + =      1                   fastio_header.data_offset/block_size $ 	    fastio_header.cur_rfa.offset = 8      1         mod(fastio_header.data_offset,block_size) 	  endif c  c Get the record size  c  50	  recsiz = 0  c * c  Mak sure the next 2 bytes are in memory c - 	  do while(fastio_header.data_offset+1 .ge.  0      1             fastio_header.seq(1).nb_read)6 	    istat = dix_fastio__scroll(control,fastio_header) 	    if(.not. istat) goto 90 	  enddo c	       c Get the record size  c ? 	  call lib$movc3(2,var_data(fastio_header.data_offset),recsiz) 5 	  if(fastio_header.msb) recsiz = ishftc(recsiz,8,16)  c B 	  fastio_header.data_offset = fastio_header.data_offset + 2	!skip c " c Now we need to copy recsiz bytes c  	  if(recsiz .eq. 'ffff'x) then  c  c Round upto next block  c ! 	    fastio_header.data_offset =  D      1         (fastio_header.data_offset/block_size + 1)*block_size 	    goto 50	      	  endif c , 	  if(fastio_header.rfm .eq. fab$c_vfc) then c 0 c VFC, skipt the vfc bytes, and set recsiz lower c = 	    fastio_header.data_offset = fastio_header.data_offset +  >      1                                  fastio_header.vfc_size 	       - 	    recsiz = recsiz - fastio_header.vfc_size  	  endif c  c And go copy the data c  	  incr = recsiz. 	elseif(fastio_header.rfm .eq. fab$c_stm .or. 7      1         fastio_header.rfm .eq. fab$c_stmcr .or.  7      1         fastio_header.rfm .eq. fab$c_stmlf) then  c  c Now for the stm type files c , 	  if(fastio_header.rfm .eq. fab$c_stm) then 	    search_byte = lf 2 	  elseif(fastio_header.rfm .eq. fab$c_stmcr) then 	    search_byte = cr  	  else  	    search_byte = lf  	  endif c ! c Now go looking for a terminator  c  	  prev_byte = 0 c  	  do recsiz=1,max_buf_size  c & c Make sure the next byte is in memory c - 	    do while(fastio_header.data_offset .ge.  3      1               fastio_header.seq(1).nb_read)   c 1 c Copy this part of the buffer to the data buffer  c 8 	      istat = dix_fastio__scroll(control,fastio_header) 	      if(.not. istat) goto 90
 	    enddo c  c Get the byte c 3 	    cur_byte = var_data(fastio_header.data_offset) > 	    fastio_header.data_offset = fastio_header.data_offset + 1 c # c See if the byte is the wanted one  c ' 	    if(cur_byte .eq. search_byte) then  c : c Got the terminator, for stm file the previous must be cr c 0 	      if(fastio_header.rfm .eq. fab$c_stm) then# 	        if(prev_byte .eq. cr) then *  	          if(fastio_header.skip) goto 60 	          goto 90  !all done  	        endif 	      else (  	        if(fastio_header.skip) goto 60 	        goto 90		!all done  	      endif
 	    endif c  c Rememer the previous one c  	    prev_byte = cur_byte  c  c And add to user buffer c  	    nkar = nkar + 1 	    record(nkar) = cur_byte 	  enddo c  c Exceeded max record length c  	  istat = rms$_rtb  	  goto 90	 2 	else   !if(fastio_header.rfm .eq. fab$c_udf) then c  c Unexpected type  c  	  istat = rms$_eof  	endif c  c  60	if(fastio_header.skip) then? 	  fastio_header.data_offset = fastio_header.data_offset + incr  	  fastio_header.skip = .false. 
 	  goto 10 	endif c & c Now copy the data to the user buffer c @ 	istat = dix_fastio__get_copy(control,fastio_header,recsiz,incr,      1            nkar,record) c  90	dix_fastio__get_seq = istat 	return  	endA 	function dix_fastio__get_copy(control,fastio_header,recsiz,incr,       1            nkar,record) 	implicit none c 7 c Copy the current record to the user record /bytecount  c  	include 'dix_fastio_def.inc' - 	record /control/ control		!:i: control block ; 	record /fastio_header/ fastio_header    !:io: fastio block & 	integer*4 recsiz			!:i: #byte to copy4 	integer*4 incr				!:i: amount to update.data_offset% 	integer*4 nkar				!:o: record length ' 	byte record(*)				!:o: the data record 5 	integer*4 dix_fastio__get_copy		!:f: function result  c# 	byte var_data(0:*)  	pointer (p_var_data,var_data) c  	integer*4 istat 	integer*4 dix_fastio__scroll  c  c * 	p_var_data = fastio_header.seq(1).address c 
 	istat = 1 c 1 c Now make sure the whole record is in the buffer  c 2 	do while(fastio_header.data_offset + recsiz .gt. /      1           fastio_header.seq(1).nb_read)   c H c The total record is not in memory, now copy the part that is in memory c Now copy to record c B 	  nkar = fastio_header.seq(1).nb_read - fastio_header.data_offset 	  if(nkar .gt. 0) then = 	    call lib$movc3(nkar,var_data(fastio_header.data_offset), &      1                         record)= 	    fastio_header.data_offset = fastio_header.seq(1).nb_read  	    recsiz = recsiz - nkar  	    incr   = incr   - nkar  	  else 
 	    nkar = 0  	  endif c + c Add scroll the data (read the next chunk)  c 4 	  istat = dix_fastio__scroll(control,fastio_header) 	  if(.not. istat) goto 90 	enddo c  c And now the rest c ; 	call lib$movc3(recsiz,var_data(fastio_header.data_offset), .      1                         record(nkar+1)) 	nkar = nkar + recsiz = 	fastio_header.data_offset = fastio_header.data_offset + incr  c  c  90	dix_fastio__get_copy = istat  	return  	end c ( 	function dix_fastio_close(control,file) 	implicit none c + c Close (and return all memory allocations)  c  	include 'dix_fastio_def.inc'  c . 	record /control/ control		!:i: cotntrol block+ 	record /file_info/ file			!:io: file block 1 	integer*4 dix_fastio_close		!:f: function result  c# 	integer*4 istat,nk,k ! 	character*(max_line_length) line  	integer*4 sys$dassgn  	integer*4 lib$free_vm_page  	integer*4 lib$free_vm c  c % 	record /fastio_header/ fastio_header ( 	pointer (p_fastio_header,fastio_header) c ( c DO we have a fastion header allocated? c % 	if(file.ptr_fast_search .ne. 0) then ) 	  p_fastio_header = file.ptr_fast_search  c 5 	  if((control.debug .and. debug_fastio) .ne. 0) then  c  c Print debug data c  	    do k=1,max_seq_rec @ 	      call sys$fao('Seq !UL start !UL end !UL hit !SL',nk,line,A      1            %val(k),%val(fastio_header.seq(k).start_block), 7      1            %val(fastio_header.seq(k).end_block), 6      1            %val(fastio_header.seq(k).hit_rate))A 	      call dix_main_print_debug(control,debug_fastio,line(1:nk))  	    end do  	    do k=1,max_prev_buckets9 	       call sys$fao('Previous bucket !UL = !UL',nk,line, A      1               %val(k),%val(fastio_header.prev_buckets(k))) A 	      call dix_main_print_debug(control,debug_fastio,line(1:nk))  	    end do  c B 	    call sys$fao('Buffer read count !10UL cache hit count !10UL',      1          nk,line,-      1        %val(fastio_header.read_count), ,      1        %val(fastio_header.hit_count))? 	    call dix_main_print_debug(control,debug_fastio,line(1:nk)) B 	    call sys$fao('    File size     !10UL #block read     !10UL',      1          nk,line,,      1        %val(fastio_header.file_size),/      1        %val(fastio_header.nblocks_read)) ? 	    call dix_main_print_debug(control,debug_fastio,line(1:nk)) B 	    call sys$fao('    #seq reads    !10UL #randm reads    !10UL',      1          nk,line,,      1       %val(fastio_header.nreads_seq),,      1       %val(fastio_header.nreads_ran))? 	    call dix_main_print_debug(control,debug_fastio,line(1:nk))d 	  endif ce c Close channelc ce( 	  if(fastio_header.channel .ne. 0) then4 	    istat = sys$dassgn(%val(fastio_header.channel)) 	    if(.not. istat) goto 90 	  endif co( c If ran data block allocated, return it c!, 	  if(fastio_header.ran.address .ne. 0) then< 	    istat = lib$free_vm_page(fastio_header.ran_block_count,5      1               %val(fastio_header.ran.address))n 	    if(.not. istat) goto 90 	  endif cc+ c If seq data block(s) allocated, return itb c/ 	  do k=1,max_seq_recb1 	    if(fastio_header.seq(k).address .ne. 0) thens> 	      istat = lib$free_vm_page(fastio_header.seq_block_count,8      1               %val(fastio_header.seq(k).address)) 	      if(.not. istat) goto 90 	    end ifa 	  enddo cc- c And finally return the fastio control blockf c ; 	  istat = lib$free_vm(sizeof(fastio_header),fastio_header)  	  if(.not. istat) goto 90 	elsek 	  istat = 1 	endif c		t 90	dix_fastio_close = istatw 	returny 	end? 	function dix_fastio__read(fastio_header,blocknr,count,address,s      1              nbl_read)c 	implicit none ca3 c Read data in either large buffer, or short buffere c this is the real io place  ca 	include 'dix_fastio_def.inc'f8 	record /fastio_header/ fastio_header	!:i: fastio headerD 	integer*4 blocknr                       !:I: the blocknumber wanted/ 	integer*4 count				!:i: the block count wanted,* 	integer*4 address			!:i: the data address' 	integer*4 nbl_read			!:o: #blocks readp1 	integer*4 dix_fastio__read		!:f: function resultl c# 	include '($efndef)' 	include '($iodef)'h ce 	include '($ssdef)'e 	integer*4 istat,nbyte cb 	integer*4 sys$qiow1 c  c Compute # bytesc ci 	nbyte = count * block_sizeo cn c Do the iog co" 	istat = sys$qiow(%val(EFN$C_ENF),0      1              %val(fastio_header.channel),'      1              %val(io$_readvblk),)*      1              fastio_header.iosbw,,,      1              address,1      1              %val(nbyte),%val(blocknr),,,)k) 	if(istat) istat = fastio_header.iosbw(1)e cl% c Word 2 and 3 contain the bytes reado ca2 	call lib$movc3(4,fastio_header.iosbw(2),nbl_read) cn#  	if(istat .eq. ss$_endoffile) thenf c  c Allow partial read c   	  if(nbl_read .gt. 0) istat = 1 	endif c_ c Make the bytes the blockse c  	nbl_read = nbl_read/block_sizenC 	fastio_header.nblocks_read = fastio_header.nblocks_read + nbl_read  c  	dix_fastio__read = istate 	return_ 	end  7 	function dix_fastio__read_seq(fastio_header,idx,block)t 	implicit none c  c Now update seq buffer  c  	include 'dix_fastio_def.inc'i= 	record /fastio_header/ fastio_header	!:io: the fastio headerf> 	integer*4 block                         !:i: the block wanted< 	integer*4 idx                 		!:i: which seq block wanted5 	integer*4 dix_fastio__read_seq		!:f: function result  c# 	include '($rmsdef)' cn 	integer*4 nbl_read,istatt ce 	integer*4 dix_fastio__read  c + 	if(block .gt. fastio_header.eof_size) then  	  istat = rms$_eoff
 	  goto 90 	endif ck< c Do the real io (min a bucket size, but max the block size) cq. 	istat = dix_fastio__read(fastio_header,block,4      1                max(fastio_header.bucket_size,9      1                    fastio_header.seq_block_count),e;      1                %val(fastio_header.seq(idx).address),i      1                nbl_read)  cl c And update the countersf cl+ 	fastio_header.seq(idx).start_block = blocka& 	fastio_header.seq(idx).end_block   = 4      1         fastio_header.seq(idx).start_block + #      1                   nbl_read-1r& 	fastio_header.seq(idx).end_block   = 3      1        min(fastio_header.seq(idx).end_block,t)      1            fastio_header.eof_size)t  " 	fastio_header.seq(idx).nb_read = 3      1           fastio_header.seq(idx).end_block -e7      1           fastio_header.seq(idx).start_block + 1p  C 	fastio_header.seq(idx).nb_read = fastio_header.seq(idx).nb_read * o      1             block_sizepF 	if(fastio_header.seq(idx).end_block .eq. fastio_header.eof_size) thenE 	  fastio_header.seq(idx).nb_read = fastio_header.seq(idx).nb_read - o2      1           block_size + fastio_header.ffbyte 	endif8 	fastio_header.nreads_seq = fastio_header.nreads_seq + 1 cc 90	dix_fastio__read_seq = istat  	returno 	endE 	function dix_fastio__read_bucket(control,fastio_header,block_nr,ptr)  	implicit none ci4 c Read bucket "bucket" in and return a pointer to it' c This is a fairly complicated routine.(6 c  we try to reduce the read count as much as possibleH c   normally buckets sequentially in the file, but after a vbucket splitP c  a bucket can be moved to a different place in the file (no longer sequential). c Initilally we do a large io to a seq buffer. crB c If the wanted bucket is in memory, just return a pointer to it. : c If the data is not in (on of) the seruential buffers, weJ c  check if the wanted number is just below one of the sequential buffers.* c  If so, move the next chunk into memory.C c If not, check if the last 3 "random" ios' were in the same chunk.fK c If so reuse the last used sequential buffer and do a new large io to it .bA c If the random io is readlly random just read one bucket in the  3 c  random io buffer, and remember the bucket number  c( 	include 'dix_fastio_def.inc' 8 	record /fastio_header/ fastio_header	!:i: fastio header- 	record /control/ control		!:i: control blockf- 	integer*4 block_nr			!:i: lock number wantedh( 	integer*4 ptr				!:o: pointer to bucket6 	integer*4 dix_fastio__read_bucket	!:f: functin result cx/ 	integer*4 istat,end_block,nbl_read,nk,k,oldestz! 	character*(max_line_length) linet 	integer*4 seq_idx cl 	integer*4 dix_fastio__read_seqc 	integer*4 dix_fastio__read_# 	integer*4 dix_fastio__check_sanity/ c  c Compute #bytes wanted  c  See if read in random e c  or seqentialn- c  We assume that most buckets are sequential 4 c   but that now and then a bucket is requested that* c   is out of order (after a bucket split) c > 	fastio_header.nbuckets_read = fastio_header.nbuckets_read + 15 	end_block = block_nr + fastio_header.bucket_size - 1d cg3 	if((control.debug .and. debug_fastio) .ne. 0) then - 	  call sys$fao(' Need block !UL nblk = !UL',dE      1        nk,line,%val(block_nr),%val(fastio_header.bucket_size))s= 	  call dix_main_print_debug(control,debug_fastio,line(1:nk))  	  do k=1,max_seq_rec > 	    call sys$fao('Seq !UL start !UL end !UL hit !SL',nk,line,A      1            %val(k),%val(fastio_header.seq(k).start_block),f7      1            %val(fastio_header.seq(k).end_block),i6      1            %val(fastio_header.seq(k).hit_rate))? 	    call dix_main_print_debug(control,debug_fastio,line(1:nk)) 	 	  end do_ 	endif cr1 	if(fastio_header.seq(1).start_block .eq. 0) then 2 	  call dix_main_print_debug(control,debug_fastio,2      1             'First time, user seq block 1') 	  seq_idx = 1
 	  goto 10 	endif c+% c decrement all seq buffers hit countc c/ 	do k=1,max_seq_rec_D 	  fastio_header.seq(k).hit_rate = fastio_header.seq(k).hit_rate - 1 	end do  c  	seq_idx = 0 co> c See if the watned bucket is in one of the sequential buffers c. 	do k=1,max_seq_rec1 c ( c See if in any of the sequential blocks ca5 	  if((control.debug .and. debug_fastio) .ne. 0) thenr; 	    call sys$fao('    see if in seqidx !UL block !UL-!UL',       1          nk,line,?      1          %val(fastio_header.seq(k).start_block),%val(k),=5      1          %val(fastio_header.seq(k).end_block))d? 	    call dix_main_print_debug(control,debug_fastio,line(1:nk))r 	  endif ce: 	  if(fastio_header.seq(k).start_block .le. block_nr .and.B      1       fastio_header.seq(k).end_block   .ge. end_block) then c	    4 	    call dix_main_print_debug(control,debug_fastio,/      1            '    Got it in this buffer ')_: 	    fastio_header.hit_count = fastio_header.hit_count + 1 c  c Reset the hit rate cd& 	    fastio_header.seq(k).hit_rate = 0, 	    seq_idx = k		!data is in this seq block 	    goto 50 	  endif 	end don c=? c Not in any of the seq in-memory block, see if sequential read # c  just after any of the seq blocksl c 3 c If the block falls in the next chunk, assume that 9 c  there are some missing buckets, take the seq type read  ci 	do k=1,max_seq_rect8 	  if(block_nr .gt. fastio_header.seq(k).end_block .and.<      1       block_nr .le. fastio_header.seq(k).end_block + >      1                     fastio_header.seq_block_count) then ca0 c Just after the 'k' seq buffer, scroll that one ci 	    seq_idx = k4 	    call dix_main_print_debug(control,debug_fastio,'      1              'Second thoughts1')f 	  endif 	enddo c'0 c It can also be just at the end of the previous cl 	do k=1,max_seq_rec 9 	  if(block_nr  .le. fastio_header.seq(k).end_block .and. @      1       end_block .ge. fastio_header.seq(k).end_block) then 	    seq_idx = k4 	    call dix_main_print_debug(control,debug_fastio,'      1              'Second thoughts2'). 	  endif 	enddo cf c Now seq_idx ) c  >0, read data to 'idx_seq' serq buffer  c  =0, try randow io c. 10	if(seq_idx .ne. 0) then c    c  Read to herer cb ce9 c Do a seq read, this will read a lot of blocks in memorye ct? 	  istat = dix_fastio__read_seq(fastio_header,seq_idx,block_nr)o cu5 	  if((control.debug .and. debug_fastio) .ne. 0) thene6 	    call sys$fao(' Need seq-Read block =!UL to seq'//)      1           ' buffer !UL nbl = !UL',t4      1         nk,line,%val(block_nr),%vaL(seq_idx),3      1         %val(fastio_header.seq_block_count)) ? 	    call dix_main_print_debug(control,debug_fastio,line(1:nk))e 	  endif cs5 c Now the end block should be in memory, if not aborti ceB 	  if(fastio_header.seq(seq_idx).end_block .ge. end_block) goto 50 c  	elset cs c Sequential read not logical D c  if the last "max_prev_buckets" random reads are in the same block6 c   we assume there is a new sequential stream started cr2 	  call dix_main_print_debug(control,debug_fastio,C      1       'Not seq, see if last random reads in the same block')	 c: 	  do k=1,max_prev_buckets5 	    if(fastio_header.prev_buckets(k) .eq. 0) goto 32f; 	    if(iabs(fastio_header.prev_buckets(k) -block_nr) .gt.  7      1         fastio_header.seq_block_count/2) goto 32i	 	  end dof co8 c Now all the last "n" buckets are in a single seq_block7 c  get the last used seqential block, and read that one  cp 	  seq_idx = 0) 	  oldest = fastio_header.seq(1).hit_rateu c' c The first is always in use c$ 	  do k=max_seq_rec,2,-1< 	    if(fastio_header.seq(k).start_block .eq. 0) seq_idx = k+ 	    if(fastio_header.seq(k).hit_rate .lt. c=      1         fastio_header.seq(oldest).hit_rate) oldest = k		 	  end dos c & 	  if(seq_idx .eq. 0) seq_idx = oldest cn5 	  if((control.debug .and. debug_fastio) .ne. 0) thend< 	    call sys$fao(' Oldest seq block = !UL, reuse that one',+      1               nk,line,%val(seq_idx))s? 	    call dix_main_print_debug(control,debug_fastio,line(1:nk))e 	  endif cr6 c Now seq_idx is the index of the last used seq buffer cr
 	  goto 10 c 2 c Random blocks not in order, go for the random io/ c Remember the last "n" block_nrs for random ioe9 c Scroll the remember area, and store this buvcket numbere cr 32	  do k=max_prev_buckets,2,-1iD 	    fastio_header.prev_buckets(k) = fastio_header.prev_buckets(k-1)	 	  end do + 	  fastio_header.prev_buckets(1) = block_nr) ce5 	  if((control.debug .and. debug_fastio) .ne. 0) thenU8 	    call sys$fao(' Need ran-Read block =!UL nbl = !UL',&      1         nk,line,%val(block_nr),/      1         %val(fastio_header.bucket_size))s? 	    call dix_main_print_debug(control,debug_fastio,line(1:nk))) 	  endif c * c Do a raed (only one bucket full of data) c 3 	  istat = dix_fastio__read(fastio_header,block_nr, +      1           fastio_header.bucket_size,r1      1           %val(fastio_header.ran.address),       1              nbl_read)_  : 	  fastio_header.nreads_ran = fastio_header.nreads_ran + 16 	  if(nbl_read .eq. fastio_header.bucket_size) goto 50 	endif csG c Something strange happend, we could not get the whoe bucket in memory  c  this is fatal cu 	write(*,*) 'Out of buffer'_
 	istat = 0 	goto 90 cr2 c Now set the pointer to the right peice of memory cl cb 50	if(seq_idx .ne. 0) then ct" c Is was in one of the seq buffers c 1 	  ptr =    fastio_header.seq(seq_idx).address +  F      1            (block_nr - fastio_header.seq(seq_idx).start_block)*      1             block_size. 	elseg cn c It is in the random buffer c " 	  ptr = fastio_header.ran.address 	endif c+" c Now see itf the bucket is "sane" ct0 	istat = dix_fastio__check_sanity(fastio_header,-      1            %val(ptr),block_nr,seq_idx)  cl c Return resultt c " 90	dix_fastio__read_bucket = istat 	returni 	endA 	function dix_fastio__check_sanity(fastio_header,bucket,blnr,idx)i 	implicit none ct c See if the bucket is valid- c  if not reread the datablock, and try again  c  if still not valid, abort cs 	include 'dix_fastio_def.inc' 8 	record /fastio_header/ fastio_header	!:i: fastio header) 	record /bucket/ bucket			!:i: the bucket ) 	integer*4 blnr				!:i: the bucker number . 	integer*4 idx				!:i: the index block to read8 	integer*4 dix_fastio__check_sanity	!:f: function result c  	include '($rmsdef)' ch 	integer*4 dix_fastio__read_seq  	integer*4 dix_fastio__readb 	integer*4 istat,nbl_reada co
 	istat = 1 cs/ c See if bucket number is present (low 16 bits)u cfA 	if(zext(bucket.hdr.check_vbn) .ne. (blnr .and. 'ffff'x)) goto 50d cs< c Now see if first byte and last btye of bucket are the same ch 	if(bucket.hdr.check .eq. E      1     bucket.data(fastio_header.bucket_size*block_size)) goto 90= cs# c Invalid bucket, try to read again  c 9 50	fastio_header.n_rereads  = fastio_header.n_rereads + 1f ci 	if(idx .eq. 0) then/ 	  istat = dix_fastio__read(fastio_header,blnr,e+      1           fastio_header.bucket_size,i1      1           %val(fastio_header.ran.address),       1              nbl_read)k 	else 2 	  istat = dix_fastio__read_seq(fastio_header,idx,3      1          fastio_header.seq(idx).start_block)  	  if(.not.  istat) goto 90a 	endif c  c Now chekc agains c_/ c See if bucket number is present (low 16 bits)  csA 	if(zext(bucket.hdr.check_vbn) .ne. (blnr .and. 'ffff'x)) goto 70  c < c Now see if first byte and last btye of bucket are the same c  	if(bucket.hdr.check .eq.eE      1     bucket.data(fastio_header.bucket_size*block_size)) goto 90c cb. c Somethinbg rotten (in the state on danemark) ca 70	istat = rms$_chkf ct# 90	dix_fastio__check_sanity = istatr 	returni 	end? 	subroutine dix_fastio__uncompress_key(fastio_header,data,bpos,i      1           ptr_key)t 	implicit none 	include 'dix_fastio_def.inc'e c * c Uncompress the key to the fastion_header cc9 	record /fastio_header/ fastio_header	!:i: fastio  headerr 	byte data(*)				!:i: the data1 	integer*4 bpos				!:o: start pos of rest of datar( 	integer*4 ptr_key			!:o: pointer to key c# 	logical*4 compresst 	integer*4 nb_k,nb_d,k 	byte last_byteg ci0 	compress = (fastio_header.prim_key.flags .and. .      1              key_flag_key_compr) .ne. 0 c   c Check if the key is compressed cc 	if(compress) then c H c If Key is compressed, move (and decompress) it to fastio_header.keyval c  c the layout isd	 c   byte 1$ c      1  : total length of key data4 c      2  : length count from the previous key value c      3..nn : the key data=C c  if the total length of the key is < nk_key, repeat the last char  c # 	  nb_k = data(1)	!total byte count $ 	  nb_d = zext(data(2))  !get length 	  bpos = 3		!used byte 1/2t c  c Now move the real keydata  c : 	  call lib$movc3(nb_k,data(3),fastio_header.keyval(nb_d)) 	  nb_d = nb_d + nb_kt 	  bpos = bpos + nb_k  c_2 c it the total length still is too short (<nb_key) c  use the last byte as filler c + 	  last_byte = fastio_header.keyval(nb_d-1)a! 	  do k=nb_d,fastio_header.nb_keya+ 	    fastio_header.keyval(nb_d) = last_bytel 	    nb_d = nb_d + 1 	  enddo ci1 c return the pointer rto the fastio_header.keyval  cp' 	  ptr_key = %loc(fastio_header.keyval)r 	elset c,9 c Key is not compressed, return the pointer rto the data _ cd 	  ptr_key = %loc(data(1))" 	  bpos = fastio_header.nb_key + 1 	endif 	return  	end cs= 	subroutine dix_fastio__copy_data(fastio_header,nb_data,data,i%      1             ptr_key,nb,record)u 	implicit none c  c copy index record to usert, c First see about uncompressing  record data cb 	include 'dix_fastio_def.inc'a8 	record /fastio_header/ fastio_header	!:i: fastio header* 	integer*4 nb_data			!:i: #bytes in record) 	integer*4 ptr_key			!:i: pointert to keyt6 	byte data(*)                            !:i: the data# 	integer*4 nb				!:o: record lengthi  	byte record(*)				!:o: the data c# 	byte       key_data(0:*)t 	pointer (p_key_data,key_data) c  	byte tempdata(0:max_buf_size) co 	logical*4 flags(max_segments) ce 	byte recdata(0:*) 	pointer (p_recdata,recdata) ct' 	integer*4 nb_d,rep_count,k,bpos,nb_rec + 	integer*4 minval,kidx,kpos,ksiz,recpos,posr 	byte last_bytet 	logical*4 compress/ ct" c The layout in the data buffer is c  key c  recorddata (minus key data) c,& c Both fields can be compressed or not ct2 c data(bpos) is the first byte of the record data  c  if can be compressed or not c  	p_key_data = ptr_keyt c 0 	compress = (fastio_header.prim_key.flags .and. .      1              key_flag_rec_compr) .ne. 0 	if(compress) then c + c Move (and uncompress) the data to recdataa c The layout is D c  word_count 		!total length of this part upto and including filler  c  uncompresseddata	!record data9 c  fillercount		!repear 'fillercount' times the last byte_ cgM c  And this structure is repeated as long as there is data in data(1:nb_data)e cf$ 	  nb_rec = 0	!no data in record yet cc 	  bpos = 1b 	  do while(bpos .lt. nb_data) c_" c Get the byte count (2 byte word) c 
 	    nb_d = 0 & 	    call lib$movc3(2,data(bpos),nb_d)' 	    bpos = bpos + 2	!we used two bytes  cn! c Now move the data to the target  c 5 	    call lib$movc3(nb_d,data(bpos),tempdata(nb_rec))d4 	    bpos = bpos + nb_d 	!we used another nb_d bytes 	    nb_rec = nb_rec + nb_do ch- c  Now the next byte in data is a fillercounteA c  The last byte in tempdata must be repeated 'fillercount' timese cd8 	    last_byte = tempdata(nb_rec-1)	!last byte in buffer. 	    rep_count = zext(data(bpos))!repeat count+ 	    bpos = bpos + 1		!we used another bytee cr c Now fill out the filler data c  	    do k=1,rep_count # 	      tempdata(nb_rec) = last_byte  	      nb_rec = nb_rec + 1 	    end doe	 	  end do. c.# c And point to the temp data buffer  ce 	  p_recdata = %loc(tempdata)  	elsed cr? c Data is not compressed, use the data from the original buffert ce 	  nb_rec = nb_data_ 	  p_recdata = %loc(data)  	endif c  c Now * c   keyval contais nb_key bytes of keydata0 c   recdata containt nb_rec bytes of record data c . c Now combine the record data and the key data c  	nb     = 0	!no bytes yetp' 	recpos = 0	!no bytes used from recdataa cr 	do k=1,max_segments6 	  flags(k) = fastio_header.prim_key.keysize(k) .gt. 0 	enddo ce- c Find the key-segment with the lowest offsetd cd 50	minval = max_buf_size+10  c @ c Go through all segments that have a length >0 and not yet used cs 	do k=1,max_segments 	  if(flags(k)) then@ 	    if(zext(fastio_header.prim_key.keypos(k)) .lt. minval) thenN 	      minval = zext(fastio_header.prim_key.keypos(k))	!remember minimum value 	      kidx = k			!and index 	    end ife	 	  end ifa 	end do " 	if(minval .lt. max_buf_size) then ce c We have found a key_segments c_3 	  flags(kidx) = .false.	!do not use this one again  c1 c Now insert keysegment (kidx)$ c  get the position in the keybuffer cz 	  kpos = 0r4 	  ksiz = zext(fastio_header.prim_key.keysize(kidx)) 	  do k=1,kidx-1: 	    kpos = kpos + zext(fastio_header.prim_key.keysize(k))	 	  end do  c , c The keydata is in key(pos:pos+sizes(kidx)) c insert in data bufferc c O 	  pos = zext(fastio_header.prim_key.keypos(kidx))	!the size in the data buffero 	  if(nb .lt. pos) thenr cnB c We have data in the record buffer before the current key-segment
 c  copy it cs8 	    call lib$movc3(pos-nb,recdata(recpos),record(nb+1)) 	    recpos = recpos + pos-nbi 	    nb     = nb + pos-nbe 	  endif c  c Now copy the key c 3 	  call lib$movc3(ksiz,key_data(kpos),record(nb+1))f 	  nb = nb + ksizi
 	  goto 50 	endif cr. c Now see it there is still data in the buffer cl 	if(recpos .lt. nb_rec) then cf c Append the trailing data c = 	  call lib$movc3(nb_rec-recpos,recdata(recpos),record(nb+1))l 	  nb = nb + nb_rec-recpos	 	endif	  e 	returne 	end3 	function dix_fastio__scroll(control,fastio_header)e 	implicit none ce5 c Take the next piece of file to sequential buffer #1s; c  this is used for rel/seq files. In this case we only useo& c  one seq_buffer and no random buffer cs 	include 'dix_fastio_def.inc'f- 	record /control/ control		!:i: control blockb< 	record /fastio_header/ fastio_header    !:io: fastio header3 	integer*4 dix_fastio__scroll		!:f: function resultb ck 	integer*4 k,istat,nk,nb! 	character*(max_line_length) line_ 	integer*4 dix_fastio__read_seqd cb! 	k = fastio_header.seq(1).nb_readf3 	if((control.debug .and. debug_fastio) .ne. 0) then D 	  nb = max(fastio_header.bucket_size,fastio_header.seq_block_count)4 	  call sys$fao(' Need seq_read blnr=!UL nbl = !UL',G      1         nk,line,%val(fastio_header.seq(1).end_block+1),%val(nb))e= 	  call dix_main_print_debug(control,debug_fastio,line(1:nk))a 	endif ce. 	istat = dix_fastio__read_seq(fastio_header,1,:      1                 fastio_header.seq(1).end_block + 1) 	fastio_header.data_offset =  )      1      fastio_header.data_offset - kg ct 	dix_fastio__scroll = istatl 	returnh 	end+ 	subroutine dix_fastio_return_rfa(file,rfa)e 	implicit none c) c Retrun the fastio rfas cl 	include 'dix_fastio_def.inc'( 	record /file_info/ file 	record /rfa/ rfah ca% 	record /fastio_header/ fastio_header(( 	pointer (p_fastio_header,fastio_header) cr' 	p_fastio_header = file.ptr_fast_searchd 	rfa = fastio_header.cur_rfa 	returnr 	end& 	subroutine dix_fastio_get_recnr(file) 	implicit none c.& c Return the record number to the file ct 	include 'dix_fastio_def.inc't* 	record /file_info/ file		!:io: file block cr% 	record /fastio_header/ fastio_headero( 	pointer (p_fastio_header,fastio_header) cs' 	p_fastio_header = file.ptr_fast_search1" 	file.rec_nr = fastio_header.recnr 	returne 	end, 	subroutine dix_fastio_show_vm(control,file) 	implicit none cd c Display info about vmr ct 	include 'dix_fastio_def.inc'o 	record /control/ control  	record /file_info/ file cb 	record /vm_zone/ vm_zonea co 	integer*4 nk,kn! 	character*(max_line_length) line  c % 	record /fastio_header/ fastio_headere( 	pointer (p_fastio_header,fastio_header) ce 	vm_zone.magic = magic_vm_zone ci% 	if(file.ptr_fast_search .ne. 0) then=7 	  call dix_dump_print_line(control,1,'FASTIO buffers') + 	  p_fastio_header   = file.ptr_fast_search2? 	  vm_zone.nb_alloc  = fastio_header.seq_block_count*block_sizei4 	  vm_zone.n_alloc   = fastio_header.seq_block_count 	  vm_zone.n_dealloc = 0 	  vm_zone.nb_dealloc= 0! 	  do k=1,fastio_header.n_seq_buf)0 	    vm_zone.zone = fastio_header.seq(k).address3 	    call sys$fao('Seq buffer !UL',nk,line,%val(k))y 	    vm_zone.name = line(1:nk)6 	    call dix_util_show_vm1(control,vm_zone,.false.,2) 	  enddo> 	  vm_zone.nb_alloc = fastio_header.ran_block_count*block_size3 	  vm_zone.n_alloc  = fastio_header.ran_block_countz! 	  vm_zone.name = 'Random buffer'r4 	  call dix_util_show_vm1(control,vm_zone,.false.,2) 	endif 	return  	end/ 	subroutine dix_fastio_stats_init(control,file)e 	implicit none c  	include 'dix_fastio_def.inc'd 	record /control/ control 4 	record /file_info/ file         !:i: the file block ct% 	record /fastio_header/ fastio_header ( 	pointer (p_fastio_header,fastio_header) cr 	integer*4 addru c'% 	if(file.ptr_fast_search .eq. 0) then  c	2 	  call get_vm(control,sizeof(fastio_header),addr,&      1              control.zone_file,(      1              .true.,'FASTIO_HDR') 	  p_fastio_header = addrd* 	  file.ptr_fast_search = p_fastio_header  	endif ce) 10	p_fastio_header = file.ptr_fast_searchr ci 	fastio_header.read_count   = 0a 	fastio_header.hit_count    = 0_ 	fastio_header.nblocks_read = 0_ 	fastio_header.nreads_seq   =0 	fastio_header.nreads_ran   =0  	fastio_header.nbuckets_read = 0 ce 	returny 	end/ 	subroutine dix_fastio_stats_show(control,file)0 	implicit none 	include 'dix_fastio_def.inc'q 	record /control/ control 4 	record /file_info/ file         !:i: the file block cf% 	record /fastio_header/ fastio_header ( 	pointer (p_fastio_header,fastio_header) c)! 	character*(max_line_length) liner
 	integer*4 nkh ce( 	if(control.search_flags .eq. 0) goto 90 ch' 	p_fastio_header = file.ptr_fast_searche ce) 	if(fastio_header.channel .eq. 0) goto 90a c.8 	call dix_dump_print_line(control,0,'FASTIO statistics')7 	call sys$fao('!UL Seq buffers of !UL blocks, #IO=!UL',r      1         nk,line, -      1         %val(fastio_header.n_seq_buf),r3      1         %val(fastio_header.seq_block_count),f.      1         %val(fastio_header.nreads_seq))/ 	call dix_dump_print_line(control,2,line(1:nk))o ct9 	call sys$fao('!UL Seq buffers of !UL blocks, #io = !UL',e      1         nk,line,       1         %val(1), 3      1         %val(fastio_header.ran_block_count),e.      1         %val(fastio_header.nreads_ran))/ 	call dix_dump_print_line(control,2,line(1:nk))  c 7 	call sys$fao('Total blocks read !UL, file size = !UL',h      1              nk,line,5      1              %val(fastio_header.nblocks_read), 2      1              %val(fastio_header.file_size))/ 	call dix_dump_print_line(control,2,line(1:nk)) 	 90	returnt 	end goto 90 	  enddo c	       c Get the record size  c ? 	  call lib$movc3(2,var_data(fastio_header.data_offset),recsiz) 5 	  if(fastio_header.msb) recsiz = ishftc(recsiz,8,16)  c B 	  fastio_header.data_offset = fastio_header.data_offset + 2	!skip c " c Now we need to copy recsiz bytes c  	  if(recsiz .eq. 'ffff'x) then  c  c Round upto next block  c ! 	    fastio_header.data_offset =  D      1         (fastio_header.data_offset/block_size + 1)*block_size 	    goto 50	      	  end                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                