/* Program Name            : FILERQUE.H                                 */
/*   Original Author       : C. K. Hung					*/
/*   Date                  : 1-JUN-1990					*/
/*   Program Description   :                                            */  
/*                         :                                            */ 
/* Revision History follows                                             */
/*  03-Jun-1999 JL Cleaned                                              */



/* ****  GLOBAL DECLARATIONS *** */

#define		MAXBUFFER		20	/**  Size of the dir cache   **/
typedef struct filer_cache_tag
{
	DATE_TIME time_stamp;			/**  Last access time	     **/
	enum sortbys sortby;			/**  Sort by		     **/
	enum sortorders sortorder;		/**  Sort order		     **/
        char cur_dir[MAXFILESPEC+1];            /**  Directory name          **/
        char par_dir[MAXFILESPEC+1];            /**  Parent directory name   **/
	long int tot_files,			/**  Total files	     **/
		 tot_blocks;			/**  Total blocks	     **/
	unsigned short int dpro;		/**  Directory protection    **/
	short int subdir;			/**  No. of sub-directories  **/
	struct cur_filter_tag cur_filter;
						/**  Filter criteria	     **/
	struct fil_dx_tag *dir_filelist, 
			  *non_dir_filelist,
			  *exclude_filelist;
} TD_FILER_CACHE_TAG;

TD_FILER_CACHE_TAG filer_cache[MAXBUFFER];   /**  Buffer to save directory info **/



/* ****  FUNCTIONS PROTOTYPING *** */

int	initialize_filer_cache(void);
int	find_LRU_in_filer_cache(void);
int	search_filer_cache(struct cur_filter_tag);
int	save_to_filer_cache(int, struct dir_dx_tag);
int	restore_from_filer_cache(int, struct dir_dx_tag *);
int	update_filer_cache(struct fil_dx_tag, int (*)(), char *);
int	add_to_filer_cache(struct fil_dx_tag, struct filer_cache_tag *, char *);
int	delete_from_filer_cache( struct fil_dx_tag, struct filer_cache_tag *, char *);
int	change_to_filer_cache( struct fil_dx_tag, struct filer_cache_tag *, char *);
void	copy_filespec_list(struct filespec_list_tag *, struct filespec_list_tag **);
void	copy_filelist(struct fil_dx_tag *, struct fil_dx_tag **, enum sortbys, enum sortorders);
int	select_from_filer_cache(void);

