/* Program Name            : FILEREDT.C                                 */
/*   Original Author       : C. K. Hung					*/
/*   Date                  : 18-MAY-1991				*/
/*   Program Description   :                                            */
/*                         :                                            */
/* Revision History follows                                             */
/*  03-Jun-1999 JL removed support for LSE				*/
 
 
#include "global.h"
#include "dx.h"
#include "filer.h"
#include "fileredt.h"
#include "fileropt.h"
#include "filerkpd.h"
#include "inquire.h"
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      tbs
**
**--
**/
int	filer_edt()
{
    if (DX_CURRENT_DIRECTORY.filemode == multiple)
	filer_multiple_edt();
    else
	filer_single_edt();
    return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      to be specified
**
**--
**/
int	filer_multiple_edt()
{
    char dummy[] = "";
    char errmsg[MAXFILESPEC+1];
 
    check_OK(smg$disable_broadcast_trapping (
                 &cntrl_info_block.pasteboard_id))
    filer_multiple(
	filer_edt$1,
	dummy,
	errmsg);
    check_OK(smg$set_broadcast_trapping (
                 &cntrl_info_block.pasteboard_id,
                 broadcast_routine,
                 0))
    if (cntrl_info_block.user_pref.auto_update)
    {
	filer_update();
    }
    return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      to be specified
**
**--
**/
int	filer_single_edt()
{
    char dummy[] = "";
    char errmsg[MAXFILESPEC+1];
    char fn[MAXFILESPEC+1];
 
    if (!strcmp(DX_CURRENT_FILE->fn, "[-]"))
    {
        signal_err("Edit a parent directory file not allowed", bell);
    }
    else
    {
	find_full_path_name(DX_CURRENT_FILE->fn, fn, cntrl_info_block.cur_win);
	check_OK(smg$disable_broadcast_trapping (
		     &cntrl_info_block.pasteboard_id))
	strcpy(errmsg, "Error editing file");
	if (filer_edt$1(dummy, fn, errmsg) == -1)
	{
	    signal_err(errmsg, bell);
	}
	check_OK(smg$set_broadcast_trapping (
		     &cntrl_info_block.pasteboard_id,
		     broadcast_routine,
		     0))
	if (cntrl_info_block.user_pref.auto_update)
	{
	    filer_update();
	}
    }
    return DX__NORMAL;
}
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      to be specified
**
**--
**/
int	filer_edt$1(dummy, fn, errmsg)
char *dummy;
char *fn;
char *errmsg;
{
    char *cp;
    char err_str[MAXFILESPEC+1];
    unsigned long display_id;
    $DESCRIPTOR (in_file, fn);
    $DESCRIPTOR (out_file, "");
    char command_line[256];
    $DESCRIPTOR (tpu_cmd, command_line);
    long _align( LONGWORD ) options;
 
    extern edt$edit();
 
    /*
    **	Check if file access is allowed
    **/
 
    if (access(fn, 4) == EOF)
    {
	/**  No READ access  **/
	strcpy(errmsg, "Insufficient privilege for read operation");
	return DX__ERROR;
    }
 
    check_OK(smg$save_physical_screen (
	      &cntrl_info_block.pasteboard_id,
	      &display_id,
	      0,
	      0))
 
    check_OK(smg$erase_pasteboard (
	      &cntrl_info_block.pasteboard_id))
 
    LENGTH(in_file) = strlen(fn);
    if (cntrl_info_block.user_pref.editor == DX_EDITOR_EDT) {
	options = 0x14;	    /**  /NOJOURNAL and /NOCOMMAND are used  **/
	edt$edit(
	    &in_file,
	    0,
	    0,
	    0,
	    &options,
	    0,
	    0,
	    0);
 
    } else {
        check_OK(tpu$edit(
		    &in_file,
		    &out_file))	
    }
 
    check_OK(smg$restore_physical_screen (
	      &cntrl_info_block.pasteboard_id,
	      &display_id))
 
    return DX__NORMAL;
}
