/* Program Name            : FILER.H                       		*/
/*   Original Author       : C. K. Hung					*/
/*   Date                  : 20-MAY-1991                                */
/*   Program Description   :                                            */  
/*                         :                                            */ 


/* ************ MACRO DEFINITIONS ************  */

/**  Filer virtual display  **/
#define FILER_BOTTOM 	cntrl_info_block.dir_dx[cntrl_info_block.cur_win].filer_display.rows
#define FILER_RIGHTMOST	cntrl_info_block.dir_dx[cntrl_info_block.cur_win].filer_display.width
#define FILER_PBD_ROW				5
#define FILER_PBD_COLUMN			1
#define FILER_DIRECT_ROW			1
#define FILER_DIRECT_COLUMN			1
#define FILER_STAT_ROW				2
#define FILER_STAT_COLUMN			1
#define FILER_COLUMNS				4
#define FILER_COLUMN_WIDTH			cntrl_info_block.pasteboard_width/FILER_COLUMNS

#define FILER_PFS    				"1HELP   2DIRECT 3FIND/F 4FIND/N 5FIRST  6LAST   7INC/EX 8PAGE   9MODE   0CANCEL "

/**  FILER timeout				**/
#define FILER_TIMEOUT				10

#define CMDS_RSV_LNS				3
#define DIRINFO_RSV_LNS				3

/**  General commands				**/
#define GEN_CMDS_ROW				1
#define GEN_CMDS_COLUMN				1

/**  Clock position				**/
#define TIME_ROW				2


/* ************ FUNCTION PROTOTYPING ************  */

int		    DX_process_loop(void);
int		    put_general_cmds(menutp *);
int		    write_time(unsigned long int);
int		    clear_time(void);
int		    put_filer_pfs(char *, unsigned long);
int		    compute_filer_begin_xy(struct fil_dx_tag *, long int *,
			long int *, unsigned short int);
int		    write_to_filer(struct fil_dx_tag *);
void		    format_filer_entry(struct fil_dx_tag *, char *, unsigned short int);
int		    setddir(char *, char *);
int		    highlight_filer_current_file(void);
int		    unhighlight_filer_current_file(void);
int		    put_filer_title(unsigned short int);
int		    put_filer_stat(unsigned short int);
int		    filter_alarm_working(void);
int		    find_full_path_name(char *, char *, unsigned short int);
int		    convert_date_string();

