P /*******************************************************************************P ********************************************************************************  $    Site:	Western Michigan University 		University Computing Services   &    System:	General Purpose Subroutines       Program:	JOBLOG  1    Version=01	Level=00	09/12/90	Leonard J. Peirce   E    Purpose:	Three general purpose subroutines used by JOBLOG.  If you 9 		want to use them for something else, feel free.  I just < 		didn't want to include them in JOBLOG.C since they already! 		exist in a object library here.   1    Version=01	Level=01	01/18/91	Leonard J. Peirce   >    Purpose:	Add strmcpy, str_pref_trim(), and str_post_trim().  1    Version=01	Level=02	03/17/95	Leonard J. Peirce   D    Purpose:	Change a variable from a register to automatic in cat().  ' 		Change a few comments that needed it.   %    Arguments:	See individual routines       External variables:	none       WMU external functions:  G           Defined:	cat,strins,strlu,strmcpy,str_post_trim,str_pref_trim              Called:	none      Files accessed:	none   (    Return codes:	See individual routines  *    Compiling instructions:	See DESCRIP.MMS  (    Linking instructions:	See DESCRIP.MMS  <    Other information:		Copyright (c) 1990, Leonard J. Peirce  P ********************************************************************************P *******************************************************************************/  P /******************************************************************************/P /*                                                                            */P /*                        # I N C L U D E   F I L E S                         */P /*                                                                            */P /******************************************************************************/   #include varargs #include ctype #include string   P /******************************************************************************/P /*                                                                            */P /*                             # D E F I N E S                                */P /*                                                                            */P /******************************************************************************/  P /******************************************************************************/P /*                                                                            */P /*          S T R U C T U R E S ,   U N I O N S ,   T Y P E D E F S           */P /*                                                                            */P /******************************************************************************/  P /******************************************************************************/P /*                                                                            */P /*   E X T E R N A L   D E F I N I T I O N S   &   D E C L A R A T I O N S    */P /*                                                                            */P /******************************************************************************/   	 char	  *cat(), 		  *str_pref_trim(),  		  *str_post_trim(),  		  *strmcpy();    	 int	  strins();    	 void	  strlu();   P /******************************************************************************/P /*                                                                            */P /*     S T A T I C   D E F I N I T I O N S   &   D E C L A R A T I O N S      */P /*                                                                            */P /******************************************************************************/  P /*******************************************************************************P ********************************************************************************     Function:	cat   A   Purpose:	This general-purpose subroutine will concatenate null- 1 		terminated strings into one destination string.      Formal Parameters:   	Name			Description  	----			----------- # 	dest			where new string is created ! 	source1,...sourcen	input strings      Global variables:   % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------  	none      Return Codes:    	Code			Reason 	----			------' 	retval			pointer to destination string - 	nullptr			null string pointer; returned when  				no arguments are passed   P ********************************************************************************P *******************************************************************************/   char *cat(va_alist) - 					/*******   FORMAL  PARAMETERS   *******/ 4 	 va_dcl				/* variable-length parameter list     */   {	/*** cat ***/ - 					/********   LOCAL  VARIABLES   ********/ @ register char	  *dest,		/* pointer to destination string      */6 		  *source;		/* pointer to current source string   */; 	 char	  *retval;		/* to save pointer to destination     */ 6 	 int	  count;		/* number of arguments passed	      */: 	 va_list  incrmtr;		/* argument list incrementor	      */> static	 char	  *nullptr = "";	/* null string pointer		      */    9    va_start(incrmtr);			/* begin everything....		      */   9    va_count(count);			/* get number of arguments	      */   <    if(count == 0)			/* were any arguments specified?      */=       return(nullptr);			/* nope, get out of here...	      */   H    dest = va_arg(incrmtr,char*);	/* get the destination pointer	      */;    retval = dest;			/* save pointer to destination	      */   K    source = va_arg(incrmtr,char*);	/* get the first source pointer	      */   @    while(--count > 0)			/* process all of the source strings  */    {I       while(*dest++ = *source++)	/* cat the source to the destination  */  	 ;   9       dest--;				/* back over the null character	      */ G       source = va_arg(incrmtr,char*);	/* get the next argument	      */     }  8    *dest = '\0';			/* terminate the destination	      */6    va_end(incrmtr);			/* end varargs session		      */  =    return(retval);			/* return pointer to destination      */    }	/*** cat ***/   P /*******************************************************************************P ********************************************************************************     Function:	strins  @   Purpose:	Insert a character string into another at a specified 		position.      Formal Parameters:   	Name			Description  	----			----------- , 	str			string to be updated; should be large' 				enough to accomodate the new string  	new			string to be inserted' 	position		place to insert new into str      Global variables:   % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------  	none      Return Codes:    	Code			Reason 	----			------ 	  0			string insert successful / 	 -1			unable to insert string because position  				points outside of str   P ********************************************************************************P *******************************************************************************/   int strins(str,new,position)   register char	  *str, 	 		  *new;  register int	  position;   {	/*** strins ***/- 					/********   LOCAL  VARIABLES   ********/ 5 register int	  i,			/* loop and array index		      */ ( 		  j;			/* temporary variable		      */8 	 int	  new_len,		/* length of string to insert	      */( 		  str_len;		/* length of str		      */    @    str_len = strlen(str);		/* get length of current str	      */  -    if((position > str_len) || (position < 0)) 
       i = -1;     else     {F       new_len = strlen(new);		/* get length of string to insert     */I       i = new_len + str_len - 1;	/* get where to start when we shift   */ ;       *(str+i+1) = '\0'; 		/* terminate it first 		      */ >       j = str_len - 1;			/* point to last char of str	      */  E       /* now shift everything over to make room for the new string */          while(j >= position)       {  	 *(str+i) = *(str+j); 	 --i; 	 --j;       }   4       /* now add the new string in the right slot */  8       for(i = 0,j = position; *(new+i) != '\0'; i++,j++)#          *(str+j) = *(new+i);                i = 0;    }  
    return(i);    }	/*** strins ***/        P /*******************************************************************************P ********************************************************************************     Function:	strlu   G   Purpose:	Convert all lower-case characters in a string to upper-case.      Formal Parameters:   	Name			Description  	----			----------- ' 	source			source string to be converted      Global variables:   % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------  	none      Return Codes:    	Code			Reason 	----			------ 	none   P ********************************************************************************P *******************************************************************************/   void strlu(source)   register char	  *source;   {	/*** strlu ***/       while(*source)     {"       *source = _toupper(*source);       source++;     }  
    return;   }	/*** strlu ***/   P /*******************************************************************************P ********************************************************************************     Function:	strmcpy   A   Purpose:	Copy at most m characters into the target string.  The 7 		resultant string is guaranteed to be null-terminated. : 		This provides an alternative to strncpy() which does not- 		guarantee that strings are null-terminated.      Formal Parameters:   	Name			Description  	----			----------- # 	dest			where new string is written  	source			source for copy & 	max			maximum number of bytes to copy     Global variables:   % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------  	none      Return Codes:    	Code			Reason 	----			------ 	none   P ********************************************************************************P *******************************************************************************/   char *strmcpy(dest,source,max) register char	  *dest, 		  *source; register int	  max;    {	/*** strmcpy ***/ - 					/********   LOCAL  VARIABLES   ********/ 5 register int	  i;			/* loop and array index		      */   )    for(i = 0;i < max && *(source+i); i++)        *(dest+i) = *(source+i);  ?    *(dest+i) = '\0';			/* terminate the destination string   */       return(dest);   }	/*** strmcpy ***/   P /*******************************************************************************P ********************************************************************************     Function:	str_pref_trim   5   Purpose:	Strip out leading whitespace from a string      Formal Parameters:   	Name			Description  	----			-----------  	str			string to be stripped     Global variables:   % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------  	none      Return Codes:    	Code			Reason 	----			------ 	str  P ********************************************************************************P *******************************************************************************/   char *str_pref_trim(str)- 					/*******   FORMAL  PARAMETERS   *******/ 6 register char	  *str;			/* string to be trim		      */   {	/*** str_pref_trim ***/ - 					/********   LOCAL  VARIABLES   ********/ 6 register char	  *ptr;			/* temporary pointer		      */    
    ptr = str;   B    while(isspace(*ptr))			/* skip the leading whitespace first  */       ++ptr;      while(*ptr)       *ptr++ = *str++;  6    *str = '\0';				/* make sure it's a string	      */    return(str);    }	/*** str_pref_trim ***/   P /*******************************************************************************P ********************************************************************************     Function:	str_post_trim   6   Purpose:	Strip out trailing whitespace from a string     Formal Parameters:   	Name			Description  	----			-----------  	str			string to be stripped     Global variables:   % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------  	none      Return Codes:    	Code			Reason 	----			------ 	str  P ********************************************************************************P *******************************************************************************/   char *str_post_trim(str)- 					/*******   FORMAL  PARAMETERS   *******/ 6 register char	  *str;			/* string to be trim		      */   {	/*** str_post_trim ***/ - 					/********   LOCAL  VARIABLES   ********/ 6 register char	  *ptr;			/* temporary pointer		      */        ptr = &str[strlen(str) - 1];   B    while(isspace(*ptr))			/* find first non-whitespace char     */       --ptr;  @    *(ptr + 1) = '\0';			/* chop off the whitespace characters */    return(str);    }	/*** str_post_trim ***/   