/ *   Extr_Buf.For -- Buffer routines for Extract J *                                                       Pat Rankin, Oct'883 *  i*4  Buffer_File ( rab, nxt_rec, start, finish ) 3 *  i*4  Fetch_Record ( rec_num, rcrd, copy_string )o$ *  sub  Alloc_Buf_Dsc ( size, list )# *  sub  Init_Buf_Dsc ( size, list )_ *  i*4  Buf_LPeek ( l )_ *  i*2  Buf_WPeek ( w )_ *  byt  Buf_BPeek ( b )_ *  sub  Buf_BPoke ( b, val ) *       F       integer *4 function  Buffer_File ( rab, nxt_rec, start, finish ) 	!% 	!   Read an entire file into memory.t 	!@ 	!   Note:  if we're treating fixed-header portion of vfc record= 	!       as data, then the size is in the rab's context fieldd@ 	!       and the header's buffer immediately precedes the recordB 	!       buffer--they can be concatenated without moving any data. 	!A 	!   NB:  retaining vfc header as a vfc header is not implementedrA 	!       here because it's never buffered if it's on disk (assumea> 	!       that only disk files ever have vfc format).  Treating> 	!       vfc header as data is also not necessary to implement3 	!       but it's done anyway since it's so simple.i 	! 	implicit none C     called by:$ *       function        Process_File C     constant:$: 	include '($RMSdef)/nolist'              !rms status codesF 	include '($RABdef)/nolist'              !rms Record Access Block defsF 	parameter       mAX_RECORD = '7FFFFFFF'x        !largest positive i*4/ 	parameter       wORD = 2,  lONG = 4,  qUAD = 8 < 	parameter       dSC_S_SIZE = qUAD       !size of descriptorK 	parameter       cHUNK_SIZE = 256        !arbitrary amount (of descriptors)l
 C     global:x 	include 'Extract.F' 	common /buffers/ 4      &                buf_list, buf_indx, buf_limit,:      &                buf_rec_start, buf_rec_end, buf_wrap: 	  integer *4    buf_list(2) /2*0/,  buf_indx,  buf_limit,B      &                  buf_rec_start,  buf_rec_end /0/,  buf_wrap C     input:F 	record /rabdef/ rab             !input file's rms record access block
 C     output: H 	integer *4      nxt_rec,        !next fetch will retreive this record #L      &                  start,  finish  !initial & final records of interest C     local:$ 	integer *4      rec_cnt,  buf_size,6      &                  buf_start,  buf_end,  buf_ptr,      &                  sts  	integer         vfc_offseti C     functions:, 	integer         Buf_WPeek *2,  Buf_LPeek *4 	integer *4      Alloc_Buf_Dsc, +      &                  SYS$FIND,  SYS$GET, &      &                  LIB$SCOPY_R_DX! 	intrinsic       ZEXT,  MAX,  MIN    	sts = 1 	buf_rec_start = 0 	buf_rec_end   = 0 	start  = 1      !temp 	finish = 0      !temp 	if ( start_val .gt. 0 ) thenk5 C         skip until we reach desired starting recordc/ 	    nxt_rec = 0         !($find needs 1 extra)= 	    start = start_val. 	    do while ( nxt_rec .lt. start .and. sts ). 		if ( SYS$FIND( rab) )  nxt_rec = nxt_rec + 1 		sts = rab.rab$l_sts  	    end don 	    if ( .not. sts )  goto 88 	elsec 	    nxt_rec = 1 	end ifm* C     determine how many records to bufferD 	if ( start_val .gt. 0 .and. end_val .gt. 0 ) then   !(won't happen)( 	    buf_limit = end_val - start_val + 1" 	else if ( start_val .lt. 0 ) then@ 	    buf_limit = -start_val              !buffer -start thru eof 	elsem 	    buf_limit = mAX_RECORD  	end ifa$ C     initialize buffer if necessary 	if ( buf_list(1) .eq. 0 ) thenz 	    buf_size = cHUNK_SIZE0 	    sts = Alloc_Buf_Dsc( buf_size, buf_list(2))3 	    buf_list(1) = buf_size              !save sizeb 	end if 
 	buf_indx = 0a 	buf_rec_start = nxt_rec
 	buf_wrap = 0p  O C     prepare for vfc manipulation (easy--the hard stuff has already been done)  	vfc_offset = 0f+ 	if ( use_vfc )  vfc_offset = rab.rab$l_ctxp  C C     loop through the rest of the input stream, retreiving recordsn& C         and copying them into memory 	rec_cnt = nxt_rec - 1 	do while ( sts )Y' 	    if ( SYS$GET( rab) .eq. RMS$_RTB ) M      &              rab.rab$l_sts = rab.rab$l_sts .or. 3                !****r 	    sts = rab.rab$l_sts 	    if ( sts ) then9 		rec_cnt = rec_cnt + 1           !increment record count= 		buf_indx = buf_indx + 1i: 		if ( buf_indx .eq. 1 .or. buf_indx .gt. buf_limit ) then 		    buf_size = buf_list(1) 		    buf_start = buf_list(2)n1 		    buf_end = buf_start + buf_size * dSC_S_SIZEt 		    buf_ptr = buf_starte 		    buf_rec_start = rec_cntr 		    buf_wrap = rec_cnt - 1 		    buf_indx = 1 		end if= 		buf_ptr = buf_ptr + dSC_S_SIZE  !advance to next descriptorp" 		if ( buf_ptr .gt. buf_end ) then0 		    buf_ptr = Buf_LPeek( %VAL(buf_start+lONG))  		    if ( buf_ptr .ne. 0 ) then 			buf_start = buf_ptr/ 			buf_size = ZEXT(Buf_WPeek( %VAL(buf_start))) 
 		    else 			buf_size = cHUNK_SIZE! 			sts = Alloc_Buf_Dsc( buf_size, A      &                                      %VAL(buf_start+lONG)) 
 			if ( sts ) H      &                      buf_start = Buf_LPeek( %VAL(buf_start+lONG)) 		    end if 		    buf_end = buf_start A      &                       + buf_size * cHUNK_SIZE * dSC_S_SIZEt> 		    buf_ptr = buf_start + dSC_S_SIZE    !advance to position 		end if 		if ( sts )G      &          sts = LIB$SCOPY_R_DX( ZEXT(rab.rab$w_rsz) + vfc_offset, F      &                               %VAL(rab.rab$l_rbf - vfc_offset),3      &                               %VAL(buf_ptr))  	    end if  	end do !while sts 	buf_rec_end = rec_cnt  ? C     we can now determine proper values for for start & finish  	if ( start_val .le. 0 ) then / 	    start = MAX( (rec_cnt + 1) + start_val, 1)  *       else# *           start already set above  	end if  	if ( end_val .le. 0 ) then . 	    finish = MAX( (rec_cnt + 1) + end_val, 0) 	else $ 	    finish = MIN( end_val, rec_cnt) 	end if 2 	nxt_rec = start         !setup for Process_File()     88    continue4 	if ( sts .eq. RMS$_EOF )  sts = 1       !SS$_NORMAL   	Buffer_File = sts 	return        end !of Buffer_File         F       integer *4 function  Fetch_Record ( rec_num, rcrd, copy_string ) 	!6 	!   Retreive a record that's been buffered in memory. 	!? 	!   Note:  if the caller intends to expand tabs, 'copy_string' A 	!       will direct us to copy the record contents into caller's ? 	!       large buffer instead of just filling in the descriptor @ 	!       with a pointer to the buffered record.  [Eventually tabA 	!       processing will be revised to eliminate this necessity.]  	! 	implicit none C     called by:$ *       function        Process_File C     constant: : 	include '($RMSdef)/nolist'              !rms status codes9 	include 'f_inc:Dsc.F'                   !descriptor defs $ 	parameter       lONG = 4,  qUAD = 8" 	parameter       dSC_S_SIZE = qUAD
 C     global:  *       include 'Extract.F'  	common /buffers/ 4      &                buf_list, buf_indx, buf_limit,:      &                buf_rec_start, buf_rec_end, buf_wrap: 	  integer *4    buf_list(2) /2*0/,  buf_indx,  buf_limit,B      &                  buf_rec_start,  buf_rec_end /0/,  buf_wrap C     input:/ 	integer *4      rec_num         !record number E 	logical         copy_string     !flag to force string copy instead - N C     input/output:                     !+ of simply filling in the descriptorE 	record /dsc/    rcrd            !string descriptor to receive record  C     local: 	record /dsc_z/  temp / 	integer *4      buf_ptr,  buf_start,  buf_end, /      &                  buf_size,  target_indx, 1      &                  prev_rec,  prev_ptr,  sts  	    data    prev_rec /-1/3 	    save    prev_rec, prev_ptr, buf_start, buf_end  C     functions:, 	integer         Buf_WPeek *2,  Buf_LPeek *4 	integer *4      STR$COPY_DX   	sts = 1% 	if ( rec_num .gt. buf_rec_end ) then  	    sts = RMS$_EOF + 	else if ( rec_num .ne. prev_rec + 1 ) then  	    buf_start = buf_list(2) 	    buf_size = buf_list(1) . 	    target_indx = rec_num - buf_rec_start + 1D 	    if ( rec_num .lt. buf_rec_start )           !buffer has wrapped9      &              target_indx = target_indx + buf_limit A 	    do while ( target_indx .gt. buf_size .and. buf_start .ne.0 ) & 		target_indx = target_indx - buf_size. 		buf_start = Buf_LPeek( %VAL(buf_start+lONG)) 		if ( buf_start .ne. 0 ) E      &                  buf_size = ZEXT( Buf_WPeek( %VAL(buf_start)))  	    end do 0 	    buf_end = buf_start + buf_size * dSC_S_SIZE3 	    buf_ptr = buf_start + target_indx * dSC_S_SIZE  	else * 	    if ( rec_num .eq. buf_wrap + 1 ) then 		buf_start = %LOC(buf_list)+ 		prev_ptr = buf_end      !force 'if' below  	    end if $ 	    buf_ptr = prev_ptr + dSC_S_SIZE% 	    if ( buf_ptr .gt. buf_end ) then . 		buf_start = Buf_LPeek( %VAL(buf_start+lONG)) 		if ( buf_start .ne. 0 ) E      &                  buf_size = ZEXT( Buf_WPeek( %VAL(buf_start))) - 		buf_end = buf_start + buf_size * dSC_S_SIZE " 		buf_ptr = buf_start + dSC_S_SIZE 	    end if  	end if    	if ( .not. sts ) then *           do nothing" 	else if ( buf_start .eq. 0 ) thenF 	    sts = 0     !internal error                                 !**** 	else + 	    temp.d_len = Buf_WPeek( %VAL(buf_ptr)) 0 	    temp.d_adr = Buf_LPeek( %VAL(buf_ptr+lONG)) 	    if ( copy_string ) then  		sts = STR$COPY_DX( rcrd, temp)	 	    else  		rcrd.d_adr = temp.d_adr  	    end if  	    rcrd.d_len = temp.d_len 	    prev_rec = rec_num  	    prev_ptr = buf_ptr  	end if    	Fetch_Record = sts  	return        end !of Fetch_Record        7       integer *4 function  Alloc_Buf_Dsc ( size, list )  	!4 	!   Allocate an array of dynamic string descriptors* 	!   and initiailize them to null strings. 	! 	implicit none C     callend by: # *       function        Buffer_File  C     constant:  	integer *4      dSC_S_SIZE ! 	parameter     ( dSC_S_SIZE = 8 )  C     input: 	integer         size 
 C     output:  	integer *4      list  C     local: 	integer *4      sts C     functions: 	integer *4      LIB$GET_VM   + 	sts = LIB$GET_VM( size * dSC_S_SIZE, list) 1 	if ( sts )  call Init_Buf_Dsc( size, %VAL(list))    	Alloc_Buf_Dsc = sts 	return        end !of Alloc_Buf_Dsc         -       subroutine  Init_Buf_Dsc ( size, list )  	!< 	!   Initialize array of dynamic string descriptors to null.> 	!   The first element of the array is not a string descriptor; 	!   but is rather part of a linked list (or soon will be).  	! 	implicit none C     callend by:a% *       function        Alloc_Buf_Dsc, C     constant:f 	include 'f_inc:Dsc.F' C     input/output:d 	integer         sizeb
 C     output:  	record /dsc/    list(0:*) C     local:D 	record /dsc_d/  null            !pre-initialized dynamic descriptor 	integer         idx  # C     first element is not a string = 	size = size - 1                 !don't count initial elementi 	list(0).d_len = sizee 	list(0).d_typ = 0 	list(0).d_cls = 0# 	list(0).d_adr = 0       !next listi   	do idx = 1, size E 	    list(idx).d_quad(1) = null.d_quad(1)    !length (0), type, classd7 	    list(idx).d_quad(2) = 0                 !(address)  	end doe   	return        end !of Init_Buf_Dsc        *       integer *4 function  Buf_LPeek ( l )3 	integer *4      l                       !%val(i*4)s 	Buf_LPeek = l 	returni       end !of Buf_LPeek     *       integer *2 function  Buf_WPeek ( w )3 	integer *2      w                       !%val(i*2)e 	Buf_WPeek = w 	return        end !of Buf_WPeek     $       byte function  Buf_BPeek ( b )4 	byte            b                       !%val(byte) 	Buf_BPeek = b 	returnc       end !of Buf_BPeek     &       subroutine  Buf_BPoke ( b, val ) 	byte            b,  val 	b = val 	return        end !of Buf_BPoke 