 #ifdef VAXC % #module CLUE$MEMORY "BOL-V1.0/AUG-96"  #else , #pragma module CLUE$MEMORY "BOL-V1.0/AUG-96" #endif  5 /* This module processes the CLUE MEMORY commands. */   B /* Perform a sanitary check. The constant MAJ_VERS must be defined@    and must be either 5, 6 or 7 (the major number of the currentB    VMS version), MIN_VERS must be define as well and must not be 0?    (VMS versions V6.0 and V7.0 are not currently supported.) */   5 #if (MAJ_VERS != 5 && MAJ_VERS != 6 && MAJ_VERS != 7) < #error MAJ_VERS is undefined or contains invalid VMS version #else  #if (MIN_VERS == 0) < #error MIN_VERS is undefined or contains invalid VMS version #else   < /* Include definitions from LIB. These includes were created<    by the MLB2H (Macro library to .H file) DCL procedure. */   #include "inc:dyndef.h"  #include "inc:ewdatadef.h" #include "inc:ddbdef.h"  #include "inc:dsrvdef.h" #include "inc:ldrimgdef.h" #if MAJ_VERS != 5  #include "inc:npool_datadef.h" #else ? #define  IOC_C_NUMLISTS		80	/* Dummy definitions required to */ D #define  IOC_C_NPAGGRNMSK	63	/* provide common code for V5 and V6 */ struct __IOC {   int IOC_GQ_LISTHEADS; }; #endif #include "inc:pcbdef.h"  #include "inc:pfldef.h"  #include "inc:pfndef.h"  #include "inc:phddef.h"  #include "inc:ptedef.h"  #include "inc:ucbdef.h"  #include "inc:vadef.h" #include "inc:wcbdef.h"   9 /* DEC C includes are all given in the following file. */    #include "clue$include.h"   E #define MAX_PAGSWP_FILES 126	/* Maximum page- and swapfiles (2*63) */ ? #define MAX_ELEMENTS 4096	/* Max elements in lookaside queue */ @ #define PTE$M_SINGLE 0x00400000	/* Indicates single free SPTE */  = #define C_BLOCK_SIZE 512	/* Size of physical block on disk */   > #define LRP_MAX_SIZE	0x0740	/* Maximum size of LRP (VMS V5) */< #define IRP_FIX_SIZE	0x00B0	/* Fixed size of IRP (VMS V5) */  L /* Since the M (mask) version of the POOLPGING bit isn't defined in LIB.MLB,.    we compute it from the V (value) symbol. */  - #define EXE$M_POOLPGING 1 << EXE$V_POOLPGING    . /* Macro to round up to next page boundary. */  1 #define pagrnd(x) (x + round_mask) & ~round_mask     /* Local primary routines. */   B void clue$mem_files(),     clue$mem_free(),     clue$mem_layout(),F      clue$mem_lookaside(), clue$mem_physical(),	clue$mem_statistics();   /* Auxiliary routines. */   C void mem_stat_mscp(), mem_stat_cache(), percent(), mem_files_ref(), %      mem_lay_getsiz(),mem_lay_look();    int chk_vms_v6(),getbit();  " void get_typ(unsigned char,char*);   /* External routines */    extern int symval_and_trymem();   5 extern void translate_bits(), mfpr(), symbol_value();    /***  ***/    void clue$sda_memory() { C  /* Main routine. Depending on given qualifiers, this routine calls #     all memory-related routines. */   3  int full_flg = 0,			/* 1 if /FULL was specified */ 1      all_flg = 0,			/* 1 if /ALL was specified */ <      act_flg = 0;			/* 1 if at least one cmd was executed */   =  $DESCRIPTOR(dcl_all,       "ALL");	/* Names of qualifiers */ %  $DESCRIPTOR(dcl_files,     "FILES"); $  $DESCRIPTOR(dcl_free,      "FREE");$  $DESCRIPTOR(dcl_full,      "FULL");&  $DESCRIPTOR(dcl_layout,    "LAYOUT");)  $DESCRIPTOR(dcl_lookaside, "LOOKASIDE"); *  $DESCRIPTOR(dcl_statistics,"STATISTICS");  7  /* /ALL qualifier specified? If so, all memory-related       information is displayed. */  1  all_flg = cli$present(&dcl_all) == CLI$_PRESENT;   I  /* /FULL qualifier specified (used for MEMORY/FREE and MEMORY/FILES.) */   3  full_flg = cli$present(&dcl_full) == CLI$_PRESENT;   L  /* /FILES or /ALL? If so, display information about page and swap files. */  8  if (cli$present(&dcl_files) == CLI$_PRESENT || all_flg)  {   clue$mem_files(full_flg);      act_flg = 1;  }6  /* /STATISTICS or /ALL? Display memory statistics. */  =  if (cli$present(&dcl_statistics) == CLI$_PRESENT || all_flg)   {   clue$mem_statistics();     act_flg = 1;  }5  /* Display memory about nonpaged lookaside lists. */   <  if (cli$present(&dcl_lookaside) == CLI$_PRESENT || all_flg)  {   clue$mem_lookaside(all_flg);     act_flg = 1;  }@  /* Display information about the nonpaged free list (/FREE). */  7  if (cli$present(&dcl_free) == CLI$_PRESENT || all_flg)   {   clue$mem_free(full_flg);     act_flg = 1;  }0  /* If requested, display layout of S0 space. */  9  if (cli$present(&dcl_layout) == CLI$_PRESENT || all_flg)   {   clue$mem_layout();     act_flg = 1;  }8  /* If no qualifier was specified, give a short help. */    if (!act_flg)  {[   sda$extend_print(desc("MEMORY qualifiers: /ALL, /FILES[/FULL], /FREE[/FULL], /LAYOUT,"));   G   sda$extend_print(desc("                   /LOOKASIDE, /STATISTICS"));   }  /* Well, all done */  }   	 /******/   ! void clue$mem_files(int full_flg)  { @  /* This routine processes the MEMORY/FILES [/FULL] command. For?     every installed page- and swapfile, it displays information A     about the file's usage. If /FULL is specified (full_flg = 1), <     all processes currently assigning blocks in the file are     displayed as well. */   5  char devnam[DDB$S_NAME],		/* Pagefile device name */ 7       buffer[22],			/* Buffer to receive status bits */ G       blanks[] = "                    ",/* Blanks for FAO formatting */ 7       pag_str[] = "Page",		/* String for 'page' file */ 7       swp_str[] = "Swap";		/* String for 'swap' file */   7  int pagswpvc,				/* Address of page/swapfile vector */ 0      page_size,				/* Size of a physical page */6      pagfilct,				/* Count of installable pagefiles */6      swpfiles,				/* Count of installable swapfiles */      swpinc,				/* SPWINC */-      totf,				/* Total # of files to check */ !      cnt=0,				/* File counter */ #      aux[2],				/* Aux variables */       i,					/* Loop counter */&      ch_geq,				/* Chunks ge SWPINC */%      ch_lt,				/* Chunks lt SWPINC */ $      ch_max,				/* Max chunk size */)      ch_cur,				/* Curr max chunk size */ 5      swpfilcnt = 0,			/* Actual count of swapfiles */ 5      pagfilcnt = 0;			/* Actual count of pagefiles */   *  void* bitbase;				/* Pointer to bitmap */  
  unsigned int B      pg_array[MAX_PAGSWP_FILES];	/* Page/swap file vector array */  =  $DESCRIPTOR(buf,buffer);		/* Descriptor for status string */   6  struct __PFL t;			/* PFL (page file control block) */  1  struct __UCB u;			/* UCB (unit control block) */   %  struct bittab				/* Pagefile bits */ -    pflbittab[5] = {PFL$M_INITED,    "inited", " 		   PFL$M_PAGFILFUL, "pagfilful"," 		   PFL$M_SWPFILFUL, "swpfilful",  		   PFL$M_DINSPEN,   "dinspen",
 		   0,0};  M  /* -------------------------> WE START HERE <---------------------------- */   "  /* Display header on new page. */  C  sda$extend_format_subheading(desc("Paging File Usage (Blocks):"));     sda$extend_new_page();   $  /* Get some relevant exec cells: */  +  /* Address of page- and swapfile vector */   6  symval_and_trymem(desc("MMG$GL_PAGSWPVC"),&pagswpvc);    /* Size of a physical page. */   8  symval_and_trymem(desc("MMG$GL_PAGE_SIZE"),&page_size);  F  /* Count of installed pagefiles (mask with 0xFFFF since a longword isF     always returned by symval_and_trymem, however, this cell is a word
     only). */   6  symval_and_trymem(desc("SGN$GW_PAGFILCT"),&pagfilct);    pagfilct &= 0xFFFF;  $  /* Count of installed swapfiles. */  6  symval_and_trymem(desc("SGN$GW_SWPFILES"),&swpfiles);    swpfiles &= 0xFFFF;    /* Chunk allocation size. */   2  symval_and_trymem(desc("SWP$GW_SWPINC"),&swpinc);    swpinc &= 0xFFFF;  M  /* If one of these is 0 (except SGN$_SWPFILES), we can't process further. */   =  if (!page_size || !pagfilct || !swpinc || !pagswpvc) return;   =  /* Get max files to process (including NULL file vector). */      totf = pagfilct + swpfiles + 1;  @  /* Sum can't be more than 126 (63 Pagefiles + 63 Swapfiles). */  6  if (totf > MAX_PAGSWP_FILES) totf = MAX_PAGSWP_FILES;  '  /* Copy page- and swapfile vectors. */   -  sda$extend_reqmem(pagswpvc,pg_array,totf*4);   <  /* The following must done for every page- and swapfile. */    while (cnt != totf)  {5   /* If NULL file vector (unused vector), skip it. */   7   if (pg_array[cnt] == pg_array[0]) {cnt ++; continue;}   $   /* Copy pagefile control block. */  3   sda$extend_reqmem(pg_array[cnt],&t,PFL$K_LENGTH);      /* Get WCB. */  -   aux[0] = t.PFL$L_WINDOW + WCB$L_ORGUCB_OFF;   9   if (!(sda$extend_trymem(aux[0],&aux[1],4) & 1)) return;   ;   /* From WCB, get UCB of device where pagefile resides. */   ?   if (!(sda$extend_trymem(aux[1],&u,UCB$K_LENGTH) & 1)) return;   (   aux[0] = u.UCB$L_DDB + DDB$T_NAME_OFF;     /* Get device name. */  A   if (!(sda$extend_trymem(aux[0],devnam,DDB$S_NAME) & 1)) return;   E   /* Print Page- or Swapfile, System-wide file index, device name and       device unit number. */   G   sda$extend_print(desc("!4AZfile (Index !UB)!24* Device!21* !AC!UL:"), < 	cnt > swpfiles ? "Page " : "Swap",cnt,devnam,u.UCB$W_UNIT);  4  /* Increment actual pagefile- or swapfile count. */  3  if (cnt > swpfiles) pagfilcnt++; else swpfilcnt++;   E  /* Print address of pagefile control block and UCB address of device +     where the page- or swapfile resides. */   a   sda$extend_print(desc("!30<   PFL Address!>!XL!30<    UCB Address!>!XL"),pg_array[cnt],aux[1]);   F   /* Compute free and reservable blocks and print this information. */  $   aux[0] = page_size / C_BLOCK_SIZE;     sda$extend_print(desc("!28<   Free Blocks!>!10UL!28<    Reservable Blocks!>!10SL"),t.PFL$L_FREPAGCNT*aux[0],t.PFL$L_RSRVPAGCNT*aux[0]);   +   /* Translate flag bits to text string. */   1   translate_bits(pflbittab,t.PFL$B_FLAGS,buffer);   $   buf.dsc$w_length = strlen(buffer);  (   /* Print total file size and flags. */     sda$extend_print(desc("!28<   Total Size (blocks)!>!10UL!18<    Flags!>!AF!AS"),t.PFL$L_BITMAPSIZ*8*aux[0],20-buf.dsc$w_length,blanks,&buf);  I   /* Print file usage - how many processes use the file for either paging       or swapping. */     sda$extend_print(desc("!28<   Paging Usage (processes)!>!10UW!28<    Swap Usage (processes)!>!10UW"),t.PFL$L_REFCNT-t.PFL$L_SWPREFCNT,t.PFL$L_SWPREFCNT);   F   /* If the page- or swapfile is initialized and deinstallation is not8      pending, look for largest contiguous free space. */  G   if (t.PFL$B_FLAGS & PFL$M_INITED && !(t.PFL$B_FLAGS & PFL$M_DINSPEN))    { A    /* Copy bitmap representing free/used blocks. If either memory A       allocation failed or the bitmap can't be accesses, skip the *       rest and continue with next file. */  6    if (!(lib$get_vm(&t.PFL$L_BITMAPSIZ,&bitbase) & 1))    {     sda$extend_skip_lines(1);   
     cnt++;  
     continue;     }J    if (!(sda$extend_trymem(t.PFL$L_BITMAP,bitbase,t.PFL$L_BITMAPSIZ) & 1))    {     sda$extend_skip_lines(1);   
     cnt++;  
     continue;     }G    /* Initialize counters: ch_max: maximum free chunks, ch_cur: current G       free chunks, ch_geq: free chunks ge SWPINC, ch_lt: free chunks lt H       SWPINC. The term 'chunks' means units of physical pages: 512 bytes;       (1 block) on VAX, 8192 bytes (16 blocks) on Alpha. */   (    ch_max = ch_cur = ch_geq = ch_lt = 0;      /* Scan bit map size. */   )    for (i=0;i != t.PFL$L_BITMAPSIZ*8;i++)     {G     /* If bit is set, this chunk is free. Increment current counter. */   )     if (getbit(bitbase,i) == 1) ch_cur++;   B     /* Otherwise, the chunk is busy. If current counter is gt thanF        free counter, update free counter and reset current counter. */       else     { *      if (ch_cur > ch_max) ch_max = ch_cur;        if (ch_cur)      {3       if (ch_cur >= swpinc) ch_geq++; else ch_lt++;       }      ch_cur = 0;     }     }0    /* End of bitmap reached. Update counters. */  (    if (ch_cur > ch_max) ch_max = ch_cur;  2    if (ch_cur >= swpinc*8) ch_geq++; else ch_lt++;  E    /* Display this information. On VAX, since the chunk size is equal G       to the size of a block, we can display information about 'blocks' %       instead of 'pages' on Alpha. */   x    sda$extend_print(desc("!30<   Alloc Size SWPINC (blocks)!>!8UL!28<    Largest Chunk (blocks)!>!10UL"),swpinc,ch_max);  g    sda$extend_print(desc("!28<   Chunks GEQ SWPINC!>!10UL!<    Chunks LT SWPINC!>!10UL"),ch_geq,ch_lt);   #    /* Release memory for bitmap. */   ,    lib$free_vm(&t.PFL$L_BITMAPSIZ,&bitbase);   }    sda$extend_skip_lines(1);   @   /* If /FULL was given, display all assignments to the file. */     if (full_flg)    {     mem_files_ref(cnt);      sda$extend_skip_lines(1);   } 6   /* Increment file index, continue with next file. */     cnt++;  }  /* Display summary info. */  f  sda$extend_print(desc("Summary: !UL Pagefile!%S and !UL Swapfile!%S installed"),pagfilcnt,swpfilcnt); }   	 /******/    void clue$mem_statistics() { A  /* This routine processes the MEMORY/STATISTICS command. Various A     accounting-related and statistical information is displayed.  =     If the MSCP server is loaded, MSCP-related information is      displayed as well. */   9  int val[3];		/* To receive integer values for display */     /* Print header. */  E  sda$extend_format_subheading(desc("Memory Management Statistics:"));     sda$extend_new_page();   4  /* Print pool-related and pagefault information. */  <  sda$extend_print(desc("!40<Pagefaults:!>Non-Paged Pool:"));  =  /* Total pagefauls and non-paged pool expansion attempts. */   2  symval_and_trymem(desc("PMS$GL_FAULTS"),&val[0]);  7  symval_and_trymem(desc("PMS$GL_NPAGDYNEXPS"),&val[1]);   m  sda$extend_print(desc("!25<Total Page Faults!>!10UL!30<     Successful Exp Attempts!>!10UL"),val[0],val[1]);   K  /* Total page reads and unsuccessful non-paged pool expansion attempts. */   2  symval_and_trymem(desc("PMS$GL_PREADS"),&val[0]);  7  symval_and_trymem(desc("PMS$GL_NPAGDYNEXPF"),&val[1]);   n  sda$extend_print(desc("!25<Total Page Reads!>!10UL!30<     Unsuccessful Exp Attempts!>!10UL"),val[0],val[1]);  A  /* Total page read I/O and non-paged pool expansion failures. */   3  symval_and_trymem(desc("PMS$GL_PREADIO"),&val[0]);   4  symval_and_trymem(desc("PMS$GL_NPAGDYNF"),&val[1]);  j  sda$extend_print(desc("!25<I/O's to read Pages!>!10UL!30<     Expansion Failures!>!10UL"),val[0],val[1]);  ;  /* Modified pages writes and failed pages accumulation. */   3  symval_and_trymem(desc("PMS$GL_PWRITES"),&val[0]);   9  symval_and_trymem(desc("PMS$GL_NPAGDYNFPAGES"),&val[1]);   s  sda$extend_print(desc("!25<Modified Pages Written!>!10UL!30<     Failed Pages Accumulator!>!10UL"),val[0],val[1]);   L  /* Modified page write I/O and total non-paged pool allocation requests. */  3  symval_and_trymem(desc("PMS$GL_PWRITIO"),&val[0]);   6  symval_and_trymem(desc("PMS$GL_NPAGDYNREQ"),&val[1]);  q  sda$extend_print(desc("!25<I/O's to write Mod Pages!>!10UL!30<     Total Alloc Requests!>!10UL"),val[0],val[1]);   G  /* DZRO (Demand zero) page faults and failed non-paged pool allocation      requests. */  4  symval_and_trymem(desc("PMS$GL_DZROFLTS"),&val[0]);  7  symval_and_trymem(desc("PMS$GL_NPAGDYNREQF"),&val[1]);   l  sda$extend_print(desc("!25<Demand Zero Faults!>!10UL!30<     Failed Alloc Requests!>!10UL"),val[0],val[1]);  <  /* Global valid faults and information about paged pool. */  2  symval_and_trymem(desc("PMS$GL_GVALID"),&val[0]);  Q  sda$extend_print(desc("!25<Global valid faults!>!10UL     Paged Pool:"),val[0]);   ;  /* Paged pool access failures. The left field contains the >     modified page faults on Alpha; on VAX, we leave this field6     empty since there is no approbiate system cell. */  3  symval_and_trymem(desc("PMS$GL_PAGDYNF"),&val[0]);   A  sda$extend_print(desc("!40* !25<Total failures!>!10UL"),val[0]);   =  /* Accumulation of failed pages. The left field contains the :     read page faults on Alpha; on VAX, we leave this field6     empty since there is no approbiate system cell. */  8  symval_and_trymem(desc("PMS$GL_PAGDYNFPAGES"),&val[0]);  K  sda$extend_print(desc("!40* !25<Failed Pages Accumulator!>!10UL"),val[0]);   A  /* Total paged pool allocation requests. The left field contains C     the execution page faults on Alpha; on VAX, we leave this field 6     empty since there is no approbiate system cell. */  5  symval_and_trymem(desc("PMS$GL_PAGDYNREQ"),&val[0]);   G  sda$extend_print(desc("!40* !25<Total Alloc Requests!>!10UL"),val[0]);   ,  /* Failed page pool allocation requests. */  6  symval_and_trymem(desc("PMS$GL_PAGDYNREQF"),&val[0]);  H  sda$extend_print(desc("!40* !25<Failed Alloc Requests!>!10UL"),val[0]);    sda$extend_skip_lines(1);  :  /* Direct I/O's and current number of global sections. */  1  symval_and_trymem(desc("PMS$GL_DIRIO"),&val[0]);   6  symval_and_trymem(desc("PMS$GL_GBLSECTCNT"),&val[1]);  f  sda$extend_print(desc("!25<Direct I/O!>!10UL!30<     Cur Mapped Gbl Sections!>!10UL"),val[0],val[1]);  9  /* Buffered I/O's and peak number of global sections. */R  1  symval_and_trymem(desc("PMS$GL_BUFIO"),&val[0]);v  6  symval_and_trymem(desc("PMS$GL_GBLSECTMAX"),&val[1]);  h  sda$extend_print(desc("!25<Buffered I/O!>!10UL!30<     Max Mapped Gbl Sections!>!10UL"),val[0],val[1]);  G  /* Split I/O's and current number of global pages (physical pages). *//  1  symval_and_trymem(desc("PMS$GL_SPLIT"),&val[0]);.  5  symval_and_trymem(desc("PMS$GL_GBLPAGCNT"),&val[1]);i  b  sda$extend_print(desc("!25<Split I/O!>!10UL!30<     Cur Mapped Gbl Pages!>!10UL"),val[0],val[1]);  2  /* Cache hits and peak number of global pages. */  /  symval_and_trymem(desc("PMS$GL_HIT"),&val[0]);   5  symval_and_trymem(desc("PMS$GL_GBLPAGMAX"),&val[1]);;  ]  sda$extend_print(desc("!25<Hits!>!10UL!30<     Max Mapped Gbl Pages!>!10UL"),val[0],val[1]);"  >  /* Logical name tramslations and peak number of processes. */  2  symval_and_trymem(desc("PMS$GL_LOGNAM"),&val[0]);  6  symval_and_trymem(desc("PMS$GL_PROCCNTMAX"),&val[1]);  i  sda$extend_print(desc("!25<Logical Name Transl!>!10UL!30<     Maximum Processes!>!10UL"),val[0],val[1]);f  <  /* Dead page table scan. On Alpha, the right field contains:     the # of zero pages created by the SWAPPER; on VAX, it     remains blank. */I  2  symval_and_trymem(desc("PMS$GL_DPTSCN"),&val[0]);  C  sda$extend_print(desc("!25<Dead Page Table Scans!>!10UL"),val[0]);I    sda$extend_new_page();   M  /* Print information about the lock manager. 'Incoming' and 'outgoing' meansfG     lock requests received by (incoming) and sent to (outgoing) anothernO     VMScluster member. On a non-clustered system, these values are always 0. */n  g  sda$extend_print(desc("Distributed Lock Manager:           Local         Incoming         Outgoing"));u  "  /* ENQ requests for new locks. */  6  symval_and_trymem(desc("PMS$GL_ENQNEW_LOC"),&val[0]);  5  symval_and_trymem(desc("PMS$GL_ENQNEW_IN"),&val[1]);e  6  symval_and_trymem(desc("PMS$GL_ENQNEW_OUT"),&val[2]);  ^  sda$extend_print(desc("$ENQ New Lock Requests    !15UL  !15UL  !15UL"),val[0],val[1],val[2]);  )  /* ENQ requests for lock conversions. */   6  symval_and_trymem(desc("PMS$GL_ENQCVT_LOC"),&val[0]);  5  symval_and_trymem(desc("PMS$GL_ENQCVT_IN"),&val[1]);  6  symval_and_trymem(desc("PMS$GL_ENQCVT_OUT"),&val[2]);  ^  sda$extend_print(desc("$ENQ Conversion Requests  !15UL  !15UL  !15UL"),val[0],val[1],val[2]);    /* DEQ requests. */  3  symval_and_trymem(desc("PMS$GL_DEQ_LOC"),&val[0]);w  2  symval_and_trymem(desc("PMS$GL_DEQ_IN"),&val[1]);  3  symval_and_trymem(desc("PMS$GL_DEQ_OUT"),&val[2]);   ^  sda$extend_print(desc("$DEQ Dequeue Requests     !15UL  !15UL  !15UL"),val[0],val[1],val[2]);     /* Blocking AST's requested. */  3  symval_and_trymem(desc("PMS$GL_BLK_LOC"),&val[0]);"  2  symval_and_trymem(desc("PMS$GL_BLK_IN"),&val[1]);  3  symval_and_trymem(desc("PMS$GL_BLK_OUT"),&val[2]);i  W  sda$extend_print(desc("!26<Blocking ASTs!>!15UL  !15UL  !15UL"),val[0],val[1],val[2]);i  )  /* Lock directory functions executed. */F  2  symval_and_trymem(desc("PMS$GL_DIR_IN"),&val[0]);  3  symval_and_trymem(desc("PMS$GL_DIR_OUT"),&val[1]);   O  sda$extend_print(desc("!43<Directory Functions!>!15UL  !15UL"),val[0],val[1]);p  '  /* Deadlock messages received/sent. */=  7  symval_and_trymem(desc("PMS$GL_DLCKMSGS_IN"),&val[0]);   8  symval_and_trymem(desc("PMS$GL_DLCKMSGS_OUT"),&val[1]);  M  sda$extend_print(desc("!43<Deadlock Messages!>!15UL  !15UL"),val[0],val[1]);g    sda$extend_skip_lines(1);  2  /* Waiting ENQ requests and deadlock searches. */  3  symval_and_trymem(desc("PMS$GL_ENQWAIT"),&val[0]);k  4  symval_and_trymem(desc("PMS$GL_DLCKSRCH"),&val[1]);  m  sda$extend_print(desc("$ENQ Requests that Wait  !10UL     Deadlock Searches Performed !7UL"),val[0],val[1]);i  9  /* Requests that were not queued and deadlocks found. */m  4  symval_and_trymem(desc("PMS$GL_ENQNOTQD"),&val[0]);  3  symval_and_trymem(desc("PMS$GL_DLCKFND"),&val[1]);&  m  sda$extend_print(desc("$ENQ Requests not Queued !10UL     Deadlocks Found             !7UL"),val[0],val[1]);     sda$extend_skip_lines(1);  F  /* If the MSCP server is loaded, display MSCP-related information. */  $  symbol_value(desc("MSCP"),&val[0]);  #  if (val[0]) mem_stat_mscp(val[0]);   C  /* Display information about various file caches, if available. */   -  symbol_value(desc("EXE$AR_EWDATA"),&val[0]);g    if (val[0])  {   sda$extend_new_page();  h   sda$extend_print(desc("File System Cache:     Current SYSGEN Param        Hits      Misses Hitrate"));  3   symval_and_trymem(desc("EXE$AR_EWDATA"),&val[0]);   %   if (val[0]) mem_stat_cache(val[0]);s  } }   	 /******/   # void clue$mem_lookaside(int allflg)D {SD  /* This routine processes the MEMORY/LOOKASIDE command. It displaysE     information about the 80 fixed-sized lookaside lists. These listsaD     were introduced in VAX/VMS V6.0 and replace the LRP, IRP and SRPB     lookaside lists of previous VMS versions. For this reason, you9     must run VAX/VMS V6.0 or higher to use this command. r  A     On Alpha, these lookaside lists were introduced with V1.0. */,  +  int status,				/* Memory return status; */s+      vms_v6,				/* 1 if VMS V6 or higher */ 4      pool_data,				/* Pointer to pool information */6      heads,				/* Pointer to lookaside list headers */(      cnt = 1,				/* List count (1-80) */-      elem,				/* Count of elements in list */,*      aux,				/* Pointer to next element */3      addr,				/* Virtual address of next element */s7      totbyt = 0;			/* Total bytes in lookaside lists */s  4  struct __IOC *ioc;			/* Pointer to IOC structure */  /  struct	XX				/* Format of listhead (on VAX) */   {   int fptr;	   int bptr;o  } *ptr;  M  /* -------------------------> WE START HERE <---------------------------- */a    /* Get VMS version. */f    vms_v6 = chk_vms_v6();a  8  /* On pre-V6 systems, no such lookaside lists exist. */  
  if (!vms_v6)s  {F   /* If the user specified /ALL, just skip this section. Otherwise, heH      has specified /LOOKASIDE, so tell him that this kind of information+      is not available on pre-V6 systems. */L     if (!allflg)   {L\    sda$extend_print(desc("%CLUE-W-NOSUCHINF, information not available on pre-V6 systems"));   }-	   return;-  }$  /* Set header and print new page */  I  sda$extend_format_subheading(desc("Lookaside List Queue Information:"));     sda$extend_new_page();   I  /* Global location EXE$AR_NPOOL_DATA_MON contains a pointer to non-pagedt     pool information. */  8  symbol_value(desc("EXE$AR_NPOOL_DATA_MON"),&pool_data);  4  /* Doesn't exist? Try EXE$AR_NPOOL_DATA as well. */  D  if (!pool_data) symbol_value(desc("EXE$AR_NPOOL_DATA"),&pool_data);    /* If not exist, return. */    if (!pool_data) return;     /* Get address of pool data. */  '  sda$extend_reqmem(pool_data,&heads,4);N  7  /* Map structure to data so we can reach listheads. */o    ioc = (struct __IOC*) heads;   8  /* Set pointer to first valid listhead. Skip listhead 06     since its a dummy (listheads are indexed by 1). */  0  ptr = (struct XX*) ioc -> IOC_GQ_LISTHEADS + 1;  C  /* On VAX, every lookaside list is a double linked relative queue;,?     a list head consists of a forward and backward pointer. The A     end of the list is reached when the current element points tol     the forward pointer.  F     (On Alpha, every lookaside list is a single linked absolute queue;E     a list head consists of a pointer to the first list element (or 0=D     if no) element) and a sequence number which is incremented every"     time the list is modified.) */    /* Already all listheads? */d     while (cnt != IOC_C_NUMLISTS+1)  {C   /* If forward pointer of the listhead is 0, the list is empty. */k     if (ptr->fptr == 0)r   {ts    sda$extend_print(desc("Listhead Addr: !XL    Size: !4UL    Status: valid, empty"),ptr,cnt*(IOC_C_NPAGGRNMSK+1));t  	    cnt++;)  	    ptr++;t      continue;   }=   elem = 1;O  G   /* Try first element in list. Since this is a relative queue, we must E      compute its virtual address by the address of the listhead + the       relative offset. */     addr = (int) ptr + ptr->fptr;e  *   status = sda$extend_trymem(addr,&aux,4);  
   while(1)   {vF    /* If not valid, the listhead or the previous element pointed to anH       invalid element. Since we run here at IPL 0, this may occur if theG       lookaside list was modified by a component running on higher IPL.f7       Don't care, just print an information message. */e      if (!(status & 1))d    {     sda$extend_print(desc("Listhead Addr: !XL    Size: !4UL    Status: invalid, access violation"),ptr,cnt*(IOC_C_NPAGGRNMSK+1));/  p     sda$extend_print(desc("    Error in queue linkage at address !XL, after tracing !UL element!%S"),addr,elem);  >     sda$extend_print(desc("    Data not in physical memory"));  
     break;    }J    /* If the listhead or previous element point to a valid entry, continueF       with the scan. Ensure, however, that elements do not cross-pointD       by establishing a maximum value of elements in a list (literal?       MAX_ELEMENTS). This will prevent us from endless looping.s  G       If the relative offset of this entry points back to the listhead,AD       we've finished. Otherwise, scan the list until MAX_ELEMENTS is       reached. */a      addr = addr + aux;i      if (addr != (int) ptr)l    {     elem++;   ,     /* Too many loops? Let the user know. */       if (elem > MAX_ELEMENTS)     {i      sda$extend_print(desc("Listhead Addr: !XL    Size: !4UL    Status: invalid,too many elements"),ptr,cnt*(IOC_C_NPAGGRNMSK+1));  ^      sda$extend_print(desc("    Possible loop detected, after tracing !UL elements!%S"),elem);        break;)     } ;     /* Save previous address and try next entry in list. */   ,     status = sda$extend_trymem(addr,&aux,4);    }        else     {M     /* Pointer to next elements pointe back to listhead, so we've reached the D        end of the list. List the number of elements in this list. */       sda$extend_print(desc("Listhead Addr: !XL    Size: !4UL    Status: valid, !UL element!%S"),ptr,cnt*(IOC_C_NPAGGRNMSK+1),elem);  J     /* Compute the number of bytes allocated by the elements of this list:F        Element size * number of elements. The element size is always a        multiple of 64. */)  0     totbyt += cnt * (IOC_C_NPAGGRNMSK+1) * elem;  
     break;    }   } $   /* Continue with next listhead. */     cnt++;     ptr++;  }  /* Print summary message. */e    sda$extend_skip_lines(1);  [  sda$extend_print(desc("   Total free space:  !XL (hex) !8UL (dec)  bytes"),totbyt,totbyt);  }   	 /******/V    void clue$mem_free(int full_flg) { H  /* This routine processes the MEMORY/FREE [/FULL] command. It validatesD     and displays the non-paged pool freelist (largest and total freeG     space, number of free packets). If /FULL is specified, the first 16b8     bytes of every free packet are displayed as well. */  ,  char typbuf[12];			/* Packet type buffer */  A  unsigned int nonpaged,			/* First free packet in non-pgd pool */ >               auxbuf[4],		/* Buffer to receive next element */) 	      next;			/* Next element pointer */>  '  int cnt = 0,				/* Element counter; */ -      largest = 0,			/* Largest free packet */t)      total = 0;				/* Total free space */c  M  /* -------------------------> WE START HERE <---------------------------- */l  *  /* Define subheader, display new page. */  R  sda$extend_format_subheading(desc("Nonpaged Dynamic Pool - Free Packet Queue:"));    sda$extend_new_page();   (  /* Get address of first free packet. */  1  symbol_value(desc("EXE$GL_NONPAGED"),&nonpaged);!  '  sda$extend_reqmem(nonpaged+4,&next,4);s  =  /* Now loop through free packet list. The end of the list isI:     indicated by a 0 in the pointer to the next packet. */  
  while (next)o  {@   /* To prevent us from endless looping, we stop with scan after)      processing MAX_ELEMENTS elements. */      if (cnt > MAX_ELEMENTS)a   {mO    sda$extend_print(desc("Free Packet Queue, Status: Invalid, possible loop"));e  Y    sda$extend_print(desc("   Possible loop detected, after tracing !UL element!%S"),cnt);;  
    return;   }uF   /* Copy packet into local buffer. If we cant', let the user know. */  /   if (!(sda$extend_trymem(next,auxbuf,16) & 1))    {*U    sda$extend_print(desc("Free Packet Queue, Status: Invalid, memory access error"));S  m    sda$extend_print(desc("   Error in queue linkage at address !XL, after tracing !UL element!%S"),next,cnt);r  4    sda$extend_print(desc("Not in physical memory"));  
    return;   }tE   /* If /FULL was given, display the first 16 bytes of the packet. */d     if (full_flg)n   {m    /* Print empty line. */      sda$extend_skip_lines(1);  F    /* Get type of packet. It is stored in the packet at position 0x0A.K       This means, it can be retrieved from the third longword in byte 3. */o  3    get_typ((auxbuf[2] & 0x00FF0000) >> 16, typbuf);       /* Display the line. */  M    sda$extend_print(desc("!7AZ  !XL:    !XL !XL !XL !XL  !16AF"),typbuf,next,)7 			 auxbuf[3],auxbuf[2],auxbuf[1],auxbuf[0],16,auxbuf);L   } I   /* If the packet size is invalid, let the user know. This is the secondsI      longword in the packet (invalid means either > 80000000 or a patternm*      used for allocation/deallocation). */  C   if (auxbuf[1] == 0x61616161 ||	/* Pool allocation pattern ('a')*/(F       auxbuf[1] == 0x64646464 ||	/* Pool deallocation pattern ('d') */=       auxbuf[1] >= 0x80000000)		/* Address in system space */o   {px    sda$extend_print(desc("Error in packet size (!XL) at address !XL, after tracing !UL element!%S"),auxbuf[1],next,cnt);   }[4   /* Update statistical information. Total bytes: */     total += auxbuf[1];n     /* Largest space: */  /   if (auxbuf[1] > largest) largest = auxbuf[1];g  !   /* Increment element counter */r     cnt++;  #   /* Get next element and retry. */n  "   sda$extend_reqmem(next,&next,4);  }  /* Print final information. */"    sda$extend_skip_lines(1);  P  sda$extend_print(desc("Free Packet Queue, Status: Valid, !UL element!%S"),cnt);    sda$extend_skip_lines(1);  d  sda$extend_print(desc("   Largest free chunk:        !XL (hex)/!8UL (dec) bytes"),largest,largest);  `  sda$extend_print(desc("   Total free dynamic space:  !XL (hex)/!8UL (dec) bytes"),total,total);    /* Well, thats all. */s }>  	 /******/]   void clue$mem_layout() {dA  /* This routine processes the MEMORY/LAYOUT command. It displayssG     the layout of the S0 (system) space (On VAX: 80000000-BFFFFFFF). */_  +  unsigned int val[5],				/* Aux integers */ - 	      vms_v6,				/* 1 if VMS V6 or higher */l( 	      spte[2],				/* for free SPTE's */) 	      page_size,			/* Phys. page size */f+ 	      round_mask,			/* Mask to round up */ / 	      sysend_va,			/* End of system vectors */;) 	      spt_base,				/* Start VA of SPT */d* 	      free_spte;			/* # of free SPTE's */  $  /* Get VMS version, print header */    vms_v6 = chk_vms_v6();   L  sda$extend_format_subheading(desc("System Virtual Address Space Layout:"));    sda$extend_new_page();e  i  sda$extend_print(desc("Item                                                Base      End      Length"));u  B  /* System space starts with global system vectors. If it doesn't,"     print line indicating this. */  2  symbol_value(desc("SYS$S0_VECTOR_BASE"),&val[0]);  }  if (val[0] != 0x80000000) sda$extend_print(desc("!50<Hole in S0 space!>!XL  !XL  !XL"),0x80000000,val[0],val[0]-0x80000000);c  (  /* Get end vector space end address. */  -  symbol_value(desc("MMG$A_SYS_END"),&val[1]);u   &  /* Round up to next page boundary. */  8  symval_and_trymem(desc("MMG$GL_PAGE_SIZE"),&page_size);    round_mask = page_size - 1;    sysend_va = pagrnd(val[1]);  c  sda$extend_print(desc("!50<System vector area!>!XL  !XL  !XL"),val[0],sysend_va,sysend_va-val[0]);!  A  /* Display info about sub-sections in the system vector area. */   "  /* System Service vector area. */  1  symbol_value(desc("SYS$S0_VECTOR_END"),&val[1]);F  7  symbol_value(desc("SYS$S0_VECTOR_LAST_USED"),&val[2]);l  v  sda$extend_print(desc("!50<  System service vectors (last: !XL)!>!XL  !XL  !XL"),val[2],val[0],val[1],val[1]-val[0]);  "  /* Executive transfer vectors. */  /  symbol_value(desc("EXE$VECTOR_BASE"),&val[0]);2  .  symbol_value(desc("EXE$VECTOR_END"),&val[1]);  4  symbol_value(desc("EXE$VECTOR_LAST_USED"),&val[2]);  z  sda$extend_print(desc("!50<  Executive transfer vectors (last: !XL)!>!XL  !XL  !XL"),val[2],val[0],val[1],val[1]-val[0]);    /* Executive Data Area. */n  /  symbol_value(desc("MMG$A_NPAG_DATA"),&val[0]);a  3  symbol_value(desc("MMG$A_NPAG_DATA_END"),&val[1]);   7  symbol_value(desc("EXE$NPAG_DATA_LAST_USED"),&val[2]);*  s  sda$extend_print(desc("!50<  Executive data area (last: !XL)!>!XL  !XL  !XL"),val[2],val[0],val[1],val[1]-val[0]);s    /* System Parameter Area. *//  .  symbol_value(desc("MMG$A_SYSPARAM"),&val[0]);  2  symbol_value(desc("MMG$A_SYSPARAM_END"),&val[1]);  b  sda$extend_print(desc("!50<  System parameter area!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);    /* Boot Parameter Area. */t  .  symbol_value(desc("MMG$A_BOOPARAM"),&val[0]);  2  symbol_value(desc("MMG$A_BOOPARAM_END"),&val[1]);  `  sda$extend_print(desc("!50<  Boot parameter area!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);  $  /* Remaining space in this area. */    val[0] = val[1];   -  symbol_value(desc("MMG$A_SYS_END"),&val[1]);!  b  sda$extend_print(desc("!50<  Miscellaneous vectors!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);  A  /* After the end of the system vector section, a guard null page      follows. */e  N  sda$extend_print(desc("!50<Guard page!>!20<!XL!>!XL"), sysend_va, page_size);  E  /* The loadable image code section is used to map executive code andnC     system images. Its size depends on the system parameter SPTREQ.m  A     If this area is not fully mapped, some SPTE's are unused. TheaB     information which SPTE's are unsed, and how many, is stored in>     the SPTE's theirself. The upper 8 bits of these SPTE's are;     always 0 (no access), so the memory management hardwareoA     will reject any access, when a VA represented by the SPTE is  @     specified. The remaining bits are used in the following way:  A     004xxxxx -> This SPTE is free. xxxxx is the SPT offset to thed4 		next free SPTE or 0, if no more free SPTE's exist.  :     000xxxxx -> xxxxx is the offset to next free SPTE or 0<     000ccccc -> ccccc is the count of subsequent free SPTE's  >     If the upper byte isn't 0, there are no free SPTE's in the     executive image section. */T     /* Get start address of SPT. */  5  symval_and_trymem(desc("MMG$GL_SPTBASE"),&spt_base);n    /* Compute offset into SPT:  0     End_of_vector_region - Base_of_vector_regionA     --------------------------------------------  * Size_of_a_PTEl                       Page_size(  */G  @  val[0] = ((sysend_va - 0x80000000) / page_size) * PTE$S_PTEDEF;    /* Get contents of SPTE. */     val[1] = spt_base + val[0] + 4;  B  if (!(sda$extend_trymem(val[1],spte,PTE$S_PTEDEF*2) & 1)) return;  C  /* If single bit is set in the first SPTE, it indicates one single_E     free SPTE; otherwise, the second SPTE contains the free count. */P  2  free_spte = spte[0] & PTE$M_SINGLE ? 1 : spte[1];  J  /* Free SPTE's exist only, if the upper 8 bits of first SPTE are zero. */    if (!(spte[0] & 0xFF000000))   {!   val[0] = sysend_va + page_size;N  ,   val[1] = val[0] + (free_spte * page_size);  3   symval_and_trymem(desc("SGN$GL_SPTREQ"),&val[2]);e  ~   sda$extend_print(desc("!50<Available SPTEs (!UL, SPTREQ=!UL)!>!XL  !XL  !XL"),free_spte,val[2],val[0],val[1],val[1]-val[0]);  }G  /* The remaining of this area is mapped by various system images. This[-     area ends at offset SMP$GL_PFORK_POOL. */s    val[0] = val[1];,  6  symval_and_trymem(desc("SMP$GL_PFORK_POOL"),&val[1]);  j  sda$extend_print(desc("!50<Executive image code and region!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);  9  /* Display location of some data within this area. Startr     with system image .*/t  2  symval_and_trymem(desc("EXE$GL_SYSMSG"),&val[0]);    /* Find size of this image. */      mem_lay_getsiz(val[0],&val[1]);    val[1] *= page_size;m  \  sda$extend_print(desc("!50<  System messages!>!XL  !XL  !XL"),val[0],val[0]+val[1],val[1]);    /* RMS image. */"  3  symval_and_trymem(desc("MMG$GL_RMSBASE"),&val[0]);      mem_lay_getsiz(val[0],&val[1]);    val[1] *= page_size;   U  sda$extend_print(desc("!50<  RMS code!>!XL  !XL  !XL"),val[0],val[0]+val[1],val[1]);(    /* Lock ID Table. */   D  symval_and_trymem(desc("LCK$GL_IDTBL"),&val[0]);	/* Base address */  G  symval_and_trymem(desc("LCK$GL_IDTBLMAX"),&val[1]);	/* Maximum size */,  E  symval_and_trymem(desc("LCK$GL_LCKCNT"),&val[2]);	/* Current size */p  G  symval_and_trymem(desc("LCK$GL_IDTBLSIZ"),&val[3]);	/* Initial size */s    /* Round up size. */l    val[4] = pagrnd(val[1]*4);"    sda$extend_print(desc("!50<  Lock ID table (ini/cur/max: !UL/!UL/!UL)!>!XL  !XL  !XL"),val[3],val[2],val[1],val[0],val[0]+val[4],val[4]);  $  /* VAXcluster cache data buffer. */  6  symval_and_trymem(desc("CACHE$AR_VCC_DATA"),&val[0]);  @  /* On non-clustered systems, this is 0; so don't display it. */  i  if (val[0]) sda$extend_print(desc("!50<  VAXcluster cache data buffer!>!20<!XL!>!XL"),val[0],page_size);X  H  /* The range of the following items is slightly different on V5 and V6:          V5         				V6.F     ------------------------------------------------------------------3     CPU type table			Tape mount verification buffero$     LMF group table			CPU type table"     Dumpfile map			LMF group table6     Executive mode data page		Executive mode data page6     SWAPPER page table			Erase pattern page table page.     Erase pattern page table page	Dumpfile map&     (Other items)			SWAPPER page table0     Tape mount verification buffer	(Other items)  K     Depending on the VMS version, we'll display it in the right order. */  	    if (vms_v6)  {7   symval_and_trymem(desc("EXE$GL_TMV_SVABUF"),&val[0]);   x   sda$extend_print(desc("!50<  Tape mount verification buffer!>!XL  !XL  !XL"),val[0],val[0]+(page_size*2),page_size*2);  '   /* Table of CPU numbers and names. */u  '   symbol_value(desc("CPULOA"),&val[0]);6  B   /* This symbol holds to the base of the CPULOA image. This imageC      contains tables holding all hardware types and hardware names.fJ      The first longword contains the number of entries in these tables. */  &   sda$extend_reqmem(val[0],&val[2],4);  !   /* Get size of CPULOA image. */o  !   mem_lay_getsiz(val[0],&val[1]);-     val[1] *= page_size;  x   sda$extend_print(desc("!50<  CPULOA HW name tables (!UW entries)!>!XL  !XL  !XL"),val[2],val[0],val[0]+val[1],val[1]);     /* LMF group table. */  5   symval_and_trymem(desc("LMF$AR_GROUPTBL"),&val[0]);l  G   /* This cell points to the first group table entry which is at offset;F      4 (the first longword contains the # of entries in the table). ByE      subtracting 4 from this value, we get base address of this imagee(      and can obtain the # of entries. */     val[0] -= 4;  &   /* Get size of group table image. */  !   mem_lay_getsiz(val[0],&val[1]);u     val[1] *= page_size;     /* Get # of entries. */(  &   sda$extend_reqmem(val[0],&val[2],4);  fv   sda$extend_print(desc("!50<  LMF group table (!UW entries)!>!XL  !XL  !XL"),val[2]>>16,val[0],val[0]+val[1],val[1]);  !   /* Executive mode data page. */X  3   symval_and_trymem(desc("EXE$AR_EWDATA"),&val[0]);e  Z   sda$extend_print(desc("!50<  Executive mode data page!>!20<!XL!>!XL"),val[0],page_size);   &   /* Erase pattern page table page. */  5   symval_and_trymem(desc("EXE$GL_ERASEPPT"),&val[0]);e  _   sda$extend_print(desc("!50<  Erase pattern page table page!>!20<!XL!>!XL"),val[0],page_size);l  I   /* Dump file memory mapping. This area starts at EXE$AR_DUMP_PTES. ThiseF      cell, however, contains the VA of the base PTE, not the VA of theF      area. So, based on the start address of the system page table, we"      can compute corresponding VA:  0 	(EXE$AR_DUMP_PTES - MMG$GL_SPTBASE) * PAGE_SIZE> 	----------------------------------------------- + VA$M_SYSTEM(                             PTE$S_PTEDEF   */  G   symval_and_trymem(desc("EXE$AR_DUMP_PTES"),&val[2]);	/* Get PTE VA */e  D   /* The lower 2 bits may be set and may have special meaning in theA      PTE address. However, PTE's are always addressed at longwordv+      boundaries, so we'll mask them out. */r     val[2] &= 0xFFFFFFFC;_  :   val[0] = (val[2] - spt_base) * page_size / PTE$S_PTEDEF;     val[0] += VA$M_SYSTEM;  2   /* The size of this area is always 128 pages. */     val[1] = 128 * page_size;c  k   sda$extend_print(desc("!50<  Dumpfile Write Memory Mapping!>!XL  !XL  !XL"),val[0],val[0]+val[1],val[1]);i  6   /* Swapper page table. Its size is determined by the>      system parameter WSMAX. SWP$GL_MAP points to cell holding       the table start address. */  0   symval_and_trymem(desc("SWP$GL_MAP"),&val[2]);  "   sda$extend_reqmem(val[2],val,4);  g5   symval_and_trymem(desc("SGN$GL_MAXWSCNT"),&val[2]);l  5   val[1] = val[2] * PTE$S_PTEDEF;	/* Size of a PTE */a  s   sda$extend_print(desc("!50<  SWAPPER page table (WSMAX=!UL)!>!XL  !XL  !XL"),val[2],val[0],val[0]+val[1],val[1]);h  }  elseE  {	/* Items in V5 sequence */o'   /* Table of CPU numbers and names. */   '   symbol_value(desc("CPULOA"),&val[0]);l  B   /* This symbol holds to the base of the CPULOA image. This imageC      contains tables holding all hardware types and hardware names.dJ      The first longword contains the number of entries in these tables. */  &   sda$extend_reqmem(val[0],&val[2],4);  !   /* Get size of CPULOA image. */   !   mem_lay_getsiz(val[0],&val[1]);?     val[1] *= page_size;  x   sda$extend_print(desc("!50<  CPULOA HW name tables (!UW entries)!>!XL  !XL  !XL"),val[2],val[0],val[0]+val[1],val[1]);     /* LMF group table. */  5   symval_and_trymem(desc("LMF$AR_GROUPTBL"),&val[0]);b  G   /* This cell points to the first group table entry which is at offset F      4 (the first longword contains the # of entries in the table). ByE      subtracting 4 from this value, we get base address of this image (      and can obtain the # of entries. */     val[0] -= 4;  &   /* Get size of group table image. */  !   mem_lay_getsiz(val[0],&val[1]);i     val[1] *= page_size;     /* Get # of entries. */   &   sda$extend_reqmem(val[0],&val[2],4);  Sv   sda$extend_print(desc("!50<  LMF group table (!UW entries)!>!XL  !XL  !XL"),val[2]>>16,val[0],val[0]+val[1],val[1]);  I   /* Dump file memory mapping. This area starts at EXE$AR_DUMP_PTES. ThismF      cell, however, contains the VA of the base PTE, not the VA of theF      area. So, based on the start address of the system page table, we"      can compute corresponding VA:  0 	(EXE$AR_DUMP_PTES - MMG$GL_SPTBASE) * PAGE_SIZE> 	----------------------------------------------- + VA$M_SYSTEM(                             PTE$S_PTEDEF   */  G   symval_and_trymem(desc("EXE$AR_DUMP_PTES"),&val[2]);	/* Get PTE VA */R  D   /* The lower 2 bits may be set and may have special meaning in theA      PTE address. However, PTE's are always addressed at longword +      boundaries, so we'll mask them out. */e     val[2] &= 0xFFFFFFFC;d  :   val[0] = (val[2] - spt_base) * page_size / PTE$S_PTEDEF;     val[0] += VA$M_SYSTEM;  2   /* The size of this area is always 128 pages. */     val[1] = 128 * page_size;   k   sda$extend_print(desc("!50<  Dumpfile Write Memory Mapping!>!XL  !XL  !XL"),val[0],val[0]+val[1],val[1]);*  6   /* Swapper page table. Its size is determined by the>      system parameter WSMAX. SWP$GL_MAP points to cell holding       the table start address. */  0   symval_and_trymem(desc("SWP$GL_MAP"),&val[2]);  "   sda$extend_reqmem(val[2],val,4);  e5   symval_and_trymem(desc("SGN$GL_MAXWSCNT"),&val[2]);)  5   val[1] = val[2] * PTE$S_PTEDEF;	/* Size of a PTE */t  s   sda$extend_print(desc("!50<  SWAPPER page table (WSMAX=!UL)!>!XL  !XL  !XL"),val[2],val[0],val[0]+val[1],val[1]);/  &   /* Erase pattern page table page. */  5   symval_and_trymem(desc("EXE$GL_ERASEPPT"),&val[0]);o  _   sda$extend_print(desc("!50<  Erase pattern page table page!>!20<!XL!>!XL"),val[0],page_size);c  }  /* Temporary CPU page. */  4  symval_and_trymem(desc("EXE$GL_CPUNODSP"),&val[0]);  S  sda$extend_print(desc("!50<  Temporary CPU page!>!20<!XL!>!XL"),val[0],page_size);     /* Error log buffers. */s  H  symval_and_trymem(desc("EXE$AL_ERLBUFADR"),&val[0]);	/* Base address */  H  symval_and_trymem(desc("SGN$GW_ERLBUFCNT"),&val[1]);	/* # of buffers */  N  symval_and_trymem(desc("EXE$GB_ERLBUFPAGES"),&val[2]);	/* Pages per buffer */     J  /* Compute entire buffer size: buffers * pages_per_buffer * page_size. */  &  val[3] = val[1] * val[2] * page_size;    sda$extend_print (desc("!50<  Error log buffers (!UL, !UL page!%S/buffer)!>!XL  !XL  !XL"),val[1],val[2],val[0],val[0]+val[3],val[3]);F  -  /* Page to map pages not in PFN database. */p  =  symval_and_trymem(desc("MMG$GL_FREE_NO_PFN_DB_VA"),&val[0]);   f  sda$extend_print(desc("!50<  Page to map pages not in PFN database!>!20<!XL!>!XL"),val[0],page_size);  !  /* Erase pattern buffer page. */   3  symval_and_trymem(desc("EXE$GL_ERASEPB"),&val[0]);u  Z  sda$extend_print(desc("!50<  Erase pattern buffer page!>!20<!XL!>!XL"),val[0],page_size);    /* DZRO optimization page. */  3  symval_and_trymem(desc("MMG$GL_DZRO_VA"),&val[0]);1  ^  sda$extend_print(desc("!50<  Demand-zero optimization page!>!20<!XL!>!XL"),val[0],page_size);  F  /* Mount verification buffer. The location EXE$GL_SVAPTE contains theF     address of the buffer's PTE, not of the buffer, so we must compute@     the address (see the dumpfile memory mapping line above). */  C  symval_and_trymem(desc("EXE$GL_SVAPTE"),&val[2]);	/* Get PTE VA */b  C  /* The lower 2 bits may be set and may have special meaning in then@     PTE address. However, PTE's are always addressed at longword*     boundaries, so we'll mask them out. */    val[2] &= 0xFFFFFFFC;  9  val[0] = (val[2] - spt_base) * page_size / PTE$S_PTEDEF;     val[0] += VA$M_SYSTEM;   Z  sda$extend_print(desc("!50<  Mount verification buffer!>!20<!XL!>!XL"),val[0],page_size);  A  /* On V5 systems, the tape mount verification buffer follows. */t  
  if (!vms_v6)/  {7   symval_and_trymem(desc("EXE$GL_TMV_SVABUF"),&val[0]);   x   sda$extend_print(desc("!50<  Tape mount verification buffer!>!XL  !XL  !XL"),val[0],val[0]+(page_size*2),page_size*2);  }"  /* System message vector page. */  2  symval_and_trymem(desc("EXE$GL_MSGVEC"),&val[0]);  G  /* On V5 systems, this page doesn't exist, so the returned value is 0.)7     Don't display this information on these systems. */     if (val[0])  {\   sda$extend_print(desc("!50<  System message vector page!>!20<!XL!>!XL"),val[0],page_size);  }E  /* Well, that's all in this area. Continue with higher system space.s4     This is pfork() pool and window to I/O space. */  6  symval_and_trymem(desc("SMP$GL_PFORK_POOL"),&val[0]);  /  symval_and_trymem(desc("EXE$GL_RPB"),&val[1]);g  p  sda$extend_print(desc("!50<Pool for pfork() and I/O space window!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);    /* Restart parameter block. */   V  sda$extend_print(desc("!50<Restart parameter block!>!20<!XL!>!XL"),val[1],page_size);  ?  /* Pageframe database. The cell MMG$GL_MAXPFN contains the PFNVB     of the highest page frame in the page frame database (the lastB     index). To compute the size of the pageframe database, we must@     multiply this value with the size of an entry in the variousA     PFN arrays. Depending on the value of MMG$GW_BIGPFN, this areh9     either 18/20 bytes (MMG$GW_BIGPFN = 0) or 22/24 bytes;B     (MMG$GW_BIGPFN = 1). MMG$GW_BIGPFN is set to 1 on systems with@     more than 32MB memory (more than 65536 physical pages) whereA     the 'next' and 'back' link arrays must be longword instead of$
     words. */l    /* Are we using big PFN's ? */g  2  symval_and_trymem(desc("MMG$GW_BIGPFN"),&val[0]);    val[0] &= 0xFFFF;    /* Get max PFN. */z  2  symval_and_trymem(desc("MMG$GL_MAXPFN"),&val[1]);  D  /* Compute size. For VMS V5, the size is 18/22 bytes/PFN entry; for,     VMS V6 and higher, it is 20/24 bytes. */  ?  if (vms_v6) val[2] = val[1] * (val[0] ? 0x18 : 0x14);	/* V6 */o  8  else val[2] = val[1] * (val[0] ? 0x16 : 0x12);	/* V5 */  )  /* Round to up to next page boundary. */T    val[3] = pagrnd(val[2]);t  G  /* Get start address and compute end address of pageframe database. */a  /  symval_and_trymem(desc("PFN$A_BASE"),&val[0]);     val[4] = val[0] + val[3]; _  u  sda$extend_print(desc("!50<Page frame database (Max. PFN: !UL)!>!XL  !XL  !XL"),val[1],val[0],val[4],val[4]-val[0]);T  %  /* Display info about paged pool. */r  M  symval_and_trymem(desc("SGN$GL_PAGEDYN"),&val[2]);  /* Pool size in bytes */l  H  symval_and_trymem(desc("MMG$GL_PAGEDYN"),&val[0]);  /* Start address */    val[1] = val[0] + val[2];  ~  sda$extend_print(desc("!50<Paged pool (!UL kB, PAGEDYN=!UL)!>!XL  !XL  !XL"),val[2]/1024,val[2],val[0],val[1],val[1]-val[0]);  )  /* Display info about non-paged pool. */l  N  symval_and_trymem(desc("SGN$GL_NPAGEDYN"),&val[2]);  /* Pool size in bytes */  I  symval_and_trymem(desc("MMG$GL_NPAGEDYN"),&val[0]);  /* Start address */_    val[1] = val[0] + val[2];    sda$extend_print(desc("!50<Non-paged pool (!UL kB, NPAGEDYN=!UL)!>!XL  !XL  !XL"),val[2]/1024,val[2],val[0],val[1],val[1]-val[0]);r  e%  /* Non-paged pool expansion area. */P  O  symval_and_trymem(desc("SGN$GL_NPAGEVIR"),&val[3]);  /* Total size in bytes */n  O  symval_and_trymem(desc("MMG$GL_NPAGNEXT"),&val[1]);  /* Total size in bytes */]  E  if (val[0] + val[2] == val[1])		/* Expansion area already in use? */o  {
   /* No */     sda$extend_print(desc("!50<Non-pgd expansion area (!UL kBytes, unmapped)!>!XL  !XL  !XL"),(val[3]-val[2])/1024,val[0]+val[2],val[0]+val[3],val[3]-val[2]);  }  elsec  {   /* Yes */l     sda$extend_print(desc("!50<Exp. area (!UL kBytes, mapped EVA: !XL)!>!XL  !XL  !XL"),(val[3]-val[2])/1024,val[1],val[0]+val[2],val[0]+val[3],val[3]-val[2]);e  }J  /* LRP, IPR and SRP lookaside lists. These lists exist one pre-V6 systemsG     only. On V6 and later, the lists were reorganized and may be viewed )     with the MEMORY/LOOKASIDE command. */d  
  if (!vms_v6)s  {5   symval_and_trymem(desc("IOC$GL_LRPSPLIT"),&val[0]);h  6   if (val[0])	/* If zero, these lists do not exist. */   {e6    mem_lay_look("IOC$GL_LRPSPLIT","LRP",LRP_MAX_SIZE);  6    mem_lay_look("EXE$GL_SPLITADR","IRP",IRP_FIX_SIZE);  5    symval_and_trymem(desc("SGN$GL_SRPSIZE"),&val[0]);S  0    mem_lay_look("IOC$GL_SRPSPLIT","SRP",val[0]);   }   }'  /* Per CPU Database and boot stack. */   4  symval_and_trymem(desc("SMP$GL_CPU_DATA"),&val[0]);  D  symval_and_trymem(desc("EXE$GL_INTSTKLM"),&val[1]);	/* Upper end */  j  sda$extend_print(desc("!50<Per-CPU database and boot stack!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);    /* Interrupt Stack. */_    val[0] = val[1];G  B  symval_and_trymem(desc("EXE$GL_INTSTK"),&val[1]);	/* Upper end */    sda$extend_print(desc("!50<Interrupt stack (INTSTKPAGES=!UW)!>!XL  !XL  !XL"),(val[1]-val[0])/page_size,val[0],val[1],val[1]-val[0]);   E  /* System control block. If there are guard pages beetween interrupt;2     stack and system control block, display it. */  /  symval_and_trymem(desc("EXE$GL_SCB"),&val[2]);,  *  if (val[2] != val[1])		/* Guard pages? */  {   /* Yes, display it. */  v  sda$extend_print(desc("!50<!UW guard page!%S!>!XL  !XL  !XL"),(val[2]-val[1])/page_size,val[1],val[2],val[2]-val[1]);  }  val[0] = val[2];   E  symval_and_trymem(desc("SWP$GL_BALBASE"),&val[1]);	/* Upper limit */T  3  mfpr(PR$_SCBB,&val[2]);	/* Get physical address */     sda$extend_print(desc("!50<System control block (!UL page!%S, PA: !XL)!>!XL  !XL  !XL"),(val[1]-val[0])/page_size,val[2],val[0],val[1],val[1]-val[0]);i    /* Balance slots. */T    val[0] = val[1];>  M  symval_and_trymem(desc("SGN$GL_BALSETCT"),&val[1]);	/* # of balance slots */n  L  symval_and_trymem(desc("SWP$GL_BSLOTSZ"),&val[2]);	/* # of balance slots */  @  val[3] = val[1] * val[2] * page_size;			/* Size of all slots */  /  val[4] = val[0] + val[3];				/* End address */n    sda$extend_print(desc("!50<Balance slots (BALSETCNT=!UW, !UW pages/slot)!>!XL  !XL  !XL"),val[1],val[2],val[0],val[4],val[4]-val[0]);    /* System header. */   E  symval_and_trymem(desc("MMG$GL_SYSPHD"),&val[0]);	/* Base address */]  @  symval_and_trymem(desc("MMG$GL_SYSPHDLN"),&val[1]);	/*  Size */  X  sda$extend_print(desc("!50<System header!>!XL  !XL  !XL"),val[0],val[0]+val[1],val[1]);    /* System page table. */a  *  val[0] = spt_base;					/* Base address */  >  symval_and_trymem(desc("MMG$GL_SPTLEN"),&val[1]);	/*  Size */     val[2] = val[1] * PTE$S_PTEDEF;    val[3] = val[0] + val[2];  D  symval_and_trymem(desc("MMG$GL_SBR"),&val[4]);		/* Phys. address */  ~  sda$extend_print(desc("!50<System page table (!UL PTEs, PA: !XL)!>!XL  !XL  !XL"),val[1],val[4],val[0],val[3],val[3]-val[0]);    /* Global page table. */,  C  symval_and_trymem(desc("MMG$GL_GPTE"),&val[0]);	/* Base address */*  E  symval_and_trymem(desc("MMG$GL_MAXGPTE"),&val[1]);	/* End address */e  C  symval_and_trymem(desc("SGN$GL_MAXGPGCT"),&val[2]);	/* GBLPAGES */e  r  sda$extend_print(desc("!50<Global page table (GBLPAGES=!UL)!>!XL  !XL  !XL"),val[2],val[0],val[1],val[1]-val[0]);     /* Unused region, up to end. */    val[0] = val[1];   K  symval_and_trymem(desc("MMG$GL_MAXSYSVA"),&val[1]);	/* End of S0 region */s    val[2] = val[1] - val[0];  ak  sda$extend_print(desc("!50<Reserved (!UW page!%S)!>!XL  !XL  !XL"),val[2]/page_size,val[0],val[1],val[2]);e  I  sda$extend_print(desc("!60<High end of S0 (system) space!>!XL"),val[1]);a    /* That's all. */ }   	 /******/    void mem_stat_mscp(int addr) {-E  /* This routine is called by MEMORY/STATISTICS to print MSCP-relatedi     information. */M  .  unsigned int val[2];			/* Used for display */  1  struct __DSRV t;			/* DSRV (MSCP server) data */t    /* Copy MSCP related data. */  *  sda$extend_reqmem(addr,&t,DSRV$K_LENGTH);    /* MSCP Operation count. */  ,  sda$extend_print(desc("MSCP Statistics:"));  %  /* Failure count and total I/O's. */t  x  sda$extend_print(desc("Count of VC Failures     !10UL!30<     Total IOs!>!10UL"),t.DSRV$L_VCFAIL_CNT,t.DSRV$L_OPCOUNT);  $  /* Server hosts and split I/O's. */  x  sda$extend_print(desc("Count of Hosts Served    !10UL!30<     Split IOs!>!10UL"),t.DSRV$W_NUM_HOST,t.DSRV$L_SPLITXFER);  #  /* Server disks and wait I/O's. */a    sda$extend_print(desc("Count of Disks Served    !10UL     IOs that had to Wait (Buf) !8UL"),t.DSRV$W_NUM_UNIT,t.DSRV$L_MEMW_TOT);  9  /* MSCP_BUFFER SYSGEN parameter and MemWait requests. */   7  symval_and_trymem(desc("CLU$GL_MSCP_BUFFER"),&val[0]);s  v  sda$extend_print(desc("MSCP_BUFFER (SYSGEN)     !10UL     Requests in MemWait Queue!10UL"),val[0],t.DSRV$W_MEMW_CNT);  >  /* MSCP_CREDITS SYSGEN parameter and max MemWait requests. */  8  symval_and_trymem(desc("CLU$GL_MSCP_CREDITS"),&val[0]);  v  sda$extend_print(desc("MSCP_CREDITS (SYSGEN)    !10UL     Max Req ever in MemWait  !10UL"),val[0],t.DSRV$W_MEMW_MAX);    return; }p  	 /******/f   void mem_stat_cache(int addr)t {fC  /* This routine displays information about various file caches. */l  2  unsigned int val[5];				/* To display on Alpha */    struct XXXi  {6   struct __EW_PMS t;				/* Exec-writeable page data */<   short EW_RMS$GW_GBLBUFQUO;			/* RMS global buffer count */  } u;z  *  /* Copy data from exec writeable page. */  *  sda$extend_reqmem(addr,&u,EW$K_LENGTH+2);  A  /* Display information about caches: Cache name, value of SYSGENpJ     parameter, number of hits, number of misses and hitrate in percent. */  %  /* Start with file header cache.. */   4  symval_and_trymem(desc("ACP$GW_HDRCACHE"),&val[0]);    val[0] &= 0xFFFF;  (#  val[1] = u.t.EW_PMS$GL_FILHDR_HIT;!  $  val[2] = u.t.EW_PMS$GL_FILHDR_MISS;  (  percent(val[1],val[2],&val[3],&val[4]);    sda$extend_print(desc("File Header Cache     (ACP_HDRCACHE  =!4UL)  !10UL  !10UL  !3UL.!1UL%"),val[0],val[1],val[2],val[3],val[4]);    /* Storage bitmap cache. */  4  symval_and_trymem(desc("ACP$GW_MAPCACHE"),&val[0]);    val[0] &= 0xFFFF;  t&  val[1] = u.t.EW_PMS$GL_STORAGMAP_HIT;  '  val[2] = u.t.EW_PMS$GL_STORAGMAP_MISS;d  (  percent(val[1],val[2],&val[3],&val[4]);    sda$extend_print(desc("Storage Bitmap Cache  (ACP_MAPCACHE  =!4UL)  !10UL  !10UL  !3UL.!1UL%"),val[0],val[1],val[2],val[3],val[4]);    /* Directory data cache. */  4  symval_and_trymem(desc("ACP$GW_DIRCACHE"),&val[0]);    val[0] &= 0xFFFF;  /$  val[1] = u.t.EW_PMS$GL_DIRDATA_HIT;  %  val[2] = u.t.EW_PMS$GL_DIRDATA_MISS;n  (  percent(val[1],val[2],&val[3],&val[4]);    sda$extend_print(desc("Directory Data Cache  (ACP_DIRCACHE  =!4UL)  !10UL  !10UL  !3UL.!1UL%"),val[0],val[1],val[2],val[3],val[4]);    /* Directory index cache. */   6  symval_and_trymem(desc("ACP$GW_DINDXCACHE"),&val[0]);    val[0] &= 0xFFFF;     val[1] = u.t.EW_PMS$GL_DIRHIT;      val[2] = u.t.EW_PMS$GL_DIRMISS;  (  percent(val[1],val[2],&val[3],&val[4]);    sda$extend_print(desc("Directory LRU         (ACP_DINDXCACHE=!4UL)  !10UL  !10UL  !3UL.!1UL%"),val[0],val[1],val[2],val[3],val[4]);    /* File ID Cache. */b  4  symval_and_trymem(desc("ACP$GW_FIDCACHE"),&val[0]);    val[0] &= 0xFFFF;  $  val[1] = u.t.EW_PMS$GL_FIDHIT;      val[2] = u.t.EW_PMS$GL_FIDMISS;  (  percent(val[1],val[2],&val[3],&val[4]);    sda$extend_print(desc("FID Cache             (ACP_FIDCACHE  =!4UL)  !10UL  !10UL  !3UL.!1UL%"),val[0],val[1],val[2],val[3],val[4]);    /* File extent cache. */   4  symval_and_trymem(desc("ACP$GW_EXTCACHE"),&val[0]);    val[0] &= 0xFFFF;  b  val[1] = u.t.EW_PMS$GL_EXTHIT;l     val[2] = u.t.EW_PMS$GL_EXTMISS;  (  percent(val[1],val[2],&val[3],&val[4]);    sda$extend_print(desc("Extent Cache          (ACP_EXTCACHE  =!4UL)  !10UL  !10UL  !3UL.!1UL%"),val[0],val[1],val[2],val[3],val[4]);    /* Disk quota cache. */  4  symval_and_trymem(desc("ACP$GW_QUOCACHE"),&val[0]);    val[0] &= 0xFFFF;  v  val[1] = u.t.EW_PMS$GL_QUOHIT;;     val[2] = u.t.EW_PMS$GL_QUOMISS;  F  /* If disk quotas aren't used, these cells contain 0. We display this%     line only for non-zero values. */     if (val[1] && val[2])  {)   percent(val[1],val[2],&val[3],&val[4]);      sda$extend_print(desc("Quota Cache           (ACP_QUOCACHE  =!4UL)  !10UL  !10UL  !3UL.!1UL%"),val[0],val[1],val[2],val[3],val[4]);   }    sda$extend_skip_lines(1);  ;  /* Print system-wide information about volumes as well. */f  %  /* Volume locks and window turns. */t  }  sda$extend_print(desc("!25<Volume Synch Locks!>!10UL!30<     Window Turns!>!10UL"),u.t.EW_PMS$GL_VOLLCK,u.t.EW_PMS$GL_TURN);   5  /* Volume locks wait and files open on this node. */i    sda$extend_print(desc("Volume Synch Locks Wait  !10UL!30<     Currently Open Files!>!10UL"),u.t.EW_PMS$GL_VOLWAIT,u.t.EW_PMS$GL_OPEN);i  9  /* Directory and file locks and total $OPEN's issued. */     sda$extend_print(desc("Dir/File Synch Locks     !10UL!30<     Total Count of OPENs!>!10UL"),u.t.EW_PMS$GL_SYNCHLCK,u.t.EW_PMS$GL_OPENS);c  ?  /* Directory and file locks wait and ERASE QIO's performed. */E    sda$extend_print(desc("Dir/file Synch Locks Wait!10UL     Total Count of ERASE QIOs!10UL"),u.t.EW_PMS$GL_SYNCHWAIT,u.t.EW_PMS$GL_ERASEIO);X    /* Access locks. */  H  sda$extend_print(desc("!25<Access Locks!>!10UL"),u.t.EW_PMS$GL_ACCLCK);    /* Free space cache waits. */  U  sda$extend_print(desc("Free Space Cache Wait    !10UL"),u.t.EW_PMS$GL_XQPCACHEWAIT);u    sda$extend_skip_lines(1);  =  /* RMS Global buffer quota and limit. Note the RMS_GBLBUFQUO;>     parameter doesn't exist on VMS V7, so we'll receive 0 from:     symval_and_trymem. If so, do not display this line. */  5  symval_and_trymem(desc("SYS$GW_GBLBUFQUO"),&val[1]);X    val[1] &= 0xFFFF;  )  val[0] = u.EW_RMS$GW_GBLBUFQUO + val[1];a  &  /* Parameter exists? Display line. */    if (val[1])  m  sda$extend_print(desc("RMS GblBufQuo Remaining  !10UL     RMS_GBLBUFQUO (SYSGEN)      !7UL"),val[0],val[1]);P  (  /* Global page file quota and limit. */  5  symval_and_trymem(desc("MMG$GL_GBLPAGFIL"),&val[0]);v  5  symval_and_trymem(desc("SGN$GL_GBLPAGFIL"),&val[1]);a  m  sda$extend_print(desc("Global Pagefile Quota    !10UL     GBLPAGFIL (SYSGEN) Limit    !7UL"),val[0],val[1]);a    /* OK, done. */ }E  	 /******/p  3 void percent(int val2,int val3,int* ret1,int* ret2)E {ED  /* This routine performs a floating-point division and converts theC     result to percent. It returns two integer values, the result of A     the division, and the remainder. This is required since there =     are no floating-point FAO directives; we must display the)(     floating-point result as !UL.!UL. */  !  int dividend[2] = {0,0},divisor;E    *ret1 = *ret2 = 0;0  	  dividend[0] = val2 * 100;    divisor = val2 + val3;R  '  lib$ediv(&divisor,dividend,ret1,ret2);s     *ret2 = (*ret2 * 10) / divisor; }E  	 /******/	  ( int getbit(unsigned char *array,int cnt) {e>  /* Given the base address of a bit map and a bit number, this=     routine returns 1 if the corresponding bit i set, else it!     returns 0. */e    /* Locate involved byte. */  &  unsigned char *ptr = array + (cnt/8);  <  /* If all bits in this byte are set or cleared, we can skip     the mask operations. */(    if (*ptr == 0xFF) return 1;    if (*ptr == 0) return 0;e  
  cnt &= 7;  7  /* Otherwise, depending on the bit offset in the byte,g     return result. */a  
  switch (cnt).  {3   case 0: if (*ptr & 0x01) return 1; else return 0;)3   case 1: if (*ptr & 0x02) return 1; else return 0;f3   case 2: if (*ptr & 0x04) return 1; else return 0;O3   case 3: if (*ptr & 0x08) return 1; else return 0;G3   case 4: if (*ptr & 0x10) return 1; else return 0;53   case 5: if (*ptr & 0x20) return 1; else return 0;[3   case 6: if (*ptr & 0x40) return 1; else return 0;l3   case 7: if (*ptr & 0x80) return 1; else return 0;e  } }'  	 /******/    void mem_files_ref (int index) {hL  /* This routine is called as part of MEMORY/FILES, when the /FULL qualifierJ     is specified. For the given pagefile ('index' argument), all processesH     currently have assignments (blocks reserved or used) to the file areL     displayed. Note: only pagefiles may have pre-reserved blocks, the blocksB     in swapfiles are not reserved until they are actually used. */  *  unsigned char *a_ptr;			/* Aux pointer */  (  int maxprc, 				/* Maximum processes */'      cnt = 0, 				/* Process counter */a8      i = 0, 				/* Per-process pagefile index counter */2      first = 1;				/* Flag to print header line */  6  unsigned int *curpcb, 			/* Pointer to current PCB */3               *nullpcb,			/* Pointer to NULL PCB */i5               *pcbvec, 			/* Pointer to PCB vector */p" 	      *i_ptr;			/* Aux pointer */  4  struct __PCB p;			/* PCB (process control block) */  -  struct __PHD h;			/* PHD (process header) */e  M  /* -------------------------> WE START HERE <---------------------------- */h  0  /* Get address of PCB array and of NULL PCB. */  2  symval_and_trymem(desc("SCH$GL_PCBVEC"),&pcbvec);  4  symval_and_trymem(desc("SCH$AR_NULLPCB"),&nullpcb);    /* Get maximum processes. */t  4  symval_and_trymem(desc("SGN$GW_MAXPRCCT"),&maxprc);  "  /* This is a word, so mask it. */    maxprc &= 0xFFFF;  F  /* Scan every process. See whether it has an assignment (occupies one/     or more pages) from the given page file. */n    while (cnt != maxprc)  {# /* Get next PCB from PCB vector. */a  ,   sda$extend_reqmem(&pcbvec[cnt],&curpcb,4);  E   if (curpcb == nullpcb)	/* If NULL PCB: unused PCB slot, try next */r   {a	    cnt++;       continue;   }n   /* Copy PCB. */   ,   sda$extend_reqmem(curpcb,&p,PCB$K_LENGTH);  @   /* If no PHD, process is currently outswapped, so try next. */     if (!p.PCB$L_PHD)t   {t	    cnt++;i      continue;   }r   /* Get PHD. */    F1   sda$extend_reqmem(p.PCB$L_PHD,&h,PHD$K_LENGTH);t  C   /* Scan the process-private pagefile vector. If index no. matches *      with given index, print info line. */     a_ptr = &h.PHD$B_PRCPGFL;t     i_ptr = &h.PHD$L_PRCPGFLREFS;y  $   for (i=0; i != PHD$S_PRCPGFL; i++)   {     if (*a_ptr == index)o    {8     /* For the first time, print header line as well. */       if (first)     {dI      sda$extend_print(desc("PID        Process Name      Idx   Refcnt"));z        first = 0;m     }(q     sda$extend_print(desc("!XL   !15AC    !UB    !UL"),p.PCB$L_EPID,p.PCB$T_LNAME,i,(1<<PTE$S_PGFLVBN) - *i_ptr);h    }    a_ptr++, i_ptr++;   }i   /* Try next process. */*     cnt++;  }  /* Well, that's all. */ }a	 /******/1  - void get_typ(unsigned char typ, char *retbuf)  {uE  /* Given a VMS dynamic structure type code (DYN$C_xxx), this routinet;     returns the corresponding type name string in 'retbuf'.a  D     On Alpha, there is a routine named SDA$EXTEND_GET_DYN_INFO. ThisB     routine returns pointers to internal SDA tables containing allA     structure names. You may further obtain the structure name by 3     using the type code as index into these tables.n  F     This routine, however, is not available on VAX, so we will provideG     our own routine here. We will return only type names here, subtypes N     are not returned due the limitation of the string name field (7 chars). */  
  switch (typ)!  {4   case DYN$C_ADP:    {strcpy(retbuf,"ADP"); return;}4   case DYN$C_ACB:    {strcpy(retbuf,"ACB"); return;}4   case DYN$C_AQB:    {strcpy(retbuf,"AQB"); return;}4   case DYN$C_CEB:    {strcpy(retbuf,"CEB"); return;}4   case DYN$C_CRB:    {strcpy(retbuf,"CRB"); return;}4   case DYN$C_DDB:    {strcpy(retbuf,"DDB"); return;}4   case DYN$C_FCB:    {strcpy(retbuf,"FCB"); return;}4   case DYN$C_FRK:    {strcpy(retbuf,"FRK"); return;}4   case DYN$C_IDB:    {strcpy(retbuf,"IDB"); return;}4   case DYN$C_IRP:    {strcpy(retbuf,"IRP"); return;}4   case DYN$C_LOG:    {strcpy(retbuf,"LOG"); return;}4   case DYN$C_PCB:    {strcpy(retbuf,"PCB"); return;}4   case DYN$C_PQB:    {strcpy(retbuf,"PQB"); return;}4   case DYN$C_RVT:    {strcpy(retbuf,"RVT"); return;}4   case DYN$C_TQE:    {strcpy(retbuf,"TQE"); return;}4   case DYN$C_UCB:    {strcpy(retbuf,"UCB"); return;}4   case DYN$C_VCB:    {strcpy(retbuf,"VCB"); return;}4   case DYN$C_WCB:    {strcpy(retbuf,"WCB"); return;}6   case DYN$C_BUFIO:  {strcpy(retbuf,"BUFIO"); return;}7   case DYN$C_TYPAHD: {strcpy(retbuf,"TYPAHD"); return;} 4   case DYN$C_GSD:    {strcpy(retbuf,"GSD"); return;}4   case DYN$C_MVL:    {strcpy(retbuf,"MVL"); return;}4   case DYN$C_NET:    {strcpy(retbuf,"NET"); return;}4   case DYN$C_KFE:    {strcpy(retbuf,"KFE"); return;}4   case DYN$C_MTL:    {strcpy(retbuf,"MTL"); return;}7   case DYN$C_BRDCST: {strcpy(retbuf,"BRDCST"); return;}/4   case DYN$C_CXB:    {strcpy(retbuf,"CXB"); return;}4   case DYN$C_NDB:    {strcpy(retbuf,"NDB"); return;}4   case DYN$C_SSB:    {strcpy(retbuf,"SSB"); return;}4   case DYN$C_DPT:    {strcpy(retbuf,"DPT"); return;}4   case DYN$C_JPB:    {strcpy(retbuf,"JPB"); return;}4   case DYN$C_PBH:    {strcpy(retbuf,"PBH"); return;}4   case DYN$C_PDB:    {strcpy(retbuf,"PDB"); return;}4   case DYN$C_PIB:    {strcpy(retbuf,"PIB"); return;}4   case DYN$C_PFL:    {strcpy(retbuf,"PFL"); return;}7   case DYN$C_PFLMAP: {strcpy(retbuf,"PFLMAP"); return;}.4   case DYN$C_PTR:    {strcpy(retbuf,"PTR"); return;}5   case DYN$C_KFRH:   {strcpy(retbuf,"KFRH"); return;}n5   case DYN$C_DCCB:   {strcpy(retbuf,"DCCB"); return;}L7   case DYN$C_EXTGSD: {strcpy(retbuf,"EXTGSD"); return;}17   case DYN$C_SHMGSD: {strcpy(retbuf,"SHMGSD"); return;}a4   case DYN$C_SHB:    {strcpy(retbuf,"SHB"); return;}4   case DYN$C_MBX:    {strcpy(retbuf,"MBX"); return;}5   case DYN$C_IRPE:   {strcpy(retbuf,"IRPE"); return;}G8   case DYN$C_SLAVCEB:{strcpy(retbuf,"SLAVCEB"); return;}7   case DYN$C_SHMCEB: {strcpy(retbuf,"SHMCEB"); return;}[4   case DYN$C_JIB:    {strcpy(retbuf,"JIB"); return;}4   case DYN$C_TWP:    {strcpy(retbuf,"TWP"); return;}4   case DYN$C_RBM:    {strcpy(retbuf,"RBM"); return;}4   case DYN$C_VCA:    {strcpy(retbuf,"VCA"); return;}4   case DYN$C_CDB:    {strcpy(retbuf,"CDB"); return;}4   case DYN$C_LPD:    {strcpy(retbuf,"LPD"); return;}4   case DYN$C_LKB:    {strcpy(retbuf,"LKB"); return;}4   case DYN$C_RSB:    {strcpy(retbuf,"RSB"); return;}5   case DYN$C_LKID:   {strcpy(retbuf,"LKID"); return;}*5   case DYN$C_RSHT:   {strcpy(retbuf,"RSHT"); return;})5   case DYN$C_CDRP:   {strcpy(retbuf,"CDRP"); return;} 4   case DYN$C_ERP:    {strcpy(retbuf,"ERP"); return;}5   case DYN$C_CIDG:   {strcpy(retbuf,"CIDG"); return;}n6   case DYN$C_CIMSG:  {strcpy(retbuf,"CIMSG"); return;}4   case DYN$C_XWB:    {strcpy(retbuf,"XWB"); return;}4   case DYN$C_WQE:    {strcpy(retbuf,"WQE"); return;}4   case DYN$C_ACL:    {strcpy(retbuf,"ACL"); return;}4   case DYN$C_LNM:    {strcpy(retbuf,"LNM"); return;}4   case DYN$C_FLK:    {strcpy(retbuf,"FLK"); return;};   case DYN$C_RIGHTSLIST:{strcpy(retbuf,"RIGHTSL"); return;}y4   case DYN$C_KFD:    {strcpy(retbuf,"KFD"); return;}5   case DYN$C_KFPB:   {strcpy(retbuf,"KFPB"); return;})4   case DYN$C_CIA:    {strcpy(retbuf,"CIA"); return;}4   case DYN$C_PMB:    {strcpy(retbuf,"PMB"); return;}4   case DYN$C_PFB:    {strcpy(retbuf,"PFB"); return;}5   case DYN$C_CHIP:   {strcpy(retbuf,"CHIP"); return;}E4   case DYN$C_ORB:    {strcpy(retbuf,"ORB"); return;}6   case DYN$C_QVAST:  {strcpy(retbuf,"QVAST"); return;}5   case DYN$C_MVWB:   {strcpy(retbuf,"MVWB"); return;}d4   case DYN$C_UNC:    {strcpy(retbuf,"UNC"); return;}4   case DYN$C_DCB:    {strcpy(retbuf,"DCB"); return;}5   case DYN$C_VCRP:   {strcpy(retbuf,"VCRB"); return;}e4   case DYN$C_SPL:    {strcpy(retbuf,"SPL"); return;}4   case DYN$C_ARB:    {strcpy(retbuf,"ARB"); return;}7   case DYN$C_LCKCTX: {strcpy(retbuf,"LCKCTX"); return;} 4   case DYN$C_BOD:    {strcpy(retbuf,"BOD"); return;}5   case DYN$C_FTRD:   {strcpy(retbuf,"FTRD"); return;};;   case DYN$C_DDTM_EVENT:{strcpy(retbuf,"DDTM_EV"); return;} 5   case DYN$C_DFLB:   {strcpy(retbuf,"DFLB"); return;} 4   case DYN$C_PTC:    {strcpy(retbuf,"PTC"); return;}4   case DYN$C_OCB:    {strcpy(retbuf,"OCB"); return;}  I /* The following types may or may not exist, depending on VMS version. */O   #ifdef DYN$C_DTN4   case DYN$C_DTN:    {strcpy(retbuf,"DTN"); return;} #endif #ifdef DYN$C_DEA4   case DYN$C_DEA:    {strcpy(retbuf,"DEA"); return;} #endif #ifdef DYN$C_CPCBe5   case DYN$C_CPCB:   {strcpy(retbuf,"CPCB"); return;}G #endif #ifdef DYN$C_HWPCB6   case DYN$C_HWPCB:  {strcpy(retbuf,"HWPCB"); return;} #endif #ifdef DYN$C_DTU4   case DYN$C_DTU:    {strcpy(retbuf,"DTU"); return;} #endif #ifdef DYN$C_GCB4   case DYN$C_GCB:    {strcpy(retbuf,"GCB"); return;} #endif #ifdef DYN$C_RDPBa5   case DYN$C_RDPB:   {strcpy(retbuf,"RDPB"); return;}H #endif #ifdef DYN$C_RDDB 5   case DYN$C_RDDB:   {strcpy(retbuf,"RDDB"); return;}R #endif #ifdef DYN$C_SCDRP6   case DYN$C_SCDRP:  {strcpy(retbuf,"SCDRP"); return;} #endif #ifdef DYN$C_TQE_ACB8   case DYN$C_TQE_ACB:{strcpy(retbuf,"TQE_ACB"); return;} #endif #ifdef DYN$C_NSABG5   case DYN$C_NSAB:   {strcpy(retbuf,"NSAB"); return;}r #endif #ifdef DYN$C_VBSME5   case DYN$C_VBSM:   {strcpy(retbuf,"VBSM"); return;}S #endif  +   /* This are type codes with a subtype. */a  4   case DYN$C_SCS:    {strcpy(retbuf,"SCS"); return;}3   case DYN$C_CI:     {strcpy(retbuf,"CI"); return;}m9   case DYN$C_LOADCODE:{strcpy(retbuf,"LOADCOD"); return;}n5   case DYN$C_INIT:   {strcpy(retbuf,"INIT"); return;} 9   case DYN$C_CLASSDRV:{strcpy(retbuf,"CLASDRV"); return;} 4   case DYN$C_CLU:    {strcpy(retbuf,"CLU"); return;}4   case DYN$C_PGD:    {strcpy(retbuf,"PGD"); return;}5   case DYN$C_DECW:   {strcpy(retbuf,"DECW"); return;}l4   case DYN$C_VWS:    {strcpy(retbuf,"VWS"); return;}5   case DYN$C_DSRV:   {strcpy(retbuf,"DSRV"); return;}_3   case DYN$C_MP:     {strcpy(retbuf,"MP"); return;} 4   case DYN$C_NSA:    {strcpy(retbuf,"NSA"); return;}5   case DYN$C_CWPS:   {strcpy(retbuf,"CWPS"); return;}m3   case DYN$C_VP:     {strcpy(retbuf,"VP"); return;} 5   case DYN$C_SHAD:   {strcpy(retbuf,"SHAD"); return;} 4   case DYN$C_VCC:    {strcpy(retbuf,"VCC"); return;} #ifdef DYN$C_ENS4   case DYN$C_ENS:    {strcpy(retbuf,"ENS"); return;} #endif #ifdef DYN$C_OBSOLETE_ENSG9   case DYN$C_OBSOLETE_ENS:{strcpy(retbuf,"ENS"); return;}p #endif5   case DYN$C_DDTM:   {strcpy(retbuf,"DDTM"); return;}c4   case DYN$C_SMI:    {strcpy(retbuf,"SMI"); return;}5   case DYN$C_TSRV:   {strcpy(retbuf,"TSRV"); return;};5   case DYN$C_LAVC:   {strcpy(retbuf,"LAVC"); return;}d7   case DYN$C_DECNET: {strcpy(retbuf,"DECNET"); return;}t4   case DYN$C_PSX:    {strcpy(retbuf,"PSX"); return;}5   case DYN$C_QMAN:   {strcpy(retbuf,"QMAN"); return;}]3   case DYN$C_SM:     {strcpy(retbuf,"SM"); return;} 5   case DYN$C_MISC:   {strcpy(retbuf,"MISC"); return;}. #ifdef DYN$C_RCl3   case DYN$C_RC:     {strcpy(retbuf,"RC"); return;}e #endif #ifdef DYN$C_IPC4   case DYN$C_IPC:    {strcpy(retbuf,"IPC"); return;} #endif #ifdef DYN$C_FILE_SYSTEM;   case DYN$C_FILE_SYSTEM:{strcpy(retbuf,"FILSYS"); return;}e #endif #ifdef DYN$C_SECURITY]7   case DYN$C_SECURITY:{strcpy(retbuf,"SECUR"); return;}D #endif8   case DYN$C_SPECIAL:{strcpy(retbuf,"SPECIAL"); return;} #ifdef DYN$C_LNMC/5   case DYN$C_LNMC:   {strcpy(retbuf,"LNMC"); return;}( #endif7   default:           {strcpy(retbuf,"UNKNOWN");return;}   } }W  	 /******/T  7 void mem_lay_look(char *basnam, char *typnam, int size)a {]8  /* Returns information about lookaside lists in VMS V5.<     basnam: name of system cell containing list base address?     cntnam: name of system cell containing initial packet counts!     size:   size of one packet */C  1  char nambuf[18];	/* Buffer for xxx[V] symbols */.  &  int start,		/* Lookaside list base */)      rstart,		/* Rounded start address */a,      next,		/* Addr. of next unused entry */      end,		/* List end */A$      count,		/* init packet count */$      countv,		/* max packet count */#      page_size,		/* Size of page */m2      round_mask;	/* Page boundary round-up mask */  ?  symval_and_trymem(desc(basnam),&start);	/* Get base address */   #  /* Build count string and get . */l    strcpy(nambuf,"SGN$GL_");    strcat(nambuf,typnam);x    strcat(nambuf,"CNT");  @  symval_and_trymem(desc(nambuf),&count);		/* Get # of packets */  /  end = start + (count * size);				/* Get end */_    /* Print info. */  y   sda$extend_print(desc("!50<!AZ lookaside list (!AZCOUNT=!UL)!>!XL  !XL  !XL"),typnam,typnam,count,start,end,end-start);   ?  /* Now obtain and display information about expansion area. */   <  /* Update name string - append a 'V' to the symbol name. */    strcat(nambuf,"V");  )  symval_and_trymem(desc(nambuf),&countv);t  A  /* Subtract this value from the initial count to obtain the # ofL%     packets in the expansion area. */l    countv -= count;t  5  /* End of initial list = start of expansion area. */b  
  start = end;l  0  end = start + (countv * size);				/* Get end */  8  symval_and_trymem(desc("MMG$GL_PAGE_SIZE"),&page_size);  4  round_mask = page_size - 1;		/* Build round mask */    end = pagrnd(end);e  B  /* Get current base (next) address of unallocated expansion area.#     Build MMG$GL_xxxNEXT string. */     strcpy(nambuf,"MMG$GL_");    strcat(nambuf,typnam);t    strcat(nambuf,"NEXT");i  I  symval_and_trymem(desc(nambuf),&next);		/* Get addr of next free pkt. */c  @  /* If base address and next address are the same, there were no     packets yet allocated. */W  5  rstart = pagrnd(start);			/* Round up start addr. */     if (rstart == next) sda$extend_print(desc("!50<!AZ expansion area (!AZCOUNTV=!UL)!>!XL  !XL  !XL"),typnam,typnam,countv+count,start,end,end-start);  J  /* Otherwise, compute # of packets in the allocated area and display this     value as well. */W    elseC  {   rstart = (next - start)/size;      sda$extend_print(desc("!50<!AZ exp. area (!AZCOUNTV=!UL, in use:!UL)!>!XL  !XL  !XL"),typnam,typnam,count+countv,rstart,start,end,end-start);   }  /* well, that's all. */ }B  	 /******/a  , void mem_lay_getsiz(int basadr, int *imgsiz) { B  /* Given the base address of a system image, this routine locatesF     the correspondig LDRIMG block (by comparing LDRIMG$L_BASE with theC     given address) and returns the value of LDRIMG$L_PAGE_COUNT. */x  )  int start,			/* Start of LDRIMG chain */a1      ldrimg;			/* Address of next LDRIMG block */   >  struct __LDRIMG imgptr;	/* Pointer to current LDRIMG block */  8  /* Get chain address and addr of first LDRIMG block. */  0  symbol_value(desc("LDR$GQ_IMAGE_LIST"),&start);  $  sda$extend_reqmem(start,&ldrimg,4);  8  /* Loop through chain list. If pointer to next chain is;     the value of the chain address, we're are the end. Note )     that this should never occur here. */i    while (start != ldrimg)  {   /* Copy LDRIMG block. */  2   sda$extend_reqmem(ldrimg,&imgptr,__LDRIMG_SIZE);     /* Is this our image? */  %   if (imgptr.LDRIMG$L_BASE == basadr)    { -    /* Yes, it is. Return length to caller. */i  (    *imgsiz = imgptr.LDRIMG$L_PAGE_COUNT;  
    return;   }i?   /* Otherwise, get address of next LDRIMG and try this one. */d  &   ldrimg = imgptr.LDRIMG$L_FLINK;       } 0E  /* We should never come here. If we do, an invalid 'basadr' argumenti      was given. Tell the user. */  g  sda$extend_print(desc("CLUE-W-INVBASADR, couldn't locate system image with base address !XL"),basadr);i  0  /* Set return length to 0 to indicate error. */  
  *imgsiz = 0;     /* Well, all done. */ }g  	 /******/l   int chk_vms_v6() {*J  /* This routine checks whether VMS V6 or higher is running. It returns 1,K     if so; else, it returns 0. This check is required at run-time to ensurek:     that the approbiate version-dependend code is invoked.  N     The check is made by obtaining the values of the symbols EXE$AR_NPOOL_DATAJ     and EXE$AR_NPOOL_DATA_MON. These symbols point to the new V6 lookasideJ     lists in non-paged pool and therefore do not exist (are returned as 0)     on V5 systems. */     int val[2];  5  symbol_value(desc("EXE$AR_NPOOL_DATA_MON"),&val[0]);t  1  symbol_value(desc("EXE$AR_NPOOL_DATA"),&val[1]);t  *  if (val[0] || val[1]) return 1;		/* V6 */    else return 0;					/* V5 */ }a #endif #endif