 #ifdef VAXC # #module CLUE$MAIN "BOL-V1.0/AUG-96"  #else * #pragma module CLUE$MAIN "BOL-V1.0/AUG-96" #endif  < /* This module contains CLUE's initialization and main code,-    including command dispatching routines. */   B /* Perform a sanitary check. The constant MAJ_VERS must be defined@    and must be either 5, 6 or 7 (the major number of the currentB    VMS version), MIN_VERS must be define as well and must not be 0?    (VMS versions V6.0 and V7.0 are not currently supported.) */   5 #if (MAJ_VERS != 5 && MAJ_VERS != 6 && MAJ_VERS != 7) < #error MAJ_VERS is undefined or contains invalid VMS version #else  #if (MIN_VERS == 0) < #error MIN_VERS is undefined or contains invalid VMS version #else    #include "clue$include.h"   4 int globalref CLUE$CLD,SDA$EXTEND_VECTOR_TABLE_ADDR;   #ifdef VAXC N globaldef SDA$EXTEND_VERSION = 0x00000001;  /* Activation interface version */ #else * const int SDA$EXTEND_VERSION = 0x00000001; #endif   # int G_exit_flg,G_on_running_system;   $ void typ_help(),symval_and_trymem();  	 /******/   # void sda$extend(int table,dsc *cmd)  { C  /* This is the extension's main routine. It is invoked by SDA when <     the CLUE command prompt is entered at the SDA> promt. */  &  char version[4];				/* VMS version */  (  int status,					/* CLI return status */       uptime1,					/* Uptime 1 */       uptime2;					/* Uptime 2 */  +  float one_sec = 1.0;				/* Waiting time */   2  $DESCRIPTOR(prp,"CLUE$SDA> ");			/* Our prompt */  ?  /* The first action to do: init the callback vector table base B     address location (SDA$EXTEND_VECTOR_TABLE_ADDR) with the value:     passed from SDA as first argument to our extension. */  H  SDA$EXTEND_VECTOR_TABLE_ADDR = table;		/* Init callback vector table */  I  /* Perform sanitary version check. We can run only under the VMS version #     which we was compiled under. */   3  symval_and_trymem(desc("SYS$GQ_VERSION"),version);   <  /* The version is stored as ASCII text string (e.g "V6.1").=     We're interested therefore in the second and fourth byte. ?     Subtract 0x030 from these bytes (to get a binary value) and =     compare them with the compile-time constants MAJ_VERS and      MIN_VERS. */  )  version[1] -= 0x030; version[3] -= 0x30;   6  if (version[1] != MAJ_VERS || version[3] != MIN_VERS)  {`   sda$extend_type(desc("%CLUE-E-BADVRS, VMS version mismatch - please reinstall this product"));     sda$extend_type(desc("-CLUE-I-VERS, current VMS Version: V!UB.!UB, compiled for VMS version V!UB.!UB"),version[1],version[3],MAJ_VERS,MIN_VERS);  	   return;   }D  /* Let's determine first whether a crash dump or the running system!     is analyzed. This is done by:   >     o) Obtaining the value of system cell EXE$GL_ABSTIM (#. of"        seconds since last reboot).       o) Waiting one second.  ;     o) Obtaining the value of the above cell a second time.   A     On a running system, the obtainend values must differ. On the D     other hand, in a crash dump, the value of the cell is frozen andF     will never change; therefore, the obtained values are the same. */  D  symval_and_trymem(desc("EXE$GL_ABSTIM"),&uptime1);	/* First time */  ,  lib$wait(&one_sec);					/* Wait a second */  E  symval_and_trymem(desc("EXE$GL_ABSTIM"),&uptime2);	/* Second time */   F  /* If values are not the same, we're analyzing the running system. */  1  if (uptime1 != uptime2) G_on_running_system = 1;   A  /* Determine whether we're invoked with a command and additional J     parameters. If we are, executed the command and return back to SDA. */  0  if (cmd->dsc$w_length)					/* Command given? */  {=   status = cli$dcl_parse(cmd,&CLUE$CLD);		/* Yes, parse it */   F   if (status == CLI$_NORMAL) status = cli$dispatch();	/* Execute it */  .   else typ_help();					/* Error: disp. help */      return;						/* That's all. */  }  else   {J   /* Otherwise, prompt for commands until EXIT or <CTRL><Z> is entered. */  3   sda$extend_new_page();				/* Start on new page */   /   /* Display version and author information. */   e   sda$extend_print(desc("CLUE (Crash Log Utility Extractor) Extension for OpenVMS !AZ"),S_CLUE_VERS);   W   sda$extend_print(desc("(P) 1993,1995 by Ing. Ferry Bolhr (bol@adv.magwien.gv.at)"));      sda$extend_skip_lines(2);      /* Get first/next command. */   :   status = cli$dcl_parse(0,&CLUE$CLD,sda$extend_get_input, 			 sda$extend_get_input,&prp);   2   if (status != CLI$_NORMAL)				/* Parse error? */   { )    typ_help();						/* Yes, disp. help */        return;						/* and return */   } /   while (status != RMS$_EOF)				/* otherwise */    { G    if (status == CLI$_NORMAL) status = cli$dispatch();	/* Execute it */   0    if (G_exit_flg) return;				/* EXIT? return */  N    status = cli$dcl_parse(0,&CLUE$CLD,sda$extend_get_input, /* No, get next */  			  sda$extend_get_input,&prp);   }   } }   	 /******/    void typ_help()  {   /* Display short help text. */   Q  sda$extend_print(desc("CLUE commands are: CONFIG, DEBUG, HELP, MEMORY/quals,"));   O  sda$extend_print(desc("                   PROCESS/quals, SECTIONS[/quals],"));   Q  sda$extend_print(desc("                   TERMINAL/quals. Type HELP for help"));  }  #endif #endif