 #ifdef VAXC % #module CLUE$CONFIG "BOL-V1.0/AUG-96"  #else , #pragma module CLUE$CONFIG "BOL-V1.0/AUG-96" #endif  / /* This module processes the CONFIG command. */   B /* Perform a sanitary check. The constant MAJ_VERS must be defined@    and must be either 5, 6 or 7 (the major number of the currentB    VMS version), MIN_VERS must be define as well and must not be 0?    (VMS versions V6.0 and V7.0 are not currently supported.) */   5 #if (MAJ_VERS != 5 && MAJ_VERS != 6 && MAJ_VERS != 7) < #error MIN_VERS is undefined or contains invalid VMS version #else  #if (MIN_VERS == 0) < #error MIN_VERS is undefined or contains invalid VMS version #else   < /* Include definitions from LIB. These includes were created<    by the MLB2H (Macro library to .H file) DCL procedure. */   #include "inc:arcdef.h"  #include "inc:cpbdef.h"  #include "inc:cpudef.h"  #include "inc:ndtdef.h"  #include "inc:pcbdef.h"  #include "inc:rpbdef.h"  #include "inc:splcoddef.h"  9 /* DEC C includes are all given in the following file. */    #include "clue$include.h"    /* Auxiliary routines. */    char *get_cpus();    /* External routines. */  8 int symbol_value(),symval_and_trymem(),translate_bits();  	 /******/    void clue$sda_config() { B  /* This routine processes the CONFIG command. It displays variousB     information about hardware, memory and CPU configuration. NoteE     that, on VAX, related (and more detailled) displays are available @     via the SYSGEN SHOW/ADAPTER, SHOW/BUS and SHOW/CONFIGURATION     commands. */  #  int aux[3],					/* Aux pointers */ -      cpuloa,					/* Base address of CPULOA */ -      curpcb,					/* PCB of current process */ +      nullpcb,					/* PCB of NULL process */ (      *pcbvec,					/* Ptr to PCB array */)      page_size,					/* Phys. page size */ 1      defcap,					/* Default process capability */       i,	j,					/* Counter */&      lowest_pa = 1,				/* Lowest PA */(      highest_pa = 0,				/* Highest PA */?      cpu_array[CPU$C_MAX_CPUS],			/* Array of CPU data addr. */ 0      maxprc;					/* Maximum process in system */  *  unsigned int *i_ptr,				/* Aux pointer */%      totpfn = 0,				/* Total PFN's */ &      cpu_num;					/* Primary CPU ID */     float mbs;					/* Total MB's */  &  char sysnam[64],				/* System name */,       cap_str[40],				/* CPU capabilities */'       memstr[10],				/* Memory value */ 6       memtyp[2][6] = {"shrd","main"},		/* Mem types */!       *ptr;					/* Aux pointer */   3  char states[8][9] =   {"unkown",		/* CPU states */  			"INIT","RUNNING","STOPPING",  			"STOPPED","TIMEOUT",  			"BOOT_REJ","BOOTED"};  ?  char img_typ[3][14] = {"uniprocessing",	/* Sync image types */  			"full checking",  			"streamlined"};  , const struct bittab				/* Capapility bits */:  cpubittab[7]= {CPB$M_PRIMARY,"PRIMARY",	/* Primary CPU */; 		CPB$M_VECTOR, "VECTOR",		/* Vector coprocessor present */ 8 		CPB$M_QUORUM, "QUORUM",		/* Cluster quorum required */3 		CPB$M_RUN,    "RUN",		/* CPU can run processes */ 6 #ifdef CPB$M_AUDIT				/* Audit does not exist on V5 */8 		CPB$M_AUDIT,  "AUDIT",		/* CPU can perform auditing */ #endif< 		CPB$M_EXPLICIT_AFFINITY,"HARDAFF", /* Explicit affinity */
 		0,0};		       *  struct __CPU cpu;				/* CPU data block */  2  struct __PCB pcb;				/* PCB of current process */  3  struct __RPB rpb;				/* Restart parameter block */   7  /* Set header string and start display at new page. */   =  sda$extend_format_subheading(desc("System Configuration:"));     sda$extend_new_page();   /  sda$extend_print(desc("System Information:"));     /* Get primary CPU ID */   3  symval_and_trymem(desc("SMP$GL_PRIMID"),&cpu_num);   <  /* Get SMN (system model number) and physical page size. */  4  symval_and_trymem(desc("EXE$GW_CPUMODEL"),&aux[0]);  C  /* Get hardware name. We obtain this name from the loaded hardware B     name table (SYS$LOADABLE_IMAGES:CPULOA.EXE). The symbol CPULOA     points to this table.   ?     Starting with VMS V6.2, the location EXE$GT_HWNAME contains ?     the hardware name as well. We use, however, common code for      all VMS versions. */  &  symbol_value(desc("CPULOA"),&cpuloa);  @  /* The table contains longwords pointing to the actual hardware@     text strings. The CPU model number can be used as index intoA     this table (decremented by 1). Since the  first two longwords @     contain the number of subsequent longwords, the base address     must be increment by 8. */  
  cpuloa += 8;   H  i = cpuloa + (4 * (aux[0]-1));		/* Address of LW holding our hw name */  8  sda$extend_reqmem(i,&j,4);		/* Get address of string */  9  sda$extend_reqmem(j,sysnam,4);		/* Get length of name */   ?  sda$extend_reqmem(j,sysnam,sysnam[0]+1); /* Get entire name */   .  /* Print hardware name and primary CPU ID. */  J  sda$extend_print(desc("System Type:    !34<!AC!>Primary CPU ID:   !2ZL"), 		  sysnam,cpu_num);  8  symval_and_trymem(desc("MMG$GL_PAGE_SIZE"),&page_size);  #  /* Print model # and page size. */   P  sda$extend_print(desc("Model number:   !34<#!UW!>Phys. Pagesize:   !UW Bytes"), 		  aux[0],page_size);    sda$extend_skip_lines(1);  /  /* Print information about physical memory. */ /  /* ---------------------------------------- */   1  sda$extend_print(desc("Memory Configuration:"));   O  sda$extend_print(desc("Cluster   Start PA     End PA    Size (MB)    Usage"));   K  /* Information about physical memory resides in the RPB (restart parameter '     block. Let's copy the RPB first. */   /  symval_and_trymem(desc("EXE$GL_RPB"),&aux[0]);    -  sda$extend_reqmem(aux[0],&rpb,RPB$C_LENGTH);   B  /* Memory related information is stored starting at offset RPB$L_F     MEMDSC. Since physical memory may present in no-contiguous blocks,B     up to 8 memory descriptors (describing a contiguous section of     physical memory) may exist.   A     Each descriptor consists of two longwords: the first longword @     contains the page count (Bits 0...23) and the adapter number8     (Bits 24...31), the second contains the base PFN. */  ;  ptr = (char*) &rpb + RPB$L_MEMDSC_OFF;		/* Init pointer */     i_ptr = (unsigned int*) ptr;   %  for (i=0; i != RPB$C_MEMDSCSIZ; i++)   {-   aux[0] = *i_ptr++;				/* Next page count */   8   if (!aux[0]) break;				/* If 0, no more descriptors */  &   aux[1] = *i_ptr++;				/* Next PFN */  P   /* If this is a MA-780 multiport memory adapter, perform additional checks. */  9   aux[2] = aux[0]>>RPB$S_PAGCNT;		/* Extract adapter # */   H   aux[3] = (aux[2] >= NDT$_MPM0) && (aux[2] <= NDT$_MPM3); /* MA-780? */  
   if (aux[3])    { @    /* This is a MA-780 multiport memory. Let's see whether it is@       used as shared memory or just as extension to conventional<       memory. This is indicated by the following bootsflags:  9 	RPM$M_MPM.......multiport memory is used as main memory; 0 			conventional memory (if present) is not used.  C         RPM$M_USEMPM....multiport memory is used as it were conven- 2 			tional memory; that is, it is just an extension" 			to present conventional memory.                         B       These flags are stored at offset RPB$L_BOOTR5 in the RPB. */  K    if ((rpb.RPB$L_BOOTR5 & RPB$M_MPM) || (rpb.RPB$L_BOOTR5 & RPB$M_USEMPM))   >    ptr = memtyp[1];			/* Multiport memory used conventional */  2    else ptr = memtyp[0];		/* Real shared memory */   } ;   else ptr = memtyp[1];			/* Otherwise, it's main memory */   !   /* Compute End PA and mem size:   &      o - mem size = pagcnt * page_size  ,      o - end pa = start pa + mem size - 1 */  -   aux[2] = (aux[0] & 0x00FFFFFF) * page_size;      aux[3] = aux[1] + aux[2] - 1;   6   mbs = aux[2] / 1024 / 1024;		/* Compute Megabytes */  E   /* FAO directives provide no support for floating point. We use C's B      sprintf function to build a character string and include this&      string with the !AZ directive. */     sprintf(memstr,"%6.2f",mbs);  E   sda$extend_print(desc("  #!UB      !XL    !XL    !8<!AZ!>    !AZ"),  	i,aux[1],aux[3],memstr,ptr);   7   /* Update lowest, highest PFN and total PFN count. */   -   if (aux[1] < lowest_pa) lowest_pa = aux[1];   /   if (aux[3] > highest_pa) highest_pa = aux[3];   "   totpfn += (aux[0] & 0x00FFFFFF);  +   /* And fetch next descriptor, if any. */    }=  /* Print summary line if more than one adapter was found. */     if (i > 1)   {+   mbs = (totpfn * page_size) / 1024 / 1024;      sprintf(memstr,"%3.2f",mbs);  D   sda$extend_print(desc(" Total    !XL    !XL    !8<!AZ!>    ----"), 	lowest_pa,highest_pa,memstr);  }*  /* Print info about SMP and CPU Slots. */*  /* ----------------------------------- */    sda$extend_skip_lines(1);  H  sda$extend_print(desc("Symmetric Multiprocessing (SMP) Information:"));  -  /* Get # of configured and activate CPUS. */   7  symval_and_trymem(desc("SMP$GL_ACTIVE_CPUS"),&aux[0]);   3  symval_and_trymem(desc("SMP$GL_CPUCONF"),&aux[1]);   C  /* The above system cells are bitmask whereins a bit set indicates C     that corresponding CPU is configured/activated. Display them in ?     a sequence of hexadecimal digits, separated with commas. */   B  sda$extend_print(desc("Active CPUs:      !AZ"),get_cpus(aux[0]));  B  sda$extend_print(desc("Configured CPUS:  !AZ"),get_cpus(aux[1]));  =  /* Print general SMP configuration: whether is it enabled or D     disabled and which synchronization image is loaded. To determineK     which image is loaded, analyze the system parameter MULTIPROCESSING. */   ;  symval_and_trymem(desc("SGN$GB_MULTIPROCESSING"),&aux[0]);   *  aux[0] &= 0xFF;				/* It's a byte only */  0  switch(aux[0])					/* Check MULTIPROCESSING: */  {@   case 0: {ptr = img_typ[0]; break;}		/* 0: Uniprocessing img */  	   case 1:    { C    /* If 1, load full checking image, unless there is one CPU only. H       In addition, full checking image is loaded when the ARC$M_LOAD_SMP)       flag is set in EXE$GL_ARCH_FLAG. */   7    symval_and_trymem(desc("EXE$GL_ARCH_FLAG"),&aux[2]);   O    if ((aux[2] & ARC$M_LOAD_SMP) || (aux[1] & ~(1<<cpu_num))) ptr = img_typ[1];       else ptr = img_typ[0];   	    break;    } C   case 2: {ptr = img_typ[1]; break;}		/* 2: always full checking */   	   case 3:    { A    /* If 3, load streamlined image, unless there is one CPU only. F       In addition, streamlined image is loaded when the ARC$M_LOAD_SMP(       flag is set in EXE$GL_ARCHFLAG. */  6    symval_and_trymem(desc("EXE$GL_ARCHFLAG"),&aux[2]);  O    if ((aux[2] & ARC$M_LOAD_SMP) || (aux[1] & ~(1<<cpu_num))) ptr = img_typ[2];       else ptr = img_typ[0];   	    break;    } B   case 4: {ptr = img_typ[2]; break;}		/* 4: always stream lined */  }7  /* Bit SMP$M_ENABLED is set to 1 if SMP is enabled. */   1  symval_and_trymem(desc("SMP$GL_FLAGS"),&aux[0]);     /* Print line. */  K  sda$extend_print(desc("SMP is !AZ, !AZ synchronization image is loaded."), 7 	 aux[0] & SMP$M_ENABLED ? "enabled" : "disabled",ptr);     sda$extend_skip_lines(1);  ?  sda$extend_print(desc("Per-CPU Slot Processor Information:"));   J  /* SMP (Symmetric multi processing) supports up to 32 CPU's on particular9     VAX computers. Display information about these CPU's. K     One single processor systems, display information about the single CPU.   8     The following VAX systems support more than one CPU:  + 	VAX computer	Code     Name		max # of CPU's < 	-----------------------------------------------------------) 	8250,8350	8SS	Scorpio		2 (2 x 8200/8300)   	8800		8NN	Nautilus	2 (2 x 8700) 	8810-8840	8PS	Polarstar	1 - 4& 	6200,6300   *)	9CC	Calypso/CVAX	1 - 8' 	6000 Model 400	9RR	Calypso/Rigel	1 - 8  	9000 Series	9AQ	Aquarius	1 - 4 + 	3520, 3540	60	Firefox		2 or 4 (2/4 x 3500) " 	6000 Model 500	1202	Mariah		1 - 6# 	6000 Model 600	1203	Neptune		1 - 6  	7000 Series	1701	Laser		1 - 6  	10000 Series	1701	Blazer		1 - 8  *     *) Also called VAX 6000-200, 6000-300.  B     Note that the VAX 11/782 (2 x 11/780) is not supported by SMP.  C     CPU-related information can be obtained from the particular CPU D     database. Each CPU has its own database, addressed by a longwordC     array at SMP$GL_CPU_DATA. If a longword is 0, the corresponding E     entry (also called 'slot') is not used. The array size is defined .     by symbol CPU$C_MAX_CPUS, currently 32. */  H  symbol_value(desc("SMP$GL_CPU_DATA"),&aux[0]);		/* Get array address */  N  sda$extend_reqmem(aux[0],cpu_array,CPU$C_MAX_CPUS*4);	/* Copy 32 Longwords */  J  symval_and_trymem(desc("SCH$AR_NULLPCB"),&nullpcb);	/* Get PCB of NULL */  H  symval_and_trymem(desc("SGN$GW_MAXPRCCT"),&maxprc);	/* Max processes */  '  maxprc &= 0xFFFF;					/* Mask word. */   I  symval_and_trymem(desc("SCH$GL_PCBVEC"),&pcbvec);	/* PCB vector array */   *   /* Get the system default capability. */  ?  symval_and_trymem(desc("SCH$GL_DEFAULT_PROCESS_CAP"),&defcap);   I  /* Walk through array. For every CPU, display info from the database. */   $  for(i = 0; i < CPU$C_MAX_CPUS; i++)  {*   /* If approbiate entry is 0, drop it. */     if (!cpu_array[i]) continue;  K   sda$extend_reqmem(cpu_array[i],&cpu,__CPU_SIZE);	/* Copy CPU structure */      /* CPU ID and CPU state. */      sda$extend_skip_lines(1);   D   sda$extend_print(desc("!46<CPU ID:  !8XB!>CPU State:      !AZ"),i, 		states[cpu.CPU$B_STATE]);      /* CPU type and HALT PC. */   @   sda$extend_print(desc("!46<CPU type:  !12XL!>Halt PC: !15XL")," 		cpu.CPU$L_SID,cpu.CPU$L_HALTPC);  "   /* Capabilities and HALT PSL. */  9   translate_bits(cpubittab,cpu.CPU$L_CAPABILITY,cap_str);   C   sda$extend_print(desc("!46<Capabilities:  !AZ!>Halt PSL: !14XL"),  		cap_str,cpu.CPU$L_HALTPSL);   *   /* Current process and bugcheck code. */  C   /* If the CPU is currently running a process, it's PCB address is F      stored in CPU$L_CURPCB. Copy this PCB and extract PID and processC      name thereoff. If the CPU has no current process (CPU$L_CURPCB 8      points to the NULL PCB), display "*** None ***". */  "   if (cpu.CPU$L_CURPCB != nullpcb)   { 9    sda$extend_reqmem(cpu.CPU$L_CURPCB,&pcb,PCB$C_LENGTH);   N    sda$extend_print(desc("!46<Curr. process: !AC (!XL)!>Bugcheck code:  !XL"),4 		pcb.PCB$T_LNAME,pcb.PCB$L_EPID,cpu.CPU$L_BUGCODE);   } h   else sda$extend_print(desc("!46<Curr. process: *** None ***!>Bugcheck code:  !XL"),cpu.CPU$L_BUGCODE);  M   /* Display processes which are bound to this CPU. Loop through process slot L      table. For every process, check whether it is bound. First, get maximum(      processes and PCB array address. */  0   aux[0] = 0;				/* Assume no processes found */  3   cpu_num = 1<<i;			/* Convert CPU # to bit mask */      for (j = 0; j < maxprc; j++)   { +    sda$extend_reqmem(&pcbvec[j],&curpcb,4);   C    if (curpcb == nullpcb) continue;	/* unused PCB slot, try next */   ?    sda$extend_reqmem(curpcb,&pcb,PCB$C_LENGTH);		/* Copy PCB */   J    /* If the process has no capability set or has no affinity, drop it. */  F    if (!pcb.PCB$L_CAPABILITY || !pcb.PCB$L_CURRENT_AFFINITY) continue;  F    /* If the process has a capability set, but it's the system default       capability, drop it. */   0    if (pcb.PCB$L_CAPABILITY == defcap) continue;  D    /* If process is bound to a CPU, but not to this CPU, drop it. */  9    if (!(pcb.PCB$L_CURRENT_AFFINITY & cpu_num)) continue;   E    /* Well, process is bound to this CPU. Display information. First, 7       display header line, if not already displayed. */   H    if (!aux[0]) sda$extend_print(desc("Processes bound to this CPU: "));  I    /* CLear implicit affinity and system default capability bits from the A       process' capability mask (these bits are not displayed). */   F    aux[1] = pcb.PCB$L_CAPABILITY & ~CPB$M_IMPLICIT_AFFINITY & ~defcap;  :    /* Translate the remaining bits and print info line. */  ,    translate_bits(cpubittab,aux[1],cap_str);  @    sda$extend_print(desc("!_!15AC  PID = !8XL  Reason(s): !AZ"),) 	pcb.PCB$T_LNAME,pcb.PCB$L_EPID,cap_str);   -    aux[0]++;					/* Update process counter */    } :   /* If no processes are bound to this CPU, display it. */  S   if (!aux[0]) sda$extend_print(desc("Processes bound to this CPU: *** None ***"));   }  /* That's all here. */  }    /***  ***/    char *get_cpus(int cpumsk) { =  /* Given a CPU mask, this routine returns a character string A     wherein each set bit in the mask is indicated by its position >     as 2-digit hex number (00...1F). The numbers are separated     with commas. */     char *ptr,				/* Aux ptr */#       auxbuf[4],			/* Aux buffer */V       i;				/* Count */a     int tmp;				/* For bit shift */  -  static char retbuf[80];		/* Return string */I  +  retbuf[0] = 0;				/* Init return string */T  $  for(i = 0; i < CPU$C_MAX_CPUS; i++)  {   tmp = cpumsk>>i;  (   if (tmp & 1)				/* Bit set in mask? */   {rH    /* If there is already data in the buffer, separate it with comma. */  %    if (retbuf[0]) strcat(retbuf,",");d      sprintf(auxbuf,"%02X",i);      strcat(retbuf,auxbuf);7   }e  }#  return retbuf; /* Return buffer */v }d #endif #endif