4 $	VERIFY = 'F$VERIFY(F$TRNLNM("FTP_MIRROR_VERIFY"))'
 $	SET = "SET" # $	SET SYMBOL/SCOPE=(noLOCAL,GLOBAL) * $	FTP_MIRROR_VERSION = "V1.0-5"								!HG $	GOTO _START_FTP_MIRROR   DESCRIPTION:  (   Automates mirroring a remote FTP site.   PARAMETERS:      P1 - configuration filename   
 REQUIREMENTS:   N Due to the different commands used by FTP Clients, only a few FTP Clients are K supported.  Due to the different output generated by different FTP Servers, > parsing routines have only been written for a few FTP Servers.  6   o one of the following FTP Clients (on your system):       - MultiNet  $       - HGFTP (formerly MadGoat FTP)       - TCPware $       - UCX (Compaq TCP/IP Services)  M   o mirrored against one of the following FTP Servers (on the remote system):        - MultiNet$       - HGFTP (formerly MadGoat FTP)       - TCPware        - Unix  I  =----------------------------------------------------------------------=    Copyright  1994 by Dan Wing. * Copyright  1997 by MadGoat Software, Inc.$ Copyright  1998 by Richard Levitte.$ Copyright  1999-2000 by Dick Munroe* Copyright  2000 by Dr. Martin P. J. Zinser( Copyright  2001, 2002 by Hunter Goatley  G This code may be freely distributed and modified for no commercial gain G as long as this copyright notice is retained.  This program is supplied  'as-is', and with no warranty.  > Created September 21, 1994, by Dan Wing, TGV <dwing@Cisco.com>5 Hacked a lot by Richard Levitte <richard@levitte.org> 9 Features added by Hunter Goatley <goathunter@goatley.com>   4 Please send bug reports to <goathunter@goatley.com>.  I  =----------------------------------------------------------------------=   ,   REVERSE CHRONOLOGICAL MODIFICATION HISTORY,   ------------------------------------------  >   V1.0-5    8-NOV-2002	Hunter Goatley <goathunter@goatley.com>B     Finally stopped dragging my feet and incorporated changes from     Dr. Martin P.J. Zinser.   B     1.) Add support for an UCX FTP server (that was easy actually)M     2.) Fix some missing quotes (even a really basic syntax coloring comes in          handy sometimes :-) N     3.) Initial ODS-5 support (i.e. remove check for all-uppercase names from M         VMS FTP servers. Both HGFTP and UCX represent lower/mixed case names  C         from ODS-5 volumes without changing them to all upper case) 5     4.) Skip over "Total" lines in directory listings N     5.) Added new Name parameter to select transfertype. This works like TYPE,I         but does check for the (start) of the name of a file to make the  G         decision (useful if the extension is made e.g. of a datestamp).      >   V1.0-4   15-APR-2002	Hunter Goatley <goathunter@goatley.com>F     Made changes to reflect the name change from MadGoat FTP to HGFTP.  E     If an error occurs because there's no mapping for directory, send C     a mail message to the CONFIG_MAILTO address.  This notification G     will occur, for example, when the directory structure on the remote =     end changes and the local param file hasn't been updated.   <     Added PURGE configuration option.  The default is "YES".?     Set to "NO" in your configuration file to prevent the PURGE      from happening.   >   V1.0-3   28-APR-2001	Hunter Goatley <goathunter@goatley.com>E     Incorporated SET TYPE fixes from Martin Zinser <zinser@decus.de>.   >   V1.0-2    5-MAR-2001	Hunter Goatley <goathunter@goatley.com>J     Fixed a bug that would cause a final failure record to not be includedN     in the summary mail message.  (For example, if 3 files failed to transfer,;     the summary message would only show 2 of the failures.)   >   V1.0-1   31-JAN-2001	Hunter Goatley <goathunter@goatley.com>B     Added new configuration record SWITCH_FROM_UNIX_LS_MODE, which?     is needed to put VMS sites running FTP servers in a default G     UNIX listing mode back into VMS listing mode.  This is accomplished @     by sending "CD []" when we first connect to the remote node.  >   V1.0     18-OCT-2000	Hunter Goatley <goathunter@goatley.com>F     Let's make this thing V1.0 finally, and fix the message for number8     of files succeeded and failed to properly use "!%S".  <   T0.8-19  06-Oct-2000  Martin P.J. Zinser <zinser@decus.de>H     Add support for an FTP client from Compaq TCP/IP Services (aka UCX).  8   T0.8-18  04-May-2000  Dick Munroe <munroe@csworks.com>:     If the equivalent remote directory had characters that<     required changes, e.g., embeded ".", the local directory9     wasn't calculated correctly IF the changed characters ?     occurred in the portion that mapped in the leading portion.   8   T0.8-17  22-Apr-2000  Dick Munroe <munroe@csworks.com>?     Ignore block and character devices when transferring files.   8   T0.8-17  22-Apr-2000  Dick Munroe <munroe@csworks.com>     Add a configuration:   	DEREFERENCE_LINK	[YES ! NO]  N      Which causes symbolic links to be seen as different files or directories 8      and data copied more than once.  The default is NO.        Add a configuration:    	TRANSFER_FILES		[YES ! NO]   O     Which caused files to be transferred.  Used only for debugging and defaults      to YES.   7   T0.8-16 15-Mar-2000  Dick Munroe <munroe@acornsw.com> H      I Forgot to check for a one shot submission at the SET ENTRY point.N      Change to using the multinet convention for embedded periods in directory      names (. becomes $5N).   7   T0.8-15 10-Mar-2000  Dick Munroe <munroe@acornsw.com>       Add a configuration:    	DEBUG [integer]  H      Which, by default, turns debugging on, otherwise sets the debugging/      state to the value of the DEBUG parameter.   J      The code that recognized a new directory failed if the directory name!      contained an embedded blank.   7   T0.8-14 11-Dec-1999  Dick Munroe <munroe@acornsw.com>        Added a configuration line:   	SPLIT_DIRECTORY	directory  I      Which, in conjunction with MAXIMUM_FILES allows you to make one pass P      through a remote site and break up the transfers into several small chuncksG      which then get executed one at a time each time FTP_MIRROR is run.          Added a configuration line:   	SPLIT_SUBMIT_AFTER deltaTime   M      Which replaces the SUBMIT_AFTER time if split files have been created in       the split directory.        7   T0.8-13 08-Dec-1999  Dick Munroe <munroe@acornsw.com> N      Submit the next run at the beginning of the job to keep things running inM      the face of failures that would otherwise be fatal.  Tweak the submitted 3      job release time to get things set up "right".   7   T0.8-12 16-Oct-1999  Dick Munroe <munroe@acornsw.com> J      To allow sorting out of multiple runs of ftp_mirror, take the name of4      the DATA file as the base of the log file name.  7   T0.8-11 09-Sep-1999  Dick Munroe <munroe@acornsw.com> F      Getting an unknown host error during processing which begins with	      a ?.   6   T0.8-10 27-May-1999  Dick Munroe <munroeacornsw.com>G      The template says that PROCESS_SOFTWARE is a valid FTP SERVER type ,      and the command procedure chokes on it.J      Some FTP servers incorrectly use 53x to indicate the need for furtherK      information during a log in.  The fix is to look for the USER username .      line in the log BEFORE looking for a 530.C      Add a type line that overrides the transfer type as necessary. 6      Parse the FTP output to generate the report file.  7   T0.8-9  12-May-1999  Dick Munroe <munroe@acornsw.com> H      Fix a bug that got triggered by seeing "$" debugging records in theG      FTP log file when getting a directory listing.  While I was at it, F      I also force a retry when the login fails for any ftp processing.G      At the moment, it waits one minute and retries indefinately.  This C      guarantees that a file transfer actually happens each time the E      command procedure is run rather than relying on the batch job to +      get through the "next" time it is run.   7   T0.8-8  16-APR-1999  Dick Munroe <munroe@acornsw.com> I      There is at least one case I'm running across in which the file name K      reported by LS isn't the file name actually on the server.  Therefore, H      I'm turning exit-on-error OFF once the file transfer portion of theK      procedure starts.  I don't like this solution, but it's what I have at       the moment.  7   T0.8-7  15-APR-1999  Dick Munroe <munroe@acornsw.com> K      The code that picks up the LS options for unix servers needs to supply E      the options when the directory is fully enumerated.  This avoids E      a bug when enumerating directories (or files) which are actually "      symbolic links on the server.  7   T0.8-6  14-APR-1999  Dick Munroe <munroe@acornsw.com> H      The invocation of FTP that gets the directory listings assumed thatG      any error coming back from FTP meant that things were not supposed G      to work.  I have disabled this test and as a result the failure to F      log in is properly detected and the job resubmitted, however thisF      may lead to other problems downstream.  I suspect that a somewhatF      more sophisticated error recovery scheme will need to be evolved.F      If things fail due to either a login failure, or other issue, the2      directory structures don't have to be purged.  7   T0.8-5  13-APR-1999  Dick Munroe <munroe@acornsw.com> >      Some FTP servers have a time limit on them.  I'm adding aB      MAXIMUM_FILES parameter to the configuration that allows someB      control over the load placed on the server.  Once the maximumH      number of files have been transferred, then the job is rescheduled.D      Frequently FTP servers are busy and you can't get logged in, soE      check for the 530 status and reschedule the job if that happens. B      To avoid spurious errors, check to see if directories contain'      files during the purge processing.   7   T0.8-4  09-APR-1999  Dick Munroe <munroe@acornsw.com> B      Using a multinet FTP client requires that the VERBOSE mode ofF      FTP transfer be used.  This, in turn, left stuff in the log filesD      that, for some reason, the command procedure didn't know how toF      process.  There were similar issues for hooking up to aol.com, soE      now this procedure seems to work with all the ftp sites that I'm       using regularly.   <   T0.8-3  23-APR-1998  Richard Levitte <richard@levitte.org>B      A small bug corrected.  REMOTE_DIRECTORY wasn't set correctly@      under some circumstances.  Under others, it was set when it      really shoulden't.   <   T0.8-2  20-APR-1998  Richard Levitte <richard@levitte.org>H      Worked around the fact that the MadGoat client (and perhaps others)E      sputters lines like the following one right in the middle of the       directory output:  2 	<226 File transfer Okay; Closing data connection.  <   T0.8-1  07-APR-1998  Richard Levitte <richard@levitte.org>F      Corrected a small bug that caused a erroneous download to be madeF      for a serie of Unix directories.  Of course, if `ls' could outputC      the directory name for the first directory listed, we wouldn't       have these problems...   <   T0.8	   6-APR-1998	Hunter Goatley <goathunter@MadGoat.com>I      Explicitly enable or disable passive mode according to file setting.   <   T0.7    06-APR-1998  Richard Levitte <richard@levitte.org>C      Merged in changes that Hunter Goatley <goathunter@madgoat.com> ,      added in 27-MAY-1997.  His comment was:  2 	Updated for newer MGFTP releases and for TCPware.  <   T0.6    05-APR-1998  Richard Levitte <richard@levitte.org>A      - Now understands the output from a Unix FTP server, and can E        download files from it.  ALL files are currently downloaded in         Image mode.E      - An added feature is that "/..." at the end of a Unix directory =        specification means the same thing as the standard VMS         ellipsis.A      - CAUTION:  Unix file specifications can ONLY be used as the ?        first argument of the DIRECTORY configuratoin parameter. E      - Name conversion for Unix file specifications is done according         to the following rules:C          1. An ending ".gz" is changed to "-gz" if there is another !             dot in the file name. F          2. And ending ".Z" is changed to "_Z" if there is another dot             in the file name. =          3. All remaining dots except the last are changed to <             underscores, except the last one in a file name.F          4. All other characters that are not legal in a VMS file name#             are changed to dollars. C      - A hack that saves the current time in a file has been added. E        If that file is found and there is a time specification in it, C        it is used to limit the download of file to those newer than 9        that time.  The name of this file is configurable. 6      - A mail address to send logs to is configurable.  ;   T0.5	  02-APR-1998  Richard Levitte <richard@levitte.org> C      Many hacks, among other supporting elipsis in directory specs, F      and support for the Process Software FTP server.  Unfortunatelly,-      I haven't made many notes of my changes.   -   T0.0    25-OCT-1994  Dan Wing, wing@tgv.com       Initial release.    $!K $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $  $ _START_FTP_MIRROR:   $  $	ON WARNING THEN GOTO _ERROR  $	ON CONTROL_Y THEN GOTO _ABORT  $ f $	WRITE SYS$OUTPUT F$FAO("!/FTP_Mirror, version !AS.!/Started by !AS on node !AS on !AS, !AS !8AS.", - 			       FTP_MIRROR_VERSION, - 2 			       F$EDIT(F$GETJPI(0,"USERNAME"),"TRIM"), -! 			       F$GETSYI("NODENAME"), - " 			       F$CVTIME(,,"WEEKDAY"), -) 			       F$CVTIME(,"ABSOLUTE","DATE"), -  			       F$CVTIME(,,"TIME"))  $ 
 $	TRUE = 1 $	FALSE = 0  $	DEBUG = FALSE 3 $	IF F$TRNLNM("FTP_MIRROR_DEBUG") THEN DEBUG = TRUE ? $	IF DEBUG THEN WRITE SYS$ERROR "FTP_Mirror debugging enabled." 6 $	DEEPDIRECTORYFLAG = F$GETSYI("VERSION") .GES. "V7.2" $ E $! setup defaults.  These can be overridden in the configuration file  $ 4 $	CONFIG_FTP_CLIENT           = "HGFTP"										!HG% $	CONFIG_COMMAND              = "FTP" " $	CONFIG_DEBUG_PRESENT	    = FALSE4 $	CONFIG_FTP_SERVER           = "HGFTP"										!HG" $	CONFIG_SITE                 = ""+ $	CONFIG_USERNAME             = "anonymous" d $	IF F$TRNLNM("UCX$INET_HOST") .NES. "" THEN CONFIG_PASSWORD = "mirror@" + F$TRNLNM("UCX$INET_HOST")m $	IF F$TRNLNM("TCPIP$INET_HOST") .NES. "" THEN CONFIG_PASSWORD = "mirror@" + F$TRNLNM("TCPIP$INET_HOST")		!DM n $	IF F$TRNLNM("MULTINET_HOST_NAME") .NES. "" THEN CONFIG_PASSWORD = "mirror@" + F$TRNLNM("MULTINET_HOST_NAME")% $	CONFIG_PASSIVE              = FALSE + $	CONFIG_SUBMIT_AFTER         = "+12:00:00" + $	CONFIG_QUEUE                = "SYS$BATCH" % $	CONFIG_FILE_TRANSFER        = "VMS" " $	CONFIG_LAST_TIME_FILE       = """ $	CONFIG_MAILTO               = ""3 $	CONFIG_MAXIMUM_FILES	    = %X7FFFFFFF									!DM ) $	CONFIG_TYPE_TOTAL	    = 0											!DM ' $       CONFIG_NAME_TOTAL           = 0 . $	CONFIG_SPLIT_DIRECTORY	    = ""										!DM/ $	CONFIG_SPLIT_SUBMIT_AFTER   = ""										!DM 6 $	CONFIG_DEREFERENCE_LINKS_PRESENT = FALSE									!DM1 $	CONFIG_DEREFERENCE_LINKS    = "NO"										!DM 4 $	CONFIG_TRANSFER_FILES_PRESENT = FALSE										!DM0 $	CONFIG_TRANSFER_FILES	    = "YES"										!DM6 $	CONFIG_FILE_SWITCH_FROM_UNIX_LS = FALSE										!HG( $	CONFIG_PURGE		    = "YES"										!HG $ 8 $	VALID_CONFIGURATION = TRUE           ! assume the best $ G $	TEMPFILE_1 = "SYS$SCRATCH:FTP_MIRROR_1_" + F$GETJPI(0,"PID") + ".TMP" G $	TEMPFILE_2 = "SYS$SCRATCH:FTP_MIRROR_2_" + F$GETJPI(0,"PID") + ".TMP" G $	TEMPFILE_3 = "SYS$SCRATCH:FTP_MIRROR_3_" + F$GETJPI(0,"PID") + ".TMP" G $	TEMPFILE_4 = "SYS$SCRATCH:FTP_MIRROR_4_" + F$GETJPI(0,"PID") + ".TMP" G $	TEMPFILE_5 = "SYS$SCRATCH:FTP_MIRROR_5_" + F$GETJPI(0,"PID") + ".TMP"  $  $	CONFIG_LAST_TIME = ""  $	CONFIG_DIR_TOTAL = 0 $  $	TYPE_MULTINET = 1  $	TYPE_HGFTP    = 2  $	TYPE_TCPWARE  = 3 " $	TYPE_TCPIP    = 4												!DM $	TYPE_UNIX     = 128  $	TYPE_OTHER    = 255  $ + $	IF P1 .EQS. "" THEN P1 = "FTP_MIRROR.DAT" H $! make sure CONFIGURATION_FILE contains a full path, but also make sureI $! you get the right directory.  Guess what F$PARSE does to non-concealed L $! multivalued logical names.  It's not a pretty sight.  --  Richard Levitte# $	CONFIGURATION_FILE = F$SEARCH(P1)E: $	IF CONFIGURATION_FILE .EQS. "" THEN GOTO _NO_CONFIG_FILE $	GOSUB _CLEANUP $OG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!_2 $	OPEN/READ/ERROR=_ERROR FILE 'CONFIGURATION_FILE' $ _CONFIG_LOOP:	= $	READ/END_OF_FILE=_EXIT_CONFIG_LOOP/ERROR=_ERROR FILE RECORDU. $	RECORD = F$EDIT(RECORD,"COMPRESS,UNCOMMENT")+ $	IF RECORD .EQS. "" THEN GOTO _CONFIG_LOOP  $p2 $	PARA1 = F$EDIT(F$ELEMENT(0," ",RECORD),"UPCASE")! $	PARA2 = F$ELEMENT(1," ",RECORD)n! $	PARA3 = F$ELEMENT(2," ",RECORD)  $  e $	VALID_RECORD = FALSE $l $	IF PARA1 .EQS. "SITE"u $	THEN $	    CONFIG_SITE = PARA2  $	    VALID_RECORD = TRUE  $	ENDIF  $  $	IF PARA1 .EQS. "USERNAME"  $	THEN $	    CONFIG_USERNAME = PARA2t $	    VALID_RECORD = TRUEe $	ENDIF  $  $	IF PARA1 .EQS. "PASSWORD"t $	THEN $	    CONFIG_PASSWORD = PARA2T $	    VALID_RECORD = TRUE  $	ENDIF  $- $	IF PARA1 .EQS. "DIRECTORY" $	THENA $	    CONFIG_DIRECTORIES_'CONFIG_DIR_TOTAL' = PARA2 + "," + PARA3 - $	    CONFIG_DIR_TOTAL = CONFIG_DIR_TOTAL + 1y $	    VALID_RECORD = TRUEi $	ENDIFy $h $	IF PARA1 .EQS. "COMMAND" $	THENB $	    CONFIG_COMMAND = F$EXTRACT(F$LOCATE(" ",RECORD)+1,-1,RECORD) $	    VALID_RECORD = TRUE  $	ENDIF  $t $	IF PARA1 .EQS. "PASSIVE" $	THEN $	    CONFIG_PASSIVE = PARA2 $	    VALID_RECORD = TRUET $	ENDIFa $s $	IF PARA1 .EQS. "PRIV"w $	THEN% $	    ORIGINAL_PRIV = F$SETPRV(PARA2) r $	    IF .NOT. F$PRIVILEGE(PARA2) THEN WRITE SYS$OUTPUT "%%Warning - not all requested privileges are authorized." $	    VALID_RECORD = TRUEy $	ENDIF  $a $	IF PARA1 .EQS. "SUBMIT_AFTER"r $	THEN> $	    CONFIG_SUBMIT_AFTER = F$EDIT("''PARA2' ''PARA3'","TRIM"). $	    IF F$EDIT(PARA2,"UPCASE") .EQS. "NONE" -6 	       .OR. F$EDIT(PARA3,"UPCASE") .EQS. "ONE" THEN -$ 	       CONFIG_SUBMIT_AFTER = "NONE" $	    VALID_RECORD = TRUEo $	ENDIF> $  $	IF PARA1 .EQS. "BATCH_QUEUE" $	THEN $	    CONFIG_QUEUE = PARA2 $	    VALID_RECORD = TRUE  $	ENDIF  $ ' $	IF PARA1 .EQS. "DEBUG"												!DMa $	THEN														!DM & $	    IF PARA2 .EQS. ""												!DM $	    THEN													!DM $		DEBUG = 1												!DM  $	    ELSE													!DM( $		DEBUG = F$INTEGER(PARA2)										!DM $	    ENDIF													!DMv/ $	    CONFIG_DEBUG_PRESENT = TRUE											!DMe( $	    VALID_RECORD = TRUE												!DM $	ENDIF														!DM $  $	IF PARA1 .EQS. "FTP_CLIENT"l $	THEN0 $	    CONFIG_FTP_CLIENT = F$EDIT(PARA2,"UPCASE"), $	    IF CONFIG_FTP_CLIENT .EQS. "MULTINET"  $	    THEN  ! $		CONFIG_FTP_CLIENT = "MultiNet" " $		CONFIG_COMMAND = "MULTINET FTP" $		VALID_RECORD = TRUE5 $               FTP_CLIENT_STRU_VMS = "STRUCTURE VMS" - $               FTP_CLIENT_TYPE_CMD = "TYPE "@ $	    ENDIF , $	    IF CONFIG_FTP_CLIENT .EQS. "MADGOAT" -4 	       .OR. CONFIG_FTP_CLIENT .EQS. "MADGOAT_FTP" -2 		.OR. CONFIG_FTP_CLIENT .EQS. "HGFTP"									!HG $	    THEN t+ $		CONFIG_FTP_CLIENT = "HGFTP"										!HGo $		CONFIG_COMMAND = "FTP"m $		VALID_RECORD = TRUE9 $               FTP_CLIENT_STRU_VMS = "SET STRUCTURE VMS"a1 $               FTP_CLIENT_TYPE_CMD = "SET TYPE "f $	    ENDIFid $	    IF (CONFIG_FTP_CLIENT .EQS. "TCPWARE") .OR. (CONFIG_FTP_CLIENT .EQS. "PROCESS_SOFTWARE")			!DM
 $	    THEN  $		CONFIG_FTP_CLIENT = "TCPware" $		CONFIG_COMMAND = "FTP". $		VALID_RECORD = TRUE5 $               FTP_CLIENT_STRU_VMS = "STRUCTURE VMS" - $               FTP_CLIENT_TYPE_CMD = "TYPE "e $	    ENDIF>] $	    IF (CONFIG_FTP_CLIENT .EQS. "TCPIP") .OR. (CONFIG_FTP_CLIENT .EQS. "UCX") .OR. -				!DMy6 	       (CONFIG_FTP_CLIENT .EQS. "COMPAQ")									!DM $	    THEN													!DM+ $		CONFIG_FTP_CLIENT = "TCPIP"										!DM1' $		CONFIG_COMMAND = "FTP"											!DMn$ $		VALID_RECORD = TRUE											!DM7 $               FTP_CLIENT_STRU_VMS = "ENABLE VMS_PLUS"e1 $               FTP_CLIENT_TYPE_CMD = "SET TYPE "l $	    ENDIF													!DMk $	ENDIF  $t $	IF PARA1 .EQS. "FTP_SERVER"  $	THEN0 $	    CONFIG_FTP_SERVER = F$EDIT(PARA2,"UPCASE")2 $	    IF CONFIG_FTP_SERVER .EQS. "MULTINET" THEN -& 	       CONFIG_FTP_SERVER = "MultiNet", $	    IF CONFIG_FTP_SERVER .EQS. "MADGOAT" -4 	       .OR. CONFIG_FTP_SERVER .EQS. "MADGOAT_FTP" -4 		.OR. CONFIG_FTP_SERVER .EQS. "HGFTP" -									!HG5 	       THEN CONFIG_FTP_SERVER = "HGFTP"										!HGnj $	    IF (CONFIG_FTP_SERVER .EQS. "TCPWARE") .OR. (CONFIG_FTP_SERVER .EQS. "PROCESS_SOFTWARE") THEN -		!DM% 	       CONFIG_FTP_SERVER = "TCPware"a. $	    IF CONFIG_FTP_SERVER .EQS. "UNIX" THEN -" 	       CONFIG_FTP_SERVER = "Unix"8 $           IF (CONFIG_FTP_SERVER .EQS. "TCPIP") .OR. - 7                (CONFIG_FTP_SERVER .EQS. "UCX")   .OR. - 1 	       (CONFIG_FTP_SERVER .EQS. "COMPAQ") THEN -o# 	       CONFIG_FTP_SERVER = "TCPIP"t $	    VALID_RECORD = TRUEg $	ENDIF  $   $	IF PARA1 .EQS. "FILE_TRANSFER" $	THEN3 $	    CONFIG_FILE_TRANSFER = F$EDIT(PARA2,"UPCASE")E $	    VALID_RECORD = TRUEi $	ENDIF  $b! $	IF PARA1 .EQS. "LAST_TIME_FILE"f $	THEN4 $	    CONFIG_LAST_TIME_FILE = F$EDIT(PARA2,"UPCASE")1 $	    IF F$SEARCH(CONFIG_LAST_TIME_FILE) .NES. ""T
 $	    THEN( $		OPEN/READ FOO 'CONFIG_LAST_TIME_FILE' $		READ FOO CONFIG_LAST_TIME= $		CONFIG_LAST_TIME = F$CVTIME(CONFIG_LAST_TIME,"COMPARISON")0 $		CLOSE FOO
 $	    ELSE" $		CONFIG_LAST_TIME = "1-JAN-1900" $	    ENDIF ? $	    ! We remove oen day just to make sure we get all files ini= $	    ! spite of all kinds of timezone junk.  So we might get ( $	    ! duplicates at times...  So what?3 $	    CONFIG_NEXT_TIME = F$CVTIME("-1-","ABSOLUTE")a $	    VALID_RECORD = TRUE  $	ENDIFi $  $	IF PARA1 .EQS. "MAILTO"  $	THEN, $	    CONFIG_MAILTO = F$EDIT(PARA2,"UPCASE") $	    VALID_RECORD = TRUE  $	ENDIFT $c. $	IF PARA1 .EQS. "MAXIMUM_FILES"											!DM $	THEN														!DMnH $	    CONFIG_MAXIMUM_FILES = F$INTEGER(F$EDIT(PARA2,"UPCASE"))							!DM( $	    VALID_RECORD = TRUE												!DM $	ENDIF														!DM $															!DMh' $	IF PARA1 .EQS. "PURGE"												!HGs $	THEN														!HG 7 $	    CONFIG_PURGE = F$EDIT(PARA2,"UPCASE")									!HGs( $	    VALID_RECORD = TRUE												!HG $	ENDIF														!HG $i/ $	IF PARA1 .EQS. "SPLIT_DIRECTORY"										!DMi $	THEN														!DM_@ $	    CONFIG_SPLIT_DIRECTORY = F$EDIT(PARA2,"UPCASE")								!DM( $	    VALID_RECORD = TRUE												!DM $	ENDIF														!DM $															!DM92 $	IF PARA1 .EQS. "SPLIT_SUBMIT_AFTER"										!DM $	THEN														!DMnC $	    CONFIG_SPLIT_SUBMIT_AFTER = F$EDIT(PARA2,"UPCASE")								!DMt( $	    VALID_RECORD = TRUE												!DM $	ENDIF														!DM $															!DM & $	IF PARA1 .EQS. "TYPE"												!DM $	THEN														!DMw9 $	    CONFIG_TYPE_'CONFIG_TYPE_TOTAL' = PARA2									!DMiA $	    CONFIG_TYPE_TRANSFER_'CONFIG_TYPE_TOTAL' = PARA3								!DMi2 $	    IF (PARA3 .EQS. "ASCII") .OR. -										!DM2 	       (PARA3 .EQS. "BINARY") .OR. -										!DM) 	       (PARA3 .EQS. "VMS")											!DMa $	    THEN													!DM7 $		CONFIG_TYPE_TOTAL = CONFIG_TYPE_TOTAL + 1								!DMs$ $		VALID_RECORD = TRUE											!DM $	    ENDIF													!DMm $	ENDIF														!DM $															!DMv# $	IF PARA1 .EQS. "NAME"												h $	THEN														6 $	    CONFIG_NAME_'CONFIG_NAME_TOTAL' = PARA2									> $	    CONFIG_NAME_TRANSFER_'CONFIG_NAME_TOTAL' = PARA3								/ $	    IF (PARA3 .EQS. "ASCII") .OR. -										f/ 	       (PARA3 .EQS. "BINARY") .OR. -										 & 	       (PARA3 .EQS. "VMS")											 $	    THEN													e4 $		CONFIG_NAME_TOTAL = CONFIG_NAME_TOTAL + 1								! $		VALID_RECORD = TRUE											  $	    ENDIF													 $	ENDIF														y $															!DMs1 $	IF PARA1 .EQS. "DEREFERENCE_LINKS"										!DMf $	THEN														!DMn9 $	    CONFIG_DEREFERENCE_LINKS_PRESENT = TRUE									!DMeB $	    CONFIG_DEREFERENCE_LINKS = F$EDIT(PARA2,"UPCASE")								!DM( $	    VALID_RECORD = TRUE												!DM $	ENDIF														!DM $															!DM / $	IF PARA1 .EQS. "TRANSFER_FILES"											!DM  $	THEN														!DMc6 $	    CONFIG_TRANSFER_FILES_PRESENT = TRUE									!DM? $	    CONFIG_TRANSFER_FILES = F$EDIT(PARA2,"UPCASE")								!DM ( $	    VALID_RECORD = TRUE												!DM $	ENDIF														!DM $!7 $	IF PARA1 .EQS. "SWITCH_FROM_UNIX_LS_MODE"									!HG  $	THEN														!HGa9 $	    CONFIG_FILE_SWITCH_FROM_UNIX_LS = TRUE										!HG ( $	    VALID_RECORD = TRUE												!HG $	ENDIF														!HG $															!HGd $	IF .NOT. VALID_RECORDt $	THENU $	    WRITE SYS$OUTPUT "%%Warning - invalid configuration file record \", RECORD, "\".! $	    VALID_CONFIGURATION = FALSEm $	ENDIFi $t $	GOTO _CONFIG_LOOPh $  aG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!c $ _EXIT_CONFIG_LOOP: w $	CLOSE FILE $i $	IF .NOT. VALID_CONFIGURATION $	THEN5 $	    WRITE SYS$OUTPUT "Error in configuration file."  $	    GOTO _EXIT $	ENDIFn $s $	FTP_CLIENT_TYPE = TYPE_OTHER. $	IF CONFIG_FTP_CLIENT .EQS. "MultiNet" THEN -# 	   FTP_CLIENT_TYPE = TYPE_MULTINETa1 $	IF CONFIG_FTP_CLIENT .EQS. "MadGoat FTP" THEN - . 	   FTP_CLIENT_TYPE = TYPE_HGFTP											!HG7 $	IF CONFIG_FTP_CLIENT .EQS. "HGFTP" THEN -									!HGi. 	   FTP_CLIENT_TYPE = TYPE_HGFTP											!HG- $	IF CONFIG_FTP_CLIENT .EQS. "TCPware" THEN - " 	   FTP_CLIENT_TYPE = TYPE_TCPWARE7 $	IF CONFIG_FTP_CLIENT .EQS. "TCPIP" THEN -									!DMr. 	   FTP_CLIENT_TYPE = TYPE_TCPIP											!DM $  $	FTP_SERVER_TYPE = TYPE_OTHER. $	IF CONFIG_FTP_SERVER .EQS. "MultiNet" THEN -# 	   FTP_SERVER_TYPE = TYPE_MULTINETh1 $	IF CONFIG_FTP_SERVER .EQS. "MadGoat FTP" THEN - . 	   FTP_SERVER_TYPE = TYPE_HGFTP											!HG7 $	IF CONFIG_FTP_SERVER .EQS. "HGFTP" THEN -									!HGy. 	   FTP_SERVER_TYPE = TYPE_HGFTP											!HG- $	IF CONFIG_FTP_SERVER .EQS. "TCPware" THEN -h" 	   FTP_SERVER_TYPE = TYPE_TCPWARE* $	IF CONFIG_FTP_SERVER .EQS. "Unix" THEN - 	   FTP_SERVER_TYPE = TYPE_UNIXi+ $	IF CONFIG_FTP_SERVER .EQS. "TCPIP" THEN -u  	   FTP_SERVER_TYPE = TYPE_TCPIP $i $	WRITE SYS$OUTPUT "" B $	WRITE SYS$OUTPUT F$FAO("  !40AS !AS","Remote site:",CONFIG_SITE)J $	WRITE SYS$OUTPUT F$FAO("  !40AS !AS","Remote username:",CONFIG_USERNAME)J $	WRITE SYS$OUTPUT F$FAO("  !40AS !AS","Remote password:",CONFIG_PASSWORD)G $	WRITE SYS$OUTPUT F$FAO("  !40AS !AS","FTP server:",CONFIG_FTP_SERVER)p $	WRITE SYS$OUTPUT ""uD $	WRITE SYS$OUTPUT "  Directories:  (remote)                (local)" $t $	COUNT = 0A $ _DISPLAY_LOOP_1:  ? $	IF COUNT .GE. CONFIG_DIR_TOTAL THEN GOTO _EXIT_DISPLAY_LOOP_1n- $	WRITE SYS$OUTPUT F$FAO("    !33AS !35AS", -a8 			       F$ELEMENT(0,",",CONFIG_DIRECTORIES_'COUNT'), -6 			       F$ELEMENT(1,",",CONFIG_DIRECTORIES_'COUNT'))S $	IF F$PARSE(F$ELEMENT(1,",",CONFIG_DIRECTORIES_'COUNT'),,,,"SYNTAX_ONLY") .EQS. ""r $	THEN` $	    WRITE SYS$ERROR F$FAO("!5** Local directory specification (above) is invalid VMS syntax.")! $	    VALID_CONFIGURATION = FALSEv $	ENDIFh $	COUNT = COUNT + 1  $	GOTO _DISPLAY_LOOP_1 $ _EXIT_DISPLAY_LOOP_1:  $															!DM $ $	WRITE SYS$OUTPUT ""												!DMT $	WRITE SYS$OUTPUT "  Type Mappings:(extension)             (Transfer type)"					!DM $															!DMv $	COUNT = 0													!DM8' $ _TYPE_DISPLAY_LOOP_1:													!DM@N $	IF COUNT .GE. CONFIG_TYPE_TOTAL THEN GOTO _EXIT_TYPE_DISPLAY_LOOP_1						!DM9 $	WRITE SYS$OUTPUT F$FAO("    !33AS !10AS", -									!DM@, 			       CONFIG_TYPE_'COUNT', -									!DM2 			       CONFIG_TYPE_TRANSFER_'COUNT')								!DM" $	COUNT = COUNT + 1												!DM) $	GOTO _TYPE_DISPLAY_LOOP_1											!DMw+ $ _EXIT_TYPE_DISPLAY_LOOP_1:												!DMe $															! $	WRITE SYS$OUTPUT ""												tQ $	WRITE SYS$OUTPUT "  Name Mappings:                        (Transfer type)"					  $															 $	COUNT = 0													$ $ _NAME_DISPLAY_LOOP_1:													K $	IF COUNT .GE. CONFIG_NAME_TOTAL THEN GOTO _EXIT_NAME_DISPLAY_LOOP_1						 6 $	WRITE SYS$OUTPUT F$FAO("    !33AS !10AS", -									) 			       CONFIG_NAME_'COUNT', -									a/ 			       CONFIG_NAME_TRANSFER_'COUNT')								n $	COUNT = COUNT + 1												m& $	GOTO _NAME_DISPLAY_LOOP_1											( $ _EXIT_NAME_DISPLAY_LOOP_1:												 $															 $	WRITE SYS$OUTPUT ""sG $	WRITE SYS$OUTPUT F$FAO("  !40AS !AS","FTP client:",CONFIG_FTP_CLIENT) E $	WRITE SYS$OUTPUT F$FAO("  !40AS !AS","DCL command:",CONFIG_COMMAND)tR $	WRITE SYS$OUTPUT F$FAO("  !40AS !AS","File transfer mode:",CONFIG_FILE_TRANSFER) $	IF CONFIG_PASSIVE  $	THEN $	    CONFIG_PASSIVE = TRUEiA $	    WRITE SYS$OUTPUT F$FAO("  !40AS !AS","Passive mode:","Yes")  $	ELSE $	    CONFIG_PASSIVE = FALSE@ $	    WRITE SYS$OUTPUT F$FAO("  !40AS !AS","Passive mode:","No") $	ENDIF % $	IF CONFIG_LAST_TIME .NES. "" THEN -u* 	   WRITE SYS$OUTPUT F$FAO("  !40AS !AS",-' 				  "Only get files created after:",-  				  CONFIG_LAST_TIME)a: $	WRITE SYS$OUTPUT F$FAO("  !40AS !AS","Resubmit after:",- 			       CONFIG_SUBMIT_AFTER), $	IF CONFIG_SUBMIT_AFTER .NES. "NONE" THEN -E 	   WRITE SYS$OUTPUT F$FAO("  !40AS !AS","Batch queue:",CONFIG_QUEUE)h" $	IF CONFIG_MAILTO .NES. "" THEN -* 	   WRITE SYS$OUTPUT F$FAO("  !40AS !AS",- 				  "Mail reports to:",- 				  CONFIG_MAILTO)< $	IF CONFIG_MAXIMUM_FILES .NE. %X7FFFFFFF THEN -									!DM6 	   WRITE SYS$OUTPUT F$FAO("  !40AS !UL",-									!DM7 				  "Maximum number of files to transfer:",-						!DM!' 				  CONFIG_MAXIMUM_FILES)									!DM 7 $	IF CONFIG_SPLIT_DIRECTORY .NES. "" THEN -									!DM 6 	   WRITE SYS$OUTPUT F$FAO("  !40AS !AS",-									!DM. 				  "Split transfer directory:",-								!DM( 				  CONFIG_SPLIT_DIRECTORY)								!DM: $	IF CONFIG_SPLIT_SUBMIT_AFTER .NES. "" THEN -									!DM6 	   WRITE SYS$OUTPUT F$FAO("  !40AS !AS",-									!DM/ 				  "Split transfer submit time:",-							!DM"+ 				  CONFIG_SPLIT_SUBMIT_AFTER)								!DM . $	IF CONFIG_DEBUG_PRESENT THEN -											!DM6 	   WRITE SYS$OUTPUT F$FAO("  !40AS !AS",-									!DM 				  "Debug:",-										!DMP" 				  F$STRING(DEBUG))									!DM8 $	IF CONFIG_DEREFERENCE_LINKS_PRESENT THEN -									!DM6 	   WRITE SYS$OUTPUT F$FAO("  !40AS !AS",-									!DM' 				  "Dereference links:",-								!DM 3 				  F$STRING(CONFIG_DEREFERENCE_LINKS))							!DM 6 $	IF CONFIG_TRANSFER_FILES_PRESENT THEN -										!DM6 	   WRITE SYS$OUTPUT F$FAO("  !40AS !AS",-									!DM% 				  "Transfer files:",-									!DME0 				  F$STRING(CONFIG_TRANSFER_FILES))							!DM $	WRITE SYS$OUTPUT ""  $N> $	IF CONFIG_SITE .EQS. "" .OR. CONFIG_USERNAME .EQS. "" .OR. -F 	   CONFIG_PASSWORD .EQS. "" .OR. CONFIG_DIRECTORIES_0 .EQS. "" .OR. -  	   CONFIG_SUBMIT_AFTER .EQS. "" $	THENH $	    WRITE SYS$ERROR "Missing required configuration setting; exiting."Y $	    WRITE SYS$ERROR "Check for missing username, directory, password, or submit-after."  $	    GOTO _EXIT $	ENDIFO $G) $	IF FTP_CLIENT_TYPE .NE. TYPE_MULTINET -F7 	   .AND. FTP_CLIENT_TYPE .NE. TYPE_HGFTP -									!HG 9 	   .AND. FTP_CLIENT_TYPE .NE. TYPE_TCPWARE -									!DMX5 	   .AND. FTP_CLIENT_TYPE .NE. TYPE_TCPIP									!DM_ $	THENs $	    WRITE SYS$ERROR "Invalid FTP Client -- only \MULTINET\, \TCPWARE\, \Compaq TCPIP or \HGFTP\ are allowed."	!HGF $	    GOTO _EXIT $	ENDIF" $	E $	IF CONFIG_PASSIVE .AND. (FTP_CLIENT_TYPE .EQ. TYPE_TCPIP)							!DMO $	THEN														!DM ` $	    WRITE SYS$ERROR "PASSIVE isn't supported by the Compaq TCPIP FTP client or server."				!DM  $	    GOTO _EXIT													!DM $	ENDIF														!DM $ ) $	IF FTP_SERVER_TYPE .NE. TYPE_MULTINET -Y7 	   .AND. FTP_SERVER_TYPE .NE. TYPE_HGFTP -									!HG - 	   .AND. FTP_SERVER_TYPE .NE. TYPE_TCPWARE -C* 	   .AND. FTP_SERVER_TYPE .NE. TYPE_UNIX -) 	   .AND. FTP_SERVER_TYPE .NE. TYPE_TCPIPR $	THENv $	    WRITE SYS$ERROR "Invalid FTP Server.  Only MultiNet, HGFTP, TCPware, Compaq TCPIP, and UNIX are supported."		!HG $	    GOTO _EXIT $	ENDIF+ $G $	IF .NOT. VALID_CONFIGURATION $	THENA $	    WRITE SYS$ERROR "Invalid configuration -- see above reason"O $	    GOTO _EXIT $	ENDIFF $DG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!A $ ! $	IF F$MODE() .EQS. "INTERACTIVE"	 $	THEND $	    READ SYS$COMMAND CHECK/PROMPT="Ready [Y]? "/END_OF_FILE=_ABORT $	ELSE $	    CHECK := Y $	ENDIFu $C6 $	IF .NOT. CHECK .AND. CHECK .NES. "" THEN GOTO _ABORT $ G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $! $l $aG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!F $R $	GOSUB _SUBMIT													!DMC $!C $! The SUBMIT command sets the variable $ENTRY to the entry number.OB $! This is used on the exit from the batch processing to give us a $! "real" timer. $!B $	IF CONFIG_SUBMIT_AFTER .NES. "NONE" .AND. F$MODE() .NES. "BATCH" $	THEN $	    GOTO _EXIT $	ENDIFO $          U3 $	IF (CONFIG_SPLIT_DIRECTORY .NES. "")										!DMF $	THEN														!DMOf $	    IF F$PARSE(CONFIG_SPLIT_DIRECTORY) .EQS. "" THEN CREATE/DIRECTORY 'CONFIG_SPLIT_DIRECTORY'			!DMG $	    IF F$SEARCH(CONFIG_SPLIT_DIRECTORY + "*.*;-0") .NES. ""							!DM  $	    THEN													!DM@ $		XXX = F$SEARCH(CONFIG_SPLIT_DIRECTORY + "*.TMP;-0")							!DM5 $		YYY = F$SEARCH(F$PARSE(".COM;-0",XXX))									!DMO5 $		IF (XXX .NES. "") .AND. (YYY .NES. "")									!DMN $		THEN													!DM.( $			COPY 'XXX' 'TEMPFILE_5'										!DM $			DELETE 'XXX'											!DM $			@'YYY'												!DMP $			DELETE 'YYY'											!DMG $			IF DEBUG THEN WRITE SYS$ERROR "-Debug- Global Symbol Table"					!DM / $			IF DEBUG THEN WRITE SYS$ERROR ""								!DMA1 $			IF DEBUG THEN SHOW SYMBOL/GLOBAL *								!DM") $			GOTO _SPLIT_FILE_TRANSFER									!DME $		ELSE													!DMD3 $			DELETE 'CONFIG_SPLIT_DIRECTORY'*.*;*								!DM  $		ENDIF													!DM $	    ENDIF													!DMS $	ENDIF														!DM $															!DMIG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!P1 $!  Obtain the list of files on the remote systemEG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!	 $ ) $	OPEN/WRITE/SHARE=READ FILE 'TEMPFILE_1'R $.' $	IF FTP_CLIENT_TYPE .EQ. TYPE_MULTINETG $	THEN $	    IF CONFIG_PASSIVE'" $	    THEN WRITE FILE "PASSIVE ON"# $	    ELSE WRITE FILE "PASSIVE OFF"  $	    ENDIFA# $	    WRITE FILE "EXIT-ON-ERROR ON" 3 $	    WRITE FILE "PROMPT-FOR-MISSING-ARGUMENTS OFF"=( $	    WRITE FILE "VERBOSE"											!DM+ $	    IF DEBUG THEN WRITE FILE "STATISTICS"2( $	    WRITE FILE "CONNECT ", CONFIG_SITE) $	    WRITE FILE "USER ", CONFIG_USERNAME ) $	    WRITE FILE "PASS ", CONFIG_PASSWORDQ) $	    IF CONFIG_FILE_TRANSFER .EQS. "VMS"	
 $	    THEN $		WRITE FILE "STRUCTURE VMS"L
 $	    ELSE+ $		WRITE FILE "TYPE ", CONFIG_FILE_TRANSFER! $	    ENDIFIE $	    IF CONFIG_FILE_SWITCH_FROM_UNIX_LS THEN WRITE FILE "CD []"		!HG	 $	    WRITE FILE "PWD" $	ENDIF  ! multinetI $	1 $	IF FTP_CLIENT_TYPE .EQ. TYPE_HGFTP										!HG  $	THEN $	    WRITE FILE "SET BATCH" $	    IF CONFIG_PASSIVE # $	    THEN WRITE FILE "SET PASSIVE" % $	    ELSE WRITE FILE "SET NOPASSIVE"" $	    ENDIF	) $	    IF CONFIG_FILE_TRANSFER .EQS. "VMS"R
 $	    THEN! $		WRITE FILE "SET STRUCTURE VMS"M
 $	    ELSE/ $		WRITE FILE "SET TYPE ", CONFIG_FILE_TRANSFERT $	    ENDIF E $	    IF CONFIG_FILE_SWITCH_FROM_UNIX_LS THEN WRITE FILE "CD []"		!HGI $	    WRITE FILE "PWD" $	ENDIF  ! hgftp $N& $	IF FTP_CLIENT_TYPE .EQ. TYPE_TCPWARE $	THEN $	    IF CONFIG_PASSIVEE# $	    THEN WRITE FILE "SET PASSIVE"_% $	    ELSE WRITE FILE "SET NOPASSIVE"E $	    ENDIF 8 $	    IF DEBUG THEN WRITE FILE "SET DEBUG/CLASS=REPLIES"0 $	    WRITE FILE "CONNECT ", CONFIG_SITE, " ", -) 		  CONFIG_USERNAME, " ", CONFIG_PASSWORDP) $	    IF CONFIG_FILE_TRANSFER .EQS. "VMS"S
 $	    THEN $		WRITE FILE "STRUCTURE VMS"T
 $	    ELSE+ $		WRITE FILE "TYPE ", CONFIG_FILE_TRANSFERD $	    ENDIFEE $	    IF CONFIG_FILE_SWITCH_FROM_UNIX_LS THEN WRITE FILE "CD []"		!HG  $	    WRITE FILE "PWD" $	ENDIF  ! tcpware $ 1 $	IF FTP_CLIENT_TYPE .EQ. TYPE_TCPIP										!DMN $	THEN														!DM"= $           IF DEBUG THEN WRITE FILE "ENABLE LOG"									!DM	6 $	    IF CONFIG_FILE_TRANSFER .EQS. "VMS"										!DM $	    THEN													!DM, $		WRITE FILE "ENABLE VMS_PLUS"										!DM $	    ELSE													!DM: $		WRITE FILE "SET TYPE ", CONFIG_FILE_TRANSFER								!DM $	    ENDIF													!DMTE $	    IF CONFIG_FILE_SWITCH_FROM_UNIX_LS THEN WRITE FILE "CD []"		!HG	- $	    WRITE FILE "SHOW DEFAULT"											!DMF+ $	ENDIF  ! Compaq TCPIP / UCX											!DM  $  $	COUNT = 0V $ _GEN_FILE_LOOP: > $	IF COUNT .GE. CONFIG_DIR_TOTAL THEN GOTO _EXIT_GEN_FILE_LOOP> $	DIRECTORY_NAME = F$ELEMENT(0,",",CONFIG_DIRECTORIES_'COUNT')3 $	DIRECTORY_NAME2 = DIRECTORY_NAME - "/..." - "..."G[ $	WRITE FILE "SPAWN WRITE SYS$OUTPUT ""<<<REMOTE_DIRECTORY ",DIRECTORY_NAME2,">>>"""				!DMF0 $	IF FTP_SERVER_TYPE .EQ. TYPE_UNIX										!DM $	THEN														!DM) $	    XXX = "l"													!DMSA $	    IF CONFIG_DEREFERENCE_LINKS THEN XXX = XXX + "L"								!DM $ $	    XXX = XXX + " "												!DMV $	    IF F$EXTRACT(F$LENGTH(DIRECTORY_NAME)-4, 4, DIRECTORY_NAME) .EQS. "/..."					!DMg $	    THEN DIRECTORY_NAME = "-R" + XXX + F$EXTRACT(0, F$LENGTH(DIRECTORY_NAME)-4, DIRECTORY_NAME)			!DM A $	    ELSE DIRECTORY_NAME = "-" + XXX + DIRECTORY_NAME								!DM. $	    ENDIF													!DM  $	ENDIF														!DM7 $	WRITE FILE "DIR """, DIRECTORY_NAME, """"									!DMI $	COUNT = COUNT + 1Q $	GOTO _GEN_FILE_LOOP	 $N $ _EXIT_GEN_FILE_LOOP: F $	WRITE FILE "EXIT"P $	CLOSE FILEA $	IF DEBUG THEN WRITE SYS$ERROR "-Debug- Contents of input file:"E2 $	IF DEBUG THEN TYPE/OUTPUT=SYS$ERROR 'TEMPFILE_1' $_H $	IF DEBUG THEN WRITE SYS$ERROR "-Debug- Connecting to remote system..."A $!RL$	IF F$SEARCH(TEMPFILE_2) .NES. "" THEN DELETE 'TEMPFILE_2';*I% $!RL$	TYPE NLA0: /OUTPUT='TEMPFILE_2'a+ $!RL$	SET FILE/VERSION_LIMIT=0 'TEMPFILE_2'fA $!RL$	IF F$SEARCH(TEMPFILE_4) .NES. "" THEN DELETE 'TEMPFILE_4';*a% $!RL$	TYPE NLA0: /OUTPUT='TEMPFILE_4'_+ $!RL$	SET FILE/VERSION_LIMIT=0 'TEMPFILE_4'IW $	IF .NOT. DEBUG .AND. F$SEARCH(TEMPFILE_3) .NES. "" THEN DELETE 'TEMPFILE_3';*					!DM  $D2 $	OLD_SYMBOL_SCOPE = F$ENVIRONMENT("SYMBOL_SCOPE")! $	SET SYMBOL/SCOPE=(GLOBAL,LOCAL)_ $E, $!RL$	IF DEBUG THEN SHOW LOG SYS$OUTPUT/FULL $ ' $ _RETRY_GEN_FILE_LIST:													!DMA $,' $	IF FTP_CLIENT_TYPE .EQ. TYPE_MULTINET= $	THEN $	    SET noON) $!RL$	    OPEN/WRITE FTP_DIR 'TEMPFILE_2'h( $!RL$	    DEFINE SYS$OUTPUT 'TEMPFILE_4'$ $	    DEFINE SYS$OUTPUT 'TEMPFILE_3' $	    'CONFIG_COMMAND' - 		  /NOINITIALIZATION -  		  /TAKE_FILE='TEMPFILE_1'	 $	    STATUS = $STATUS $	    DEASSIGN SYS$OUTPUTQ $!RL$	    CLOSE FTP_DIR	 $	    SET ON $	ENDIF	 $	$ $	IF FTP_CLIENT_TYPE .EQ. TYPE_HGFTP $	THEN $	    SET noON) $!RL$	    OPEN/WRITE FTP_DIR 'TEMPFILE_2'	( $!RL$	    DEFINE SYS$OUTPUT 'TEMPFILE_4'$ $	    DEFINE SYS$OUTPUT 'TEMPFILE_3' $	    'CONFIG_COMMAND' - 		  'CONFIG_SITE' -	$ 		  /USERNAME="''CONFIG_USERNAME'" -$ 		  /PASSWORD="''CONFIG_PASSWORD'" -  		  /INITIALIZATION='TEMPFILE_1' $	    STATUS = $STATUS $	    DEASSIGN SYS$OUTPUT	 $!RL$	    CLOSE FTP_DIRY $	    SET noON $	ENDIFN $	& $	IF FTP_CLIENT_TYPE .EQ. TYPE_TCPWARE $	THEN $	    SET noON) $!RL$	    OPEN/WRITE FTP_DIR 'TEMPFILE_2'F( $!RL$	    DEFINE SYS$OUTPUT 'TEMPFILE_4'$ $	    DEFINE SYS$OUTPUT 'TEMPFILE_3'6 $	    DEFINE/USER FTP_STARTUP 'TEMPFILE_1'									!DM $	    'CONFIG_COMMAND' $	    STATUS = $STATUS $	    DEASSIGN SYS$OUTPUT  $!RL$	    CLOSE FTP_DIRN $	    SET noON $	ENDIF	 $s1 $	IF FTP_CLIENT_TYPE .EQ. TYPE_TCPIP										!DM	 $	THEN														!DM	 $	    SET noON													!DM1 $	    DEFINE SYS$OUTPUT 'TEMPFILE_3'										!DMN' $	    'CONFIG_COMMAND' -												!DM_! 		  'CONFIG_SITE' -											!DM 0 		  /USERNAME="''CONFIG_USERNAME'" -									!DM0 		  /PASSWORD="''CONFIG_PASSWORD'" -									!DM% 		  /INPUT='TEMPFILE_1'											!DM.% $	    STATUS = $STATUS												!DM"( $	    DEASSIGN SYS$OUTPUT												!DM $	    SET noON													!DM $	ENDIF														!DM $															!DM	' $	SET SYMBOL/SCOPE=('OLD_SYMBOL_SCOPE')N $	A $!RL$	IF F$SEARCH(TEMPFILE_3) .NES. "" THEN DELETE 'TEMPFILE_3';*_= $!RL$	COPY/CONCATENATE 'TEMPFILE_4','TEMPFILE_2' 'TEMPFILE_3'RB $	IF DEBUG THEN WRITE SYS$ERROR "-Debug- Output from FTP session:"2 $	IF DEBUG THEN TYPE/OUTPUT=SYS$ERROR 'TEMPFILE_3' $_% $!DM	IF .NOT. STATUS THEN GOTO _ERROR	 $	G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!	C $! Determine which files we will need to get from the remote systemNG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!) $	 $	OPEN/READ FILE 'TEMPFILE_3'T, $	OPEN/WRITE/SHARE=READ OUTFILE 'TEMPFILE_5'& $	LOCAL_LINK_INDEX = -1												!DM* $	LOCAL_DIRECTORY_INDEX = -1											!DM $ W $!	IF .NOT. DEBUG .AND. F$SEARCH(TEMPFILE_1) .NES. "" THEN DELETE 'TEMPFILE_1';					!DM	 $	  $	SPLIT_FILE = 0													!DM $	 $ _SPLIT_TRANSFER_FILE:O $V' $	IF FTP_CLIENT_TYPE .EQ. TYPE_MULTINETP $	THEN7 $	    IF CONFIG_PASSIVE THEN WRITE OUTFILE "PASSIVE ON".& $	    WRITE OUTFILE "EXIT-ON-ERROR ON"6 $	    WRITE OUTFILE "PROMPT-FOR-MISSING-ARGUMENTS OFF"+ $	    WRITE OUTFILE "VERBOSE"											!DM!. $	    IF DEBUG THEN WRITE OUTFILE "STATISTICS"+ $	    WRITE OUTFILE "CONNECT ", CONFIG_SITE , $	    WRITE OUTFILE "USER ", CONFIG_USERNAME, $	    WRITE OUTFILE "PASS ", CONFIG_PASSWORD) $	    IF CONFIG_FILE_TRANSFER .EQS. "VMS"_
 $	    THEN  $		WRITE OUTFILE "STRUCTURE VMS"
 $	    ELSE. $		WRITE OUTFILE "TYPE ", CONFIG_FILE_TRANSFER $	    ENDIF H $	    IF CONFIG_FILE_SWITCH_FROM_UNIX_LS THEN WRITE OUTFILE "CD []"		!HG $	    WRITE OUTFILE "PWD"	4 $	    WRITE OUTFILE "EXIT-ON-ERROR OFF"										!DM $	ENDIFI $T$ $	IF FTP_CLIENT_TYPE .EQ. TYPE_HGFTP $	THEN $	    WRITE OUTFILE "SET BATCH"I) $	    IF CONFIG_FILE_TRANSFER .EQS. "VMS"D
 $	    THEN$ $		WRITE OUTFILE "SET STRUCTURE VMS"
 $	    ELSE2 $		WRITE OUTFILE "SET TYPE ", CONFIG_FILE_TRANSFER $	    ENDIF H $	    IF CONFIG_FILE_SWITCH_FROM_UNIX_LS THEN WRITE OUTFILE "CD []"		!HG $	    WRITE OUTFILE "PWD"  $	ENDIFR $P& $	IF FTP_CLIENT_TYPE .EQ. TYPE_TCPWARE $	THEN8 $	    IF CONFIG_PASSIVE THEN WRITE OUTFILE "SET PASSIVE"; $	    IF DEBUG THEN WRITE OUTFILE "SET DEBUG/CLASS=REPLIES"C3 $	    WRITE OUTFILE "CONNECT ", CONFIG_SITE, " ", -	) 		  CONFIG_USERNAME, " ", CONFIG_PASSWORD ) $	    IF CONFIG_FILE_TRANSFER .EQS. "VMS"_
 $	    THEN  $		WRITE OUTFILE "STRUCTURE VMS"
 $	    ELSE. $		WRITE OUTFILE "TYPE ", CONFIG_FILE_TRANSFER $	    ENDIFOH $	    IF CONFIG_FILE_SWITCH_FROM_UNIX_LS THEN WRITE OUTFILE "CD []"		!HG $	    WRITE OUTFILE "PWD", $	ENDIF  ! tcpware $T1 $	IF FTP_CLIENT_TYPE .EQ. TYPE_TCPIP										!DM, $	THEN														!DM @ $           IF DEBUG THEN WRITE OUTFILE "ENABLE LOG"									!DM6 $	    IF CONFIG_FILE_TRANSFER .EQS. "VMS"										!DM $	    THEN													!DM/ $		WRITE OUTFILE "ENABLE VMS_PLUS"										!DM  $	    ELSE													!DM= $		WRITE OUTFILE "SET TYPE ", CONFIG_FILE_TRANSFER								!DM" $	    ENDIF													!DM H $	    IF CONFIG_FILE_SWITCH_FROM_UNIX_LS THEN WRITE OUTFILE "CD []"		!HG/ $	    WRITE OUTFILE "SHOW DEFAULT"										!DME+ $	ENDIF  ! Compaq TCPIP / UCX											!DMN $															!DM  $	GET_FILE_COUNT = 0 $R $	LOCAL_DIRECTORY = "" $	LOCAL_FILENAME = ""a $	NOT_LOGGED_IN = 0s $	USER_SEEN = 0													!DMO $ _READ_FILE_LOOP:3 $	READ/END_OF_FILE=_EXIT_READ_FILE_LOOP FILE RECORDIA $	IF F$EDIT(RECORD,"COLLAPSE") .EQS. "" THEN GOTO _READ_FILE_LOOP	I $	IF DEBUG THEN WRITE SYS$ERROR F$FAO("-Debug- Record is: \!AS\", RECORD)a$ $	RECORD = F$EDIT(RECORD,"COMPRESS")H $	IF F$EXTRACT(0,1,RECORD) .EQS. "$" THEN GOTO _READ_FILE_LOOP							!DMH $	IF F$EXTRACT(0,1,RECORD) .EQS. "?" THEN GOTO _READ_FILE_LOOP							!DM $															!DM$< $	XXX = F$EDIT(F$ELEMENT(0," ",RECORD),"UPCASE")									!DM; $	IF XXX .EQS. "LIST" THEN GOTO _READ_FILE_LOOP									!DMR; $	IF XXX .EQS. "PORT" THEN GOTO _READ_FILE_LOOP									!DMO; $	IF XXX .EQS. "QUIT" THEN GOTO _READ_FILE_LOOP									!DML: $	IF XXX .EQS. "RUN" THEN GOTO _READ_FILE_LOOP									!DM< $	IF XXX .EQS. "TYPE:" THEN GOTO _READ_FILE_LOOP									!DM; $	IF XXX .EQS. "TYPE" THEN GOTO _READ_FILE_LOOP									!DMOA $       IF XXX .EQS. "--->" THEN GOTO _READ_FILE_LOOP									!DMUp $       IF XXX .EQS. "TOTAL" .AND. F$EDIT(F$ELEMENT(1," ",RECORD),"UPCASE") .EQS. "OF" THEN GOTO _READ_FILE_LOOP$ $	IF XXX .EQS. "USER"												!DM $	THEN														!DM " $	    USER_SEEN = 1												!DM( $	    GOTO _READ_FILE_LOOP											!DM $	ENDIF														!DM* $	IF F$EXTRACT(0,5,RECORD) .EQS. "<257 " -+ 	   .OR. F$EXTRACT(0,4,RECORD) .EQS. "257 "T $	THEN+ $	    REMOTE_ROOT = F$ELEMENT(1," ",RECORD)e_ $	    IF F$EXTRACT(0,1,REMOTE_ROOT) .EQS. """" THEN REMOTE_ROOT = F$ELEMENT(1,"""",REMOTE_ROOT) L $	    IF DEBUG THEN WRITE SYS$ERROR "-Debug- Remote root now: ", REMOTE_ROOT $	    GOTO _READ_FILE_LOOP $	ENDIF	 $ 9 $	IF ((F$EXTRACT(0,5,RECORD) .EQS. "<530 ") -									!DMAA 	   .OR. (F$EXTRACT(0,4,RECORD) .EQS. "530 ")) .AND. -								!DME 	   USER_SEEN													!DM" $	THEN														!DMe& $	    NOT_LOGGED_IN = 1												!DMN $	    IF DEBUG THEN WRITE SYS$ERROR "-Debug- Login at remote failed."						!DM- $	    GOTO _EXIT_READ_FILE_LOOP											!DME $	ENDIF														!DM $															!DMu. $	IF F$EXTRACT(0,10,RECORD) .EQS. "Directory " $	THEN I7 $	    RECORD = F$EXTRACT(10,F$LENGTH(RECORD)-10,RECORD)FR $	    IF DEBUG THEN WRITE SYS$ERROR F$FAO("-Debug- Record changed: \!AS\", RECORD) $	ENDIFTI $	IF F$EDIT(F$ELEMENT(0," ",RECORD),"UPCASE") .EQS. "<<<REMOTE_DIRECTORY"G& $!RL	   .AND. LOCAL_DIRECTORY .EQS. "" $	THEN $	    LOCAL_DIRECTORY = ""7 $	    RECORD = F$ELEMENT(0,">",F$ELEMENT(1," ",RECORD)) ' $	    IF FTP_SERVER_TYPE .EQ. TYPE_UNIX	
 $	    THEN $		RECORD = RECORD + ":"
 $	    ELSE* $!RL$		IF RECORD - ":" .EQS. RECORD THEN -4 $!RL		   RECORD = REMOTE_ROOT - "]" + (RECORD - "[") $		GOTO _READ_FILE_LOOPS $	    ENDIF R $	    IF DEBUG THEN WRITE SYS$ERROR F$FAO("-Debug- Record changed: \!AS\", RECORD) $	ENDIFA $R $	IF RECORD .EQS. ""  THEN - 	   GOTO _READ_FILE_LOOP       $	C = F$EXTRACT(0,1,RECORD) T $	IF C .EQS. "<" .OR. C .EQS. "%" .OR. C .EQS. "[" THEN GOTO _READ_FILE_LOOP					!DM+ $	IF FTP_SERVER_TYPE .EQ. TYPE_UNIX .AND. -	7 	   F$TYPE(C) .EQS. "INTEGER" THEN GOTO _READ_FILE_LOOP!+ $	IF FTP_SERVER_TYPE .EQ. TYPE_UNIX .AND. -T) 	   F$ELEMENT(0," ",RECORD) .EQS. "total"E $	THEN< $	    TMP3 = F$EDIT(RECORD - F$ELEMENT(0," ",RECORD),"TRIM")? $	    IF F$TYPE(TMP3) .EQS. "INTEGER" THEN GOTO _READ_FILE_LOOP  $	ENDIF$ $I1 $	IF FTP_SERVER_TYPE .EQ. TYPE_UNIX											!HGIy $	THEN	HAVE_A_DIR = (F$EXTRACT(0,1,RECORD) .EQS. "/") .AND. (F$LENGTH(RECORD) .NE. F$LENGTH(F$ELEMENT(0,":",RECORD)))	!HG:f $	ELSE	HAVE_A_DIR = F$LOCATE(":",F$ELEMENT(0," ",RECORD)) .NE. F$LENGTH(F$ELEMENT(0," ",RECORD))			!HG $	ENDIF															!HGI  $	IF HAVE_A_DIR														!HG $	THEN $	    ! we have a directoryR $	    LOCAL_DIRECTORY = ""' $	    IF FTP_SERVER_TYPE .EQ. TYPE_UNIX 
 $	    THEN- $		REMOTE_DIRECTORY = F$ELEMENT(0,":",RECORD)n/ $		IF F$EXTRACT(0,1,REMOTE_DIRECTORY) .NES. "/"s $		THENnK $		    IF F$EXTRACT(F$LENGTH(REMOTE_ROOT)-1,1,REMOTE_ROOT) .NES. "/" THEN - 2 		       REMOTE_DIRECTORY = "/" + REMOTE_DIRECTORY8 $		    REMOTE_DIRECTORY = REMOTE_ROOT + REMOTE_DIRECTORY $		ENDIFB $		IF F$EXTRACT(F$LENGTH(REMOTE_DIRECTORY)-1,1,REMOTE_DIRECTORY) - 		   .NES. "/" THEN -	. 		   REMOTE_DIRECTORY = REMOTE_DIRECTORY + "/"
 $	    ELSE- $		REMOTE_DIRECTORY = F$ELEMENT(0," ",RECORD)F $	    ENDIFeV $	    IF DEBUG THEN WRITE SYS$ERROR "-Debug- Remote directory now: ", REMOTE_DIRECTORY. $	    ! now we have to find it in our mappings $	    COUNT = 0Y $ _FIND_LOOP: > $	    IF COUNT .GE. CONFIG_DIR_TOTAL THEN GOTO _EXIT_FIND_LOOP7 $	    TMP = F$ELEMENT(0,",",CONFIG_DIRECTORIES_'COUNT')	' $	    IF FTP_SERVER_TYPE .EQ. TYPE_UNIXM
 $	    THEN" $		IF F$EXTRACT(0,1,TMP) .NES. "/" $		THEN	K $		    IF F$EXTRACT(F$LENGTH(REMOTE_ROOT)-1,1,REMOTE_ROOT) .NES. "/" THEN -V 		       TMP = "/" + TMP $		    TMP = REMOTE_ROOT + TMP $		ENDIF
 $	    ELSE* $		IF F$EXTRACT(0,2,TMP) .EQS. "[." THEN -? 		   TMP = F$EXTRACT(0,F$LENGTH(REMOTE_ROOT)-1,REMOTE_ROOT) + -. 		   F$EXTRACT(1,999,TMP)	) $		IF F$EXTRACT(0,1,TMP) .EQS. "[" THEN - - 		   TMP = F$ELEMENT(0,"[",REMOTE_ROOT) + TMPa $	    ENDIFbR $	    IF DEBUG THEN WRITE SYS$ERROR "-Debug- Remote directory to check for: ", TMP $	    ENDING = "...]"!; $	    IF FTP_SERVER_TYPE .EQ. TYPE_UNIX THEN ENDING = "..."	 $	    LE = F$LENGTH(ENDING)O- $	    IF F$EXTRACT(F$LENGTH(TMP)-LE,LE,TMP) -	 	       .EQS. ENDING
 $	    THEN8 $		TMP = F$EXTRACT(0,F$LENGTH(TMP)-F$LENGTH(ENDING),TMP); $		IF TMP .EQS. F$EXTRACT(0,F$LENGTH(TMP),REMOTE_DIRECTORY)! $		THEN  $		    ! we have a mappingD $		    LOCAL_DIRECTORY = F$ELEMENT(1,",",CONFIG_DIRECTORIES_'COUNT')a $		    IF DEBUG THEN WRITE SYS$ERROR "-Debug- Equivalent local directory: ", LOCAL_DIRECTORY		!DM O $		    IF F$EXTRACT(F$LENGTH(LOCAL_DIRECTORY)-4,4,LOCAL_DIRECTORY) .EQS. "...]"e $		    THENC $			!U- $			! If the remote directory has "changable"A- $			! characters in the "local" portion, trim , $			! the REMOTE_DIRECTORY now to avoid this $			! problem. $			!	^ $			TMP2 = F$EXTRACT(F$LENGTH(TMP)-(FTP_SERVER_TYPE .EQ. TYPE_UNIX),999,REMOTE_DIRECTORY)		!DM $!			TMP2 = REMOTE_DIRECTORY% $			IF FTP_SERVER_TYPE .EQ. TYPE_UNIX" $			THENb $			    ALLOWED_CHARACTERS = "ABCDEFGHIKJLMNOPQRSTUVWXYZabcdefghikjlmnopqrstuvwxyz0123456789-_$/."
 $			    I = 0	 $ LOOP_CHARACTERS1:	     $			    C = F$EXTRACT(I,1,TMP2) # $			    IF C .EQS. "."										!DM	 $			    THEN											!DM\ $			        TMP2 = F$EXTRACT(0,I,TMP2) + "$5N" + F$EXTRACT(I+1,F$LENGTH(TMP2)-I-1,TMP2)		!DM $				I = I + 2										!DM' $			    ELSE											!DM  $				IF C .EQS. "/"										!DM $				THEN											!DM	. $				    IF I .LT. F$LENGTH(TMP2)-1								!DM $				    THEN										!DMS $					TMP2 = F$EXTRACT(0,I,TMP2) + "." + F$EXTRACT(I+1,F$LENGTH(TMP2)-I-1,TMP2)	!DM	 $				    ELSE										!DM/ $					TMP2 = F$EXTRACT(0,I,TMP2) + "]"						!DMF $				    ENDIF										!DM	 $				ELSE											!DM	I $				    IF ALLOWED_CHARACTERS - C .EQS. ALLOWED_CHARACTERS THEN -				!DM!R 					TMP2 = F$EXTRACT(0,I,TMP2) + "$" + F$EXTRACT(I+1,F$LENGTH(TMP2)-I-1,TMP2)	!DM $				ENDIF											!DM $			    ENDIF											!DM! $			    I = I + 1											!DMN; $			    IF I .LT. F$LENGTH(TMP2) THEN GOTO LOOP_CHARACTERS1E	 $			ENDIFM $			IF DEBUG THEN - 1 			   WRITE SYS$ERROR "-Debug- TMP = """,TMP,""""E $			IF DEBUG THEN -E3 			   WRITE SYS$ERROR "-Debug- TMP2 = """,TMP2,""""" $			IF DEBUG THEN -	C 			   WRITE SYS$ERROR "-Debug- Old LOCAL_DIRECTORY = """,-						!DM" 			   LOCAL_DIRECTORY,""""Z $			LOCAL_DIRECTORY = F$EXTRACT(0,F$LENGTH(LOCAL_DIRECTORY)-4,LOCAL_DIRECTORY) + TMP2		!DM! $			IF DEBUG THEN -											!DM C 			   WRITE SYS$ERROR "-Debug- New LOCAL_DIRECTORY = """,-						!DMS' 			   LOCAL_DIRECTORY,""""										!DML $			 $		    ENDIFU $		    IF DEBUG THEN WRITE SYS$ERROR "-Debug- Local directory now: ", LOCAL_DIRECTORY_ $		ENDIF
 $	    ELSE& $		IF FTP_SERVER_TYPE .EQ. TYPE_UNIX -< 		   .AND. F$EXTRACT(F$LENGTH(TMP)-1,1,TMP) .NES. "/" THEN - 		   TMP = TMP + "/"  $		IF TMP .EQS. REMOTE_DIRECTORY $		THENA $		    ! we have a mappingL $		    LOCAL_DIRECTORY = F$ELEMENT(1,",",CONFIG_DIRECTORIES_'COUNT') - "..."U $		    IF DEBUG THEN WRITE SYS$ERROR "-Debug- Local directory now: ", LOCAL_DIRECTORY  $		ENDIF $	    ENDIF	 $	    COUNT = COUNT + 1S $	    GOTO _FIND_LOOPT $ _EXIT_FIND_LOOP:  " $	    IF LOCAL_DIRECTORY .EQS. ""  $	    THEN RO $		WRITE SYS$ERROR "Error - no mapping for remote directory ", REMOTE_DIRECTORYIB $		WRITE SYS$ERROR "Error - skipping directory ", REMOTE_DIRECTORY $!1 $		OPEN/WRITE/SHARE=READ REPORT_FILE 'TEMPFILE_4'SA $		WRITE REPORT_FILE "(This message generated by FTP_MIRROR.COM)"E $		WRITE REPORT_FILE "" F $		WRITE REPORT_FILE "Error retrieving files from site: ", CONFIG_SITE $		WRITE REPORT_FILE ""CQ $		WRITE REPORT_FILE "Error - no mapping for remote directory ", REMOTE_DIRECTORY D $		WRITE REPORT_FILE "Error - skipping directory ", REMOTE_DIRECTORY $		CLOSE REPORT_FILES $		MAIL_SUBJECT = F$FAO("FTP_Mirror: Error retrieving files from !AS", CONFIG_SITE)a1 $		MAIL_PN = F$FAO("!AS: Failure!!", CONFIG_SITE)	 $		SET noONN& $		MAIL 'TEMPFILE_4' 'CONFIG_MAILTO' -  			 /SUBJECT="''MAIL_SUBJECT'" - 			 /PERSONAL_NAME="''MAIL_PN'"A	 $		SET ON  $!
 $	    ELSE $_REMOVE_MFD:														!DMD $		IF (LOCAL_DIRECTORY - "[000000.") .NES. LOCAL_DIRECTORY							!DM $		THEN													!DMP> $		    LOCAL_DIRECTORY = LOCAL_DIRECTORY - "000000."							!DM% $		    GOTO _REMOVE_MFD											!DMI $		ENDIF													!DMW $		IF (F$ELEMENT(8,".",LOCAL_DIRECTORY) .EQS. ".") .OR. DEEPDIRECTORYFLAG THEN -				!DM	\ 		    IF F$PARSE(LOCAL_DIRECTORY) .EQS. "" THEN CREATE/DIRECTORY/LOG 'LOCAL_DIRECTORY'			!DM $	    ENDIFL $	    GOTO _READ_FILE_LOOP $	ENDIF ! f$locate $I7 $	IF LOCAL_DIRECTORY .EQS. "" THEN GOTO _READ_FILE_LOOP" $. $!( $!!!  Determine if we need to get a file $! $<8 $	IF F$EDIT(F$ELEMENT(0," ",RECORD),"COLLAPSE") .NES. "" $	THEN $	    GET_FILE = FALSE( $	    ! assume we have a remote filename' $	    IF FTP_SERVER_TYPE .EQ. TYPE_UNIXN
 $	    THEN, $		RECORD_C = F$EDIT(RECORD,"COMPRESS,TRIM")0 $		REMOTE_PROTECTION = F$ELEMENT(0," ",RECORD_C) $!' $!		Ignore block and character devices._ $!V $		IF F$EXTRACT(0,1,REMOTE_PROTECTION) .EQS. "b" THEN GOTO _READ_FILE_LOOP					    !DMV $		IF F$EXTRACT(0,1,REMOTE_PROTECTION) .EQS. "c" THEN GOTO _READ_FILE_LOOP					    !DM+ $		REMOTE_LINKS = F$ELEMENT(1," ",RECORD_C)	* $		REMOTE_USER = F$ELEMENT(2," ",RECORD_C)+ $		REMOTE_GROUP = F$ELEMENT(3," ",RECORD_C) * $		REMOTE_SIZE = F$ELEMENT(4," ",RECORD_C)+ $		REMOTE_MONTH = F$ELEMENT(5," ",RECORD_C)") $		REMOTE_DAY = F$ELEMENT(6," ",RECORD_C) 0 $		REMOTE_YEARORTIME = F$ELEMENT(7," ",RECORD_C)5 $		IF REMOTE_YEARORTIME - ":" .EQS. REMOTE_YEARORTIMEF $		THEN ! Mon day yeark $		    REMOTE_TIMESTAMP = F$CVTIME(REMOTE_DAY+"-"+REMOTE_MONTH+"-"+REMOTE_YEARORTIME+":0:0:0","COMPARISON"); $		ELSE	{ $		    REMOTE_TIMESTAMP = F$CVTIME(REMOTE_DAY+"-"+REMOTE_MONTH+"-"+F$CVTIME("",,"YEAR")+":"+REMOTE_YEARORTIME,"COMPARISON")ED $		    IF REMOTE_TIMESTAMP .GTS. F$CVTIME("+1-","COMPARISON") THEN - 		       REMOTE_TIMESTAMP = F$CVTIME(REMOTE_DAY+"-"+REMOTE_MONTH+"-"+F$CVTIME("-365-",,"YEAR")+":"+REMOTE_YEARORTIME,"COMPARISON") $		ENDIF; $		FILENAME = RECORD_C - REMOTE_PROTECTION - REMOTE_LINKS -(2 			   - REMOTE_USER - REMOTE_GROUP - REMOTE_SIZE -5 			   - REMOTE_MONTH - REMOTE_DAY - REMOTE_YEARORTIMED% $		FILENAME = F$EDIT(FILENAME,"TRIM")M
 $	    ELSE% $		FILENAME = F$ELEMENT(0," ",RECORD)IM $		REMOTE_TIMESTAMP = F$ELEMENT(2," ",RECORD) + " " + F$ELEMENT(3," ",RECORD)E3 $		IF F$EDIT(REMOTE_TIMESTAMP,"COLLAPSE") .EQS. "" 	 $		THENI$ $		    ! date is on the next line... $ _READ_DATE_LINE:  8 $		    READ/END_OF_FILE=_EXIT_READ_FILE_LOOP FILE RECORDE $! Watch out.  Some client, like the HGFTP client, will sputter lines	9 $! like this right in the middle of the directory output:E4 $!	<226 File transfer Okay; Closing data connection.L $! Fortunately, it is very easy to check, since we expect this line to start $! with a space'0 $		    IF F$EXTRACT(0,1,RECORD) .NES. " " THEN - 		       GOTO _READ_DATE_LINET) $		    RECORD = F$EDIT(RECORD,"COMPRESS")EQ $		    REMOTE_TIMESTAMP = F$ELEMENT(2," ",RECORD) + " " + F$ELEMENT(3," ",RECORD)P $		ENDIF= $		REMOTE_TIMESTAMP = F$CVTIME(REMOTE_TIMESTAMP,"COMPARISON")I $	    ENDIFEH $	    IF DEBUG THEN WRITE SYS$ERROR "-Debug- Remote file is: ", FILENAME' $	    IF FTP_SERVER_TYPE .EQ. TYPE_UNIXT
 $	    THEN; $		IF F$EXTRACT(0,1,REMOTE_PROTECTION) .EQS. "l"								!DMT $		THEN													!DMOP $		    IF DEBUG THEN WRITE SYS$OUTPUT "-Debug- Link detected: ",FILENAME					!DM2 $		    XXX = F$LOCATE(" -> ",FILENAME)									!DM? $		    YYY = F$EDIT(F$EXTRACT(0,XXX,FILENAME),"TRIM")							!DMTC $		    ZZZ = F$EDIT(F$EXTRACT(XXX+4,999,FILENAME),"TRIM")							!DM	9 $		    LOCAL_LINK_INDEX = LOCAL_LINK_INDEX + 1								!DMS: $		    LOCAL_LINK_FROM_'LOCAL_LINK_INDEX' = YYY								!DMT $		    LOCAL_LINK_FROM_REMOTE_DIRECTORY_'LOCAL_LINK_INDEX' = REMOTE_DIRECTORY				!DMR $		    LOCAL_LINK_TO_REMOTE_DIRECTORY_'LOCAL_LINK_INDEX' = REMOTE_DIRECTORY				!DM= $		    IF ZZZ .EQS. "." THEN ZZZ = REMOTE_DIRECTORY							!DME2 $		    IF F$EXTRACT(0,1,ZZZ) .EQS. "/"									!DM $		    THEN												!DMD $			LOCAL_LINK_TO_REMOTE_DIRECTORY_'LOCAL_LINK_INDEX' = "/"						!DM! $			ZZZ = ZZZ - "/"											!DM$ $		    ENDIF												!DMP5 $		    IF F$ELEMENT(0,"/",ZZZ) .EQS. ".."									!DMF $		    THEN												!DMc $			IF DEBUG THEN WRITE SYS$OUTPUT "-Debug- Link to high in the remote tree: ",REMOTE_DIRECTORY	!DM  $			XXX = 1												!DM( $_DIRECTORY_FLAG_LOOP_40:												!DMH $			REMOTE_DIRECTORY_'XXX' = F$ELEMENT(XXX,"/",REMOTE_DIRECTORY)					!DM1 $			IF REMOTE_DIRECTORY_'XXX' .NES. ""								!DMA $			THEN												!DM_" $			    XXX = XXX + 1										!DM/ $			    GOTO _DIRECTORY_FLAG_LOOP_40								!DMM $			ENDIF												!DM $			XXX = XXX - 2											!DM " $			ZZZ = ZZZ - "../"										!DM( $_DIRECTORY_FLAG_LOOP_50:												!DM1 $			IF F$ELEMENT(0,"/",ZZZ) .EQS. ".."								!DM. $			THEN												!DMN" $			    XXX = XXX - 1										!DM& $			    ZZZ = ZZZ - "../"										!DM/ $			    GOTO _DIRECTORY_FLAG_LOOP_50								!DMP $			ENDIF												!DM $			YYY = 2												!DM[ $			LOCAL_LINK_TO_REMOTE_DIRECTORY_'LOCAL_LINK_INDEX' = "/" + REMOTE_DIRECTORY_1 + "/"		!DMN( $_DIRECTORY_FLAG_LOOP_60:												!DM! $			IF YYY .LE. XXX											!DMT $			THEN												!DM_E $			    LOCAL_LINK_TO_REMOTE_DIRECTORY_'LOCAL_LINK_INDEX' = -					!DMIX 				LOCAL_LINK_TO_REMOTE_DIRECTORY_'LOCAL_LINK_INDEX' + REMOTE_DIRECTORY_'YYY' + "/"	!DM" $			    YYY = YYY + 1										!DM/ $			    GOTO _DIRECTORY_FLAG_LOOP_60								!DM  $			ENDIF												!DMG $			IF DEBUG THEN WRITE SYS$OUTPUT "-Debug- Uptree link is: ",-					!DMFA 			    LOCAL_LINK_TO_REMOTE_DIRECTORY_'LOCAL_LINK_INDEX'						!DMB $		    ENDIF												!DMT( $_DIRECTORY_FLAG_LOOP_20:												!DMN $		    IF (ZZZ - "/") .EQS. ZZZ THEN GOTO _DIRECTORY_FLAG_LOOP_20_EXIT					!DME $		    LOCAL_LINK_TO_REMOTE_DIRECTORY_'LOCAL_LINK_INDEX' = -						!DMEA 			LOCAL_LINK_TO_REMOTE_DIRECTORY_'LOCAL_LINK_INDEX' + -						!DM ) 			F$ELEMENT(0,"/",ZZZ) + "/"									!DM 9 $		    ZZZ = ZZZ -  F$ELEMENT(0,"/",ZZZ) - "/"								!DMS/ $		    GOTO _DIRECTORY_FLAG_LOOP_20									!DMG- $_DIRECTORY_FLAG_LOOP_20_EXIT:												!DM"8 $		    LOCAL_LINK_TO_'LOCAL_LINK_INDEX' = ZZZ								!DMR $		    LOCAL_LINK_FROM_LOCAL_DIRECTORY_'LOCAL_LINK_INDEX' = LOCAL_DIRECTORY				!DME $		    LOCAL_LINK_TO_LOCAL_DIRECTORY_'LOCAL_LINK_INDEX' = ""						!DMFD $		    LOCAL_LINK_DIRECTORY_FLAG_'LOCAL_LINK_INDEX' = FALSE						!DM $		    XXX = -1												!DM( $_DIRECTORY_FLAG_LOOP_30:												!DM" $		    XXX = XXX + 1											!DMV $		    IF XXX .GT. LOCAL_DIRECTORY_INDEX THEN GOTO _DIRECTORY_FLAG_LOOP_30_EXIT				!DMs $		    IF LOCAL_LINK_TO_REMOTE_DIRECTORY_'LOCAL_LINK_INDEX' .NES. LOCAL_DIRECTORY_REMOTE_DIRECTORY_'XXX' THEN -	!DMI+ 			GOTO _DIRECTORY_FLAG_LOOP_30									!DMEa $		    IF LOCAL_LINK_TO_'LOCAL_LINK_INDEX' .NES. LOCAL_DIRECTORY_DIRECTORY_NAME_'XXX' THEN -		!DM	+ 			GOTO _DIRECTORY_FLAG_LOOP_30									!DMUd $		    LOCAL_LINK_TO_LOCAL_DIRECTORY_'LOCAL_LINK_INDEX' = LOCAL_DIRECTORY_LOCAL_DIRECTORY_'XXX'		!DMD $		    LOCAL_LINK_DIRECTORY_FLAG_'LOCAL_LINK_INDEX' = TRUE							!DM- $_DIRECTORY_FLAG_LOOP_30_EXIT:												!DME( $		    GOTO _READ_FILE_LOOP										!DM $		ENDIF													!DM; $		IF F$EXTRACT(0,1,REMOTE_PROTECTION) .EQS. "d"								!DMI $		THEN													!DME@ $		    IF FILENAME .EQS. "." THEN GOTO _READ_FILE_LOOP							!DMA $		    IF FILENAME .EQS. ".." THEN GOTO _READ_FILE_LOOP							!DME! $		    YYY = FALSE												!DM	 $		    XXX = -1												!DM( $_DIRECTORY_FLAG_LOOP_10:												!DM" $		    XXX = XXX + 1											!DMR $		    IF XXX .GT. LOCAL_LINK_INDEX THEN GOTO _DIRECTORY_FLAG_LOOP_10_EXIT					!DMk $		    IF REMOTE_DIRECTORY .NES. LOCAL_LINK_TO_REMOTE_DIRECTORY_'XXX' THEN GOTO _DIRECTORY_FLAG_LOOP_10	!DMQU $		    IF FILENAME .NES. LOCAL_LINK_TO_'XXX' THEN GOTO _DIRECTORY_FLAG_LOOP_10				!DM_  $		    YYY = TRUE												!DM8 $		    LOCAL_LINK_DIRECTORY_FLAG_'XXX' = TRUE								!DME $		    LOCAL_LINK_TO_LOCAL_DIRECTORY_'XXX' = LOCAL_DIRECTORY						!DMY/ $		    GOTO _DIRECTORY_FLAG_LOOP_10									!DM - $_DIRECTORY_FLAG_LOOP_10_EXIT:												!DM	3 $		    IF YYY THEN GOTO _READ_FILE_LOOP									!DMIB $		    LOCAL_DIRECTORY_INDEX = LOCAL_DIRECTORY_INDEX + 1							!DMW $		    LOCAL_DIRECTORY_LOCAL_DIRECTORY_'LOCAL_DIRECTORY_INDEX' = LOCAL_DIRECTORY				!DM	Y $		    LOCAL_DIRECTORY_REMOTE_DIRECTORY_'LOCAL_DIRECTORY_INDEX' = REMOTE_DIRECTORY				!DMEP $		    LOCAL_DIRECTORY_DIRECTORY_NAME_'LOCAL_DIRECTORY_INDEX' = FILENAME					!DM( $		    GOTO _READ_FILE_LOOP										!DM $		ENDIF													!DM7 $		IF F$EXTRACT(0,1,REMOTE_PROTECTION) .NES. "-" THEN -M 		   GOTO _READ_FILE_LOOP	
 $	    ELSE4 $		IF F$PARSE(FILENAME,,,"TYPE") .EQS. ".DIR" THEN - 		   GOTO _READ_FILE_LOOPF $	    ENDIFN $	) $	    OLD_LOCAL_FILENAME = LOCAL_FILENAME5( $	    IF FTP_SERVER_TYPE .EQS. TYPE_UNIX
 $	    THEN $		LOCAL_FILENAME = FILENAMEH $		IF F$EXTRACT(F$LENGTH(LOCAL_FILENAME)-3,3,LOCAL_FILENAME) .EQS. ".gz" $		THEN N $		    LOCAL_FILENAME = F$EXTRACT(0,F$LENGTH(LOCAL_FILENAME)-3,LOCAL_FILENAME)3 $		    IF LOCAL_FILENAME - "." .EQS. LOCAL_FILENAME	 $		    THEN + $			LOCAL_FILENAME = LOCAL_FILENAME + ".gz"u $		    ELSEA+ $			LOCAL_FILENAME = LOCAL_FILENAME + "-gz"  $		    ENDIF $		ENDIFG $		IF F$EXTRACT(F$LENGTH(LOCAL_FILENAME)-2,2,LOCAL_FILENAME) .EQS. ".Z"A $		THEN-N $		    LOCAL_FILENAME = F$EXTRACT(0,F$LENGTH(LOCAL_FILENAME)-2,LOCAL_FILENAME)3 $		    IF LOCAL_FILENAME - "." .EQS. LOCAL_FILENAME  $		    THENR* $			LOCAL_FILENAME = LOCAL_FILENAME + ".Z" $		    ELSEO* $			LOCAL_FILENAME = LOCAL_FILENAME + "_Z" $		    ENDIF $		ENDIF\ $		ALLOWED_CHARACTERS = "ABCDEFGHIKJLMNOPQRSTUVWXYZabcdefghikjlmnopqrstuvwxyz0123456789-_$."B $		IF DEBUG THEN WRITE SYS$ERROR "-Debug- (1) LOCAL_FILENAME=""",- 		   LOCAL_FILENAME,"""" $		I = 0 $ LOOP_CHARACTERS2: $ $		C = F$EXTRACT(I,1,LOCAL_FILENAME)[ $		IF (C .EQS. ".") .AND. ((LOCAL_FILENAME - "." - ".") .NES. (LOCAL_FILENAME - "."))			!DMD $		THEN													!DM$I 		    LOCAL_FILENAME = F$EXTRACT(0,I,LOCAL_FILENAME) + "$5N" + -						!DMEE 			F$EXTRACT(I+1,F$LENGTH(LOCAL_FILENAME)-I-1,LOCAL_FILENAME)					!DMD $		    I = I + 2												!DMR $		ELSE													!DMOI $		    IF ALLOWED_CHARACTERS - C .EQS. ALLOWED_CHARACTERS THEN -						!DMDC 			LOCAL_FILENAME = F$EXTRACT(0,I,LOCAL_FILENAME) + "$" + -					!DM"I 			    F$EXTRACT(I+1,F$LENGTH(LOCAL_FILENAME)-I-1,LOCAL_FILENAME)					!DME $		ENDIF													!DM $		I = I + 1												!DMI@ $		IF I .LT. F$LENGTH(LOCAL_FILENAME) THEN GOTO LOOP_CHARACTERS2B $		IF DEBUG THEN WRITE SYS$ERROR "-Debug- (2) LOCAL_FILENAME=""",- 		   LOCAL_FILENAME,""""? $		LOCAL_FILENAME = F$PARSE(";",LOCAL_FILENAME,LOCAL_DIRECTORY),B $		IF DEBUG THEN WRITE SYS$ERROR "-Debug- (3) LOCAL_FILENAME=""",- 		   LOCAL_FILENAME,""""
 $	    ELSE9 $		LOCAL_FILENAME = F$PARSE(";",FILENAME,LOCAL_DIRECTORY)E $	    ENDIFYM $	    IF DEBUG THEN WRITE SYS$ERROR "-Debug- Local file is: ", LOCAL_FILENAMEX0 $	    IF OLD_LOCAL_FILENAME .EQS. LOCAL_FILENAME
 $	    THEN_ $		IF DEBUG THEN WRITE SYS$ERROR "-Debug- Skipping file ", FILENAME, " (it's an older version)"  $		GOTO _READ_FILE_LOOP  $	    ENDIFT* $	    IF F$SEARCH(LOCAL_FILENAME) .EQS. ""
 $	    THEN< $		! no such file exists, so we need to create directory (if& $		! necessary) and pull the file over& $		IF CONFIG_LAST_TIME_FILE .EQS. "" -F 		   .OR. CONFIG_LAST_TIME .LTS. REMOTE_TIMESTAMP THEN GET_FILE = TRUE! $		IF GET_FILE .AND. DEBUG THEN -- 		   WRITE SYS$ERROR "-Debug- Copying file #",GET_FILE_COUNT, REMOTE_DIRECTORY, FILENAME, " to ", LOCAL_FILENAME, " (we don't have a copy)."
 $	    ELSE3 $		! check dates to see if we should get a new copyMH $		LOCAL_TIMESTAMP = F$CVTIME(F$FILE(LOCAL_FILENAME,"RDT"),"COMPARISON")w $		IF DEBUG THEN WRITE SYS$ERROR "-Debug- Local file date: ", LOCAL_TIMESTAMP, ", remote file date: ", REMOTE_TIMESTAMPO, $		IF LOCAL_TIMESTAMP .LES. REMOTE_TIMESTAMP $		THEN * $		    IF CONFIG_LAST_TIME_FILE .EQS. "" -J 		       .OR. CONFIG_LAST_TIME .LTS. REMOTE_TIMESTAMP THEN GET_FILE = TRUE% $		    IF GET_FILE .AND. DEBUG THEN -  		       WRITE SYS$ERROR "-Debug- Getting file ",GET_FILE_COUNT, REMOTE_DIRECTORY, FILENAME, " to ", LOCAL_FILENAME," (we have an old copy)."G $		ENDIF $	    ENDIF- $	    IF GET_FILE  $	    THEN f& $		GET_FILE_COUNT = GET_FILE_COUNT + 1 $		NEW_TYPE = 0												!DM- $		IF (CONFIG_TYPE_TOTAL .NE. 0)										!DMN $		THEN													!DMT $		    XXX = 0												!DM " $ _SCAN_TYPE_LOOP:													!DMK $		    IF XXX .GE. CONFIG_TYPE_TOTAL THEN GOTO _EXIT_SCAN_TYPE_LOOP					!DMC+ $		    YYY = CONFIG_TYPE_'XXX'										!DM \ $		    IF F$EXTRACT(F$LENGTH(FILENAME)-F$LENGTH(YYY),F$LENGTH(YYY),FILENAME) .EQS. YYY			!DM $		    THEN												!DMz $                       IF DEBUG THEN WRITE SYS$ERROR "-Debug- Changing transfer mode to: ",CONFIG_TYPE_TRANSFER_'XXX'	!DM9 $			IF (CONFIG_TYPE_TRANSFER_'XXX' .EQS. "VMS")							!DM	  $			THEN											        !MPJZw $	                    WRITE OUTFILE FTP_CLIENT_STRU_VMS                                                           !MPJZ   $			ELSE											        !MPJZj $	                    WRITE OUTFILE FTP_CLIENT_TYPE_CMD, CONFIG_TYPE_TRANSFER_'XXX'		                !MPJZ! $			ENDIF											        !MPJZ	{ $                                                                                                                       !DMO $			NEW_TYPE = 1											!DM) $			GOTO _EXIT_SCAN_TYPE_LOOP									!DM" $		    ENDIF												!DMN" $		    XXX = XXX + 1											!DM( $		    GOTO _SCAN_TYPE_LOOP										!DM' $ _EXIT_SCAN_TYPE_LOOP:													!DMI $		ENDIF													!DM8 $ _SCAN_NAME_LOOP:                                      - $               IF (CONFIG_NAME_TOTAL .NE. 0)N $               THEN $                   XXX = 0  $ _SCAN_NAME_LOOP:P $                   IF XXX .GE. CONFIG_NAME_TOTAL THEN GOTO _EXIT_SCAN_NAME_LOOP+ $                   YYY = CONFIG_NAME_'XXX'+D $                   IF F$EXTRACT(0,F$LENGTH(YYY),FILENAME) .EQS. YYY $		    THEN												Rw $                       IF DEBUG THEN WRITE SYS$ERROR "-Debug- Changing transfer mode to: ",CONFIG_NAME_TRANSFER_'XXX'	I6 $			IF (CONFIG_NAME_TRANSFER_'XXX' .EQS. "VMS")							 $			THEN											         r $	                    WRITE OUTFILE FTP_CLIENT_STRU_VMS                                                            $			ELSE											        Te $	                    WRITE OUTFILE FTP_CLIENT_TYPE_CMD, CONFIG_NAME_TRANSFER_'XXX'		                D $			ENDIF											        x $                                                                                                                        $			NEW_TYPE = 1											I& $			GOTO _EXIT_SCAN_NAME_LOOP									 $		    ENDIF												 $		    XXX = XXX + 1											D% $		    GOTO _SCAN_NAME_LOOP										_ $               ENDIF	 $ _EXIT_SCAN_NAME_LOOP: b $		IF (CONFIG_TYPE_TOTAL .NE. 0) .AND. (CONFIG_NAME_TOTAL .NE. 0) .AND. (.NOT. NEW_TYPE)							!DM $		THEN													!DMR7 $		    IF (CONFIG_FILE_TRANSFER .EQS. "VMS")								!DM) $		    THEN												!DM9 $			WRITE OUTFILE FTP_CLIENT_STRU_VMS							        !MPJZT $		    ELSE												!DMF $			WRITE OUTFILE FTP_CLIENT_TYPE_CMD, CONFIG_FILE_TRANSFER						!MPJZ $		    ENDIF												!DMH $		ENDIF													!DM! $		WRITE OUTFILE -												!DMEi 		    "SPAWN WRITE SYS$OUTPUT ""<<<GET """"",REMOTE_DIRECTORY,FILENAME,""""" ",LOCAL_FILENAME,">>>"""	!DM S $		WRITE OUTFILE "GET """, REMOTE_DIRECTORY, FILENAME, """ ", LOCAL_FILENAME				!DMf9 $		IF GET_FILE_COUNT .GE. CONFIG_MAXIMUM_FILES								!DMR $		THEN													!DMo5 $		    IF CONFIG_SPLIT_DIRECTORY .EQS. ""									!DMP $		    THEN												!DM) $			GOTO _EXIT_READ_FILE_LOOP									!DMy $		    ELSE												!DM $			CLOSE OUTFILE											!DM_ $			IF SPLIT_FILE											!DM  $			THEN												!DMW` $			    OPEN/WRITE/SHARE=READ COMFILE 'F$PARSE(CONFIG_SPLIT_DIRECTORY + ".COM",TEMPFILE_5)'		!DMD $			    WRITE COMFILE "$ GET_FILE_COUNT == ",GET_FILE_COUNT						!DM" $			    CLOSE COMFILE										!DM $			ENDIF												!DMT $			OPEN/WRITE/SHARE=READ OUTFILE 'F$PARSE(CONFIG_SPLIT_DIRECTORY,TEMPFILE_5)'			!DM  $			SPLIT_FILE = 1											!DM) $			GOTO _SPLIT_TRANSFER_FILE									!DM  $		    ENDIF												!DM  $		ENDIF													!DM $	    ENDIFT $	ENDIF  $	GOTO _READ_FILE_LOOP $ _EXIT_READ_FILE_LOOP:	 $	CLOSE FILE $	WRITE OUTFILE "EXIT" $	CLOSE OUTFILE	! $	GOSUB MAKE_LINKS												!DM	 $ V $	IF .NOT. DEBUG .AND. F$SEARCH(TEMPFILE_2) .NES. "" THEN DELETE 'TEMPFILE_2';					!DM $	! $	IF NOT_LOGGED_IN												!DMI $	THEN														!DMD" $	    WAIT 00:01:00												!DM- $	    GOTO _RETRY_GEN_FILE_LIST											!DMD $	ENDIF														!DM $E( $	IF GET_FILE_COUNT .EQ. 0											!DM $	THEN														!DME" $	    IF SPLIT_FILE												!DM $	    THEN													!DM= $		DELETE 'F$PARSE("*.*;0",CONFIG_SPLIT_DIRECTORY)'							!DMe $	    ELSE													!DM; $		WRITE SYS$OUTPUT "No files to get.  Exiting."								!DMN $		GOTO _EXIT												!DM $	    ENDIF													!DMi $	ELSE														!DME" $	    IF SPLIT_FILE												!DM $	    THEN													!DM\ $		OPEN/WRITE/SHARE=READ COMFILE 'F$PARSE(CONFIG_SPLIT_DIRECTORY + ".COM",TEMPFILE_5)'			!DM@ $		WRITE COMFILE "$ GET_FILE_COUNT == ",GET_FILE_COUNT							!DM $		CLOSE COMFILE												!DM	 $	    ENDIF													!DM, $	ENDIF														!DM $"H $	IF SPLIT_FILE THEN GET_FILE_COUNT = CONFIG_MAXIMUM_FILES    							!DM $OC $	WRITE SYS$OUTPUT F$FAO("!/Getting !UL file!%S!/", GET_FILE_COUNT)  $LG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!M, $!  Get the new files from the remote systemG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" $R' $ _SPLIT_FILE_TRANSFER:													!DME $															!DMFI $	IF .NOT. CONFIG_TRANSFER_FILES THEN GOTO _EXIT_TRANSFER_FILES							!DM+A $	IF DEBUG THEN WRITE SYS$ERROR "-Debug- Contents of input file:"	= $	IF DEBUG THEN TYPE/OUTPUT=SYS$ERROR 'TEMPFILE_5'								!DMH $"' $ _RETRY_FILE_TRANSFER:													!DMM $CH $	IF DEBUG THEN WRITE SYS$ERROR "-Debug- Connecting to remote system..."2 $	OLD_SYMBOL_SCOPE = F$ENVIRONMENT("SYMBOL_SCOPE")! $	SET SYMBOL/SCOPE=(GLOBAL,LOCAL)( $6( $	IF FTP_CLIENT_TYPE .EQ. TYPE_MULTINET  $	THEN $	    SET noON1 $	    DEFINE SYS$OUTPUT 'TEMPFILE_2'										!DM  $	    'CONFIG_COMMAND' - 		  /NOINITIALIZATION -E( 		  /TAKE_FILE='TEMPFILE_5'										!DM $	    STATUS = $STATUS( $	    DEASSIGN SYS$OUTPUT												!DM $	    SET ON $	ENDIFM $($ $	IF FTP_CLIENT_TYPE .EQ. TYPE_HGFTP $	THEN $	    SET noON1 $	    DEFINE SYS$OUTPUT 'TEMPFILE_2'										!DMT $	    'CONFIG_COMMAND' - 		  'CONFIG_SITE' -	$ 		  /USERNAME="''CONFIG_USERNAME'" -$ 		  /PASSWORD="''CONFIG_PASSWORD'" -- 		  /INITIALIZATION='TEMPFILE_5'										!DMh $	    STATUS = $STATUSu $	    DEASSIGN SYS$OUTPUT                                                                                         !DMe $	    SET ON $	ENDIFn $t& $	IF FTP_CLIENT_TYPE .EQ. TYPE_TCPWARE $	THEN $	    SET noON1 $	    DEFINE SYS$OUTPUT 'TEMPFILE_2'										!DMX6 $	    DEFINE/USER FTP_STARTUP 'TEMPFILE_5'									!DM $	    'CONFIG_COMMAND' $	    STATUS = $STATUSu $	    DEASSIGN SYS$OUTPUT                                                                                         !DMM $	    SET noON $	ENDIFT $,1 $	IF FTP_CLIENT_TYPE .EQ. TYPE_TCPIP										!DMR $	THEN														!DMm $	    SET noON			E1 $	    DEFINE SYS$OUTPUT 'TEMPFILE_2'										!DM ' $	    'CONFIG_COMMAND' -												!DMT! 		  'CONFIG_SITE' -											!DM	0 		  /USERNAME="''CONFIG_USERNAME'" -									!DM0 		  /PASSWORD="''CONFIG_PASSWORD'" -									!DM% 		  /INPUT='TEMPFILE_5'											!DM	% $	    STATUS = $STATUS												!DMC( $	    DEASSIGN SYS$OUTPUT												!DM $	    SET noON													!DM $	ENDIF														!DM $															!DMLW $	IF DEBUG THEN WRITE SYS$ERROR "-Debug- results of FTP file transfer session."					!DM = $	IF DEBUG THEN TYPE/OUTPUT=SYS$ERROR 'TEMPFILE_2'								!DML $																_ $	OPEN/READ FILE 'TEMPFILE_2'L" $	NOT_LOGGED_IN = 0												!DM $	USER_SEEN = 0													!DM   $	FILE_COUNT = 0													!DM( $	FILE_SUCCEEDED_COUNT = 0											!DM& $	FILE_FAILED_COUNT = 0												!DM! $	REPORT_LINE= ""													!DMA $															!DMC0 $	OPEN/WRITE/SHARE=READ REPORT_FILE 'TEMPFILE_4'@ $	WRITE REPORT_FILE "(This message generated by FTP_MIRROR.COM)" $	WRITE REPORT_FILE ""6 $	WRITE REPORT_FILE "New files at site: ", CONFIG_SITE $	WRITE REPORT_FILE "" $T0 $ _READ_FILE_TRANSFER_STATUS_LOOP:											!DMN $       READ/END_OF_FILE=_EXIT_FILE_TRANSFER_STATUS_LOOP FILE RECORD							!DMK $	IF F$EDIT(RECORD,"COLLAPSE") .EQS. "" THEN GOTO _READ_FILE_LOOP							!DM!R $	IF DEBUG THEN WRITE SYS$ERROR F$FAO("-Debug- Record is: \!AS\", RECORD)						!DM1 $	RECORD = F$EDIT(RECORD,"COMPRESS")										!DME $															!DM	\ $       IF F$EXTRACT(0,1,RECORD) .EQS. "$" THEN GOTO _READ_FILE_TRANSFER_STATUS_LOOP					!DM $															!DMR< $	XXX = F$EDIT(F$ELEMENT(0," ",RECORD),"UPCASE")									!DM$ $	IF XXX .EQS. "USER"												!DM $	THEN														!DMX" $	    USER_SEEN = 1												!DM6 $	    GOTO _READ_FILE_TRANSFER_STATUS_LOOP									!DM $	ENDIF														!DM $															!DM	9 $	IF ((F$EXTRACT(0,5,RECORD) .EQS. "<530 ") -									!DM'A 	   .OR. (F$EXTRACT(0,4,RECORD) .EQS. "530 ")) .AND. -								!DMR 	   USER_SEEN													!DM  $	THEN														!DM	& $	    NOT_LOGGED_IN = 1												!DMN $	    IF DEBUG THEN WRITE SYS$ERROR "-Debug- Login at remote failed."						!DM6 $	    GOTO _EXIT_FILE_TRANSFER_STATUS_LOOP									!DM $	ENDIF														!DM $															!DM	6 $	IF F$EXTRACT(0,6,RECORD) .EQS. "<<<GET"										!DM $	THEN														!DM!+ $	    IF REPORT_LINE .NES. ""											!DMg $	    THEN													!DM6 $		WRITE REPORT_FILE REPORT_LINE," FAILED"									!DM7 $		FILE_FAILED_COUNT = FILE_FAILED_COUNT + 1								!DM_ $	    ENDIF													!DM / $	    FILE_COUNT = FILE_COUNT + 1											!DMO> $	    RECORD = RECORD - "<<<" - ">>>" - """" - """"								!DMp $	    REPORT_LINE = F$STRING(FILE_COUNT) + ". " + F$ELEMENT(1," ",RECORD) + " -> " + F$ELEMENT(2," ",RECORD)	!DM6 $	    GOTO _READ_FILE_TRANSFER_STATUS_LOOP									!DM $	ENDIF														!DM $															!DMG= $	IF ((F$EXTRACT(0,5,RECORD) .EQS. "<226 ") .OR. -								!DM_n 	    (F$EXTRACT(0,4,RECORD) .EQS. "226 "))	                                                                !DMO $	THEN						                                                                !DMLu $	    FILE_SUCCEEDED_COUNT = FILE_SUCCEEDED_COUNT + 1                                                             !DM t $	    WRITE REPORT_FILE REPORT_LINE," SUCCEEDED"	                                                                !DM] $	    REPORT_LINE = ""				                                                                !DMKt $           GOTO _READ_FILE_TRANSFER_STATUS_LOOP	                                                                !DMP $	ENDIF						                                                                !DM $															!DMM3 $	GOTO _READ_FILE_TRANSFER_STATUS_LOOP										!DM	0 $ _EXIT_FILE_TRANSFER_STATUS_LOOP:											!DML $	!Check to see if there's a FAILED line still waiting to be output						!HG( $	IF REPORT_LINE .NES. ""												!HG $	THEN														!HGR9 $	    WRITE REPORT_FILE REPORT_LINE," FAILED"									!HGE; $	    FILE_FAILED_COUNT = FILE_FAILED_COUNT + 1									!HG( $	ENDIF														!HG $	CLOSE FILE													!DM% $	WRITE REPORT_FILE ""												!DM.u $	write report_file f$fao("!UL transfer!%S succeeded, !UL transfer!%S failed",FILE_SUCCEEDED_COUNT,FILE_FAILED_COUNT)Y" $	CLOSE REPORT_FILE												!DM $															!DM ! $	IF NOT_LOGGED_IN												!DM	 $	THEN														!DM1" $	    WAIT 00:01:00												!DM- $	    GOTO _RETRY_FILE_TRANSFER											!DM1 $	ENDIF														!DM $O' $	SET SYMBOL/SCOPE=('OLD_SYMBOL_SCOPE')I $TB $	IF DEBUG THEN WRITE SYS$ERROR "-Debug- Output from FTP session:"2 $	IF DEBUG THEN TYPE/OUTPUT=SYS$ERROR 'TEMPFILE_2' $O6 $	IF CONFIG_LAST_TIME_FILE .NES. "" .AND. .NOT. STATUS $	THEN, $	    OPEN/WRITE FOO 'CONFIG_LAST_TIME_FILE'  $	    WRITE FOO CONFIG_NEXT_TIME $	    CLOSE FOOC $	ENDIF	 $Y $	IF CONFIG_MAILTO .NES. ""_ $	THEN $	    IF STATUSI
 $	    THENI $		MAIL_SUBJECT = F$FAO("!AS: !UL file!%S transferred to local system", -	% 				     CONFIG_SITE, GET_FILE_COUNT)=( $		MAIL_PN = F$FAO("!AS: !UL file!%S", -  				CONFIG_SITE, GET_FILE_COUNT)
 $	    ELSE $		SHOW SYMBOL STATUSRS $		MAIL_SUBJECT = F$FAO("!AS: Following files were not transferred - check logs", -O 				     CONFIG_SITE)	1 $		MAIL_PN = F$FAO("!AS: Failure!!", CONFIG_SITE)Y $	    ENDIFE $	    SET noON) $	    MAIL 'TEMPFILE_4' 'CONFIG_MAILTO' -E 		 /SUBJECT="''MAIL_SUBJECT'" -R 		 /PERSONAL_NAME="''MAIL_PN'" $	    SET ON $	ENDIF  $A $! $!!!  Purge local directoriesA $!= $	IF .NOT.CONFIG_PURGE THEN GOTO _EXIT_PURGE_LOOP									!HGOQ $	IF NOT_LOGGED_IN .OR. GET_FILE_COUNT .EQ. 0 THEN GOTO _EXIT_PURGE_LOOP						!DME $	COUNT = 0T $ _PURGE_LOOP: H; $	IF COUNT .GE. CONFIG_DIR_TOTAL THEN GOTO _EXIT_PURGE_LOOPC" $	FOO = CONFIG_DIRECTORIES_'COUNT'k $	IF (F$SEARCH(F$PARSE("*.*",F$ELEMENT(1,",",FOO))) .NES. "") THEN PURGE/LOG 'F$ELEMENT(1,",",FOO)'*.*		!DM  $	COUNT = COUNT + 1. $	GOTO _PURGE_LOOP $_EXIT_PURGE_LOOP:& $_EXIT_TRANSFER_FILES:													!DM $	2 $	IF CONFIG_SUBMIT_AFTER .NES. "NONE"										!DM $	THEN														!DMD- $	    YYY = CONFIG_SUBMIT_AFTER											!DM2u $	    IF (CONFIG_SPLIT_SUBMIT_AFTER .NES. "") .AND. (F$SEARCH(CONFIG_SPLIT_DIRECTORY+"*.TMP;-0") .NES. "") THEN -	!DM . 		YYY = CONFIG_SPLIT_SUBMIT_AFTER										!DM5 $	    SET ENTRY '$ENTRY' /AFTER="''YYY'"										!DM  $	ENDIF														!DM $	GOTO _EXIT													!DM $															!DMFG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!j	 $ _EXIT: w $	GOSUB _CLEANUP+ $	WRITE SYS$OUTPUT "Leaving FTP_Mirror ..."1> $	IF F$TYPE(ORIGINAL_PRIV) THEN JUNK = F$SETPRV(ORIGINAL_PRIV) $	VERIFY = F$VERIFY(VERIFY)T $	EXIT 1 $L $ _NO_CONFIG_FILE: .9 $	WRITE SYS$ERROR "Could not find configuration file ",P1F $	WRITE SYS$ERROR "Aborting..."	 $	GOTO _EXIT $ 
 $ _ERROR:  $	ERROR_STATUS = $STATUSW $	WRITE SYS$ERROR "Unexpected error (%X''F$FAO("!XL",ERROR_STATUS)') in FTP_MIRROR.COM"I $	GOSUB _CLEANUP> $	IF F$TYPE(ORIGINAL_PRIV) THEN JUNK = F$SETPRV(ORIGINAL_PRIV) $	VERIFY = F$VERIFY(VERIFY). $	EXIT ERROR_STATUSR $H
 $ _ABORT: / $	WRITE SYS$ERROR "User aborted FTP_MIRROR.COM"A $	GOTO _EXIT $	 $ _CLEANUP: $ $	CLOSE/NOLOG COMFILE												!DM $	CLOSE/NOLOG FILE $	CLOSE/NOLOG OUTFILE	 $	CLOSE/NOLOG REPORT_FILE	; $	IF .NOT. DEBUG .AND. F$SEARCH(TEMPFILE_1) .NES. "" THEN -  	   DELETE 'TEMPFILE_1';*U; $	IF .NOT. DEBUG .AND. F$SEARCH(TEMPFILE_2) .NES. "" THEN -  	   DELETE 'TEMPFILE_2';*C; $	IF .NOT. DEBUG .AND. F$SEARCH(TEMPFILE_3) .NES. "" THEN -	 	   DELETE 'TEMPFILE_3';*R; $	IF .NOT. DEBUG .AND. F$SEARCH(TEMPFILE_4) .NES. "" THEN -" 	   DELETE 'TEMPFILE_4';*N; $	IF .NOT. DEBUG .AND. F$SEARCH(TEMPFILE_5) .NES. "" THEN -	 	   DELETE 'TEMPFILE_5';*$ $	RETURN $															!DM, $_SUBMIT:														!DM2 $	IF CONFIG_SUBMIT_AFTER .NES. "NONE"										!DM $	THEN														!DMS- $	    YYY = CONFIG_SUBMIT_AFTER											!DMtm $	    IF (CONFIG_SPLIT_SUBMIT_AFTER .NES. "") .AND. (F$SEARCH(CONFIG_SPLIT_DIRECTORY+"*.*;-0") .NES. "")		!DM  $	    THEN													!DM/ $		IF F$MODE() .EQS. "INTERACTIVE"										!DMc$ $		THEN	YYY = F$TIME()											!DM3 $		ELSE	YYY = CONFIG_SPLIT_SUBMIT_AFTER									!DMS $		ENDIF													!DM $	    ENDIF													!DMI $	    XXX = F$VERIFY(1)E $	    SUBMIT - 		   /NONOTIFY -; 		   /LOG_FILE='F$PARSE(CONFIGURATION_FILE,,,"NAME")'.LOG - 8 		   /PARAMETERS='F$ELEMENT(0,";",CONFIGURATION_FILE)' - 		   /noPRINTER -t 		   /QUEUE='CONFIG_QUEUE' - 		   /NAME="FTP_Mirror" -P 		   /AFTER="''YYY'" - 		   /KEEP -2 		   'F$ELEMENT(0,";",F$ENVIRONMENT("PROCEDURE"))' $	    XXX = F$VERIFY('XXX')O $	ENDIF														!DM $	RETURN														!DMM   $ MAKE_LINKS:														!DM $	XXX = -1													!DM! $ MAKE_LINKS_10$:													!DM" $	XXX = XXX + 1													!DME6 $	IF XXX .GT. LOCAL_LINK_INDEX THEN RETURN									!DML $	IF .NOT. LOCAL_LINK_DIRECTORY_FLAG_'XXX' THEN GOTO MAKE_LINKS_10$						!DM3 $	XXX_FILENAME = LOCAL_LINK_FROM_'XXX'										!DML2 $       GOSUB CONVERT_DIRECTORY_NAME											!DM< $       LOCAL_LINK_FROM_VMS_'XXX' = XXX_FILENAME									!DM1 $	XXX_FILENAME = LOCAL_LINK_TO_'XXX'										!DM	2 $       GOSUB CONVERT_DIRECTORY_NAME											!DM; $       LOCAL_LINK_TO_VMS_'XXX' = XXX_FILENAME										!DM h $	XXX_LINK_FROM = F$PARSE(".DIR;1",LOCAL_LINK_FROM_LOCAL_DIRECTORY_'XXX',LOCAL_LINK_FROM_VMS_'XXX')		!DMc $	XXX_LINK_TO = F$PARSE(".DIR;1",LOCAL_LINK_TO_LOCAL_DIRECTORY_'XXX',LOCAL_LINK_TO_VMS_'XXX')			!DMYL $	IF DEBUG THEN WRITE SYS$OUTPUT "-Debug- Search for: ",XXX_LINK_TO						!DM0 $	IF F$SEARCH(XXX_LINK_TO) .NES. ""										!DM $	THEN														!DMmK $	    IF DEBUG THEN WRITE SYS$OUTPUT "-Debug- Found: ",XXX_LINK_TO						!DM.R $	    IF DEBUG THEN WRITE SYS$OUTPUT "-Debug- Search for: ",XXX_LINK_FROM						!DM6 $	    IF F$SEARCH(XXX_LINK_FROM) .NES. ""										!DM $	    THEN													!DMJ $		IF DEBUG THEN WRITE SYS$OUTPUT "-Debug- Found: ",XXX_LINK_FROM						!DM $	    ELSE													!DM` $		IF DEBUG THEN WRITE SYS$OUTPUT "-Debug- Linking from: ",XXX_LINK_FROM," to ",XXX_LINK_TO		!DM: $		SET FILE/ENTER='XXX_LINK_FROM' 'XXX_LINK_TO'								!DM $	    ENDIF													!DM  $	ENDIF														!DM$ $	GOTO MAKE_LINKS_10$												!DM X( $ CONVERT_DIRECTORY_NAME:												!DMU $	IF DEBUG THEN WRITE SYS$OUTPUT "-Debug- Directory Name (in): ",XXX_FILENAME					!DM	b $	ALLOWED_CHARACTERS = "ABCDEFGHIKJLMNOPQRSTUVWXYZabcdefghikjlmnopqrstuvwxyz0123456789-_$/."			!DM0 $	XXX_ALLOWED_CHARACTERS_INDEX = -1										!DM& $ CONVERT_FILENAME_10:													!DMK $	XXX_ALLOWED_CHARACTERS_INDEX = XXX_ALLOWED_CHARACTERS_INDEX + 1							!DM G $	IF XXX_ALLOWED_CHARACTERS_INDEX .EQ. F$LENGTH(XXX_FILENAME)							!DM  $	THEN														!DMFY $	    IF DEBUG THEN WRITE SYS$OUTPUT "-Debug- Directory Name (out): ",XXX_FILENAME				!DM  $	    RETURN													!DM $	ENDIF														!DMQ $	XXX_CHARACTER = F$EXTRACT(XXX_ALLOWED_CHARACTERS_INDEX,1,XXX_FILENAME)						!DMI* $	IF XXX_CHARACTER .EQS. "."											!DM $	THEN														!DM	^ $	    XXX_FILENAME = F$EXTRACT(0,XXX_ALLOWED_CHARACTERS_INDEX,XXX_FILENAME) + "$5N" + -				!DME 		F$EXTRACT(XXX_ALLOWED_CHARACTERS_INDEX+1,999,XXX_FILENAME)						!DM N $	    XXX_ALLOWED_CHARACTERS_INDEX = XXX_ALLOWED_CHARACTERS_INDEX + 2						!DM $	ELSE														!DMNO $	    IF (ALLOWED_CHARACTERS - XXX_CHARACTER) .EQS. ALLOWED_CHARACTERS						!DM  $	    THEN													!DMY $		XXX_FILENAME = F$EXTRACT(0,XXX_ALLOWED_CHARACTERS_INDEX,XXX_FILENAME) + "$" + -				!DMLI 		    F$EXTRACT(XXX_ALLOWED_CHARACTERS_INDEX+1,999,XXX_FILENAME)						!DM	 $	    ENDIF													!DM	 $	ENDIF														!DM( $	GOTO CONVERT_FILENAME_10											!DM $ exit