#ifndef __DESCRIP2_LOADED
#define __DESCRIP2_LOADED    1
 
/*+ DESCRIP2
 Module (DESCRIP2) of SITE$LIB:LCLCDEF.TLB and file SITE$INC:DESCRIP2.H.
 
 This module defines some additions to the standard VAX C include
 module (DESCRIP) found in SYS$LIBRARY:VAXCDEF.TLB.
 
 The following macros are defined:
 
  $DESCRIPTOR0(name)             empty string descriptor (length and
                                 pointer fields initialzed to 0).
 
  $DESCRIPTOR1(name,string)      string descriptor for 1 character
                                 or a whole structure.
 
  $DESCRIPTORM(name,string)      string descriptor for structure
                                 member or non-NUL terminated strings.
 
  $DESCRIPTORA(name,array,type)  array descriptor.
 
  $LENGTH(descriptor)            length field of descriptor.
  $POINTER(descriptor)           pointer field of descriptor.
 
  DESCALLOC(name)                allocate and initialize empty descriptor.
  DESCINIT(name,string)          set string length and pointer into descriptor.
  DESCGETATTR(name,addr,length)  get pointer and length from descriptor.
  DESCUNPACK(name,string)        get text from descriptor into string.
-*/
/*
  V1.0  16-May-83       FJN     Created
 Editted for VAXC V3.1 to allow nested #include's on 06-Jul-1990 (FJN)
 Added macros from Rex Jaeschke via Jack Schmidt on 01-May-1991 (FJN)
*/
 
/*      DESCRIP2 - Extended VMS Descriptor Definitions  */
 
/* Invoke standard descriptor definitions if not already done so */
 
#ifndef $DESCRIPTOR
#include descrip
#endif
 
/*      simple macro to construct an empty string descriptor    */
 
#define $DESCRIPTOR0(name) \
        struct dsc$descriptor_s name = { 0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0 }
 
/*      simple macro to construct string descriptor for single
        characters or for complete structures:                  */
 
#define $DESCRIPTOR1(name,string) \
        struct dsc$descriptor_s name = { sizeof(string), DSC$K_DTYPE_T, DSC$K_CLASS_S, &string }
 
/*      macro to construct string descriptor for structure
        members or non-NUL terminated strings:                  */
 
#define $DESCRIPTORM(name,string) \
        struct dsc$descriptor_s name = { sizeof(string), DSC$K_DTYPE_T, DSC$K_CLASS_S, string }
 
/*      macro to construct array desciptors:                    */
 
#define $DESCRIPTORA(name,array,type) \
        struct dsc$descriptor_a name = { sizeof(type), DSC$K_DTYPE_Z, DSC$K_CLASS_A, array, 0, 0, \
                                        { 0, 0, 0, 0, 0 }, 1, sizeof(array) }
 
/*      macros to reference the length or pointer fields of
        descriptors                                             */
 
#define $LENGTH(descriptor) descriptor.dsc$w_length
#define $POINTER(descriptor) descriptor.dsc$a_pointer
 
/*
 End of DESCRIP2 module
*/
 
/*
 * Descriptor macros from Rex Jaeschke (via Advanced C course given
 * at Fermilab in April 1991).
 
 * DESCALLOC-   allocates a descriptor with an initial length and
 *              address of zero.   Rex Jaeschke
 *
 * DESCINIT-    Allows you to init a descriptor with a given string,
 *              array name, or char pointer.
 *
 * DESCGETATTR- Given a descriptor, return the length and address.
 *
 * DESCUNPACK-  Converts a descriptor back to a null-terminated string.
 *
 */
 
#define DESCALLOC(name) struct dsc$descriptor_s \
        (name) = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0}
 
#define DESCINIT(name, string)  \
        ((void)((name).dsc$a_pointer = (string),        \
        (name).dsc$w_length = strlen(string)))
 
#define DESCGETATTR(name, addr, length)                 \
        ((void)((addr) = (name).dsc$a_pointer,          \
        (length) = (name).dsc$w_length))
 
#define DESCUNPACK(name, string)                        \
        ((void)(strncpy(string),(name).dsc$a_pointer,   \
        (name).dsc$w_length),                           \
        string[(name).dsc$w_length] = '\0'))
 
#endif                                  /* __DESCRIP2_LOADED */
