r /*****************************************************************************************************************  ,  Program:	ATG_EDT		Interface to callable EDT  Module:	ATG_EDT.C	(the root)   Author:	Nick de Smith	May 1986 R 		Applied Telematics Group, 7 Vale Avenue, Tunbridge Wells, Kent TN1 1DJ, England.( 		+44 892 511000, PSI%234213300154::NICK  T  Copyright (c) 1987,1988,1989 by Applied Telematics Group Limited and Nick de Smith.m  This software is supplied for information only. No guarantee is supplied for this software, and no liability m  will be accepted for any action resulting from the use of this software or the information contained herein. i  Under no circumstances may this software be used for commercial gain, including its sale, lease or loan. N  This software may be copied only with the inclusion of this copyright notice.f  The author is prepared to enter into correspondance with interested parties, but will not necessarily8  maintain this software. Having said all that, enjoy it!    Discussion:4  This program acts as a front end to the EDT editor.  j  If /REMEMBER is used on the command line (the default), then ATG_EDT defines the following logical names:  U 	EDT$$GT_CURRENT_FILE			current output file name. This can be accessed in any spawned ) 						sub-process, or outside of ATG_EDT. ? 	EDT$$GT_LANGUAGE_TEMPLATE		language template file in the form:  							ATG$EDT:language.EDT   m  The language of an input file is determined by its file type. The table "r_template" contains a list of file i  types and the associated language. If the file type is not recognised, the language is set to "UNKNOWN". 1  In your EDTINI.EDT file, add a line of the form:   ' 		set command edt$$gt_language_template   q  This will execute the language initialiser for the file you are editing. If the initialiser does not exist, then   no error is generated.   L  The XLATE callback supplied in this module supports two modes of operation:  ' 	1) Called with a zero length parameter J 	   Spawn a sub-process. Suspend EDT session until sub-process terminates.+ 	2) Called with a non zero length parameter l 	   Execute the single command passed in a sub-process. Defines 0EDTIN.TMP as the sub-process SYS$INPUT, andm 	   0EDTOUT.TMP as the sub-process SYS$OUTPUT. These files can therefore be written and read by EDT commands.   q  Examples:	(replace <esc> by an escape character, and <ctl/z> by a control-Z character. Each "define key" command Q 		should be on a single line. "^Z" is exactly that! An up-arrow followed by a Z).    	insert =clear_screen  	<esc>[H<esc>[J  	^Z < 	define key gold $ as "ext write sys$output: =clear_screen ; 		change ; xlate<ctl/z> ref." V 	define key gold ^ as "ext clear edtfilter ; write sys$scratch:0edtin.tmp =edtfilter ;J 		change ; xlate?'DCL Command: '<ctl/z> ext inc sys$scratch:0edtout.tmp ."\ 	define key gold * as "cutsr=edtfilter ext find =edtfilter ; change ; er d-c ext find last ;+ 		write SYS$SCRATCH:0EDTIN.TMP =edtfilter ; M 		change ; xlate?'DCL Filter: '<ctl/z> ext include SYS$SCRATCH:0EDTOUT.TMP ."    	These lines define: 		GOLD $		Spawn a sub-process O 		GOLD ^		Execute a DCL command and include the output at the current position. ` 		GOLD *		Run a program that reads SYS$INPUT and writes SYS$OUTPUT to process the select region.] 				The current select region contents are written to a file that appears as SYS$INPUT to the \ 				program running in the sub-processes. The select region is replaced with SYS$OUTPUT from 				the sub-process.    To build:	$ CC /Debug ATG_EDT- 		$ Set Command /Object=EDT_TABLES EDT_TABLES ; 		$ Link /NoTraceback /NoMap /Exec=ATG_EDT SYS$INPUT/Option 
 		ATG_EDT.OBJ  		EDT_TABLES.OBJ 		SYS$SHARE:EDTSHR	/Share  		SYS$SHARE:VAXCRTL	/Share 		$! 		  Edit	Edit date	By	Reason   2.01	19-May-89	NMdS	VMS V5.1 !   01	09-Jul-86	NMdS	First attempt   r *****************************************************************************************************************/   #define	VERSION	"V2.01"  #module		ATG_EDT		VERSION   > #include	descrip							/* Define DSC$xxxx - VMS descriptors	*/@ #include	lnmdef							/* Define LNM$xxxx - Logical name flags	*/> #include	psldef							/* Define PSL$Cxxx - VMS access modes	*/: #include	rms							/* Define RMS$xxxx - RMS definitions	*/8 #include	ssdef							/* Define SS$_xxxx - VMS statii		*/? #include	stsdef							/* Define STS$Mxxx - VMS system statii	*/   3 #include	"climsgdef.h"						/* CLI defintiions			*/   0 #define	TRUE	(1 == 1)						/* Logical TRUE				*/1 #define	FALSE	(1 == 0)						/* Logical FALSE			*/   U #define	CURRENT_FILE		"EDT$$GT_CURRENT_FILE"			/* Logical for name of current file	*/ b #define	LANGUAGE_TEMPLATE	"EDT$$GT_LANGUAGE_TEMPLATE"		/* Logical for name of language template */U #define	TEMPLATE_DEFAULTS	"ATG$EDT:.EDT"				/* Defaults for language template name	*/   V #define	$DESC( string )	{ sizeof( string ) - 1, DSC$K_DTYPE_T, DSC$K_CLASS_S, string } static struct r_template {  	struct dsc$descriptor_s x_type;$ 	struct dsc$descriptor_s x_template; } r_template[] = {' 	/* File type	     Language template	*/ # 	{ $DESC( ".C"	) , $DESC( "C"		) }, # 	{ $DESC( ".H"	) , $DESC( "C"		) }, ( 	{ $DESC( ".MAR"	) , $DESC( "MACRO"	) },& 	{ $DESC( ".COM"	) , $DESC( "DCL"	) },( 	{ $DESC( ".BAS"	) , $DESC( "BASIC"	) },( 	{ $DESC( ".SUB"	) , $DESC( "BASIC"	) },( 	{ $DESC( ".INC"	) , $DESC( "BASIC"	) },) 	{ $DESC( ".PAS"	) , $DESC( "PASCAL"	) }, & 	{ $DESC( ".ADA"	) , $DESC( "ADA"	) },* 	{ $DESC( ".FTN"	) , $DESC( "FORTRAN"	) },* 	{ $DESC( ".FOR"	) , $DESC( "FORTRAN"	) },* 	{ $DESC( ".F77"	) , $DESC( "FORTRAN"	) },( 	{ $DESC( ".COB"	) , $DESC( "COBOL"	) },( 	{ $DESC( ".REQ"	) , $DESC( "BLISS"	) },( 	{ $DESC( ".B32"	) , $DESC( "BLISS"	) },( 	{ $DESC( ".BLI"	) , $DESC( "BLISS"	) },) 	{ $DESC( ".RNH"	) , $DESC( "RUNOFF"	) }, ) 	{ $DESC( ".RNO"	) , $DESC( "RUNOFF"	) }, ) 	{ $DESC( ".RNT"	) , $DESC( "RUNOFF"	) }, = 	{ $DESC( ""	) , $DESC( "UNKNOWN"	) },			/* End of list				*/  };  0 typedef	struct {							/* $TRNLNM item list			*/. 	unsigned size	: 16;						/* Buffer size				*/' 	unsigned	: 16;						/* Item code				*/ 2 	unsigned address: 32;						/* Buffer address			*/3 	unsigned	: 32;						/* Returned length address		*/  } TRNLNM_ITEM;  E globalvalue	EDT$M_NOOUTPUT;						/* Set if /NOOUTPUT or /READ_ONLY	*/ : globalvalue	EDT$M_NOCOMMAND;					/* Set if /NOCOMMAND			*/D globalvalue	EDT$M_COMMAND;						/* Set if /COMMAND=file specified	*/: globalvalue	EDT$M_NOJOURNAL;					/* Set if /NOJOURNAL			*/7 globalvalue	EDT$M_RECOVER;						/* Set if /RECOVER			*/ 9 globalvalue	EDT$M_NOCREATE;						/* Set if /NOCREATE			*/   R static	long xlate_executed = FALSE;					/* Set to true if edt_xlate is executed	*/  + /* Macro to check returned system status	*/   ! #define	ss_check( command ) {			\  	long ss_status = (command);		\ , 	if ( (ss_status & STS$M_SUCCESS) == 0 ) {	\ 		return ss_status;		\ 	}					\ }     r /*****************************************************************************************************************   					e d t _ m a i n  l  This is the main program. It retrieves the command line, parses it, prompts for an input file if necessary,  and then invokes EDT.  4  Returns error values returned from routines called.  r *****************************************************************************************************************/  
 edt_main() { D 	static struct dsc$descriptor_d x_tmp = {			/* Temporary string			*/' 		0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 }; C 	static struct dsc$descriptor_d x_in_file = {			/* Input file				*/ ' 		0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 }; E 	static struct dsc$descriptor_d x_out_file = {			/* Output file				*/ ' 		0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 }; F 	static struct dsc$descriptor_d x_com_file = {			/* Command file				*/' 		0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 }; F 	static struct dsc$descriptor_d x_jou_file = {			/* Journal file				*/' 		0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };   E 	unsigned long	edt_xlate();					/* Forward reference XLATE routine	*/ Z 	unsigned long	xlate_bpv[] = { edt_xlate, 0 };			/* Procedure description for edt_xlate	*/E 	unsigned long	l_options = 0;					/* Options flag for callable EDT	*/ 7 	globalvalue	EDT_TABLES;					/* EDT command tables			*/  	unsigned long	status;  = 	static $DESCRIPTOR( x_edt	, "EDT "	);		/* EDT verb name			*/ C 	static $DESCRIPTOR( x_input	, "INPUT"	);		/* Input file label			*/ I 	static $DESCRIPTOR( x_output	, "OUTPUT"	);		/* /[NO]OUTPUT=filespec			*/ K 	static $DESCRIPTOR( x_command	, "COMMAND"	);		/* /[NO]COMMAND=filespec		*/ K 	static $DESCRIPTOR( x_journal	, "JOURNAL"	);		/* /[NO]JOURNAL=filespec		*/ I 	static $DESCRIPTOR( x_read_only	, "READ_ONLY"	);		/* /[NO]READ_ONLY			*/ D 	static $DESCRIPTOR( x_recover	, "RECOVER"	);		/* /[NO]RECOVER				*/A 	static $DESCRIPTOR( x_create	, "CREATE"	);		/* /[NO]CREATE				*/ F 	static $DESCRIPTOR( x_remember	, "REMEMBER"	);		/* /[NO]REMEMBER			*/  Y 	static $DESCRIPTOR( x_current_file, CURRENT_FILE );		/* Logical name of current file		*/   B 	ss_check( LIB$GET_FOREIGN( &x_tmp ) )				/* Get command line			*/C 	ss_check( STR$PREFIX( &x_tmp, &x_edt ) )			/* Add in EDT verb			*/   ; 	ss_check( CLI$DCL_PARSE(					/* Parse the command line		*/  		&x_tmp		,  		EDT_TABLES	) )  V 	if ( CLI$PRESENT( &x_input ) & STS$M_SUCCESS ) {		/* If there was an input file...	*/ 		ss_check( CLI$GET_VALUE(
 			&x_input	,  			&x_in_file	) ) , 	} else {							/* No input file name...		*/= 		translate_logical(					/* Look for last file name edited	*/  			&x_current_file	, 			&x_in_file	);N 		while ( x_in_file.dsc$w_length == 0 ) {			/* While no file name is given		*/K 			static $DESCRIPTOR( x_prompt, "$_File: " );	/* Prompt string to use			*/ > 			ss_check( LIB$GET_COMMAND(			/* As for the file name...		*/ 				&x_in_file	, 				&x_prompt	) )  		}  	}  E 	switch( CLI$PRESENT( &x_output ) ) {				/* /[NO]OUTPUT=filespec			*/ + 		case CLI$_NEGATED:					/* /NOOUTPUT				*/  			l_options |= EDT$M_NOOUTPUT; 	 			break;  		case CLI$_PRESENT: 			ss_check( CLI$GET_VALUE(  				&x_output	,  				&x_out_file	) ) 	 			break; 
 		default:	 			break;  	}  K 	if ( CLI$PRESENT( &x_remember ) & STS$M_SUCCESS ) {		/* /[NO]REMEMBER			*/ _ 		static $DESCRIPTOR( x_template, LANGUAGE_TEMPLATE );	/* Logical name for language template	*/ ` 		static $DESCRIPTOR( x_defaults, TEMPLATE_DEFAULTS );	/* Defaults for language template name	*/I 		static struct dsc$descriptor_d x_current = {		/* Current file name			*/ ( 			0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };F 		static struct dsc$descriptor_d x_type = {		/* Current file type			*/( 			0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };W 		static struct dsc$descriptor_d x_language = {		/* Name of language template to use	*/ ( 			0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };S 		struct r_template * ar_template = r_template;		/* => first template structure		*/   N 		if ( x_out_file.dsc$w_length ) {			/* If there was an output file name...	*/W 			ss_check( STR$COPY_DX( &x_current, &x_out_file ) ) /* ...use the output file name	*/ 
 		} else {V 			ss_check( STR$COPY_DX( &x_current, &x_in_file ) ) /* ...use the input file name		*/ 		}  		ss_check( file_parse( * 			&x_current	,				/* Input file name			*/ 			0		,				/* No defaults				*/ / 			&x_current	,				/* Return file name here		*/ - 			&x_type		) )				/* Returned file type			*/   A 		ss_check( LIB$SET_LOGICAL(				/* Save the current file name		*/ 3 			&x_current_file	,				/* Logical name to set			*/ 1 			&x_current	) )				/* Value to set name to			*/   W 		while ( ar_template->x_type.dsc$w_length ) {		/* While some file types to check...	*/ [ 			if ( STR$COMPARE( &ar_template->x_type, &x_type ) == 0 ) { /* If we found the type...	*/ % 				break;					/* ...get out now			*/  			}= 			ar_template++;					/* ...else move on to next file type	*/  		}  		ss_check( file_parse( ; 			&ar_template->x_template	,		/* Template command name		*/ - 			&x_defaults			,		/* Defaults for name			*/ 9 			&x_language			,		/* Returned language template name	*/ ) 			0				) )		/* No returned file type		*/ E 		ss_check( LIB$SET_LOGICAL(				/* Save the language template name	*/ / 			&x_template	,				/* Logical name to set			*/ 2 			&x_language	) )				/* Value to set name to			*/ 	}  F 	switch( CLI$PRESENT( &x_journal ) ) {				/* /[NO]JOURNAL=filespec		*/, 		case CLI$_NEGATED:					/* /NOJOURNAL				*/  			l_options |= EDT$M_NOJOURNAL;	 			break; 2 		case CLI$_PRESENT:					/* /JOURNAL=filespec			*/ 			ss_check( CLI$GET_VALUE(  				&x_journal	, 				&x_jou_file	) ) 	 			break; 
 		default:	 			break;  	}  N  	if ( CLI$PRESENT( &x_read_only ) & STS$M_SUCCESS ) {		/* /[NO]READ_ONLY			*/ 		l_options |= EDT$M_NOOUTPUT; 	}  J 	if ( CLI$PRESENT( &x_recover ) & STS$M_SUCCESS ) {		/* /[NO]RECOVER				*/ 		l_options |= EDT$M_RECOVER;  	}  O 	if ( CLI$PRESENT( &x_create ) == CLI$_NEGATED ) {		/* /NOCREATE specified			*/  		l_options |= EDT$M_NOCREATE; 	}  - 	status = EDT$EDIT(						/* Execute EDT				*/ * 		&x_in_file	,					/* Input file name			*/, 		&x_out_file	,					/* Output file name			*/- 		&x_com_file	,					/* Command file name			*/ - 		&x_jou_file	,					/* Journal file name			*/ ( 		&l_options	,					/* Options flags			*/0 		0		,					/* File I/O routine BPV (not used)	*/5 		0		,					/* Work file I/O routine BPV (not used)	*/ , 		xlate_bpv	);					/* XLATE routine BPV			*/  H 	if ( xlate_executed ) {						/* If all was ok, and XLATE was used...	*/; 		static $DESCRIPTOR( x_files, "SYS$SCRATCH:0EDT*.TMP;*" ); L 		LIB$DELETE_FILE( &x_files );				/* Make sure all temp files are deleted	*/ 	}  9 	return status;							/* Return final status to caller	*/  }     r /*****************************************************************************************************************   					e d t _ x l a t e  <  This routine is called by EDT to process the XLATE command.o  The passed parameter, INSTRING, is the string of characters between the XLATE command and the trailing CTRL/Z. C  If INSTRING is null, the user wants to start a subprocess session. J  LIB$SPAWN is called with SYS$INPUT and SYS$OUTPUT as the command streams.  p  If INSTRING is not null, the user is processing one command and has created SYS$SCRATCH:0EDTIN.TMP as the inputZ  stream and wants SYS$SCRATCH:0EDTOUT.TMP to be used to capture the output of the command.  Z  Creates a subprocess via LIB$SPAWN. Returns when the subprocess has terminated execution.  b  XLATE_EXECUTED		Set to true if user executes single command to be included in the current buffer.     Returns the value of LIB$SPAWN   r *****************************************************************************************************************/ static unsigned long
 edt_xlate(F 	struct dsc$descriptor	*ax_instring	)			/* Input string descriptor		*/ { 9 	unsigned long	status;						/* Returned system status		*/   V 	if ( ax_instring->dsc$w_length == 0 ) {				/* If we want an interactive session...	*/  . 		static $DESCRIPTOR( x_sys_in, "SYS$INPUT" );0 		static $DESCRIPTOR( x_sys_out, "SYS$OUTPUT" );, 		static struct dsc$descriptor_d x_input = {( 			0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };- 		static struct dsc$descriptor_d x_output = { ( 			0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };  C 		ss_check( translate_logical(				/* Try to translate SYS$INPUT		*/  			&x_sys_in	, 			&x_input	) ) N 		if ( x_input.dsc$a_pointer[ 0 ] == 0x1B ) {		/* If SYS$INPUT is a PPF...		*/C 			ss_check( STR$COPY_DX(				/* ...just use the string SYS$INPUT	*/  				&x_input	, 				&x_sys_in	) )  		}   D 		ss_check( translate_logical(				/* Try to translate SYS$OUTPUT		*/ 			&x_sys_out	,  			&x_output	) )P 		if ( x_output.dsc$a_pointer[ 0 ] == 0x1B ) {		/* If SYS$OUTPUT is a PPF...		*/D 			ss_check( STR$COPY_DX(				/* ...just use the string SYS$OUTPUT	*/ 				&x_output	,  				&x_sys_out	) ) 		}   6 		status = LIB$SPAWN(					/* Spawn the sub-process		*/5 			0		,				/* No command, full interactive session	*/ 1 			&x_input	,				/* SYS$INPUT for sub-process		*/ 4 			&x_output	);				/* SYS$OUTPUT for sub-process		*/	 	} else {  	/* ) 		User wants to execute a single command. & 		SYS$INPUT  => SYS$SCRATCH:0EDTIN.TMP' 		SYS$OUTPUT => SYS$SCRATCH:0EDTOUT.TMP  	*/ : 		static $DESCRIPTOR( x_tmpin, "SYS$SCRATCH:0EDTIN.TMP" );< 		static $DESCRIPTOR( x_tmpout, "SYS$SCRATCH:0EDTOUT.TMP" );   		status = LIB$SPAWN( . 			ax_instring	,				/* Command to execute			*/' 			&x_tmpin	,				/* SYS$INPUT name			*/** 			&x_tmpout	);				/* SYS$OUTPUT name			*/  A 		if ( status & STS$M_SUCCESS ) {				/* If SPAWN succeeded...		*/a@ 			xlate_executed = TRUE;				/* ...remember to clean up files	*/ 		}i 	}  d 	/* We should free up the input string else it will be interpreted as nokeypad mode commands for EDT 	   to execute.												*/  	ss_check( STR$FREE1_DX(2 		ax_instring	) )					/* Return a null string			*/  9 	return status;							/* Return final status to caller	*/  }r e  r /*****************************************************************************************************************  % 				t r a n s l a t e _ l o g i c a ln  X  Translate a logical name in table LNM$FILE_DEV, and return the translation to the user.!  This is a one level translation.m<  Return SS$_NORMAL for success, system error code otherwise.  r *****************************************************************************************************************/ static translate_logical(I 	struct dsc$descriptor	*ax_lognam	,			/* => Logical name to translate		*/EI 	struct dsc$descriptor	*ax_trans	)			/* => returned translation if any	*/  {_@ 	char	b_buffer[ LNM$C_NAMLENGTH ];				/* Translation buffer			*/P 	struct dsc$descriptor_s x_buffer = {				/* Descriptor for translation buffer	*/< 		LNM$C_NAMLENGTH, DSC$K_DTYPE_T, DSC$K_CLASS_S, b_buffer };  	TRNLNM_ITEM	trnlnm_itmlst[] = {D 		LNM$C_NAMLENGTH	, LNM$_STRING	, b_buffer, &x_buffer.dsc$w_length ,< 		0		, 0		, 0	, 0 };		/* Terminate list with a null entry	*/U 	static	$DESCRIPTOR( x_tabnam, "LNM$FILE_DEV" );		/* Logical name table to search		*/a  D 	ss_check( STR$FREE1_DX( ax_trans ) )				/* Clear output string			*/  9 	ss_check( SYS$TRNLNM(						/* Translate logical name		*/ D 		&LNM$M_CASE_BLIND ,					/* Ignore case in the logical name scan	*/) 		&x_tabnam	,					/* Table to search			*/ 2 		ax_lognam	,					/* Logical name to translate		*/2 		&PSL$C_USER	,					/* Use highest access mode		*/= 		trnlnm_itmlst	) )					/* Item list of actions to perform	*/s  W 	ss_check( STR$COPY_DX( ax_trans, &x_buffer ) )			/* Copy the translated string back	*/a  7 	return SS$_NORMAL;						/* Return sucess to caller		*/e }  i  r /*****************************************************************************************************************   					f i l e _ p a r s e  h  Parse the supplied input filename appling defaults. Return any error conditions and disallow wildcards.  r *****************************************************************************************************************/ static file_parse(sA 	struct	dsc$descriptor	* ax_infile	,			/* Input to the parse			*/lQ 	struct	dsc$descriptor	* ax_defaults	,			/* Defaults to apply during the parse	*/iE 	struct	dsc$descriptor  * ax_outfile	,			/* Output from the parse		*/ ? 	struct	dsc$descriptor	* ax_type	)			/* Returned file type			*/  {d= 	char	outbuf[ NAM$C_MAXRSS ];					/* Parse output buffer			*/t@ 	struct	FAB	fab = cc$rms_fab;				/* File access block to use		*/: 	struct	NAM	nam = cc$rms_nam;				/* Name block to use			*/@ 	unsigned short w_temp;						/* 16 bit version of byte values	*/   	if ( ax_defaults ) {CV 		fab.fab$l_dna = ax_defaults->dsc$a_pointer;		/* Default file specification string	*/M 		fab.fab$b_dns = ax_defaults->dsc$w_length;		/* Default file string size		*/u 	}R 	fab.fab$l_fna = ax_infile->dsc$a_pointer;			/* Input file specification string	*/K 	fab.fab$b_fns = ax_infile->dsc$w_length;			/* Input file string length		*/S< 	fab.fab$w_ifi = 0;						/* Internal file identifier MBZ		*/@ 	fab.fab$l_nam = &nam;						/* Save address of NAM in the FAB	*/  < 	nam.nam$l_esa = outbuf;						/* Expanded string address		*/C 	nam.nam$b_ess = NAM$C_MAXRSS;					/* Expanded string area size		*/	? 	nam.nam$b_nop = NAM$M_SYNCHK;					/* Do syntax check only			*/S  H 	if ( SYS$PARSE( &fab ) != RMS$_NORMAL ) {			/* Try to do the parse			*/< 		return fab.fab$l_sts;					/* Return reason for failure		*/ 	}L 	if ( nam.nam$l_fnb & NAM$M_WILDCARD ) {				/* If wildcards were used...		*/9 		return RMS$_WLD;					/* ...tell user "no wildcards"		*/t 	}  L 	w_temp = (unsigned short) nam.nam$b_esl;			/* Convert the output length		*/O 	ss_check( STR$COPY_R( ax_outfile, &w_temp, outbuf ) )		/* Copy the output			*/e  9 	if ( ax_type ) {						/* If we want the file type...		*/eN 		w_temp = (unsigned short) nam.nam$b_type;		/* ...convert the type length		*/> 		ss_check( STR$COPY_R(					/* ...and return the file type		*/
 			ax_type		,	
 			&w_temp		,	 			nam.nam$l_type	) )/ 	}/ 	return SS$_NORMAL;						/* Return success			*/  }d n