< (* DELIVER.PAS - General MAIL delivery manager for VMS MAIL.  ;    Written by Ned Freed, 23-Sep-1985, modified 30-Apr-1986. ?    Mail dispatch interface originally written by Kevin Carosso. 6    Some modifications by Sheldon Smith, December 1986.G    Rewrite by Ned Freed to use new $GETUAI system service, 15-Dec-1986. :    This change requires the use of VMS 4.4 and Pascal 3.4.@    Additional changes by Shel Smith and Andy Leslie, 6-Sep-1988.F    Added support for use of SJC$_USER_IDENTIFICATION item code, to getD      around problems with SJC$_USERNAME. Since this item code is notE      documented and may be removed in the future the support for this G      feature is conditional -- the constant use_sjc_user_identification       controls it.   C    DELIVER provides a general-purpose MAIL delivery manager similar @    to the MMDF-II MAILDELIVERY system. DELIVER makes it possibleC    for users to set up a file containing screening information that A    automatically deals with each incoming message. Actions may be B    selectively taken by DELIVER based on information in the From:,1    To: and Subject: fields of the message header.   B    DELIVER operates as a foreign mail interface to VMS MAIL and isF    invoked with a call to LIB$FIND_IMAGE_SYMBOL in MAIL. The shareableI    image containing this code should be placed in SYS$LIBRARY as the file     DELIVER_MAILSHR.EXE).  A    Users may activate DELIVER by setting their forwarding address E    to DELIVER%username, where "username" is the user's own user name. D    In order for DELIVER to perform any useful function a file calledG    MAIL.DELIVERY must be present in the user's default login directory.   K    DELIVER's operation is only meaningful in outgoing mode; however, rather F    than waste a possible incoming MAIL interface, DELIVER implements aK    rudimentary mail posting mechanism on the incoming side that can be used I    to send messages contained in data files. Full privileges are required B    to run DELIVER in this mode since it is possible to forge From:"    addresses using this mechanism.     Note: A     The foreign protocol interface within MAIL is undocumented at @     this time.  It may change without notice in a future release     of VMS.   D     The information necessary to write this code comes from the MAILE     source on the VMS microfiche.  The most useful information is the G     routine NETJOB in module MAIL$MAIL (230-E2), which handles incoming G     foreign mail, and the various routines in module NETSUBS (230-N11), 2     most of which deal with outgoing foreign mail.     Revision history:        PMDF 3.1 release:   :       13-Jul-1989, Ned Freed, Innosoft International, Inc.  L         Changed the batch queue from MAIL$BATCH to DELIVER_BATCH, to make it=         easier to run in a different queue than PMDF runs in.   #         Added support for CC lines.   C         Change DELIVER$STATUS to DELIVER_STATUS, DELIVER$MESSAGE to E         DELIVER_MESSAGE, and change the incoming interface to look at 0         the symbol DELIVER_FROM instead of FROM.  A         Added the K, L, and M actions (all for easier debugging):   4           K - Keep the command file after execution.N           L - Keep the log file after execution -- log file name is parameter.H           M - Keep the message after execution -- same as MESSAGE_DELETE               flag.   9       3-Oct-1989, Ned Freed, Innosoft International, Inc.   H         Added the ability to specify a CC line with a DELIVER_CC symbol.  =       15-Sep-92, Dick Munroe, Doyle, Munroe Consultants, Inc.  	         267 Cox St.  	         Hudson, Ma.  01749 	         munroe@dmc.com  6 	Add the ability to turn debugging on/off dynamically.  ; 		DELIVER_DEBUG_IN    If defined, input debugging is armed. < 		DELIVER_DEBUG_OUT   If defined, output debugging is armed.  D 	There appears to be a problem in MAIL.  If SYSPRV is enabled, thereK         seems to be a bug in MAIL preventing the sharable images from being O         properly invoked.  If BYPASS is asserted, everything works just fine or O         if NO privileges are asserted, everything works just fine.  Note that a N         test for bypass CANNOT be put into IN_CONNECT since that would preventM         the normal delivery mechanism from working properly.  The test is put O         into the generated command file and if BYPASS is not available, MAIL is          not invoked.  B 	The to address must be quoted on forwarding to allow use of other! 	transports as forward addresses.   I 	I believe that setting the "matched" switch for the K, L, and M flags is F 	unreasonable.  These are intended to capture output state and must be8 	present in ways that screw up the rest of the behavior.  <       16-Sep-92 Dick Munroe, Doyle, Munroe Consultants, Inc.  B 	Setting the 'L' flag doesn't actually keep the log.  It now does.  <       16-Nov-92 Dick Munroe, Doyle, Munroe Consultants, Inc. 	 B 	If the command procedure is created without S:RD protection, thenH 	deliver can't execute and delete the command procedure.  Since it can'tF 	hurt to make the command procedure have wide open protections, create, 	the command procedure with all protections.  F 	Allow the forward and privileged forward to have a list of arguments.C 	the logic for quoting the forwarding addresses now takes that into 	 	account.  *)  : [inherit ('SYS$LIBRARY:STARLET')] module deliver (output);   const   2   (* Switch for use of SJC$_USER_IDENTIFICATION *)&   use_sjc_user_identification = false;  K   LNK_C_OUT_CONNECT  = 0;       (* MAIL protocol link actions.           *) K   LNK_C_OUT_SENDER   = 1;       (* These are defined in MAILSHR.MAR      *) K   LNK_C_OUT_CKUSER   = 2;       (* but because we cannot have external   *) K   LNK_C_OUT_TO       = 3;       (* constants in Pascal, they are         *) K   LNK_C_OUT_SUBJ     = 4;       (* redefined here.                       *)    LNK_C_OUT_FILE     = 5;    LNK_C_OUT_CKSEND   = 6;    LNK_C_OUT_DEACCESS = 7;      LNK_C_IN_CONNECT = 8;    LNK_C_IN_SENDER  = 9;    LNK_C_IN_CKUSER  = 10;   LNK_C_IN_TO      = 11;   LNK_C_IN_SUBJ    = 12;   LNK_C_IN_FILE    = 13;     LNK_C_IO_READ  = 14;   LNK_C_IO_WRITE = 15;     LNK_C_IN_CC = 16;    LNK_C_OUT_CC = 17;     LNK_C_IN_ATTRIBS = 18;   LNK_C_OUT_ATTRIBS = 19;   D   parameter_size     = 256;     (* Size of a single parameter in theG                                    MAIL.DELIVERY file. This is also the O                                    maximum size of lines read from any file. *) D   max_parameters     = 7;       (* Maximum number of parameters that<                                    can appear on a line in a8                                    MAIL.DELIVERY file *)D   min_parameters     = 5;       (* Minimum number of parameters that<                                    can appear on a line in a8                                    MAIL.DELIVERY file *)E   from_parameter     = 1;       (* Position of the From: parameter *) C   to_parameter       = 2;       (* Position of the To: parameter *) H   subject_parameter  = 3;       (* Position of the Subject: parameter *)H   decision_parameter = 4;       (* Position of the decision parameter *)F   action_parameter   = 5;       (* Position of the action parameter *)H   argument_parameter = 6;       (* Position of the argument parameter *)  N   stack_size = 10;              (* State mach. stack for messages from MAIL *)  K   DCL_line_size = 256;          (* Maximum possible line allowed by DCL. *)    type,   string = varying [parameter_size] of char;  J   (* A string descriptor type used to handle the descriptors MAIL hands to      DELIVER. *)<   longest_possible_string = packed array [1..65536] of char;   string_descriptor = record1                         length : [word] 0..65535; 6                         dclass, dtype : [byte] 0..255;;                         address : ^longest_possible_string;                        end;  C   (* Storage for a single line of MAIL.DELIVERY file information *) )   parameter_block_ptr = ^parameter_block;    parameter_block = recordH                       parameters  : array [1..max_parameters] of string;8                       next        : parameter_block_ptr;,                       any_from    : boolean;,                       any_to      : boolean;,                       any_subject : boolean;5                     end; (* parameter_block record *)   -   account_name = packed array [1..8] of char; +   user_name = packed array [1..12] of char;    priorities = [byte] 0..255;   I   (* Storage for information about a single recipient. The uic, username, E      account and priority fields are ordered to match the format of a @      SJC$_USER_IDENTIFICATION buffer and cannot be reordered. *)   user_block_ptr = ^user_block;    user_block = record (                  uic         : unsigned;)                  username    : user_name; ,                  account     : account_name;-                  priority    : [byte] 0..255; /                  user_length : [word] 0..65535; &                  directory   : string;3                  rules_list  : parameter_block_ptr; .                  next        : user_block_ptr;4                  copyname    : varying [29] of char;+                end; (* user_block record *)   :   (* Possible reasons why MAIL_IO_WRITE will be called. *)B   write_states = (bad_msg, user_check, delivery_check, error_msg);  B   (* A stack structure to store information about pending calls to      MAIL_IO_WRITE. *)   write_state_stack = record&                         top : integer;F                         store : array [1..stack_size] of write_states;9                       end; (* write_state_check record *)   "   (* Record for VMS item lists. *)   item = record $            len    : [word] 0..65535;$            code   : [word] 0..65535;#            addr   : [long] integer; #            rlen   : [long] integer;           end; (* item record *)   1   file_attribute_block = array [0..1] of integer;    var    (* Debugging control flags *) Q   DEBUG_IN  : boolean := false;				(* Debug messages produced by receive code. *) Q   DEBUG_OUT : boolean := false;				(* Debug messages produced by send code.    *)    =   batch_queue : [static, readonly] string := 'DELIVER_BATCH'; @   system_batch_queue : [static, readonly] string := 'SYS$BATCH';  =   batch_log : [static] string; batch_keep : [static] boolean; d   batch_log_keep : [static] boolean ;			(* True if the log file is to be kept, false otherwise.			*)  C   (* Storage for message header information on the outgoing side *) B   tostring, fromstring, subjectstring, ccstring : [static] string;  <   (* List of active recipients and associated information *)6   user_list, user_list_last : [static] user_block_ptr;%   user_count : [static] integer := 0;       from_owner : [static] boolean;  ?   (* Storage for accumulated To: line for incoming messages. *)      toline : [static] string;   6   (* The state machine for MAIL status information. *)  )   write_recv_states  : write_state_stack;    last_error : integer;   6   (* Error message codes defined in DELIVER_ERR.MSG *))   DELIVER__GOTNOSYSPRV, DELIVER__NOTPRIV, @   DELIVER__CANACCUAF, DELIVER__NOSUCHUSER, DELIVER__NAMETOOLONG,G   DELIVER__NODEFAULTDIR, DELIVER__TOOMANYPARAMS, DELIVER__TOOFEWPARAMS, N   DELIVER__NOMDFILE, DELIVER__MDIGNORED, DELIVER__NORULES, DELIVER__MESREAERR,P   DELIVER__GETFILERR, DELIVER__MESWRTERR, DELIVER__INTSTKOVR, DELIVER__STKEMPTY,=   DELIVER__BADSTKELE, DELIVER__MESOPNERR, DELIVER__MSGWRTERR, G   DELIVER__MSGREAERR, DELIVER__USERNOEXIST : [external, value] integer;   , (* Routine to get job/process information *)   function LIB$GETJPI ( =   item_code : integer; var process_id : unsigned := %immed 0; =   process_name : [readonly] varying [u1] of char := %immed 0; '   var out_value : unsigned := %immed 0; 4   var out_string : varying [u2] of char := %immed 0;9   var out_len : integer := %immed 0) : integer; external;    (* Routine to signal errors *)  D procedure LIB$SIGNAL (%IMMED stat : [list, unsafe] integer); extern;  , (* Routine to read command line arguments *)  6 function CLI$GET_VALUE (name : varying [max1] of char;6   var val : varying [max2] of char) : integer; extern;  " (* Routine to get symbol values *)  7 function LIB$GET_SYMBOL (name : varying [max1] of char; 9   var result : varying [max2] of char) : integer; extern;   " (* Routine to set symbol values *)  7 function LIB$SET_SYMBOL (name : varying [max1] of char; 5   svalue : varying [max2] of char) : integer; extern;    [ INITIALIZE ]) FUNCTION initializationRoutine: integer ;         {      FUNCTIONAL DESCRIPTION:        G 	This routine is invoked by the LIB$INITIALIZATION process during image C 	startup.  It exists to initialize the debugging log, if necessary.             FORMAL PARAMETERS:          	none             IMPLICIT INPUTS:       2 	Logical names DELIVER_DEBUG_IN, DELIVER_DEBUG_OUT            IMPLICIT OUTPUTS:        < 	debug_in set to TRUE if DELIVER_DEBUG_IN has a translation.> 	debug_out set to TRUE if DELIVER_DEBUG_OUT has a translation.            ROUTINE VALUE:        	%[description_or_none]%            SIDE EFFECTS:         	%[description_or_none]%     }                VAR  	status :	integer; 	translation :	string;  	     BEGIN 
     status := 
 	$trnlnm ( 	    tabnam := 'LNM$FILE_DEV',$ 	    lognam := 'DELIVER_DEBUG_IN') ;]     debug_in := odd(status) ;				(* Write debugging output during input mail processing.			*) R     if DEBUG_IN then writeln ('In initialize routine.  DELIVER_DEBUG_IN is set.');
     status := 
 	$trnlnm ( 	    tabnam := 'LNM$FILE_DEV',$ 	    lognam := 'DELIVER_DEBUG_OUT');`     debug_out := odd(status) ;				(* Write debugging output during oututput mail processing.		*)T     if DEBUG_OUT then writeln ('In initialize routine.  DELIVER_DEBUG_OUT is set.');%     initializationRoutine := status ; C     END;						(* End FUNCTION initializationRoutine: integer ;			*)    J (* create_with_SYSPRV is a Pascal user-action routine for OPEN statements.J    It enables SYSPRV while doing certain OPEN's so we can write files into    user directories. *)    0 function create_with_SYSPRV (var fab : FAB$TYPE;0                              var rab : RAB$TYPE;7                              var fil : text) : integer;  var @   stat : integer; ppriv, priv : [quad] array [0..1] of unsigned;+   xabpro : [volatile] xab$type value zero ;    begin (* create_with_SYSPRV *)(   priv[0] := PRV$M_SYSPRV; priv[1] := 0;N   stat := $SETPRV (ENBFLG := 1, PRVADR := priv, PRMFLG := 0, PRVPRV := ppriv);   if odd (stat) then beginJ     xabpro.xab$b_cod := XAB$C_PRO ;			(* This is a protection XAB.						*)H     xabpro.xab$b_bln := XAB$K_PROLEN ;			(* This is the length.							*)p     xabpro.xab$w_pro := 16#'ff00' ;			(* System and owner get all provileges.  Everyone else can suck rocks!.	*)4     FAB.FAB$L_XAB := (ADDRESS( xabpro ))::unsigned ;     <     FAB.FAB$V_LNM_MODE := PSL$C_EXEC; stat := $CREATE (FAB);.     if odd (stat) then stat := $CONNECT (RAB);   end;-   priv[0] := uand (priv[0], unot (ppriv[0])); -   priv[1] := uand (priv[1], unot (ppriv[1])); 5   $SETPRV (ENBFLG := 0, PRVADR := priv, PRMFLG := 0);    create_with_SYSPRV := stat;  end; (* create_with_SYSPRV *)   H (* open_with_SYSPRV is a Pascal user-action routine for OPEN statements.E    It enables SYSPRV while doing certain OPEN's so we can read system     files. *)  . function open_with_SYSPRV (var fab : FAB$TYPE;.                            var rab : RAB$TYPE;5                            var fil : text) : integer;  var @   stat : integer; ppriv, priv : [quad] array [0..1] of unsigned;   begin (* open_with_SYSPRV *)(   priv[0] := PRV$M_SYSPRV; priv[1] := 0;N   stat := $SETPRV (ENBFLG := 1, PRVADR := priv, PRMFLG := 0, PRVPRV := ppriv);   if odd (stat) then begin:     FAB.FAB$V_LNM_MODE := PSL$C_EXEC; stat := $OPEN (FAB);.     if odd (stat) then stat := $CONNECT (RAB);   end;-   priv[0] := uand (priv[0], unot (ppriv[0])); -   priv[1] := uand (priv[1], unot (ppriv[1])); 5   $SETPRV (ENBFLG := 0, PRVADR := priv, PRMFLG := 0);    open_with_SYSPRV := stat;  end; (* open_with_SYSPRV *)   F (* find_user_directory locates a user in the system authorization fileC    and returns his or her default login directory (which is where a D    MAIL.DELIVERY file must reside). find_user_directory also returnsC    the user's UIC and account since this information will be neededi*    for creating the delivery batch job. *)  > function find_user_directory (username : varying [l1] of char;7   var user_directory : string; var user_uic : unsigned;cH   var user_account : account_name; var priority : priorities) : boolean;   varA4   device_with_prefix : packed array [1..16] of char;7   directory_with_prefix : packed array [1..64] of char;I/   items : array [1..6] of item; stat : integer;J0   ppriv, priv : [quad] array [0..1] of unsigned;   begin (* find_user_directory *)u<   if DEBUG_OUT then writeln ('find_user_directory called.');   find_user_directory := false;t    if length (username) > 12 then(     LIB$SIGNAL (DELIVER__NAMETOOLONG, 2,:                 username.length, iaddress (username.body))   else begin     with items[1] do beginI       len := 4; code := UAI$_UIC; addr := iaddress (user_uic); rlen := 0;a     end; (* with *)      with items[2] do begin%       len := 8; code := UAI$_ACCOUNT;i1       addr := iaddress (user_account); rlen := 0;s     end; (* with *)r     with items[3] do begin%       len := 16; code := UAI$_DEFDEV;n7       addr := iaddress (device_with_prefix); rlen := 0;M     end; (* with *)      with items[4] do begin%       len := 64; code := UAI$_DEFDIR;f:       addr := iaddress (directory_with_prefix); rlen := 0;     end; (* with *)f     with items[5] do beginI       len := 1; code := UAI$_PRI; addr := iaddress (priority); rlen := 0;      end; (* with *)m     with items[6] do begin0       len := 0; code := 0; addr := 0; rlen := 0;     end; (* with *)r?     (* Enable SYSPRV to check for valid user recipient-name. *) *     priv[0] := PRV$M_SYSPRV; priv[1] := 0;H     $SETPRV (ENBFLG := 1, PRVADR := priv, PRMFLG := 0, PRVPRV := ppriv);:     stat := $GETUAI (usrnam := username, itmlst := items);>     if DEBUG_OUT then writeln ('  $GETUAI returned status: "',+                                stat, '".');i=     if stat = SS$_NOPRIV then LIB$SIGNAL (DELIVER__CANACCUAF).$     else if stat = SS$_NOSYSPRV then;       LIB$SIGNAL (DELIVER__GOTNOSYSPRV, 2, username.length,t+                   iaddress (username.body))e     else if not odd (stat) thent)       LIB$SIGNAL (DELIVER__NOSUCHUSER, 2, <                   username.length, iaddress (username.body))     else begin6       user_directory := substr (device_with_prefix, 2,>                                 ord (device_with_prefix[1])) +9                         substr (directory_with_prefix, 2, @                                 ord (directory_with_prefix[1]));:       if DEBUG_OUT then writeln ('  Default directory: "',7                                  user_directory, '".');CE       if DEBUG_OUT then writeln ('  Account: "', user_account, '".');eG       if DEBUG_OUT then writeln ('  UIC: ', hex (user_uic, 8, 8), '.'); *       if length (user_directory) <= 0 then-         LIB$SIGNAL (DELIVER__NODEFAULTDIR, 2,c>                     username.length, iaddress (username.body))'       else find_user_directory := true;e1       (* Disable and reestablish former privs. *))1       priv[0] := uand (priv[0], unot (ppriv[0]));c1       priv[1] := uand (priv[1], unot (ppriv[1]));t9       $SETPRV (ENBFLG := 0, PRVADR := priv, PRMFLG := 0);m     end;   end; end; (* find_user_directory *)  H (* copy_descr_to_string copies a MAIL string (passed by descriptor) into    a Pascal VARYING string. *)    procedure copy_descr_to_string (&   var mail_string : string_descriptor;/   var out_string : string; DEBUG_ON : boolean);    varo   index : integer;    begin (* copy_descr_to_string *)<   if DEBUG_ON then writeln ('copy_descr_to_string called.');   out_string := '';_/   if mail_string.length > 256 then index := 256E#   else index := mail_string.length;d   for index := 1 to index do;     out_string := out_string + mail_string.address^[index]; D   if DEBUG_ON then writeln ('  String copied: "', out_string, '".'); end; (* copy_descr_to_string *)   I (* copy_string_to_descr copies a Pascal VARYING string into a MAIL stringg    (passed by descriptor). *)k    procedure copy_string_to_descr (   var in_string : string;u;   var mail_string : string_descriptor; DEBUG_ON : boolean);l  4   [asynchronous, unbound, external (LIB$SCOPY_DXDX)]9   function copy_string (var src : varying [max1] of char; 3     var dst : string_descriptor) : integer; extern;T    begin (* copy_string_to_descr *)<   if DEBUG_ON then writeln ('copy_string_to_descr called.');'   copy_string (in_string, mail_string);dC   if DEBUG_ON then writeln ('  String copied: "', in_string, '".');e end; (* copy_string_to_descr *)m  F (* charupper is a simple function to convert characters to upper case.>    The full DEC Multinational Character Set is accomodated. *)  & function charupper (ch : char) : char;   begin (* charupper *) %   if (ch >= 'a') and (ch <= 'z') thenC9     charupper := chr (ord (ch) + (ord ('A') - ord ('a')))w6   else if (ord (ch) >= 224) and (ord (ch) <= 253) then-     charupper := chr (ord (ch) + (192 - 224))    else charupper := ch;  end; (* charupper *)  > (* dispose_rules_list disposes of heap storage associated with!    a list of parameter blocks. *)e  D procedure dispose_rules_list (var rules_list : parameter_block_ptr);   var "   temp_list : parameter_block_ptr;   begin (* dispose_rules_list *)"   while rules_list <> nil do begin<     temp_list := rules_list; rules_list := rules_list^.next;     dispose (temp_list);$   end; (* while rules_list <> nil *) end; (* dispose_rules_list *)l  = (* dispose_user_list disposes of heap storage associated withT!    a list of user name blocks. *)   = procedure dispose_user_list (var user_list : user_block_ptr);v   varn   temp_list : user_block_ptr;=   begin (* dispose_user_list *) !   while user_list <> nil do beginU9     temp_list := user_list; user_list := user_list^.next;*D     dispose_rules_list (temp_list^.rules_list); dispose (temp_list);#   end; (* while user_list <> nil *)T end; (* dispose_user_list *)  D (* read_maildelivery_file reads the contents of a MAIL.DELIVERY file?    and creates a rules_list structure. Any errors are signalledN    by returning FALSE. *)_  2 function read_maildelivery_file (var dfile : text;2   var rules_list : parameter_block_ptr) : boolean;   label    99;    varS8   current, last : parameter_block_ptr; quoted : boolean;:   pindex, lindex, rindex, lcount : integer; line : string;     procedure addch (ch : char);     labels     88;m     var.     cindex : integer;      begin (* addch *)m)     if pindex > max_parameters then begin H       if FROM_OWNER then LIB$SIGNAL (DELIVER__TOOMANYPARAMS, 1, lcount);       goto 99;     end;@     if current = nil then if (ch = '!') or (ch = ';') then begin=       if DEBUG_OUT then writeln ('  Skipping comment line.'); '       lindex := length (line); goto 88;M     end else begin       new (current);       with current^ do beginF         for cindex := 1 to max_parameters do parameters[cindex] := '';         next := nil;       end; (* with current^ *)       rindex := rindex + 1;a;       if DEBUG_OUT then writeln (' Rule #', rindex:0, '.');d       if last = nil then begin/         last := current; rules_list := current;a       end else begin/         last^.next := current; last := current; 
       end;     end;D     current^.parameters[pindex] := current^.parameters[pindex] + ch;   88:    end; (* addch *)  " begin (* read_maildelivery_file *)?   if DEBUG_OUT then writeln ('read_maildelivery_file called.');c<   read_maildelivery_file := false; last := nil; lcount := 0;   rindex := 0;    while not eof (dfile) do begin/     readln (dfile, line); lcount := lcount + 1;;K     if DEBUG_OUT then writeln ('  Line from MAIL.DELIVERY: "', line, '".');5>     pindex := 1; current := nil; lindex := 1; quoted := false;*     while lindex <= length (line) do beginE       if (not quoted) and (line[lindex] in [' ', chr (9)]) then begin ?         if current <> nil then if pindex <= max_parameters then @           if length (current^.parameters[pindex]) > 0 then beginK             if DEBUG_OUT then writeln ('  Parameter #', pindex:0, ' is: "', J                                        current^.parameters[pindex], '".');!             pindex := pindex + 1;o           end;/       end else if line[lindex] = '"' then begin &         if length (line) > lindex then,           if line[lindex+1] = '"' then begin1             addch ('"'); lindex := succ (lindex);]'           end else quoted := not quoted "         else quoted := not quoted;C       end else if quoted and (pindex > 5) then addch (line[lindex]) ,       else addch (charupper (line[lindex]));       lindex := lindex + 1;      end; (* while not eoln *) 1     if current <> nil then with current^ do begin=&       if pindex <= max_parameters then5         if length (parameters[pindex]) > 0 then begin I           if DEBUG_OUT then writeln ('  Parameter #', pindex:0, ' is: "',:?                                      parameters[pindex], '".');            pindex := pindex + 1;s         end;       pindex := pindex - 1;m+       if pindex < min_parameters then begin I         if FROM_OWNER then LIB$SIGNAL (DELIVER__TOOFEWPARAMS, 1, lcount);          goto 99;
       end;=       any_from      := parameters[from_parameter]      = '*'; =       any_to        := parameters[to_parameter]        = '*';c=       any_subject   := parameters[subject_parameter]   = '*';b1       if parameters[subject_parameter] = '"' thent,         parameters[subject_parameter] := '';     end;   end; (* while not eof *)I   if FROM_OWNER and (rules_list = nil) then LIB$SIGNAL (DELIVER__NORULES)n&   else read_maildelivery_file := true;   99:r   close (dfile);! end; (* read_maildelivery_file *)   J (* MAIL_OUT_CONNECT is called by VMS MAIL to initiate a send operation. *)  ; [global] function MAIL_OUT_CONNECT (var context : unsigned;    var link_flag : integer;)   var protocol, node : string_descriptor;1   var log_link_error : integer;g#   var file_RAT, file_RFM : integer;    var MAIL$GL_FLAGS : integer;3   var attached_file : string_descriptor) : integer;o   begin (* MAIL_OUT_CONNECT *)H   fromstring := ''; tostring := ''; subjectstring := ''; ccstring := '';   user_list_last := nil;9   if DEBUG_OUT then writeln ('MAIL_OUT_CONNECT called.');S!   MAIL_OUT_CONNECT := SS$_NORMAL;s end; (* MAIL_OUT_CONNECT *)b  F (* MAIL_OUT_LINE is called by VMS MAIL whenever a single line of stuff2    must be delivered to the DELIVER mail relay. *)  8 [global] function MAIL_OUT_LINE (var context : unsigned;   var link_flag : integer;0   var node, line : string_descriptor) : integer;   begin (* MAIL_OUT_LINE *)c6   if DEBUG_OUT then writeln ('MAIL_OUT_LINE called.');   case iaddress (link_flag) of*     (* MAIL is delivering a To: address *)     LNK_C_OUT_TO     : beginM                          if DEBUG_OUT then writeln ('  OUT_TO option used.');cJ                          copy_descr_to_string (line, tostring, DEBUG_OUT);.                        end; (* LNK_C_OUT_TO *),     (* MAIL is delivering a From: address *)     LNK_C_OUT_SENDER : begin*                          if DEBUG_OUT thenA                            writeln ('  OUT_SENDER option used.'); L                          copy_descr_to_string (line, fromstring, DEBUG_OUT);2                        end; (* LNK_C_OUT_SENDER *),     (* MAIL is delivering a Subject: line *)     LNK_C_OUT_SUBJ   : beginO                          if DEBUG_OUT then writeln ('  OUT_SUBJ option used.');GO                          copy_descr_to_string (line, subjectstring, DEBUG_OUT); 0                        end; (* LNK_C_OUT_SUBJ *)'     (* MAIL is delivering a Cc: line *)n     LNK_C_OUT_CC     : beginM                          if DEBUG_OUT then writeln ('  OUT_CC option used.'); J                          copy_descr_to_string (line, ccstring, DEBUG_OUT);.                        end; (* LNK_C_OUT_CC *)   end; (* case *)r   MAIL_OUT_LINE := SS$_NORMAL; end; (* MAIL_OUT_LINE *)  D (* MAIL_OUT_CHECK is called once with each addressee for the currentB    message and once again after the message body has been sent. *)  " [global] function MAIL_OUT_CHECK (   var context : unsigned;    var link_flag : integer;.   var protocol, addressee : string_descriptor;,   procedure MAIL$READ_ERROR_TEXT) : integer;   var:D   usernamebuffer, userdirectory : string; userpriority : priorities;F   maildelivery : text; useruic : unsigned; useraccount : account_name;   currenttime : [quad] recordc+                          l0, l1 : unsigned;U                        end;    begin (* MAIL_OUT_CHECK *)7   if DEBUG_OUT then writeln ('MAIL_OUT_CHECK called.');b   case iaddress (link_flag) of      (* Check out an addressee *)4     LNK_C_OUT_CKUSER : if (addressee.length = 1) andF                           (addressee.address^[1] = chr (0)) then beginK                          (* The null byte indicates that all the addressees 5                             have been accomodated. *)LN                          if DEBUG_OUT then writeln ('  Terminate user list.');6                          MAIL_OUT_CHECK := SS$_NORMAL;%                        end else beginEM                          if DEBUG_OUT then writeln ('  CKUSER option used.');aI                          copy_descr_to_string (addressee, usernamebuffer,l:                                                DEBUG_OUT);*                          if DEBUG_OUT then<                            writeln ('  Checking out user "',:                                     usernamebuffer, '".');D                          if not find_user_directory (usernamebuffer,C                                                      userdirectory,uJ                                                      useruic, useraccount,G                                                      userpriority) then_A                            MAIL_OUT_CHECK := DELIVER__USERNOEXISTN#                          else beginnK                            if DEBUG_OUT then writeln ('  Trying to open "',oD                              userdirectory + 'MAIL.DELIVERY', '".');?                            open (file_variable := maildelivery,uN                                  file_name := userdirectory + 'MAIL.DELIVERY',<                                  organization := SEQUENTIAL,5                                  sharing := READONLY,aA                                  user_action := open_with_SYSPRV,zI                                  error := CONTINUE, history := READONLY);]=                            if status (maildelivery) <= 0 then:E                              reset (maildelivery, error := CONTINUE);dB                            if status (maildelivery) > 0 then begin>                              LIB$SIGNAL (DELIVER__NOMDFILE, 2,5                                usernamebuffer.length, ?                                iaddress (usernamebuffer.body));AA                              MAIL_OUT_CHECK := DELIVER__NOMDFILE;_)                            end else begin .                              if DEBUG_OUT thenN                                writeln ('  Adding this user to active list.');:                              user_count := user_count + 1;?                              if user_list_last = nil then begine4                                new (user_list_last);;                                user_list := user_list_last;w+                              end else begine:                                new (user_list_last^.next);F                                user_list_last := user_list_last^.next;!                              end;r:                              with user_list_last^ do beginI                                FROM_OWNER := fromstring = usernamebuffer;pK                                if not read_maildelivery_file (maildelivery,V8                                   rules_list) then begin3                                  if FROM_OWNER thenoC                                    LIB$SIGNAL (DELIVER__MDIGNORED);iA                                  dispose_rules_list (rules_list);]#                                end;:2                                next        := nil;L                                username    := pad (usernamebuffer, ' ', 12);<                                directory   := userdirectory;6                                uic         := useruic;:                                account     := useraccount;;                                priority    := userpriority; D                                user_length := usernamebuffer.length;5                                $GETTIM (currenttime);o4                                copyname := 'MAIL_' +G                                            hex (currenttime.l0, 8, 8) +iG                                            hex (currenttime.l1, 8, 8) + B                                            hex (user_count, 8, 8);0                                if DEBUG_OUT thenK                                  writeln ('  Added user "', usernamebuffer, >                                           '"; file code is "',:                                           copyname, '".');<                              end; (* with user_list_last^ *):                              MAIL_OUT_CHECK := SS$_NORMAL;                            end;                           end;e2                        end; (* LNK_C_OUT_CKUSER *).     (* Check out the message send operation *)     LNK_C_OUT_CKSEND : beginM                          if DEBUG_OUT then writeln ('  CKSEND option used.');e6                          MAIL_OUT_CHECK := SS$_NORMAL;2                        end; (* LNK_C_OUT_CKSEND *)   end; (* case *)4 end; (* MAIL_OUT_CHECK *);  F (* MAIL_OUT_FILE is called when the body of the message is ready to beF    sent. The message is available as a file and must be read from thisF    temporary file using RMS. MAIL_OUT_FILE is where most of the actual@    work DELIVER does takes place. The following steps are taken:  H    (1) The mode of the message file is set to record I/O (MAIL sometimes&        leaves the file in block mode).  D    (2) The list of users to whom messages are being sent is scanned.!        For each user on the list:p  @        (a) A copy of the message is placed in the user's defaultA            directory. The file is created with SYSPRV, so it will !            be owned by that user..  @        (b) The user's rules are scanned and checked for matches.  D        (c) If any of the rules are satisfied, a command file is alsoG            created. This files contains some initial symbol definitionseG            and then commands to implement each of the user's rules that,G            matched. The command file ends with commands that delete thelC            copy of the message as well as the commmand file itself.   I        (d) A batch job is created to run the command file. Note that this >            means MAIL must be installed with CMKRNL privilege. *)  8 [global] function MAIL_OUT_FILE (var context : unsigned;   var link_flag : integer;#   var protocol : string_descriptor;    var message_RAB : RAB$TYPE; A   [asynchronous, unbound] procedure UTIL$REPORT_ERROR) : integer;)   var P   user_list_scan : user_block_ptr; onehasmatched, match, previous_bio : boolean;=   rules_list_scan : parameter_block_ptr; message_file : text;D;   fromupstring, toupstring, subjectupstring, line : string;    index, lleft, stat : integer;_6   ppriv, priv, iosb : [quad] array [0..1] of unsigned;    items : array [1..10] of item;R   inQuote : BOOLEAN ;					(* True if inside a quoted string, false otherwise.			*)b   quoted : BOOLEAN ;					(* True if a quoted string occurred in this segment of a mail address,	*)# 							(* false otherwise.							*)s<   function STR$MATCH_WILD (candidate : varying [l1] of char;6     pattern : varying [l2] of char) : integer; extern;  9   function STR$UPCASE (var dststr : varying [l1] of char;g9     var srcstr : varying [l2] of char) : integer; extern;;  5   (* function to read a line from the message file *)w  2   function get_line (var line : string) : boolean;     var      stat : integer;t     begin (* get_line *)     get_line := false;2     message_RAB.RAB$L_UBF := iaddress (line.body);,     message_RAB.RAB$W_USZ := parameter_size;&     stat := $GET (RAB := message_RAB);     if odd (stat) then begin+       line.length := message_RAB.RAB$W_RSZ;        get_line := true;oO     end else if stat <> RMS$_EOF then LIB$SIGNAL (DELIVER__MESREAERR, 1, stat);    end; (* get_line *)_  '   procedure put_string (line : string);a     begin (* put_string *)(     if lleft >= length (line) then beginA       write (message_file, line); lleft := lleft - length (line);(     end;   end; (* put_string *)   !   procedure put_char (ch : char);t     begin (* put_char *)     if lleft >= 1 then begin6       write (message_file, ch); lleft := pred (lleft);     end;   end; (* put_char *)s  1   procedure put_symbol (symbol, svalue : string);d     begin (* put_symbol *)0     write (message_file, '$ ', symbol, ' == "');1     lleft := DCL_line_size - 8 - length (symbol);s(     for index := 1 to length (svalue) do3       if svalue[index] = '"' then put_string ('""')c$       else put_char (svalue[index]);3     writeln (message_file, '"', error := CONTINUE);e%     if status (message_file) > 0 then'@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));1     write (message_file, '$ Q', symbol, ' == "');e1     lleft := DCL_line_size - 9 - length (symbol);o(     for index := 1 to length (svalue) do5       if svalue[index] = '"' then put_string ('""""')c$       else put_char (svalue[index]);3     writeln (message_file, '"', error := CONTINUE);a%     if status (message_file) > 0 thenl@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));2     write (message_file, '$ QQ', symbol, ' == "');2     lleft := DCL_line_size - 10 - length (symbol);(     for index := 1 to length (svalue) do9       if svalue[index] = '"' then put_string ('""""""""') $       else put_char (svalue[index]);3     writeln (message_file, '"', error := CONTINUE);c%     if status (message_file) > 0 theno@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));   end; (* put_symbol *)s   begin (* MAIL_OUT_FILE *)u6   if DEBUG_OUT then writeln ('MAIL_OUT_FILE called.');  D   (* Do some fancy footwork with RMS to insure that the file is openC      for sequential access and not block access. MAIL sometimes hastB      this file open in block mode. The only way to change modes isI      to disconnect the RAB, diddle the mode bit and then reconnect it. *)l?   previous_bio := uand (message_RAB.RAB$L_ROP, RAB$M_BIO) <> 0;oB   if DEBUG_OUT then writeln ('  The BIO field of the RAB is set ',+                              previous_bio); #   $DISCONNECT (RAB := message_RAB);eJ   message_RAB.RAB$L_ROP := uand (message_RAB.RAB$L_ROP, unot (RAB$M_BIO));    $CONNECT (RAB := message_RAB);  O   if DEBUG_OUT then writeln (' Creating upper case copies of header strings.');n+   STR$UPCASE (fromupstring,    fromstring);t)   STR$UPCASE (toupstring,      tostring);t.   STR$UPCASE (subjectupstring, subjectstring);O   if DEBUG_OUT then writeln ('  From: "', fromupstring, '", To: "', toupstring,:E                              '", Subject: "', subjectupstring, '".');   9   if DEBUG_OUT then writeln (' Pruning the rules list.');r   user_list_scan := user_list;&   while user_list_scan <> nil do begin+     if DEBUG_OUT then writeln ('  User: "',1O       substr (user_list_scan^.username, 1, user_list_scan^.user_length), '".'); D     if DEBUG_OUT then writeln ('  Create copy of message in file "',9                                user_list_scan^.directory,rD                                user_list_scan^.copyname, '.TEXT".');8     open (file_variable := message_file, history := NEW,C           record_length := parameter_size, record_type := VARIABLE,e2           file_name := user_list_scan^.directory +:                        user_list_scan^.copyname + '.TEXT',?           user_action := create_with_SYSPRV, error := CONTINUE,t&           organization := SEQUENTIAL);>     if status (message_file) <= 0 then rewrite (message_file);%     if status (message_file) > 0 thenu@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));!     $REWIND (RAB := message_RAB);n"     while get_line (line) do begin6       writeln (message_file, line, error := CONTINUE);'       if status (message_file) > 0 theneB         LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));     end; (* while get_line *) ,     close (message_file, error := CONTINUE);%     if status (message_file) > 0 then @       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  A     if DEBUG_OUT then writeln ('  Creating command file named "',n9                                user_list_scan^.directory, C                                user_list_scan^.copyname, '.COM".');n8     open (file_variable := message_file, history := NEW,C           record_length := parameter_size, record_type := VARIABLE,e2           file_name := user_list_scan^.directory +9                        user_list_scan^.copyname + '.COM',t?           user_action := create_with_SYSPRV, error := CONTINUE,m&           organization := SEQUENTIAL);>     if status (message_file) <= 0 then rewrite (message_file);%     if status (message_file) > 0 then @       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  <     writeln (message_file, '$ SET NOON', error := CONTINUE);%     if status (message_file) > 0 thena@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  E     writeln (message_file, '$ DELETE = "DELETE"', error := CONTINUE);m%     if status (message_file) > 0 then @       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  K     writeln (message_file, '$ MESSAGE_DELETE == "YES"', error := CONTINUE);f%     if status (message_file) > 0 thene@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  $     put_symbol ('FROM', fromstring);      put_symbol ('TO', tostring);*     put_symbol ('SUBJECT', subjectstring);      put_symbol ('CC', ccstring);  1     writeln (message_file, '$ MESSAGE_FILE == "',M'              user_list_scan^.directory,iD              user_list_scan^.copyname, '.TEXT"', error := CONTINUE);%     if status (message_file) > 0 then @       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  1     writeln (message_file, '$ COMMAND_FILE == "',t'              user_list_scan^.directory, C              user_list_scan^.copyname, '.COM"', error := CONTINUE);U%     if status (message_file) > 0 theni@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  F     if DEBUG_OUT then writeln ('  Check this user''s delivery list.');     onehasmatched := false; I     batch_log := '_NLA0:'; batch_keep := false; batch_log_keep := false ;e2     rules_list_scan := user_list_scan^.rules_list;B     while rules_list_scan <> nil do with rules_list_scan^ do begin;       match := (any_to      or (STR$MATCH_WILD (toupstring,iL                                 parameters[to_parameter]) = STR$_MATCH)) and=                (any_from    or (STR$MATCH_WILD (fromupstring,nN                                 parameters[from_parameter]) = STR$_MATCH)) and@                (any_subject or (STR$MATCH_WILD (subjectupstring,N                                 parameters[subject_parameter]) = STR$_MATCH));/       case parameters[decision_parameter][1] ofK!         'A'      : match := true;r"         'X'      : match := false;"         'T', 'Y' : match := match;&         'F', 'N' : match := not match;:         '?', 'O' : match := match and (not onehasmatched);@         'B', 'Q' : match := (not match) and (not onehasmatched);9         'E'      : match := match or (not onehasmatched); !         otherwise match := false;l       end; (* decision case *)       if match then begin E         if DEBUG_OUT then writeln (' Rule matched. From: pattern: "', :           parameters[from_parameter], '", To: pattern: "',=           parameters[to_parameter], '", Subject: pattern: "', C           parameters[subject_parameter], '", Decision character: ', 2           parameters[decision_parameter][1], '.');  ( 	case parameters[action_parameter][1] OF` 	  'K', 'L', 'M' : ;				(* The K, L, and M directives don't have any effect on onehasmatched.	*) 	  otherwise\ 	    onehasmatched := true			(* All other directives cause onehasmatched to become true.		*)! 	end ;						(* End case								*)r 	  c/         case parameters[action_parameter][1] ofg           (* append *)           'A'  : beginG                    writeln (message_file, '$ APPEND ''MESSAGE_FILE'' ', ;                             parameters[argument_parameter],L/                             error := CONTINUE);u4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));r"                  end; (* append *)           (* create, copy *)           'C'  : beginE                    writeln (message_file, '$ COPY ''MESSAGE_FILE'' ',';                             parameters[argument_parameter], /                             error := CONTINUE);S4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); (                  end; (* create, copy *)           (* deliver *)            'D'  : beginJ                    write (message_file, '$ MAIL/NOSELF/SUBJECT="(From: ');H                    write (message_file, '''''QFROM'') ''''QSUBJECT''"');@                    write (message_file, ' ''MESSAGE_FILE'' "_');'                    write (message_file,n9                      substr (user_list_scan^.username, 1,a;                              user_list_scan^.user_length)); B                    writeln (message_file, '"', error := CONTINUE);4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); #                  end; (* deliver *)r           (* execute *)            'E'  : beginC                    if parameters[argument_parameter][1] <> '$' then .                    write (message_file, '$ ');I                    writeln (message_file, parameters[argument_parameter], /                             error := CONTINUE);_4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); #                  end; (* execute *)+           (* forward *)            'F'  : beginJ                    write (message_file, '$ MAIL/NOSELF/SUBJECT="(From: ');H                    write (message_file, '''''QFROM'') ''''QSUBJECT''"');?                    write (message_file, ' ''MESSAGE_FILE'' ') ;                       (* L                    ** Write the to address as a quoted string, if necessary.                    *)r   		   quoted := false ; 		   inQuote := false ;  		    U                    for index := 1 to length (parameters[argument_parameter]) do beginiN                      if parameters[argument_parameter][index] = '"' then begin 		       (*nb 		       ** Emit the outer most quote and note that a quoted string has been seen in this segment. 		       *)e! 		       if not quoted then begin & 		         write (message_file, '"') ; 			 quoted := true ; 		       end ; 		       (*R$ 		       ** Emit the doubling quote. 		       *)e! 		       inQuote := not inQuote ;i1                        write (message_file, '"');i 		     end ;  	 		     (*oF 		     ** Ignore quoted commas, but when a comma appears terminate the& 		     ** quoted string if one exists.	 		     *)t 		     e; 		     if (parameters[argument_parameter][index] = ',') and; 		        (not inQuote) and  			quoted then begin$ 		       write (message_file, '"') ; 		       quoted := false ; 		     end ;  C 		     write (message_file, parameters[argument_parameter][index]);e!                    end; (* for *);   		   if quoted then begin D                      writeln (message_file, '"', error := CONTINUE);( 		     if status (message_file) > 0 thenQ                        LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));v	 		   end a 		   else begin C                      writeln (message_file, '', error := CONTINUE); ( 		     if status (message_file) > 0 thenQ                        LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); 
 		   end ;#                  end; (* forward *)            (* keep-command *)$           'K'  : batch_keep := true;           (* log-keep *)           'L'  : begin 		   batch_log_keep := true ;b>                    if parameters[argument_parameter] = '' thenK                      batch_log := user_list_scan^.directory + 'DELIVER.LOG' @                    else batch_log := user_list_scan^.directory +D                                      parameters[argument_parameter];$                  end; (* log-keep *)           (* message-keep *)           'M'  : beginE                    writeln (message_file, '$ MESSAGE_DELETE == "NO"', /                             error := CONTINUE);n4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); (                  end; (* message-keep *)           (* quit *)(           'Q'  : rules_list_scan := nil;"           (* privileged-deliver *)           'V'  : begin@ 		   writeln (message_file,'$ PRIV = F$SETPRV("BYPASS,TMPMBX")',/                             error := CONTINUE); 4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); C                    writeln (message_file, '$ DELIVER_FROM = FROM'); 4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); ?                    writeln (message_file, '$ DELIVER_CC = CC'); 4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));K8                    write (message_file, '$ MAIL/NOSELF',J                     '/PROTOCOL=DELIVER_MAILSHR/SUBJECT="''''QSUBJECT''"');@                    write (message_file, ' ''MESSAGE_FILE'' "_');'                    write (message_file,o9                      substr (user_list_scan^.username, 1,e;                              user_list_scan^.user_length));sB                    writeln (message_file, '"', error := CONTINUE);4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));sC                    writeln (message_file,'$ PRIV = F$SETPRV(PRIV)',s/                             error := CONTINUE); 4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));o.                  end; (* privileged-deliver *)"           (* privileged-forward *)           'W'  : begin@ 		   writeln (message_file,'$ PRIV = F$SETPRV("BYPASS,TMPMBX")',/                             error := CONTINUE); 4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); C                    writeln (message_file, '$ DELIVER_FROM = FROM');l4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); ?                    writeln (message_file, '$ DELIVER_CC = CC');r4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));t8                    write (message_file, '$ MAIL/NOSELF',K                      '/PROTOCOL=DELIVER_MAILSHR/SUBJECT="''''QSUBJECT''"');:?                    write (message_file, ' ''MESSAGE_FILE'' ') ;;                      (* L                    ** Write the to address as a quoted string, if necessary.                    *)d   		   quoted := false ; 		   inQuote := false ;d 		   sU                    for index := 1 to length (parameters[argument_parameter]) do beginTN                      if parameters[argument_parameter][index] = '"' then begin 		       (*tb 		       ** Emit the outer most quote and note that a quoted string has been seen in this segment. 		       *)g! 		       if not quoted then begina& 		         write (message_file, '"') ; 			 quoted := true ; 		       end ; 		       (* $ 		       ** Emit the doubling quote. 		       *) ! 		       inQuote := not inQuote ;s1                        write (message_file, '"');s 		     end ;  	 		     (*tF 		     ** Ignore quoted commas, but when a comma appears terminate the& 		     ** quoted string if one exists.	 		     *)  		     e; 		     if (parameters[argument_parameter][index] = ',') andI 		        (not inQuote) ands 			quoted then begin$ 		       write (message_file, '"') ; 		       quoted := false ; 		     end ;  C 		     write (message_file, parameters[argument_parameter][index]);l!                    end; (* for *))   		   if quoted then begintD                      writeln (message_file, '"', error := CONTINUE);( 		     if status (message_file) > 0 thenQ                        LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); 	 		   end   		   else beginlC                      writeln (message_file, '', error := CONTINUE);f( 		     if status (message_file) > 0 thenQ                        LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); 
 		   end ;4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); C                    writeln (message_file,'$ PRIV = F$SETPRV(PRIV)',E/                             error := CONTINUE);e4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));f.                  end; (* privileged-forward *)           otherwise begin end;         end; (* case *)e=       end; (* add commands to implement this matching rule *)>N       if rules_list_scan <> nil then rules_list_scan := rules_list_scan^.next;     end; (* while *)  #     if not onehasmatched then beginDI       if DEBUG_OUT then writeln ('  No rules matched, just deliver it.'); =       write (message_file, '$ MAIL/NOSELF/SUBJECT="(From: '); O       writeln (message_file, '''''QFROM'') ''''QSUBJECT''" ''MESSAGE_FILE'' _',N3                substr (user_list_scan^.username, 1, H                        user_list_scan^.user_length), error := CONTINUE);'       if status (message_file) > 0 thenuB         LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));     end;  H     if DEBUG_OUT then writeln ('  Finishing up delivery command file.');7     writeln (message_file, '$ IF MESSAGE_DELETE then ',i<              'DELETE ''MESSAGE_FILE'';', error := CONTINUE);%     if status (message_file) > 0 theni@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));:     writeln (message_file, '$ LOGOUT', error := CONTINUE);%     if status (message_file) > 0 then @       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));,     close (message_file, error := CONTINUE);%     if status (message_file) > 0 thenI@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  :     if DEBUG_OUT then writeln ('  Submitting batch job.');9     priv[0] := PRV$M_CMKRNL + PRV$M_SYSPRV; priv[1] := 0;pH     $SETPRV (ENBFLG := 1, PRVADR := priv, PRMFLG := 0, PRVPRV := ppriv);J     line := user_list_scan^.directory + user_list_scan^.copyname + '.COM';     with items[2] do begin6       len := length (batch_queue); code := SJC$_QUEUE;4       addr := iaddress (batch_queue) + 2; rlen := 0;     end; (* with items[2] *)     with items[3] do begin<       len := length (line); code := SJC$_FILE_SPECIFICATION;-       addr := iaddress (line) + 2; rlen := 0;_     end; (* with items[3] *)     with items[4] do begin@       len := length (batch_log); code := SJC$_LOG_SPECIFICATION;2       addr := iaddress (batch_log) + 2; rlen := 0;     end; (* with items[4] *)     with items[5] do begin*       len := 0; code := SJC$_NO_LOG_SPOOL;       addr := 0; rlen := 0;d     end; (* with items[5] *)     with items[6] do begin       len := 0;=4       if batch_keep then code := SJC$_NO_DELETE_FILE$       else code := SJC$_DELETE_FILE;       addr := 0; rlen := 0;_     end; (* with items[6] *)-     if use_sjc_user_identification then begin        with items[1] do begin4         len := 25; code := SJC$_USER_IDENTIFICATION;:         addr := iaddress (user_list_scan^.uic); rlen := 0;       end; (* with items[1] *)       with items[7] do begin2         len := 0; code := 0; addr := 0; rlen := 0;       end; (* with items[7] *)     end else begin       with items[1] do beginB         len := user_list_scan^.user_length; code := SJC$_USERNAME;?         addr := iaddress (user_list_scan^.username); rlen := 0;T       end; (* with items[1] *)       with items[7] do begin#         len := 4; code := SJC$_UIC;s:         addr := iaddress (user_list_scan^.uic); rlen := 0;       end; (* with items[7] *)       with items[8] do begin,         len := 8; code := SJC$_ACCOUNT_NAME;>         addr := iaddress (user_list_scan^.account); rlen := 0;       end; (* with items[8] *)       with items[9] do       beginr
 	len := 0;2 	if batch_log_keep then code := SJC$_NO_LOG_DELETE 	else code := SJC$_LOG_DELETE; 	addr := 0 ; 	rlen := 0 ;       end ; (* with items[9] *)        with items[10] do beginS2         len := 0; code := 0; addr := 0; rlen := 0;       end; (* with items[10] *)s     end;3     if DEBUG_OUT then writeln ('    Opening job.');sN     stat := $SNDJBCW (func := SJC$_ENTER_FILE, itmlst := items, iosb := iosb);9     if (not odd (stat)) or (not odd (iosb[0])) then begin        with items[2] do begin+         len := length (system_batch_queue);E2         addr := iaddress (system_batch_queue) + 2;
       end;P       stat := $SNDJBCW (func := SJC$_ENTER_FILE, itmlst := items, iosb := iosb);     end;-     if not odd (stat) then LIB$SIGNAL (stat); 3     if not odd (iosb[0]) then LIB$SIGNAL (iosb[0]);S/     priv[0] := uand (priv[0], unot (ppriv[0]));f/     priv[1] := uand (priv[1], unot (ppriv[1]));L7     $SETPRV (ENBFLG := 0, PRVADR := priv, PRMFLG := 0);u+     user_list_scan := user_list_scan^.next;l   end; (* while *)6   (* Turn the BIO bit back on if it was set before. *)   if previous_bio then begin%     $DISCONNECT (RAB := message_RAB); D     message_RAB.RAB$L_ROP := uor (message_RAB.RAB$L_ROP, RAB$M_BIO);"     $CONNECT (RAB := message_RAB);   end;   MAIL_OUT_FILE := SS$_NORMAL; end; (* MAIL_OUT_FILE *)  J (* MAIL_OUT_DEACCESS is called to shut down the current send operation. *)  < [global] function MAIL_OUT_DEACCESS (var context : unsigned;%   var link_flag : integer) : integer;n   begin (* MAIL_OUT_DEACCESS *)U:   if DEBUG_OUT then writeln ('MAIL_OUT_DEACCESS called.');    if user_list <> nil then beginM     if DEBUG_OUT then writeln ('  Deleting user list and associated rules.');i"     dispose_user_list (user_list);   end;"   MAIL_OUT_DEACCESS := SS$_NORMAL; end; (* MAIL_OUT_DEACCESS *)  K (* MAIL_OUT_ATTRIBS delivers the message file's attributes to DELIVER. ThisaL    information is currently unused (see comment in MAIL_IN_ATTRIBS below. *)  ; [global] function MAIL_OUT_ATTRIBS (var context : unsigned;a6   var link_flag : integer; var system_flags : integer;.   var idtld : file_attribute_block) : integer;   begin (* MAIL_OUT_ATTRIBS *)9   if DEBUG_OUT then writeln ('MAIL_OUT_ATTRIBS called.'); !   MAIL_OUT_ATTRIBS := SS$_NORMAL;D end; (* MAIL_OUT_ATTRIBS *)   O (* These routines manipulate a stack in which we maintain state information forrF    information being "written" to us when MAIL calls MAIL_IO_WRITE. *)  5 procedure init_stack (var stack : write_state_stack);t   begin (* init_stack *)2   if DEBUG_IN then writeln ('INIT_STACK called.');   stack.top := 0;o end; (* init_stack *)   E procedure push (var stack : write_state_stack; state : write_states);    varh   i : integer;   begin (* push *),   if DEBUG_IN then writeln ('PUSH called.');   with stack do begin      top := succ (top);=     if top > stack_size then LIB$SIGNAL (DELIVER__INTSTKOVR);e     store[top] := state;   end; (* with *)]   if DEBUG_IN then begin     writeln ('  after PUSH:');D     for i := stack.top downto 1 do writeln ('    ', stack.store[i]);   end; end; (* push *)'  . procedure pop (var stack : write_state_stack);   var    i : integer;   begin (* pop *)1+   if DEBUG_IN then writeln ('POP called.');d   with stack do begine     top := pred (top);3     if top < 1 then LIB$SIGNAL (DELIVER__STKEMPTY);(   end; (* with *)v   if DEBUG_IN then begin     writeln ('  after POP:');*D     for i := stack.top downto 1 do writeln ('    ', stack.store[i]);   end; end; (* pop *)  E function top_of_stack (var stack : write_state_stack) : write_states;    begin (* top_of_stack *)4   if DEBUG_IN then writeln ('TOP_OF_STACK called.');)   top_of_stack := stack.store[stack.top];oC   if DEBUG_IN then writeln (' returning ', stack.store[stack.top]);n end; (* top_of_stack *)B  I (* The incoming mail handling routines are activated by a command line ofd    the form:  M    $ MAIL/PROTOCOL=DELIVER_MAILSHR/SUBJECT="subject" message.txt address-listn  H    Everything is specified on the command line except the From: address,E    which is obtained by getting the value of the symbol DELIVER_FROM.N  H    BYPASS privilege is required to use this interface since this routine4    makes it possible to "forge" return addresses. *)  : [global] function MAIL_IN_CONNECT (var context : unsigned;   var link_flag : integer;%   var input_tran : string_descriptor;i#   var file_RAT, file_RFM : integer;E!   var MAIL$GL_SYSFLAGS : integer;w*   var MAIL$Q_PROTOCOL : string_descriptor;"   var pflags : integer) : integer;   var_9   priv : [quad] array [0..1] of unsigned; stat : integer;e   begin (* MAIL_IN_CONNECT *) 7   if DEBUG_IN then writeln ('MAIL_IN_CONNECT called.');    priv[0] := 0; priv[1] := 0;e6   stat := LIB$GETJPI (JPI$_PROCPRIV, , , priv[0], , );+   if not odd (stat) then LIB$SIGNAL (stat);i0   if uand (priv[0], PRV$M_BYPASS) = 0 then begin"     LIB$SIGNAL (DELIVER__NOTPRIV);(     MAIL_IN_CONNECT := DELIVER__NOTPRIV;   end else begin     toline := '';*;     if DEBUG_IN then writeln ('Initializing state stack.');a#     init_stack (write_recv_states);'&     push (write_recv_states, bad_msg);4     LIB$SET_SYMBOL ('DELIVER_STATUS', '%X00000001');"     MAIL_IN_CONNECT := SS$_NORMAL;   end; end; (* MAIL_IN_CONNECT *)  J (* MAIL calls MAIL_IN_LINE to get single line information from DELIVER. *)  7 [global] function MAIL_IN_LINE (var context : unsigned;s   var link_flag : integer;*   var line : string_descriptor) : integer;   var &   linebuffer : string; stat : integer;   begin (* MAIL_IN_LINE *)4   if DEBUG_IN then writeln ('MAIL_IN_LINE called.');   case iaddress (link_flag) of*     (* Return From: information to MAIL *)     LNK_C_IN_SENDER : beginEL                         if DEBUG_IN then writeln ('IN_SENDER option used.');L                         stat := LIB$GET_SYMBOL ('DELIVER_FROM', linebuffer);O                         if not odd (stat) then linebuffer := '<not specified>';nM 		        if DEBUG_IN then writeln ('LIB$GET_SYMBOL status = ',HEX( stat )) ;eJ                         copy_string_to_descr (linebuffer, line, DEBUG_IN);1                        end; (* LNK_C_IN_SENDER *)n(     (* Return To: information to MAIL *)     LNK_C_IN_CKUSER : begintL                         if DEBUG_IN then writeln ('IN_CKUSER option used.');E                         stat := CLI$GET_VALUE ('TOLIST', linebuffer); O                         if not odd (stat) then linebuffer := chr (0) else beginiM                           if length (toline) > 0 then toline := toline + ',';n8                           toline := toline + linebuffer;?                           push (write_recv_states, user_check);t                         end;J                         copy_string_to_descr (linebuffer, line, DEBUG_IN);0                       end; (* LNK_C_IN_CKUSER *)(     (* Return entire To: line to MAIL *)     LNK_C_IN_TO     : begindH                         if DEBUG_IN then writeln ('IN_TO option used.');F                         copy_string_to_descr (toline, line, DEBUG_IN);-                        end; (* LNK_C_IN_TO *) -     (* Return entire Subject: line to MAIL *)1     LNK_C_IN_SUBJ   : begin	J                         if DEBUG_IN then writeln ('IN_SUBJ option used.');F                         stat := CLI$GET_VALUE ('SUBJECT', linebuffer);@                         if not odd (stat) then linebuffer := '';J                         copy_string_to_descr (linebuffer, line, DEBUG_IN);/                        end; (* LNK_C_IN_SUBJ *);(     (* Return entire Cc: line to MAIL *)     LNK_C_IN_CC     : begin H                         if DEBUG_IN then writeln ('IN_CC option used.');J                         stat := LIB$GET_SYMBOL ('DELIVER_CC', linebuffer);@                         if not odd (stat) then linebuffer := '';M 		        if DEBUG_IN then writeln ('LIB$GET_SYMBOL status = ',HEX( stat )) ; J                         copy_string_to_descr (linebuffer, line, DEBUG_IN);/                        end; (* LNK_C_IN_SUBJ *)e   end; (* case *)    MAIL_IN_LINE := SS$_NORMAL;  end; (* MAIL_IN_LINE *))  G (* MAIL_IN_FILE is called by MAIL to read the body of the message to be J    delivered. This routine gets the file name from the command line, opens;    the file and copies it into MAIL's intermediate file. *)   7 [global] function MAIL_IN_FILE (var context : unsigned;i   var link_flag : integer;   var scratch : integer;   var RAB : RAB$TYPE;(,   procedure UTIL$REPORT_IO_ERROR) : integer;   var E   filename, linebuffer : string; message_file : text; stat : integer;    begin (* MAIL_IN_FILE *)4   if DEBUG_IN then writeln ('MAIL_IN_FILE called.');H   (* Get the name of the file containing the message to be delivered. *)+   stat := CLI$GET_VALUE ('FILE', filename);n   if not odd (stat) then begin-     LIB$SIGNAL (DELIVER__GETFILERR, 1, stat);)'     MAIL_IN_FILE := DELIVER__GETFILERR;i   end else begin?     open (file_variable := message_file, file_name := filename, :           organization := SEQUENTIAL, sharing := READONLY,2           error := CONTINUE, history := READONLY);&     if status (message_file) <= 0 then.       reset (message_file, error := CONTINUE);+     if status (message_file) > 0 then beging&       LIB$SIGNAL (DELIVER__MESOPNERR);)       MAIL_IN_FILE := DELIVER__MESOPNERR;      end else begin1       RAB.RAB$L_RBF := iaddress (linebuffer) + 2;        stat := SS$_NORMAL;e>       while (not eof (message_file)) and (odd (stat)) do begin=         readln (message_file, linebuffer, error := CONTINUE); /         if status (message_file) > 0 then begin_D           LIB$SIGNAL (DELIVER__MSGREAERR, 1, status (message_file));%           stat := DELIVER__MSGREAERR;          end else begin/           RAB.RAB$W_RSZ := length (linebuffer);t$           stat := $PUT (RAB := RAB);J           if not odd (stat) then LIB$SIGNAL (DELIVER__MSGWRTERR, 1, stat);         end;       end; (* while *).       close (message_file, error := CONTINUE);       MAIL_IN_FILE := stat;e     end;   end;+   push (write_recv_states, delivery_check);  end; (* MAIL_IN_FILE *)   N (* MAIL_IN_ATTRIBS is called to get file attributes for the message file. ThisJ    routine is currently unused. It is not possible to add support for fileI    attributes to DELIVER at this time (VMS 5.0-2) because this routine is H    *never* called for foreign protocols. See the code in the accept_linkK    routine in MAIL$SERVER_SUBS -- the only way that the SERV_FORRECV bit in(H    MAIL$L_SRVFLAGS can be set is by a MAIL-11 transaction. This bit thenN    determines if LNK_C_IN_ATTRIBS is used and MAIL_IN_ATTRIBS is called by theL    mail_server routine in MAIL$SERVER_MAIN. Until this code is expanded uponM    (or if we are willing to patch the MAIL image) it will not be possible for K    DELIVER to handle file attributes and the things they apply to like DDIF     files. *)  : [global] function MAIL_IN_ATTRIBS (var context : unsigned;G   var link_flag : integer; var idtld : file_attribute_block) : integer;o   begin (* MAIL_IN_ATTRIBS *) 7   if DEBUG_IN then writeln ('MAIL_IN_ATTRIBS called.');p    MAIL_IN_ATTRIBS := SS$_NORMAL; end; (* MAIL_IN_ATTRIBS *)  H (* MAIL_IO_WRITE is called by MAIL to tell DELIVER what it thinks of the8    results returned by the various MAIL_IN_ routines. *)  8 [global] function MAIL_IO_WRITE (var context : unsigned;   var link_flag : integer;&   line : string_descriptor) : integer;   var    error_text : string;  E   function string_to_integer (var str : string_descriptor) : integer;      vart6     number : packed array [1..4] of char; i : integer;     begin (* string_to_integer *) =     if str.length <> 4 then string_to_integer := 0 else begine6       for i := 1 to 4 do number[i] := str.address^[i];-       string_to_integer := number :: integer;r     end;   end; (* string_to_integer *)   begin (* MAIL_IO_WRITE *)n5   if DEBUG_IN then writeln ('MAIL_IO_WRITE called.'); *   case top_of_stack (write_recv_states) of     delivery_check : beginD                        if DEBUG_IN then writeln ('Delivery check.');>                        last_error := string_to_integer (line);O                        if DEBUG_IN then writeln (' got a stat : ', last_error); /                        pop (write_recv_states);t3                        if not odd (last_error) then :                          LIB$SET_SYMBOL ('DELIVER_STATUS',H                                          '%X' + hex (last_error, 8, 8));7                        if last_error <> SS$_NORMAL then =                          push (write_recv_states, error_msg);h.                      end; (* delivery_check *)     user_check :     begin@                        if DEBUG_IN then writeln ('User check.');>                        last_error := string_to_integer (line);O                        if DEBUG_IN then writeln (' got a stat : ', last_error);G/                        pop (write_recv_states);)3                        if not odd (last_error) then :                          LIB$SET_SYMBOL ('DELIVER_STATUS',H                                          '%X' + hex (last_error, 8, 8));7                        if last_error <> SS$_NORMAL then^=                          push (write_recv_states, error_msg);e*                      end; (* user_check *)     error_msg :      begin@                        if DEBUG_IN then writeln ('Error text.');L                        if (line.length = 1) and (line.address^[1] = chr (0))!                        then beginu)                          if DEBUG_IN then P                            writeln (' got a NULL -- popping write_recv_states');%                        end else begin(K                          copy_descr_to_string (line, error_text, DEBUG_IN);t)                          if DEBUG_IN thennI                            writeln ('Error message: "', error_text, '"'); 5                          if not odd (last_error) then J                            LIB$SET_SYMBOL ('DELIVER_MESSAGE', error_text);                        end; /                        pop (write_recv_states);O*                      end; (* error_text *)     bad_msg :        beginH                        if DEBUG_IN then writeln ('Unexpected message.');>                        last_error := string_to_integer (line);'                        if DEBUG_IN thenmE                          writeln (' UNEXPECTED stat : ', last_error);b;                        push (write_recv_states, error_msg);0'                      end; (* bad_msg *)r.     otherwise LIB$SIGNAL (DELIVER__BADSTKELE);   end; (* case *)e   MAIL_IO_WRITE := SS$_NORMAL; end; (* MAIL_IO_WRITE *)  7 [global] function MAIL_IO_READ (var context : unsigned;C   var link_flag : integer;3   var returned_line : string_descriptor) : integer;i   begin (* MAIL_IO_READ *)4   if DEBUG_IN then writeln ('MAIL_IO_READ called.');   MAIL_IO_READ := SS$_NORMAL;: end; (* MAIL_IO_READ *)e   (* End of DELIVER.PAS *) end.