$! autoheader.com -- create `config.h_in' using m4 macros
$! Copyright (C) 1992, 1993, 1994 Free Software Foundation, Inc.
$
$! This program is free software; you can redistribute it and/or modify
$! it under the terms of the GNU General Public License as published by
$! the Free Software Foundation; either version 2, or (at your option)
$! any later version.
$
$! This program is distributed in the hope that it will be useful,
$! but WITHOUT ANY WARRANTY; without even the implied warranty of
$! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
$! GNU General Public License for more details.
$
$! You should have received a copy of the GNU General Public License
$! along with this program; if not, write to the Free Software
$! Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
$
$! Written by Roland McGrath.
$
$! If given no args, create `config.h.in' from template file `configure.in'.
$! With one arg, create a configure script on standard output from
$! the given template file.
$
$ usage="Usage: autoheader [-h] [--help] [-m dir] [--macrodir=dir] " +-
"[-v] [--version] [template-file]" 
$
$! NLS nuisances.
$! These must not be set unconditionally because not all systems understand
$! e.g. LANG=C (notably SCO).
$!NOT VALID ON VMS.
$!if test "${LC_ALL+set}" = 'set' ; then LC_ALL=C; export LC_ALL; fi
$!if test "${LANG+set}"   = 'set' ; then LANG=C;   export LANG;   fi
$
$ AC_MACRODIR = f$trnlnm("AC_MACRODIR")
$ if AC_MACRODIR .eqs. "" then AC_MACRODIR := AXPA:[TTN.LOCAL.lib.autoconf]
$ if "''M4'" .eqs. "" then M4 := $AXPA:[TTN.LOCAL.BIN]M4
$! Handle the case that m4 has moved since we were configured.
$! It may have been found originally in a build directory.
$ if f$search(M4) .eqs. "" then M4 := m4
$
$ print_version:=
$
$ possible_args = "-H/--H*ELP:A_HELP|-M/--M*ACRODIR=:A_MACRODIR" +-
"|-V/--V*ERSION:A_VERSION|--:A_FORCE_NOMORE|-:A_KBDINP"
$ default_lable := A_NOMORE
$ gosub count_args
$
$loop:
$ if argc .le. 0 then goto loopend
$  gosub process_arg
$  if "''argl'" .nes. "" .or. f$extract(0,1,p1) .nes. "-" then -
	goto 'argl'
$ A_HELP:
$  wri sys$error "''usage'"
$  exit 1
$ A_MACRODIR:
$  AC_MACRODIR = p1
$  if argc .le. 0 then goto A_HELP
$  gosub shift
$  goto loop
$ A_VERSION:
$  print_version := -DAC_PRINT_VERSION
$  gosub shift
$  goto loop
$A_FORCE_NOMORE:
$  gosub shift
$A_KBDINP:
$A_NOMORE:
$loopend:
$
$ TEMPLATES := 'AC_MACRODIR'acconfig.h
$ if f$search("acconfig.h") .nes. "" then TEMPLATES := 'TEMPLATES' acconfig.h
$ MACROFILES:='AC_MACRODIR'acgen_vms.m4 'AC_MACRODIR'acspec_vms.m4
$ if f$search("''AC_MACRODIR'aclocal.m4") .nes. "" then -
	MACROFILES := 'MACROFILES' 'AC_MACRODIR'aclocal.m4
$ if f$search("aclocal.m4") .nes. "" then -
	MACROFILES := 'MACROFILES' aclocal.m4
$! print_version must have extra quotes. Otherwise, the value
$! will be converted to lower case.
$ if print_version .nes. "" then MACROFILES=""""+print_version+""" "+MACROFILES
$
$ if argc .gt. 1 then goto A_HELP
$ infile := configure.com_in
$ if argc .eq. 1 then infile = p1
$ if argc .eq. 0 then if print_version .nes. "" then infile := nla0:
$
$! These are the alternate definitions of the acgeneral.m4 macros we want to
$! redefine.  They produce strings in the output marked with "@@@" so we can
$! easily extract the information we want.  The `#' at the end of the first
$! line of each definition seems to be necessary to prevent m4 from eating
$! the newline, which makes the @@@ not always be at the beginning of a line.
$ type sys$input/out=headtest.m4
$ DECK
define([AC_DEFINE],[#
@@@syms=syms+" $1"@@@
])dnl
define([AC_SIZEOF_TYPE],[#
@@@types=types+",$1"@@@
])dnl
define([AC_HAVE_FUNCS],[#
@@@funcs=funcs+" $1"@@@
])dnl
define([AC_HAVE_HEADERS],[#
@@@headers=headers+" $1"@@@
])dnl
define([AC_CONFIG_HEADER],[#
@@@config_h="$1"@@@
])dnl
define([AC_HAVE_LIBRARY], [#
@@@libs=libs+" $1"@@@
$!# If it was found, we do:
$2
$!# If it was not found, we do:
$3
])dnl
$ EOD
$
$ config_h := config.h
$ syms:=
$ used_syms=" "
$ types:=
$ used_types=","
$ funcs:=
$ used_funcs=" "
$ headers:=
$ used_headers=" "
$ libs:=
$ used_libs=" "
$
$ M4 'MACROFILES' - 'infile' < headtest.m4 > headtest.m4_out
$ search/noheader headtest.m4_out "@@@"/out=headtest.out
$ open/read foo headtest.out
$loop1:
$ read/end_of_file=end_loop1 foo row
$ if f$extract(0,3,row) .eqs. "@@@" -
	.and. f$extract(f$length(row)-3,3,row) .eqs. "@@@"
$  then
$   row = f$extract(3,f$length(row)-6,row)
$   'row'
$  endif
$ goto loop1
$end_loop1:
$
$ if print_version .nes. "" then exit 1
$
$ if argc .eq. 0
$  then
$   tmpout := autoh.'f$getjpi("","PID")'
$   set noon
$   delete/nolog 'tmpout'.*
$   set on
$   open/write autoh 'tmpout'
$  else open/write autoh sys$output:
$  endif
$! Don't write "do not edit" -- it will get copied into the
$! config.h, which it's ok to edit.
$ write autoh "/* ",config_h,"_in.  Generated automatically from ",infile," by autoheader.  */"
$
$! This puts each paragraph on its own line, separated by @s.
$ if syms .nes. ""
$  then
$   ! Make sure the boundary of template files is also the boundary
$   ! of the paragraph.  Extra newlines don't hurt since they will
$   ! be removed.
$   t_i = 0
$   wrote_empty_line := YES
$  loop_s_2:
$   t = f$element(t_i," ",TEMPLATES)
$   t_i = t_i + 1
$   if t .eqs. "" then goto loop_s_2
$   if t .eqs. " " then goto end_loop_s_2
$   open/read t_file 't'
$  loop_s_23:
$    keep_it := no
$    skip_it := no
$    r_i = 0
$  loop_s_3:
$     read/end=end_loop_s_3 t_file record'r_i'
$     if f$edit(record'r_i',"COLLAPSE") .eqs. "" then goto glob_s
$     old_r_i = r_i
$     r_i = r_i + 1
$     s_i = 0
$  loop_s_4:
$      if keep_it .or. skip_it then goto loop_s_3
$      s = f$element(s_i," ",syms)
$      s_i = s_i + 1
$      if s .eqs. "" then goto loop_s_4
$      if s .eqs. " " then goto loop_s_3
$      if f$locate(" "+s+" ",used_syms) .lt. f$length(used_syms) then skip_it := yes
$      if skip_it then goto loop_s_3
$      if f$locate(s,record'old_r_i') .lt. f$length(record'old_r_i') then keep_it := yes
$      if keep_it then used_syms = used_syms + syms + " "
$      goto loop_s_4
$  glob_s:
$     if .not. keep_it .or. skip_it then goto loop_s_23
$     r2_i = 0
$  loop_s_5:
$     if r2_i .eq. r_i then goto end_loop_s_5
$     write autoh record'r2_i'
$     wrote_empty_line := no
$     r2_i = r2_i + 1
$     goto loop_s_5
$  end_loop_s_5:
$     write autoh ""
$     wrote_empty_line := yes
$     goto loop_s_23
$  end_loop_s_3:
$    if .not. wrote_empty_line then write autoh ""
$    close t_file
$    goto loop_s_2
$  end_loop_s_2:
$  endif
$
$ t_i = 0
$loop_t:
$ ctype = f$element(t_i,",",types)
$ t = f$edit(ctype,"UPCASE")
$ if t .eqs "" then goto loop_t
$ if t .eqs. "," then goto end_loop_t
$ l = f$length(t)
$loop_t_2:
$ p = f$locate(" ",t)
$ if p .ge. l then goto loop_t_3
$ t = f$extract(0,p,t)+"_"+f$extract(p+2,1000,t)
$ goto loop_t_2
$loop_t_3:
$ p = f$locate("*",t)
$ if p .ge. l then goto write_t
$ t = f$extract(0,p,t)+"P"+f$extract(p+2,1000,t)
$ goto loop_t_3
$write_t:
$ if f$locate(","+t+",",used_types) .lt. f$length(used_types) then goto loop_t
$ used_types = used_types+t+","
$ write autoh ""
$ write autoh "/* The number of bytes in a ",ctype," */
$ write autoh "#undef SIZEOF_",t
$ goto loop_t
$end_loop_t:
$
$ f_i = 0
$loop_f:
$ func = f$element(f_i," ",funcs)
$ f = f$edit(func,"UPCASE")
$ if f .eqs "" then goto loop_f
$ if f .eqs. " " then goto end_loop_f
$ l = f$length(f)
$ p = -1
$loop_f_2:
$ p = p + 1
$ if p .ge. l then goto write_f
$ s = f$extract(p,1,f)
$ if s .ges. "A" .and. s .les. "Z" -
     .or. s .ges. "0" .and. s .les. "9" -
     .or. s .eqs. "_" then goto loop_f_2
$ f = f$extract(0,p,f)+"_"+f$extract(p+2,1000,f)
$ goto loop_f_2
$write_f:
$ if f$locate(" "+f+" ",used_funcs) .lt. f$length(used_funcs) then goto loop_f
$ used_funcs = used_funcs+f+" "
$ write autoh ""
$ write autoh "/* Define if you have ",func," */"
$ write autoh "#undef HAVE_",f
$ goto loop_f
$end_loop_f:
$ 
$ h_i = 0
$loop_h:
$ header = f$element(h_i," ",headers)
$ h = f$edit(header,"UPCASE")
$ if h .eqs "" then goto loop_h
$ if h .eqs. " " then goto end_loop_h
$ l = f$length(h)
$ p = -1
$loop_h_2:
$ p = p + 1
$ if p .ge. l then goto write_h
$ s = f$extract(p,1,h)
$ if s .ges. "A" .and. s .les. "Z" -
     .or. s .ges. "0" .and. s .les. "9" -
     .or. s .eqs. "_" then goto loop_h_2
$ h = f$extract(0,p,h)+"_"+f$extract(p+2,1000,h)
$ goto loop_h_2
$write_h:
$ if f$locate(" "+h+" ",used_headers) .lt. f$length(used_headers) then goto loop_h
$ used_headers = used_headers+h+" "
$ write autoh ""
$ write autoh "/* Define if you have ",header," */"
$ write autoh "#undef HAVE_",h
$ goto loop_h
$end_loop_h:
$
$ l_i = 0
$loop_l:
$ lib = f$element(l_i," ",libs)
$ l = f$edit(lib,"UPCASE")
$ if l .eqs "" then goto loop_l
$ if l .eqs. " " then goto end_loop_l
$ l = f$length(l)
$ p = -1
$loop_l_2:
$ p = p + 1
$ if p .ge. l then goto write_l
$ s = f$extract(p,1,l)
$ if s .ges. "A" .and. s .les. "Z" -
     .or. s .ges. "0" .and. s .les. "9" -
     .or. s .eqs. "_" then goto loop_l_2
$ l = f$extract(0,p,l)+"_"+f$extract(p+2,1000,l)
$ goto loop_l_2
$write_l:
$ if f$locate(" "+l+" ",used_libs) .lt. f$length(used_libs) then goto loop_l
$ used_libs = used_libs+l+" "
$ write autoh ""
$ write autoh "/* Define if you have ",lib," */"
$ write autoh "#undef HAVE_LIB",l
$ goto loop_l
$end_loop_l:
$
$ if f$search(config_h+"_bot") .nes. "" then copy 'config_h'_bot autoh:
$
$ exit 'status'
$
$
$count_args:
$ argc = 8
$count_args1:
$ if argc .eq. 0 then return
$ if p'argc' .nes. "" then return
$ argc = argc - 1
$ goto count_args1
$
$
$process_arg:
$ argl = default_lable
$ _i1 = 0
$process_arg1:
$ _e1 = f$element(_i1,"|",possible_args)
$ _i1 = _i1 + 1
$ if "''_e1'" .eqs. "|" then return
$ _s = f$element(0,":",_e1)
$ _l = f$element(1,":",_e1)
$ _i2 = 0
$process_arg2:
$ _e2 = f$element(_i2,"/","''_s'")
$ _i2 = _i2 + 1
$ if "''_e2'" .eqs. "/" then goto process_arg1
$ _s1 = f$element(0,"*",_e2)
$ _s2 = f$element(1,"*",_e2)
$ if "''_s2'" .eqs. "*" then _s2 = ""
$ _s3 = f$element(1,"=","''_s2'")
$ _s2 = f$element(0,"=",_s2)
$ _p1 = f$element(0,"=",p1)
$ _p2 = f$element(1,"=",p1)
$ if "''_p1'" .nes. f$extract(0,f$length(_p1),"''_s1'"+"''_s2'") then goto process_arg2
$ if ("''_s3'" .nes. "=" .and. "''_p2'" .eqs. "=") -
	.or. (_s3 .eqs. "=" .and. _p2 .nes. "=") then goto process_arg_err
$ if _s3 .eqs. "=" then gosub shift
$ argl = _l
$ if _s3 .nes. "=" then p1 = _p2
$ return
$process_arg_err:
$ argl = error_lable
$ return
$
$
$shift:
$ p1 = p2
$ p2 = p3
$ p3 = p4
$ p4 = p5
$ p5 = p6
$ p6 = p7
$ p7 = p8
$ p8 = ""
$ if argc .gt. 0 argc = argc - 1
$ return
