dnl Macros that test for specific features.
dnl This file is part of Autoconf.
dnl Copyright (C) 1992, 1993, 1994 Free Software Foundation, Inc.
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2, or (at your option)
dnl any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl
dnl Written by David MacKenzie, with help from
dnl Franc,ois Pinard, Karl Berry, Richard Pixley, Ian Lance Taylor,
dnl Roland McGrath, and Noah Friedman.
dnl
dnl
dnl checks for programs
dnl
dnl
define(AC_PROG_CC, dnl
dnl Really, we should prefer GCC over CC, but really, it isn't good enough
dnl right now.
dnl [AC_BEFORE([$0], [AC_PROG_CPP])AC_PROVIDE([$0])AC_PROGRAM_CHECK(CC, gcc, gcc, cc)
[AC_BEFORE([$0], [AC_PROG_CPP])AC_PROVIDE([$0])AC_PROGRAM_CHECK(CC, cc, cc, gcc)
$!# Find out if we are using GNU C, under whatever name.
$ _GNU_C := no
$ _DEC_C := no
$ _VAX_C := no
AC_MAYBE_SILENT([$ type sys$input /out=conftest.c
#ifdef __GNUC__
conftest___ _GNU_C:=yes
#endif
#ifdef __DECC
conftest___ _DEC_C:=yes
#else
#ifdef VAXC
conftest___ _VAX_C:=yes
#endif
#endif
$!#
$ if f$type(CFLAGS) .eqs. "" then CFLAGS = ""
$ ac_preprocess
$ search conftest.out "conftest___" /out=conftest.out-stripped/noheader])
$ open/read ac_prog_cc_in conftest.out-stripped
$ac_prog_cc_read_loop:
$ read/end=ac_prog_cc_stop_reading ac_prog_cc_in foo
$ foo = f$extract(12,999,foo) ! Get rid of "conftest___ "
$ 'foo'
$ goto ac_prog_cc_read_loop
$ac_prog_cc_stop_reading:
$ close ac_prog_cc_in
$ if f$type(LIBS) .eqs. "" then LIBS = ""
$ if f$type(OPTS) .eqs. "" then OPTS = ""
$ sys_includes = ""
$ ac_GCC := no
$ if _GNU_C
$  then
$   ac_GCC := yes
$   CFLAGS := 'CFLAGS' /NOCASE_HACK
$   if OPTS .nes. ""
$    then OPTS = OPTS + ","
$    endif
changequote({,})dnl
$   OPTS := 'OPTS',GNU_CC:[000000]OPTIONS_SHR.OPT/opt
changequote([,])dnl
$! I'm currently not at all sure this is needed...
$   sys_includes := gnu_cc_include:,vaxc$include:,sys$library:
$  else
$   if _DEC_C
$    then
$     CFLAGS := 'CFLAGS' /NESTED=INCLUDE
$    else
$     if LIBS .nes. ""
$      then LIBS = LIBS + " "
$      endif
$     LIBS = LIBS + "SYS$SHARE:VAXCRTL/SHARE"
$     sys_includes := vaxc$include:,sys$library:
$    endif
$   if sys_includes .nes. "" then defi/nolog sys 'sys_includes'
$  endif
$ ac_cflags = CFLAGS
AC_SUBST(sys_includes)dnl
AC_SUBST(OPTS)dnl
AC_SUBST(LIBS)dnl
AC_SUBST(CFLAGS)dnl
$ set noon
$ delete conftest*.*.*
$])dnl
dnl
define(AC_PROG_CXX, dnl
[AC_BEFORE([$0], [AC_PROG_CXXCPP])AC_PROVIDE([$0])dnl
AC_PROGRAMS_CHECK(CXX, cxx gcc, gcc)
$ _GNU_CXX := no
$ _DEC_CXX := no
$!# Find out if we are using GNU C, under whatever name.
AC_MAYBE_SILENT([$ type sys$input /out=conftest.c
#ifdef __GNUC__
conftest___ _GNU_CXX:=yes
#endif
#ifdef __DECCXX
conftest___ _DEC_CXX:=yes
#endif
$!#
$ if f$type(CFLAGS) .eqs. "" then CFLAGS = ""
$ ac_preprocess
$ search conftest.out "conftest___" /out=conftest.out-stripped/noheader])
$ open/read ac_prog_cc_in 'tempcname'-stripped
$ac_prog_cxx_read_loop:
$ read/end=ac_prog_cxx_stop_reading ac_prog_cc_in foo
$ foo = f$extract(12,999,foo) ! Get rid of "conftest___ "
$ 'foo'
$ goto ac_prog_cxx_read_loop
$ac_prog_cxx_stop_reading:
$ close ac_prog_cc_in
$ if f$type(LIBS) .eqs. "" then LIBS = ""
$ if f$type(OPTS) .eqs. "" then OPTS = ""
$ if _GNU_CXX
$  then
changequote({,})dnl
$   OPTS := 'OPTS',GNU_CC:[000000]OPTIONS_SHR.OPT/opt
changequote([,])dnl
$  else
$   if _DEC_CXX
$    then
$     CFLAGS := 'CFLAGS' /PREFIX=ALL /NESTED=INCLUDE
$    endif
$  endif
$ ac_cflags = CFLAGS
AC_SUBST(sys_includes)dnl
AC_SUBST(OPTS)dnl
AC_SUBST(LIBS)dnl
AC_SUBST(CFLAGS)dnl
$ set noon
$ delete conftest*.*.*
$])dnl
dnl
define(AC_GCC_TRADITIONAL,
[AC_REQUIRE([AC_PROG_CC])AC_REQUIRE([AC_PROG_CPP])dnl
$ if "''ac_GCC'" .nes. ""
$  then
AC_CHECKING(whether -traditional is needed)
AC_PROGRAM_EGREP(["Autoconf","'x'"/match=and],[#include <sgtty.h>
Autoconf TIOCGETP],$ need_trad = "YES")
$   if "''need_trad'" .eqs. ""
$    then
AC_PROGRAM_EGREP(["Autoconf","'x'"/match=and],[#include <sgtty.h>
Autoconf TCGETA],$ need_trad = "YES")
$    endif
$   if "''need_trad'" .nes. "" then CC=CC+"/CC1_OPTIONS=(""-traditional"")"
$  endif
$])dnl
dnl
define(AC_MINUS_C_MINUS_O,[$])dnl This is a noop as well, because this is right on VMS.
dnl
dnl Define SET_MAKE to set ${MAKE} if make doesn't.
define(AC_SET_MAKE,
[$ type sys$input: /out=conftestmake.
all :
	@ write sys$output "$ ac_maketemp:==$(MMS)$(MAKE)"
$
$!set ver
$! MMK is a free MMS clone.  GMAKE is GNU make.
$!TTNHACK: jam preference for mms for now (2003-03-10)
$! ac_makes := mmk,gmake,mms
$ ac_makes := mms,mmk,gmake,mms
$ ac_makes_i = 0
$ SET_MAKE :=
$!$ if f$type(MAKE) .eqs. "" then goto ac_set_make_loop
$!$ if MAKE .nes. "" .and. f$edit(MAKE,"UPCASE") .nes. "$TECO MAKE" then -
$!	ac_makes_i = 999
$!$ if MAKE .nes. "" .and. f$edit(MAKE,"UPCASE") .nes. "$TECO MAKE" then -
$!	SET_MAKE = MAKE
$ac_set_make_loop:
$ ac_make = f$element(ac_makes_i, ",", ac_makes)
$ if ac_make .eqs. "," then goto ac_set_make_loop_end
$ ac_very_dummy := 'ac_make
$ ac_very_dummy := 'ac_makes_i
$ ac_makes_i = ac_makes_i + 1
$ SET_MAKE = ac_make
$ if f$type('SET_MAKE') .nes. "" then SET_MAKE = 'SET_MAKE'
changequote(,)dnl
$!# GNU make sometimes prints "make[1]: Entering...", which would confuse us.
changequote([,])dnl
$!$ set ver
$ set noon
AC_MAYBE_NOERROR([$ SET_MAKE -f conftestmake.
$ ac_severity = $severity
$ if f$trnlnm("sys$output",,,,,"ACCESS_MODE") .eqs. "USER" then -
	deassign/user sys$output
$])
$ if ac_severity .ne. 1
$  then
AC_MAYBE_NOERROR([$   SET_MAKE /description=conftestmake./output=conftest.out
$   ac_severity = $severity
$!$   set nover
$])
$  endif
$!$ set nover
$ if ac_severity .ne. 1 then goto ac_set_make_loop
$ SET_MAKE = ac_make
$ac_set_make_loop_end:
$ if SET_MAKE .nes. "," then SET_MAKE="MAKE="+SET_MAKE
$ ac_very_dummy := 'SET_MAKE
$ if f$search("conftestmake.*") .nes. "" then delete/nolog conftestmake.*;*
$ if f$search("conftest.out") .nes. "" then delete/nolog conftest.out;*
AC_SUBST([SET_MAKE])dnl
$!set nover
$])dnl
dnl
define(AC_PROG_RANLIB,[$])dnl yet another noop. There is no such thing as ranlib
dnl
define(AC_PROG_AWK, [AC_PROGRAMS_CHECK(AWK, mawk gawk nawk awk,)])dnl
dnl
define(AC_PROG_YACC,[AC_PROGRAMS_CHECK(YACC, bison/yacc byacc yacc,)])dnl
dnl
define(AC_PROG_CPP,
[AC_PROVIDE([$0])AC_CHECKING(how to run the C preprocessor)
$ if "''CPP'" .eqs. ""
$  then
$  CPP="''CC' ''CFLAGS'/PREPROCESS="
dnl On the NeXT, cc -E runs the code through the compiler's parser,
dnl not just through cpp.
  AC_TEST_CPP([#include <stdio.h>
Syntax Error], , [$ write sys$error "What do I do now?"
$ exit 0])
$  endif
AC_VERBOSE(setting CPP to 'CPP')
AC_SUBST(CPP)dnl
$])dnl
dnl
define(AC_PROG_CXXCPP,
[AC_PROVIDE([$0])AC_CHECKING(how to run the C++ preprocessor)
AC_LANG_SAVE[]dnl
AC_LANG_CPLUSPLUS[]dnl
$ if "''CXXCPP'" .eqs. ""
$  then
$   CXXCPP := cxx
$   if "''CXX'" .nes. "" CXXCPP = CPP
AC_TEST_CPP([#include <stdlib.h>])
$  endif
AC_VERBOSE(setting CXXCPP to 'CXXCPP')
AC_LANG_RESTORE[]dnl
AC_SUBST(CXXCPP)dnl
])dnl
dnl
dnl Require finding the C or C++ preprocessor, whichever is the
dnl current language.
define(AC_REQUIRE_CPP,
[ifelse(AC_LANG,C,[AC_REQUIRE([AC_PROG_CPP])],[AC_REQUIRE([AC_PROG_CXXCPP])])])dnl
dnl
define(AC_PROG_LEX,
[AC_PROVIDE([$0])AC_PROGRAM_CHECK(LEX, flex, flex,)
$!# It looks like FLEX for VMS does not have a library.
$!# if "''LEXLIB'"
$!#  then
$!#   case "$LEX" in
$!#   flex*)
$!#   flex*) AC_HAVE_LIBRARY(fl, LEXLIB="-lfl") ;;
$!#   *) LEXLIB="-ll" ;;
$!#   esac
$!# fi
AC_SUBST(LEXLIB)])dnl
dnl
define(AC_DECLARE_YYTEXT,
[AC_REQUIRE_CPP()AC_REQUIRE([AC_PROG_LEX])dnl
AC_CHECKING(for yytext declaration)
$!# POSIX says lex can declare yytext either as a pointer or an array; the
$!# default is implementation-dependent. Figure out which it is, since
$!# not all implementations provide the %pointer and %array declarations.
$!#
$!# The minimal lex program is just a single line: %%.  But some broken lexes
$!# (Solaris, I think it was) want two %% lines, so accommodate them.
$ set noon
$ type sys$input/out=conftest.l
%%
%%
$ 'LEX' conftest.l
$ delete conftest.l.*
$ if f$search("lex_yy.c")
$  then
$   LEX_OUTPUT_ROOT:=lex_yy
$  else
$   if f$search("lexyy.c") .nes. ""
$    then
$     LEX_OUTPUT_ROOT:=lexyy
$    else
$     !# Don't know what to do here.
AC_ERROR(cannot find output from 'LEX', giving up on yytext declarartion)
$     LEX_OUTPUT_ROOT:=
$    endif
$  endif
$ if LEX_OUTPUT_ROOT .nes. ""
$  then
$   append 'LEX_OUTPUT_ROOT'.c,sys$input: conftest.c
extern char *yytext; main () { exit (1); }
$   AC_TEST_FILED_PROGRAM(conftest.c, [AC_DEFINE(YYTEXT_POINTER)])
$   delete/nolog 'LEX_OUTPUT_ROOT'.c.*,conftest*.*.*
$  endif
$ set on
AC_SUBST(LEX_OUTPUT_ROOT)dnl
$])dnl
dnl
define(AC_PROG_INSTALL,
[$ if f$type(INSTALL) .eqs. "" THEN -
	INSTALL:=copy/prot=(s:rwed,o:rwed,g:re,w:re)
AC_SUBST(INSTALL)dnl
__AC_VERBOSE(["setting INSTALL to ",INSTALL])
$ if f$type(INSTALL_PROGRAM) .eqs. "" THEN -
	INSTALL_PROGRAM:=copy/prot=(s:rwed,o:rwed,g:re,w:re)
AC_SUBST(INSTALL_PROGRAM)dnl
__AC_VERBOSE(["setting INSTALL_PROGRAM to ",INSTALL_PROGRAM])
$ if f$type(INSTALL_DATA) .eqs. "" THEN -
	INSTALL_DATA:=copy/prot=(s:rwed,o:rwed,g:re,w:re)
AC_SUBST(INSTALL_DATA)dnl
__AC_VERBOSE(["setting INSTALL_DATA to ",INSTALL_DATA])
$])dnl
define(AC_PROG_INSTALL_QUOTED,
[$ if f$type(INSTALL_QUOTED) .eqs. "" THEN -
	INSTALL_QUOTED:=copy/prot=(s:rwed,o:rwed,g:re,w:re)
AC_SUBST(INSTALL_QUOTED)dnl
__AC_VERBOSE(["setting INSTALL_QUOTED to ",INSTALL_QUOTED])
$ if f$type(INSTALL_PROGRAM_QUOTED) .eqs. "" THEN -
	INSTALL_PROGRAM_QUOTED:=copy/prot=(s:rwed,o:rwed,g:re,w:re)
AC_SUBST(INSTALL_PROGRAM_QUOTED)dnl
__AC_VERBOSE(["setting INSTALL_PROGRAM_QUOTED to ",INSTALL_PROGRAM_QUOTED])
$ if f$type(INSTALL_DATA_QUOTED) .eqs. "" THEN -
	INSTALL_DATA_QUOTED:=copy/prot=(s:rwed,o:rwed,g:re,w:re)
AC_SUBST(INSTALL_DATA_QUOTED)dnl
__AC_VERBOSE(["setting INSTALL_DATA_QUOTED to ",INSTALL_DATA_QUOTED])
$])dnl
dnl
define(AC_LN_S,
[AC_CHECKING([for ln -s (Will use COPY instead of ln -s)])
$ LN_S:=copy
AC_SUBST(LN_S)dnl
$])dnl
dnl
define(AC_RSH,
[AC_CHECKING(for remote shell)
$])dnl
dnl
dnl
dnl checks for header files
dnl
dnl
define(AC_STDC_HEADERS,
[AC_REQUIRE_CPP()dnl
AC_CHECKING(for ANSI C header files)
AC_TEST_CPP([#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <float.h>],
[$!# SunOS 4.x string.h does not declare mem*, contrary to ANSI.
AC_HEADER_EGREP(memchr, string.h,
$!# SGI's /bin/cc from Irix-4.0.5 gets non-ANSI ctype macros unless using -ansi.
[AC_TEST_PROGRAM([#include <ctype.h>
#define ISLOWER(c) ('a' <= (c) && (c) <= 'z')
#define TOUPPER(c) (ISLOWER(c) ? 'A' + ((c) - 'a') : (c))
#define XOR(e,f) (((e) && !(f)) || (!(e) && (f)))
void exit();
int main () { int i; for (i = 0; i < 256; i++)
if (XOR (islower (i), ISLOWER (i)) || toupper (i) != TOUPPER (i)) exit(2);
exit (0); }
],
[$!# ISC 2.0.2 stdlib.h does not declare free, contrary to ANSI.
AC_HEADER_EGREP(free, stdlib.h, [AC_DEFINE(STDC_HEADERS)])])])])
$])dnl
dnl
define(AC_UNISTD_H, [AC_OBSOLETE([$0], [. instead use AC_HAVE_HEADERS(unistd.h)])AC_HEADER_CHECK(unistd.h,
  [AC_DEFINE(HAVE_UNISTD_H)])])dnl
dnl
define(AC_USG,
[AC_OBSOLETE([$0], [$! instead use AC_HAVE_HEADERS(string.h) and HAVE_STRING_H])AC_COMPILE_CHECK([BSD string and memory functions],
[#include <strings.h>], [rindex(0, 0); bzero(0, 0);], , [AC_DEFINE(USG)])])dnl
dnl
dnl
dnl If memchr and the like aren't declared in <string.h>, include <memory.h>.
dnl To avoid problems, don't check for gcc2 built-ins.
define(AC_MEMORY_H,
[AC_OBSOLETE([$0], [.  Instead use AC_HAVE_HEADERS(memory.h) and HAVE_MEMORY_H])AC_CHECKING(whether string.h declares mem functions)
AC_HEADER_EGREP(memchr, string.h, ,
  AC_HEADER_CHECK(memory.h, [AC_DEFINE(NEED_MEMORY_H)]))])dnl
dnl
define(AC_MAJOR_HEADER,
[AC_COMPILE_CHECK([major, minor and makedev header],
[#include <sys/types.h>],
[return makedev(0, 0);], ac_makedev=1)
$ if "''ac_makedev'" .eqs. ""
$  then
AC_HEADER_CHECK(sys/mkdev.h, [AC_DEFINE(MAJOR_IN_MKDEV) $ ac_makedev=1])
$  endif
$ if "''ac_makedev'" .eqs. ""
$  then
AC_HEADER_CHECK(sys/sysmacros.h, [AC_DEFINE(MAJOR_IN_SYSMACROS)])
$  endif
$])dnl
dnl
define(AC_DIR_HEADER,
[AC_PROVIDE([$0])AC_CHECKING(for directory library header)
$ ac_dir_header:=
$ ac_include_dir_header:=
AC_DIR_HEADER_CHECK(dirent.h, DIRENT)
AC_DIR_HEADER_CHECK(sys/ndir.h, SYSNDIR)
AC_DIR_HEADER_CHECK(sys/dir.h, SYSDIR)
AC_DIR_HEADER_CHECK(ndir.h, NDIR)
$
$ if ac_dir_header .nes. "" then -
	ac_include_dir_header = "#include <"+ac_dir_header+">"
AC_CHECKING(for closedir return value)
AC_TEST_PROGRAM([#include <sys/types.h>
''ac_include_dir_header'
void exit();
int closedir(); main() { exit(closedir(opendir(".")) != 0); }], ,
[AC_DEFINE(VOID_CLOSEDIR)])
$])dnl
dnl Subroutine of AC_DIR_HEADER.
dnl ??? I tried to put this define inside AC_DIR_HEADER, but when I did
dnl that, $1 and $2 did not get expanded. --roland
dnl Check if $1 is the winning directory library header file.
dnl It must not only exist, but also correctly define the `DIR' type.
dnl If it is really winning, define $2 and set shell var `ac_dir_header' to $1.
define(AC_DIR_HEADER_CHECK, [dnl
$ if ac_dir_header .nes. ""
$  then
  AC_COMPILE_CHECK($1, [#include <sys/types.h>
#include <]$1[>],
  [DIR *dirp = 0;],
  [AC_DEFINE($2)
   $ ac_dir_header="$1"])
$  endif
$])dnl
dnl
dnl
dnl checks for typedefs
dnl
dnl
define(AC_GETGROUPS_T,
[AC_REQUIRE([AC_UID_T])dnl
AC_CHECKING(for type of array argument to getgroups)
dnl I know it looks curious, but some things need extra quoting.
AC_TEST_PROGRAM([/* Thanks to Mike Rendell for this test.  */
#include <sys/types.h>
#define NGID 256
#undef MAX
#define MAX(x,y) ((x) > (y) ? (x) : (y))
void exit();
main()
{
  gid_t gidset[NGID];
  int i, n;
  union { gid_t gval; long lval; }  val;

  val.lval = -1;
  for (i = 0; i < NGID; i++)
    gidset[i] = val.gval;
  n = getgroups (sizeof (gidset) / MAX (sizeof (int), sizeof (gid_t)) - 1,
                 gidset);
  /* Exit non-zero if getgroups seems to require an array of ints.  This
     happens when gid_t is short but getgroups modifies an array of ints.  */
  exit ((n > 0 && gidset[n] != val.gval) ? 1 : 0);
}
],
		[AC_DEFINE(GETGROUPS_T, gid_t)],
		[AC_DEFINE(GETGROUPS_T, int)])
$])dnl
dnl
define(AC_UID_T,
[AC_PROVIDE([$0])AC_CHECKING(for uid_t in sys/types.h)
AC_HEADER_EGREP(uid_t, sys/types.h, ,
  [AC_DEFINE(uid_t, int)
   AC_DEFINE(gid_t, int)])])dnl
dnl
define(AC_SIZE_T,
[AC_CHECKING(for size_t in sys/types.h)
AC_HEADER_EGREP(size_t, sys/types.h, , [dnl
AC_CHECKING(for size_t in stddef.h)
AC_HEADER_EGREP(size_t, stddef.h, , [AC_DEFINE(size_t, unsigned)])])])dnl
dnl
define(AC_PID_T,
[AC_PROVIDE([$0])AC_CHECKING(for pid_t in sys/types.h)
AC_HEADER_EGREP(pid_t, sys/types.h, , [AC_DEFINE(pid_t, int)])])dnl
dnl
define(AC_OFF_T,
[AC_PROVIDE([$0])AC_CHECKING(for off_t in sys/types.h)
AC_HEADER_EGREP(off_t, sys/types.h, , [AC_DEFINE(off_t, long)])])dnl
dnl
define(AC_MODE_T,
[AC_CHECKING(for mode_t in sys/types.h)
AC_HEADER_EGREP(mode_t, sys/types.h, , [AC_DEFINE(mode_t, int)])])dnl
dnl
define(AC_RETSIGTYPE,
[AC_PROVIDE([$0])AC_COMPILE_CHECK([return type of signal handlers],
[#include <sys/types.h>
#include <signal.h>
#ifdef signal
#undef signal
#endif
extern void (*signal ()) ();],
[int i;],
[AC_DEFINE(RETSIGTYPE, void)],
[AC_DEFINE(RETSIGTYPE, int)])])dnl
dnl
dnl
dnl checks for functions
dnl
dnl
define(AC_MMAP, [
AC_CHECKING(for working mmap)
AC_TEST_PROGRAM([/* Thanks to Mike Haertel and Jim Avera for this test. */
#include <sys/types.h>
#include <fcntl.h>
#include <sys/mman.h>

#ifdef BSD
#ifndef BSD4_1
#define HAVE_GETPAGESIZE
#endif
#endif
#ifndef HAVE_GETPAGESIZE
#include <sys/param.h>
#ifdef EXEC_PAGESIZE
#define getpagesize() EXEC_PAGESIZE
#else
#ifdef NBPG
#define getpagesize() NBPG * CLSIZE
#ifndef CLSIZE
#define CLSIZE 1
#endif /* no CLSIZE */
#else /* no NBPG */
#ifdef NBPC
#define getpagesize() NBPC
#else /* no NBPC */
#define getpagesize() PAGESIZE /* SVR4 */
#endif /* no NBPC */
#endif /* no NBPG */
#endif /* no EXEC_PAGESIZE */
#endif /* not HAVE_GETPAGESIZE */

#ifdef __osf__
#define valloc malloc
#endif

extern char *valloc();
extern char *malloc();

int
main()
{
  char *buf1, *buf2, *buf3;
  int i = getpagesize(), j;
  int i2 = getpagesize()*2;
  int fd;

  buf1 = valloc(i2);
  buf2 = valloc(i);
  buf3 = malloc(i2);
  for (j = 0; j < i2; ++j)
    *(buf1 + j) = rand();
  fd = open("conftestmmap", O_CREAT | O_RDWR, 0666);
  write(fd, buf1, i2);
  mmap(buf2, i, PROT_READ | PROT_WRITE, MAP_FIXED | MAP_PRIVATE, fd, 0);
  for (j = 0; j < i; ++j)
    if (*(buf1 + j) != *(buf2 + j))
      exit(1);
  lseek(fd, (long)i, 0);
  read(fd, buf2, i); /* read into mapped memory -- file should not change */
  /* (it does in i386 SVR4.0 - Jim Avera) */
  lseek(fd, (long)0, 0);
  read(fd, buf3, i2);
  for (j = 0; j < i2; ++j)
    if (*(buf1 + j) != *(buf3 + j))
      exit(1);
  exit(0);
}
], [AC_DEFINE(HAVE_MMAP)])
$])dnl
dnl
define(AC_VPRINTF,
[AC_COMPILE_CHECK([vprintf], , [vprintf();], [AC_DEFINE(HAVE_VPRINTF)],
ac_vprintf_missing=1)
$ if "''ac_vprintf_missing'" .nes. ""
$  then
AC_COMPILE_CHECK([_doprnt], , [_doprnt();], [AC_DEFINE(HAVE_DOPRNT)])
$  endif
$])dnl
dnl
define(AC_VFORK,
[AC_REQUIRE([AC_PID_T])AC_HEADER_CHECK(vfork.h, [AC_DEFINE(HAVE_VFORK_H)])
AC_CHECKING(for working vfork)
AC_REQUIRE([AC_RETSIGTYPE])
AC_TEST_PROGRAM([/* Thanks to Paul Eggert for this test.  */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_VFORK_H
#include <vfork.h>
#endif
static int signalled;
static RETSIGTYPE catch (s) int s; { signalled = 1; }
void exit();
main() {
  pid_t parent = getpid ();
  pid_t child;

  signal (SIGINT, catch);

  child = vfork ();

  if (child == 0) {
    /* On sparc systems, changes by the child to local and incoming
       argument registers are propagated back to the parent.
       The compiler is told about this with #include <vfork.h>,
       but some compilers (e.g. gcc -O) don't grok <vfork.h>.
       Test for this by using lots of local variables, at least
       as many local variables as main has allocated so far
       including compiler temporaries.  4 locals are enough for
       gcc 1.40.3 on a sparc, but we use 8 to be safe.
       A buggy compiler should reuse the register of parent
       for one of the local variables, since it will think that
       parent can't possibly be used any more in this routine.
       Assigning to the local variable will thus munge parent
       in the parent process.  */
    pid_t
      p = getpid(), p1 = getpid(), p2 = getpid(), p3 = getpid(),
      p4 = getpid(), p5 = getpid(), p6 = getpid(), p7 = getpid();
    /* Convince the compiler that p..p7 are live; otherwise, it might
       use the same hardware register for all 8 local variables.  */
    if (p != p1 || p != p2 || p != p3 || p != p4
	|| p != p5 || p != p6 || p != p7)
      _exit(1);

    /* On some systems (e.g. SunOS 5.2), if the parent is catching
       a signal, the child ignores the signal before execing,
       and the parent later receives that signal, the parent dumps core.
       Test for this by ignoring SIGINT in the child.  */
    signal (SIGINT, SIG_IGN);

    /* On some systems (e.g. IRIX 3.3),
       vfork doesn't separate parent from child file descriptors.
       If the child closes a descriptor before it execs or exits,
       this munges the parent's descriptor as well.
       Test for this by closing stdout in the child.  */
    _exit(close(fileno(stdout)) != 0);
  } else {
    int status;
    struct stat st;

    while (wait(&status) != child)
      ;
    exit(
	 /* Was there some problem with vforking?  */
	 child < 0

	 /* Did the child fail?  (This shouldn't happen.)  */
	 || status

	 /* Did the vfork/compiler bug occur?  */
	 || parent != getpid()

	 /* Did the signal handling bug occur?  */
	 || kill(parent, SIGINT) != 0
	 || signalled != 1

	 /* Did the file descriptor bug occur?  */
	 || fstat(fileno(stdout), &st) != 0
	 );
  }
}], , [AC_DEFINE(vfork, fork)])
$])dnl
dnl
define(AC_WAIT3,
[AC_CHECKING(for wait3 that fills in rusage)
AC_TEST_PROGRAM([#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <stdio.h>
/* HP-UX has wait3 but does not fill in rusage at all.  */
main() {
  struct rusage r;
  int i;
  /* Use a field that we can force nonzero --
     voluntary context switches.
     For systems like NeXT and OSF/1 that don't set it,
     also use the system CPU time.  */
  r.ru_nvcsw = 0;
  r.ru_stime.tv_sec = 0;
  r.ru_stime.tv_usec = 0;
  switch (fork()) {
  case 0: /* Child.  */
    sleep(1); /* Give up the CPU.  */
    _exit(0);
  case -1: _exit(0); /* What can we do?  */
  default: /* Parent.  */
    wait3(&i, 0, &r);
    sleep(1); /* Avoid "text file busy" from rm on fast HP-UX machines.  */
    exit(r.ru_nvcsw == 0
	 && r.ru_stime.tv_sec == 0 && r.ru_stime.tv_usec == 0);
  }
}], [AC_DEFINE(HAVE_WAIT3)])
$])dnl
dnl
define(AC_ALLOCA,
[$!# The Ultrix 4.2 mips built in alloca declared by alloca.h only works
$!# for constant arguments.  Useless!
AC_COMPILE_CHECK(working alloca.h, [#include <alloca.h>],
  [char *p = alloca(2 * sizeof(int));], [AC_DEFINE(HAVE_ALLOCA_H)])
dnl If alloca is a macro designing another name, the C file should contain
dnl the following:
dnl   /* Make alloca work the best possible way.  */
dnl   #ifdef __GNUC__
dnl   #define alloca __builtin_alloca
dnl   #else /* not __GNUC__ */
dnl   #ifdef __DECC
dnl   #include <builtins.h>
dnl   #define alloca __ALLOCA
dnl   #else /* not __GNUC__ or __DECC */
dnl   #if HAVE_ALLOCA_H
dnl   #include <alloca.h>
dnl   #else /* not __GNUC__ or __DECC or HAVE_ALLOCA_H */
dnl   #ifdef _AIX
dnl    #pragma alloca
dnl   #else /* not _AIX */
dnl   char *alloca ();
dnl   #endif /* not _AIX */
dnl   #endif /* not HAVE_ALLOCA_H */ 
dnl   #endif /* not __DECC */
dnl   #endif /* not __GNUC__ */
AC_COMPILE_CHECK([alloca], [#ifdef __GNUC__
#define alloca __builtin_alloca
#else
#ifdef __DECC
#include <builtins.h>
#define alloca __ALLOCA
#else
#if HAVE_ALLOCA_H
#include <alloca.h>
#else
#ifdef _AIX
 #pragma alloca
#else
char *alloca ();
#endif
#endif
#endif
#endif
],
[char *p = (char *) alloca(1);], [AC_DEFINE([HAVE_ALLOCA])], [dnl
$ ac_alloca_missing=1
AC_PROGRAM_EGREP(winnitude, [
#if defined(CRAY) && ! defined(CRAY2)
winnitude
#else
lossage
#endif
],
[AC_FUNC_CHECK([_getb67],[AC_DEFINE([CRAY_STACKSEG_END],[_getb67])],
[AC_FUNC_CHECK([GETB67],[AC_DEFINE([CRAY_STACKSEG_END],[GETB67])],
[AC_FUNC_CHECK([getb67],[AC_DEFINE([CRAY_STACKSEG_END],[getb67])])])])])
$])
$ if "''ac_alloca_missing'" .nes. ""
$  then
$   !# The SVR3 libPW and SVR4 libucb both contain incompatible functions
$   !# that cause trouble.  Some versions do not even contain alloca or
$   !# contain a buggy version.  If you still want to use their alloca,
$   !# use ar to extract alloca.o from them instead of compiling alloca.c.
$   ALLOCA=",alloca.obj"
AC_DEFINE(C_ALLOCA)
$
AC_CHECKING(stack direction for C alloca)
dnl AC_TEST_PROGRAM_UNIX dnl
AC_TEST_PROGRAM([find_stack_direction ()
{
  static char *addr = 0;
  auto char dummy;
  if (addr == 0)
    {
      addr = &dummy;
      return find_stack_direction ();
    }
  else
    return (&dummy > addr) ? 1 : -1;
}
void exit();
main ()
{
  exit (find_stack_direction() < 0 ? 2 : 1); /* slightly changed for VMS */
}], dnl
[AC_DEFINE(STACK_DIRECTION,1)], [AC_DEFINE(STACK_DIRECTION,-1)], dnl
[AC_DEFINE(STACK_DIRECTION,0)])
dnl AC_TEST_PROGRAM_VMS dnl
$ endif
AC_SUBST(ALLOCA)dnl
$])dnl
dnl
define(AC_GETLOADAVG,
[$!# Some definitions of getloadavg require that the program be installed setgid.
AC_SUBST(NEED_SETGID)NEED_SETGID=false
$ ac_need_func:=yes
$
$!# Check for the 4.4BSD definition of getloadavg.
AC_HAVE_LIBRARY(util,
[$ LIBS=LIBS+" -lutil"
$ ac_need_func:=no])
AC_HAVE_LIBRARY(kvm,
[$ LIBS="$LIBS -lutil -lkvm"])
$
$ if ac_need_func
$  then
$   !# There is a commonly available library for RS/6000 AIX.
$   !# Since it is not a standard part of AIX, it might be installed locally.
$   LIBS_old=LIBS
$   LIBS="-L/usr/local/lib"+LIBS
AC_HAVE_LIBRARY(getloadavg,
[$ LIBS=LIBS+"-lgetloadavg"
$ ac_need_func:=no],[$ LIBS=LIBS_old])
$  endif
$
$!# Make sure it is really in the library, if we think we found it at all.
AC_REPLACE_FUNCS(getloadavg)

case "$LIBOBJS" in
*getloadavg*)
ac_need_func=true
AC_HEADER_CHECK(sys/dg_sys_info.h, [dnl
AC_DEFINE(DGUX)
$ ac_need_func=false
$!# Some versions of DGUX need -ldgc for dg_sys_info.
AC_HAVE_LIBRARY(dgc)])
if $ac_need_func; then
$!# We cannot check for <dwarf.h>, because Solaris 2 does not use dwarf (it
$!# uses stabs), but it's still SVR4.  We cannot check for <elf.h> because
$!# Irix 4.0.5F has the header but not the library.
ACHAVE_LIBRARY(elf, [AC_DEFINE(SVR4)
$ LIBS="$LIBS -lelf"
$ ac_need_func=false
  AC_HAVE_LIBRARY(kvm, [$ LIBS="$LIBS -lkvm"], [$])])
fi
if $ac_need_func; then
AC_HEADER_CHECK(inq_stats/cpustats.h, [AC_DEFINE(UMAX4_3) AC_DEFINE(UMAX)]
  $ ac_need_func=false)
fi
if $ac_need_func; then
AC_HEADER_CHECK(sys/cpustats.h, [AC_DEFINE(UMAX)$ need_func=false])
fi
if $ac_need_func; then
AC_HAVE_HEADERS(mach/mach.h)
fi

AC_HEADER_CHECK(nlist.h,
[AC_DEFINE(NLIST_STRUCT)
AC_COMPILE_CHECK(n_un in struct nlist, [#include <nlist.h>],
[struct nlist n; n.n_un.n_name = 0;],
[AC_DEFINE(NLIST_NAME_UNION)])])dnl

$!# Figure out whether we will need to install setgid.
AC_PROGRAM_EGREP([Yowza Am I SETGID yet], [dnl
#include "${srcdir}/getloadavg.c"
#ifdef LDAV_PRIVILEGED
Yowza Am I SETGID yet
#endif], [AC_DEFINE(GETLOADAVG_PRIVILEGED)$ NEED_SETGID=true])dnl
;;

*) AC_DEFINE(HAVE_GETLOADAVG) ;;
esac

if $NEED_SETGID; then
AC_SUBST(KMEM_GROUP)dnl
$  !# Figure out what group owns /dev/kmem.
$  !# The installed program will need to be setgid and owned by that group.
changequote(,)dnl
  $!# On Solaris, /dev/kmem is a symlink.  Get info on the real file.
  ac_ls_output=`ls -lgL /dev/kmem 2>/dev/null`
  $!# If we got an error (system does not support symlinks), try without -L.
  test -z "$ac_ls_output" && ac_ls_output=`ls -lg /dev/kmem`
  KMEM_GROUP=`echo $ac_ls_output \
    | sed -ne 's/[ 	][ 	]*/ /g;
	       s/^.[sSrwx-]* *[0-9]* *\([^0-9]*\)  *.*/\1/;
	       / /s/.* //;p;'`
changequote([,])dnl
fi
$])dnl
dnl
define(AC_UTIME_NULL,
[AC_CHECKING(utime with null argument)
$ delete/nolog conftestdata.;*
$ open/write ac_tmp_file conftestdata.;
$ close ac_tmp_file
$!# Sequent interprets utime(file, 0) to mean use start of epoch.  Wrong.
AC_TEST_PROGRAM([#include <sys/types.h>
#include <sys/stat.h>
main() {
struct stat s, t;
exit(!(stat ("conftestdata", &s) == 0 && utime("conftestdata", (long *)0) == 0
&& stat("conftestdata", &t) == 0 && t.st_mtime >= s.st_mtime
&& t.st_mtime - s.st_mtime < 120));
}], [AC_DEFINE(HAVE_UTIME_NULL)])
$])dnl
dnl
define(AC_STRCOLL, [AC_CHECKING(for strcoll)
AC_TEST_PROGRAM([#include <string.h>
main ()
{
  exit (strcoll ("abc", "def") >= 0 ||
	strcoll ("ABC", "DEF") >= 0 ||
	strcoll ("123", "456") >= 0);
}], [AC_DEFINE(HAVE_STRCOLL)])])dnl
dnl
define(AC_SETVBUF_REVERSED,
[AC_TEST_PROGRAM([#include <stdio.h>
/* If setvbuf has the reversed format, exit 0. */
main () {
  /* This call has the arguments reversed.
     A reversed system may check and see that the address of main
     is not _IOLBF, _IONBF, or _IOFBF, and return nonzero.  */
  if (setvbuf(stdout, _IOLBF, (char *) main, BUFSIZ) != 0)
    exit(1);
  putc('\r', stdout);
  exit(0);			/* Non-reversed systems segv here.  */
}], [AC_DEFINE(SETVBUF_REVERSED)])
$])dnl
dnl
dnl
dnl checks for structure members
dnl
dnl
define(AC_STRUCT_TM,
[AC_PROVIDE([$0])AC_COMPILE_CHECK([struct tm in time.h],
[#include <sys/types.h>
#include <time.h>],
[struct tm *tp; tp->tm_sec;], , [AC_DEFINE(TM_IN_SYS_TIME)])])dnl
dnl
define(AC_TIME_WITH_SYS_TIME,
[AC_COMPILE_CHECK([whether time.h and sys/time.h may both be included],
[#include <sys/types.h>
#include <sys/time.h>
#include <time.h>],
[struct tm *tp;],
[AC_DEFINE(TIME_WITH_SYS_TIME)
$ tm_in_sys_time="YES"])])dnl
dnl
define(AC_TIMEZONE,
[AC_REQUIRE([AC_STRUCT_TM])dnl
$ if "''tm_in_sys_time'"
$  then ac_decl = "sys/time.h"
$  else ac_decl = "time.h"
$  endif
AC_COMPILE_CHECK([tm_zone in struct tm], 
[#include <sys/types.h>
#include <''ac_decl'>
],
[struct tm tm; tm.tm_zone;], [AC_DEFINE(HAVE_TM_ZONE)], $ ac_no_tm_zone=1)
$ if "''ac_no_tm_zone'" .nes. ""
$  then
AC_COMPILE_CHECK(tzname, changequote(<<,>>)dnl
<<#include <time.h>
#ifndef tzname /* For SGI.  */
extern char *tzname[]; /* RS6000 and others want it this way.  */
#endif>>, changequote([,])dnl
[atoi(*tzname);], [AC_DEFINE(HAVE_TZNAME)])
$ endif
$])dnl
dnl
define(AC_ST_BLOCKS,
[AC_COMPILE_CHECK([st_blocks in struct stat],
[#include <sys/types.h>
#include <sys/stat.h>], [struct stat s; s.st_blocks;],
[AC_DEFINE(HAVE_ST_BLOCKS)], LIBOBJS="$LIBOBJS fileblocks.o")dnl
AC_SUBST(LIBOBJS)dnl
$])dnl
dnl
define(AC_ST_BLKSIZE,
[AC_COMPILE_CHECK([st_blksize in struct stat],
[#include <sys/types.h>
#include <sys/stat.h>], [struct stat s; s.st_blksize;],
[AC_DEFINE(HAVE_ST_BLKSIZE)])])dnl
dnl
define(AC_ST_RDEV,
[AC_COMPILE_CHECK([st_rdev in struct stat],
[#include <sys/types.h>
#include <sys/stat.h>], [struct stat s; s.st_rdev;],
[AC_DEFINE(HAVE_ST_RDEV)])])dnl
dnl
dnl
dnl checks for compiler characteristics
dnl
dnl
define(AC_CROSS_CHECK,
[AC_PROVIDE([$0])AC_CHECKING(whether cross-compiling)
$!# If we cannot run a trivial program, we must be cross compiling.
AC_TEST_PROGRAM([void exit();main(){exit(0);}], , [$ cross_compiling=1])
$])dnl
dnl
define(AC_CHAR_UNSIGNED,
[AC_CHECKING(for unsigned characters)
AC_TEST_PROGRAM(
[/* volatile prevents gcc2 from optimizing the test away on sparcs.  */
#if !__STDC__
#define volatile
#endif
main() {
#ifdef __CHAR_UNSIGNED__
  exit(1); /* No need to redefine it.  */
#else
  volatile char c = 255; exit(c < 0);
#endif
}], [AC_DEFINE(__CHAR_UNSIGNED__)])]
)dnl
dnl
define(AC_LONG_DOUBLE,
[AC_REQUIRE([AC_PROG_CC])dnl
AC_CHECKING(for long double)
if test -n "$GCC"; then
AC_DEFINE(HAVE_LONG_DOUBLE)
else
AC_TEST_PROGRAM([int main() {
/* The Stardent Vistra knows sizeof(long double), but does not support it.  */
long double foo = 0.0;
/* On Ultrix 4.3 cc, long double is 4 and double is 8.  */
exit(sizeof(long double) < sizeof(double)); }],
[AC_DEFINE(HAVE_LONG_DOUBLE)])
fi
$])dnl
dnl
define(AC_INT_16_BITS,
[AC_OBSOLETE([$0], [; instead use AC_SIZEOF_TYPE(int)])
AC_CHECKING(integer size)
AC_TEST_PROGRAM([main() { exit(sizeof(long) != 2); }],
 [AC_DEFINE(INT_16_BITS)])
$])dnl
dnl
define(AC_INT_64_BITS,
[AC_OBSOLETE([$0], [; instead use AC_SIZEOF_TYPE(long)])
AC_CHECKING(for 64-bit long ints)
AC_TEST_PROGRAM([main() { exit(sizeof(long) != 8); }],
 [AC_DEFINE(INT_64_BITS)])
$])dnl
dnl
define(AC_WORDS_BIGENDIAN,
[AC_CHECKING(byte ordering)
AC_TEST_PROGRAM([main () {
  /* Are we little or big endian?  From Harbison&Steele.  */
  union
  {
    long l;
    char c[sizeof (long)];
  } u;
  u.l = 1;
  exit (u.c[sizeof (long) - 1] == 1);
}], , [AC_DEFINE(WORDS_BIGENDIAN)])
$])dnl
dnl
define(AC_ARG_ARRAY,
[AC_CHECKING(whether the address of an argument can be used as an array)
AC_TEST_PROGRAM([main() {
/* Return 0 iff arg arrays are ok.  */
exit(x(1, 2, 3, 4) ? 2 : 1);
}
x(a, b, c, d) {
  return y(a, &b);
}
/* Return 1 iff arg arrays are ok.  */
y(a, b) int *b; {
  return a == 1 && b[0] == 2 && b[1] == 3 && b[2] == 4;
}], , [AC_DEFINE(NO_ARG_ARRAY)])
$])dnl
dnl
define(AC_INLINE,
[AC_REQUIRE([AC_PROG_CC])if test -n "$GCC"; then
AC_COMPILE_CHECK([inline], , [} inline foo() {], , [AC_DEFINE(inline, __inline)])
fi
$])dnl
define(AC_CONST,
[dnl Do not "break" this again.
AC_COMPILE_CHECK([lack of working const], ,
[/* Ultrix mips cc rejects this.  */
typedef int charset[2]; const charset x;
/* SunOS 4.1.1 cc rejects this.  */
char const *const *ccp;
char **p;
/* AIX XL C 1.02.0.0 rejects this.
   It does not let you subtract one const X* pointer from another in an arm
   of an if-expression whose if-part is not a constant expression */
const char *g = "string";
ccp = &g + (g ? g-g : 0);
/* HPUX 7.0 cc rejects these. */
++ccp;
p = (char**) ccp;
ccp = (char const *const *) p;
{ /* SCO 3.2v4 cc rejects this.  */
  char *t;
  char const *s = 0 ? (char *) 0 : (char const *) 0;

  *t++ = 0;
}
{ /* Someone thinks the Sun supposedly-ANSI compiler will reject this.  */
  int x[] = {25,17};
  const int *foo = &x[0];
  ++foo;
}
{ /* Sun SC1.0 ANSI compiler rejects this -- but not the above. */
  typedef const int *iptr;
  iptr p = 0;
  ++p;
}
{ /* AIX XL C 1.02.0.0 rejects this saying
     "k.c", line 2.27: 1506-025 (S) Operand must be a modifiable lvalue. */
  struct s { int j; const int *ap[3]; };
  struct s *b; b->j = 5;
}
{ /* ULTRIX-32 V3.1 (Rev 9) vcc rejects this */
  const int foo = 10;
}
], , [AC_DEFINE(const,)])])dnl
dnl
dnl
dnl checks for operating system services
dnl
dnl
define(AC_HAVE_POUNDBANG, [dnl
AC_CHECKING([if #! works in shell scripts IS A NOOP on VMS and is always false...])
$2
$])dnl
define(AC_REMOTE_TAPE,
[AC_CHECKING(for remote tape and socket header files)
AC_HEADER_CHECK(sys/mtio.h,
[AC_DEFINE(HAVE_SYS_MTIO_H)
$ ac_have_mtio=1])
$ if "''ac_have_mtio'"
$  then
AC_TEST_CPP([#include <sgtty.h>
#include <sys/socket.h>], [$ PROGS=PROGS+" rmt"])
$  endif
$])dnl
dnl
define(AC_LONG_FILE_NAMES,
[AC_CHECKING([for long file names (vms has that!)])
AC_DEFINE(HAVE_LONG_FILE_NAMES)
$])dnl
dnl
define(AC_RESTARTABLE_SYSCALLS,
[AC_CHECKING(for restartable system calls)
AC_TEST_PROGRAM(
[/* Exit 0 (true) if wait returns something other than -1,
   i.e. the pid of the child, which means that wait was restarted
   after getting the signal.  */
#include <sys/types.h>
#include <signal.h>
ucatch (isig) { }
main () {
  int i = fork (), status;
  if (i == 0) { sleep (3); kill (getppid (), SIGINT); sleep (3); exit (0); }
  signal (SIGINT, ucatch);
  status = wait(&i);
  if (status == -1) wait(&i);
  exit (status == -1);
}
], [AC_DEFINE(HAVE_RESTARTABLE_SYSCALLS)])
$])dnl
dnl
define(AC_FIND_X,
[$!# If we find X, set shell vars x_includes and x_libraries to the paths.
AC_CHECKING(for X include and library files)
$ if f$trnlnm("DECW$INCLUDE") .nes. ""
$  then
$   x_includes := DECW$INCLUDE:
AC_VERBOSE(X11 headers are in 'x_includes')
$  endif
$ if f$trnlnm("DECW$INCLUDE") .nes. ""
$  then
$   x_libraries := SYS$LIBRARY:
AC_VERBOSE(X11 libraries are in 'x_libraries')
$  endif
$ defi/nolog x11 'x_includes'
AC_SUBST(x_includes)dnl
$])dnl
dnl
dnl
dnl checks for UNIX variants
dnl
dnl
define(AC_AIX,
[AC_CHECKING(for AIX)
AC_BEFORE([$0], [AC_COMPILE_CHECK])AC_BEFORE([$0], [AC_TEST_PROGRAM])AC_BEFORE([$0], [AC_HEADER_EGREP])AC_BEFORE([$0], [AC_TEST_CPP])AC_PROGRAM_EGREP(yes,
[#ifdef _AIX
  yes
#endif
], [AC_DEFINE(_ALL_SOURCE)])
$])dnl
dnl
define(AC_MINIX,
[AC_BEFORE([$0], [AC_COMPILE_CHECK])AC_BEFORE([$0], [AC_TEST_PROGRAM])AC_BEFORE([$0], [AC_HEADER_EGREP])AC_BEFORE([$0], [AC_TEST_CPP])AC_HEADER_CHECK(minix/config.h, [$ MINIX:=YES])
$!# The Minix shell can't assign to the same variable on the same line!
$ if "''MINIX'" .eqs. "YES"
$  then
  AC_DEFINE(_POSIX_SOURCE)
  AC_DEFINE(_POSIX_1_SOURCE, 2)
  AC_DEFINE(_MINIX)
$  endif
$])dnl
dnl
define(AC_ISC_POSIX, [$! ISC_POSIX is a noop on VMS])
dnl
define(AC_XENIX_DIR, [$! XENIX_DIR is a noop on VMS])
dnl
define(AC_SCO_INTL, [$! SCO_INTL is a noop on VMS])
dnl
define(AC_IRIX_SUN, [$! IRIX_SUN is a noop on VMS])
dnl
define(AC_DYNIX_SEQ, [$! DYNIX_SEQ is a noop on VMS])
dnl
define(AC_STAT_MACROS_BROKEN,[AC_CHECKING(for broken stat file mode macros)
AC_PROGRAM_EGREP([You lose], [#include <sys/types.h>
#include <sys/stat.h>
#ifdef S_ISBLK
#if S_ISBLK (S_IFDIR)
You lose.
#endif
#ifdef S_IFCHR
#if S_ISBLK (S_IFCHR)
You lose.
#endif
#endif /* S_IFCHR */
#endif /* S_ISBLK */
#ifdef S_ISLNK
#if S_ISLNK (S_IFREG)
You lose.
#endif
#endif /* S_ISLNK */
#ifdef S_ISSOCK
#if S_ISSOCK (S_IFREG)
You lose.
#endif
#endif /* S_ISSOCK */
], [AC_DEFINE(STAT_MACROS_BROKEN)])])dnl
dnl
dnl
define(AC_SYS_SIGLIST_DECLARED,[dnl
AC_COMPILE_CHECK(sys_siglist declaration in signal.h or unistd.h,
		 [#include <signal.h>
/* NetBSD declares sys_siglist in <unistd.h>.  */
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif], [char *msg = *(sys_siglist + 1);],
		 [AC_DEFINE(SYS_SIGLIST_DECLARED)])])dnl
dnl
dnl debugmode(V)
