 #ifdef VAXC # #module CLUE$MISC "BOL-V1.0/AUG-96"  #else * #pragma module CLUE$MISC "BOL-V1.0/AUG-96" #endif   #include tpadef  #include ssdef   #include "clue$include.h"   N /* This module contains miscellaneous functions used by other CLUE modules. */  	 /******/   B /* DESC(): given a null-terminated string, this function returns a7 	   fixed-length descriptor pointing to this string. */    dsc *desc(char *str) {   static $DESCRIPTOR (x,"");     x.dsc$w_length = strlen(str);  x.dsc$a_pointer= str;    return &x;  }   	 /******/   A /* TRANSLATE_BITS(): Given a table containing bit definitions and C    a bit mask, this routine fills-in a buffer with the names of the @    bit set in the bit mask. If more names are returned, they are    separated with commas.   
    Inputs:  @    bittable - a pointer to a bit table. The table consists of an8 	      array of longwords representing the bit value and7 	      pointers to the approbiate bit name strings. The ; 	      table must be terminated with 0. Here is an example:    		struct 		{  		 int mask_value; 		 char* bit_name;/ 		} nambittab[6] = {LNMB$M_NO_ALIAS,"no_alias",   				  LNMB$M_CONFINE, "confine", 				  LNMB$M_CRELOG,  "crelog",  				  LNMB$M_TABLE,   "table",! 				  LNMB$M_NODELETE,"nodelete",  				  0,0};   4    bitmask - the bit mask to translate (max 32 bits)  6    retbuf - buffer to receive the resultant string. */  E void translate_bits(struct bittab *bitptr, int bitmask, char *retbuf)  { 4  retbuf[0] = 0;				/* Null string (if no bit set) */  6  while (bitptr->bitvalue)		/* Scan until 0 is found */  {D   if (bitmask & bitptr->bitvalue)	/* Is this bit set in the mask? */   { J    /* If there is already a string in retbuf, separate it with a comma. */  %    if (retbuf[0]) strcat(retbuf,",");   B    strcat(retbuf,bitptr->bitname);	/* Add corresponding bitname */   } '   bitptr++;				/* Switch to next bit */   } }   	 /******/   $ void get_expr(char *str,int *retval) { H  /* GET_EXPR(): Given an expression as  null-terminated string in 'str',L     this routine evaluates the expression and return the result in 'retval'.E     'str' may contain any valid SDA expression, including symbols and      operators.  E     We use a trick here to let SDA perform all parsing. First, we get G     the 'current' address (the last address used with EXAMINE) and save J     it. We then call SDA$EXTEND_PARSECOMMAND with the command 'EXA <str>',B     where 'str' is the given string. If this fails for some reason@     (invalid expression, unknown symbol(s)), SDA prints an error&     message and signals the condition.  E     Otherwise, if the given expression was valid, the current address D     was now changed to the the result of the expression. This is the8     value we must pass back to the caller (in 'retval').  7     Before return, we restore the 'current' address. */   1  char cmdbuf[132] = "EXA ";		/* Command buffer */   *  int oldaddr;				/* Old current address */  2  struct tpadef tpa;			/* TPA (parser) structure */  3  strcat(cmdbuf,str);			/* Append string to 'EXA' */   ;  /* Append ';0'. This forces EXAMINE to suppress output. */     strcat(cmdbuf,";0");   B  sda$extend_get_address(&oldaddr);	/* Save our current address. */  2  tpa.tpa$l_count = TPA$K_COUNT0;	/* 8 longwords */  >  tpa.tpa$l_options = TPA$M_ABBREV;	/* Abbreviations allowed */  B  tpa.tpa$l_stringcnt = strlen(cmdbuf);	/* Command string length */  A  tpa.tpa$l_stringptr = (int) cmdbuf;	/* Command string address */   <  sda$extend_parsecommand(&tpa);		/* Execute 'EXA <str>;0' */  H  sda$extend_get_address(retval);	/* return updated 'current' address. */  <  sda$extend_set_address(oldaddr);	/* Restore old address. */ } 