	program	frame_counter

C+
C Version:	X1-008
C
C Facility:	Diagnostic Utilities.
C
C Abstract:	This will start a watch on the ethernet device and count the
C		number of messages of different sizes.
C
C Environment:	PHY_IO and LOG_IO privileges are needed.
C
C		Run it via a foreign command and specify the device to watch.
C
C module frame_counter_cld
C
C define verb framecount
C	noparameters
C	qualifier device,	value (required)
C	qualifier protocol,	default, value (default = "*")
C	qualifier address,	default, value (default = "*")
C
C History:
C
C	12-Jul-1990, DBS; Version X1-001
C 001 -	Original version.  (Ripped off from PROTOCOL_COUNTER.)
C	13-Jul-1990, DBS; Version X1-002
C 002 -	Allow a specific protocol type to be monitored.
C	16-Jul-1990, DBS; Version X1-003
C 003 -	Add a display of the packets per second count.
C	17-Jul-1990, DBS; Version X1-004
C 004 -	Fix bug with something integer overflows (hopefully).
C	02-Oct-1991, DBS; Version X1-005
C 005 -	Added address matching.
C	20-Nov-1991, DBS; Version X1-006
C 006 -	Added call to sys_find_ether_device to establish the default.
C	17-Jan-1992, DBS; Version X1-007
C 007 -	Added software expiry check.
C	11-Oct-1993, DBS; Version X1-008
C 008 -	Fixed bug with packet header size.
C-

 	implicit none

	character	program_id*(*)
	parameter	(program_id = 'FRAME_COUNTER  X1-008')

C External references

	include 'FRAME_COUNTER_INC.INC/nolist'

	external	enable_controlc
	external	lib$date_time
	external	lib$put_output
	external	lib$stop
	external	parse_command
	external	startup_device
	integer*4	sys$assign
	external	sys$assign
	external	sys$hiber
	external	sys_check_software_expiry1

C Type declarations for variables

	integer*4	expiry_date		/-1/
	integer*4	check_date		/0/
	integer*4	assign_status

C+
C Mainline - frame_counter
C-

	call lib$put_output (program_id)
C	call sys_check_software_expiry1 (expiry_date, check_date)
	call lib$date_time (reset_time)

	call parse_command

	assign_status = sys$assign ('TT', io_channel,,)
	if (.not. assign_status) call lib$stop (%val(assign_status))

	call enable_controlc

	call startup_device

	call sys$hiber

	end

	subroutine parse_command

C++
C Functional Description:
C	This routine parses the users command.
C
C Calling Sequence:
C
C	call parse_command
C
C Formal Argument(s):
C	None
C
C Implicit Inputs:
C	counter_data common area.
C
C Implicit Outputs:
C	counter_data common area.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'FRAME_COUNTER_INC.INC/nolist'
	include '($CLIDEF)/nolist'

	integer*4	cli$dcl_parse
	external	cli$dcl_parse
	integer*4	cli$get_value
	external	cli$get_value
	integer*4	cli$present
	external	cli$present
	external	cli$_present
	external	cli$_negated
	external	cli$_locpres
	external	cli$_defaulted
	external	cli$_locneg
	external	cli$_absent
	external	frame_counter_cld
	external	lib$get_input
	external	lib$put_output
	external	str_collapse
	integer*4	str_len
	external	str_len
	external	str_uppercase
	external	sys_find_ether_device
	external	sys$exit

C Type declarations for parameters and PARAMETER statements

	character	cli_t_command*(*)
	parameter	(cli_t_command = 'FRAMECOUNT')

C Type declarations for variables

	integer*4	slash_loc
	integer*4	space_loc

C+
C Mainline - parse_command
C-

	call sys_find_ether_device (default_device)
	default_device_len = str_len (default_device)

	device   = default_device
	protocol = '*'
	spy_address = '*'

	call cli$get_value ('$LINE', command, command_len)

	space_loc = index(command(1:command_len), ' ')
	slash_loc = index(command(1:command_len), '/')

	if (space_loc .eq. 0) then
		if (slash_loc .eq. 0) then
			command = cli_t_command
		else
		command = cli_t_command//command(slash_loc:)
		endif !(slash_loc .eq. 0) then
	else
	if (slash_loc .lt. space_loc) then
		command = cli_t_command//command(slash_loc:)
	else
	command = cli_t_command//command(space_loc:)
	endif !(slash_loc .lt. space_loc) then
	endif !(space_loc .eq. 0) then

	call str_uppercase (command)
	command_len = str_len (command)

	status = cli$dcl_parse (command(1:command_len)
	1			,frame_counter_cld
	1			,lib$get_input
	1			,lib$get_input
	1			,'_FrameCount: ')
	if (.not. status) call sys$exit (%val('10000000'X .or. status))

	status = cli$present ('DEVICE')
	if ((status .eq. %loc(cli$_present))
	1		.or. (status .eq. %loc(cli$_defaulted)))
	1	call cli$get_value ('DEVICE', device, device_len)
	call str_uppercase (device)

	status = cli$present ('PROTOCOL')
	if ((status .eq. %loc(cli$_present))
	1		.or. (status .eq. %loc(cli$_defaulted)))
	1	call cli$get_value ('PROTOCOL', protocol, protocol_len)
	call str_uppercase (protocol)

	status = cli$present ('ADDRESS')
	if ((status .eq. %loc(cli$_present))
	1		.or. (status .eq. %loc(cli$_defaulted)))
	1	call cli$get_value ('ADDRESS', spy_address, spy_address_len)
	call str_uppercase (protocol)

	device_len   = str_len (device)
	protocol_len = str_len (protocol)
	spy_address_len = str_len (spy_address)

	if (protocol_len .lt. prot_len) then
		if ((index(protocol, '*') .eq. 0) .and.
	1			(index(protocol, '%') .eq. 0)) then
			protocol = protocol(1:protocol_len)//'*'
			protocol_len = protocol_len + 1
		endif !((index(protocol, '*') .eq. 0) .and.
	endif !(protocol_len .lt. prot_len) then

	if (spy_address_len .lt. addr_len) then
		if ((index(spy_address, '*') .eq. 0) .and.
	1			(index(spy_address, '%') .eq. 0)) then
			spy_address = spy_address(1:spy_address_len)//'*'
			spy_address_len = spy_address_len + 1
		endif !((index(spy_address, '*') .eq. 0) .and.
	endif !(spy_address_len .lt. addr_len) then

	call lib$put_output ('Counting frames for protocol '
	1			//protocol(1:protocol_len)//' address '
	1			//spy_address(1:spy_address_len))

	display_thresh = 0.3	! default for all
	if (protocol(1:protocol_len) .ne. '*') display_thresh = 0.15

	return
	end

	subroutine process_packet

C++
C Functional Description:
C	This routine gets the frame size and increments the packet count
C	for that size.
C
C Calling Sequence:
C
C	call process_packet
C
C Formal Argument(s):
C	None
C
C Implicit Inputs:
C	counter_data common area.
C
C Implicit Outputs:
C	None.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'FRAME_COUNTER_INC.INC/nolist'

	external	lib$int_over
	external	queue_async_read
	integer*4	str_match
	external	str_match
	external	sys$fao

C Type declarations for parameters and PARAMETER statements

	integer*4	disable_
	character	protocol_format*(*)
	character	address_format*(*)

	parameter	(disable_ = 0)
	parameter	(protocol_format = '!XB-!XB')
	parameter	(address_format = '!XB-!XB-!XB-!XB-!XB-!XB')

C Type declarations for variables

	integer*4	fao_len
	character	formatted_protocol*(prot_len)
	character	formatted_source*(addr_len)
	character	formatted_dest*(addr_len)
	integer*4	packet_size

C+
C Mainline - process_packet
C-

	call lib$int_over (disable_)

	call sys$fao (%descr(protocol_format)
	1		,%ref(fao_len)
	1		,%descr(formatted_protocol)
	1		,%val(packet.ethdr.prtcl(1))
	1		,%val(packet.ethdr.prtcl(2)))

	call sys$fao (%descr(address_format)
	1		,%ref(fao_len)
	1		,%descr(formatted_source)
	1		,%val(packet.ethdr.src(1))
	1		,%val(packet.ethdr.src(2))
	1		,%val(packet.ethdr.src(3))
	1		,%val(packet.ethdr.src(4))
	1		,%val(packet.ethdr.src(5))
	1		,%val(packet.ethdr.src(6)))

	call sys$fao (%descr(address_format)
	1		,%ref(fao_len)
	1		,%descr(formatted_dest)
	1		,%val(packet.ethdr.dst(1))
	1		,%val(packet.ethdr.dst(2))
	1		,%val(packet.ethdr.dst(3))
	1		,%val(packet.ethdr.dst(4))
	1		,%val(packet.ethdr.dst(5))
	1		,%val(packet.ethdr.dst(6)))

	if (str_match(formatted_protocol, protocol) .and.
	1	(str_match(formatted_source, spy_address)
	1	.or. str_match(formatted_dest, spy_address))) then
		packet_size = iosb.count + 18	! add the header/crc back on

		if (packet_size .gt. 1518) packet_size = 1518

		frame_size(packet_size) = frame_size(packet_size) + 1
	endif !(str_match(formatted_protocol, protocol))

	call queue_async_read

	return
	end

	subroutine queue_async_read

C++
C Functional Description:
C	Here we issue a qio to the ethernet device and setup an ast to
C	invoke the process_packet routine when we have something to read.
C
C Calling Sequence:
C
C	call queue_async_read
C
C Formal Argument(s):
C	None
C
C Implicit Inputs:
C	counter_data common area.
C
C Implicit Outputs:
C	None
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'FRAME_COUNTER_INC.INC/nolist'
	include '($IODEF)/nolist'

	external	lib$signal
	external	process_packet
	integer*4	sys$qio
	external	sys$qio

C+
C Mainline - queue_async_read
C-

	status = sys$qio (%val(0)
	1			,%val(log_channel)
	1			,%val(io$_readvblk)
	1			,%ref(iosb)
	1			,process_packet,
	1			,%val(%loc(packet.etdata))
	1			,%val(eth_c_length),,
	1			,%val(%loc(packet.ethdr.dst)),)

	if (.not. status) call lib$signal(%val(status))

	return
	end

	subroutine startup_device

C++
C Functional Description:
C	This routine attempts to startup the ethernet device, set it up so
C	we can see everything then queue the first read request to it.
C
C Calling Sequence:
C
C	call startup_device
C
C Formal Argument(s):
C	None
C
C Implicit Inputs:
C	counter_data common area.
C
C Implicit Outputs:
C	counter_data common area.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'FRAME_COUNTER_INC.INC/nolist'
	include 'DBSLIB:NMADEF.INC/nolist'
	include '($IODEF)/nolist'

	external	lib$signal
	external	queue_async_read
	integer*4	sys$assign
	external	sys$assign
	integer*4	sys$qiow
	external	sys$qiow
	external	zero_counters

C+
C Mainline - startup_device
C-

	status = sys$assign (%descr(device), %ref(log_channel),,)

	if (.not. status) call lib$signal (%val(status))

	param_desc.length		= e_num_params*6
	param_desc.parameters		= %loc(param_buffer)
	param_buffer(1).param_id	= nma$c_pcli_bus
	param_buffer(1).param_value	= e_max_packet_size
	param_buffer(2).param_id	= nma$c_pcli_bfn
	param_buffer(2).param_value	= e_num_rcv_buffers
	param_buffer(3).param_id	= nma$c_pcli_pad
	param_buffer(3).param_value	= nma$c_state_off
	param_buffer(4).param_id	= nma$c_pcli_pty
	param_buffer(4).param_value	= e_protocol_c
	param_buffer(5).param_id	= nma$c_pcli_prm
	param_buffer(5).param_value	= nma$c_state_on

	status = sys$qiow (%val(0)
	1			,%val(log_channel)
	1			,%val(io$_setmode .or. io$m_ctrl
	1				.or. io$m_startup)
	1			,%ref(iosb),,
	1			,,%val(%loc(param_desc)),,,,)

	if (.not. status) call lib$signal(%val(status))
	if (.not. iosb.value) call lib$signal (%val(iosb.value))

	call zero_counters

	call queue_async_read

	return
	end

	subroutine zero_counters

C++
C Functional Description:
C	Here we clear out all the counters.
C
C Calling Sequence:
C
C	call zero_counters
C
C Formal Argument(s):
C	None
C
C Implicit Inputs:
C	counter_data common area.
C
C Implicit Outputs:
C	None
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'FRAME_COUNTER_INC.INC/nolist'

	external	lib$date_time
	external	lib$put_output
	external	sys$fao
	external	sys$gettim

C Type declarations for parameters and PARAMETER statements

	character	zeroed*(*)
	parameter	(zeroed = 'Counters being reset at !%D')

C Type decalarations for variables

	character	line*132
	integer*4	line_len
	integer*4	loop

C+
C Mainline - zero_counters
C-

	call sys$fao (%descr(zeroed)
	1		,%ref(line_len)
	1		,%descr(line)
	1		,%val(0))
	call lib$put_output (line(1:line_len))

	do loop = 0, 1519

		frame_size(loop) = 0

	enddo !loop = 0, 1519

	call lib$date_time (reset_time)
	call sys$gettim (reset_time_q(1))
	call sys$gettim (interrupt_time_q(1))

	elapsed_time_q(1) = -1
	elapsed_time_q(2) = -1

	return
	end

	subroutine enable_controlc

C++
C Functional Description:
C	Setup a control c trap.
C
C Calling Sequence:
C
C	call enable_controlc
C
C Formal Argument(s):
C	None.
C
C Implicit Inputs:
C	None.
C
C Implicit Outputs:
C	None.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'FRAME_COUNTER_INC.INC/nolist'
	include '($IODEF)/nolist'

	external	lib$stop
	external	process_controlc
	integer*4	sys$qiow
	external	sys$qiow

C Type declarations for variables

	integer*4	qio_status

C+
C Mainline - enable_controlc
C-

	qio_status = sys$qiow (,%val(io_channel)
	1			,%val(io$_setmode .or. io$m_ctrlcast),,,
	1			,process_controlc,,,,,)

	if (.not. qio_status) call lib$stop (%val(qio_status))

	return
	end

	subroutine process_controlc

C++
C Functional Description:
C	This is where we end up if a control c is used.
C
C Calling Sequence:
C
C	via an ast...
C
C Formal Argument(s):
C	None.
C
C Implicit Inputs:
C	None.
C
C Implicit Outputs:
C	None.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'FRAME_COUNTER_INC.INC/nolist'
	include '($RMSDEF)/nolist'

	external	enable_controlc
	external	lib$add_times
	external	lib$date_time
	integer*4	lib$get_input
	external	lib$get_input
	external	lib$int_over
	external	lib$put_output
	external	lib$stop
	external	lib$sub_times
	external	str_collapse
	integer*4	str_len
	external	str_len
	external	str_uppercase
	external	sys$asctim
	external	sys$fao
	external	sys$gettim
	external	sys$numtim
	external	sys$setast
	external	zero_counters

C Type declarations for parameters and PARAMETER statements

	character	command_options*(*)
	character	continuing*(*)
	integer*4	disable_
	integer*4	disable_ast
	integer*4	enable_ast
	character	interrupted*(*)
	character	line_format*(*)
	character	trailer*(*)

	parameter	(command_options = '_options are Continue'
	1			//', Zero and continue, Exit [C]: ')
	parameter	(continuing = '!/... continuing at !%D')
	parameter	(disable_ = 0)
	parameter	(disable_ast = 0)
	parameter	(enable_ast = 1)
	parameter	(interrupted = '     last reset at !AS!/'
	1			//'... interrupted at !AS!/!/'
	1			//'Protocol !AS  Address !AS!/'
	1			//'!27<FrameSize     Count!>+!50*-')
	parameter	(line_format = ' !5UL   !10UL !3UL.!1UL%'
	1				//' |!#*'//char('A8'X))
	parameter	(trailer = '!27< Total   !10UL!>+!50*-!/'
	1			//'!27< !UL Packets/second!> Delta time !AS')

C Type declarations for variables

	integer*4	bar_length
	integer*4	delta_time_len
	real*8		elapsed_seconds
	integer*4	elapsed_seconds_l
	character	elapsed_delta_time*23
	character	line*512
	integer*4	line_len
	integer*4	loop
	real*8		percentage
	integer*4	percentage_l
	real*8		tenths
	integer*4	tenths_l
	integer*4	reply_status
	real*8		this_value
	integer*2	time_vector(1)
	real*8		total_count
	integer*4	total_count_l

C+
C Mainline - process_controlc
C-

	call sys$setast (%val(disable_ast))

	call lib$int_over (disable_)

	call sys$gettim (interrupt_time_q(1))
	call lib$sub_times (interrupt_time_q(1), reset_time_q(1)
	1			,run_time_q(1))
	call lib$add_times (run_time_q(1), elapsed_time_q(1)
	1			,elapsed_time_q(1))

	call lib$date_time (interrupt_time)

	call sys$fao (%descr(interrupted)
	1		,%ref(line_len)
	1		,%descr(line)
	1		,%descr(reset_time)
	1		,%descr(interrupt_time)
	1		,%descr(protocol(1:protocol_len))
	1		,%descr(spy_address(1:spy_address_len)))
	call lib$put_output (line(1:line_len))

	total_count = 0.0

	do loop = 0, 1519
		total_count = total_count + frame_size(loop)
	enddo !loop = 0, 1519

	call sys$numtim (time_vector(1), elapsed_time_q(1))

	elapsed_seconds = 1.0*time_vector(6)
	1			+ 60.0*time_vector(5)
	1			+ 60.0*60.0*time_vector(4)
	1			+ 60.0*60.0*24.0*time_vector(3)

	packets_per_second   = total_count/elapsed_seconds
	elapsed_seconds_l    = elapsed_seconds
	total_count_l        = total_count
	packets_per_second_l = packets_per_second

	do loop = 0, 1519
		if (frame_size(loop) .ne. 0) then
			this_value = frame_size(loop)

			if (total_count .eq. 0.0) then
				percentage = 0.0
			else
			percentage = this_value*100.0/total_count
			endif !(total_count .eq. 0.0) then

			percentage_l = percentage

			if (percentage .ge. display_thresh) then
				tenths = (percentage - percentage_l)*10
				tenths_l = tenths
				bar_length = percentage/2

				call sys$fao (%descr(line_format)
	1				,%ref(line_len)
	1				,%descr(line)
	1				,%val(loop)
	1				,%val(frame_size(loop))
	1				,%val(percentage_l)
	1				,%val(tenths_l)
	1				,%val(bar_length))

				call lib$put_output (line(1:line_len))
			endif !(percentage .ge. display_thresh) then
		endif !(frame_size(loop) .ne. 0) then
	enddo !loop = 0, 1519

	call sys$asctim (%ref(delta_time_len), %descr(elapsed_delta_time)
	1			,%ref(elapsed_time_q(1)),)

	call sys$fao (%descr(trailer)
	1		,%ref(line_len)
	1		,%descr(line)
	1		,%val(total_count_l)
	1		,%val(packets_per_second_l)
	1		,%descr(elapsed_delta_time(1:delta_time_len)))
	call lib$put_output (line(1:line_len))

	reply_status = lib$get_input (command, command_options, command_len)
	if (reply_status .eq. rms$_eof) command = 'EXIT'

	call str_collapse (command, command)
	call str_uppercase (command)
	command_len = str_len (command)

	if (command(1:1) .eq. 'E') then
		call lib$stop (%val('10000001'X))
	else
	if (command(1:1) .eq. 'Z') then
		call zero_counters
	else
	call sys$fao (%descr(continuing)
	1		,%ref(line_len)
	1		,%descr(line)
	1		,%val(0))
	call lib$put_output (line(1:line_len))
	endif !(command(1:1) .eq. 'Z') then
	endif !(command(1:1) .eq. 'E') then

	call enable_controlc

	call sys$gettim (reset_time_q(1))

	call sys$setast (%val(enable_ast))

	return
	end
