  	%title	"Right justify a string" 	%ident	"V1-003"  C 	sub str_just_right (string target, string pad_char, string source)    !+ ! Version:	V1-003  !  ! Facility:	Library routines.  ! + ! Abstract:	Right justify and pad a string.  !  ! Environment:	User mode.  ! 
 ! History: ! " !	07-Dec-1988, DBS; Version V1-001 ! 001 -	Original version. " !	29-Dec-1988, DBS; Version V1-002D ! 002 -	Changed the order of the parameters to reflect the standard." !	18-Dec-1995, DBS; Version V1-003( ! 003 -	Converted from FORTRAN to BASIC. !-   !++  ! Functional Description: A !	This routine right justifies a string and left fills the target " !	with the pad character supplied. !  ! Calling Sequence:  ! 0 !	call str_just_right (target, pad_char, source) !  ! Formal Argument(s): + !	target.wt.ds	Somewhere to put the result. @ !	pad_char.rt.ds	The character with which to pad out the string.! !	source.rt.ds	The source string.  !  ! Implicit Inputs: !	None !  ! Implicit Outputs:  !	None !  ! Completion Codes:  !	None !  ! Side Effects:  !	None !--       	option	type = explicit,					  &! 		constant type = integer,				  & $ 		size = (integer long, real double)  $ ! External references (and includes)   	external long function	str_len   ! ! Type declarations for variables    	declare long	filler_len 	declare long	loop 	declare long	source_len 	declare long	target_len   !+
 ! Mainline !-	 mainline:    	source_len = str_len (source) 	target_len = len(target) % 	filler_len = target_len - source_len   ' 	rset target = left(source, source_len)   	 	loop = 1    	while (loop <= filler_len) * 		mid(target, loop, 1) = left(pad_char, 1) 		loop = loop + 1  	next    	end sub