       program  ExtractC 	!                                               Pat Rankin, Oct'88 C 	!                                                  revised, Apr'89 C 	!                       vers 1.3                      "     Jul'89 C 	!                       -DECUS, Anaheim SIG tape-     "     Oct'89 C 	!                       vers 1.4                      "     Dec'89 C 	!                       vers 1.5                      "     Sep'91 C 	!                       vers 1.6                      "     May'97  	!= 	!   Extract (and copy or display) a set of records or blocks : 	!   from the start, middle, or end of a file.  Optionally> 	!   perform various conversions such as tab expansion, column' 	!   range selection, and simple edits.  	!A 	!   Note: Block-mode implementation is incomplete and what there 1 	!       is of it has not been thoroughly tested.  	!# *     version 1.6, 20-MAY-1997 [pr] @ *           Suppress a couple of VARUNUSED compiler diagnostics.2 *       No other changes, just a new full release.# *     --           08-OCT-1991 [pr] G *           Bug fixes for /numbers option.  Buffer manipulation has now ( *       grown to be too complicated. :-(# *     version 1.5, 18-SEP-1991 [pr] H *           Use RMS options that enable us access to files that are openF *       for writing by other process(es), provided they allow sharing.H *       This is less general than a /ignore=(file_lock,record_lock) typeH *       scheme, but doesn't require any additional command handling codeG *       and gives access to batch log files, the most common situation. D *           Add /numbers switch to give numbered output, showing theC *       input record number in the left margin of each output line. K *       Add /index=N to allow scanning an indexed file on an alternate key. # *     --           02-JUL-1991 [pr] D *           Fix argument list manipulation routines used for commandD *       line processing.  Logic for dynamic memory re-allocation wasG *       wrong, resulting in limit of 10 file names or 10 column ranges. # *     --           02-APR-1991 [pr] E *           Bug fix for the case of selecting a column range from M:N I *       where M was greater than 0--if M was also greater than the length G *       of selected record, an RMS "invalid record size" error would be C *       triggered.  Reported by Steve Hirby, HIRBYS@LAWRENCE.bitnet # *     version 1.4, 19-DEC-1989 [pr] F *           Additional code added to handle a stream file which has anG *       unterminated final record (ie, no trailing '\n' for stream_lf). D *       SYS$FIND fails to locate the final record, causing incorrectF *       count and/or initial position.  Although ANALYZE/RMS considersC *       such a file to be in error, it can be handled with SYS$GET.  *  	implicit none C     constant: = 	include '($RMSdef)/nolist'              !rms condition codes E 	include '($SHRdef)/nolist'              !shared message status codes I 	character *(*)  fACILITY                !also in Param_Init, Give_Signal 6 	parameter     ( fACILITY = 'EXTRACT' )  ! who are we?
 C     global:  	include 'Extract.F' C     local:! 	character *128  infile,  outfile # 	integer *2      inf_len,  outf_len  	integer         width; 	logical         show_name,  ldummy,  was_bad,  need_input,       &                  stream$ 	integer *4      rabadr,  sts,  cond C     functions: 	integer *4      Param_Init,&      &                  Get_Next_File,(      &                  Open_Input_File,$      &                  Open_Output,%      &                  Close_Output, $      &                  Process_File  % 	sts = Param_Init( outfile, outf_len)  	if ( .not. sts ) then3 C         report probelm (and subsequently give up) & 	    call Give_Signal( SHR$_PARSEFAIL,?      &                       %DESCR(fACILITY//' command'), sts)  	else !init okP C         get first input file spec and open its file before opening output file 	    need_input = .true.& 	    do while ( sts .and. need_input )2 		sts = Get_Next_File( infile, inf_len, show_name) 		if ( sts )H      &          sts = Open_Input_File( infile(:inf_len), rabadr, stream)A 		if ( .not. sts ) then       !give message, possibly reset 'sts' : 		   call Give_Signal( SHR$_OPENIN, infile(:inf_len), sts) 		    was_bad = .true. 		else 		    need_input = .false. 		end if 	    end do  	    if ( sts ) then& 		call Customize_Output( %VAL(rabadr))/ 		sts = Open_Output( outfile(:outf_len), width)  		if ( .not. sts )H      &          call Give_Signal( SHR$_OPENOUT, outfile(:outf_len), sts) 	    end if  	end if !init ok   C     loop through input files 	do while ( sts ) # C         identify the current file ) 	    if ( show_name .and. .not. was_bad ) 9      &              call Identify_File( infile(:inf_len))  C  C         perform the real work  C  	    if ( .not. was_bad ) then1 		sts = Process_File( %VAL(rabadr), stream, cond) 	 	    else - 		was_bad = .false.       !clear problem flag  	    end if    	    if ( sts ) then" C             open next input file/ 		sts = Get_Next_File( infile, inf_len, ldummy)  		if ( sts )H      &          sts = Open_Input_File( infile(:inf_len), rabadr, stream)/ 		if ( .not. sts .and. sts .ne. RMS$_NMF ) then : 		   call Give_Signal( SHR$_OPENIN, infile(:inf_len), sts) 		    was_bad = .true. 		end if 	    else !.not. sts' C             report processing problem % 		if ( cond .eq. SHR$_WRITEERR ) then 6 		    call Give_Signal( cond, outfile(:outf_len), sts) 		else4 		    call Give_Signal( cond, infile(:inf_len), sts) 		end if 	    end if !sts?  	end do !next file   C     clean up 	if ( sts .eq. RMS$_NMF ) then 	    sts = Close_Output()  	    if ( .not. sts ) 4      &              call Give_Signal( SHR$_CLOSEOUT,=      &                               outfile(:outf_len), sts)  	end if   
 C     done, 	if ( .not. sts )  call SYS$EXIT( %VAL(sts))       end !of Extract(main)         ,       subroutine  Identify_File ( filename ) 	!= 	!   Write out a line identifying the file that's about to be  	!   processed.  [/IDENTIFY] 	!C 	!   Note: the line-feeds won't translate into ebcdic (who cares?).  	! 	implicit none C     constant: 9 	character *1    LF                      !ascii line feed   	parameter     ( LF = CHAR(10) )4 	character *(*)  sEPARATOR_PREFIX,  sEPARATOR_SUFFIX1 	parameter     ( sEPARATOR_PREFIX = LF//'***** ', 9      &                  sEPARATOR_SUFFIX = ' *****'//LF )  C     global input: ' 	include 'Extract.F'             !xlate  C     input: 	character *(*)  filename  C     local: 	character *144  buffer  	integer *2      ln    	call STR$TRIM( buffer, H      &             sEPARATOR_PREFIX // filename // sEPARATOR_SUFFIX, ln)M C         since the header ends up with the output, translate it if necessary B 	if ( xlate .eq. 1 )             !translate from ASCII into EBCDIC?      &          call LIB$TRA_ASC_EBC( buffer(:ln), buffer(:ln))    	call Output( buffer(:ln))   	return        end !of Identify_File         E       integer *4 function  Process_File ( rab, is_stream, condition )  	!* 	!   Process an (already open) input file. 	!A 	!   Note: the input file's fixed-header size (for vfc) is passed A 	!       in the rab's context field.  If there are multiple input @ 	!       files processed, this might have a different value fromB 	!       call to call (so it won't necessarily match output file's6 	!       vfc size if we're preserving the vfc header). 	! 	implicit none C     called by:& *       program         Extract (main) C     constant: : 	include '($RMSdef)/list'                !rms status codesF 	include '($RABdef)/list'                !rms Record Access Block defs> 	include '($SHRdef)/list'                !shared message codes9 	include 'f_inc:Dsc.F'                   !descriptor defs F 	parameter       nUM_PREFIX_SIZE = 12    !also in Insert_Number_Prefix C     global input:  	include 'Extract.F'D 	common /vfc/ vfc_size, vfc_header       !output file's fixed-header/ 	  byte          vfc_size /0/,  vfc_header(255)  C     input: 	record /rabdef/ rabE 	logical         is_stream       !requires special handling for $FIND 
 C     output:  	integer *4      condition C     local: 	record /dsc/    rcrd,  work* 	integer *4      start,  finish,  nxt_rec,/      &                  problem,  sts,  tmpsts,        &                  tmp_long 	integer *2      tmp_word % 	  equivalence ( tmp_long, tmp_word ) 2 	logical         manipulate_record,  stream_kludge 	integer         vfc_offset  	character       record$ *65535  C     functions:< 	integer *4      Rfa_Position,  Direct_Position,  Block_Pos,3      &                  Buffer_File,  Fetch_Record, =      &                  Output,  Block_Output,  Flush_Output, 6      &                  SYS$FIND,  SYS$GET,  SYS$READ,2      &                  SYS$DISCONNECT,  SYS$CLOSE! 	intrinsic       LEN,  MIN,  ZEXT    	condition = 0 	sts = 1 C     set up record buffer(s) H 	rcrd.d_adr = %LOC(record$)      !(useful iff detab or columns [or vfc])L 	rcrd.d_quad(1) = MIN(LEN(record$),'0000FFFF'x)  !(type & class unspecified) 	if ( block_mode ) then 5 	    rcrd.d_quad(1) = rab.rab$l_ctx       !block size ! 	else if ( numbered_output ) then . 	    rcrd.d_adr = rcrd.d_adr + nUM_PREFIX_SIZE6 	    rcrd.d_quad(1) = rcrd.d_quad(1) - nUM_PREFIX_SIZE$ 	    record$(:nUM_PREFIX_SIZE) = ' ' 	end if = 	rab.rab$w_usz = rcrd.d_len              !size of user buffer @ 	rab.rab$l_ubf = rcrd.d_adr              !address of user bufferB 	if ( use_vfc .eq. 2 ) then     !want to keep fixed-header portionM C             note: if 'buffer_required' then header won't exist [don't care] I 	    rab.rab$l_rhb = %LOC(vfc_header)    !address of record header buffer < 	else if ( use_vfc ) then        !treat fixed-header as dataC 	    vfc_offset = rab.rab$l_ctx          !size of fixed-header area " 	    rab.rab$l_rhb = rab.rab$l_ubf/ 	    rab.rab$l_ubf = rab.rab$l_ubf + vfc_offset 0 	    tmp_long = ZEXT(rab.rab$w_usz) - vfc_offset 	    rab.rab$w_usz = tmp_word  	end if @ 	work = rcrd                             !copy string descriptorI 	call LIB$MOVC5( 0, %VAL(0), 0, ZEXT(vfc_size), vfc_header)  !init to 0's   C     flag for record processing; 	manipulate_record = ( detab .or. edit .or. numbered_output D      &                       .or. xlate .ne. 0 .or. col_cnt .gt. 0 )   	stream_kludge = .false.F 	problem = SHR$_READERR  !if we encounter trouble, this will be reason6 C     perform preliminary file processing if necessary 	if ( block_mode ) then E C         position so that $read will get the first block of interest 2 	    sts = Block_Pos( rab, nxt_rec, start, finish)! 	else if ( buffer_required ) then > C         read entire file and hold it in memory (last resort)4 	    sts = Buffer_File( rab, nxt_rec, start, finish) 	else if ( direct_access ) then = C         calculate start and/or finish and position at startc8 	    sts = Direct_Position( rab, nxt_rec, start, finish)6 	else if ( start_val .lt. 0 .or. end_val .lt. 0 ) then* C         read entire file and cache rfa's@ 	    sts = Rfa_Position( rab, nxt_rec, start, finish, is_stream) 	else    !scan sequentiallyeC 	    nxt_rec = 0         !number of next record (need 1 extra find)g 	    start  = start_vals 	    finish = end_val0 	    if ( is_stream ) then 		start = start - 1e 		stream_kludge = .true. 	    end if  	end if    C     process the file 	if ( sts ) then/ C         skip intervening records if necessaryp. 	    do while ( nxt_rec .lt. start .and. sts ). 		if ( SYS$FIND( rab) )  nxt_rec = nxt_rec + 1 		sts = rab.rab$l_stsn 	    end doh( 	    if ( stream_kludge .and. sts ) then9 		start = start + 1               !restore original valuenG C             skip next stream record unless it's the first of the file  		if ( start .gt. 1 ) then 		    sts = SYS$GET( rab)m1 		    if ( sts .eq. RMS$_RTB )  sts = RMS$_NORMAL ' 		    if ( sts )  nxt_rec = nxt_rec + 1g 		else2 		    nxt_rec = 1         !start with first record 		end if 	    end if   % C         extract the desired records-/ 	    do while ( nxt_rec .le. finish .and. sts )i3 		work = rcrd             !reset working descriptore- 		problem = SHR$_READERR  !in case of troublew  # C             get next input recordf 		if ( block_mode ) then 		    sts = SYS$READ( rab)< 		    rab.rab$l_bkt = 0   !subsequent access will sequential" 		else if ( buffer_required ) thenM *-                  if ( detab )  work.d_len = rcrd.d_len       !reset length / 		    sts = Fetch_Record( nxt_rec, work, detab)e 		else: 		    if ( SYS$GET( rab) .eq. RMS$_RTB )  !record too big?M      &                      rab.rab$l_sts = rab.rab$l_sts .or. 3        !****c 		    sts = rab.rab$l_stsm9 		    work.d_len = rab.rab$w_rsz          !size of recordn: 		    work.d_adr = rab.rab$l_rbf          !address of data= 		    if ( use_vfc ) then         !treat fixed-header as datarN C                     fixed-header buffer immediately precedes the data bufferN C                         (because we've set it up that way); concatenate them' 			work.d_adr = work.d_adr - vfc_offset!+ 			tmp_long = ZEXT(work.d_len) + vfc_offseti 			work.d_len = tmp_word 		    end if 		end if !input mode  3 C             process input record and write it outg 		if ( sts ) then  		    if ( manipulate_record )E      &                      call Process_Record( nxt_rec, work, rcrd)r5 		    problem = SHR$_WRITEERR     !in case of troublet 		    if ( block_mode ) then7 			sts = Block_Output( work)       !write out the blockp
 		    else8 			sts = Output( work)     !write out the current record 		    end if9 		    nxt_rec = nxt_rec + 1       !increment record count 
 		end if !stsl 	    end do !while more recordsI0 	    if ( sts .eq. RMS$_EOF )  sts = RMS$_NORMAL  9 C         update the output file (not strictly necessary) ( 	    if ( sts )  problem = SHR$_WRITEERR 	    tmpsts = Flush_Output() 	    if ( sts )  sts = tmpstse 	end if !sts okt   C     close the input file# 	if ( sts )  problem = SHR$_CLOSEIN  	call SYS$DISCONNECT( rab)  	if ( sts )  sts = rab.rab$l_sts) 	tmpsts = SYS$CLOSE( %VAL(rab.rab$l_fab))n 	if ( sts )  sts = tmpstsi  : 	if ( .not. sts )  condition = problem   !auxiliary output4 	if ( sts .eq. RMS$_NORMAL )  sts = 1    !SS$_NORMAL 	Process_File = stsf 	return        end !of Process_File        ;       subroutine  Process_Record ( rec_num, work, record$ )  	!  	!   Process the current record.= 	!   If we're translating from ascii into ebcdic, perform tab)B 	!   expansion and requested edits first; but if we're translating? 	!   from ebcdic into ascii, ignore tab expansion (can't access%: 	!   them) and perform edits *after* the data is in ascii. 	! 	implicit none C     called by:$ *       function        Process_File C     constant:t1 	include 'f_inc:Dsc.F'           !descriptor defsr C     global input:  	include 'Extract.F' C     input: 	integer *4      rec_num C     input/output:t< 	record /dsc/    work            !descriptor for data recordI 	character *(*)  record$         !large string buffer for manipulation(s)a C     local:6 	record /dsc/    temp            !temporary descriptor 	logical         result  C     functions:. 	logical         Expand_Tabs,  Select_Columns,,      &                  Insert_Number_Prefix  $ 	if ( xlate .ne. 0 .or. detab ) thenQ C         build temporary string descriptor; leave type & class unspecified [0,0]) 	    temp.d_adr = %LOC(record$) " 	    temp.d_quad(1) = LEN(record$)) 	    if ( xlate .eq. 2 )  detab = .false.	 	end ifa  C 	if ( detab ) then       !possibly increase length (within record$)s3 	    result = Expand_Tabs( col_cnt, %VAL(col_list), 2      &                           temp, work.d_len)+ 	    if ( result )  work.d_adr = temp.d_adri 	end ife 	if ( col_cnt .eq. 1 ) theni1 	    call Select_Substring( %VAL(col_list), work) B 	else if ( col_cnt .gt. 1 ) then         !possibly decrease length6 	    result = Select_Columns( col_cnt, %VAL(col_list),>      &                              work, record$, work.d_len). 	    if ( result )  work.d_adr = %LOC(record$) 	end if 1 	if ( xlate .eq. 2 .and. work.d_len .gt. 0 ) then  	    temp.d_len = work.d_len& 	    call LIB$TRA_EBC_ASC( work, temp) 	    work.d_adr = temp.d_adr 	end ifb/ 	if ( edit ) then        !might decrease length 1 	    call Edit_Record( work, record$, work.d_len)w 	    work.d_adr = %LOC(record$)  	end ifs 	if ( numbered_output ) then; 	    result = Insert_Number_Prefix( rec_num, work, record$)H 	    if ( result )  temp = workT 	end if,1 	if ( xlate .eq. 1 .and. work.d_len .gt. 0 ) thenI 	    temp.d_len = work.d_len& 	    call LIB$TRA_ASC_EBC( work, temp) 	    work.d_adr = temp.d_adr 	end ife   	return'       end !of Process_Record        ,       subroutine  Customize_Output ( inrab ) 	!C 	!   Set up a callback from Open_Output() to set up special options A 	!   for the output file.  Callback handles RMS output-file-parse)? 	!   option for filling in fields of output name based on firsttA 	!   input file's name and also handles block-mode and vfc-headerC 	!   contortions.  	! 	implicit none C     called by:& *       program         Extract (main) C     constant:rA 	include '($RABdef)/nolist'              !RMS Record Access Blockt  	external        Outfile_Options C     global output:6 	common /output_usropn/ usropn_routine, usropn_context0 	  integer *4    usropn_routine,  usropn_context C     input: 	record /rabdef/ inrab  ' 	usropn_routine = %LOC(Outfile_Options)  	usropn_context = %LOC(inrab)h   	returnr       end !of Customize_Output        ;       subroutine  Outfile_Options ( in_rab, fab, rab, nam )  	!= 	!   Set additional RMS options before Open_Output() $CREATEsl? 	!   the output file.  RMS blocks have already been initialized ' 	!   for standard text file attributes.! 	!A 	!   Note: the input file's fixed-header size (for vfc) is passedAA 	!       in the rab's context field.  If there are multiple inputm? 	!       files, their header sizes may differ; the first one isr4 	!       used to set the outfile file's header size. 	! 	implicit none C     called by:# *       function        Open_Outputo C     constant:  	include '($FABdef)/nolist'' 	include '($RABdef)/nolist'  	include '($NAMdef)/nolist'2 C     global input:r 	include 'Extract.F' C     global output:" 	common /vfc/ vfc_size, vfc_header+ 	  byte          vfc_size,  vfc_header(255)c C     input:8 	record /rabdef/ in_rab          !rab of open input file C     input/output:e5 	record /fabdef/ fab             !fab for output file 3 	record /rabdef/ rab             !rab  "    "     "w5 	record /namdef/ nam             !nam for output file  C     local: 	integer         offsete" 	integer *4      fabadr,  tmp_long 	integer *2      tmp_word  	byte            tmp_byter/ 	  equivalence ( tmp_long, tmp_word, tmp_byte )o C     functions: 	byte            Buf_BPeek 	integer *4      Buf_LPeek  E 	fabadr = in_rab.rab$l_fab           !get address of input file's fabYO C     additional filename options (use input file's name fields in output name) G 	fab.fab$l_fop = fab.fab$l_fop .or. FAB$M_OFP        !output file parse C 	offset = %LOC(fab.fab$l_nam) - %LOC(fab)                !FAB$L_NAMeG 	nam.nam$l_rlf = Buf_LPeek( %VAL(fabadr + offset))   !input's nam block    	if ( block_mode ) then)* C         block mode is fairly restrictiveC 	    fab.fab$b_fac = fab.fab$b_fac .or. FAB$M_BIO    !use block i/otH 	    fab.fab$b_shr = fab.fab$b_shr .or. FAB$M_UPI    !(ignore interlock) 	    if ( lrecl .eq. 0 ) thenI 		fab.fab$b_rfm = FAB$C_UDFSA 		tmp_long = in_rab.rab$l_ctx     !context field contains rec lene( 	    else        !retain original format< 		offset = %LOC(fab.fab$b_rfm) - %LOC(fab)        !FAB$B_RFM= 		fab.fab$b_rfm = Buf_BPeek( %VAL(fabadr + offset))   !formato< 		offset = %LOC(fab.fab$b_rat) - %LOC(fab)        !FAB$B_RATA 		fab.fab$b_rat = Buf_BPeek( %VAL(fabadr + offset))   !attributesr 		tmp_long = lrecl 	    end ife 	    fab.fab$w_mrs = tmp_word H 	    use_vfc = 0         !force this to guarantee freedom from conflicts  	else if ( use_vfc .ne. 0 ) thenL C         need to retreive vfc info from input file (which is already open);@ C             first get fixed-header-size from RAB context field  	    tmp_long = in_rab.rab$l_ctx 	    vfc_size = tmp_byte5 	    if ( use_vfc .eq. 2 .and. vfc_size .ne. 0 ) then N C             want to retain vfc format [the first input file is already open]2 		fab.fab$b_fsz = vfc_size        !set header size7 		fab.fab$b_rfm = FAB$C_VFC       !file format is "vfc"0< 		offset = %LOC(fab.fab$b_rat) - %LOC(fab)        !FAB$B_RATA 		fab.fab$b_rat = Buf_BPeek( %VAL(fabadr + offset))   !attributes - C             set up buffer for record header)" 		rab.rab$l_rhb = %LOC(vfc_header) 	    end if  	end if    	returnt       end !of Outfile_Optionsa