C	include file for LATWATCH

C	[Note: still needs to be cleaned up]

C External references

C Type declarations for parameters and PARAMETER statements

	integer*4	addr_len
	integer*4	e_adr_size
	integer*4	e_max_packet_size
	integer*4	e_max_str
	integer*4	e_num_params
	integer*4	e_num_rcv_buffers
	integer*4	e_protocol_c
	integer*4	e_pty_size
	integer*4	find_addr
	integer*4	find_name
	integer*4	max_message_type
	integer*4	max_nodeaddr
	integer*4	name_len
	character	nodefile*(*)
	integer*4	prot_len
	character	protocol_c_lat*(*)
	character	protocol_t_lat*(*)
	character	unknown_node*(*)
	integer*4	unknown_node_len

	parameter	(addr_len = 17)
	parameter	(e_adr_size = 6)
	parameter	(e_max_packet_size = 1500)
	parameter	(e_max_str = 100)
	parameter	(e_num_params = 5)
	parameter	(e_num_rcv_buffers = 12)
	parameter	(e_protocol_c = '0660'X)
	parameter	(e_pty_size = 2)
	parameter	(find_name = 1)
	parameter	(find_addr = 2)
	parameter	(max_message_type = 63)
	parameter	(max_nodeaddr = 2048)
	parameter	(name_len = 32)
	parameter	(nodefile = 'ETHERWATCHER:NODELIST.DAT')
	parameter	(prot_len = 5)
	parameter	(protocol_c_lat = '60-04')
	parameter	(protocol_t_lat = 'LAT')
	parameter	(unknown_node = 'UNKNOWN')
	parameter	(unknown_node_len = 7)

	integer*4	eth_s_address
	integer*4	eth_s_header
	integer*4	eth_c_length
	integer*4	eth_s_protocol
	integer*4	slh_c_length
	integer*4	slot_c_length
	integer*4	vch_c_length
	parameter	(eth_s_address = 6)
	parameter	(eth_s_header = 20)
	parameter	(eth_c_length = 1500)
	parameter	(eth_s_protocol = 2)
	parameter	(slh_c_length = 4)
	parameter	(slot_c_length = 1492)
	parameter	(vch_c_length = 8)

C Structures

	include 'DBSLIB:STRUCTURES.INC'

	structure /node_record/
		character	addr*(addr_len)
		integer*4	addrlen
		character	name*(name_len)
		integer*4	namelen
	end structure !node_record
	volatile /node_record/

	structure /eth_params/
		integer*2	param_id
		integer*4	param_value
	end structure !eth_params
	volatile /eth_params/

	structure /eth_param_desc/
		integer*4	length
		integer*4	parameters
	end structure !eth_param_desc
	volatile /eth_param_desc/

	structure /eth_addrdef/
	  union
	    map
		byte	header(eth_s_header)
	    end map
	    map
		byte	dst(eth_s_address)
		byte	src(eth_s_address)
		byte	prtcl(eth_s_protocol)
	    end map
	  end union
	end structure !eth_addrdef
	volatile /eth_addrdef/

	structure /lat_def/
	  union
	    map
		character	latdata*(eth_c_length)
	    end map
	    map		! for virtual circuit header
		byte		msg_type
		byte		nbr_slots
		integer*2	dst_cir_id
		integer*2	src_cir_id
		byte		msg_seq_nbr
		byte		msg_ack_nbr
		character	msg_data*(eth_c_length-vch_c_length)
	    end map
	    map		! for command messages			(12)
		byte		%fill
		byte		prtcl_format
		byte		high_prtcl_ver
		byte		low_prtcl_ver
		byte		cur_prtcl_ver
		byte		cur_prtcl_eco
		integer*2	data_link_rcv_frame_size
		integer*2	request_identifier
		integer*2	entry_identifier
		byte		command_type
		byte		command_modifier
	    end map
	  end union
	end structure !lat_def
	volatile /lat_def/

	structure /slot_def/
	  union
	    map
		character	slots*(slot_c_length)
	    end map
	    map
		byte		dst_slot_id
		byte		src_slot_id
		union
		  map
			byte	slot_byte_count
		  end map
		  map
			byte	status_byte_count
		  end map
		end union
		byte		credits_slot_type
		character	slot_data*(slot_c_length-slh_c_length)
	    end map
	  end union
	end structure !slot_def
	volatile /slot_def/

	structure /eth_def/
		record /eth_addrdef/	ethdr
		character		etdata*(eth_c_length)
	end structure !eth_def
	volatile /eth_def/

	record /eth_def/	packet
	record /lat_def/	latpckt
	record /slot_def/	slot

	byte		credits
	byte		reason
	byte		slot_type
	byte		master
	byte		rrf
	byte		message_type
	byte		service_class
	byte		minimum_attention_slot_size
	byte		minimum_data_slot_size

C Type declarations for variables

	integer*4	hex_segment_size		/20/
	integer*4	text_segment_size		/64/

	integer*4	buffer_length
	character	command*256
	integer*4	command_len
	integer*4	cli_from
	integer*4	cli_to
	integer*4	cli_both
	integer*4	cli_message
	integer*4	from_unknown
	integer*4	to_unknown
	character	src_address*(addr_len)
	integer*4	src_address_len
	character	src_node*(name_len)
	integer*4	src_node_len
	character	dest_address*(addr_len)
	integer*4	dest_address_len
	character	dest_node*(name_len)
	integer*4	dest_node_len
	character	default_device*10
	integer*4	default_device_len
	character	device*10
	integer*4	device_len
	character	sel_message_t*32
	integer*4	sel_message_len
	integer*4	selected_message
	character	protocol*5
	integer*4	protocol_len
	integer*4	tt_channel

	integer*4	status

	integer*2	log_channel
	character	prot_str*10
	integer*4	node_count

	record /eth_param_desc/		param_desc
	record /eth_params/		param_buffer(e_num_params)
	record /io_status_block/	iosb
	record /node_record/		node(max_nodeaddr)

	character	messagetext(17)*16
	1		/'Run Message',		'Start Message'
	1		,'Stop Message',	'Message Type 3'
	1		,'Message Type 4',	'Message Type 5'
	1		,'Message Type 6',	'Message Type 7'
	1		,'Message Type 8',	'Message Type 9'
	1		,'Service Info',	'Message Type 11'
	1		,'Command Message',	'Status Message'
	1		,'Solicit Info',	'Response Info'
	1		,'Unknown Message'/
	character	slottext(16)*10
	1		/'DataASlot',	'SlotType_1'
	1		,'SlotType_2',	'SlotType_3'
	1		,'SlotType_4',	'SlotType_5'
	1		,'SlotType_6',	'SlotType_7'
	1		,'SlotType_8',	'SlotStart'
	1		,'DataBSlot',	'AttnSlot'
	1		,'SlotReject',	'SlotStop'
	1		,'SlotType_14',	'SlotType_15'/
	character	stop_reason(12)*32
	1		/'Reason is unknown',
	1		 'No slots connected on VC',
	1		 'Illegal message or slot received',
	1		 'User requested disconnect',
	1		 'No progress is being made',
	1		 'Time limit expired',
	1		 'LAT message retry limit reached',
	1		 'Insufficient resources',
	1		 'Server circ timer out of range',
	1		 'Number of VCs is exceeded',
	1		 'Incompatible protocol version',
	1		 '**Reason outside known range**'/
	character	who(2)*6	/'Slave', 'Master'/
	character	answer(2)*17	/'No Response Reqd'
	1				,'Response Required'/

C Commons (and includes)

	common /latwatch_data/
	1		command
	1		,command_len
	1		,cli_from
	1		,cli_to
	1		,cli_both
	1		,cli_message
	1		,from_unknown
	1		,to_unknown
	1		,src_address
	1		,src_address_len
	1		,src_node
	1		,src_node_len
	1		,dest_address
	1		,dest_address_len
	1		,dest_node
	1		,dest_node_len
	1		,default_device
	1		,default_device_len
	1		,device
	1		,device_len
	1		,sel_message_t
	1		,sel_message_len
	1		,selected_message
	1		,protocol
	1		,protocol_len
	1		,prot_str
	1		,tt_channel
	1		,log_channel
	1		,iosb
	1		,status
	1		,param_desc
	1		,param_buffer
	1		,node_count
	1		,node
	1		,hex_segment_size
	1		,text_segment_size
	1		,messagetext
	1		,slottext
	1		,credits
	1		,reason
	1		,slot_type
	1		,buffer_length
	1		,master
	1		,rrf
	1		,message_type
	1		,service_class
	1		,minimum_attention_slot_size
	1		,minimum_data_slot_size
	1		,packet
	1		,latpckt
	1		,slot
	1		,who
	1		,answer

C Data statements
