	program	latwatch

C+
C Version:	X4-004
C
C Facility:	Diagnostic Utilities.
C
C Abstract:	This is similar to ETHERWATCH but will only process LAT
C		protocol messages.
C
C Environment:	PHY_IO and LOG_IO privileges are needed.
C
C	The following is the CLD used in LATWATCH:
C
C module latwatch_cld
C
C define verb latwatch
C	noparameters
C	qualifier from,		default, value (default = "*")
C	qualifier to,		default, value (default = "*")
C	qualifier both_ways
C	qualifier message_type,	default, value (default = 63, type = $number)
C	qualifier device,	value (required)
C
C History:
C
C	02-Apr-1990, DBS; Version X1-001
C 001 -	Original version.  Based on ETHUTIL by Mark Myers of the University
C	of Melbourne.
C	02-Apr-1990, DBS; Version X1-002
C 002 -	Added code to handle /both, /from and /to.
C	03-Apr-1990, DBS; Version X1-003
C 003 -	Added code for the /unkown qualifier and changed the code that matches
C	the addresses to nodenames.
C	09-Apr-1990, DBS; Version X1-004
C 004 -	Fix to pick up the value returned in the iosb when starting up the
C	device.
C	11-Apr-1990, DBS; Version X1-005
C 005 -	Use for_signal/stop to handle errors.
C	23-May-1990, DBS; Version X1-006
C 006 -	Added code to unpack LAT messages.
C	05-Jun-1990, DBS; Version X1-007
C 007 -	Modified to always do the LAT format on LAT messages.
C	06-Jun-1990, DBS; Version X1-008
C 008 -	Added more specific lat packet processing.
C
C	07-Jun-1990, DBS; Version X2-001
C 001 -	Major rehash for lat processing.
C	Became LATWATCH about this time...
C	15-Jun-1990, DBS; Version X2-002
C 002 -	Changed the format of the ascii/hex displays.
C	15-Jun-1990, DBS; Version X2-003
C 003 -	Cleanup time...
C
C	27-Jun-1990, DBS; Version X3-001
C 001 -	Added wildcard matching on addresses and protocols.
C	09-Jul-1990, DBS; Version X3-002
C 002 -	Added a control C trap so we can exit cleanly.
C	20-Nov-1991, DBS; Version X3-003
C 003 -	Added call to sys_find_ether_device to establish default.
C	17-Jan-1992, DBS; Version X3-004
C 004 -	Added software expiry check.
C
C	08-Jan-1993, DBS; Version X4-001
C 001 -	Major rehash to change the qualifiers so source and destination
C	addresses can be specified.
C	08-Oct-1993, DBS; Version X4-002
C 002 -	Added reason descriptions for stop messages.
C	11-Oct-1993, DBS; Version X4-003
C 003 -	Fixed bug with header size and first six bytes of packet data being
C	overwritten.
C	11-Oct-1993, DBS; Version X4-004
C 004 -	Added /message_type qualifier.
C-

 	implicit none

	character	program_id*(*)
	parameter	(program_id = 'LATWATCH  X4-004')

C External references

	include 'LATWATCH_INC.INC/nolist'

	external	enable_controlc
	external	lib$put_output
	external	lib$stop
	external	parse_command
	external	read_nodelist
	external	startup_device
	integer*4	sys$assign
	external	sys$assign
	external	sys$hiber
	external	sys_check_software_expiry1

C Type declarations for variables

	integer*4	expiry_date		/-1/
	integer*4	check_date		/0/
	integer*4	assign_status

C+
C Mainline - latwatch
C-

	call lib$put_output (program_id)

C	call sys_check_software_expiry1 (expiry_date, check_date)

	call read_nodelist

	call parse_command

	assign_status = sys$assign ('TT', tt_channel,,)
	if (.not. assign_status) call lib$stop (%val(assign_status))

	call enable_controlc

	call startup_device

	call sys$hiber

	end

	subroutine convert_header (formatted_destination
	1				,formatted_source
	1				,formatted_protocol)

C++
C Functional Description:
C	This routine will take the ethernet addresses an protocols from
C	common area and format them into readable ascii text.
C
C Calling Sequence:
C
C	call convert_header (...)
C
C Formal Argument(s):
C	formatted_destination.wt.ds	Somewhere to store the destination.
C	formatted_source.wt.ds		Somewhere to store the source.
C	formatted_protocol.wt.ds	Somewhere to store the protocol.
C
C Implicit Inputs:
C	latwatch_data common area.
C
C Implicit Outputs:
C	None
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'LATWATCH_INC.INC/nolist'

	external	sys$fao

C Type declarations for parameters and PARAMETER statements

	character	address_format*(*)
	character	protocol_format*(*)

	parameter	(address_format = '!XB-!XB-!XB-!XB-!XB-!XB')
	parameter	(protocol_format = '!XB-!XB')

C Type declarations for variables

	character	formatted_destination*(*)
	character	formatted_source*(*)
	character	formatted_protocol*(*)

	integer*2	fao_len
	character	full_format*40

C+
C Mainline - convert_header
C-

	call sys$fao (%descr(address_format//address_format//protocol_format)
	1		,%ref(fao_len)
	1		,%descr(full_format)
	1		,%val(packet.ethdr.dst(1))
	1		,%val(packet.ethdr.dst(2))
	1		,%val(packet.ethdr.dst(3))
	1		,%val(packet.ethdr.dst(4))
	1		,%val(packet.ethdr.dst(5))
	1		,%val(packet.ethdr.dst(6))
	1		,%val(packet.ethdr.src(1))
	1		,%val(packet.ethdr.src(2))
	1		,%val(packet.ethdr.src(3))
	1		,%val(packet.ethdr.src(4))
	1		,%val(packet.ethdr.src(5))
	1		,%val(packet.ethdr.src(6))
	1		,%val(packet.ethdr.prtcl(1))
	1		,%val(packet.ethdr.prtcl(2)))

	formatted_destination	= full_format(01:17)
	formatted_source	= full_format(18:34)
	formatted_protocol	= full_format(35:39)

	return
	end

 	logical function lookupnode*4 (flag
	1				,nodeaddr
	1				,nodename
	1				,nodenamelen)

C++
C Functional Description:
C	This routine will scan the internal list of nodename and addresses
C	looking for a match on the values passed.  The choice of whether to
C	look for a name or address is determined by the flag.
C
C Calling Sequence:
C
C	node_found = lookupnode (...)
C
C Formal Argument(s):
C	flag.rl.r	Determines whether a search is made of the names or
C			addresses list.
C	nodeaddr.mt.ds	Either the address to look for or the address that
C			matches the specified name.
C	nodename.mt.ds	Either the name to look for or the name that matches
C			the specified address.
C	nodenamelen.ml.r  The length of the name returned.
C
C Implicit Inputs:
C	latwatch_data common area.
C
C Implicit Outputs:
C	None
C
C Completion Codes:
C	.true. or .false. depending on whether a match was made.
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'LATWATCH_INC.INC/nolist'

C Type declarations for variables

	integer*4	flag
	character	nodeaddr*(*)
	character	nodename*(*)
	integer*4	nodenamelen

	logical*4	found_it
	integer*4	item

C+
C Mainline - lookupnode
C-

	found_it = .false.
	lookupnode = .false.

	if (flag .eq. find_name) then
		item = 1

		do while ((item .le. node_count) .and. (.not. found_it))
			if (node(item).addr(1:node(item).addrlen)
	1				.eq. nodeaddr(1:node(item).addrlen))
	1			then
				nodename = node(item).name
				nodenamelen = node(item).namelen
				found_it = .true.
				lookupnode = .true.
			endif !(node(item).addr .eq. nodeaddr) then
			item = item + 1
		enddo !while ((item .le. node_count) .or. (.not. found_it))

		if (.not. found_it) then
			nodename = unknown_node
			nodenamelen = 7
		endif !(.not. found_it) then
	else
	item = 1

	do while ((item .le. node_count) .and. (.not. found_it))
		if (node(item).name(1:node(item).namelen)
	1			.eq. nodename(1:node(item).namelen)) then
			nodeaddr = node(item).addr
			nodenamelen = node(item).namelen
			found_it = .true.
			lookupnode = .true.
		endif !(node(item).name .eq. nodename) then
		item = item + 1
	enddo !while ((item .le. node_count) .or. (.not. found_it))
	endif !(flag .eq. find_name) then

	return
	end

	subroutine parse_command

C++
C Functional Description:
C	This routine parses the users command.
C
C Calling Sequence:
C
C	call parse_command
C
C Formal Argument(s):
C	None
C
C Implicit Inputs:
C	ether_watch_data common area.
C
C Implicit Outputs:
C	ether_watch_data common area.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'LATWATCH_INC.INC/nolist'
	include '($CLIDEF)/nolist'

	integer*4	cli$dcl_parse
	external	cli$dcl_parse
	integer*4	cli$get_value
	external	cli$get_value
	integer*4	cli$present
	external	cli$present
	external	cli$_present
	external	cli$_negated
	external	cli$_locpres
	external	cli$_defaulted
	external	cli$_locneg
	external	cli$_absent
	external	latwatch_cld
	external	lib$get_input
	logical*4	lookupnode
	external	lookupnode
	integer*4	str_len
	external	str_len
	external	str_uppercase
	external	sys_find_ether_device
	external	sys$exit

C Type declarations for parameters and PARAMETER statements

	character	cli_t_command*(*)
	parameter	(cli_t_command = 'LATWATCH')

C Type declarations for variables

	integer*4	slash_loc
	integer*4	space_loc
	character	from_where*(name_len)
	integer		from_where_len
	character	to_where*(name_len)
	integer		to_where_len

C+
C Mainline - parse_command
C-

	call sys_find_ether_device (default_device)
	default_device_len = str_len (default_device)

	device		= default_device
	src_node	= '*'
	src_address	= '*'
	dest_node	= '*'
	dest_address	= '*'
	from_where	= '*'
	to_where	= '*'
	from_unknown	= .false.
	to_unknown	= .false.
	protocol	= protocol_c_lat

	call cli$get_value ('$LINE', command, command_len)

	space_loc = index(command(1:command_len), ' ')
	slash_loc = index(command(1:command_len), '/')

	if ((space_loc .eq. 0) .and. (slash_loc .eq. 0)) then
		command = cli_t_command
	else
	if ((space_loc .lt. slash_loc) .and. (space_loc .gt. 0)) then
		command = cli_t_command//command(space_loc:)
	else
	if (slash_loc .gt. 0) command = cli_t_command//command(slash_loc:)
	endif !(space_loc .lt. slash_loc) then
	endif !((space_loc .eq. 0) .and. (slash_loc .eq. 0)) then

	command_len = str_len (command)

	status = cli$dcl_parse (command(1:command_len)
	1			,latwatch_cld
	1			,lib$get_input
	1			,lib$get_input
	1			,'_LatWatch: ')

	if (.not. status) call sys$exit (%val('10000000'X .or. status))

	cli_from    = cli$present ('FROM')
	cli_to      = cli$present ('TO')
	cli_both    = cli$present ('BOTH_WAYS')
	cli_message = cli$present ('MESSAGE_TYPE')

	if ((cli_message .eq. %loc(cli$_present))
	1		.or. (cli_message .eq. %loc(cli$_defaulted))) then
		call cli$get_value ('MESSAGE_TYPE', sel_message_t
	1				,sel_message_len)
		call lib_cvt_t_l (sel_message_t(1:sel_message_len)
	1				,selected_message)
		if ((selected_message .lt. 0)
	1		.or. (selected_message .gt. max_message_type))
	1		selected_message = max_message_type
	endif !((cli_message .eq. %loc(cli$_present))

	if ((cli_from .eq. %loc(cli$_present))
	1		.or. (cli_from .eq. %loc(cli$_defaulted))) then
		call cli$get_value ('FROM', from_where, from_where_len)
		src_address = from_where
		src_node = from_where
		src_node_len = from_where_len
		if (.not. lookupnode(find_addr, src_address
	1			,src_node, src_node_len)) then
			if (from_where .eq. unknown_node) then
				src_address = '*'
				from_unknown = .true.
			else
			src_address = from_where
			endif
		endif
	endif !((cli_from .eq. %loc(cli$_present))

	if ((cli_to .eq. %loc(cli$_present))
	1		.or. (cli_to .eq. %loc(cli$_defaulted))) then
		call cli$get_value ('TO', to_where, to_where_len)
		dest_address = to_where
		dest_node = to_where
		dest_node_len = to_where_len
		if (.not. lookupnode(find_addr, dest_address
	1			,dest_node, dest_node_len)) then
			if (to_where .eq. unknown_node) then
				dest_address = '*'
				to_unknown = .true.
			else
			dest_address = to_where
			endif
		endif
	endif !((cli_to .eq. %loc(cli$_present))

	status = cli$present ('DEVICE')
	if ((status .eq. %loc(cli$_present))
	1		.or. (status .eq. %loc(cli$_defaulted)))
	1	call cli$get_value ('DEVICE', device, device_len)

	call str_uppercase (src_address)
	call str_uppercase (dest_address)
	device_len	= str_len (device)
	src_address_len	= str_len (src_address)
	src_node_len	= str_len (src_node)
	dest_address_len= str_len (dest_address)
	dest_node_len	= str_len (dest_node)

	if (src_address_len .lt. addr_len) then
		if ((index(src_address, '*') .eq. 0) .and.
	1			(index(src_address, '%') .eq. 0)) then
			src_address = src_address(1:src_address_len)//'*'
			src_address_len = src_address_len + 1
		endif !(index(src_address, '*') .eq. 0) .and.
	endif !(src_address_len .lt. addr_len) then

	if (dest_address_len .lt. addr_len) then
		if ((index(dest_address, '*') .eq. 0) .and.
	1			(index(dest_address, '%') .eq. 0)) then
			dest_address = dest_address(1:dest_address_len)//'*'
			dest_address_len = dest_address_len + 1
		endif !(index(dest_address, '*') .eq. 0) .and.
	endif !(dest_address_len .lt. addr_len) then

	return
	end

	subroutine process_packet

C++
C Functional Description:
C	This routine waits for LAT packets then checks the addresses against
C	the addresses we are monitoring to see if we want to look at what we
C	just got.
C
C Calling Sequence:
C
C	call process_packet
C
C Formal Argument(s):
C	None
C
C Implicit Inputs:
C	latwatch_data common area.
C
C Implicit Outputs:
C	Display information is directed to sys$output.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'LATWATCH_INC.INC/nolist'

	external	convert_header
	external	lib$put_output
	logical*4	lookupnode
	external	lookupnode
	external	queue_async_read
	integer*4	str_match
	external	str_match
	external	sys$fao

C Type declarations for parameters and PARAMETER statements

	character	header_format*(*)
	parameter	(header_format = '!72*-'
	1				//'!/From !AS [!AS] to !AS [!AS]'
	1				//'!/!4UL byte buffer at !%D')

C Type declarations for variables

	character	dest_adr*(addr_len)
	logical*4	dest_known
	character	dest_name*(name_len)
	integer*4	dest_namelen
	character	line*256
	integer*4	line_len
	character	pkt_prot*(prot_len)
	character	source_adr*(addr_len)
	logical*4	source_known
	character	source_name*(name_len)
	integer*4	source_namelen

C+
C Mainline - process_packet
C-

	call convert_header (dest_adr, source_adr, pkt_prot)

	if (pkt_prot .eq. protocol) then
		if ((str_match(source_adr, src_address(1:src_address_len))
	1	  .and. str_match(dest_adr, dest_address(1:dest_address_len)))
	1	  .or. (cli_both .and.
	1	  str_match(source_adr, dest_address(1:dest_address_len))
	1	  .and. str_match(dest_adr, src_address(1:src_address_len)))
	1	  .or. ((src_address .eq. dest_address) .and.
	1	  (str_match(source_adr, src_address(1:src_address_len))
	1	 .or. str_match(dest_adr, dest_address(1:dest_address_len)))))
	1		then
			source_known = lookupnode (find_name, source_adr
	1					,source_name, source_namelen)
			dest_known = lookupnode (find_name, dest_adr
	1					,dest_name, dest_namelen)

			if ((from_unknown .and. .not. source_known) .or.
	1			(to_unknown .and. .not. dest_known) .or.
	1			(.not. (from_unknown .or. to_unknown))) then
				buffer_length = iosb.count

				call sys$fao (%descr(header_format)
	1				,%ref(line_len)
	1				,%descr(line)
	1				,%descr(source_adr)
	1				,%descr(source_name(1:source_namelen))
	1				,%descr(dest_adr)
	1				,%descr(dest_name(1:dest_namelen))
	1				,%val(buffer_length)
	1				,%val(0))

				call process_lat_packet (line(1:line_len))
			endif
		endif
	endif

	packet.etdata = ' '
	buffer_length = 0

	call queue_async_read

	return
	end

	subroutine process_lat_packet (display_header)

C++
C Functional Description:
C	We have a LAT packet, here we try to pick it to bits and display
C	the contents in some sort of readable format.
C
C Calling Sequence:
C
C	call process_lat_packet
C
C Formal Argument(s):
C	None
C
C Implicit Inputs:
C	latwatch_data common area.
C
C Implicit Outputs:
C	latwatch_data common area.
C	Display information is directed to sys$output.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'LATWATCH_INC.INC/nolist'

	external	lib_output_seg_tzb
	external	lib$put_output
	external	sys$fao

C Type declarations for parameters and PARAMETER statements

	character	slot_format*(*)
	character	start_format*(*)
	character	stop_format*(*)
	character	unk_format*(*)
	character	vch_format*(*)

	parameter	(slot_format = '!/Slot !UB, !AS (!UB)'
	1				//', Dest !UB, Source !UB'
	1				//', !UB Byte!%S, !UB Credit!%S')
	parameter	(start_format = '!/Service Class !UB'
	1				//', Min Attn Size !UB'
	1				//', Min Data Size !UB')
	parameter	(stop_format = '!/Circuit disconnect !UB !AS!/'
	1				//'  <!AS>')
	parameter	(unk_format = '!/!16AS (!UB)')
	parameter	(vch_format = '!/!16AS  Dest !XW, Source !XW'
	1				//', !UB slot!%S, Seq/Ack !UB/!UB'
	1				//'!/!AS ,!AS')

C Type declarations for variables

	character	display_header*(*)

	integer*2	counter
	integer*2	data_size
	integer*4	display_reason
	byte		last_slot
	integer*4	l_buffer_size
	character	line*256
	integer*4	line_len
	integer*2	obj_offset
	integer*2	obj_srvc_len
	integer*4	offset
	logical*4	packet_matched
	integer*2	subj_offset
	integer*2	subj_dscr_len

C+
C Mainline - process_lat_packet
C-

	latpckt.latdata = packet.etdata
	rrf		= (latpckt.msg_type .and. 1)
	master		= (latpckt.msg_type .and. 2)/2
	latpckt.msg_type = ((latpckt.msg_type/4) .and. 63)
	message_type = latpckt.msg_type
	if ((message_type .lt. 0) .or. (message_type .gt. 15))
	1		message_type = 16
	packet_matched = ((selected_message .eq. max_message_type)
	1			.or. (selected_message .eq. message_type))

	if (packet_matched) then
	  call lib$put_output (display_header)

	  if ((message_type .lt. 0) .or. (message_type .gt. 2)) then
		call sys$fao (%descr(unk_format)
	1			,%ref(line_len)
	1			,%descr(line)
	1			,%descr(messagetext(message_type+1))
	1			,%val(latpckt.msg_type))
		call lib$put_output (line(1:line_len))
		call lib_output_seg_tzb (packet.etdata, buffer_length, 16)
	  else
	  call sys$fao (%descr(vch_format)
	1		,%ref(line_len)
	1		,%descr(line)
	1		,%descr(messagetext(message_type+1))
	1		,%val(latpckt.dst_cir_id)
	1		,%val(latpckt.src_cir_id)
	1		,%val(latpckt.nbr_slots)
	1		,%val(latpckt.msg_seq_nbr)
	1		,%val(latpckt.msg_ack_nbr)
	1		,%descr(who(master+1))
	1		,%descr(answer(rrf+1)))
	  call lib$put_output (line(1:line_len))

	  if (message_type .eq. 1) then		! start message
		call lib_output_seg_tzb (latpckt.msg_data, buffer_length, 16)
	  else
	  if (message_type .eq. 2) then		! stop message
		reason    = ichar(latpckt.msg_data(1:1))
		data_size = ichar(latpckt.msg_data(2:2))
		display_reason = reason
		if ((display_reason .lt. 0) .or. (display_reason .gt. 10))
	1		display_reason = 11
		display_reason = display_reason + 1
		call sys$fao (%descr(stop_format)
	1			,%ref(line_len)
	1			,%descr(line)
	1			,%val(reason)
	1			,%descr(stop_reason(display_reason))
	1			,%descr(latpckt.msg_data(3:3+data_size)))
		call lib$put_output (line(1:line_len))
	  else					! run message
	  offset = 1
	  last_slot = (latpckt.nbr_slots .and. 255)

	  do counter = 1, last_slot
		slot.slots    = latpckt.msg_data(offset:)
		credits       = (slot.credits_slot_type .and. 15)
		slot_type     = (slot.credits_slot_type/16 .and. 15)
		l_buffer_size = (slot.slot_byte_count .and. 255)
		call sys$fao (%descr(slot_format)
	1			,%ref(line_len)
	1			,%descr(line)
	1			,%val(counter)
	1			,%descr(slottext(slot_type+1))
	1			,%val(slot_type)
	1			,%val(slot.dst_slot_id)
	1			,%val(slot.src_slot_id)
	1			,%val(slot.slot_byte_count)
	1			,%val(credits))
		call lib$put_output (line(1:line_len))
		if (slot_type .eq. 9) then	! start slot
			service_class = ichar(slot.slot_data(5:5))
			minimum_attention_slot_size
	1			= ichar(slot.slot_data(6:6))
			minimum_data_slot_size = ichar(slot.slot_data(7:7))
			call sys$fao (%descr(start_format)
	1				,%ref(line_len)
	1				,%descr(line)
	1				,%val(service_class)
	1				,%val(minimum_attention_slot_size)
	1				,%val(minimum_data_slot_size))
			call lib$put_output (line(1:line_len))
			obj_offset = 1
			obj_srvc_len = ichar(slot.slot_data(obj_offset:))
			obj_offset = obj_offset + 1
			call lib$put_output 
	1			('Object Service <'
	1			//slot.slot_data
	1			    (obj_offset:obj_offset+obj_srvc_len)
	1			//'>')
			subj_offset = obj_offset + obj_srvc_len
			subj_dscr_len = ichar(slot.slot_data(subj_offset:))
			subj_offset = subj_offset + 1
			call lib$put_output
	1			('Subject Description <'
	1			//slot.slot_data
	1			    (subj_offset:subj_offset+subj_dscr_len)
	1			//'>')
		else
		if (l_buffer_size .gt. 0) then
			call lib_output_seg_tzb (slot.slot_data
	1					,l_buffer_size, 16)
		endif !(l_buffer_size .gt. 0)
		endif !(slot_type .eq. 9) then
		offset = offset + slh_c_length + l_buffer_size
	1			+ (l_buffer_size .and. 1)
	  end do !counter = 1, last_slot
	  endif !(message_type .eq. 2) then
	  endif !(message_type .eq. 1) then
	  endif !(message_type .lt. 0) .or. (message_type .gt. 2)) then
	endif !(packet_matched) then

	return
	end

	subroutine queue_async_read

C++
C Functional Description:
C	Here we issue a qio to the ethernet device and setup an ast to
C	invoke the process_packet routine when we have something to read.
C
C Calling Sequence:
C
C	call queue_async_read
C
C Formal Argument(s):
C	None
C
C Implicit Inputs:
C	latwatch_data common area.
C
C Implicit Outputs:
C	None
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'LATWATCH_INC.INC/nolist'
	include '($IODEF)/nolist'

	external	lib$signal
	external	process_packet
	integer*4	sys$qiow
	external	sys$qiow

C+
C Mainline - queue_async_read
C-

	status = sys$qiow (%val(0)
	1			,%val(log_channel)
	1			,%val(io$_readvblk)
	1			,%ref(iosb)
	1			,process_packet,
	1			,%val(%loc(packet.etdata))
	1			,%val(eth_c_length),,
	1			,%val(%loc(packet.ethdr.dst)),)

	if (.not. status) call lib$signal(%val(status))

	return
	end

	subroutine read_nodelist

C++
C Functional Description:
C	Here we read the node list file and set up the internal tables so
C	we can match addresses and names.
C
C Calling Sequence:
C
C	call read_nodelist
C
C Formal Argument(s):
C	None
C
C Implicit Inputs:
C	latwatch_data common area.
C
C Implicit Outputs:
C	latwatch_data common area.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include		'LATWATCH_INC.INC/nolist'

	external	for_stop
	external	lib$put_output
	external	str_collapse
	external	str_uppercase
	integer*4	str_len
	external	str_len
	external	sys$fao

C Type declarations for parameters and PARAMETER statements

	character	fao_node_count*(*)
	character	file_error*(*)

	parameter	(fao_node_count = '!UL nodenames/addresses loaded')
	parameter	(file_error = '%LATWATCH-I-FILERR, error opening '
	1					//nodefile)

C Type declarations for variables

	integer*4	delim_loc
	integer*4	iostatus
	character	line*132
	integer*4	line_len
	integer*4	list_lun		/81/

C+
C Mainline - read_nodelist
C-

01000	format (A)

	open (unit=list_lun, file=nodefile
	1	,readonly
	1	,access='SEQUENTIAL'
	1	,form='FORMATTED'
	1	,recordtype='VARIABLE'
	1	,status='OLD'
	1	,iostat=iostatus)

	if (iostatus .ne. 0) then
		call lib$put_output (file_error)
		call for_stop
	endif !(iostatus .ne. 0) then

	node(1).addr	= 'xx-xx-xx-xx-xx-xx'
	node(1).name	= 'NoName'
	node(1).namelen	= 6

	node_count = 1

	read (list_lun, 1000, iostat=iostatus) line

	do while ((node_count .le. max_nodeaddr) .and. (iostatus .eq. 0))
		call str_collapse (line, line)
		call str_uppercase (line, line)

		if (line(1:1) .ne. '!') then
			delim_loc = index(line, '=')

			if (delim_loc .eq. 0) then
				node(node_count).addr = line(1:addr_len)
				node(node_count).name = unknown_node
			else
			node(node_count).addr = line(1:delim_loc-1)
			node(node_count).name = line(delim_loc+1:)
			endif !(delim_loc .eq. 0) then

			node(node_count).addrlen
	1				= str_len (node(node_count).addr)
			node(node_count).namelen
	1				= str_len (node(node_count).name)
			node_count = node_count + 1
		endif !(node(node_count).name(1:1) .ne. '!') then

		read (list_lun, 1000, iostat=iostatus) line
	enddo !while ((node_count .le. max_nodeaddr) .and. (iostatus .eq. 0))

	node_count = node_count - 1

	close (list_lun)

	call sys$fao (%descr(fao_node_count)
	1		,%ref(line_len)
	1		,%descr(line)
	1		,%val(node_count))

	call lib$put_output (line(1:line_len))

	return
	end

	subroutine startup_device

C++
C Functional Description:
C	This routine attempts to startup the ethernet device, set it up so
C	we can see everything then queue the first read request to it.
C
C Calling Sequence:
C
C	call startup_device
C
C Formal Argument(s):
C	None
C
C Implicit Inputs:
C	latwatch_data common area.
C
C Implicit Outputs:
C	latwatch_data common area.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'LATWATCH_INC.INC/nolist'
	include 'DBSLIB:NMADEF.INC/nolist'
	include '($IODEF)/nolist'

	external	lib$put_output
	external	lib$signal
	external	queue_async_read
	integer*4	sys$assign
	external	sys$assign
	integer*4	sys$qiow
	external	sys$qiow

C+
C Mainline - startup_device
C-

	call lib$put_output ('Watching LAT Protocol on device '
	1			//device(1:device_len))
	call lib$put_output ('From '
	1			//src_address(1:src_address_len)
	1			//' ['//src_node(1:src_node_len)
	1			//'], to '
	1			//dest_address(1:dest_address_len)
	1			//' ['//dest_node(1:dest_node_len)//']')

	status = sys$assign (%descr(device), %ref(log_channel),,)

	if (.not. status) call lib$signal (%val(status))

	param_desc.length		= e_num_params*6
	param_desc.parameters		= %loc(param_buffer)
	param_buffer(1).param_id	= nma$c_pcli_bus
	param_buffer(1).param_value	= e_max_packet_size
	param_buffer(2).param_id	= nma$c_pcli_bfn
	param_buffer(2).param_value	= e_num_rcv_buffers
	param_buffer(3).param_id	= nma$c_pcli_pad
	param_buffer(3).param_value	= nma$c_state_off
	param_buffer(4).param_id	= nma$c_pcli_pty
	param_buffer(4).param_value	= e_protocol_c
	param_buffer(5).param_id	= nma$c_pcli_prm
	param_buffer(5).param_value	= nma$c_state_on

	status = sys$qiow (%val(0)
	1			,%val(log_channel)
	1			,%val(io$_setmode .or. io$m_ctrl
	1				.or. io$m_startup)
	1			,%ref(iosb),,
	1			,,%val(%loc(param_desc)),,,,)

	if (.not. status) call lib$signal(%val(status))
	if (.not. iosb.value) call lib$signal (%val(iosb.value))

	call queue_async_read

	return
	end

	subroutine enable_controlc

C++
C Functional Description:
C	Setup a control c trap.
C
C Calling Sequence:
C
C	call enable_controlc
C
C Formal Argument(s):
C	None.
C
C Implicit Inputs:
C	None.
C
C Implicit Outputs:
C	None.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'LATWATCH_INC.INC/nolist'
	include '($IODEF)/nolist'

	external	lib$stop
	external	process_controlc
	integer*4	sys$qiow
	external	sys$qiow

C Type declarations for variables

	integer*4	qio_status

C+
C Mainline - enable_controlc
C-

	qio_status = sys$qiow (,%val(tt_channel)
	1			,%val(io$_setmode .or. io$m_ctrlcast),,,
	1			,process_controlc,
	1			,%val(3),,,)

	if (.not. qio_status) call lib$stop (%val(qio_status))

	return
	end

	subroutine process_controlc

C++
C Functional Description:
C	This is where we end up if a control c is used.  We just exit.
C
C Calling Sequence:
C
C	via an ast...
C
C Formal Argument(s):
C	None.
C
C Implicit Inputs:
C	None.
C
C Implicit Outputs:
C	None.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	external	lib$stop

C+
C Mainline - process_controlc
C-

	call lib$stop (%val('10000001'X))

	return
	end
