/*
 * Define low-level routines for bookreader file io.
 */
#ifndef BKREC_COMMON_HEADER
#include "bookreader_recdef.h"
#endif
/* 
 * Define symbol for bkf_read to signify RFA for sequential read 
 */
#define BKF_NEXT_REC (struct file_address *) 0

int bkf_open ( char *fname, char *defname, void **retctx );
int bkf_close ( void *ctx );

char *bkf_last_error ( void *ctx );		/* Text for error */
/* 
 * Note that bkf_read returns a pointer to the record.  Caller must
 * copy record if the dat will be needed after a subsequent call.  The
 * exception is the page id 0, whose record is allocated separately
 * by bkf_open().
 */
int bkf_read ( void *ctx, 		/* I/O context */
	struct file_address *rfa,	/* RMS record adress, null for next */
	bkrdr_recptr *bufaddr,		/* Address of read record */
	int *length );			/* Length of RMS record read */

int bkf_read_page ( void *ctx, 
	int id, 			/* Page number */
	int *page_length,		/* virtual length of requested page */
	bkrdr_recptr *bufaddr, 		/* First RMS record of page */
	int *length );			/* Length of RMS record */

int bkf_lookup_section ( void *vctx, int sect_id, int *part );
int bkf_lookup_first_section ( void *vctx, int sect_id, int *part, int *first );
int bkf_lookup_part_section ( void *vctx, int part_num, int *sect_id );
