/*
 * Routines for accessing indices of bookreader file.
 */
int bki_create_context ( void *bkfctx,	void **ctx );
int bki_delete_context ( void *ctx );
/*
 * If type is -1, matches any, otherwise both type and name must match.
 */
int bki_find_index ( void *ctx, char *pattern, int pat_type,
	char name[256], int *type, int *count );
int bki_find_index_end ( void *ctx );
int bki_open_index ( void *ctx, char *name );
/*
 * For read_index, hdr includes 7 shorts from ixtxt record and
 * 2 from first text subrecord (type 2/3).  Pointers returned by read_index
 * will remain valid until index is closed (only one index may be
 * open per context).
 */
int bki_read_index ( void *ctx, 
	short hdr[9], 		/* Index entry attributes + hor,ver of name */
	unsigned char attr[4],  /* Fontno, x, y, length of name */
	char name[256], 	/* Entry name */
	char **desc, 		/* Display descricption. */
	long *value );		/* Section number or special value */
int bki_close_index ( void *ctx );
