/*
 * Per-thread memory allocation routines, on thread exit all allocated
 * memory is automatically freed.
 */
int tm_initialize();		/* must be called first */
void *tm_malloc ( int size );
void tm_free ( void *ptr );
void *tm_calloc ( int size );
void *tm_realloc ( void *ptr, int new_size );
/*
 * The following special routines allow operation of the memory
 * routines to be tuned.
 */
typedef void *tm_heap_id;	/* opaque pointer */
#define TMEM_TYPE_FIRST_FIT 0		/* first-fit */
union tm_heap_attr_blk {	/* Parameter definitions for heap types */
    struct {
	int chunk_size;		/* Heap expansion size (bytes) */
	int max_alloc;		/* 0 for unbound */
    } ff;
};
typedef union tm_heap_attr_blk *tm_heap_attr;

tm_heap_id tm_create_heap ( int type, tm_heap_attr );
int tm_destroy_heap ( tm_heap_id );	/* returns current reference count */
/*
 * Change_heap, affects all subsequent calls to tm_malloc, etc.  Return
 * value is heap_id of current heap (null for default heap).
 */
tm_heap_id tm_change_heap ( tm_heap_id );
